/*  GUBI - Gtk+ User Interface Builder
 *  Copyright (C) 1997	Tim Janik	<timj@psynet.net>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
#include	"rcs.h"
RCS_ID("$Id: auxlist.c,v 1.5 1997/08/18 03:24:10 timj Exp $")


#define		__auxlist_c__

#include	"auxlist.h"
#include	"gsi.h"
#include	"gtkext.h"
#include	"editor.h"
#include	"widgets.h"
#include	"windows.h"
#include	"widdata.h"
#include	"defines.h"
#include	"config.h"



/* --- prototypes --- */
static	void	SigH_AuxList_List_selection_changed	(GtkList	*widget,
							 gpointer	func_data);
static	void	SigH_AuxList_Add_clicked	(GtkWidget	*widget,
						 gpointer	func_data);
static	void	SigH_AuxList_Delete_clicked	(GtkWidget	*widget,
						 gpointer	func_data);
static	void	SigH_AuxList_Edit_clicked	(GtkWidget	*widget,
						 gpointer	func_data);
static	void	SigH_AuxList_Dump_clicked	(GtkWidget	*widget,
						 gpointer	func_data);
static	void	SigH_Delete_widget_real		(GtkWidget	*widget,
						 gpointer	 func_data);



/* --- variables --- */
static	gboolean	ignore_selection_events=FALSE;



/* --- functions --- */
void
AuxList_create	(GtkObject	*parent_object)
{
	
	
	/* only raise the window if it already exists
	*/
	if (AuxList_Window->widget) {
		if (AuxList_Window->widget->window)
			_gtk_widget_raise(AuxList_Window->widget);
		return;
	}
	
	
	/* initialize widgets
	*/
	GB_wCAST(label, AuxList_Label)->label="huhu";
		
		
	/* build window
	*/
	gb_window_build(GB_wCAST(window, AuxList_Window));
		
		
	/* the window should be destroyed
	 * if it's parent gets destroyed.
	 * OTOH, this "destroy" signal handler must be
	 * removed from parent if the window gets destroyed.
	*/
	if (parent_object) {
		object_connect_disc_handler (
			GTK_OBJECT(AuxList_Button_Close->widget),
			"destroy",
			parent_object,
			gtk_signal_connect_object (
				parent_object,
				"destroy",
				GTK_SIGNAL_FUNC(gtk_widget_destroy),
				GTK_OBJECT(AuxList_Window->widget)
			)
		);
	}
	
	
	/* track selection_changed on single lists
	 * and connect SigH to buttons
	*/
	gtk_signal_connect(GTK_OBJECT(AuxList_List->widget),
			   "selection_changed",
			   GTK_SIGNAL_FUNC(SigH_AuxList_List_selection_changed),
			   NULL);
	gtk_signal_connect(GTK_OBJECT(AuxList_Button_New_label->widget),
			   "clicked",
			   GTK_SIGNAL_FUNC(SigH_AuxList_Add_clicked),
			   NULL);
	gtk_signal_connect(GTK_OBJECT(AuxList_Button_New_adjustment->widget),
			   "clicked",
			   GTK_SIGNAL_FUNC(SigH_AuxList_Add_clicked),
			   NULL);
	gtk_signal_connect(GTK_OBJECT(AuxList_Button_Delete->widget),
			   "clicked",
			   GTK_SIGNAL_FUNC(SigH_AuxList_Delete_clicked),
			   NULL);
	gtk_signal_connect(GTK_OBJECT(AuxList_Button_Edit->widget),
			   "clicked",
			   GTK_SIGNAL_FUNC(SigH_AuxList_Edit_clicked),
			   NULL);
	gtk_signal_connect(GTK_OBJECT(AuxList_Button_Dump->widget),
			   "clicked",
			   GTK_SIGNAL_FUNC(SigH_AuxList_Dump_clicked),
			   NULL);
	gtk_signal_connect_object(GTK_OBJECT(AuxList_Button_Close->widget),
			  "clicked",
			  GTK_SIGNAL_FUNC(gtk_widget_destroy),
			  GTK_OBJECT(AuxList_Window->widget));

	
	/* show window
	*/
	gtk_widget_show(AuxList_Window->widget);

	AuxList_refresh();
}


void
AuxList_refresh		(void)
{
	register GtkWidget	*List;
	register GtkWidget	*item;
	register GList		*list;
	
	if (!AuxList_Window->widget)
		return;
	
	List=AuxList_List->widget;
	
	ignore_selection_events=TRUE;

	gtk_list_clear_items(GTK_LIST(List), 0, -1);
	
	list=Gubi_auxillary_list;
	while (list) {
		g_assert(GB_IS_WIDDAT(GB_wCAST(base, list->data)));
		item=widget_data_item_new(list->data,
					  0,
					  GTK_LIST(List),
					  -1);
	}
	
	ignore_selection_events=FALSE;
}


void
SigH_AuxList_List_selection_changed	(GtkList	*gtklist,
					 gpointer	func_data)
{
	register gb_wdat_base_S		*WidDat;
	
	
	/* we just return if a list refresh is done
	*/
	if (ignore_selection_events)
		return;
	
	
	/* we get the widget from the current item
	*/
	if (gtklist->selection) {
		WidDat=gtk_object_get_user_data(gtklist->selection->data);
		g_assert(GB_IS_WIDDAT(WidDat));
	} else
		WidDat=NULL;
}


void
SigH_AuxList_Add_clicked	(GtkWidget	*widget,
				 gpointer	func_data)
{
	printf("%s: i'm invoked, FIXME!\n",
		FUNCNAME);
}


void
SigH_AuxList_Dump_clicked	(GtkWidget	*widget,
				 gpointer	func_data)
{
	printf("%s: i'm invoked, FIXME!\n",
		FUNCNAME);
}


void
SigH_AuxList_Delete_clicked	(GtkWidget	*widget,
				 gpointer	func_data)
{
	printf("%s: i'm invoked, FIXME!\n",
		FUNCNAME);
}


void
SigH_AuxList_Edit_clicked	(GtkWidget	*widget,
				 gpointer	func_data)
{
	register GtkList	*List;
	
	List=GTK_LIST(AuxList_List->widget);
	if (List->selection) {
		register gb_wdat_base_S	*WidDat;
		
		WidDat=List->selection->data;
		
		g_assert(GB_IS_WIDDAT(WidDat));
		
		Editor_create(WidDat);
	}
}


void
SigH_Delete_widget_real	(GtkWidget	*widget,
			 gpointer	func_data)
{
	printf("%s: i'm invoked, FIXME!\n",
		FUNCNAME);
}
