/*  GUBI - Gtk+ User Interface Builder
 *  Copyright (C) 1997  Tim Janik
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* widdata.h: various utility functions
 * RCS_ID("$Id: widdata.h,v 1.7 1997/05/20 21:17:50 tim Exp $")
*/


#ifndef		__widdata_h__
#define		__widdata_h__

#ifdef		__cplusplus
  extern	"C"	{
#endif

#include	"config.h"
#include	"gbconf.h"
#include	"gtkext.h"
#include	"structures.h"
#include	"wdtree.h"



/* --- typedefs --- */
typedef	struct	gubi_data_S	gubi_data_S;
typedef	enum
{
	WID_CAT_NORMAL		= 0,
	WID_CAT_GENERIC		= 1 <<  0
				/* this indicates a generic symbol name
				*/,
	WID_CAT_AUXILLARY	= 1 <<  1
				/* is widget in auxillary pool ?
				*/
} wid_category_options_E;


/* --- defines --- */
#define	UPDATE_CHILD_COUNT(widget_data)				\
	GUBI_DATA(widget_data)->child_count=(			\
		widget_data_base_child_count(widget_data) +	\
		g_list_length(GUBI_DATA(widget_data)->children)	)

#define	HAS_MAX_CHILD_COUNT(widget_data)			\
	(! (GUBI_DATA(widget_data)->child_count < 		\
	    GUBI_DATA(widget_data)->max_child_count) )



/* --- structures --- */


/* structure piggy back on gb_wdat_base_S.clone
*/
struct	gubi_data_S {
	gb_struct_type_E	type;
	wid_category_options_E	category;
	gb_wdat_base_S		*widget_data
				/* back link for
				 * gtk_object_get_user_data()
				*/;
	gchar			*symbol_name
				/* MALLOC
				*/;
	tree_S			*tree;
	GList			*children;
	guint			max_child_count
				/* number of children that can be added
				 * to this widget.
				 * (0, 1 or MAX_CHILDREN)
				*/;
	guint			child_count
				/* current number of childs
				*/;
	GtkWidget		*editor;
	GtkWidget		*browser;
	GList			*item_refs;
	GList			*link_refs;
};



/* --- global variables --- */
/* doubly linked list of auxillary widget data structures
*/
extern  GList           *Gubi_auxillary_list;



/* --- prototypes --- */


/* the tree_widget_data_new() function allocates and initializes
 * the space for a new gb_wdat_*_S. the initialization is done
 * according to the widget type specified by widget_enum.
*/
gb_wdat_base_S	*widget_data_new	(gb_struct_type_E	struct_type
					 /* if this is a numeric value that
					  * is not declared for
					  * gb_widget_type_E,
					  * g_error() will be invoked.
					 */,
					 const gchar		*widget_name
					 /* if this is a NULL pointer
					  * or if strlen(widget_name)==0,
					  * a name will be generated.
					 */,
					 gboolean		auxillary);


/* the widget_data_delete_R() function free()s WidDat and
 * it's sub structures. this also descends a possible child
 * tree of WidDat.
*/
void    widget_data_delete_R		(gb_wdat_base_S	*WidDat);


/* the widget_data_last_child() will return a pointer to the
 * last child in WidDat's widget tree.
 * the return value might be WidDat itself.
*/
gb_wdat_base_S*
	widget_data_last_child		(gb_wdat_base_S	*WidDat);


/* the widget_data_parent_level() functions returns the
 * parentation level of a widget data structure within
 * it's tree.
*/
guint	widget_data_parent_level	(gb_wdat_base_S	*WidDat);


/* the widget_data_item_new() function will create a GtkListItem
 * for WidDat.
 * the GtkListItem will be inserted into the children list of
 * List at the specified position.
 * indent_level indicates prefixing spaces for the item's label.
*/
GtkWidget*
	widget_data_item_new		(gb_wdat_base_S	*WidDat,
					 guint		indent_level,
					 GtkList	*List,
					 gint		position);


/* the widget_data_items_update() function updates the symbol
 * name of WidDat in all items referring to it, by preserving
 * the indentation level of each item.
*/
void
widget_data_items_update		(gb_wdat_base_S	*WidDat);


/* the widget_data_item_destroy() function will destroy the
 * specified item of a widget.
*/
void	widget_data_item_destroy	(gb_wdat_base_S	*WidDat,
					 GtkWidget	*item);


/* the widget_data_symbol_name_get() function returns a pointer to an
 * allocated char buffer, containing the symbol name of a gb_wdat_*_S.
 * the buffer must not be free()d and it's value might change because of
 * calls to other widget related functions!
 * the existence of *WidDat is asserted!
*/
const	gchar*
	widget_data_symbol_name_get	(gb_wdat_base_S		*WidDat);


/* the widget_data_symbol_name_set() function sets the symbol_name of
 * WidDat. if this name already exists, a new one will be generated.
 * the new symbol_name is also registered in the global symbol name
 * registery.
 * therefore the widget data must not be in the clipboard.
 * the existence of *WidDat is asserted!
*/
void	widget_data_symbol_name_set	(gb_wdat_base_S		*WidDat,
					 const gchar		*widget_name);


/* the widget_data_lookup() function looks up the specified symbol_name
 * in the global symbol name registery.
 * the existence of *symbol_name is asserted!
 * returns:
 * this returns a pointer to a gb_wdat_base_S or NULL if the look up failed.
*/
gb_wdat_base_S*
	widget_data_lookup		(const gchar		 *symbol_name);


/* the widget_data_symbol_name_register() function registers WidDat
 * in the global symbol name registery.
 * the existence of *WidDat is asserted!
*/
void	widget_data_symbol_name_register (gb_wdat_base_S	*WidDat);


/* the widget_data_symbol_name_unregister() function unregisters WidDat
 * in the global symbol name registery.
 * the existence of *WidDat is asserted!
*/
void	widget_data_symbol_name_unregister (gb_wdat_base_S	*WidDat);


/* the widget_data_handler_add() function apends the specified handler
 * to the handler list of widget_data.
 * the existence of *WidDat is asserted!
 * returns:
 * index of the newly appended handler in handler stack.
*/
guint	widget_data_handler_add		(gb_wdat_base_S		*WidDat,
					 const guint16		connect_options,
					 const gchar		*func_name,
					 const gchar		*signal_name,
					 const gchar		*data_name);


/* the widget_data_linkage_new() functions initializes the linkage field
 * of a gb_wdat_base_S appropriate to the parent widget type of WidDat.
 * the existence of *WidDat is asserted!
*/
void	widget_data_linkage_new		(gb_wdat_base_S		*WidDat);


/* the widget_data_linkage_check() function checks all fields of
 * WidDat->linkage for validity.
 * the existence of *WidDat is asserted!
 * returns:
 * the return value indicates wether all fields of the linkage have
 * default values.
*/
gboolean
	widget_data_linkage_check	(gb_wdat_base_S		*WidDat);


/* the widget_data_children_linkage_check() function corrects the
 * linkage information of all child widgets.
 * this function returns wether some children might have changed or not.
*/
gboolean
	widget_data_children_linkage_check	(gb_wdat_base_S	*WidDat);






#ifdef		__cplusplus
  }
#endif
#endif		/*__widdata_h__*/
