/*  GUBI - Gtk+ User Interface Builder
 *  Copyright (C) 1997  Tim Janik
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
#include	"RCS.h"
RCS_ID("$Id: special_fields.c,v 1.5 1997/05/14 15:46:26 tim Exp $")


#define		__windows_c__

#include	"special_fields.h"
#include	"widdata.h"
#include	"windows.h"
#include	"defines.h"



/* --- prototypes --- */



/* --- functions --- */
GtkWidget*
RadioGroup_List		(gb_wdat_base_S		*WidDat,
			 GtkObject		*parent_object,
			 gpointer		nullify_pointer,
			 GtkSignalFunc		signal_func,
			 gpointer		func_data,
			 gb_wdat_base_S		**widget_data_pointer)
{
	register gb_wdat_base_S		*ParDat;
	register GList			*w_list;
	register GList			*list;
	register gint			pos;
	
	g_assert(GB_IS_WIDDAT(WidDat));
	g_assert((ParDat=WidDat->parent));
	
	w_list=NULL;
	list=GUBI_DATA(WidDat)->tree->widget_data_list;
	while (list) {
		register gb_wdat_base_S	*ChildDat;
		
		g_assert((ChildDat=list->data));
		
		if (ChildDat==WidDat)
			break;
		
		if (ChildDat->type==WidDat->type)
			w_list=g_list_append(w_list, ChildDat);
		
		list=list->next;
	}
	
	if (!w_list)
		return NULL;
	
	list=NULL;
	pos=0;
	while (w_list) {
		GtkWidget	*item;
		
		item=widget_data_item_new(w_list->data, 0, NULL, 0);
		
		list=g_list_append(list, item);
		
		if (w_list->data==*widget_data_pointer)
			pos=g_list_length(list);
		
		w_list=g_list_remove(w_list, w_list->data);
	}
	
	return	SimpleList_create(parent_object,
				  nullify_pointer,
				  signal_func,
				  func_data,
				  FALSE,
				  list,
				  pos-1,
				  (gpointer*)widget_data_pointer,
				  "Select a Radio Widget:");
}
