/*  GUBI - Gtk+ User Interface Builder
 *  Copyright (C) 1997  Tim Janik
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
#include	"RCS.h"
RCS_ID("$Id: gtkext.c,v 1.4 1997/05/14 16:56:16 tim Exp $")


#define		__gtkext_c__

#include	"gtkext.h"
#include	<gdkprivate.h>



/* --- prototypes --- */



/* --- functions --- */
void
_gtk_widget_raise	(GtkWidget	*widget)
{
	g_return_if_fail(widget!=NULL);
	g_return_if_fail(GTK_IS_WINDOW(widget));
	
	if (!widget->parent && GTK_WIDGET_DRAWABLE(widget))
		gdk_window_raise(widget->window);
}


void
_gtk_widget_set_sensitivity	(GtkWidget	*widget)
{
	gtk_widget_set_sensitive(widget, TRUE);
}


void
_gtk_widget_unset_sensitivity	(GtkWidget	*widget)
{
	gtk_widget_set_sensitive(widget, FALSE);
}


void
_gtk_object_describe_heritage	(GtkObject	*object)
{
	gtk_type_describe_heritage(GTK_OBJECT_TYPE(object));
}


void
_gtk_adjustment_set_value	(GtkAdjustment	*adjustment,
				 gfloat		value)
{
	g_return_if_fail(adjustment!=NULL);
	g_return_if_fail(GTK_IS_ADJUSTMENT(adjustment));
	
	adjustment->value=CLAMP(value, adjustment->lower, adjustment->upper);
	
	gtk_signal_emit_by_name(GTK_OBJECT(adjustment), "value_changed");
}


void
_gdk_window_clear_expose	(GdkWindow	*window)
{
	GdkWindowPrivate	*private;
	
	g_return_if_fail(window!=NULL);
	
	private=(GdkWindowPrivate*)window;
	
	XClearArea(private->xdisplay,
		   private->xwindow,
		   0, 0, 0, 0,
		   True);
}
