/*  GUBI - Gtk+ User Interface Builder
 *  Copyright (C) 1997  Tim Janik
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
%{
#include	"RCS.h"
RCS_ID("$Id: gbclex.l,v 1.4 1997/05/09 16:29:10 tim Exp $")

#define		__gbclex_l__


#include	"defines.h"
#include	"gbcio.h"


/* some versions of stdio.h
 * skip this declaration if __STRICT_ANSI__
 * is defined (e.g. "gcc -ansi" does this)
*/
extern	int	fileno(FILE*);


/* since input is never interactive, we can define
 * YY_INPUT for fread() only
*/
#define	YY_INPUT(buf,result,max_size) \
	if (((result=fread(buf, 1, (unsigned)max_size, yyin))==0) && ferror(yyin)) \
		/*YY_FATAL_ERROR*/ g_error("input in flex scanner failed");


/* this isn't really needed
*/
#define ECHO	(void)fwrite(yytext, (unsigned)yyleng, 1, yyout)


%}



%option	noyywrap
%array

DIGIT	[0-9]
HEX_D	[0-9a-fA-F]
CHAR	[a-zA-Z_]
CHAR_D	[a-zA-Z_0-9]

%x	lvlComment
%x	lvlString


%%


		gchar	yybuffer[4096]="";
		gchar	*yybuffer_p=0;
	extern	guint	yyline; /* from gbcio.c */
	extern	token_U	yylval; /* from gbcio.c */
	


	/* --- rules --- */


			/* eat up comments
			 * but count newlines
			*/
"/*"			{ BEGIN(lvlComment); }
<lvlComment>{
	[^*\n]*		/* eat anything that's not an '*' */
	"*"+[^*/\n]*	/* eat up '*'s not followed by '/'s */
	\n		{ yyline++; }
	"*"+"/"		{ BEGIN(INITIAL); }
}


			/* read string (like in c-source)
			*/
\"			{ yybuffer_p=yybuffer; BEGIN(lvlString); }
<lvlString>{
	\"		{
			  *yybuffer_p='\0';
			  yylval.String=g_strdup(yybuffer);
			  BEGIN(INITIAL); return TOKEN_STRING;
			}
	\n		{
			  g_warning("parse error: unterminated string const");
			  yyline++;
			  unput('"');
			}
	\\[0-7]{1,3}	{
			  /* octal */ int result;
			  (void) sscanf(yytext+1, "%o", &result);
			  if (result>0xff)
			  	g_warning("parse error: %s", "octal value out of bounds");
			  *yybuffer_p++=result;
			}
	\\[0-9]+	{ }
	\\n		{ *yybuffer_p++='\n'; }
	\\t		{ *yybuffer_p++='\t'; }
	\\r		{ *yybuffer_p++='\r'; }
	\\b		{ *yybuffer_p++='\b'; }
	\\f		{ *yybuffer_p++='\f'; }
	\\(.|\n)	{ *yybuffer_p++=yytext[1]; }
	[^\\\n\"]+	{
			  char *yptr=yytext;
			  while (*yptr) *yybuffer_p++=*yptr++;
			}
}


			/* count newlines
			*/
\n			{ yyline++; }


			/* eat up whitespace
			*/
[ \t\f\v\b\r]		{ /* nothing */ }


			/* number scanning
			*/
-?{DIGIT}+		{ yylval.Long=strtol(yytext, (char **)NULL, 10); return TOKEN_LONG;	}
0[xX]{HEX_D}+		{ yylval.Long=strtol(yytext, (char**)NULL, 16);  return TOKEN_LONG;	}
-?{DIGIT}+"."{DIGIT}*	{ yylval.Double=strtod(yytext, (char **)NULL); return TOKEN_DOUBLE;	}
-?{DIGIT}*"."{DIGIT}+	{ yylval.Double=strtod(yytext, (char **)NULL); return TOKEN_DOUBLE;	}


			/* NULL value
			*/
NULL			{ return TOKEN_NULL; }

			
			/* token to introduce handler
			 * handler specification
			*/
HANDLER_spec		{ return TOKEN_HANDLER;			}
HANDLER_connect_options	{ return TOKEN_HANDLER_connect_options;	}
HANDLER_handler_func	{ return TOKEN_HANDLER_handler_func;	}
HANDLER_signal_name	{ return TOKEN_HANDLER_signal_name;	}
HANDLER_data		{ return TOKEN_HANDLER_data;		}


			/* structure key words
			*/
GB_WIDGET_[A-Z_a-z]+	{ yylval.String=g_strdup(yytext);	return TOKEN_WIDGET;	}
GB_[A-Z_a-z]+		{ yylval.String=g_strdup(yytext);	return TOKEN_STRUCT;	}


			/* widget data fields
			*/
[A-Z_a-z]+		{ yylval.String=g_strdup(yytext);	return TOKEN_FIELD;	}


			/* miscellaneous
			*/
"{"			{ return yytext[0]; }
"}"			{ return yytext[0]; }
";"			{ return yytext[0]; }
"="			{ return yytext[0]; }
"("			{ return yytext[0]; }
")"			{ return yytext[0]; }


			/* default: scan 1 character
			 * FIXME: this isn't really needed
			*/
.			{ return yytext[0]; }


%%
