/*  GUBI - Gtk+ User Interface Builder
 *  Copyright (C) 1997  Tim Janik
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* gbcio.h: IO functions for Gubi's config file
 * RCS_ID("$Id: gbcio.h,v 1.6 1997/05/20 21:17:50 tim Exp $")
*/


#ifndef		__gbcio_h__
#define		__gbcio_h__

#ifdef		__cplusplus
  extern "C"	{
#endif

#include	<stdio.h>
#include	"gbconf.h"
#include	"wdtree.h"



/* --- typedefs --- */
typedef	union	{		/* token types for config lexer */
	double			Double;		/* scanned number */
	long			Long;		/* scanned number */
	gchar			*String;	/* scanned string (malloced) */
}	token_U;



/* --- prototypes for gbcio.c --- */


/* the Save_window() function dumps the contents of *WinDat and any
 * existing children to f_out, using filename for error messages.
 * the existence of *f_out, *filename and *WinDat is asserted!
*/
void
Save_window	(FILE			*f_out
		 /* *valid* pointer to an opened output stream.
		 */,
		 gchar			*filename
		 /* name of the file,
		  * the opened stream refers to.
		 */,
		 gb_wdat_window_S	*WinDat,
		 gboolean		skip_defaults);


/* the Read_trees() functions builds new widget trees,
 * by parsing f_in. filename is needed for error messages.
 * the existence of *f_in and *filename is asserted!
 * returns:
 * this returns the number of errors that have occoured.
*/
guint
Read_trees	(FILE			*f_in,
		 gchar			*filename,
		 guint			max_errors);



/* --- prototypes for gb_lex.l --- */


/* the yylex() function is produced by flex(1) from gbclex.l.
 * returns:
 * this returns token values, see gbclex.l and flex(1)
 * for more information on tokenization.
*/
int
yylex		(void);
void
yyrestart	(FILE	*input_file);






#ifdef		__cplusplus
  }
#endif

#endif		/*__gbcio_h__*/
