/*  GUBI - Gtk+ User Interface Builder
 *  Copyright (C) 1997  Tim Janik
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* config.h: configuration informations
 * RCS_ID("$Id: config.h,v 1.8 1997/05/14 15:46:26 tim Exp $")
*/


#ifndef		__config_h__
#define		__config_h__

#ifdef		__cplusplus
  extern	"C"	{
#endif



/* compiler specific stuff
*/
#ifdef	__GNUC__
	#define	FUNCNAME	(__PRETTY_FUNCTION__"()")
#else	/*__GNUC__*/
	#define	FUNCNAME	("")
#endif	/*__GNUC__*/


/* limits
*/
/* #define		MAX_SYMBOL_SIZE		(1024) */
#define		MAX_MACRO_LEN		(64)
#define		MAX_CHILDREN		(1024)
#define		MAX_BORDER_WIDTH	(1024)
#define		MAX_POS			(32768)
#define		MAX_SIZE		(32768)
#define		MAX_DIGITS		(32)
#define		MAX_PADDING		(1024)
#define		MAX_SPACING		(1024)
#define		MIN_ALIGN		(0)
#define		MAX_ALIGN		(+1)
#define		MAX_COLS		(1024)
#define		MAX_ROWS		(MAX_COLS)
#define		MAX_ATTACH		(MAX(MAX_COLS,MAX_ROWS))
#define		MIN_RULER		(-65536.0)
#define		MAX_RULER		(65536.0)

/* defaults
*/
#define		DFL_TARGET_DIR		"./test_src"
#define		DFL_BUFFER_SIZE		(1024)


/* miscellaneous
*/
#define		GBC_INDENT_STRING	"  "
#define		INDENT_CHAR		' '
#define		MACRO_IDENT		'@'
#define		SHOW_CURRENT_DELAY	(333)


/* entry and option menu length for
 * widget editor
*/
#define		FIELD_LENGTH_INT	(50)
#define		FIELD_LENGTH_FLOAT	(80)
#define		FIELD_LENGTH_STRING	(140)
#define		FIELD_LENGTH_POINTER	(FIELD_LENGTH_STRING)
#define		FIELD_LENGTH_ENUM	(140)


/* currently hard coded stuff FIXME: hack
*/
#define		DIR_TEMPLATE		"./templates"


/* post and prefixes for auxillary structures
*/
#define		WIDGET_DATA_NAME_PREFIX		"_"
#define		WIDGET_DATA_NAME_POSTFIX	""
#define		HANDLER_NAME_PREFIX		"_"
#define		HANDLER_NAME_POSTFIX		"_handler"
#define		LINKAGE_NAME_PREFIX		"_"
#define		LINKAGE_NAME_POSTFIX		"_linkage"





#ifdef		__cplusplus
  }
#endif
#endif		/*__config_h__*/
