/* GnomeForestTest - Gnome Sprite Engine Test
 * Copyright (C) 1999 Tim Janik
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#include "gnomeforest.h"

static void
setup_animation_a (GnomeForest *forest,
                   guint        sprite_id)
{
  gnome_forest_animate_sprite (forest, sprite_id,
			       0, 1,
			       GNOME_SPRITE_MOVE_TO, 0, 0,
			       GNOME_SPRITE_ROTATE_TO, 0.0,
			       GNOME_SPRITE_SHEAR_TO, 0.0,
			       GNOME_SPRITE_RESIZE_TO, -1, -1,
			       GNOME_SPRITE_DONE);
  gnome_forest_animate_sprite (forest, sprite_id, 250, 1, GNOME_SPRITE_DONE);
  gnome_forest_animate_sprite (forest, sprite_id,
			       45, 100,
			       GNOME_SPRITE_MOVE_BY, +200, +200,
			       GNOME_SPRITE_RESIZE_BY, +200, +200,
			       GNOME_SPRITE_ROTATE_BY, 1.5 * 360.0,
			       GNOME_SPRITE_DONE);
  gnome_forest_animate_sprite (forest, sprite_id, 250, 1, GNOME_SPRITE_DONE);
  gnome_forest_animate_sprite (forest, sprite_id,
			       45, 50,
			       GNOME_SPRITE_MOVE_BY, +50, +50,
			       GNOME_SPRITE_RESIZE_BY, -100, -100,
			       GNOME_SPRITE_SHEAR_BY, -45.0,
			       GNOME_SPRITE_ROTATE_BY, 0.5 * 360.0,
			       GNOME_SPRITE_DONE);
  gnome_forest_animate_sprite (forest, sprite_id,
			       45, 50,
			       GNOME_SPRITE_SHEAR_BY, +90.0,
			       GNOME_SPRITE_DONE);
  gnome_forest_animate_sprite (forest, sprite_id,
			       45, 50,
			       GNOME_SPRITE_MOVE_BY, -50, -50,
			       GNOME_SPRITE_RESIZE_BY, +100, +100,
			       GNOME_SPRITE_SHEAR_BY, -45.0,
			       GNOME_SPRITE_DONE);
  gnome_forest_animate_sprite (forest, sprite_id, 250, 1, GNOME_SPRITE_DONE);
  gnome_forest_animate_sprite (forest, sprite_id,
			       45, 100,
			       GNOME_SPRITE_MOVE_BY, -200, -200,
			       GNOME_SPRITE_RESIZE_BY, -200, -200,
			       GNOME_SPRITE_ROTATE_BY, -4.0 * 360.0,
			       GNOME_SPRITE_DONE);
  gnome_forest_stop_sprite_animations (forest, sprite_id);
}

static void
setup_animation_loop (GnomeForest *forest,
		      guint        sprite_id)
{
  gnome_forest_kill_sprite_animations (forest, sprite_id);
  gnome_forest_animate_sprite (forest, sprite_id,
			       0, 1,
			       GNOME_SPRITE_MOVE_TO, 50, 50,
			       GNOME_SPRITE_ROTATE_TO, 0.0,
			       GNOME_SPRITE_SHEAR_TO, 0.0,
			       GNOME_SPRITE_LOOP_ALWAYS,
			       GNOME_SPRITE_DONE);
  gnome_forest_animate_sprite (forest, sprite_id,
			       0, 100,
			       GNOME_SPRITE_MOVE_BY, +100, 0,
			       GNOME_SPRITE_RESIZE_BY, -60, -60,
			       GNOME_SPRITE_DONE);
  gnome_forest_animate_sprite (forest, sprite_id,
			       0, 100,
			       GNOME_SPRITE_MOVE_BY, +100, 0,
			       GNOME_SPRITE_RESIZE_BY, +60, +60,
			       GNOME_SPRITE_DONE);
  gnome_forest_animate_sprite (forest, sprite_id,
			       0, 50,
			       GNOME_SPRITE_ROTATE_BY, +360.0,
			       GNOME_SPRITE_DONE);
  gnome_forest_animate_sprite (forest, sprite_id,
			       0, 100,
			       GNOME_SPRITE_MOVE_BY, -50, +150,
			       GNOME_SPRITE_ROTATE_BY, +360.0,
			       GNOME_SPRITE_DONE);
  gnome_forest_animate_sprite (forest, sprite_id,
			       0, 60,
			       GNOME_SPRITE_RESIZE_BY, -63, 0,
			       GNOME_SPRITE_DONE);
  gnome_forest_animate_sprite (forest, sprite_id,
			       0, 60,
			       GNOME_SPRITE_RESIZE_BY, +63, 0,
			       GNOME_SPRITE_DONE);
  gnome_forest_animate_sprite (forest, sprite_id,
			       20, 50,
			       GNOME_SPRITE_ROTATE_BY, 1.0 * +360.0,
			       GNOME_SPRITE_MOVE_TO, 50, 50,
			       GNOME_SPRITE_DONE);
  gnome_forest_animate_sprite (forest, sprite_id,
			       10, 80,
			       GNOME_SPRITE_ROTATE_BY, +0.3 * +360.0,
			       GNOME_SPRITE_SHEAR_BY, +65.0,
			       GNOME_SPRITE_DONE);
  gnome_forest_animate_sprite (forest, sprite_id,
			       20, 30,
			       GNOME_SPRITE_ROTATE_BY, -0.6 * +360.0,
			       GNOME_SPRITE_SHEAR_BY, -2.0 * +65.0,
                               GNOME_SPRITE_DONE);       
  gnome_forest_animate_sprite (forest, sprite_id,
			       10, 50,
			       GNOME_SPRITE_ROTATE_BY, +0.6 * +360.0,
			       GNOME_SPRITE_SHEAR_BY, +2.0 * +65.0,
                               GNOME_SPRITE_DONE);       
  gnome_forest_animate_sprite (forest, sprite_id,
			       20, 30,
			       GNOME_SPRITE_ROTATE_BY, -0.6 * +360.0,
			       GNOME_SPRITE_SHEAR_BY, -2.0 * +65.0,
                               GNOME_SPRITE_DONE);       
  gnome_forest_animate_sprite (forest, sprite_id,
			       10, 80,
			       GNOME_SPRITE_ROTATE_BY, +0.3 * +360.0,
			       GNOME_SPRITE_SHEAR_BY, +65.0,
			       GNOME_SPRITE_DONE);
}

static void
animate_sprite1 (GnomeForest *forest)
{
  gnome_forest_restart_sprite_animations (forest, 1);
}

static void
toggle_sprite2 (GtkWidget   *toggle,
		GnomeForest *forest)
{
  (GTK_TOGGLE_BUTTON (toggle)->active ?
   gnome_forest_show_sprite :
   gnome_forest_hide_sprite)
    (forest, 2);
}
static void
toggle_sprite3 (GtkWidget   *toggle,
		GnomeForest *forest)
{
  (GTK_TOGGLE_BUTTON (toggle)->active ?
   gnome_forest_show_sprite :
   gnome_forest_hide_sprite)
    (forest, 3);
}

static void
toggle_shade_svps (GtkWidget   *toggle,
		   GnomeForest *forest)
{
  forest->shade_svps = GTK_TOGGLE_BUTTON (toggle)->active;
  gnome_forest_rerender (forest);
}
static void
toggle_show_utas (GtkWidget   *toggle,
		  GnomeForest *forest)
{
  forest->show_utas = GTK_TOGGLE_BUTTON (toggle)->active;
  if (!forest->show_utas)
    gtk_widget_queue_draw (GTK_WIDGET (forest));
}
static void
toggle_auto_resize (GtkWidget   *toggle,
		    GnomeForest *forest)
{
  forest->auto_resize = GTK_TOGGLE_BUTTON (toggle)->active;
  gtk_widget_set_usize (GTK_WIDGET (forest),
			forest->auto_resize ? -1 : 400,
			forest->auto_resize ? -1 : 400);
}
static void
toggle_disable_cd (GtkWidget   *toggle,
		   GnomeForest *forest)
{
  forest->disable_cd = GTK_TOGGLE_BUTTON (toggle)->active;
}
static void
toggle_debug_cd (GtkWidget   *toggle,
		 GnomeForest *forest)
{
  forest->debug_cd = GTK_TOGGLE_BUTTON (toggle)->active;
  gtk_widget_queue_draw (GTK_WIDGET (forest));
}

int
main (int   argc,
      char *argv[])
{
  GtkWidget *button, *vbox, *window;
  GtkWidget *forest;
#include "icons/ball.c"

  gtk_init (&argc, &argv);
  gdk_rgb_init ();
  // gnome_init ("ForestTest", "Alpha", argc, argv);

  vbox = gtk_widget_new (GTK_TYPE_VBOX,
			 "visible", TRUE,
			 NULL);
  
  forest = gtk_widget_new (GNOME_TYPE_FOREST,
			   "visible", TRUE,
			   NULL);
  gnome_forest_put_sprite (GNOME_FOREST (forest),
			   1,
			   (gimp_image.bytes_per_pixel > 3
			    ? art_pixbuf_new_const_rgba
			    : art_pixbuf_new_const_rgb) (gimp_image.pixel_data,
							 gimp_image.width,
							 gimp_image.height,
							 gimp_image.width *
							 gimp_image.bytes_per_pixel));
  setup_animation_a (GNOME_FOREST (forest), 1);

  {
#include "icons/speaker.c"
    gnome_forest_put_sprite (GNOME_FOREST (forest),
			     2,
			     (gimp_image.bytes_per_pixel > 3
			      ? art_pixbuf_new_const_rgba
			      : art_pixbuf_new_const_rgb) (gimp_image.pixel_data,
							   gimp_image.width,
							   gimp_image.height,
							   gimp_image.width *
							   gimp_image.bytes_per_pixel));
    setup_animation_loop (GNOME_FOREST (forest), 2);
  }
  {
#include "icons/test.c"
    gnome_forest_put_sprite (GNOME_FOREST (forest),
			     3,
			     (gimp_image.bytes_per_pixel > 3
			      ? art_pixbuf_new_const_rgba
			      : art_pixbuf_new_const_rgb) (gimp_image.pixel_data,
							   gimp_image.width,
							   gimp_image.height,
							   gimp_image.width *
							   gimp_image.bytes_per_pixel));
    setup_animation_loop (GNOME_FOREST (forest), 3);
  }
  
  gtk_widget_new (GTK_TYPE_BUTTON,
		  "visible", TRUE,
		  "parent", vbox,
		  "child", forest,
		  "object_signal::clicked", animate_sprite1, forest,
		  NULL);

  button = gtk_widget_new (GTK_TYPE_TOGGLE_BUTTON,
			   "visible", TRUE,
			   "active", TRUE,
			   "label", "toggle sprite 2",
			   "signal::clicked", toggle_sprite2, forest,
			   NULL);
  gtk_box_pack_start (GTK_BOX (vbox), button, FALSE, TRUE, 5);
  toggle_sprite2 (button, GNOME_FOREST (forest));

  button = gtk_widget_new (GTK_TYPE_TOGGLE_BUTTON,
			   "visible", TRUE,
			   "active", FALSE,
			   "label", "toggle sprite 3",
			   "signal::clicked", toggle_sprite3, forest,
			   NULL);
  gtk_box_pack_start (GTK_BOX (vbox), button, FALSE, TRUE, 5);
  toggle_sprite3 (button, GNOME_FOREST (forest));

  /* debug flags
   * guint shade_svps:1, show_utas:1, disable_cd:1, debug_cd:1;
   */
  button = gtk_widget_new (GTK_TYPE_TOGGLE_BUTTON,
			   "visible", TRUE,
			   "active", FALSE,
			   "label", "shade_svps",
			   "signal::clicked", toggle_shade_svps, forest,
			   NULL);
  gtk_box_pack_start (GTK_BOX (vbox), button, FALSE, TRUE, 5);
  toggle_shade_svps (button, GNOME_FOREST (forest));
  button = gtk_widget_new (GTK_TYPE_TOGGLE_BUTTON,
			   "visible", TRUE,
			   "active", FALSE,
			   "label", "show_utas",
			   "signal::clicked", toggle_show_utas, forest,
			   NULL);
  gtk_box_pack_start (GTK_BOX (vbox), button, FALSE, TRUE, 5);
  toggle_show_utas (button, GNOME_FOREST (forest));
  button = gtk_widget_new (GTK_TYPE_TOGGLE_BUTTON,
			   "visible", TRUE,
			   "active", FALSE,
			   "label", "auto resize",
			   "signal::clicked", toggle_auto_resize, forest,
			   NULL);
  gtk_box_pack_start (GTK_BOX (vbox), button, FALSE, TRUE, 5);
  toggle_auto_resize (button, GNOME_FOREST (forest));
  button = gtk_widget_new (GTK_TYPE_TOGGLE_BUTTON,
			   "visible", TRUE,
			   "active", TRUE,
			   "label", "disable_cd",
			   "signal::clicked", toggle_disable_cd, forest,
			   NULL);
  gtk_box_pack_start (GTK_BOX (vbox), button, FALSE, TRUE, 5);
  toggle_disable_cd (button, GNOME_FOREST (forest));
  button = gtk_widget_new (GTK_TYPE_TOGGLE_BUTTON,
			   "visible", TRUE,
			   "active", TRUE,
			   "label", "debug_cd",
			   "signal::clicked", toggle_debug_cd, forest,
			   NULL);
  gtk_box_pack_start (GTK_BOX (vbox), button, FALSE, TRUE, 5);
  toggle_debug_cd (button, GNOME_FOREST (forest));

  window = gtk_widget_new (GTK_TYPE_WINDOW,
			   "child", vbox,
			   "visible", TRUE,
			   "signal::destroy", gtk_main_quit, NULL,
			   "auto_shrink", TRUE,
			   "allow_shrink", TRUE,
			   "allow_grow", TRUE,
			   NULL);
  button = gtk_widget_new (GTK_TYPE_BUTTON,
			   "visible", TRUE,
			   "label", "close",
			   "object_signal::clicked", gtk_widget_destroy, window,
			   NULL);
  gtk_box_pack_end (GTK_BOX (vbox), button, FALSE, TRUE, 5);

  gtk_main ();

  return 0;
}
