#ifndef __HF_IO_H__
#define __HF_IO_H__
/* read heightfield  */
int hf_read(PTYPE **hf, U *x, U *y, char *fname);    
int read_mfile(PTYPE **hh, U *x, U *y, char *f);  /* read matlab file */
int write_mfile(PTYPE *hf, U xs, U ys, char *f, char *m); /* write matlab */
                              /* write hf array to PGM ascii or binary */
int hf_writeb(PTYPE *hf, U xsize, U ysize, char *fname);
int hf_write(PTYPE *hf, U xsize, U ysize, char *fname);
int gwrite(PTYPE *hf, U xsize, U ysize, char *fname); /* write as GIF */
int pwrite(PTYPE *hf, U xs, U ys, char *fname);  /* write to POT format */
int pread(PTYPE **hf, U *x, U *y, char *fname);      /* read from POT */
int tga_read(PTYPE **hf, U *x, U *y, char *fname);   /* read from TGA */
int tga_write(PTYPE *hf, U xsize, U ysize, char *fname);
int oct_write(PTYPE *hf, U xsize, U ysize, char *f, char *m); /* Octave fmt */
int gread(char *fname);                 /* read hf array from GIF format */
int gread1(PTYPE **hh, unsigned int *xs, unsigned int *ys, char *fname);
                                        /* general (top-level) hf i/o */
         /* ready heightfield determining type from filename extension */
int readn_hf(PTYPE **hf, U *xsize, U *ysize, char *fname_in);
int read_hf(PTYPE **hfp, U* xsp, U* ysp, char *fname_in, int itype);
int writen_hf(PTYPE *hf, U xsize, U ysize, char *fname_out);
int write_hf(PTYPE *hf, U xsize, U ysize, char *fname_out, int otype);

/* extensions of recognized filetypes */
#define Intype_string "PGM|MAT|GIF|POT|TGA"
#define Outtype_string "PGM|PG8|MAT|OCT|GIF|POT|TGA"
#endif // __HF_IO_H__
