
/*  *************************************************************************
    macte.c -- The Macintosh textedit functions code (part 2 of 2) for:

    MacSCM v1.0

    Author: Kevin Scott Kunzelman (kkunzelm@cam.cornell.edu)

    This code is in the public domain.	You can copy it, sell it, modify it,
    all without any restrictions.
    ************************************************************************/


#include <Events.h>
#include <Controls.h>
#include <Windows.h>
#include <QuickDraw.h>
#include <TextEdit.h>
#include <Menus.h>
#include <Pascal.h>

#include <assert.h>
#include <stdio.h>
#include <string.h>
#include <console.h>

#include "scm.h"
#include "macscm.h"
#include "macte.h"
#include "version.h"


/*  ************************************************************************/


static Str255 GStr255;
static char ARG6[] = "arg6";
static char ARG7[] = "arg7";
static char ARG8[] = "arg8";
static char ARG9[] = "arg9";


/*  ************************************************************************/


#define TE_SETSELECT(t,a,b)	TESetSelect((a),(b),(t))
#define TE_SETJUST(t,a)		TESetJust((a),(t))
#define TE_SETTEXT(t,s)		TESetText((s),strlen(s),(t))
#define TE_DESTRECT(t)		((**(t)).destRect)
#define TE_VIEWRECT(t)		((**(t)).viewRect)
#define TE_LENGTH(t)		((long) (**(t)).teLength)
#define TE_START(t)		((long) (**(t)).selStart)
#define TE_END(t)		((long) (**(t)).selEnd)
#define TE_LINES(t)		((long) (**(t)).nLines)
#define TE_JUST(t)		((long) (**(t)).just)
#define TE_FONT(t)		((long) (**(t)).txFont)
#define TE_FACE(t)		((long) (**(t)).txFace)
#define TE_MODE(t)		((long) (**(t)).txMode)
#define TE_SIZE(t)		((long) (**(t)).txSize)
#define TE_HEIGHT(t)		((long) (**(t)).lineHeight)
#define TE_ASCENT(t)		((long) (**(t)).fontAscent)
#define TE_SETDESTRECT(t,pr)	((**(t)).destRect = *(pr))
#define TE_SETVIEWRECT(t,pr)	((**(t)).viewRect = *(pr))
#define TE_SETFONT(t,i)		((**(t)).txFont = (i))
#define TE_SETFACE(t,i)		((**(t)).txFace = (i))
#define TE_SETMODE(t,i)		((**(t)).txMode = (i))
#define TE_SETSIZE(t,i)		((**(t)).txSize = (i))
#define TE_SETHEIGHT(t,i)	((**(t)).lineHeight = (i))
#define TE_SETASCENT(t,i)	((**(t)).fontAscent = (i))


/*  ************************************************************************/


#define SUBRS(x)								\
x("te-set-dest-rect",	    te_set_dest_rect,	TERECT_FUNC,	TE_SETDESTRECT) \
x("te-set-view-rect",	    te_set_view_rect,	TERECT_FUNC,	TE_SETVIEWRECT) \
x("te-set-text",	    te_set_text,	TESTRING_FUNC,	TE_SETTEXT)	\
x("te-set-just",	    te_set_just,	TEINT_FUNC,	TE_SETJUST)	\
x("te-set-select",	    te_set_select,	TEINT2_FUNC,	TE_SETSELECT)	\
x("te-set-font",	    te_set_font,	TEINT_FUNC,	TE_SETFONT)	\
x("te-set-face",	    te_set_face,	TEINT_FUNC,	TE_SETFACE)	\
x("te-set-mode",	    te_set_mode,	TEINT_FUNC,	TE_SETMODE)	\
x("te-set-size",	    te_set_size,	TEINT_FUNC,	TE_SETSIZE)	\
x("te-set-line-height",	    te_set_line_height, TEINT_FUNC,	TE_SETHEIGHT)	\
x("te-set-font-ascent",	    te_set_font_ascent, TEINT_FUNC,	TE_SETASCENT)	\
x("te-get-dest-rect",	    te_get_dest_rect,	TE_RECT_FUNC,	TE_DESTRECT)	\
x("te-get-view-rect",	    te_get_view_rect,	TE_RECT_FUNC,	TE_VIEWRECT)	\
x("te-get-text",	    te_get_text,	SPECIAL_FUNC,	SPECIAL_FUNC)	\
x("te-get-just",	    te_get_just,	TE_INT_FUNC,	TE_JUST)	\
x("te-get-select-pt",	    te_get_sel_pt,	SPECIAL_FUNC,	SPECIAL_FUNC)	\
x("te-get-select-start",    te_get_sel_start,	TE_INT_FUNC,	TE_START)	\
x("te-get-select-end",	    te_get_sel_end,	TE_INT_FUNC,	TE_END)		\
x("te-get-font",	    te_get_font,	TE_INT_FUNC,	TE_FONT)	\
x("te-get-face",	    te_get_face,	TE_INT_FUNC,	TE_FACE)	\
x("te-get-mode",	    te_get_mode,	TE_INT_FUNC,	TE_MODE)	\
x("te-get-size",	    te_get_size,	TE_INT_FUNC,	TE_SIZE)	\
x("te-get-line-height",	    te_get_line_height, TE_INT_FUNC,	TE_HEIGHT)	\
x("te-get-font-ascent",	    te_get_font_ascent, TE_INT_FUNC,	TE_ASCENT)	\
x("te-get-length",	    te_get_length,	TE_INT_FUNC,	TE_LENGTH)	\
x("te-get-lines",	    te_get_lines,	TE_INT_FUNC,	TE_LINES)	\


/*  ************************************************************************/


DECLARE_FUNCS(SUBRS, init_mac_te2)


/*  ************************************************************************/


SCM mac_te_get_text(SCM s_args)
{
  TEHandle t;

  GET_NEXT_MACTE(t, s_args, ARG1, s_mac_te_get_text);

  return makfromstr(*((**t).hText), (long) (**t).teLength);
}

SCM mac_te_get_sel_pt(SCM s_args)
{
  TEHandle t;

  GET_NEXT_MACTE(t, s_args, ARG1, s_mac_te_get_sel_pt);

  return make_macpt(&( (**(t)).selPoint ));
}

/*  ************************************************************************/
