;;;
;;; macte.scm -- A prototype Macintosh text-editor (this was created
;;;		 to test maclib.scm).
;;;
;;; This text editor is far from complete.  In fact, you cannot even load or
;;; save files.	 I created this merely for test purposes: to
;;; make sure that maclib.scm worked properly.	SCM provides a very nice
;;; environment for sophisticated object-oriented programming.	Perhaps someone
;;; with a lot of self-motivation can take maclib.scm and this example and
;;; push it further.
;;;
;;; Part of MacSCM 1.0.
;;;
;;; Author: Kevin Scott Kunzelman (kkunzelm@cam.cornell.edu)
;;;
;;; This code is in the public domain.	You can copy it, sell it, modify it,
;;; all without any restrictions.
;;;

(load "mac.scm")
(load "maclib.scm")

(define old-port (mac:get-port))
(define app (app-new))

(define next-window 0)

(define edit-menus
     `(("File" ("New/N" ,(lambda () (new-edit-window)))
	       ("Quit/Q" ,(lambda () (set! app-done #t))))
       ("Edit" ("Cut/X" ,(lambda () (display "*Cut*") (newline)))
	       ("Copy/C" ,(lambda () (display "*Copy*") (newline)))
	       ("Paste/V" ,(lambda () (display "*Paste*") (newline))))))

;;; here's a function that will add a new edit window to our application.

(define (new-edit-window)
  (let*
    ((my-rect (mac:rect-new 200 50 500 350))
     (my-name (string-append "My Window" (number->string next-window)))
     (my-wind (wind-zoom-doc-new my-rect my-name #t #t))
     (my-te (widg-te-scroll-new my-wind (mac:rect-new 2 2 298 298)))
     (my-menu-bar (menu-bar-new)))
    (my-menu-bar 'set-menus edit-menus)
    (my-te 'set-text my-name)
    (my-wind 'set-widg my-te)
    (my-wind 'set-menu-bar my-menu-bar)
    (app 'add-wind my-wind)
    (set! next-window (1+ next-window))))

;;; let's start out with one edit window.

(new-edit-window)

(define app-done #f)		; here's the done flag initialized to false.
(define (loop)			; Main event loop
  (if (not app-done)
      (let ((my-evt (mac:get-next-evt everyEvent)))
	(app 'idle)
	(if my-evt (app 'evt my-evt))	; give the event to the application.
	(loop))))
(loop)				; start looping

(app 'dispose)			; deallocate our application
(mac:set-port old-port)		; restore to the previous context.
