#ifndef __macte_h__
#define __macte_h__

/*  *************************************************************************
    macte.h -- The Macintosh textedit functions header for:

    MacSCM v1.0

    Author: Kevin Scott Kunzelman (kkunzelm@cam.cornell.edu)

    This code is in the public domain.	You can copy it, sell it, modify it,
    all without any restrictions.
    ************************************************************************/


#define TE_FUNC(name, call)				\
SCM MAC_(name)(SCM s_args)				\
{							\
  TEHandle t;						\
							\
  GET_NEXT_MACTE(t, s_args, ARG1, S_MAC_(name));	\
  call(t);						\
							\
  return UNSPECIFIED;					\
}

#define TE_INT_FUNC(name, call)				\
SCM MAC_(name)(SCM s_args)				\
{							\
  TEHandle t;						\
							\
  GET_NEXT_MACTE(t, s_args, ARG1, S_MAC_(name));	\
							\
  return MAKINUM(call(t));				\
}

#define TE_RECT_FUNC(name, call)			\
SCM MAC_(name)(SCM s_args)				\
{							\
  TEHandle t;						\
  Rect r;						\
							\
  GET_NEXT_MACTE(t, s_args, ARG1, S_MAC_(name));	\
  r = call(t);						\
							\
  return make_macrect(&r);				\
}

#define TESTRING_FUNC(name, call)			\
SCM MAC_(name)(SCM s_args)				\
{							\
  char *pc;						\
  TEHandle t;						\
							\
  GET_NEXT_MACTE(t, s_args, ARG1, S_MAC_(name));	\
  GET_NEXT_STRING(pc, s_args, ARG2, S_MAC_(name));	\
  call(t,pc);						\
							\
  return UNSPECIFIED;					\
}

#define TEINT_FUNC(name, call)				\
SCM MAC_(name)(SCM s_args)				\
{							\
  long n;						\
  TEHandle t;						\
							\
  GET_NEXT_MACTE(t, s_args, ARG1, S_MAC_(name));	\
  GET_NEXT_INT(n, s_args, ARG2, S_MAC_(name));		\
  call(t,n);						\
							\
  return UNSPECIFIED;					\
}

#define TEINT2_FUNC(name, call)				\
SCM MAC_(name)(SCM s_args)				\
{							\
  long n1, n2;						\
  TEHandle t;						\
							\
  GET_NEXT_MACTE(t, s_args, ARG1, S_MAC_(name));	\
  GET_NEXT_INT(n1, s_args, ARG2, S_MAC_(name));		\
  GET_NEXT_INT(n2, s_args, ARG3, S_MAC_(name));		\
  call(t,n1,n2);					\
							\
  return UNSPECIFIED;					\
}

#define TEINT2_INT_FUNC(name, call)			\
SCM MAC_(name)(SCM s_args)				\
{							\
  long n1, n2;						\
  TEHandle t;						\
							\
  GET_NEXT_MACTE(t, s_args, ARG1, S_MAC_(name));	\
  GET_NEXT_INT(n1, s_args, ARG2, S_MAC_(name));		\
  GET_NEXT_INT(n2, s_args, ARG3, S_MAC_(name));		\
							\
  return MAKINUM(call(t,n1,n2));			\
}

#define TERECT_FUNC(name, call)				\
SCM MAC_(name)(SCM s_args)				\
{							\
  Rect r;						\
  TEHandle t;						\
							\
  GET_NEXT_MACTE(t, s_args, ARG1, S_MAC_(name));	\
  GET_NEXT_MACRECT(r, s_args, ARG2, S_MAC_(name));	\
  call(t,&r);						\
							\
  return UNSPECIFIED;					\
}

#define RECT2_TE_FUNC(name, call)			\
SCM MAC_(name)(SCM s_args)				\
{							\
  Rect r1, r2;						\
							\
  GET_NEXT_MACRECT(r1, s_args, ARG1, S_MAC_(name));	\
  GET_NEXT_MACRECT(r2, s_args, ARG1, S_MAC_(name));	\
							\
  return make_macte(call(&r1, &r2));			\
}

#define TEBOOL_FUNC(name, call)				\
SCM MAC_(name)(SCM s_args)				\
{							\
  char b;						\
  TEHandle t;						\
							\
  GET_NEXT_MACTE(t, s_args, ARG1, S_MAC_(name));	\
  GET_NEXT_BOOL(b, s_args, ARG2, S_MAC_(name));		\
  call(t,b);						\
							\
  return UNSPECIFIED;					\
}

#define TEPT_INT_FUNC(name, call)			\
SCM MAC_(name)(SCM s_args)				\
{							\
  Point p;						\
  TEHandle t;						\
							\
  GET_NEXT_MACTE(t, s_args, ARG1, S_MAC_(name));	\
  GET_NEXT_MACPT(p, s_args, ARG2, S_MAC_(name));	\
							\
  return MAKINUM((long) call(t,p));			\
}

#define TEINT_PT_FUNC(name, call)			\
SCM MAC_(name)(SCM s_args)				\
{							\
  long n;						\
  TEHandle t;						\
  Point p;						\
							\
  GET_NEXT_MACTE(t, s_args, ARG1, S_MAC_(name));	\
  GET_NEXT_INT(n, s_args, ARG2, S_MAC_(name));		\
  p = call(t,n);					\
							\
  return make_macpt(&p);				\
}

#define TEPTBOOL_FUNC(name, call)			\
SCM MAC_(name)(SCM s_args)				\
{							\
  Point p;						\
  char b;						\
  TEHandle t;						\
							\
  GET_NEXT_MACTE(t, s_args, ARG1, S_MAC_(name));	\
  GET_NEXT_MACPT(p, s_args, ARG2, S_MAC_(name));	\
  GET_NEXT_BOOL(b, s_args, ARG3, S_MAC_(name));		\
  call(t,p,b);						\
							\
  return UNSPECIFIED;					\
}


/*  ************************************************************************/

#endif /* __macte_h__ */
