#ifndef __macctrl_h__
#define __macctrl_h__

/*  *************************************************************************
    macctrl.h -- The Macintosh control functions header for:

    MacSCM v1.0

    Author: Kevin Scott Kunzelman (kkunzelm@cam.cornell.edu)

    This code is in the public domain.	You can copy it, sell it, modify it,
    all without any restrictions.
    ************************************************************************/


#define CTRL_FUNC(name, call)				\
SCM MAC_(name)(SCM s_args)				\
{							\
  ControlHandle c;					\
							\
  GET_NEXT_MACCTRL(c, s_args, ARG1, S_MAC_(name));	\
  call(c);						\
							\
  return UNSPECIFIED;					\
}

#define CTRLINT_FUNC(name, call)			\
SCM MAC_(name)(SCM s_args)				\
{							\
  ControlHandle c;					\
  long n;						\
							\
  GET_NEXT_MACCTRL(c, s_args, ARG1, S_MAC_(name));	\
  GET_NEXT_INT(n, s_args, ARG2, S_MAC_(name));		\
  call(c,n);						\
							\
  return UNSPECIFIED;					\
}

#define CTRLINT2_FUNC(name, call)			\
SCM MAC_(name)(SCM s_args)				\
{							\
  ControlHandle c;					\
  long n1, n2;						\
							\
  GET_NEXT_MACCTRL(c, s_args, ARG1, S_MAC_(name));	\
  GET_NEXT_INT(n1, s_args, ARG2, S_MAC_(name));		\
  GET_NEXT_INT(n2, s_args, ARG3, S_MAC_(name));		\
  call(c,n1,n2);					\
							\
  return UNSPECIFIED;					\
}

#define CTRL_INT_FUNC(name, call)			\
SCM MAC_(name)(SCM s_args)				\
{							\
  ControlHandle c;					\
							\
  GET_NEXT_MACCTRL(c, s_args, ARG1, S_MAC_(name));	\
							\
  return MAKINUM((long) call(c));			\
}

#define CTRLSTRING_FUNC(name, call)			\
SCM MAC_(name)(SCM s_args)				\
{							\
  ControlHandle c;					\
  char *pc;						\
							\
  GET_NEXT_MACCTRL(c, s_args, ARG1, S_MAC_(name));	\
  GET_NEXT_STRING(pc, s_args, ARG2, S_MAC_(name));	\
  c2pstr (strncpy((char *) GStr255, pc, 255));		\
  call (c, &GStr255);					\
							\
  return UNSPECIFIED;					\
}

#define CTRL_STRING_FUNC(name, call)			\
SCM MAC_(name)(SCM s_args)				\
{							\
  ControlHandle c;					\
  char *pc;						\
							\
  GET_NEXT_MACCTRL(c, s_args, ARG1, S_MAC_(name));	\
  call(c, &GStr255);					\
  pc = p2cstr((char *) GStr255);			\
							\
  return makfromstr(pc, strlen(pc));			\
}

#define CTRLPT_INT_FUNC(name, call)			\
SCM MAC_(name)(SCM s_args)				\
{							\
  ControlHandle c;					\
  Point p;						\
							\
  GET_NEXT_MACCTRL(c, s_args, ARG1, S_MAC_(name));	\
  GET_NEXT_MACPT(p, s_args, ARG2, S_MAC_(name));	\
							\
  return MAKINUM((long) call(c, p));			\
}

#define CTRLPTRECT2INT_FUNC(name, call)			\
SCM MAC_(name)(SCM s_args)				\
{							\
  ControlHandle c;					\
  Point p;						\
  Rect r1,r2;						\
  long n;						\
							\
  GET_NEXT_MACCTRL(c, s_args, ARG1, S_MAC_(name));	\
  GET_NEXT_MACPT(p, s_args, ARG2, S_MAC_(name));	\
  GET_NEXT_MACRECT(r1, s_args, ARG3, S_MAC_(name));	\
  GET_NEXT_MACRECT(r2, s_args, ARG4, S_MAC_(name));	\
  GET_NEXT_INT(n, s_args, ARG5, S_MAC_(name));		\
  call(c, p, &r1, &r2, n);				\
							\
  return UNSPECIFIED;					\
}


/*  ************************************************************************/

#endif /* __macctrl_h__ */
