From olav@jordforsk.nlh.no Sun Jan 23 18:16:25 1994
Return-Path: <bug-gnuplot-request@wildcat.dartmouth.edu>
From: olav@jordforsk.nlh.no (Hans Olav Eggestad)
Date: Mon, 20 Dec 93 16:31:58 GMT
To: bug-gnuplot@Dartmouth.EDU
Subject: timeseries, command.c.3.5.patch

*** command.c.orig	Thu Nov 11 09:06:22 1993
--- command.c	Wed Dec 15 09:01:19 1993
***************
*** 1,5 ****
  #ifndef lint
! static char    *RCSid = "$Id: command.c%v 3.50.1.15 1993/08/21 15:23:42 woo Exp $";
  #endif
  
  
--- 1,5 ----
  #ifndef lint
! static char    *RCSid = "$Id: command.c%v 3.51.1.15 1993/08/21 15:23:42 woo Exp $";
  #endif
  
  
***************
*** 382,387 ****
--- 382,396 ----
  /* jev -- for passing data thru user-defined function */
  static struct udft_entry ydata_func;
  
+ #ifndef __time_h
+ #include <time.h>
+ #endif
+ 
+ extern int datatype[];
+ extern char timefmt[];
+ extern char *gstrptime();
+ extern utime_t gtimegm();
+ 
  /* support for replot command */
  char            replot_line[MAX_LINE_LEN + 1] = "";
  static int      plot_token;	/* start of 'plot' command */
***************
*** 746,782 ****
  		/* used to be: int_error("'=' expected",c_token); */
  	    }
  	}
! 	changed = parametric ? load_range(&tmin, &tmax) : load_range(&xmin, &xmax);
  	if (!equals(c_token, "]"))
  	    int_error("']' expected", c_token);
  	c_token++;
! 	if (changed) {
  	    if (parametric)
! 		autoscale_lt = FALSE;
  	    else
! 		autoscale_lx = FALSE;
! 	}
      }
      if (parametric && equals(c_token, "[")) {	/* set optional x ranges */
  	c_token++;
! 	changed = load_range(&xmin, &xmax);
  	if (!equals(c_token, "]"))
  	    int_error("']' expected", c_token);
  	c_token++;
! 	if (changed)
  		if(parametric)
! 			autoscale_lt = FALSE;
  		else
! 	   	 	autoscale_lx = FALSE;
      }
      if (equals(c_token, "[")) {	/* set optional y ranges */
  	c_token++;
! 	changed = load_range(&ymin, &ymax);
  	if (!equals(c_token, "]"))
  	    int_error("']' expected", c_token);
  	c_token++;
! 	if (changed)
! 	    autoscale_ly = FALSE;
      }
      /* use the default dummy variable unless changed */
      if (dummy_token >= 0)
--- 755,796 ----
  		/* used to be: int_error("'=' expected",c_token); */
  	    }
  	}
! 	changed = parametric ? load_range('t',&tmin, &tmax, autoscale_lt) : load_range('x',&xmin, &xmax, autoscale_lx);
  	if (!equals(c_token, "]"))
  	    int_error("']' expected", c_token);
  	c_token++;
! 	/* if (changed) { */
  	    if (parametric)
! 		/* autoscale_lt = FALSE; */
! 		autoscale_lt = changed;
  	    else
! 		/* autoscale_lx = FALSE; */
! 		autoscale_lx = changed;
! 	/* } */
      }
      if (parametric && equals(c_token, "[")) {	/* set optional x ranges */
  	c_token++;
! 	changed = load_range('x',&xmin, &xmax, autoscale_lx);
  	if (!equals(c_token, "]"))
  	    int_error("']' expected", c_token);
  	c_token++;
! 	/* if (changed) */
  		if(parametric)
! 			/* autoscale_lt = FALSE; */
! 			autoscale_lt = changed;
  		else
! 	   	 	/* autoscale_lx = FALSE; */
! 	   	 	autoscale_lx = changed;
      }
      if (equals(c_token, "[")) {	/* set optional y ranges */
  	c_token++;
! 	changed = load_range('y',&ymin, &ymax, autoscale_ly);
  	if (!equals(c_token, "]"))
  	    int_error("']' expected", c_token);
  	c_token++;
! 	/* if (changed) */
! 	    /* autoscale_ly = FALSE; */
! 	    autoscale_ly = changed;
      }
      /* use the default dummy variable unless changed */
      if (dummy_token >= 0)
***************
*** 823,837 ****
  		/* used to be: int_error("'=' expected",c_token); */
  	    }
  	}
! 	changed = parametric ? load_range(&umin, &umax) : load_range(&xmin, &xmax);
  	if (!equals(c_token, "]"))
  	    int_error("']' expected", c_token);
  	c_token++;
! 	if (changed)
  		if(parametric) 
! 			autoscale_lu = FALSE;
  		else
! 	    	autoscale_lx = FALSE;
      }
      if (equals(c_token, "[")) {
  	c_token++;
--- 837,853 ----
  		/* used to be: int_error("'=' expected",c_token); */
  	    }
  	}
! 	changed = parametric ? load_range('u',&umin, &umax, autoscale_lu) : load_range('x',&xmin, &xmax, autoscale_lx);
  	if (!equals(c_token, "]"))
  	    int_error("']' expected", c_token);
  	c_token++;
! 	/* if (changed) */
  		if(parametric) 
! 			/* autoscale_lu = FALSE; */
! 			autoscale_lu = changed;
  		else
! 			/* autoscale_lx = FALSE; */
! 			autoscale_lx = changed;
      }
      if (equals(c_token, "[")) {
  	c_token++;
***************
*** 845,889 ****
  		/* used to be: int_error("'=' expected",c_token); */
  	    }
  	}
! 	changed = parametric ? load_range(&vmin, &vmax) : load_range(&ymin, &ymax);
  	if (!equals(c_token, "]"))
  	    int_error("']' expected", c_token);
  	c_token++;
! 	if (changed)
  		if(parametric) 
! 			autoscale_lv = FALSE;
  		else
! 	    	autoscale_ly = FALSE;
      }
      if (equals(c_token, "[")) {	/* set optional x (parametric) or z ranges */
  	c_token++;
! 	changed = parametric ? load_range(&xmin, &xmax) : load_range(&zmin, &zmax);
  	if (!equals(c_token, "]"))
  	    int_error("']' expected", c_token);
  	c_token++;
! 	if (changed)
  		if(parametric) 
! 			autoscale_lx = FALSE;
  		else
! 	    	autoscale_lz = FALSE;
      }
      if (equals(c_token, "[")) {	/* set optional y ranges */
  	c_token++;
! 	changed = load_range(&ymin, &ymax);
  	if (!equals(c_token, "]"))
  	    int_error("']' expected", c_token);
  	c_token++;
! 	if (changed)
! 	    autoscale_ly = FALSE;
      }
      if (equals(c_token, "[")) {	/* set optional z ranges */
  	c_token++;
! 	changed = load_range(&zmin, &zmax);
  	if (!equals(c_token, "]"))
  	    int_error("']' expected", c_token);
  	c_token++;
! 	if (changed)
! 	    autoscale_lz = FALSE;
      }
      /* use the default dummy variable unless changed */
      if (dummy_token0 >= 0)
--- 861,911 ----
  		/* used to be: int_error("'=' expected",c_token); */
  	    }
  	}
! 	changed = parametric ? load_range('v',&vmin, &vmax, autoscale_lv) : load_range('y',&ymin, &ymax, autoscale_ly);
  	if (!equals(c_token, "]"))
  	    int_error("']' expected", c_token);
  	c_token++;
! 	/* if (changed) */
  		if(parametric) 
! 			/* autoscale_lv = FALSE; */
! 			autoscale_lv = changed;
  		else
! 			/* autoscale_ly = FALSE; */
! 			autoscale_ly = changed;
      }
      if (equals(c_token, "[")) {	/* set optional x (parametric) or z ranges */
  	c_token++;
! 	changed = parametric ? load_range('x',&xmin, &xmax, autoscale_lx) : load_range('z',&zmin, &zmax, autoscale_lz);
  	if (!equals(c_token, "]"))
  	    int_error("']' expected", c_token);
  	c_token++;
! 	/* if (changed) */
  		if(parametric) 
! 			/* autoscale_lx = FALSE; */
! 			autoscale_lx = changed;
  		else
! 			/* autoscale_lz = FALSE; */
! 			autoscale_lz = changed;
      }
      if (equals(c_token, "[")) {	/* set optional y ranges */
  	c_token++;
! 	changed = load_range('y',&ymin, &ymax, autoscale_ly);
  	if (!equals(c_token, "]"))
  	    int_error("']' expected", c_token);
  	c_token++;
! 	/* if (changed) */
! 	    /* autoscale_ly = FALSE; */
! 	    autoscale_ly = changed;
      }
      if (equals(c_token, "[")) {	/* set optional z ranges */
  	c_token++;
! 	changed = load_range('z',&zmin, &zmax, autoscale_lz);
  	if (!equals(c_token, "]"))
  	    int_error("']' expected", c_token);
  	c_token++;
! 	/* if (changed) */
! 	    /* autoscale_lz = FALSE; */
! 	    autoscale_lz = changed;
      }
      /* use the default dummy variable unless changed */
      if (dummy_token0 >= 0)
***************
*** 947,952 ****
--- 969,975 ----
  	char *s;
  	double val[5], v[5];
  	float fval[5];	/* for use in sscanf */
+ 	struct tm tm;
  
  	/* close forgotten input file (in case of a syntax error) */
  	if( data_fp ) {
***************
*** 1046,1058 ****
  	for (i=0; i<5; i++) 
  		if (fcol[i]>col) col=fcol[i];
  
  	l_num = 0;
  	datum = 0;
  	i = 0;
  	while (fgets(line, MAX_LINE_LEN, data_fp) != (char *) NULL) {
  		l_num++;
  		if (is_comment(line[0]))
! 	    	continue;		/* ignore comments */
  		if (i >= this_plot->p_max) {
  			/*
  			 * overflow about to occur. Extend size of points[] array. We
--- 1069,1089 ----
  	for (i=0; i<5; i++) 
  		if (fcol[i]>col) col=fcol[i];
  
+ 	tm.tm_year = tm.tm_mon = tm.tm_mday = tm.tm_yday = tm.tm_hour = tm.tm_min = tm.tm_sec = 0;
  	l_num = 0;
  	datum = 0;
  	i = 0;
  	while (fgets(line, MAX_LINE_LEN, data_fp) != (char *) NULL) {
  		l_num++;
+ 		if ( line[0] == '$' ) { /* this_plot title */
+ 			char *xptr;
+ 			strcpy(this_plot->title,&line[1]);
+ 			if(xptr = (char *)rindex(this_plot->title,'\n')) 
+ 				*xptr = '\0'; 
+ 			continue;
+ 		}
  		if (is_comment(line[0]))
! 	    		continue;		/* ignore comments */
  		if (i >= this_plot->p_max) {
  			/*
  			 * overflow about to occur. Extend size of points[] array. We
***************
*** 1097,1103 ****
  				}
  				n++;
  				if (n == scol[m]) {
! 					if (isdigit(*s) || *s=='-' || *s=='+' || *s=='.') {
  						val[m] = atof(s);
  						m++;
  					}
--- 1128,1138 ----
  				}
  				n++;
  				if (n == scol[m]) {
! 					if ( datatype[ncol[m]-1] == TIME ) {
! 						s = (char *) gstrptime(s,timefmt,&tm); 
! 						val[m] = (double) gtimegm(&tm);
! 						m++;
! 					} else if (isdigit(*s) || *s=='-' || *s=='+' || *s=='.') {
  						val[m] = atof(s);
  						m++;
  					}
***************
*** 1228,1237 ****
      if (cp->type == INRANGE)
  	if (autoscale_lx || inrange(x, xmin, xmax)) {
  	    if (autoscale_lx) {
! 		if (x < xmin)
! 		    xmin = x;
! 		if (x > xmax)
! 		    xmax = x;
  	    }
  	} else {
  	    cp->type = OUTRANGE;
--- 1263,1280 ----
      if (cp->type == INRANGE)
  	if (autoscale_lx || inrange(x, xmin, xmax)) {
  	    if (autoscale_lx) {
! 		if (x < xmin) {
! 		    if (autoscale_lx & 1) 
! 			xmin = x;
! 		    else
! 			cp->type = OUTRANGE;
! 		}
! 		if (x > xmax) {
! 		    if (autoscale_lx & 2) 
! 		    	xmax = x;
! 		    else
! 			cp->type = OUTRANGE;
! 		}
  	    }
  	} else {
  	    cp->type = OUTRANGE;
***************
*** 1285,1304 ****
  		 inrange((y), ymin, ymax) ||
  		 polar)) {
  		if (autoscale_ly) {
! 		    if (y < ymin)
! 			ymin = y;
! 		    if (y > ymax)
! 			ymax = y;
  		    if (ebars) {
  			ylow = is_log_y ? pow(base_log_y, cp->ylow) : cp->ylow;
  			yhigh = is_log_y ? pow(base_log_y, cp->yhigh) : cp->yhigh;
! 			if (ylow < ymin)
  			    ymin = ylow;
! 			if (ylow > ymax)
  			    ymax = ylow;
! 			if (yhigh < ymin)
! 			    ymin = yhigh;
! 			if (yhigh > ymax)
  			    ymax = yhigh;
  		    }
  		}
--- 1328,1355 ----
  		 inrange((y), ymin, ymax) ||
  		 polar)) {
  		if (autoscale_ly) {
! 			if (y < ymin) {
! 			    if (autoscale_ly & 1) 
! 				ymin = y;
! 			    else
! 				cp->type = OUTRANGE;
! 			}
! 			if (y > ymax) {
! 			    if (autoscale_ly & 2) 
! 				ymax = y;
! 			    else
! 				cp->type = OUTRANGE;
! 			}
  		    if (ebars) {
  			ylow = is_log_y ? pow(base_log_y, cp->ylow) : cp->ylow;
  			yhigh = is_log_y ? pow(base_log_y, cp->yhigh) : cp->yhigh;
! 			if (ylow < ymin && autoscale_ly & 1)
  			    ymin = ylow;
! 			if (ylow > ymax && autoscale_ly & 2)
  			    ymax = ylow;
! 			if (yhigh < ymin && autoscale_ly & 1)
! 			    ymin = yhigh;
! 			if (yhigh > ymax && autoscale_ly & 2)
  			    ymax = yhigh;
  		    }
  		}
***************
*** 1448,1453 ****
--- 1499,1506 ----
  	XYZ, YXZ, ZXY, XZY, ZYX, YZX, XY, YX
      }               xyz_order;
      struct iso_curve *this_iso;
+     int get_time_data();
+     int cols[3], types[3], time_data = 0;
  
      /* close forgotten file (in case of a syntax error) */
      if (data_fp && !more_data_fp) {
***************
*** 1529,1534 ****
--- 1582,1609 ----
  	}
      }
  
+     if ( datatype[0] == TIME || datatype[1] == TIME || datatype[2] == TIME ) {
+ 	int t;
+ 	time_data = 1;
+ 	t = 0;
+ 	for (i=0;i<3;i++) 
+ 		cols[i] = types[i] = 0;
+ 	for (i=0;i<maxcol;i++) {
+ 		if ( i == xcol ) {
+ 			cols[t] = i;
+ 			types[t] = (datatype[0] == TIME);
+ 			t++;
+ 		} else if ( i == ycol ) {
+ 			cols[t] = i;
+ 			types[t] = (datatype[1] == TIME);
+ 			t++;
+ 		} else if ( i == zcol ) {
+ 			cols[t] = i;
+ 			types[t] = (datatype[2] == TIME);
+ 			t++;
+ 		}
+ 	}
+     }
      switch (mapping3d) {
      case MAP3D_CARTESIAN:
  	maxcol = (xcol > ycol) ? xcol : ycol;
***************
*** 1554,1560 ****
  	if (strlen(format) == 0) {
  	    if (only_z) {
  		for (i = 1; i <= zcol; i++)
! 		    if (i == zcol)
  			(void) strcat(format, float_format);
  		    else
  			(void) strcat(format, float_skip);
--- 1629,1635 ----
  	if (strlen(format) == 0) {
  	    if (only_z) {
  		for (i = 1; i <= zcol; i++)
! 		    if (i == zcol) 
  			(void) strcat(format, float_format);
  		    else
  			(void) strcat(format, float_skip);
***************
*** 1680,1686 ****
  		iso_extend(this_iso,
  			   xdatum + (xdatum < 1000 ? xdatum : 1000));
  	    }
! 	    switch (num_col = sscanf(line, format, &x, &y, &z)) {
  	    case 3:		/* All parameter are specified. */
  		if (!only_z || using_format) {
  		    switch (xyz_order) {
--- 1755,1766 ----
  		iso_extend(this_iso,
  			   xdatum + (xdatum < 1000 ? xdatum : 1000));
  	    }
! 	    if ( time_data ) {
! 		num_col = get_time_data(line,maxcol,cols,types,&x,&y,&z);
! 	    } else {
! 		num_col = sscanf(line, format, &x, &y, &z);
! 	    }
! 	    switch (num_col) {
  	    case 3:		/* All parameter are specified. */
  		if (!only_z || using_format) {
  		    switch (xyz_order) {
***************
*** 1806,1826 ****
  		    this_iso->points[xdatum].z =
  			log(this_iso->points[xdatum].z)/log_base_log_z;
  	    }
! 	    if (autoscale_lx) {
  		if (x < xmin)
  		    xmin = x;
  		if (x > xmax)
  		    xmax = x;
  	    }
! 	    if (autoscale_ly) {
  		if (y < ymin)
  		    ymin = y;
  		if (y > ymax)
  		    ymax = y;
  	    }
! 	    if (autoscale_lz) {
  		if (z < zmin)
  		    zmin = z;
  		if (z > zmax)
  		    zmax = z;
  	    }
--- 1886,1912 ----
  		    this_iso->points[xdatum].z =
  			log(this_iso->points[xdatum].z)/log_base_log_z;
  	    }
! 	    if (autoscale_lx & 1) {
  		if (x < xmin)
  		    xmin = x;
+ 	    }
+ 	    if (autoscale_lx & 2) {
  		if (x > xmax)
  		    xmax = x;
  	    }
! 	    if (autoscale_ly & 1) {
  		if (y < ymin)
  		    ymin = y;
+ 	    }
+ 	    if (autoscale_ly & 2) {
  		if (y > ymax)
  		    ymax = y;
  	    }
! 	    if (autoscale_lz & 1) {
  		if (z < zmin)
  		    zmin = z;
+ 	    }
+ 	    if (autoscale_lz & 2) {
  		if (z > zmax)
  		    zmax = z;
  	    }
***************
*** 2043,2050 ****
      first_plot=NULL;
  
      if (autoscale_ly) {
! 	ymin = VERYLARGE;
! 	ymax = -VERYLARGE;
      } else if (is_log_y && (ymin <= 0.0 || ymax <= 0.0))
  	int_error("y range must be above 0 for log scale!",
  		  NO_CARET);
--- 2129,2138 ----
      first_plot=NULL;
  
      if (autoscale_ly) {
!     	if (autoscale_ly & 1) 
! 		ymin = VERYLARGE;
!     	if (autoscale_ly & 2) 
! 		ymax = -VERYLARGE;
      } else if (is_log_y && (ymin <= 0.0 || ymax <= 0.0))
  	int_error("y range must be above 0 for log scale!",
  		  NO_CARET);
***************
*** 2080,2087 ****
  			      c_token);
  
  		if (!some_data_files && autoscale_lx) {
! 		    xmin = VERYLARGE;
! 		    xmax = -VERYLARGE;
  		}
  		some_data_files = TRUE;
  
--- 2168,2177 ----
  			      c_token);
  
  		if (!some_data_files && autoscale_lx) {
! 		    if (autoscale_lx & 1)
! 		    	xmin = VERYLARGE;
! 		    if (autoscale_lx & 2)
! 		    	xmax = -VERYLARGE;
  		}
  		some_data_files = TRUE;
  
***************
*** 2130,2135 ****
--- 2220,2227 ----
  		}
  		c_token++;
  	    } else if (almost_equals(c_token, "not$itle")) {
+ 		if (xtitle != NULL)
+ 			xtitle[0] = '\0';
  	        c_token++;
  	    } else {
  		m_capture(&(this_plot->title), start_token, end_token);
***************
*** 2202,2213 ****
  		    parametric ? 't' : 'x', xmin, xmax);
  	    if (fabs(xmin) < zero) {
  		/* completely arbitary */
! 		xmin = -1.;
! 		xmax = 1.;
  	    } else {
  		/* expand range by 10% in either direction */
! 		xmin = xmin * 0.9;
! 		xmax = xmax * 1.1;
  	    }
  	    fprintf(stderr, "adjusting to [%g:%g]\n", xmin, xmax);
  	} else {
--- 2294,2309 ----
  		    parametric ? 't' : 'x', xmin, xmax);
  	    if (fabs(xmin) < zero) {
  		/* completely arbitary */
! 		if (autoscale_lx & 1) 
! 			xmin = -1.;
! 		if (autoscale_lx & 2) 
! 			xmax = 1.;
  	    } else {
  		/* expand range by 10% in either direction */
! 		if (autoscale_lx & 1) 
! 			xmin = xmin * 0.9;
! 		if (autoscale_lx & 2) 
! 			xmax = xmax * 1.1;
  	    }
  	    fprintf(stderr, "adjusting to [%g:%g]\n", xmin, xmax);
  	} else {
***************
*** 2326,2335 ****
  			this_plot->points[i].type = INRANGE;
  			/* When xparam is 1 we are not really computing y's! */
  			if (!xparam && autoscale_ly) {
! 			    if (temp < ymin)
! 				ymin = temp;
! 			    if (temp > ymax)
! 				ymax = temp;
  			}
  		    } else
  			this_plot->points[i].type = OUTRANGE;
--- 2422,2439 ----
  			this_plot->points[i].type = INRANGE;
  			/* When xparam is 1 we are not really computing y's! */
  			if (!xparam && autoscale_ly) {
! 			    if (temp < ymin) {
! 				if (autoscale_ly & 1)
! 					ymin = temp;
! 				else
! 					this_plot->points[i].type = OUTRANGE;
! 			    }
! 			    if (temp > ymax) {
! 				if (autoscale_ly & 2)
! 					ymax = temp;
! 				else
! 					this_plot->points[i].type = OUTRANGE;
! 			    }
  			}
  		    } else
  			this_plot->points[i].type = OUTRANGE;
***************
*** 2384,2395 ****
  	if (autoscale_ly) {
  	    fprintf(stderr, "Warning: empty y range [%g:%g], ", ymin, ymax);
  	    if (fabs(ymin) < zero) {
! 		ymin = -1.;
! 		ymax = 1.;
  	    } else {
  		/* expand range by 10% in either direction */
! 		ymin = ymin * 0.9;
! 		ymax = ymax * 1.1;
  	    }
  	    fprintf(stderr, "adjusting to [%g:%g]\n", ymin, ymax);
  	} else {
--- 2488,2503 ----
  	if (autoscale_ly) {
  	    fprintf(stderr, "Warning: empty y range [%g:%g], ", ymin, ymax);
  	    if (fabs(ymin) < zero) {
! 		if (autoscale_ly & 1) 
! 			ymin = -1.;
! 		if (autoscale_ly & 2) 
! 			ymax = 1.;
  	    } else {
  		/* expand range by 10% in either direction */
! 		if (autoscale_ly & 1) 
! 			ymin = ymin * 0.9;
! 		if (autoscale_ly & 2) 
! 			ymax = ymax * 1.1;
  	    }
  	    fprintf(stderr, "adjusting to [%g:%g]\n", ymin, ymax);
  	} else {
***************
*** 2473,2478 ****
--- 2581,2590 ----
  	    }
  	    c_token++;
  	}  else if (almost_equals(c_token, "not$itle")) {
+ 	    if (*xtitle != NULL)
+ 		(*xtitle)[0] = '\0';
+ 	    if (*ytitle != NULL)
+ 		(*ytitle)[0] = '\0';
  	    c_token++;
  	}  else {
  	    m_capture(&(this_plot->title), start_token, end_token);
***************
*** 2516,2523 ****
      first_3dplot=NULL;
  
      if (autoscale_lz) {
! 	zmin = VERYLARGE;
! 	zmax = -VERYLARGE;
      } else if (is_log_z && (zmin <= 0.0 || zmax <= 0.0))
  	int_error("z range must be above 0 for log scale!",
  		  NO_CARET);
--- 2628,2637 ----
      first_3dplot=NULL;
  
      if (autoscale_lz) {
!     	if (autoscale_lz & 1) 
! 		zmin = VERYLARGE;
!     	if (autoscale_lz & 2) 
! 		zmax = -VERYLARGE;
      } else if (is_log_z && (zmin <= 0.0 || zmax <= 0.0))
  	int_error("z range must be above 0 for log scale!",
  		  NO_CARET);
***************
*** 2560,2571 ****
  			      c_token);
  
  		if (!some_data_files) {
! 		    if (autoscale_lx) {
  			xmin = VERYLARGE;
  			xmax = -VERYLARGE;
  		    }
! 		    if (autoscale_ly) {
  			ymin = VERYLARGE;
  			ymax = -VERYLARGE;
  		    }
  		}
--- 2674,2689 ----
  			      c_token);
  
  		if (!some_data_files) {
! 		    if (autoscale_lx & 1) {
  			xmin = VERYLARGE;
+ 		    }
+ 		    if (autoscale_lx & 2) {
  			xmax = -VERYLARGE;
  		    }
! 		    if (autoscale_ly & 1) {
  			ymin = VERYLARGE;
+ 		    }
+ 		    if (autoscale_ly & 2) {
  			ymax = -VERYLARGE;
  		    }
  		}
***************
*** 2719,2730 ****
  		    xmin, xmax);
  	    if (xmin == 0.0) {
  		/* completely arbitary */
! 		xmin = -1.;
! 		xmax = 1.;
  	    } else {
  		/* expand range by 10% in either direction */
! 		xmin = xmin * 0.9;
! 		xmax = xmax * 1.1;
  	    }
  	    fprintf(stderr, "adjusting to [%g:%g]\n", xmin, xmax);
  	} else {
--- 2837,2852 ----
  		    xmin, xmax);
  	    if (xmin == 0.0) {
  		/* completely arbitary */
! 		if (autoscale_lx & 1) 
! 			xmin = -1.;
! 		if (autoscale_lx & 2) 
! 			xmax = 1.;
  	    } else {
  		/* expand range by 10% in either direction */
! 		if (autoscale_lx & 1) 
! 			xmin = xmin * 0.9;
! 		if (autoscale_lx & 2) 
! 			xmax = xmax * 1.1;
  	    }
  	    fprintf(stderr, "adjusting to [%g:%g]\n", xmin, xmax);
  	} else {
***************
*** 2737,2748 ****
  		    ymin, ymax);
  	    if (ymin == 0.0) {
  		/* completely arbitary */
! 		ymin = -1.;
! 		ymax = 1.;
  	    } else {
  		/* expand range by 10% in either direction */
! 		ymin = ymin * 0.9;
! 		ymax = ymax * 1.1;
  	    }
  	    fprintf(stderr, "adjusting to [%g:%g]\n", ymin, ymax);
  	} else {
--- 2859,2874 ----
  		    ymin, ymax);
  	    if (ymin == 0.0) {
  		/* completely arbitary */
! 		if (autoscale_ly & 1) 
! 			ymin = -1.;
! 		if (autoscale_ly & 2)
! 			ymax = 1.;
  	    } else {
  		/* expand range by 10% in either direction */
! 		if (autoscale_ly & 1)
! 			ymin = ymin * 0.9;
! 		if (autoscale_ly & 2)
! 			ymax = ymax * 1.1;
  	    }
  	    fprintf(stderr, "adjusting to [%g:%g]\n", ymin, ymax);
  	} else {
***************
*** 2887,2896 ****
  			if (autoscale_lz || inrange(temp, zmin, zmax)) {
  			    points[i].type = INRANGE;
  			    if (autoscale_lz) {
! 				if (temp < zmin)
! 				    zmin = temp;
! 				if (temp > zmax)
! 				    zmax = temp;
  			    }
  			} else
  			    points[i].type = OUTRANGE;
--- 3013,3030 ----
  			if (autoscale_lz || inrange(temp, zmin, zmax)) {
  			    points[i].type = INRANGE;
  			    if (autoscale_lz) {
! 				if (temp < zmin) {
! 				    if (autoscale_lz & 1)
! 					    zmin = temp;
! 				    else
! 					    points[i].type = OUTRANGE;
! 				}
! 				if (temp > zmax) {
! 				    if (autoscale_lz & 2)
! 					    zmax = temp;
! 				    else
! 					    points[i].type = OUTRANGE;
! 			        }
  			    }
  			} else
  			    points[i].type = OUTRANGE;
***************
*** 2950,2959 ****
  				|| inrange(temp, zmin, zmax)) {
  				points[j].type = INRANGE;
  				if (autoscale_lz) {
! 				    if (temp < zmin)
! 					zmin = temp;
! 				    if (temp > zmax)
! 					zmax = temp;
  				}
  			    } else
  				points[j].type = OUTRANGE;
--- 3084,3101 ----
  				|| inrange(temp, zmin, zmax)) {
  				points[j].type = INRANGE;
  				if (autoscale_lz) {
! 				    if (temp < zmin) {
! 					if (autoscale_lz & 1) 
! 						zmin = temp;
! 					else
! 						points[j].type = OUTRANGE;
! 				    }
! 				    if (temp > zmax) {
! 					if (autoscale_lz & 2) 
! 						zmax = temp;
! 					else
! 						points[j].type = OUTRANGE;
! 				    }
  				}
  			    } else
  				points[j].type = OUTRANGE;
***************
*** 3007,3018 ****
  	if (autoscale_lz) {
  	    fprintf(stderr, "Warning: empty z range [%g:%g], ", zmin, zmax);
  	    if (fabs(zmin) < zero) {
! 		zmin = -1.;
! 		zmax = 1.;
  	    } else {
  		/* expand range by 10% in either direction */
! 		zmin = zmin * 0.9;
! 		zmax = zmax * 1.1;
  	    }
  	    fprintf(stderr, "adjusting to [%g:%g]\n", zmin, zmax);
  	} else {
--- 3149,3164 ----
  	if (autoscale_lz) {
  	    fprintf(stderr, "Warning: empty z range [%g:%g], ", zmin, zmax);
  	    if (fabs(zmin) < zero) {
! 		if (autoscale_lz & 1) 
! 			zmin = -1.;
! 		if (autoscale_lz & 2) 
! 			zmax = 1.;
  	    } else {
  		/* expand range by 10% in either direction */
! 		if (autoscale_lz & 1) 
! 			zmin = zmin * 0.9;
! 		if (autoscale_lz & 2) 
! 			zmax = zmax * 1.1;
  	    }
  	    fprintf(stderr, "adjusting to [%g:%g]\n", zmin, zmax);
  	} else {
***************
*** 3192,3199 ****
      double          lxmin, lxmax, temp;
  
      if (autoscale_lx) {
! 	lxmin = VERYLARGE;
! 	lxmax = -VERYLARGE;
      } else {
  	lxmin = xmin;
  	lxmax = xmax;
--- 3338,3347 ----
      double          lxmin, lxmax, temp;
  
      if (autoscale_lx) {
!     	if (autoscale_lx & 1) 
! 		lxmin = VERYLARGE;
!     	if (autoscale_lx & 2) 
! 		lxmax = -VERYLARGE;
      } else {
  	lxmin = xmin;
  	lxmax = xmax;
***************
*** 3247,3256 ****
  		yp->points[i].type = xp->points[i].type;
  	    if (autoscale_lx || polar
  		|| inrange(temp, lxmin, lxmax)) {
! 		if (autoscale_lx && temp < lxmin)
! 		    lxmin = temp;
! 		if (autoscale_lx && temp > lxmax)
! 		    lxmax = temp;
  	    } else
  		yp->points[i].type = OUTRANGE;	/* Due to x value. */
  	}
--- 3395,3414 ----
  		yp->points[i].type = xp->points[i].type;
  	    if (autoscale_lx || polar
  		|| inrange(temp, lxmin, lxmax)) {
! 		if (autoscale_lx) {
! 		    if (temp < lxmin) {
! 			if (autoscale_lx & 1) 
! 			    lxmin = temp;
! 			else
! 			    yp->points[i].type = OUTRANGE;	/* Due to x value. */
! 		    }
! 		    if (temp > lxmax) {
! 			if (autoscale_lx & 2) 
! 			    lxmax = temp;
! 			else
! 			    yp->points[i].type = OUTRANGE;	/* Due to x value. */
! 		    }
! 		}
  	    } else
  		yp->points[i].type = OUTRANGE;	/* Due to x value. */
  	}
***************
*** 3334,3360 ****
      char           *new_title;
      double          lxmin, lxmax, lymin, lymax, lzmin, lzmax;
  
!     if (autoscale_lx) {
  	lxmin = VERYLARGE;
- 	lxmax = -VERYLARGE;
      } else {
  	lxmin = xmin;
  	lxmax = xmax;
      }
  
!     if (autoscale_ly) {
  	lymin = VERYLARGE;
- 	lymax = -VERYLARGE;
      } else {
  	lymin = ymin;
  	lymax = ymax;
      }
  
!     if (autoscale_lz) {
  	lzmin = VERYLARGE;
- 	lzmax = -VERYLARGE;
      } else {
  	lzmin = zmin;
  	lzmax = zmax;
      }
  
--- 3492,3527 ----
      char           *new_title;
      double          lxmin, lxmax, lymin, lymax, lzmin, lzmax;
  
!     if (autoscale_lx & 1) {
  	lxmin = VERYLARGE;
      } else {
  	lxmin = xmin;
+     }
+     if (autoscale_lx & 2) {
+ 	lxmax = -VERYLARGE;
+     } else {
  	lxmax = xmax;
      }
  
!     if (autoscale_ly & 1) {
  	lymin = VERYLARGE;
      } else {
  	lymin = ymin;
+     }
+     if (autoscale_ly & 2) {
+ 	lymax = -VERYLARGE;
+     } else {
  	lymax = ymax;
      }
  
!     if (autoscale_lz & 1) {
  	lzmin = VERYLARGE;
      } else {
  	lzmin = zmin;
+     }
+     if (autoscale_lz & 2) {
+ 	lzmax = -VERYLARGE;
+     } else {
  	lzmax = zmax;
      }
  
***************
*** 3527,3551 ****
  	}
      }
      /* Report the overall graph mins and maxs. */
!     if (autoscale_lx) {
  	*x_min = (is_log_x ? pow(base_log_x, lxmin) : lxmin);
- 	*x_max = (is_log_x ? pow(base_log_x, lxmax) : lxmax);
      } else {
  	*x_min = xmin;
  	*x_max = xmax;
      }
!     if (autoscale_ly) {
  	*y_min = (is_log_y ? pow(base_log_y, lymin) : lymin);
- 	*y_max = (is_log_y ? pow(base_log_y, lymax) : lymax);
      } else {
  	*y_min = ymin;
  	*y_max = ymax;
      }
!     if (autoscale_lz) {
  	*z_min = (is_log_z ? pow(base_log_z, lzmin) : lzmin);
- 	*z_max = (is_log_z ? pow(base_log_z, lzmax) : lzmax);
      } else {
  	*z_min = zmin;
  	*z_max = zmax;
      }
  }
--- 3694,3727 ----
  	}
      }
      /* Report the overall graph mins and maxs. */
!     if (autoscale_lx & 1) {
  	*x_min = (is_log_x ? pow(base_log_x, lxmin) : lxmin);
      } else {
  	*x_min = xmin;
+     }
+     if (autoscale_lx & 2) {
+ 	*x_max = (is_log_x ? pow(base_log_x, lxmax) : lxmax);
+     } else {
  	*x_max = xmax;
      }
!     if (autoscale_ly & 1) {
  	*y_min = (is_log_y ? pow(base_log_y, lymin) : lymin);
      } else {
  	*y_min = ymin;
+     }
+     if (autoscale_ly & 2) {
+ 	*y_max = (is_log_y ? pow(base_log_y, lymax) : lymax);
+     } else {
  	*y_max = ymax;
      }
!     if (autoscale_lz & 1) {
  	*z_min = (is_log_z ? pow(base_log_z, lzmin) : lzmin);
      } else {
  	*z_min = zmin;
+     }
+     if (autoscale_lz & 2) {
+ 	*z_max = (is_log_z ? pow(base_log_z, lzmax) : lzmax);
+     } else {
  	*z_max = zmax;
      }
  }
***************
*** 4329,4331 ****
--- 4505,4551 ----
  	return(0);		/* success */
  	}
  #endif
+ 
+ int 
+ get_time_data(line,maxcol,cols,types,x,y,z)
+ char *line;
+ int maxcol, *cols, *types;
+ double *x, *y, *z;
+ {
+ 	register int m, n, linestat;
+ 	double val[3];
+ 	char *s;
+ 	static struct tm tm;
+ 
+ 	linestat = 1;
+ 	m = n = 0;
+ 	s = line;
+ 	while ((linestat == 1) && (n<maxcol)) {
+ 		while (isspace(*s)) s++;
+ 		if (*s == '\0') {
+ 			linestat = 0;
+ 			break;
+ 		}
+ 		n++;
+ 		if (n == cols[m]) {
+ 			if ( types[m] ) {
+ 				s = (char *) gstrptime(s,timefmt,&tm); 
+ 				val[m] = (double) gtimegm(&tm);
+ 				m++;
+ 			} else if (isdigit(*s) || *s=='-' || *s=='+' || *s=='.') {
+ 				val[m] = atof(s);
+ 				m++;
+ 			}
+ 			else
+ 				linestat = 2;	/* abort the line non-digit in req loc */
+ 		}
+ 		while ((!isspace(*s)) && (*s != '\0')) s++;
+ 	}
+ 	if ( m > 0 )
+ 		*x = val[0];
+ 	if ( m > 1 )
+ 		*y = val[1];
+ 	if ( m > 2 )
+ 		*z = val[2];
+ 	return(m);
+ }


