/*
 * Copyright (C) 1994 by Steve Cumming (stevec@geog.ubc.ca)
 *
 * Permission to use, copy, modify, and distribute this software 
 * for any purpose and without fee is hereby granted, provided
 * that the above copyright notices appear in all copies and that both the
 * copyright notice and this permission notice appear in supporting
 * documentation.  This software is provided "as is" without express or
 * implied warranty.
 */


#ifndef MAP_SYS
#define MAP_SYS

/*
  this file tries to handle all system dependent declarations.
  It sort of works on a PC under MS-DOS, a  SPARC 1+ and 
  a PC  running OS/2.
*/



#ifdef __GCC__
#define __sys_stdtypes_h
#endif
/*
	These should eventually be set in the Makefile
*/

#ifdef __TURBOC__
#include <stdlib.h>
#include <values.h>
#include <alloc.h>
#ifndef NULL
#if defined(__TINY__) || defined(__SMALL__) || defined(__MEDIUM__)
#define	NULL	0
#else
#define	NULL	0L
#endif 
#endif /* NULL */
typedef long int longint;
#define min(a,b) (((a) < (b))?(a) : (b))
#define max(a,b) (((a) < (b))?(b) : (a))
#define abs(a) (((a) < 0)?(-a) : (a))
#endif /* __TURBOC__ */

#ifdef MSC
#include <stdlib.h>
#include <float.h>
#include <stddef.h>
#include <limits.h>
#ifndef NULL
#if defined(__TINY__) || defined(__SMALL__) || defined(__MEDIUM__)
#define	NULL	0
#else
#define	NULL	0L
#endif 
#endif  /* NULL */
typedef long int longint;
#endif  /* MSC */

#ifdef UNIX
#ifndef __GCC__
#include <stdlib.h>
#endif
#include <limits.h>
#define min(a,b) (((a) < (b))?(a) : (b))
#define max(a,b) (((a) < (b))?(b) : (a))
/*
#define abs(a) (((a) < 0)?(-a) : (a))
typedef int longint;
typedef long fpos_t;
*/
#endif /* UNIX */

typedef int BOOLEAN;

#ifdef MSDOS
#define HERE ".\\"
#define PATHSEP "\\"
#else
#define HERE "./"
#define PATHSEP "/"
#endif /*  MSDOS */

#ifdef vms
#define OS "VMS "
#endif

#ifdef UNIX
#define OS "unix "
#endif

#ifdef MSDOS
#define OS "MS-DOS "
#endif

#ifndef OS
#define OS ""
#endif

/* The following needs some work *.


/*
 * If you're memcpy() has another name, define it below as bcopy() is.
 * If you don't have a memcpy():
#define NOCOPY
 */

/* these are specific to Steve's 286 */
#ifdef __TURBOC__ 
#undef NOCOPY
#undef BCOPY
#define BZERO
#endif

#ifdef MSC 
#undef NOCOPY
#undef BCOPY
#define BZERO
#endif /* MSC */

#ifdef UNIX
#define BZERO
#endif

#ifdef BCOPY
#define memcpy(dest,src,len) bcopy(src,dest,len)
#endif /* BCOPY */

#ifdef vms
#define memcpy(dest,src,len) lib$movc3(&len,src,dest)
#endif /* vms */

/*
 * If you don't have BZERO, define it below.
 */
#ifndef BZERO
#define bzero(dest,len)  (void)(memset(dest, (char)NULL, len))
#endif /* BZERO */



#ifdef vms
#define HOME "sys$login:"
#else /* vms */
#ifdef MSDOS
#define HOME "ZELIG"
#else /* MSDOS */
#define HOME "HOME"
#endif /* MSDOS */
#endif /* vms */

#endif /*MAP_SYS*/




