#ifndef lint
static char    *copyright = "Copyright (C) 1994, Steve Cumming";
#endif

/*
 * Copyright (C) 1994 by Steve Cumming (stevec@geog.ubc.ca)
 *
 * Permission to use, copy, modify, and distribute this software 
 * for any purpose and without fee is hereby granted, provided
 * that the above copyright notices appear in all copies and that both the
 * copyright notice and this permission notice appear in supporting
 * documentation.  This software is provided "as is" without express or
 * implied warranty.
 */


#include <stdio.h>
#include <math.h> 

#include "lib.h" 
#include "gp.h" 
#include "array.h"
#include "histgen.h"
#include "nr.h"
#include "getopt.h"
#include "mvalloc.h"

int Debug = 0;

FILE * outfile;
FILE * infile;

extern int optind;

void pad_array_args(struct array **, int);

int Nfiles;
enum DATA_TYPES Type;
int Chi;
int knstrn;
int tok;
char * ofn = NULL;
char * ifn = NULL;

int 
getargs(int argc, char ** argv)
{
    int ch;
    char * str;
    ifn = ofn  = NULL;
    Type = DOUBLE;
    Chi = 0;
    tok = 0;
    knstrn = -1;
    while ((ch = getopt(argc,argv,"CKt:T:k:o:")) != EOF){
	switch(ch) {
	case 't' :
	    sscanf(optarg, "%d", &tok);
	    break;
	case 'k':
	    sscanf(optarg, "%d", &knstrn);
	    break;	    
	case 'o':
	    ofn = xstrdup(optarg,"damn!");
	    break;
	case 'T':
	    str = xstrdup(optarg,"damn!");
	    Type = type_from_string(str);
	    free((void *)str);
	    break;
	case 'C':
	    Chi = 1;
	    break;
	case 'K':
	    Chi = 0;
	    break;
	default:
	    return 1;
	    /* NOTREACHED */
	    break;
	}
    }
    return 0;
}
		
int
    checkargs(int argc, char ** argv)
{
    if (ofn){
	if ((outfile = fopen(ofn,"w")) == NULL){
	    (void)fprintf(stderr,"could not open %s!\n",ofn);
	    return 1;
	}
    }
    else
	outfile = stdout;

    Nfiles = argc - optind;
    if (Nfiles < 2)
	return 1;
    return 0;
}

#define PROGRAM "ks"
int
useage(void){
    fprintf(stderr,"%s : perform pairwise Chi or K-S tests on files\n",PROGRAM);
    fprintf(stderr,"%s [C|K] [-t tok] [-k deg_freedom] [-o outfile] [-T type] files\n",PROGRAM);
    return;
}

main (int argc, char ** argv) 
{

    struct array * a;
    struct array ** ars;
    double **D, **P;
    double dtmp, ptmp;
    int i,j;

    if (getargs(argc, argv)){
	useage();
	exit(1);
    }
    if (checkargs(argc, argv)){
	useage();
	exit(1);
    }

    /* how many files ? */

    ars = (struct array **)xalloc(Nfiles * sizeof(struct array *),"ks: no memory!\n");

    i = 0;
    for (; optind < argc; optind++){
	if ((infile = fopen(argv[optind],"r")) == NULL){
	    (void)fprintf(stderr,"can't open %s\n",argv[optind]);
	    exit(1);
	}
	a = read_array(Type, infile, tok);
	fclose(infile);
	if (!Chi)
	    sort_array_in_place(a);
	ars[i++] = a;
	fprintf(stdout,"# %d %s\n",i, argv[optind]);
    }
    P = MValloc(MV_DOUBLE,2,Nfiles,Nfiles);
    D = MValloc(MV_DOUBLE,2,Nfiles,Nfiles);
    
    if (Chi)
	pad_array_args(ars,Nfiles);

    for (i = 0; i < Nfiles; i++){
	for (j = 0; j < Nfiles; j++){
	    ptmp = dtmp = 0.0;
	    if (j > i){
		if (Chi)
		    chstwo(ars[i], ars[j], knstrn, &dtmp, &ptmp);
		else	    
		    kstwo(ars[i], ars[j], &dtmp, &ptmp, 0);  /* presorted */
	    }
	    P[i][j] = ptmp;
	    D[i][j] = dtmp;
	}
    }

    fprintf(outfile,"\n#Probabilities\n\n");
    for (i = 0; i < Nfiles; i++){
	for (j = 0; j < Nfiles; j++)
	    fprintf(outfile,"%9.7f  ",P[i][j]);     
	fprintf(outfile,"\n");
    }

    fprintf(outfile,"\n# %s Statistic\n\n",(Chi ? "Chi^2": "K-S"));
    for (i = 0; i < Nfiles; i++){
	for (j = 0; j < Nfiles; j++)
	    fprintf(outfile,"%9.7f  ",D[i][j]);     
	fprintf(outfile,"\n");
    }
    exit(0);
    /* NOTREACHED */
}




void pad_array_args(struct array ** as,int n){
    int i;
    int maxsz = 0;

    for (i= 0;i<n;i++)
	maxsz = max(maxsz,as[i]->n);
    for (i = 0; i < n; i++)
	(void)resize_array(as[i],maxsz);

    return;
}



