#ifndef lint
static char    *copyright = "Copyright (C) 1994, Steve Cumming Thewalt";
#endif

/*
 * Copyright (C) 1994 by Steve Cumming (stevec@geog.ubc.ca)
 *
 * Permission to use, copy, modify, and distribute this software 
 * for any purpose and without fee is hereby granted, provided
 * that the above copyright notices appear in all copies and that both the
 * copyright notice and this permission notice appear in supporting
 * documentation.  This software is provided "as is" without express or
 * implied warranty.
 */

#include <stdio.h>
#include <math.h> 
#include <sys/types.h>
#include <malloc.h>
#include "gp.h" 
#include "lib.h" 
#include "array.h"
#include "histgen.h"
#include "getopt.h"

int Debug = 0;
char * tsdir;
FILE * outfile;
FILE * infile;

int Log, Nbins, Cdf, Pdf, Sum, Csum;
enum DATA_TYPES Type;

char * ofn = NULL;
char * ifn = NULL;
int tok;

int 
getargs(int argc, char ** argv)
{

    int  ch;
    char * str;
    Sum = Log = Nbins = Cdf = Pdf = Csum = 0;
    ifn = ofn  = NULL;
    Type = DOUBLE;
    tok = 0;

    while ((ch = getopt(argc,argv,"Scplsn:t:T:i:o:")) != EOF){
	switch(ch) {
	case 't': 
	    sscanf(optarg, "%d", &tok);
	    break;
	case 'S':
	    Csum = 1;
	    break;
	case 's':
	    Sum = 1;
	    break;
	case 'c':
	    Cdf = 1;
	    break;
	case 'p':
	    Pdf = 1;
	    break;
	case 'l':
	    Log = 1;
	    break;
	case 'n':
	    sscanf(optarg,"%d",&Nbins);
	    break;
	case 'i':
	    ifn = xstrdup(optarg,"damn!");
	    break;
	case 'o':
	    ofn = xstrdup(optarg,"damn!");
	    break;
	case 'T':
	    str = xstrdup(optarg,"damn!");
	    Type = type_from_string(str);
	    free(str);
	    break;
	default:
	    return 1;
	    /* NOTREACHED */
	    break;
	}
    }
    return 0;
}
		
int
    checkargs()
{
    if (Cdf && Pdf) {
	fprintf(stderr,"Can't make both cdf and pdf!\n");
	return 1;
    }

    if (Csum && (Cdf || Pdf)){
	fprintf(stderr, "-S with -c or -p makes no sense\n");
	return 1;
    }

    if (!Log && !Nbins){
	fprintf(stderr,"If not logarithmic, must use -n!\n ");
	return 1;
    }

    if (Log && Nbins){	
	fprintf(stderr,"-n with -l makes no sense!\n");
	return 1;
    }

    if (ifn){
	if ((infile = fopen(ifn,"r")) == NULL){
	    (void)fprintf(stderr,"could not open %s!\n",ifn);
	    return 1;
	}
    }
    else
	infile = stdin;
    if (ofn){
	if ((outfile = fopen(ofn,"w")) == NULL){
	    (void)fprintf(stderr,"could not open %s!\n",ofn);
	    return 1;
	}
    }
    else
	outfile = stdout;
    return 0;
}

#define PROGRAM "hg"
int
useage(void){
    fprintf(stderr,"%s [-s] [-i input] [-o output] {-l | -n nbins} [-c | -p] [-T type] [-t col]\n",PROGRAM);
    fprintf(stderr,"\t -l logscale or else nbins bins\n");
    fprintf(stderr,"\t -p or -c as (cummulative) probability density function\n");
    fprintf(stderr,"\t -s sum, don't just count, binned values\n");
    fprintf(stderr,"\t -S cummulative distribution\n");
    fprintf(stderr,"\t -t which column from file?\n");
    return;
}

main (int argc, char ** argv) 
{

    double mn,mx;
    int nz;
    struct array * a,  * tic;

/*
  args are 

     infile (stdin)
     outfile (stdout)
     type (DOUBLE)
     Log else nbins
     [Cdf | Pdf]
*/


    if (getargs(argc, argv)){
	useage();
	exit(1);
    }
    if (checkargs()){
	useage();
	exit(1);
    }

    a = read_array(Type, infile, tok);
    sort_array_in_place(a);
    mn = get_double_array(a, 0);
    mx = get_double_array(a, a->n - 1);

    if (Log)
	if (mn == 0.0 || mx == 0.0 || (mn < 0.0 && mx > 0.0))
	    fatal("Using logscale with 0.0 in data");

    if (Sum)
	nz = sum_array(a) + .5;
    else
	nz = a->n;

    if (Log){
	if (Sum) 
	    a = log_binify_sum(a, a, mn, mx);
	else
	    a = log_binify(a, mn, mx);
	tic = log_binify(NULL, mn, mx);
    }
    else {
	if (Sum)
	    a = binify_sum(a, a, Nbins, mn, mx);
	else
	    a = binify(a, Nbins, mn, mx);
	tic = binify(NULL, Nbins, mn, mx);
    }

    if (Cdf)
	a = cdf_array_in_place(a, nz);
    else if (Pdf)
	a = pdf_array_in_place(a, nz);
    else if (Csum)
	a = csum_array_in_place(a);
	
    write_array_pair(tic, a, outfile);
    
    exit(0);
    /* NOTREACHED */
}








