/*
 * Copyright (C) 1994 by Steve Cumming (stevec@geog.ubc.ca)
 *
 * Permission to use, copy, modify, and distribute this software 
 * for any purpose and without fee is hereby granted, provided
 * that the above copyright notices appear in all copies and that both the
 * copyright notice and this permission notice appear in supporting
 * documentation.  This software is provided "as is" without express or
 * implied warranty.
 *
 * Some of the structure definitions are under the following copyright:
 */

/* - plot.h */
/*
 * Copyright (C) 1986, 1987, 1990   Thomas Williams, Colin Kelley
 *
 * Permission to use, copy, and distribute this software and its
 * documentation for any purpose with or without fee is hereby granted, 
 * provided that the above copyright notice appear in all copies and 
 * that both that copyright notice and this permission notice appear 
 * in supporting documentation.
 *
 * Permission to modify the software is granted, but not the right to
 * distribute the modified code.  Modifications are to be distributed 
 * as patches to released version.
 *  
 * This software  is provided "as is" without express or implied warranty.
 * 
 *
 * AUTHORS
 * 
 *   Original Software:
 *     Thomas Williams,  Colin Kelley.
 * 
 *   Gnuplot 2.0 additions:
 *       Russell Lang, Dave Kotz, John Campbell.
 * 
 * send your comments or suggest
ions to (pixar!info-gnuplot@sun.com).
 * 
 */

#ifndef GP
#define GP

#include "sys.h"

extern int Debug;

enum DATA_TYPES {INT, FLOAT, DOUBLE, CMPLX, STR, POINTER, GP_ILLEGAL, GP_ARRAY, GP_UNDEF}; 


enum GP_OPS {GP_ADD, GP_MULTIPLY, GP_DIVIDE, GP_SUBTRACT, GP_INCREMENT};

enum GP_RELS {GP_EQ, GP_LT, GP_GT, GP_NE, GP_LE, GP_GE};


struct cmplx {
	double real, imag;
};

struct value {
    enum DATA_TYPES type;
    union {
	int int_val;
	float f_val;
	double d_val;
	struct cmplx cmplx_val;
	char * str_val;
	void * ptr_val;
    }v;
};

#define Int(x) ((x)->v.int_val)
#define Str(x) ((x)->v.str_val)
#define Dbl(x) ((x)->v.d_val)

enum JUSTIFY {
	LEFT, CENTRE, RIGHT
};

struct value * coerce_value(struct value *, enum DATA_TYPES);
char * type_to_string(enum DATA_TYPES);
enum DATA_TYPES type_from_string(char *);
enum DATA_TYPES highest_type(enum DATA_TYPES, enum DATA_TYPES);
char * value_to_string(struct value * );
void  string_to_value(char *, enum DATA_TYPES, struct value *);
struct value * Complex(struct value *, double,double);
struct value * Integer(struct value *, int);
struct value * Float(struct value *,  float);
struct value * Double(struct value *,  double);
struct value * String(struct value *,  char *);
struct value * Pointer(struct value *,  void *);
int eq(struct value *, struct value *);

struct value * new_value(enum DATA_TYPES);
struct value * gp_unary(struct value *, enum GP_OPS);
struct value * gp_binary(struct value * , struct value * , enum GP_OPS);
int gp_rels(struct value *, struct value *, enum GP_RELS);

int is_zero(struct value *);
char * gp_op_to_string(enum GP_OPS);
extern int gp_result_undef;
#endif GP












