#
# $Id: makefile.ami 3.38.2.21 1992/11/24 16:22:20 woo Exp $
#
#
#
#   Makefile for the Amiga             Pat R. Empleo
#                                      Sept 1991
#      SAS C 6.2
#
#   Usage:
#
#      smake -f makefile.sas
#
#

# where to install help file gnuplot.gih
#HELPDEST=GNUPLOT:docs/gnuplot.gih
HELPDEST=TeX:3_3b9/docs/gnuplot.gih

# Where to send email about bugs and comments (locally)
EMAIL="bug-gnuplot@dartmouth.edu"


#
# SAS/C 6.2 compiler options
#
CC     = sc
CFLAGS = def=NOGAMMA def=MEMSET def=MEMCPY def=AMIGA_SC_6_1 math=ieee\
         ign=100 ign=154 ign=85 ign=88 ign=161 data=far code=far opt

#
# SAS/C 6.2 linker options
#
LD   = slink
LOPT = TO GnuPlot LIB LIB:scmieee.lib LIB:sc.lib VERBOSE StripDebug

#
# Terminal (device) support --- see term.h
#
TERMFLAGS = idir=term

#
# List of object files except term.o, version.o
#
OBJS = binary.o bitmap.o command.o contour.o eval.o graphics.o graph3d.o gnubin.o\
       help.o internal.o misc.o parse.o plot.o scanner.o \
             setshow.o specfun.o standard.o util.o

#
# List of sources
#
CSOURCE1 = command.c setshow.c
CSOURCE2 = help.c graphics.c graph3d.c internal.c
CSOURCE3 = misc.c eval.c parse.c plot.c readline.c scanner.c standard.c
CSOURCE4 = bitmap.c term.c util.c version.c
CSOURCE5 = term/amiga.trm term/aed.trm term/cgi.trm term/dumb.trm term/dxf.trm \
        term/dxy.trm term/eepic.trm term/epson.trm term/fig.trm \
        term/hp26.trm term/hp2648.trm term/hpgl.trm term/hpljii.trm \
        term/apollo.trm term/gpr.trm
CSOURCE6 = term/impcodes.h term/imagen.trm term/object.h \
        term/iris4d.trm term/kyo.trm term/latex.trm term/pbm.trm term/pc.trm
CSOURCE7 = term/post.trm term/qms.trm term/regis.trm term/sun.trm \
        term/t410x.trm term/tek.trm term/unixpc.trm term/unixplot.trm \
        term/v384.trm term/x11.trm term/bigfig.trm term/vws.trm gplt_x11.c
CSOURCE8 = contour.c specfun.c

#
# Docs
#
DOCS1 = docs/Makefile docs/README docs/checkdoc.c docs/doc2gih.c \
        docs/doc2hlp.c docs/doc2hlp.com docs/doc2ms.c docs/doc2tex.c \
        docs/gnuplot.1 docs/lasergnu.1 docs/toc_entry.sty \
        docs/titlepage.ms docs/titlepage.tex
DOCS2 = docs/gnuplot.doc
DOCS3 = docs/latextut/Makefile docs/latextut/eg1.plt \
        docs/latextut/eg2.plt docs/latextut/eg3.dat docs/latextut/eg3.plt \
        docs/latextut/eg4.plt docs/latextut/eg5.plt docs/latextut/eg6.plt \
        docs/latextut/header.tex docs/latextut/tutorial.tex \
        docs/latextut/linepoint.plt

#
# Targets
#

.c.o:
  $(CC) $(CFLAGS) $<

default: gnuplot doc

gnuplot: $(OBJS) term.o version.o
        $(LD) LIB:c.o+$(OBJS) term.o version.o $(LOPT)

doc: docs/GnuPlot.gih

docs/GnuPlot.gih: docs/GnuPlot.doc
  doc2gih <docs/GnuPlot.doc >$(HELPDEST)

#
# Dependencies
#
term.o: term.h term.c bitmap.h setshow.h $(CSOURCE5) $(CSOURCE6) $(CSOURCE7)
        $(CC) $(CFLAGS) $(TERMFLAGS) term.c

version.o: version.c
        $(CC) $(CFLAGS) def CONTACT=$(EMAIL) version.c

command.o: command.c help.h setshow.h
        $(CC) $(CFLAGS) cpu=any command.c def HELPFILE="$(HELPDEST)"

binary.o: binary.c
bitmap.o: bitmap.c bitmap.h
contour.o: contour.c
eval.o: eval.c
gnubin.o: gnubin.c
graphics.o: graphics.c setshow.h
graph3d.o: graph3d.c setshow.h
help.o: help.c help.h
internal.o: internal.c
misc.o: misc.c help.h setshow.h
parse.o: parse.c
plot.o: plot.c setshow.h
scanner.o: scanner.c
setshow.o: setshow.c setshow.h
specfun.o: specfun.c
standard.o: standard.c
util.o: util.c

#
# misc
#
clean:
        delete #?.o

veryclean: spotless

spotless:
        delete #?.o gnuplot

