#include <stdio.h>
#include <math.h>
#include "gtplot.h"

main(argc, argv)
int argc;
char *argv[];
{
   FILE *in, *fopen();
   struct termentry *t;

   if (argc > 2) 
      usage();

   if (argc == 0)
      in = stdin;
   else if ((in = fopen (argv[1], "r")) == NULL) {
      fprintf (stderr, "Can't open %s\n", argv[1]);
      exit();
   }

   GToutfile = stdout;
/* 
   still missing the signal handler--especially to make sure we
   always reset the terminal before we leave on the signals that
   gnuplot normally traps (2 of them).
*/
   gt_init_terminal();  /* Hope we set term here--if not need too later. */
   if (!GTterm) {
      fprintf (stderr, "Sorry, unknown terminal type\n");
      exit(1);
   }
   t = &GTterm_tbl[GTterm];
#ifdef WAIT
  gt_test_term(); 
#endif
   bar_graph(in);
   getchar();
   (*t->reset)();
}

bar_graph(in)
FILE *in;
/* 
   Routine to make a bar graph out of a list of points.  The list of
   points come from the file named on the command line.
 
   Parameter:

          in:  Pointer to file descriptor containing list of points.
*/
{
#define MAXBUF 255
   struct termentry *t = &GTterm_tbl[GTterm];
   int *pnum, bar_w, x_loc, height, lcnt, max_points=t->xmax/2;
   int err, i, k, result, bar_cnt=0;
   float *pval, scale, pmax, pmin, dummy;
   char buf[MAXBUF], *malloc();

/* Read everything into an array of floats with room for 10 per line. */
   pval = (float *)malloc (10*sizeof(float)*max_points);
   pnum = (int *)malloc (sizeof(int )*max_points);
   pmin = VERYLARGE;
   pmax = -VERYLARGE;
   err = 0;
   for (lcnt=0; fgets (buf, MAXBUF, in) != NULL; ++lcnt) {
      result = sscanf(buf,"%f %f %f %f %f %f %f %f %f %f %f", 
        &pval[lcnt*10], &pval[lcnt*10+1], &pval[lcnt*10+2], &pval[lcnt*10+3], 
        &pval[lcnt*10+4], &pval[lcnt*10+5], &pval[lcnt*10+6], &pval[lcnt*10+7], 
        &pval[lcnt*10+8], &pval[lcnt*10+9], &dummy);
      if (result > 10) {
         err = 1;
         break;
      }
   /* Find the max and min of the overall array. */
      for (k = 0; k < result; ++k) {
         if (pval[lcnt*10+k] > pmax) pmax = pval[lcnt*10+k];
         if (pval[lcnt*10+k] < pmin) pmin = pval[lcnt*10+k];
      }
      pnum[lcnt] = result;  /* number of items on this line. */
      bar_cnt += result;
      if (bar_cnt > max_points) {
         err = 1;
         break;
      }
   }
   if (bar_cnt >= max_points) {
      fprintf (stderr, "Error on input: more than %d data elements\n", bar_cnt);
      exit(1);
   }
   if (err) {
      fprintf (stderr, "Error on input: line %d\n", lcnt);
      exit(1);
   }

/* Draw the bars represented by the array pval. */
   bar_draw (pval, pnum, lcnt, pmax, pmin);
}


usage()
{
   fprintf (stderr, "usage: bar [file]\n");
   exit(1);
}


#define SOLID

bar_draw (pval, pnum, lcnt, pmax, pmin)
float pval[], pmax, pmin;
int pnum[], lcnt;
/*
   Routine to draw the bars represented by values in array pval.

   Parameters:

         pval: array of groups of points to take as bar heights.

         pnum: array of the number of points in the ith bar group.

         lcnt: number of groups (10 at most per group) of bars to draw.

         pcnt: number of points to draw. 

         pmax: largest value in the pval array.

         pmin: smallest value in the pval array.
*/
{
   int i, j, k, bar_cnt, zero, y_loc, bar_h, bar_w, x_loc;
   float scale, range, yoff=0.0;
   struct termentry *t = &GTterm_tbl[GTterm];

#define GAP (t->v_char/2)  /* Space between bar and top (or bott) of graph. */

/* Compute scaling factor zero point, etc for this bar graph. */
   if (pmin < 0.0) {
   /* Make a gap at the top and at the bottom of the bar graph */
      range = pmax - pmin;
      scale = (t->ymax - 2*GAP)/range;
      zero = (0.0-pmin) * scale + GAP + 0.5;
      yoff = pmin - GAP/scale; 
   }
   else {
   /* Make a gap only at the top of the bar graph */
      range = pmax;
      scale = (t->ymax - GAP)/range;
      zero = 0;
   }

/* Compute the width of the bar graph. */
   for (bar_cnt=i=0; i < lcnt; ++i)
      bar_cnt += pnum[i]+1;

   bar_w = t->xmax/bar_cnt;

/* Compute start of first bar. */
   x_loc = (t->xmax - (bar_cnt-1)*bar_w)/2.0 + 0.5;

#ifdef DEBUG
   for (i=0; i < lcnt; ++i) {
      fprintf (stderr, "%d: pval[%d] = ", pnum[i], i*10);
      for (k=0; k < pnum[i]; ++k) {
         fprintf (stderr, "%f ", pval[i*10+k]);
      }
      fprintf (stderr,"\n");
   }
   fprintf (stderr, "lcnt = %d\t", lcnt);
   fprintf (stderr, "scale = %f\t", scale);
   fprintf (stderr, "pmax = %f\t", pmax);
   fprintf (stderr, "pmin = %f\n", pmin);
   fprintf (stderr, "zero = %d\t", zero);
   fprintf (stderr, "bar_cnt = %d\n", bar_cnt);
   fprintf (stderr, "bar_w = %d\n", bar_w);
   fprintf (stderr, "Hit return\n");
   (void )getchar();
#endif

/* Put device into graphics mode. */
   if (!GTterm_init) {
      (*t->init)();
      GTterm_init = TRUE;
   }
   (*t->graphics)();  /* Default linetype is 0 (solid line) */

/* Draw a box around the plot. */
      (*t->move)(0,0);
      (*t->vector)(0,t->ymax-1);
      (*t->vector)(t->xmax-1,t->ymax-1);
      (*t->vector)(t->xmax-1, 0);
      (*t->vector)(0,0);

/* Draw the zero line. */
      if (zero != 0) {
         (*t->move)(x_loc,zero);
         (*t->vector)(t->xmax-x_loc-1,zero);
      }

/* Draw lcnt bars of bar_h scale*pval[i] and width bar_w. */
   for (i = 0; i < lcnt; ++i) {
      for (k = 0; k < pnum[i]; ++k) {
         bar_h = (int )((scale * (pval[i*10+k] - yoff)) + 0.5);

#ifdef DEBUG
         fprintf (stderr, "bar_h = %d, linetype = %d\n", bar_h, k);
#endif
   
         (*t->move)(x_loc,zero);
         (*t->vector)(x_loc, bar_h);
         (*t->vector)(x_loc+bar_w, bar_h);
         (*t->vector)(x_loc+bar_w, zero);
#ifdef SOLID
         if (k % 6 < 4) {
            for (j=0; j < bar_w; ++j) {
            /* Terminal drivers define points as unsigned int... */
               (*t->move)(x_loc+j,zero);
               if (j % (k % 4 + 1) == 0)
                  (*t->vector)(x_loc+j,bar_h);
            }
         }
         else {
            int lower, upper;
            if (zero < bar_h) {
               lower = zero;
               upper = bar_h;
            }
            else {
               lower = bar_h;
               upper = zero;
            }
            for (j=lower; j < upper; ++j) {
               if (j % (k % 3 + 1) == 0) {
                  (*t->move)(x_loc,j);
                  (*t->vector)(x_loc+bar_w,j);
               }
            }
         }
#endif
         x_loc += bar_w;
      }
      x_loc += bar_w;
   }
/* Back into text mode (to see the plot generated) */
   (*t->text)();

}
