;;;;;;;;;;;;;;;;;;;;;;;;;; -*- Mode: Emacs-Lisp -*- ;;;;;;;;;;;;;;;;;;;;;;;;;;
;; tar.el --- An emacs equivilent to tar
;; Author          : Lynn Slater
;; Created On      : Tue Sep  6 13:39:03 1988
;; Last Modified By: Lynn Slater
;; Last Modified On: Fri Sep  9 07:01:43 1988
;; Update Count    : 12
;; Status          : Unknown, Use with caution!
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Copyright (C) 1988 Lynn Randolph Slater, Jr.
;; This file might become part of GNU Emacs.
;;
;; This file is distributed in the hope that it will be useful,
;; but without any warranty.  No author or distributor
;; accepts responsibility to anyone for the consequences of using it
;; or for whether it serves any particular purpose or works at all,
;; unless he says so in writing.
;;
;; Everyone is granted permission to copy, modify and redistribute
;; this file, but only under the conditions described in the
;; document "GNU Emacs copying permission notice".   An exact copy
;; of the document is supposed to have been given to you along with
;; this file so that you can know how you may redistribute it all.
;; It should be in a file named COPYING.  Among other things, the
;; copyright notice and this notice must be preserved on all copies.

;; call this tar.el

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; This file supports automatic insertion and extraction of "cut here"
;; style embedded files.  I call these "tar" files because this is the
;; within a file equivilent to what I use tar for in a shell.  This
;; facility is good for sending short ascii files in mail messages.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defun insert-tar-file (fname &optional dir)
  "Inserts the named file into the current buffer in a format that
   get-tar-file will understand."
  (interactive "fFile: ")
  (beginning-of-line)
  (setq real-fname (expand-file-name fname (or dir default-directory)))
  (insert "\n-*- File: "
	  fname
	  "\n")
  (if (file-exists-p real-fname)
      (progn (insert-file real-fname)
	     (exchange-point-and-mark))
    (insert "<<File missing>"))
  (insert "\n-*- End File: " fname "\n")
  )

(defun get-tar-file ()
  "Searches in the current buffer for the next tar file and creates it"
  (interactive)
  (if (re-search-forward "^\\-\\*\\- File: \\(.*\\)$" nil t)
      (let ((fname (buffer-substring (match-beginning 1) (match-end 1)))
	    b e str)
	(next-line 1)
	(beginning-of-line)
	(setq b (point))
	(re-search-forward "^\\-\\*\\- End File: \\(.*\\)$")
	(beginning-of-line)
	(setq e (point))
	(setq str (buffer-substring b e))
	(if (and (file-exists-p fname)
		 (not (yes-or-no-p (format "File %s already exists, replace? "
					   fname))))
	    (message "File already exists: %s" fname)
	  (save-excursion
	    (find-file fname)
	    (kill-region 1 (1+ (buffer-size)))
	    (insert str)
	    t)))))


;; The functions in this file pack and unpack files into or from a buffer
(defun create-tar (fnames)
  "Given a list of file names, adds each file into the buffer *tar*,
   The files may be unpacked by extract-tar."
  (switch-to-buffer "*tar*")
  (end-of-buffer)
  (let ((dd default-directory)
	fname)
  (while fnames
    (insert-tar-file (car fnames) dd)
    (setq fnames (cdr fnames))
    )))

(defun extract-tar ()
  "If invoked from a  buffer filled by create-tar, will find all files
   following point and will create their buffers providing that the files
   do not already exist. The buffers must be saved manually; this way you
   have some control over files being created accidentally."
  (interactive)
  (while (get-tar-file))
  (message "Now save the files you want to keep"))
	
      

