;;;;;;;;;;;;;;;;;;;;;;;;;; -*- Mode: Emacs-Lisp -*- ;;;;;;;;;;;;;;;;;;;;;;;;;;
;; file-path.el --- This file contains file functions that I wish were
;;                  in emacs
;; Author          : Lynn Slater
;; Created On      : Fri May 27 08:47:05 1988
;; Last Modified By: Lynn Slater
;; Last Modified On: Tue Oct 18 06:50:21 1988
;; Update Count    : 6
;; Status          : Beta Released
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Copyright (C) 1988 Lynn Randolph Slater, Jr.
;; This file might become part of GNU Emacs.
;;
;; This file is distributed in the hope that it will be useful,
;; but without any warranty.  No author or distributor
;; accepts responsibility to anyone for the consequences of using it
;; or for whether it serves any particular purpose or works at all,
;; unless he says so in writing.
;;
;; Everyone is granted permission to copy, modify and redistribute
;; this file, but only under the conditions described in the
;; document "GNU Emacs copying permission notice".   An exact copy
;; of the document is supposed to have been given to you along with
;; this file so that you can know how you may redistribute it all.
;; It should be in a file named COPYING.  Among other things, the
;; copyright notice and this notice must be preserved on all copies.

;; Make this a file called file-path.el in your path
;; You should byte-compile it.

(defun file-name-in-path (file-name)
  "Searches load-path for the passed file name.
   Returns the expand-file-name of the first found file.
   This is good for finding non .el or .elc data files that might be stored
   along with lisp files."
  (let ((p load-path)
	temp
	(name))

    (while p
      (if (file-exists-p (setq temp (expand-file-name file-name (car p))))
	  (progn
	    (setq name temp)
	    (setq p nil))
	(setq p (cdr p))))
    name))

;;(file-name-in-path "template.eld")
      
(provide 'file-path)
