/* inputline.h -- prototypes for the functions in inputline.c. */

/* Copyright (C) 1993, 1994, 1995 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

/* Written by Tudor Hulubei and Andrei Pitis.  */


#ifndef _GIT_INPUTLINE_H
#define _GIT_INPUTLINE_H


#include "stdc.h"
#include "window.h"


#define IL_RECORD	0
#define IL_PREVIOUS	1
#define IL_NEXT		2


#define IL_DONT_STORE	0
#define IL_DONT_KILL	0
#define IL_STORE	1
#define IL_KILL		2


/* Some #defines used in external input line interfaces.  */
#define IL_FREEZED	 0
#define IL_EDIT		 1
#define IL_MOVE		 2
#define IL_BEEP		 4
#define IL_ERROR	 8
#define IL_SAVE		16

#define IL_ISEARCH_ACTION_FAILED       -1
#define IL_ISEARCH_ACTION_NONE		0
#define IL_ISEARCH_ACTION_DECREASE	1
#define IL_ISEARCH_ACTION_RETRY		2
#define IL_ISEARCH_ACTION_INCREASE	3

#define IL_UPDATE	 1


typedef struct
{
    window_t *win;
    int echo;			/* echo flag.  */
    int error;			/* use error-like output.  */
    int columns;		/* number of columns.  */
    int point;			/* point position.  */
    int mark;			/* mark position.  */
    int length;			/* total length of the input line.  */
    int static_length;		/* static text length.  */
    int dynamic_length;		/* dynamic text length.  */
    int size;			/* current buffer size.  */
    int last_operation;		/* last basic edit operation performed.  */
    char *buffer;		/* buffer.  */
    char *kill_ring;		/* the kill ring :-).  */
    char *history_file;
} input_line_t;


extern input_line_t *il;

extern void il_free __P((input_line_t *));

extern void il_init __P((int, int));
extern void il_end __P(());

extern input_line_t *il_save __P(());
extern void il_restore __P((input_line_t *));

extern int  il_echo __P((int));
extern int  il_is_empty __P(());
extern void il_set_mark __P(());
extern void il_kill_region __P(());
extern void il_kill_ring_save __P(());
extern void il_yank __P(());
extern void il_exchange_point_and_mark __P(());
extern void il_backward_char __P(());
extern void il_forward_char __P(());
extern void il_backward_word __P(());
extern void il_forward_word __P(());
extern void il_beginning_of_line __P(());
extern void il_end_of_line __P(());
extern void il_insert_char __P((char));
extern void il_delete_char __P(());
extern void il_backward_delete_char __P(());
extern void il_backward_kill_word __P(());
extern void il_reset_line __P(());
extern void il_kill_line __P((int));
extern void il_kill_to_beginning_of_line __P(());
extern void il_kill_to_end_of_line __P(());
extern void il_just_one_space __P(());
extern void il_delete_horizontal_space __P(());
extern void il_set_static_text __P((char *));
extern void il_insert_text __P((char *));
extern void il_update_point __P(());
extern void il_update __P(());
extern void il_full_update __P(());
extern int  il_get_contents __P((char **));
extern void il_message __P((char *));
extern void il_set_error_flag __P((int));
extern void il_history __P((int));


#endif	/* _GIT_INPUTLINE_H */
