#ifndef __libgxx_sys_socket_h

extern "C"
{
#ifdef __sys_socket_h_recursive
#include_next <sys/socket.h>
#else
#define __sys_socket_h_recursive
#include <time.h>

#ifdef VMS
#include "GNU_CC_INCLUDE:[sys]socket.h"
#else
#include_next <sys/socket.h>
#endif

#define __libgxx_sys_socket_h 1

// void* in select, since different systems use int* or fd_set*
int       select(int, void*, void*, void*, struct timeval*);

int       accept(int, struct sockaddr*, int*);
int       bind(int, const void*, int);
int       connect(int, struct sockaddr*, int);
int       getsockname(int, struct sockaddr*, int*);
int       getpeername(int, struct sockaddr*, int*);  // 16 Oct 90 Talisman
int       getsockopt(int, int, int, void*, int*);
int       listen(int, int);
int       rcmd(char**, int, const char*, const char*, const char*, int*);
int       recv(int, void*, int, int);
int       recvfrom(int, void*, int, int, void*, int *);
int       recvmsg(int, struct msghdr*, int);
int       rexec(char**, int, const char*, const char*, const char*, int*);
int       rresvport(int*);
int       send(int, const void*, int, int);
int       sendto(int, const void*, int, int, const char*, int);
int       sendmsg(int, const struct msghdr*, int);
int       setsockopt(int, int, int, const char*, int);
int       shutdown(int, int);
int       socket(int, int, int);
int       socketpair(int, int, int, int sv[2]);
#endif
}

#endif
