// This may look like C code, but it is really -*- C++ -*-

/* 
Copyright (C) 1988 Free Software Foundation
    written by Doug Lea (dl@rocky.oswego.edu)

This file is part of GNU CC.

GNU CC is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY.  No author or distributor
accepts responsibility to anyone for the consequences of using it
or for whether it serves any particular purpose or works at all,
unless he says so in writing.  Refer to the GNU CC General Public
License for full details.

Everyone is granted permission to copy, modify and redistribute
GNU CC, but only under the conditions described in the
GNU CC General Public License.   A copy of this license is
supposed to have been given to you along with GNU CC so you
can know your rights and responsibilities.  It should be in a
file named COPYING.  Among other things, the copyright notice
and this notice must be preserved on all copies.  
*/

/*
  arithmetic, etc. functions on built in types
*/


#ifndef _builtin_h
#pragma once
#define _builtin_h 1


typedef void (*one_arg_error_handler_t)(const char*);
typedef void (*two_arg_error_handler_t)(const char*, const char*);



#include <stddef.h>
#include <std.h>
#include <math.h>

long         abs(long);
double       abs(double);
void         clearbit(long&, long);
void         setbit(long&, long);
int          testbit(long, long);
int          even(long);
long         gcd(long, long);
long         lg(long); 
long         lcm(long, long);
int          odd(long);
double       pow(double, long);
long         pow(long, long);
int          sign(long);
int          sign(double);
long         sqr(long);
double       sqr(double);
long         sqrt(long);

double       start_timer();
double       return_elapsed_time(double);

char*        itoa(long x, int base = 10, int width = 0);
char*        itoa(unsigned long x, int base = 10, int width = 0);
char*        itoa(long long x, int base = 10, int width = 0);
char*        itoa(unsigned long long x, int base = 10, int width = 0);
char*        dtoa(double x, char cvt = 'g', int width = 0, int prec = 6);

char*        hex(long x, int width = 0);
char*        hex(unsigned long x, int width = 0);
char*        oct(long x, int width = 0);
char*        oct(unsigned long x, int width = 0);
char*        dec(long x, int width = 0);
char*        dec(unsigned long x, int width = 0);

char*        form(const char* fmt ...);
char*        chr(char ch);
char*        str(const char* s, int width = 0);

unsigned int hashpjw(const char*);
unsigned int multiplicativehash(int);
unsigned int foldhash(double);

extern void default_one_arg_error_handler(const char*);
extern void default_two_arg_error_handler(const char*, const char*);

extern two_arg_error_handler_t lib_error_handler;

extern two_arg_error_handler_t 
       set_lib_error_handler(two_arg_error_handler_t f);

//#ifdef __OPTIMIZE__

inline double abs(double _arg) 
{
  return (_arg < 0.0)? -_arg : _arg;
}

inline long abs(long _arg) 
{
  return (_arg < 0)? -_arg : _arg;
}

inline int sign(long _arg)
{
  return (_arg == 0) ? 0 : ( (_arg > 0) ? 1 : -1 );
}

inline int sign(double _arg)
{
  return (_arg == 0.0) ? 0 : ( (_arg > 0.0) ? 1 : -1 );
}

inline long sqr(long _arg)
{
  return _arg * _arg;
}

inline double sqr(double _arg)
{
  return _arg * _arg;
}

inline int even(long _arg)
{
  return !(_arg & 1);
}

inline int odd(long _arg)
{
  return (_arg & 1);
}

inline long lcm(long _x, long _y)
{
  return _x / gcd(_x, _y) * _y;
}

inline void setbit(long& _x, long _b)
{
  _x |= (1 << _b);
}

inline void clearbit(long& _x, long _b)
{
  _x &= ~(1 << _b);
}

inline int testbit(long _x, long _b)
{
  return ((_x & (1 << _b)) != 0);
}

//#endif

#endif
