.TH StringEdit 3I "11 December 1987" "InterViews" "InterViews Reference Manual"
.SH NAME
StringEdit \- single line interactive string editor
.SH SYNOPSIS
.B #include <InterViews/Text/stringedit.h>
.SH DESCRIPTION
StringEdit is an interactor that provides a convenient mouse-based
interactive editor for text strings, suitable for incorporation into other
components such as dialog boxes.  The StringEdit class implements
cut\-and\-paste style editing with a clipboard shared by all its instances,
thus allowing text to be transferred between instances.  A set of control
characters is mapped into common editing operations.
StringEdit works with either fixed width or proportionally spaced fonts.
.SH EDITING MODEL
Text is selected with the mouse (augmented by chording with the SHIFT key)
or with the keyboard.
A single click selects a new insertion point between
characters.  A shifted click extends an existing selection.  A double click
selects a whole word (bounded by space characters), and a shifted double
click selects the whole string.  Dragging across the text selects a range of
characters.  Keyboard commands are available to extend the selection
backwards by whole words, and to select the entire text.
.P
Editing is performed by selecting, then using the keyboard to
specify the desired action.  Characters not specifically associated with
commands are inserted into text in place of the text specified by the
current selection.  The replaced text is lost, and the selection becomes an
insertion point following the inserted character.
Commands currently defined include the following.
.TP
.B "Copy (^C)"
Copy the text specified by the selection to the clipboard, discarding
the previous clipboard contents.  The selection is unaffected.
.TP
.B "Cut (^X)"
Cut the text specified by the selection to the clipboard, discarding the
previous clipboard contents.  The selection becomes an insertion point in
place of the deleted text.
.TP
.B "Paste (^V)"
Replace the text specified by the selection with the contents of the
clipboard, which is unchanged.  The selection becomes an insertion point
following the pasted text.
.TP
.B "Left (^B)"
.ns
.TP
.B "Right (^F)"
.ns
.TP
.B "Begin (^A)"
.ns
.TP
.B "End (^E)"
Move the selection one character position to the left or right,
or to the beginning or end of the text.
.TP
.B "Erase (^H, DEL)"
.ns
.TP
.B "Delete (^D)"
Delete the text of the current selection, without saving it in the
clipboard.  If the selection is an insertion point, delete the previous
character (Erase) or the next character (Delete) instead.
.TP
.B "SelectAll (^U)"
.ns
.TP
.B "SelectWord (^W)"
Select the entire text, or extend the selection to the left by one whole
word.  These commands enable common editing operations to be performed
without using the mouse.  For example to replace the previous word in the
text, do a SelectWord and type the new text.
.TP
.B "Restart (^R)"
Restart the edit, throwing away all changes made to the string.  The
clipboard is unchanged.
.TP
.B "Accept (CR)"
Finish the edit.  Note that
a mouse click outside the bounds of the StringEdit object also performs
an Accept.
.SH PUBLIC OPERATIONS
.TP
.B "StringEdit(const char* sample, Painter* = stdpaint, int border = 3)"
Create a new StringEdit object, passing a sample string, 
a painter and a border width.  The shape of the new object is calculated from
the length of the sample string and the font specified by the
painter.
.TP
.B "void SetString(const char* string, boolean select = true)"
Set the initial contents of the edit buffer to \fIstring\fP.
A value of nil leaves
the buffer untouched.  If \fIselect\fP is true, the entire text will be
initially selected, otherwise the selection point will be at the end of the
text.
.TP
.B "char* GetString()"
Allocate and return a new string containing the current contents of the edit
buffer.  It is the caller's responsibility to deallocate the string when it
is no longer required.
.TP
.B "Flash(int period)"
Set the blink period of the insertion point marker to \fIperiod\fP tenths of
a second.  The initial value is five tenths.  A period of zero disables
flashing.
.TP
.B "Extra(int count)"
If the text grows longer than will fit into the available space, the
interactor's shape will be increased by the equivalent of \fIcount\fP
characters, and Change will be called on the parent Scene in an attempt
to allocate more space.  If \fIcount\fP is zero (the initial value),
this action is disabled.
.TP
.B "Handle(Event&)"
Handle the event, and read and process subsequent events until an Accept
command is executed (a Carriage Return is typed or the mouse is clicked
outside the bounds of the StringEdit object).  The event which caused the
Accept is returned in the reference parameter and also put back onto the
event queue.
.SH SEE ALSO
Interactor(2I), Painter(2I)
