.TH StringEditor 3I "23 May 1989" "InterViews" "InterViews Reference Manual"
.SH NAME
StringEditor \- single line interactive string editor
.SH SYNOPSIS
.B #include <InterViews/stringeditor.h>
.SH DESCRIPTION
StringEditor is an interactor that provides a convenient mouse-based
interactive editor for text strings.  It is suitable for incorporation
into other components such as dialog boxes.  Clicking inside the
StringEditor (or calling the Edit function) initiates an edit.
Subsequent keyboard events, which need not be inside the StringEditor,
are interpreted as editing operations on the text.  Typing a carriage
return or clicking outside the StringEdit terminates the edit.
StringEditor works with either fixed width or proportionally spaced
fonts.
.SH EDITING MODEL
Text is selected with the mouse or with the keyboard.  A single click
selects a new insertion point between characters.  Dragging across the
text selects a range of characters.  A set of control characters is
mapped into common editing operations.  A character not specifically
associated with commands is inserted in place of the the current
selection, the replaced text is lost, and the selection becomes an
insertion point following the inserted character.  Commands currently
defined include the following.
.TP
.B "CharacterLeft (^B)"
.ns
.TP
.B "CharacterRight (^F)"
.ns
.TP
.B "BeginningOfText (^A)"
.ns
.TP
.B "EndOfText (^E)"
Move the selection one character position to the left or right,
or to the beginning or end of the text.
.TP
.B "Erase (^H, DEL)"
.ns
.TP
.B "Delete (^D)"
Delete the text of the current selection.  If the selection is an
insertion point, delete the previous character (Erase) or the next
character (Delete) instead.
.TP
.B "SelectAll (^U)"
.ns
.TP
.B "SelectWord (^W)"
Select the entire text, or extend the selection to the left by one
whole word.  These commands enable common editing operations to be
performed without using the mouse.  For example, to replace the
previous word in the text, do a SelectWord and type the new text.
.TP
.B "Accept (CR)"
.ns
.TP
.B "Cancel (^G)"
Finish the edit.
.SH PUBLIC OPERATIONS
.TP
.B "StringEditor(ButtonState*, int accept, int cancel, const char* sample)"
Create a new StringEditor object.  The ButtonState will be used to
communicate the result of editing operations.  If an edit is
terminated by an Accept, the ButtonState will be set to \fIaccept\fP.
If the edit is terminated by Cancel, the ButtonState will be set to
\fIcancel\fP.  The shape of the new object is calculated from the
length of the sample string.
.TP
.B "void Message(const char* text)"
Set the contents of the edit buffer to \fItext\fP.
.TP
.B "void Select(int point)"
.ns
.TP
.B "void Select(int left, int right)"
Select an insertion point or a subrange of the edit buffer.
.TP
.B "void Edit()"
.ns
.TP
.B "void Edit(const char* text, int left, int right)"
Initiate an edit.  Specifying a string and selection range is short
hand for first calling Message and Select with the corresponding
parameters.
.TP
.B "const char* Text()"
Return the current value of the edit buffer.  Note that this buffer is
owned by the StringEditor, and that its contents are subject to
change.  It is the caller's responsibility to copy the string if the
value will be needed in the long term.
.TP
.B "Handle(Event&)"
Handle the event, and read and process subsequent events until an
Accept or Cancel command is executed or a down click occurs outside
the StringEditor's bounds.
.SH PROTECTED OPERATIONS
.TP
.B "virtual boolean HandleChar(char)"
.ns
.TP
.B "void InsertText(const char* text, int length)"
Subclasses of StringEditor can perform additional processing on the
edit buffer.  For instance, an editor for file names might do file
name completion, or an editor for numeric input might check the
validity of the string as it is entered.  Derived classes should
redefine the virtual function HandleChar as required.  HandleChar
should return true to indicate that the edit is completed, or false
otherwise.  InsertText can be used to insert text into the edit
buffer, replacing any currently selected text.
.SH SEE ALSO
Interactor(2I), Button(3I)
