.TH Menu 3I "15 June 1987" "InterViews" "InterViews Reference Manual"
.SH NAME
Menu, HMenu, VMenu, MenuItem, TextItem \- menu and item interactors
.SH SYNOPSIS
.B #include <InterViews/menu.h>
.SH DESCRIPTION
A menu is an interactor that displays a list of items and selects
an item based on the position of the pointing device.
Items in a menu are arranged vertically in a box.
.B HMenu
is a subclass whose items are arranged horizontally.
.PP
Each item in a menu is also an interactor.
.B MenuItem
is a class of interactors that highlight themselves when the pointing device
enters their canvas, and unhighlight themselves
when the pointing device leaves their canvas.
A public \fItag\fP field of MenuItem contains an integer that
typically determines the item's associated operation.
.B TextItem
is a subclass of
.B MenuItem
that displays a string of characters.
.SH PUBLIC OPERATIONS
.TP
.B "Menu(boolean persistent = true)"
.ns
.TP
.B "HMenu(boolean persistent = true)"
Construct a new menu.
If \fIpersistent\fP is true
the menu will remain visible when the mouse leaves its area,
otherwise the menu will disappear.
A string can be passed as the first argument
to name the menu to allow the user to customize its appearance.
.TP
.B "Insert(MenuItem*)"
Add a new item to the menu.
.TP
.B "Change(MenuItem*)"
Notify the menu that an item's shape has changed.
.TP
.B "Remove(MenuItem*)"
Eliminate an item from the menu.
.TP
.B "void Compose()"
After all the items in a menu have been inserted,
Compose builds the box representation of the menu.
.TP
.B "void Popup(Event&, MenuItem*&)"
Insert the menu into the root scene centered around the coordinates
associated with the event and
read events until a button is released.
When the target of an event is a menu item, it is marked
as the selected item and passed the event.
Events for other interactors are ignored.
The menu is removed from the root scene when the button is released.
The interactor argument to Popup is set
to the selected menu item or nil if none.
.TP
.B "void GetSelection(MenuItem*&)"
GetSelection returns the currently selected item.
.TP
.B "void Handle(Event&)"
The Handle operation reads events
until a button is released, passing the events
to the appropriate menu items.
Handle sets the currently selected menu item to the event's target.
.TP
.B "MenuItem(int = 0)"
Construct a new item with the given tag.
.TP
.B "TextItem(const char*, int = 0)"
Construct a text item with the string and tag.
The string will be centered in the canvas.
.SH SEE ALSO
Interactor(3I)
