.TH Event 3I "11 December 1987" "InterViews" "InterViews Reference Manual"
.SH NAME
Event \- input events
.SH SYNOPSIS
.B #include <InterViews/event.h>
.SH DESCRIPTION
Events represent user input.
The \fItarget\fP field of an event
indicates the interactor whose current sensor
is interested in the event.
For keyboard and button events,
the \fItimestamp\fP field indicates when the event occured and
the (\fIx\fP,\ \fIy\fP) fields contain the coordinates of
the input pointing device relative to the target interactor.
The \fIeventType\fP field specifies what kind of event occurred.
The following types of events are possible:
.TP
.B MotionEvent
The position of the pointing device changed.
.TP
.B DownEvent
.ns
.TP
.B UpEvent
The \fIbutton\fP field identifies a button that was pressed or released.
The constants LEFTMOUSE, MIDDLEMOUSE, and RIGHTMOUSE identify
up to three buttons on the pointing device.
The fields \fIleftmouse\fP, \fImiddlemouse\fP, and \fIrightmouse\fP
are \fItrue\fP if the corresponding button is currently down as well
(so chording can be handled).
.TP
.B KeyEvent
A key is pressed.
Since many keyboards do not support up events for arbitrary keys;
no event is generated when the key is released.
The \fIbutton\fP field contains the key code.
The \fIkeystring\fP field points to
a string of length \fIlen\fP that represents
the ASCII mapping of the key.
The fields \fIcontrol\fP, \fImeta\fP, \fIshift\fP, and \fIshiftlock\fP
are \fItrue\fP if the corresponding key is currently down.
.TP
.B OnEvent
.ns
.TP
.B OffEvent
The pointing device enters or leaves the canvas associated with
the target interactor.
.TP
.B ChannelEvent
Data is available on the file descriptors identified
in the \fIchannel\fP field.
The field is a bitset, with bit 0 set if data is ready
on file descriptor 0, bit 1 set if data ready on file descriptor 1, etc.
.TP
.B TimerEvent
The time limit defined by the sensor has expired without any
input events occurring.
.SH PUBLIC OPERATIONS
.TP
.B "void GetAbsolute(Coord& x, Coord& y)"
.ns
.TP
.B "void GetAbsolute(World*&, Coord& x, Coord& y)"
GetAbsolute computes the event coordinates relative to the root scene and
optionally assigns a pointer to that root scene.
.SH SEE ALSO
Sensor(3I), World(3I)
