.TH gbench 1 "1 March 1988" "InterViews" "InterViews Reference Manual"
.SH NAME
gbench \- graphics benchmark
.SH SYNOPSIS
\fBgbench\fP [-\fIcommandname\fP [\fIparameters\fP]]*
.SH DESCRIPTION
\fIGbench\fP is a graphics benchmark tool.  It currently supports 2D
immediate-mode graphics and runs on top of the X Window System, both Version 10
and Version 11.  It is written in C and it directly calls the low-level window
system client library; no toolkit is used.
.PP
When \fIgbench\fP starts, it creates a window and begins processing
commands.  You may supply any number of commands as arguments to the
program.  Once these commands have been processed, commands are read from
standard input, one per line.  Each command directs \fIgbench\fP to
repeatedly perform a particular drawing operation.  \fIgbench\fP copies the
command to the outfile (default:  standard output), executes the command,
and prints on the outfile the host load average, the time for each
iteration, and the number of iterations per second.
.PP
All times are measured in real (wall-clock) time.  You should establish that
the host(s) and network (if used) are unloaded so that valid numbers may be
obtained.
.PP
When \fIgbench\fP performs a sequence of drawing operations, each operation
is shifted by one pixel in x and y from the previous one.  This shifting
goes back and forth over a user-definable range (default: 32 pixels), the
intent being to average out the effects of pixel alignment in the frame
buffer.  Pixel alignment can affect the performance of many graphics
systems, both low-end memory-mapped frame buffers and high-end systems with
interleaved pixel processors.
.PP
You can use \fIgbench\fP either interactively, by typing
commands and viewing the results immediately, or in batch mode,
with standard input redirected to a script file and output
redirected to a log file.  To avoid cluttering up the log when
output is redirected to a file, certain outputs that are only useful in
interactive use are directed to standard error rather than the outfile.
.PP
\fBCommands\fP
.PP
Each command consists of a command name followed by zero or more optional
parameters separated by white space.  You may abbreviate command names to
their smallest unique prefix.  Ambiguous command names are resolved to the
first matching name.  Any command name may be prefixed with the @ character,
which forces all output from the command to standard error rather than
the outfile.  This is useful for preventing selected commands from
going into a log file.
.PP
The optional parameters consist of zero or more positional parameters of the
form \fIvalue\fP, followed by zero or more keyword parameters of the form
\fIname\fP=\fIvalue\fP.  Each positional parameter has a name and may be
specified in keyword form as well.  The positional form is more convenient
for interactive input, while the keyword form is more suited for creating
self-documenting script files.
.PP
To provide values for parameters that are not specified in a command,
\fIgbench\fP maintains a set of global defaults that may be displayed and
changed using the 'default' command.  Each default value has a name and may
be overridden in a command using a \fIname\fP=\fIvalue\fP parameter.
The names of all global default values are given below.  The
'init' command restores all global defaults to their initial values.
.PP
The first positional parameter for each command is \fIopts\fP.  It is a
comma-separated list of option flags, the meanings of which are described
below.  Option flags may be supplied in any order.  If the \fIopts\fP
parameter is given in positional form, the global default option list is
prepended to the given list; if it is given in keyword form, the given
list is used as is, overriding the global default option list.
.PP
The commands are:
.TP
arc [\fIopts\fP] [\fIsize\fP] [\fIaspect\fP] [\fIangle\fP] [\fIlwidth\fP] [\fIname\fP=\fIvalue\fP]*
Draws an arc of an ellipse.  The ellipse is drawn in a bounding box with an
area of \fIsize\fP squared pixels and a height/width ratio of \fIaspect\fP.
The default value of \fIaspect\fP is 1.0, yielding a circular arc.
The arc begins at the 3 o'clock position and continues counterclockwise for
\fIangle\fP degrees.  This command works only in the X11 version.
.TP
blit [\fIopts\fP] [\fIsize\fP] [\fIoffset\fP] [\fIname\fP=\fIvalue\fP]*
Copies a square area of the window, \fIsize\fP pixels on a side, to
an area offset by \fIoffset\fP*\fIsize\fP pixels.  The default value for
\fIoffset\fP is 0.5.
.TP
map [\fIopts\fP] [\fIsize\fP] [\fInwin\fP] [\fIname\fP=\fIvalue\fP]*
Maps and then unmaps \fInwin\fP square subwindows, each \fIsize\fP
pixels on a side.
.TP
nop [\fIopts\fP] [\fIname\fP=\fIvalue\fP]*
Performs a window server no-op.  This command works only in the X11 version.
.TP
point [\fIopts\fP]
Draws a point.  This command works only in the X11 version.
.TP
poly [\fIopts\fP] [\fIsize\fP] [\fInvert\fP] [\fIlwidth\fP] [\fIname\fP=\fIvalue\fP]*
Draws a polygon with the specified number of vertices and linewidth,
inscribed in a circle of radius \fIsize\fP pixels.
.TP
rect [\fIopts\fP] [\fIsize\fP] [\fIlwidth\fP] [\fIname\fP=\fIvalue\fP]*
Draws an axis-aligned square, \fIsize\fP pixels on a side, with the specified
linewidth.
.TP
text [\fIopts\fP] [\fInchar\fP] [\fIptsize\fP] [\fIname\fP=\fIvalue\fP]*
Draws a text string with the specified number of characters, at the
specified point size.  The closest available point size is chosen.
.TP
vec [\fIopts\fP] [\fIsize\fP] [\fIangle\fP] [\fIlwidth\fP] [\fIname\fP=\fIvalue\fP]*
Draws a vector \fIsize\fP pixels long, with the specified linewidth and
angle (given in degrees counterclockwise from the 3 o'clock position).
.TP
config
Prints the host name, display name, window system version, current time,
and tag (see below) on the outfile.
.TP
defaults [\fIname\fP=\fIvalue\fP]*
Prints the defaults on standard error and optionally changes them.  The
names of the default values are given below.
.TP
help
Prints a help message on the outfile listing the available commands and
option flags.
.TP
init
Restores all defaults to their initial value, and prints the updated
set of values on standard error.
.TP
script [\fIfilename\fP]
Run the given script file, which may itself use the 'script' command.  If
no file is given, the built-in script is run.
.TP
quit
Exits \fIgbench\fP.
.TP
!
Repeat:  Re-issue the previous drawing command, with parameters defaulting
to the values used when that command was executed, rather than to the global
default values.  Positional and keyword parameters for the command may be
given in the normal manner to override the defaults.  As usual, if the
\fIopts\fP parameter is given in positional form, the default option
list is prepended to the given list, whereas if it is given in keyword
form, the given list overrides the default option list.
.TP
#
Comment:  causes \fIgbench\fP to write the rest of the command to
the outfile. This is useful for putting comments in script files.  After
echoing and executing each command, \fIgbench\fP writes a result line
to the outfile.  Since each result line begins with the comment
character, \fIgbench\fP output logs are also valid \fIgbench\fP input
scripts.  You can run a log through \fIgbench\fP several times using
different hardware configurations.  In the resulting log, each command
will be followed by a series of result lines, one for each configuration.
.PP
\fBOptions\fP
.PP
The option flags are as follows:
.TP 8
ac
Alternate the drawing color between black and white on each drawing
operation.  This measures the effect of changing one element of the
graphics state for each drawing operation.
.TP
af
Use a separate text item, with its own font identifier, for each character
in the 'text' command.  The same font is used for all characters.  This
option works only in the X11 version.
.TP
ag
Alternate the graphics context on each drawing operation.  The two graphics
contexts used are identical except that one draws with white and the other
draws with black.  The ac and ag flags can be used to compare the cost of
changing one element of the graphics state with the cost of swapping the
entire graphics state.
.TP
aw
Alternate windows on each drawing operation.  This flag makes it possible
to measure the performance impact of context-switching between windows.
It is important to keep this overhead low in order to support applications
that do real-time drawing in multiple windows simultaneously.
.TP
d
Dragging.  You are prompted to move the mouse around in the window while
holding down a mouse button.  Every time a mouse motion event is received,
\fIgbench\fP draws a background-color rectangle to erase the results of the
previous drawing operations, then performs one drawing iteration.  This
option allows you to measure the frame rate that the system can achieve
during interactive animation.
.TP
f
Fill the arc, polygon, or rectangle with a solid color.
.TP
i
Draw by inverting pixel values rather than painting.  This measures
the additional cost of reading pixels from the frame buffer before writing.
.TP
m
Monitor for profiling.  Profiling information is accumulated while this
command is executing.  If \fIgbench\fP has been compiled and linked for
\fIgprof\fP profiling, this information is written to the file "gmon.out"
in the current directory when \fIgbench\fP exits.
.TP
n
No options.  If you choose no options and you supply \fIopt\fP as
a positional parameter, you must use the n flag as a placeholder.
.TP
o
Overlap the object being drawn with a very small window.  The overlapping
window is made small to avoid a significant change in the number of pixels
drawn.  This measures the cost of clipping.
.TP
os
Use an offscreen pixel map identical in size and depth to the graphics window
as the source for blits.  This option works only in the X11 version.
.TP
od
Use an offscreen pixel map identical in size and depth to the graphics window
as the destination for drawing operations.  After the command has been
completed and timed, the contents of the offscreen pixel map are blitted
into the graphics window so correct drawing can be verified.  This option
works only in the X11 version.  Together, the os and od options allow you
to measure the performance impact of offscreen rendering and the cost
of moving pixels to and from offscreen memory.
.TP
p
Polling.  Used in conjunction with the d flag, this flag specifies that
\fIgbench\fP should loop continuously, reading the mouse position and
performing a drawing iteration, rather than responding to mouse motion
events.  This measures the performance difference between polling and
event-driven input.
.TP
ps
Polygon self-intersecting.  Draw a polygon with the same vertices and number
of edges as usual, but self-intersecting.  \fInvert\fP will be rounded up
to an odd number if necessary.
.TP
pw
Fill polygons using the non-zero winding number rule rather than the
default even-odd rule.  This option works only in the X11 version.
.TP
r
Reset defaults.  Copy the set of parameters used in this command to the
set of global defaults.
.TP
s
Use a stipple pattern when drawing.  The stipple pattern is a bitmap that is
tessellated over the drawing area.  When a drawing operation is performed,
the only pixels that are actually drawn are those inside the shape being
drawn that correspond to a '1' in the stipple pattern.  These pixels are
drawn in the foreground color.  Stippling is fully supported only in the X11
version.
.TP
t
Use a tile when drawing.  The tile is a pixel map that is tessellated over
the drawing area.  When a drawing operation is performed, the pixel value
for each pixel inside the shape being drawn is obtained from the tile.
When the s and t flags are used simultaneously, the stipple pattern is used
as a tile, with '0' pixels in the stipple pattern selecting the background
color and '1' pixels selecting the foreground color.  This combination works
only in the X11 version.
.TP
u
Unbatched.  Normally the window system client library will batch many
requests into a single message to the window server in order to minimize
communication overhead.  This option causes the client's request buffer
to be flushed after each operation, thereby preventing batching.  This
makes it possible to directly measure the performance benefit of batching.
.PP
\fBGlobal defaults\fP
.PP
The following global defaults may be displayed and set using the 'defaults'
command:
.TP 8
timegoal
When a command is executed, \fIgbench\fP should repeat the drawing
operation under test enough times to get an accurate measurement of its
cost, but not so many times that the command takes an inordinate amount of
time to execute.  \fIgbench\fP allows you to specify a time goal, which
is the number of seconds that each command should take to execute (default:
1).  \fIgbench\fP performs as many iterations as are necessary to reach
this goal.  Setting timegoal to 0 forces \fIgbench\fP to execute a
single iteration.
.TP
count
Specifies the number of times to perform the primitive drawing operation
on \fIeach\fP iteration.  This defines the unit of work being measured.
For example, to measure the time it takes to draw a 1000-polygon object,
give the command 'p count=1000' and \fIgbench\fP will repeatedly draw
1000 polygons.  To get the feel of dragging around a 1000-polygon object,
give the command 'p d count=1000' and \fIgbench\fP will draw 1000 polygons
every time the mouse moves.  If you want exact control over the number
of drawing operations executed for each command, set \fItimegoal\fP to 0
and set \fIcount\fP as desired.
.TP
angle
The angle in degrees used for the 'arc' and 'vec' commands.
.TP
aspect
A floating point value representing the height to width ratio of the
bounding box for the 'arc' command.  The default value is 1.0, which
yields circular arcs.
.TP
font
A comma-separated list of font names for \fIgbench\fP to load.
In the X11 version, each name may contain the wild-card characters * and ?.
A maximum of 16 fonts may be loaded.
.TP
ptsize
The font size, given in points, used in the 'text' command.
.TP
lwidth
The line width used in the drawing operations.
.TP
maxshift
Each drawing operation is shifted by one pixel in x and y from the previous
operation.  The shifting goes back and forth over a range of \fImaxshift\fP
pixels.
.TP
offset
The 'blit' command multiplies the size of the square being blitted by this
floating point value to determine how far to move it.  The default value
is 0.5, which causes the destination square to overlap the source square.
.TP
nchar
The length in characters of the string drawn by the 'text' command.
.TP
nwin
The number of windows mapped by the 'map' command.
.TP
nvert
The number of vertices drawn by the 'poly' command.
.TP
opts
The option list that is prepended to the option list that is given as
the first positional parameter of a command.  It can be used to run scripts
(including the built-in script) with different lists of options.
.TP
outfile
The name of the file that output is appended to (default:  standard output).
.TP
size
The size in pixels of the objects drawn by the various drawing commands.
.TP
tag
An uninterpreted string that is included in the output of the 'config'
command and at the beginning of each result line.  It is useful for
associating each result line with a named configuration when a log file is
run through \fIgbench\fP several times to accumulate result lines for
different configurations.  For example:

gbench -@d tag=configname <oldlog >newlog

Note the use of the '@' on the 'defaults' command to prevent the tag-setting
command from going into the log.  A suggested tag format is a quadruple of
the form

<\fIrcpu\fP>.<\fIlcpu\fP>.<\fIwsys\fP>.<\fIgxsys\fP>

where \fIrcpu\fP is the type of the remote CPU running \fIgbench\fP (if any),
\fIlcpu\fP is the type of the local CPU running the window server, \fIwsys\fP
is the name of the window system, and \fIgxsys\fP is the type of graphics
hardware being used.  Each of these components can be encoded in two or three
characters.
.TP
winsize
The edge length (in pixels) of the square drawing window.
