//  This file is part of GNU c++-suite.
//  
//  GNU c++-suite is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 1, or (at your option)
//  any later version.
//  
//  GNU c++-suite is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//  
//  You should have received a copy of the GNU General Public License
//  along with GNU c++-suite; see the file COPYING.  If not, write to
//  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

// Check that calls to the correct overloaded virtual
// functions are generated even where the type of the formal
// arguments for the overloadings are similar or related.

int proper_method_called = 0;

struct base {
	int member;
	virtual void method (char)
	{
	}
	virtual void method (char *)
	{
	}
};

struct derived : public base {
	int member;
	virtual void method (char)
	{
	}
	virtual void method (char *)
	{
		proper_method_called++;
	}
};

char *message;

int main ()
{
	derived derived_object;

	derived_object.method (message);
	return (proper_method_called != 1);
}
