//  This file is part of GNU c++-suite.
//  
//  GNU c++-suite is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 1, or (at your option)
//  any later version.
//  
//  GNU c++-suite is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//  
//  You should have received a copy of the GNU General Public License
//  along with GNU c++-suite; see the file COPYING.  If not, write to
//  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

// Check that if a destructor is needed (e.g. at the point
// where an object is destroyed) and that if there is a destructor
// for the class of the object, but it is private, an error message
// is issued.
//
// Note that it is assumed here that the error message issued for
// a local variable of the given class type should be issued for
// the line where the object is declared and *not* on each of the
// lines where the object might be destroyed.
//
// Cases: objects which are:
//	static
//	auto
//	heap

class friendly;

class base
{
	~base();

public:
	int data_member;

	base ();
	friend class friendly;
};

static base static_base_object_1;		// ERROR - cannot destroy
base static_base_object_2;			// ERROR - cannot destroy

void test1 ()
{
	base local_base_object;			// ERROR - cannot destroy
	base *base_ptr = new base;

	local_base_object.data_member = 99;
}
