//  This file is part of GNU c++-suite.
//  
//  GNU c++-suite is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 1, or (at your option)
//  any later version.
//  
//  GNU c++-suite is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//  
//  You should have received a copy of the GNU General Public License
//  along with GNU c++-suite; see the file COPYING.  If not, write to
//  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

// Check that if a class is declared and then subsequently
// a method is defined for that class which was *not*
// present in the original class declaration, that a call
// to the extra (invalid) method for the class produces
// an appropriate compile-time error.

struct c1 {
	int member;
};

void c1::method_1 ()			// ERROR
{
}

void test ()
{
	c1 c1_object;

	c1_object.member = 99;
	c1_object.method_1();		// ERROR
}
