//  This file is part of GNU c++-suite.
//  
//  GNU c++-suite is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 1, or (at your option)
//  any later version.
//  
//  GNU c++-suite is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//  
//  You should have received a copy of the GNU General Public License
//  along with GNU c++-suite; see the file COPYING.  If not, write to
//  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

// Check that bit fields may be accessed.
//
// This caused assembler errors in g++ 1.32 and in gcc 1.32

struct Node {
    union {
	struct {
	    unsigned
	        mark: 1,
                print: 1,
	        type: 6,
	        val: 24;
	} p;
    } uu;
};

typedef struct Node NODE;

inline NODE* newnode(int type, int size)
{
    NODE *nnode;

    type = size;
    nnode = (NODE *) 0xff;
    return (nnode);
}

inline NODE *cons(NODE *x, NODE *y)
{
    NODE *val;

    x = y;
    val = newnode(3,7);
    return (val);
}

void xlbind(NODE *sym, NODE *val, NODE *env)
{
    register NODE* ptr = (NODE*) 99;

    ((NODE*)env)->uu.p.val = (NODE*) ptr;
    ((NODE*)ptr)->uu.p.val = (NODE*) (cons(sym,val)) ;
}

int main ()
{
	return 0;
}
