//  This file is part of GNU c++-suite.
//  
//  GNU c++-suite is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 1, or (at your option)
//  any later version.
//  
//  GNU c++-suite is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//  
//  You should have received a copy of the GNU General Public License
//  along with GNU c++-suite; see the file COPYING.  If not, write to
//  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

// Options: -fall-virtual
//
// Check that the method call operator basically works, and that
// it is *not* applied to either constructor calls or destructor
// calls.

int constructor_calls = 0;
int destructor_calls = 0;
int method_call_operator_calls = 0;
int method_calls = 0;

struct base {
	int base_member;
	void operator->()(int meth_id, int arg_count, ...)
	{
		method_call_operator_calls++;
	}
	base ()
	{
		constructor_calls++;
	}
	~base ()
	{
		destructor_calls++;
	}
	void method ()
	{
		method_calls++;
	}
};

void test ();

base global_base_object;

int main ()
{
	test ();

	// extern printf (const char *, ...);
	// printf ("%d %d %d %d\n", constructor_calls,
	//   destructor_calls, method_call_operator_calls, method_calls);

	return ((constructor_calls != 3)
	     || (destructor_calls !=  2)
	     || (method_call_operator_calls != 3)
	     || (method_calls != 0));
}

base* base_pointer;

void test ()
{
	base local_base_object;

	base_pointer = new base;
	global_base_object.method ();
	local_base_object.method ();
	base_pointer->method ();
	delete base_pointer;
}
