//  This file is part of GNU c++-suite.
//  
//  GNU c++-suite is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 1, or (at your option)
//  any later version.
//  
//  GNU c++-suite is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//  
//  You should have received a copy of the GNU General Public License
//  along with GNU c++-suite; see the file COPYING.  If not, write to
//  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

// Check that it is legal to take the address of an overloaded
// operator (which is class-name-qualified), even if that operator
// could be either a unary or a binary operator, so long as the
// operator designator is unambiguous when class-name-qualified
// (i.e. only one form is declared for the class).
//
// Note that the & operator may be applied to unambiguous qualified
// methods.  It seem that this privledge should extend likewise to
// operators.

class base {
	int field;
public:
	int operator+ (base b);
	int operator- ();
};

int main ()
{
	&base::operator+;	// compile-time error using g++ 1.34.1
	&base::operator-;	// compile-time error using g++ 1.34.1
	return 0;
}

int base::operator+ (base b)
{
	b.field = 7;
	return 0;
}

int base::operator- ()
{
	return 0;
}
