'\"
'\" Copyright 1989 Regents of the University of California
'\" Permission to use, copy, modify, and distribute this
'\" documentation for any purpose and without fee is hereby
'\" granted, provided that this notice appears in all copies.
'\" The University of California makes no representations about
'\" the suitability of this material for any purpose.  It is
'\" provided "as is" without express or implied warranty.
'\" 
'\" $Header: /rel/cvsfiles/devo/tcl/doc/Eval.man,v 1.1.1.1 1992/11/07 04:46:44 zoo Exp $ SPRITE (Berkeley)
'\" 
.\" The definitions below are for supplemental macros used in Sprite
.\" manual entries.
.\"
.\" .HS name section [date [version]]
.\"	Replacement for .TH in other man pages.  See below for valid
.\"	section names.
.\"
.\" .AP type name in/out [indent]
.\"	Start paragraph describing an argument to a library procedure.
.\"	type is type of argument (int, etc.), in/out is either "in", "out",
.\"	or "in/out" to describe whether procedure reads or modifies arg,
.\"	and indent is equivalent to second arg of .IP (shouldn't ever be
.\"	needed;  use .AS below instead)
.\"
.\" .AS [type [name]]
.\"	Give maximum sizes of arguments for setting tab stops.  Type and
.\"	name are examples of largest possible arguments that will be passed
.\"	to .AP later.  If args are omitted, default tab stops are used.
.\"
.\" .BS
.\"	Start box enclosure.  From here until next .BE, everything will be
.\"	enclosed in one large box.
.\"
.\" .BE
.\"	End of box enclosure.
.\"
.\" .VS
.\"	Begin vertical sidebar, for use in marking newly-changed parts
.\"	of man pages.
.\"
.\" .VE
.\"	End of vertical sidebar.
.\"
.\" .DS
.\"	Begin an indented unfilled display.
.\"
.\" .DE
.\"	End of indented unfilled display.
.\"
'\"	# Heading for Sprite man pages
.de HS
.if '\\$2'cmds'       .TH \\$1 1 \\$3 \\$4
.if '\\$2'lib'        .TH \\$1 3 \\$3 \\$4
.if '\\$2'tcl'        .TH \\$1 3 \\$3 \\$4
.if '\\$2'tk'         .TH \\$1 3 \\$3 \\$4
.if t .wh -1.3i ^B
.nr ^l \\n(.l
.ad b
..
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ie !"\\$3"" \{\
.ta \\n()Au \\n()Bu
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp .5
..
.HS Tcl_Eval tcl
.BS
.SH NAME
Tcl_Eval, Tcl_VarEval, Tcl_EvalFile, Tcl_GlobalEval \- execute Tcl commands
.SH SYNOPSIS
.nf
\fB#include <tcl.h>\fR
.sp
int
\fBTcl_Eval\fR(\fIinterp, cmd, flags, termPtr\fR)
.sp
int
\fBTcl_VarEval\fR(\fIinterp, string, string, ... \fB(char *) NULL\fR)
.sp
int
\fBTcl_EvalFile\fR(\fIinterp, fileName\fR)
.sp
.VS
int
\fBTcl_GlobalEval\fR(\fIinterp, cmd\fR)
.VE
.SH ARGUMENTS
.AS Tcl_Interp **termPtr;
.AP Tcl_Interp *interp in
Interpreter in which to execute the command.  String result will be
stored in \fIinterp->result\fR.
.AP char *cmd in
Command (or sequence of commands) to execute.
.AP int flags in
Either \fBTCL_BRACKET_TERM\fR or 0.
If 0, then \fBTcl_Eval\fR will process commands from \fIcmd\fR until
it reaches the null character at the end of the string.
If \fBTCL_BRACKET_TERM\fR,
then \fBTcl_Eval\fR will process comands from \fIcmd\fR until either it
reaches a null character or it encounters a close bracket that isn't
backslashed or enclosed in braces, at which point it will return.
Under normal conditions, \fIflags\fR should be 0.
.AP char **termPtr out
If \fItermPtr\fR is non-NULL, \fBTcl_Eval\fR fills in *\fItermPtr\fR with
the address of the character just after the last one in the last command
successfully executed (normally the null character at the end of \fIcmd\fR).
If an error occurs in the first command in \fIcmd\fR, then \fI*termPtr\fR
will be set to \fIcmd\fR.
.AP char *string in
String forming part of Tcl command.
.AP char *fileName in
Name of file containing Tcl command string.
.BE

.SH DESCRIPTION
.PP
All four of these procedures execute Tcl commands.
\fBTcl_Eval\fR is the core procedure:  it parses commands
from \fIcmd\fR and executes them in
order until either an error occurs or \fBTcl_Eval\fR reaches a terminating
character (']' or '\e0', depending on the value of \fIflags\fR).
The return value from \fBTcl_Eval\fR is one
of the Tcl return codes \fBTCL_OK\fR, \fBTCL_ERROR\fR, \fBTCL_RETURN\fR, \fBTCL_BREAK\fR, or
\fBTCL_CONTINUE\fR, and \fIinterp->result\fR will point to
a string with additional information (result value or error message).
This return information corresponds to the last command executed from
\fIcmd\fR.
.PP
\fBTcl_VarEval\fR takes any number of string arguments
of any length, concatenates
them into a single string, then calls \fBTcl_Eval\fR to
execute that string as a Tcl command.
It returns the result of the command and also modifies
\fIinterp->result\fR in the usual fashion for Tcl commands.  The
last argument to \fBTcl_VarEval\fR must be NULL to indicate the end
of arguments.
.PP
\fBTcl_EvalFile\fR reads the file given by \fIfileName\fR and evaluates
its contents as a Tcl command by calling \fBTcl_Eval\fR.  It returns
a standard Tcl result that reflects the result of evaluating the
file.
If the file couldn't be read then a Tcl error is returned to describe
why the file couldn't be read.
.PP
.VS
\fBTcl_GlobalEval\fR is similar to \fBTcl_Eval\fR except that it
processes the command at global level.
This means that the variable context for the command consists of
global variables only (it ignores any Tcl procedure that is active).
This produces an effect similar to the Tcl command ``\fBuplevel 0\fR''.
.VE
.PP
During the processing of a Tcl command it is legal to make nested
calls to evaluate other commands (this is how conditionals, loops,
and procedures are implemented).
If a code other than
\fBTCL_OK\fR is returned from a nested \fBTcl_Eval\fR invocation, then the
caller should normally return immediately, passing that same
return code back to its caller, and so on until the top-level application is
reached.  A few commands, like \fBfor\fR, will check for certain
return codes, like \fBTCL_BREAK\fR and \fBTCL_CONTINUE\fR, and process them
specially without returning.
.PP
\fBTcl_Eval\fR keeps track of how many nested Tcl_Eval invocations are
in progress for \fIinterp\fR.
If a code of \fBTCL_RETURN\fR, \fBTCL_BREAK\fR, or \fBTCL_CONTINUE\fR is
about to be returned from the topmost \fBTcl_Eval\fR invocation for
\fIinterp\fR, then \fBTcl_Eval\fR converts the return code to \fBTCL_ERROR\fR
and sets \fIinterp->result\fR to point to an error message indicating that
the \fBreturn\fR, \fBbreak\fR, or \fBcontinue\fR command was
invoked in an inappropriate place.  This means that top-level
applications should never see a return code from \fBTcl_Eval\fR other then
\fBTCL_OK\fR or \fBTCL_ERROR\fR.

.SH KEYWORDS
command, execute, file, global, interpreter, variable
