/*******************************************************************
**
** HyperBase was designed and implemented by:
**
**	Uffe Kock Wiil 		(kock@iesd.auc.dk)
**	Claus Bo Nielsen 	(cbn@cci.dk)
**	Carsten Ruseng Jakobsen (ruseng@sun.com)
**	Finn Soelvsten
**	Per Magnus Petersen
**	Poul Larsen
**	Hans Mejdahl Jeppesen
**
** at The University of Aalborg in Denmark autumn 1989, and is provided
** for unrestricted use provided that this legend is included on all
** tape media and as a part of the software program in whole or part.
** Users may copy or modify HyperBase without charge, but are not
** authorized to license or distribute it to anyone else except as part
** of a product or program developed by the user.
**  
** HyperBase IS PROVIDED AS IS WITH NO WARRANTIES OF ANY KIND INCLUDING
** THE WARRANTIES OF DESIGN, MERCHANTIBILITY AND FITNESS FOR A
** PARTICULAR PURPOSE, OR ARISING FROM A COURSE OF DEALING, USAGE OR
** TRADE PRACTICE.
**  
** HyperBase is provided with no support and without any obligation on
** the part of the authors, to assist in its use, correction,
** modification or enhancement.
** 
** THE AUTHORS SHALL HAVE NO LIABILITY WITH RESPECT TO THE INFRINGEMENT
** OF COPYRIGHTS, TRADE SECRETS OR ANY PATENTS BY HyperBase OR ANY PART
** THEREOF.
** 
** In no event will the authors and/or The University of Aalborg be
** liable for any lost revenue or profits or other special, indirect and
** consequential damages, even if the authors and/or The University of
** Aalborg has been advised of the possibility of such damages.
** 
** Please address all correspondence to:
** 
** Uffe Kock Wiil
** Department of Computer Science,
** The University of Aalborg,      Email:  kock@iesd.auc.dk
** Fredrik Bajers Vej 7E,          Phone:  + 45 98 15 42 11 (Ext 5051)
** DK-9220 Aalborg, Denmark.       Fax:    + 45 98 15 81 29
**
*******************************************************************/

%{
#include "config.h"
#include<stdio.h>
#include "y.tab.h"
int yylength;
int value;
int atoi();
int lineno;
%}

%%

[0-9]+				{yylval.value = atoi (yytext, yylength);
							return(HELTAL);}
[ ]*(CONFIG|config) 		{return(CONFIG);}
[ ]*(OPTIONAL|optional)		{return(OPTIONAL);}
[ ]*(SET|set)			{return(SET);}
[ ]*(IN|in)			{return(IN);}
[ ]*(OF|of)                     {return(OF);}
[ ]*(NUMBER|number)		{return(NUMBER);}
[ ]*(LINKPOINTER|linkpointer)   {return(LINKPOINTER);}
[ ]*(DATAPOINTER|datapointer)	{return(DATAPOINTER);}
[ ]*(DATABLOCK|datablock)	{return(DATABLOCK);}
[ ]*(BLOCKPOINTERS|blockpointers) {return(BLOCKPOINTERS);}
[ ]*(INCLUDE|include)		{return(INCLUDE);}
[ ]*(DATANODE|datanode)		{return(DATANODE);}
[ ]*(LINKNODE|linknode)		{return(LINKNODE);}
[ ]*(LINKS|links)               {return(LINKS);}
[ ]*(SIZE|size)			{return(SIZE);}
[ ]*(KEY|key)			{return(KEY);}
[ ]*(TO|to)			{return(TO);}
[ ]*(ID|id)                     {return(ID);}
[ ]*(USERS|users)               {return(USERS);}
[ ]*(VALUE|value)		{return(VALUE);}
[ ]*(SOCKETID|socketid)         {return(SOCKETID);}
[ ]*(DIRECT|direct)             {return(DIRECT);}
([a-zA-Z][a-zA-Z0-9]*) 			{ Symbol *s;
					  if((s=lookup(yytext)) == 0)
					      s = install(yytext, UNDEF, 0.0);
					  else if ( (s->u.val) != 0)
					      execerror("already defined", s->name);
					  yylval.sym = s;
					  return(VAR); }
#.*\n ;
[\n]	                        {lineno++;}

%%
