/*******************************************************************
**
** HyperBase was designed and implemented by:
**
**	Uffe Kock Wiil 		(kock@iesd.auc.dk)
**	Claus Bo Nielsen 	(cbn@cci.dk)
**	Carsten Ruseng Jakobsen (ruseng@sun.com)
**	Finn Soelvsten
**	Per Magnus Petersen
**	Poul Larsen
**	Hans Mejdahl Jeppesen
**
** at The University of Aalborg in Denmark autumn 1989, and is provided
** for unrestricted use provided that this legend is included on all
** tape media and as a part of the software program in whole or part.
** Users may copy or modify HyperBase without charge, but are not
** authorized to license or distribute it to anyone else except as part
** of a product or program developed by the user.
**  
** HyperBase IS PROVIDED AS IS WITH NO WARRANTIES OF ANY KIND INCLUDING
** THE WARRANTIES OF DESIGN, MERCHANTIBILITY AND FITNESS FOR A
** PARTICULAR PURPOSE, OR ARISING FROM A COURSE OF DEALING, USAGE OR
** TRADE PRACTICE.
**  
** HyperBase is provided with no support and without any obligation on
** the part of the authors, to assist in its use, correction,
** modification or enhancement.
** 
** THE AUTHORS SHALL HAVE NO LIABILITY WITH RESPECT TO THE INFRINGEMENT
** OF COPYRIGHTS, TRADE SECRETS OR ANY PATENTS BY HyperBase OR ANY PART
** THEREOF.
** 
** In no event will the authors and/or The University of Aalborg be
** liable for any lost revenue or profits or other special, indirect and
** consequential damages, even if the authors and/or The University of
** Aalborg has been advised of the possibility of such damages.
** 
** Please address all correspondence to:
** 
** Uffe Kock Wiil
** Department of Computer Science,
** The University of Aalborg,      Email:  kock@iesd.auc.dk
** Fredrik Bajers Vej 7E,          Phone:  + 45 98 15 42 11 (Ext 5051)
** DK-9220 Aalborg, Denmark.       Fax:    + 45 98 15 81 29
**
*******************************************************************/

/*******************************************************************
** Class method :
**  fuctions - first()
**           - next(a)
*******************************************************************/

long baltree::first()
{
  return treefirst(root);
}


long baltree::next(long a)
{
  return treenext(root,a,FALSE);
}

/*******************************************************************
** Private fuctions for First & Next
*******************************************************************/

long baltree::treefirst(treelink* TempPtr)
{
  if(TempPtr == 0)
    return 0;
  while(TempPtr->left != 0)
    TempPtr = TempPtr->left;
  return TempPtr->nr;
}

long baltree::treenext(treelink* Input, long a, int found)
{
  long tmp;
  if(Input != 0)
  {
    if((Input->nr != a)&&(!found))
    {
      if(Input->nr > a)
	tmp = treenext(Input->left,a,found);
      else
	tmp = treenext(Input->right,a,found);
    }
    else
    {
      if(Input->nr == a)
      {
	found = TRUE;
	if(Input->right != 0)
	  tmp = treenext(Input->right,a,found);
	else
	  return 0;
      }
      else
      {
	if (Input->left != 0)
	  tmp = treenext(Input->left,a,found);
	else
	  return Input->nr;
      }
    }
    if( (Input->nr > a)&&((Input->nr < tmp)||(tmp==0)))
      return Input->nr;
    else
      return tmp;
  }
  else
    return baltree::first();
}





