;;!emacs
;; $Id: hmh.el,v 1.2 1992/05/14 10:11:11 rsw Exp $
;;
;; FILE:         hmh.el
;; SUMMARY:      Support for Hyperbole buttons in mail reader: Mh.
;; USAGE:        GNU Emacs Lisp Library
;;
;; AUTHOR:       Bob Weiner
;; ORG:          Brown U.
;;
;; ORIG-DATE:    21-May-91 at 17:06:36
;; LAST-MOD:     18-Feb-92 at 03:08:47 by Bob Weiner
;;
;; This file is part of Hyperbole.
;;
;; Copyright (C) 1991, Brown University and the Free Software Foundation, Inc.
;; Developed with support from Motorola Inc.
;; Available for use and distribution under the same terms as GNU Emacs.
;;
;; DESCRIPTION:  
;; 
;;   Automatically configured for use in "hsite.el".
;;   If hsite loading fails prior to initializing Hyperbole Mh support,
;;
;;       {M-x Mh-init RTN}
;;
;;   will do it.
;;
;;
;;     Have not yet overloaded 'mh-yank-cur-msg' to yank and hide
;;   button data from mail reader buffer.
;;     Have not yet overloaded 'mh-insert-letter' to highlight buttons
;;   and to merge its button data.
;;
;; DESCRIP-END.

;;; ************************************************************************
;;; Other required Elisp libraries
;;; ************************************************************************
(require 'hmail)
(load "hsmail")
(require 'mh-e)

;;; ************************************************************************
;;; Public variables
;;; ************************************************************************


;;; ************************************************************************
;;; Public functions
;;; ************************************************************************

(defun Mh-init ()
  "Initializes Hyperbole support for Mh mail reading."
  (interactive)
  (setq hmail:composer  'mh-letter-mode
	hmail:lister    'mh-folder-mode
	hmail:modifier  'mh-letter-mode
	hmail:reader    'mh-folder-mode)
  (var:append 'mh-show-message-hook '(hmail:msg-narrow Mh-hbut-highlight))
  ;;
  ;;
  ;; Setup public abstract interface to Hyperbole defined mail
  ;; reader-specific functions used in "hmail.el".
  ;;
  (rmail:init)
  ;;
  ;; Setup private abstract interface to mail reader-specific functions
  ;; used in "hmail.el".
  ;;
  (fset 'rmail:get-new       'mh-inc-folder)
  (fset 'rmail:msg-forward   'mh-redistribute)
  (fset 'rmail:summ-msg-to   'mh-goto-msg)
  (fset 'rmail:summ-new      'mh-rescan-folder)
  (if (interactive-p)
      (message "Hyperbole MH mail reader support initialized."))
  )

(defun Mh-hbut-highlight ()
  "Highlight any Hyperbole buttons in buffer for which display support exists."
  (if (fboundp 'ep:but-create) (ep:but-create)))

(defun Mh-msg-hdrs-full (toggled)
  "If TOGGLED is non-nil, toggle full/hidden headers, else show full headers.
For now, a no-op."
  )

(defun Mh-msg-narrow ()
  "Narrows mail reader buffer to current message.
This includes Hyperbole button data."
  (Mh-msg-widen))

(defun Mh-msg-next ()           (mh-next-undeleted-msg 1))

(defun Mh-msg-num ()
  "Returns number of mail message that point is within."
  (interactive)
  (mh-get-msg-num nil))

(defun Mh-msg-prev ()           (mh-previous-undeleted-msg 1))

(defun Mh-msg-to-p (mail-msg-id mail-file)
  "Sets current buffer to start of msg with MAIL-MSG-ID in MAIL-FILE.
Returns t if successful, else nil."
  (if (not (file-readable-p mail-file))
      nil
    (find-file mail-file)
    (hmail:msg-narrow)
    (goto-char 1)
    t))

(defun Mh-msg-widen ()
  "Widens buffer to full current message including Hyperbole button data."
  (Mh-to) (widen))

(defun Mh-to ()
  "Sets current buffer to a mail reader buffer."
  (and (eq major-mode 'Mh-folder-mode)
       (set-buffer (Mh-get-buffer Mh-show-buffer))))

(defun Mh-Summ-delete ()        (mh-delete-msg (mh-get-msg-num t)))

(defun Mh-Summ-expunge ()
  (message "(Mh-Summ-expunge: I don't think mh-e has an expunge operator."))

(defun Mh-Summ-goto ()          (mh-goto-msg (mh-get-msg-num nil)))

(defun Mh-Summ-to ()
  "Sets current buffer to a mail listing buffer."
  (let ((summ-buf))
    (save-excursion
      (mapcar '(lambda (window)
		 (if summ-buf
		     nil
		   (set-buffer (window-buffer window))
		   (if (eq major-mode 'Mh-folder-mode)
		       (setq summ-buf (current-buffer)))))
	      (hypb:window-list 'no-mini)))
    (if summ-buf (set-buffer summ-buf))))

(defun Mh-Summ-undelete-all ()
  (message
   "(Mh-Summ-undelete-all: I don't think mh-e has an undelete operator."))

;;; ************************************************************************
;;; Private functions
;;; ************************************************************************
;;;
;;; Overlay version of this function from mh-e.el to run mh-show-message-hook.
(fset 'mh-display-msg (append (symbol-function 'mh-display-msg)
			      '((run-hooks 'mh-show-message-hook))))

;;;
;;; Overlay version of 'mh-regenerate-headers' to highlight Hyperbole
;;; buttons when possible.
;;;
(fset 'mh-regenerate-headers
      (append (symbol-function 'mh-regenerate-headers)
	      '((if (fboundp 'ep:but-create) (ep:but-create)))))

;;;
;;; Overlay 'mh-send-letter' to widen to include button data.
;;;
(defun mh-send-letter (&optional arg)
  "Send the draft letter in the current buffer.
If (optional) prefix argument is provided, monitor delivery.
Run mh-before-send-letter-hook before doing anything."
  (interactive "P")
  (if mh-add-md4-signature
      (mh-add-md4-header))
  (widen)
  (run-hooks 'mh-before-send-letter-hook)
  (set-buffer-modified-p t)		; Make sure buffer is written
  (save-buffer)
  (message "Sending...")
  (let ((draft-buffer (current-buffer))
	(file-name (buffer-file-name))
	(config mh-previous-window-config))
    (cond (arg
	   (pop-to-buffer "MH mail delivery")
	   (erase-buffer)
	   (if mh-send-args
	       (mh-exec-cmd-output "send" t "-watch" "-nopush"
				   "-nodraftfolder" mh-send-args file-name)
	       (mh-exec-cmd-output "send" t "-watch" "-nopush"
				   "-nodraftfolder" file-name))
	   (goto-char (point-max))
	   (recenter -1)
	   (set-buffer draft-buffer))	; for annotation below
	  (mh-send-args
	   (mh-exec-cmd-daemon "send" "-nodraftfolder" "-noverbose"
			       mh-send-args file-name))
	  (t
	   (mh-exec-cmd-daemon "send" "-nodraftfolder" "-noverbose"
			       file-name)))

    (if mh-annotate-char
	(mh-annotate-msg mh-sent-from-msg
			 mh-sent-from-folder
			 mh-annotate-char
			 "-component" mh-annotate-field
			 "-text" (format "\"%s %s\""
					 (mh-get-field "To:")
					 (mh-get-field "Cc:"))))

    (mh-when (or (not arg)
		 (y-or-n-p "Kill draft buffer? "))
      (kill-buffer draft-buffer)
      (if config
	  (set-window-configuration config)))
    (message "Sending...done")))


;;; ************************************************************************
;;; Private variables
;;; ************************************************************************

(provide 'hmh)

