;;!emacs
;;
;; FILE:         hsys-wais.el
;; SUMMARY:      Hyperbole support for WAIS browsing.
;; USAGE:        GNU Emacs Lisp Library
;;
;; AUTHOR:       Bob Weiner
;; ORG:          Brown U.
;; E-MAIL:       rsw@cs.brown.edu
;;
;; ORIG-DATE:     5-Nov-91 at 20:53:26
;; LAST-MOD:     13-Dec-91 at 14:54:00 by Bob Weiner
;;
;; This file is part of Hyperbole.
;; 
;; Copyright (C) 1991, Brown University, Providence, RI
;; Developed with support from Motorola Inc.
;; 
;; Permission to use, modify and redistribute this software and its
;; documentation for any purpose other than its incorporation into a
;; commercial product is hereby granted without fee.  A distribution fee
;; may be charged with any redistribution.  Any distribution requires
;; that the above copyright notice appear in all copies, that both that
;; copyright notice and this permission notice appear in supporting
;; documentation, and that neither the name of Brown University nor the
;; author's name be used in advertising or publicity pertaining to
;; distribution of the software without specific, written prior permission.
;; 
;; Brown University makes no representations about the suitability of this
;; software for any purpose.  It is provided "as is" without express or
;; implied warranty.
;;
;;
;; DESCRIPTION:  
;; DESCRIP-END.

;;; ************************************************************************
;;; Other required Elisp libraries
;;; ************************************************************************

(require 'wais)

;;; ************************************************************************
;;; Public implicit button types
;;; ************************************************************************

(defib wais-smart ()
  "Handles context-sensitive Smart Key in WAIS buffers."
  (let ((b (buffer-name)))
    (and b
	 (cond ((or (string-match "Quick: Find Documents On" b)
		    (equal b "Quick: Similar To"))
		'(wais-query))
	       ((equal "*Source List*" b)
		'(source-menu-view))
	       ((string-match "Quick: On Sources" b)
		(if (eobp) '(wais-view-source) '(source-menu-view)))
	       ((string-match "Quick: Results" b)
		'(wais-edit))
	       ))))

;;; ************************************************************************
;;; Public button action types
;;; ************************************************************************

(defact wais-ques (question-name)
  "Loads a Wais Question QUESTION-NAME, displays it with WAIS Emacs interface."
  (interactive "sWAIS Question name: ")
  (if (or (featurep 'wais) (load "wais"))
      (progn
	(display-question question-name)
	(wais)
	(display-question question-name)
	)
    (error "(wais-ques): WAIS interface not available so can't load question.")
    ))

(defact wais-smart (interactive-func)
  "Performs INTERACTIVE-FUNC in a Wais buffer."
  (call-interactively interactive-func))

(provide 'hsys-wais)
