/* AE program profiling system.
   tm- description file for a MIPS-based system with AE.
   Copyright (C) 1989, 1990 by James R. Larus (larus@cs.wisc.edu)

   AE and AEC are free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the
   Free Software Foundation; either version 1, or (at your option) any
   later version.

   AE and AEC are distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with GNU CC; see the file COPYING.  If not, write to James R.
   Larus, Computer Sciences Department, University of Wisconsin--Madison,
   1210 West Dayton Street, Madison, WI 53706, USA or to the Free
   Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. */


/* $Header: /var/home/larus/AE/AE/config/RCS/tm-mips-ae.h,v 2.1 90/02/14 15:45:00 larus Exp Locker: larus $ */


#include "tm-mips.h"

/* Add -AE flag: */

/* I'm using the version 1.37 SPECs, which are slightly different from
   the 1.36 SPECs */

#undef CC1_SPEC
#define CC1_SPEC   "%{O2:-O -fstrength-reduce -fomit-frame-pointer -mgpOPT}\
                    %{G32: -mG2 -mnG1 }					\
                    %{G32:%{!O2:%eOption -G32 may require -O2}} \
		    %{AE}"

/* Surpress assembler warning: "macro instruction used $at"*/

#undef ASM_SPEC

#define ASM_SPEC   "-nocpp %{AE: -w} %{O: -O2} %{O2: -O2} %{!G32: %{G*}} \
%{!G:%{!G32: -G 8}} %{G32: -G 32}"


/* Link with the AE routines and start at ae_start. */

#undef LIB_SPEC

#define LIB_SPEC "%{AE: -e ae_start aecrt0.o%s} \
%{!p:%{!pg:-lc}}%{p:-lc_p}%{pg:-lc_p}"


/* Should always save and restore R31 since even a leaf procedure may
   call AE_FLUSH_BUFFER. */

#undef MUST_SAVE_REG_LOGUES

#define MUST_SAVE_REG_LOGUES (( frame_pointer_needed && (regno == 30))	\
                              ||( (regno == 31)))
#define AE
