#ifndef IMPORT_H
#define IMPORT_H
/*

  "libimport.a" include file for the Xlogmaster
  
  The libimport.a is basically consists of several functions that I had to grab out
  of the GNU C library because they don't exist on all systems.

  For clean separation between the "real" Xlogmaster source and the imported
  functions I created this directory where the libimport.a is built that is linked
  to the Xlogmaster in the end.

  Currently this supplies the following functions the Xlogmaster uses:

  - getopt_long_only()

  - all REGEXP functions from rx.h - rx.c is only built into libimport.a if it couldn't
  be found on the system to keep the Xlogmaster as small as possible


*/

/*
  first include the data from the configuration package if not done
  so already... we need this to assure the flag NEED_LIBIMPORT is
  being set properly.
*/
#include "../config.h"


#if NEED_IMPORT
/* 
   include file for proper GNUish commandline parsing 
*/
#include "getopt.h"

/* 
   include file for the REGEXP functions from the local system if possible,
   otherwise use our local version of it.
*/
#include "rx.h"

#else
/* 
   include file for proper GNUish commandline parsing 
*/
#include <getopt.h>

/* 
   include file for the REGEXP functions from the local system if possible,
   otherwise use our local version of it.
*/
#include <rx.h>

#endif



#endif /* IMPORT_H */
