# GNU Solfege - eartraining for GNOME
# Copyright (C) 2000, 2001, 2002  Tom Cato Amundsen
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

"""
Only utility functions and classes that are private to the mpd module
should go into this file.
"""
from musicalpitch import MusicalPitch

def int_to_notename(i):
    p = MusicalPitch(0, 0, 0)
    p.set_from_midiint(i)
    return p.str()

def notename_to_int(n):
    p = MusicalPitch(n)
    return p.semitone_pitch()


def semitonepitch_to_ylinepos(i, clef):
    n = MusicalPitch(i)
    return steps_to_ylinepos(n.steps(), clef)

def steps_to_ylinepos(steps, clef):
    return {'treble': 13, #treble and violin are two names for the same clef
            'violin': 13,
            'subbass': -1,
            'bass': 1,
            'baritone': 3,
            'varbaritone': 3,
            'tenor': 5,
            'alto': 7,
            'mezzosoprano': 9,
            'soprano': 11,
            'french': 15}[clef] - steps
    raise "unknown clef"

def notename_to_ylinepos(n, clef):
    n = MusicalPitch(n)
    i = n.steps()
    return steps_to_ylinepos(i, clef)

def an_to_ylinepos(an, clef):
    if an[-2:] == 'es':
        l = 3
        h = -3
    else:
        l = 1
        h = -5
    i = notename_to_ylinepos(an, clef)
    while i > l:
        an = an + "'"
        i =  notename_to_ylinepos(an, clef)
    while i < h:
        an = an + ","
        i = notename_to_ylinepos(an, clef)
    return i

def key_to_accidentals(key):
    i = ['aeses', 'eeses', 'beses', 'fes', 'ces', 'ges', 'des', 'aes',
         'ees', 'bes', 'f', 'c', 'g', 'd', 'a', 'e', 'b', 'fis', 'cis',
         'gis', 'dis', 'ais', 'eis', 'bis'].index(key[0])-11
    if key[1] == 'minor':
        i = i - 3
    if i > 0:
        r = ['fis', 'cis', 'gis', 'dis', 'ais', 'eis',
             'bis', 'fis', 'cis', 'gis', 'dis'][:i]
        m = 'is'
    elif i < 0:
        r = ['bes', 'ees', 'aes', 'des', 'ges', 'ces',
             'fes', 'bes', 'ees', 'aes', 'des'][:-i]
        m = 'es'
    else:
        r = []
    retval = []
    for a in r:
        if a not in retval:
            retval.append(a)
        else:
            del retval[retval.index(a)]
            retval.append(a+m)
    return retval

class DataClass:
    def __init__(self, names):
        self.__dict__['__names'] = names
        for n in names:
            self.__dict__[n] = None
    def __getattr__(self, name):
        if name in self.__dict__.keys():
            return self.__dict__[name]
    def __setattr__(self, name, value):
        if name in self.__dict__['__names']:
            self.__dict__[name] = value
        else:
            print "Trying varibale:", name
            raise "DataClass: variable name not allowed"

