;;; -*-  Mode: Lisp; Package: Maxima; Syntax: Common-Lisp; Base: 10 -*- ;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;     The data in this file contains enhancments.                    ;;;;;
;;;                                                                    ;;;;;
;;;  Copyright (c) 1984,1987 by William Schelter,University of Texas   ;;;;;
;;;     All rights reserved                                            ;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; OPTIONS functions
;;; (c) Copyright 1980, Massachusetts Institute of Technology

(in-package "MAXIMA")

(macsyma-module option)

(DECLARE-TOP(SPECIAL OPTIONS HISTORY CRU CRF)
	 (*EXPR OPTIONS NCDR FULLSTRIP1 RETRIEVE URESTORE NONSYMCHK MDESCRIBE))

(DEFMSPEC $OPTIONS (X) (SETQ X (CDR X))
  (COND ((NULL X)
	 (PRINC "OPTIONS interpreter  (Type `EXIT' to exit.)")
	 (TERPRI) (OPTIONS '$ALL))
	((NONSYMCHK (CAR X) 'OPTIONS))
	(T (CONS '(MLIST) (DOWNS (CAR X))))))

(DEFUN OPTIONS (ANS)
  (DO ((HISTORY)) (NIL)
      (COND ((EQ '$EXIT ANS) (RETURN '$DONE))
	    ((OR (EQ '$UP ANS) (EQ '$BACK ANS))
	     (SETQ ANS (CADR HISTORY) HISTORY (CDDR HISTORY))
	     (DOWN (IF (NULL ANS) '$ALL ANS)))
	    ((EQ '$TOP ANS) (OPTIONS '$ALL))
	    ((ATOM ANS) (DOWN ANS))
	    ((OR (EQ '$DOWN (CAAR ANS)) (EQ '$OPTIONS (CAAR ANS)))
	     (DOWN (CADR ANS)))
	    ((EQ '$DESCRIBE (CAAR ANS)) (MDESCRIBE (DECODE (CADR ANS))))
	    (T (OPT-ERR)))
      (SETQ ANS (RETRIEVE NIL NIL))))

(DEFUN DOWN (NODE &AUX OPTS)
  (SETQ NODE (DECODE NODE) OPTS (DOWNS NODE))
  (COND ((NULL OPTS) (PRINC "No options") (TERPRI))
	(T (SETQ HISTORY (CONS NODE HISTORY) OPTIONS OPTS)
	   (MENU OPTIONS))))

(DEFUN UP (NODE &AUX OPTS)
  (SETQ NODE (DECODE NODE) OPTS (UPS NODE))
  (COND ((NULL OPTS) (PRINC "No options") (TERPRI))
	(T (SETQ HISTORY (CONS NODE HISTORY) OPTIONS OPTS)
	   (MENU OPTIONS))))

(DEFUN DOWNS (NODE) (OLDGET NODE 'SUBC))
(DEFUN UPS (NODE) (OLDGET NODE 'SUPC))

(DEFUN DECODE (NODE)
  (COND ((NOT (INTEGERP NODE)) NODE)
	((OR (ZEROP NODE) (NULL (SETQ NODE (NCDR OPTIONS NODE)))) (NOR-ERR))
	(T (CAR NODE))))

(DEFUN MENU (OPTS)
  (DO ((L OPTS (CDR L)) (I 1 (f1+ I))) ((NULL L))
      (PRINC I) (PRINC " - ") (PRINC (FULLSTRIP1 (CAR L)))
      (COND ((OLDGET (CAR L) 'KIND) (TYO #\SPACE) (PRINC (OLDGET (CAR L) 'KIND))))
      (TERPRI)))


(DEFUN OPT-ERR () (PRINC "Illegal command to OPTIONS") (TERPRI))
(DEFUN NOR-ERR () (PRINC "Number out of range") (TERPRI))

(defmacro subc (a b &rest l)
  `(subc-internal '(,a ,b ,@l)))
(defun subc-internal (x)
  (PUTPROP (CAR X) (CADR X) 'KIND)
  (PUTPROP (CAR X) (CDDR X) 'SUBC))

(defmacro supc (a b &rest l)
  `(supc-internal '(,a ,b ,@l)))
(defun supc-internal (x)
  (PUTPROP (CAR X) (CADR X) 'KIND)
  (PUTPROP (CAR X) (CDDR X) 'SUPC))

(DEFUN PRINTNET () (PRNET '$ALL 0) NIL)
(DEFUN PRNET (NODE INDENT)
  (TERPRI)
  (DO ((I 1 (f1+ I))) ((> I INDENT)) (TYO #\TAB)) (PRINC (FULLSTRIP1 NODE))
  (COND ((OLDGET NODE 'KIND) (TYO #\SPACE) (PRINC (OLDGET NODE 'KIND))))
  (MAPC #'(LAMBDA (L) (PRNET L (f1+ INDENT))) (DOWNS NODE)))

;;Copyright 1980, Massachusetts Institute of Technology
(SUBC $ALL () $INTERACTION $DEBUGGING $EVALUATION $LISTS $MATRICES 
	      $SIMPLIFICATION $REPRESENTATIONS $PLOTTING $TRANSLATION
	      $PATTERN-MATCHING $TENSORS)

(SUBC $ABS (C))

(SUBC $ADDROW (C))

(SUBC $ALARMCLOCK (C))

(SUBC $ALIASES (V))

(SUBC $ALGSYS (C))

(SUBC $ALLROOTS (C))

(SUBC $APPEND (C))

(SUBC $APPENDFILE (C))

(SUBC $APPLY (C))

(SUPC $APROPOS (C) $USER-AIDS $GENERAL-INFO)

(SUBC $ARRAYS () $ARRAY)

(SUBC $ARRAYS (V))

(SUBC $ARRAY (C))

(SUBC $ARRAYINFO (C))

(SUBC $ARRAYMAKE (C))

(SUBC $ASSUME (C))

(SUBC $AT (C))

(SUBC $ATOM (C))

(SUBC $ATVALUE (C))

(SUBC $AUGCOEFMATRIX (C))

(SUBC $AUTOMATIC () $TRIGEXPAND $TRIGINVERSES $TRIGSIGN $EXPONENTIALIZE
                    $LOGARC $DEMOIVRE $LOGEXPAND $RADEXPAND)

(SUBC $BAKSOLVE (C))

(SUBC $BATCH (C))

(SUBC $BATCON (C))

(SUBC $BERN (C))

(SUBC $BERNPOLY (C))

(SUBC $BETA (C))

(SUBC $BFLOAT (C))

(SUPC $BFTRUNC (S) $DISPLAY)

(SUBC $BREAK (C))

(SUBC $CABS (C))

(SUBC $CATCH (C))

(SUBC $CF (C))

(SUBC $CFDISREP (C))

(SUBC $CFEXPAND (C))

(SUBC $CHANGEVAR (C))

(SUBC $CHARPOLY (C))

(SUBC $CHR1 (C))

(SUBC $CHR2 (C))

(SUBC $CHRISTOF (C))

(SUBC $CLOSEFILE (C))

(SUBC $COEFF (C))

(SUBC $COEFMATRIX (C))

(SUBC $COL (C))

(SUBC $COMEXP (C))

(SUBC $COMPILE (C))

(SUBC $CONCAT (C))

(SUBC $COMMAND-FILES (C) $BATCH $BATCON $DEMO)

(SUBC $COMPFILE (C))

(SUBC $COMPLEX () $REALPART $IMAGPART $RECTFORM $POLARFORM $CABS)

(SUBC $CONS (C))

(SUBC $CONSTANTP (C))

(SUBC $CONTENT (C))

(SUBC $CONTRACT (C))

(SUBC $COPYLIST (C))

(SUBC $COVDIFF (C))

(SUBC $COPYMATRIX (C) $RATMX $SPARSE $LISTARITH $DETOUT $DOALLMXOPS
                      $DOMXMXOPS $DOSCMXPLUS $SCALARMATRIXP)

(SUBC $CURVATURE () $SCURVATURE $RIEMANN $RAISERIEMANN $RINVARIANT $WEYL
                    $DSCALAR $DALEM $YT)

(SUBC $DALEM (C))

(SUBC $DEBUGMODE (C))

(SUBC $DECLARE (C))

(SUBC $DEFCON (C))

(SUBC $DEFINE (C))

(SUBC $DEFMATCH (C))

(SUBC $DEFRULE (C))

(SUBC $DEFTAYLOR (C))

(SUBC $DEBUGGING () $TRACE $DEBUG $DEBUGMODE $BREAK $BINDTEST $OPTIONSET)

(SUBC $DELETE (C))

(SUPC $DERIVABBREV (S) $DISPLAY)

(SUBC $DEFILE (C))

(SUBC $DELTA (C))

(SUBC $DEMO (C))

(SUBC $DENOM (C))

(SUBC $DEPENDS (C))

(SUBC $DEPENDENCIES (V))

(SUBC $DERIVDEGREE (C))

(SUBC $DETERMINANT (C))

(SUBC $DESCRIBE (C))

(SUBC $DIAGMATRIX (C))

(SUBC $DIFF (C) $DEPENDENCIES $GRADEF)

(SUBC $DISPLAY (C) $POWERDISP $SQRTDISPFLAG $STARDISP $DERIVABBREV 
		   $EXPTDISPFLAG $%EDISPFLAG $BFTRUNC $PFEFORMAT
		   $NOUNDISP $NOLABELS)

(SUBC $DISP (C))

(SUBC $DISPFUN (C))

(SUBC $DISPRULE (C))

(SUBC $DISPTERMS (C))

(SUBC $DIVIDE (C))

(SUBC $DPART (C))

(SUBC $DSCALAR (C))

(SUBC $DSKGC (C))

(SUBC $DUMMY (C))


(SUBC $EDITING () $MACSYMA-LINE-EDITOR $TECO)

(SUPC $%EDISPFLAG (S) $DISPLAY)

(SUBC $ECHELON (C))

(SUBC $EINSTEIN (C) $RATEINSTEIN $FACRAT)

(SUBC $EMATRIX (C))

(SUBC $ENDCONS (C))

(SUBC $ENTERMATRIX (C) $RATMX $SPARSE $LISTARITH $DETOUT $DOALLMXOPS
                       $DOMXMXOPS $DOSCMXPLUS $SCALARMATRIXP)

(SUBC $ENTIER (C))

(SUBC $EQUAL (C))

(SUBC $ERF (C))

(SUBC $ERRCATCH (C))

(SUBC $ERROR (C))

(SUBC $EULER (C))

(SUBC $EXP (C))

(SUBC $EXPLICIT () $TSETUP $QUANTITIES $CURVATURE)

(SUBC $EXTEND (C))

(SUBC $EZGCD (C))

(SUBC $EXPAND (C) $MAXPOSEX $MAXNEGEX)

(SUBC $EXPANSION () $EXPAND $RATEXPAND)

(SUPC $EXPONENTIALIZE (S) $EV $SIMPLIFICATION)

(SUPC $EXPTDISPFLAG (S) $DISPLAY)

(SUBC $EV (C) $EXPONENTIALIZE $%IARGS $LOGARC $%PIARGS $TRIGSIGN 
	      $TRIGINVERSES)

(SUBC $EVALUATION () $VARIABLE $FUNCTION $ARRAY $SIMP)

(SUPC $FACRAT (S) $EINSTEIN $REIMANN $WEYL)

(SUBC $FACTCOMB (C))

(SUBC $FACTOR (C) $RATVARS)

(SUBC $FACTORSUM (C) $RATVARS)

(SUBC $FACTORING () $FACTOR $GFACTOR $FACTORSUM $GFACTORSUM $SQFR $PARTITION)

(SUBC $FASSAVE (C))

(SUBC $FASTTIMES (C))

(SUBC $FIB (C))

(SUBC $FIRST (C))

(SUBC $FLOAT (C))

(SUBC $FLOATNUMP (C))

(SUBC $FORGET (C))

(SUBC $FPPREC (C))

(SUBC $FREEOF (C))

(SUBC $FILES () $FILE-CREATION $FILE-DELETION $SAVE-FILES $COMMAND-FILES)

(SUBC $FILE-CREATION () $APPENDFILE $CLOSEFILE $FASSAVE $STORE
                         $SAVE $WRITEFILE)

(SUBC $FILE-DELETION () $DEFILE $REMFILE)

(SUBC $FULLMAP (C) $MAPERROR $MAPRAT)

(SUBC $FULLMAPL (C) $MAPERROR $MAPRAT)

(SUBC $FUNCTIONS (V))

(SUBC $GAMMA (C))

(SUBC $GCD (C))

(SUBC $GENERAL-INFO () $DESCRIBE $EXAMPLE $OPTIONS $PRIMER $APROPOS)

(SUBC $GENFACT (C))

(SUBC $GENMATRIX (C) $RATMX $SPARSE $LISTARITH $DETOUT $DOALLMXOPS
                     $DOMXMXOPS $DOSCMXPLUS $SCALARMATRIXP)

(SUBC $GET (C))

(SUBC $GETCHAR (C))

(SUBC $GFACTOR (C) $RATVARS)

(SUBC $GFACTORSUM (C) $RATVARS)

(SUBC $GRADEF (C))

(SUBC $GRADEFS (V))

(SUBC $GRAPH (C) $PLOTHEIGHT $LINEL)

(SUBC $HIPOW (C))

(SUBC $HORNER (C))

(SUPC $%IARGS (S) $EV $SIMPLIFICATION)

(SUPC $INCHAR (V))

(SUBC $IDENT (C))

(SUBC $ILT (C))

(SUBC $IMAGPART (C))

(SUBC $INDICES (C))

(SUBC $INPART (C))

(SUBC $INTEGERP (C))

(SUBC $INTEGRATE (C))

(SUBC $INTOPOIS (C))

(SUBC $INFIX (C))

(SUBC $INPUT () $SYNTAX $EDITING $RETRIEVE $READ $INCHAR)

(SUBC $INTERACTION () $INPUT $OUTPUT $FILES $INFORMATION $USER-AIDS
                      $INFORMATION)

(SUBC $INFOLISTS (V))

(SUBC $INFORMATION () $GENERAL-INFO $SPECIFIC-INFO $INFORMATION-LISTS)

(SUBC $INFORMATION-LISTS () $INFOLISTS $MYOPTIONS $ALIASES $LABELS
                            $LABELS $VALUES $FUNCTIONS $RULES $PROPS
			    $MATCHDECLARES $MODEDECLARES $ARRAYS
			    $GRADEFS $DEPENDENCIES)
(SUBC $IS (C) $PREDERROR)

(SUBC $ISOLATE (C))

(SUBC $ISQRT (C))

(SUBC $KILL (C))

(SUBC $LABELS (V))

(SUBC $LAMBDA (C))

(SUBC $LAPLACE (C))

(SUBC $LAST (C))

(SUBC $LC (C))

(SUBC $LDEFINT (C))

(SUBC $LDISP (C))

(SUBC $LDISPLAY (C))

(SUBC $LENGTH (C))

(SUBC $LET (C))

(SUBC $LETRULES (C))

(SUBC $LETSIMP (C))

(SUBC $LHS (C))

(SUBC $LIMIT (C))

(SUPC $LINEL (V) $DISPLAY $PLOT $GRAPH $MULTIGRAPH $PARAMPLOT)

(SUBC $LISTS () $CONS $ENDCONS $APPEND $MEMBER $REVERSE $FIRST $REST
	        $LAST $DELETE $LENGTH $MAPPING)

(SUPC $LISTARITH (S) $ENTERMATRIX $MATRIX $GENMATRIX $COPYMATRIX
                     $ADDROW $TRANSPOSE $ECHELON $TRIANGULARIZE
                     $RANK $DETERMINANT $CHARPOLY)

(SUBC $LINSOLVE (C))

(SUBC $LISTOFVARS (C))

(SUBC $LISTP (C))

(SUBC $LOADFILE (C))

(SUBC $LOCAL (C))

(SUBC $LOG (C))

(SUBC $LOGOUT (C))

(SUBC $LOPOW (C))

(SUBC $LORENTZ (C))

(SUBC $LPART (C))

(SUBC $LRICCICOM (C))

(SUPC $LOGARC (S) $EV $SIMPLIFICATION)

(SUBC $MACSYMA-LINE-EDITOR ())

(SUBC $MAKEBOX (C))

(SUBC $MAKENONSCALAR (C))

(SUBC $MAP (C) $MAPERROR $MAPRAT)

(SUBC $MAPLIST (C) $MAPERROR $MAPRAT)

(SUPC $MAPERROR (S) $MAP $MAPLIST $FULLMAP $FULLMAPL)

(SUBC $MAPPING () $MAP $MAPLIST $FULLMAP $FULLMAPL $SCANMAP)

(SUPC $MAPRAT (S) $MAP $MAPLIST $FULLMAP $FULLMAPL)

(SUBC $MATCHDECLARES (V))

(SUBC $MATCHDECLARE (C))

(SUBC $MATCHFIX (C))

(SUBC $MATRICES () $MATRIX-CONSTRUCTION $MATRIX-MANIPULATION)

(SUBC $MATRIX-CONSTRUCTION () $ENTERMATRIX $MATRIX $GENMATRIX $COPYMATRIX
                              $ADDROW)

(SUBC $MATRIX-MANIPULATION () $TRANSPOSE $ECHELON $TRIANGULARIZE
                              $RANK $DETERMINANT $CHARPOLY)

(SUBC $MATRIX (C) $RATMX $SPARSE $LISTARITH $DETOUT $DOALLMXOPS
                  $DOMXMXOPS $DOSCMXPLUS $SCALARMATRIXP)

(SUBC $MATRIXMAP (C))

(SUBC $MATRIXP (C))

(SUBC $MAX (C))

(SUBC $MAXNEGEX (S) $EXPAND)

(SUBC $MAXPOSEX (S) $EXPAND)

(SUBC $MEMBER (C))

(SUBC $MIN (C))

(SUBC $MINFACTORIAL (C))

(SUBC $MINOR (C))

(SUBC $MOD (C))

(SUBC $MODEDECLARE (C))

(SUBC $MODEDECLARES (V))

(SUBC $MOTION (C))

(SUBC $MULTIGRAPH (C) $PLOTHEIGHT $LINEL)

(SUBC $MULTTHRU (C))

(SUBC $MYOPTIONS (V))

(SUBC $NARY (C))

(SUBC $NEWDET (C))

(SUBC $NONSCALARP (C))

(SUBC $NOUNIFY (C))

(SUBC $NOFIX (C))

(SUPC $NOLABELS (S) $DISPLAY)

(SUPC $NOUNDISP (S) $DISPLAY)

(SUBC $NROOTS (C))

(SUBC $NTERMS (C))

(SUBC $NTERMSG (C))

(SUBC $NTERMSRCI (C))

(SUBC $NUM (C))

(SUBC $NUMBERP (C))

(SUBC $NUMERVAL (C))

(SUBC $NUMFACTOR (C))

(SUBC $OPTIMIZE (C))

(SUBC $OPTIONS (C) $DOWN $UP $BACK $DESCRIBE $EXIT)

(SUBC $ORDERGREAT (C))

(SUBC $ORDERLESS (C))

(SUBC $OTHER-TRANSFORMATIONS () $TRIGREDUCE $TRIGEXPAND $FACTCOMB $LOGCONTRACT)

(SUBC $OUTOFPOIS (C))

(SUBC $OUTCHAR (V))

(SUBC $OUTPUT () $PRINT $DISPLAY $OUTCHAR)

(SUBC $PARAMPLOT (C) $PLOTHEIGHT $LINEL)

(SUBC $PART-FUNCTIONS () $PART $INPART $LHS $RHS %NUM $DENOM $COEFF $$FIRST
                         $REST $LAST $RATCOEF)

(SUBC $PART (C))

(SUBC $PARTFRAC (C))

(SUBC $PARTITION (C)  $RATVARS)

(SUPC $PFEFORMAT (S) $DISPLAY)

(SUPC $%PIARGS (S) $EV $SIMPLIFICATION)

(SUBC $PICKAPART (C))

(SUBC $PLAYBACK (C))

(SUBC $PLOG (C))

(SUBC $PLOT (C) $PLOTHEIGHT $LINEL)

(SUPC $PLOTHEIGHT (V) $PLOT $GRAPH $MULTIGRAPH $PARAMPLOT)

(SUBC $PLOTTING () $PLOT $GRAPH $MULTIGRAPH $PARAMPLOT)

(SUBC $POISDIFF (C))

(SUBC $POISEXPT (C))

(SUBC $POISINT (C))

(SUBC $POISMAP (C))

(SUBC $POISPLUS (C))

(SUBC $POISSIMP (C))

(SUBC $POISSUBST (C))

(SUBC $POISTIMES (C))

(SUBC $POISTRIM (C))

(SUBC $POLARFORM (C))

(SUBC $POLYSIGN (C))

(SUBC $POSTFIX (C))

(SUPC $POWERDISP (S) $DISPLAY)

(SUBC $POWERSERIES (C))

(SUPC $PREDERROR (S) $IS)

(SUBC $PREDICATES () $IS $ZEROEQUIV $ASSUME $FORGET)

(SUBC $PREFIX (C))

(SUBC $PRIMER (C))

(SUBC $PRINT (C))

(SUBC $PRINTPOIS (C))

(SUBC $PRINTPROPS (C))

(SUBC $PRODUCT (C))

(SUBC $PROPS (V))

(SUBC $PROPERTIES (C))

(SUBC $PROPVARS (C))

(SUBC $PSI (C))

(SUBC $PUT (C))

(SUBC $QPUT (C))

(SUBC $QUANTITIES () $CHRISTOF $MOTION $RICCICOM $NTERMSRCI $LRICCICOM
                     $EINSTEIN $NTERMSG)

(SUBC $QUIT (C))

(SUBC $QUNIT (C))

(SUBC $QUOTIENT (C))

(SUBC $RADCAN (C))

(SUBC $RAISERIEMANN (C))

(SUBC $RANDOM (C))

(SUBC $RANK (C))

(SUBC $RAT (C))

(SUBC $RATCOEF (C))

(SUBC $RATDENOM (C))

(SUBC $RATDIFF (C))

(SUBC $RATDISREP (C))

(SUPC $RATEINSTEIN (S) $EINSTEIN)

(SUBC $RATEXPAND (C))

(SUBC $RATIONAL () $EXPAND $MULTTHRU $XTHRU $COMBINE $FACTOR $FACTORSUM
                   $FACTOROUT $SQFR $RATSIMP $PARTFRAC)

(SUPC $RATMX (S) $ENTERMATRIX $MATRIX $GENMATRIX $COPYMATRIX
                   $ADDROW $TRANSPOSE $ECHELON $TRIANGULARIZE
                   $RANK $DETERMINANT $CHARPOLY)

(SUBC $RATNUMER (C))

(SUBC $RATNUMP (C))

(SUBC $RATP (C))

(SUPC $RATRIEMANN (S) $RIEMANN)

(SUBC $RATSIMP (C))

(SUBC $RATSUBST (C))

(SUPC $RATVARS (V))

(SUBC $RATWEIGHT (C))

(SUPC $RATWEYL (S) $WEYL)

(SUBC $READ (C))

(SUBC $REALPART (C))

(SUBC $REALROOTS (C))

(SUBC $RECTFORM (C))

(SUBC $REM (C))

(SUBC $REMAINDER (C))

(SUBC $REMARRAY (C))

(SUBC $REMBOX (C))

(SUBC $REMCON (C))

(SUBC $REMFILE (C))

(SUBC $REMFUNCTION (C))

(SUBC $REMLET (C))

(SUBC $REMOVE (C))

(SUBC $REMRULE (C))

(SUBC $RETRIEVE (C))

(SUBC $REMTRACE (C))

(SUBC $REMVALUE (C))

(SUBC $RENAME (C))

(SUBC $RESET (C))

(SUBC $RESIDUE (C))

(SUBC $REPRESENTATIONS () $GENERAL $CRE $TRANSFORMATIONS $SUBSTITUTIONS
                          $PART-FUNCTIONS)

(SUBC $REST (C))

(SUBC $REVERSE (C))

(SUBC $RESTORE (C))

(SUBC $RESULTANT (C))

(SUBC $REVEAL (C))

(SUBC $RHS (C))

(SUBC $RICCICOM (C))

(SUBC $RIEMANN (C) $RATRIEMANN $FACRAT)

(SUBC $RINVARIENT (C))

(SUBC $RISCH (C))

(SUBC $ROW (C))

(SUBC $RULES (V))

(SUBC $SAVE-FILES (C) $LOADFILE $RESTORE)

(SUBC $SAVE (C))

(SUBC $SCANMAP (C))

(SUBC $SCURVATURE (C))

(SUBC $SEND (C))

(SUBC $SETELMX (C))

(SUBC $SETUP (C))

(SUBC $SHOW (C))

(SUBC $SHOWTIME (C))

(SUBC $SIGN (C))

(SUBC $SIGNUM (C))

(SUBC $SIMP (S))

(SUBC $SIMPLIFICATION () $AUTOMATIC $SIMP-RULES)

(SUBC $SOLVE (C))

(SUPC $SPARSE (S) $ENTERMATRIX $MATRIX $GENMATRIX $COPYMATRIX
                  $ADDROW $TRANSPOSE $ECHELON $TRIANGULARIZE
                  $RANK $DETERMINANT $CHARPOLY)

(SUBC $SPECIFIC-INFO () $TRACE $UNTRACE $GRIND $DISPRULE $PROPERTIES
                        $PRINTPROPS $PLAYBACK $DISPFUN $ARRAYINFO)

(SUBC $SQFR (C) $RATVARS)

(SUBC $SQRT (C))

(SUBC $SRRAT (C))

(SUBC $STARDISP (C))

(SUBC $STATUS (C))

(SUBC $STORE (C))

(SUBC $STRING (C))

(SUBC $STRINGOUT (C))

(SUBC $SUBMATRIX (C))

(SUBC $SUBST (C))

(SUBC $SUBSTINPART (C))

(SUBC $SUBSTITUTIONS () $SUBST $RATSUBST $SUBSTPART $SUBSTINPART)

(SUBC $SUBSTPART (C))

(SUBC $SUM (C))

(SUBC $SYMBOL (C))

(SUBC $SYNTAX () $PREFIX $INFIX $POSTFIX $NARY $MATCHFIX $NOFIX $SYMBOL)

(SUBC $TAYLOR (C))

(SUBC $TELLRAT (C))

(SUBC $TELLSIMP (C))

(SUBC $TELLSIMPAFTER (C))

(SUBC $TENSORS () $EXPLICIT $INDICIAL)

(SUBC $THROW (C))

(SUBC $TLDEFINT (C))

(SUBC $TLIMIT (C))

(SUBC $TOTALDISREP (C))

(SUBC $TRACE (C) $UNTRACE $REMTRACE)

(SUBC $TRANSFORMATIONS () $RATIONAL $OTHER-TRANSFORMATIONS)

(SUBC $TRANSLATE (C) $TRANSRUN $MODEDECLARE)

(SUBC $TRANSPOSE (C))

(SUPC $TRANSRUN (S) $EVALUATION)

(SUBC $TRIANGULARIZE (C))

(SUBC $TRIG () $TRIGSWITCHES $TRIGEXPAND $TRIGREDUCE)

(SUBC $TRIGEXPAND (C S))

(SUPC $TRIGINVERSES (S) $EV $SIMPLIFICATION)

(SUBC $TRIGREDUCE (C))

(SUPC $TRIGSIGN (S) $EV $SIMPLIFICATION)

(SUBC $TRIGSWITCHES () $%PIARGS $%IARGS $TRIGINVERSES $TRIGSIGN 
		       $EXPONENTIALIZE $LOGARC)

(SUBC $TSETUP (C))

(SUBC $SCANMAP (C))

(SUBC $SIMPLIFICATION () $EXPANSION $FACTORING $TRIG)

(SUBC $SOLVE (C) $SOLVEFACTORS $SOLVERADCAN)

(SUPC $SOLVEFACTORS (S) $SOLVE)

(SUPC $SOLVERADCAN (S) $SOLVE)

(SUPC $SQRTDISPFLAG (S) $DISPLAY)

(SUPC $STARDISP (S) $DISPLAY)

(SUBC $TRANSLATION () $TRANSLATE $COMPFILE $MODEDECLARE)

(SUBC $TRIGFUNCTION () %SIN %COS %TAN %COT %CSC %SEC 
		       %ASIN %ACOS %ATAN %ACOT %ACSC %ASEC
		       %SINH %COSH %TANH %COTH %CSCH %SECH
		       %ASINH %ACOSH %ATANH %ACOTH %ACSCH %ASECH)

(SUBC $UNDIFF (C))

(SUBC $UNIVERSALS () $TIMEDATE $WHO $BUG $MAIL $SEND)

(SUBC $UNORDER (C))

(SUBC $UNSTORE (C))

(SUBC $UNTRACE (C))

(SUBC $USER-AIDS () $PRIMER $DESCRIBE $OPTIONS $EXAMPLE $APROPOS $VISUAL-AIDS)

(SUBC $VALUES (V))

(SUBC $VERBIFY (C))

(SUBC $VISUAL-AIDS () $REVEAL $ISOLATE $PICKAPART)

(SUBC $WEYL (C) $RATWEYL $FACRAT)

(SUBC $WRITEFILE (C))

(SUBC $XTHRU (C))

(SUBC $YT (C))

(SUBC $ZETA (C))

(SUBC $ZEROEQUIV (C))

(SUBC %SIN (C) $FLOAT $NUMER $BFLOAT $%PIARGS $%IARGS $TRIGINVERSES
	       $TRIGEXPAND $EXPONENTIALIZE $HALFANGLES $TRIGSIGN
	       $LOGARC)

(SUBC %COS (C) $FLOAT $NUMER $BFLOAT $%PIARGS $%IARGS $TRIGINVERSES
	       $TRIGEXPAND $EXPONENTIALIZE $HALFANGLES $TRIGSIGN
	       $LOGARC)

(SUBC %TAN (C) $FLOAT $NUMER $BFLOAT $%PIARGS $%IARGS $TRIGINVERSES
	       $TRIGEXPAND $EXPONENTIALIZE $HALFANGLES $TRIGSIGN
	       $LOGARC)

(SUBC %COT (C) $FLOAT $NUMER $BFLOAT $%PIARGS $%IARGS $TRIGINVERSES
	       $TRIGEXPAND $EXPONENTIALIZE $HALFANGLES $TRIGSIGN
	       $LOGARC)

(SUBC %CSC (C) $FLOAT $NUMER $BFLOAT $%PIARGS $%IARGS $TRIGINVERSES
	       $TRIGEXPAND $EXPONENTIALIZE $HALFANGLES $TRIGSIGN
	       $LOGARC)

(SUBC %SEC (C) $FLOAT $NUMER $BFLOAT $%PIARGS $%IARGS $TRIGINVERSES
	       $TRIGEXPAND $EXPONENTIALIZE $HALFANGLES $TRIGSIGN
	       $LOGARC)

(SUBC %ASIN (C) $FLOAT $NUMER $BFLOAT $%PIARGS $%IARGS $TRIGINVERSES
		$TRIGSIGN $LOGARC)

(SUBC %ACOS (C) $FLOAT $NUMER $BFLOAT $%PIARGS $%IARGS $TRIGINVERSES
		$TRIGSIGN $LOGARC)

(SUBC %ATAN (C) $FLOAT $NUMER $BFLOAT $%PIARGS $%IARGS $TRIGINVERSES
		$TRIGSIGN $LOGARC)

(SUBC %ACOT (C) $FLOAT $NUMER $BFLOAT $%PIARGS $%IARGS $TRIGINVERSES
		$TRIGSIGN $LOGARC)

(SUBC %ACSC (C) $FLOAT $NUMER $BFLOAT $%PIARGS $%IARGS $TRIGINVERSES
		$TRIGSIGN $LOGARC)

(SUBC %ASEC (C) $FLOAT $NUMER $BFLOAT $%PIARGS $%IARGS $TRIGINVERSES
		$TRIGSIGN $LOGARC)

(SUBC %SINH (C) $FLOAT $NUMER $BFLOAT $%PIARGS $%IARGS $TRIGINVERSES
		$TRIGEXPAND $EXPONENTIALIZE $HALFANGLES $TRIGSIGN)

(SUBC %COSH (C) $FLOAT $NUMER $BFLOAT $%PIARGS $%IARGS $TRIGINVERSES
		$TRIGEXPAND $EXPONENTIALIZE $HALFANGLES $TRIGSIGN)

(SUBC %TANH (C) $FLOAT $NUMER $BFLOAT $%PIARGS $%IARGS $TRIGINVERSES
		$TRIGEXPAND $EXPONENTIALIZE $HALFANGLES $TRIGSIGN)

(SUBC %COTH (C) $FLOAT $NUMER $BFLOAT $%PIARGS $%IARGS $TRIGINVERSES
		$TRIGEXPAND $EXPONENTIALIZE $HALFANGLES $TRIGSIGN)

(SUBC %CSCH (C) $FLOAT $NUMER $BFLOAT $%PIARGS $%IARGS $TRIGINVERSES
		$TRIGEXPAND $EXPONENTIALIZE $HALFANGLES $TRIGSIGN)

(SUBC %SECH (C) $FLOAT $NUMER $BFLOAT $%PIARGS $%IARGS $TRIGINVERSES
		$TRIGEXPAND $EXPONENTIALIZE $HALFANGLES $TRIGSIGN)

(SUBC %ASINH (C) $FLOAT $NUMER $BFLOAT $%PIARGS $%IARGS $TRIGINVERSES
		 $TRIGSIGN $LOGARC)

(SUBC %ACOSH (C) $FLOAT $NUMER $BFLOAT $%PIARGS $%IARGS $TRIGINVERSES
		 $TRIGSIGN $LOGARC)

(SUBC %ATANH (C) $FLOAT $NUMER $BFLOAT $%PIARGS $%IARGS $TRIGINVERSES
		 $TRIGSIGN $LOGARC)

(SUBC %ACOTH (C) $FLOAT $NUMER $BFLOAT $%PIARGS $%IARGS $TRIGINVERSES
		 $TRIGSIGN $LOGARC)

(SUBC %ACSCH (C) $FLOAT $NUMER $BFLOAT $%PIARGS $%IARGS $TRIGINVERSES
		 $TRIGSIGN $LOGARC)

(SUBC %ASECH (C) $FLOAT $NUMER $BFLOAT $%PIARGS $%IARGS $TRIGINVERSES
		 $TRIGSIGN $LOGARC)

(SUBC |&.| (C) $DOTASSOC $DOTSCRULES $DOTCONSTRULES $DOTEXPTSIMP
	       $DOTDISTRIB $ASSUMESCALAR)

