/*-*-macsyma-*-*/

/* Macros for organizing packages. */

eval_when(translate,transcompile:true)$

/* HERALD_PACKAGE(MYJUNK)$ will tell the macsyma user and the system
           which VERSION of your MYJUNK package is being loaded. */

eval_when([translate,demo,batch,loadfile],

 HERALD_PACKAGE(NAME)::=
    BUILDQ([NAME,
	    VERSION_NO:IF TR_TRUE_NAME_OF_FILE_BEING_TRANSLATED#FALSE THEN
			  ?pathname\-version(TR_TRUE_NAME_OF_FILE_BEING_TRANSLATED)
		       ELSE "VERSION UNKNOWN"],
	 (IF LOADPRINT THEN PRINT('name,"source",'version_no),
          PUT('NAME,'VERSION_NO,'VERSION)))
)$

/* next, a macro that is convenient for making sure a HERALDed package
   is loaded. It saves a bit of typing. e.g.
   LOAD_PACKAGE(FOO_STUFF,FOO,FASL,DSK,SHARE) */

HERALD_PACKAGE(PACKG)$

LOAD_PACKAGE(NAME,FILE_NAME)::=
 BUILDQ([NAME,FILE_NAME],
        IF GET('NAME,'VERSION)=FALSE THEN LOAD(FILE_NAME))$


/* For address space reasons on MC things which have an autoload
   property are loaded during translation time only if they
   have a TRANSLOAD property. This isn't all bad because the
   the presence of the property can tell you that the form has
   special handling during translation. Which is not a bad thing to
   know. */

SETUP_AUTOLOAD_MACRO(FILENAME,[L])::=
 BUILDQ([PROPSETS:MAPLIST(LAMBDA([U],BUILDQ([U],PUT('U,TRUE,'TRANSLOAD))),L),
         FILENAME,L],
        (SETUP_AUTOLOAD(FILENAME,SPLICE(L)),SPLICE(PROPSETS)) )$

/* Now, here are the big ones */

/* Should have a DEFINE_PACKAGE which sets up 
   (1) Entry points & autoloads.
   (2) Bulk Translate & compile aids.
   (3) Tags aids.

*/

