/*  Motti -- a strategy game
    Copyright (C) 1999-2010 Free Software Foundation

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
#include "StdAfx.h"
#include <sstream>
#include <fstream>
#include "GameManager.h"
#include <cstdlib>
#include <vector>

#include <iostream>
#include <istream>
#include <ostream>
#include <string>
#include "MapManager.h"
#include "LabelBoxElement.h"
#include "EditLineBoxElement.h"
#include "Serializer.h"
#include "AiPlayer.h"
#include "MapGenerator.h"

#if defined __CYGWIN32__ 
#include <dirent.h>
#else
#if defined WIN32 
#else
#include <dirent.h>

#endif
#endif

GameManager::GameManager(Drawer *dr,Board *b)
{
	drawer_=dr;
	board_=b;
	rulesManager_.setBoard (b);
	std::vector<BoxElement *> ll;
	ll.push_back(new LabelBoxElement("Ca dechire"));
	ll.push_back(new LabelBoxElement("Choix mi"));
	ll.push_back(new LabelBoxElement("dernier"));
	myMenu_=drawer_->createMenu(ll,"  TITRE");
	myMenu_->setSelected(0);
	meesBox_=drawer_->createMessageBox("Empty","  TITRE");
	actualIndexMenu_=0;
	actualState_=START_MENU;
	filterMottiSavedGame_=false;
	filterMottiMap_=false;
	firstTime_=false;
	playersGen=0;
}


GameManager::~GameManager(void)
{
	if (myMenu_!=NULL)
		delete myMenu_;
}


void GameManager::init(){
	rulesManager_.initGame();
	rulesManager_.initTurn();
	drawer_->refreshConfig();
	drawer_->setCursorPlacement((drawer_->getWidth()/2),(drawer_->getHeight()/2));
	
}


Player *GameManager::getActualPlayer(){
	return board_->getActualPlayer();
}


Player *GameManager::getPlayer(int y ){
	return board_->getPlayer(y);
}
 
void GameManager::attack(Player *p,int x,int y){
	rulesManager_.attack(p,x,y);
}

void GameManager::guerilla(Player *p,int x,int y){
	rulesManager_.guerilla(p,x,y);
}

void GameManager::unattack(Player *p,int x,int y){
	rulesManager_.unattack(p,x,y);
}
	void GameManager::defend(Player *p,int x,int y){
	rulesManager_.defend(p,x,y);
}
	void GameManager::undefend(Player *p,int x,int y){
	rulesManager_.undefend(p,x,y);
}

	
	void GameManager::unguerilla(Player *p,int x,int y){
	rulesManager_.unguerilla(p,x,y);
}

void GameManager::endTurn(){
	
	rulesManager_.endTurn();
	
}

RandomGenerator &GameManager::getRandomGenerator(){
	return rulesManager_.getRandomGenerator();
}


void GameManager::transitionStarMenu(){
	switch (actualIndexMenu_)
	{
		case 0: 
			actualState_=NEW_GAME;
			actualIndexMenu_=0;
			break;
		case 1:
			previousState_=START_MENU;
			actualState_=NEW_LOCAL_GAME_OPEN;
			actualDir_=".";
			actualIndexMenu_=0;
			filterMottiSavedGame_=true;
			filterMottiMap_=false;
			break;
		case 2:
			actualState_=START_MENU;
			actualIndexMenu_=0;
			break;
		case 3:
			exit(0);
			break;
		default:
			break;
	
	}
}
void GameManager::setStarMenu(){
	myMenu_->setTitle("Menu");
	std::vector<BoxElement *> ll;
	ll.push_back(new LabelBoxElement("New Game"));
	ll.push_back(new LabelBoxElement("Continue Game "));
	ll.push_back(new LabelBoxElement("Options (Locked)"));
	ll.push_back(new LabelBoxElement("Exit"));
	myMenu_->setMenuElements(ll);
}



void GameManager::setNewMenu(){
	myMenu_->setTitle("New Game");
	std::vector<BoxElement *> ll;
	ll.push_back(new LabelBoxElement("Local game"));
	ll.push_back(new LabelBoxElement("Network (Locked)"));
	ll.push_back(new LabelBoxElement("Return to start menu"));
	
	myMenu_->setMenuElements(ll);
}

void GameManager::setNewLocalMenu(){
	myMenu_->setTitle("New Local Game");
	std::vector<BoxElement*> ll;
	ll.push_back(new LabelBoxElement("Open a Map"));
	ll.push_back(new LabelBoxElement("Generate a Map"));
	ll.push_back(new LabelBoxElement("Return"));
	
	myMenu_->setMenuElements(ll);
}

void GameManager::setNewLocalOpenMenu(){
	myMenu_->setTitle("Open - "+actualDir_);
	std::vector<BoxElement *> ll=listLabelDir(actualDir_);
	
	
	
	myMenu_->setMenuElements(ll);
}

void GameManager::setInGameSelectPlayer(){
	myMenu_->setTitle("Choose Players"+actualDir_);
	std::vector<BoxElement *> ll;
	int i=0;
	
	for (i=0;i<board_->getNbPlayers();i++)
	{
		std::stringstream val;
		val <<board_->getNbPlayers()-i<<" Human Player(s),"<<i<<" Computer Player(s)";
		ll.push_back(new LabelBoxElement(val.str()));
		
	}
	
	
	myMenu_->setMenuElements(ll);
}

void GameManager::setInGameHelp(){
	myMenu_->setTitle("Help");
	std::vector<BoxElement*> ll;
	ll.push_back(new LabelBoxElement("Save"));
	ll.push_back(new LabelBoxElement("Main menu"));
	ll.push_back(new LabelBoxElement("Return"));
	
	myMenu_->setMenuElements(ll);
}


void GameManager::setMapSize(){
	myMenu_->setTitle("Choose Map Size");
	std::vector<BoxElement*> ll;
	ll.push_back(new LabelBoxElement("20x20"));
	ll.push_back(new LabelBoxElement("50x50"));
	ll.push_back(new LabelBoxElement("100x100"));
	ll.push_back(new LabelBoxElement("200x200"));
	ll.push_back(new LabelBoxElement("Return"));
	myMenu_->setMenuElements(ll);
}
void GameManager::setMapPlayer(){
	myMenu_->setTitle("Choose Players");
	std::vector<BoxElement*> ll;
	ll.push_back(new LabelBoxElement("2"));
	ll.push_back(new LabelBoxElement("3"));
	ll.push_back(new LabelBoxElement("5"));
	ll.push_back(new LabelBoxElement("10"));
	ll.push_back(new LabelBoxElement("Return"));
	myMenu_->setMenuElements(ll);
}


void GameManager::setInGameSelectAction(){
	myMenu_->setTitle("Choose Action");
	std::vector<BoxElement*> ll;
	ll.push_back(new LabelBoxElement("Attack"));
	ll.push_back(new LabelBoxElement("Defend"));
	ll.push_back(new LabelBoxElement("Guerilla"));
	ll.push_back(new LabelBoxElement("Return"));
	
	myMenu_->setMenuElements(ll);
}

void GameManager::setInGameSave(){
	myMenu_->setTitle("Save the game");
	std::vector<BoxElement*> ll;
	ll.push_back(new LabelBoxElement("Directory "+actualDir_));
	std::string valmueName="";
	if (myMenu_->getMenuElements().size()>1)
	{
		BoxElement *ee=myMenu_->getMenuElements()[1];
		EditLineBoxElement *edl=dynamic_cast<EditLineBoxElement *>(ee);
		if (edl!=NULL)
		{
			valmueName=edl->getValue();
		}
	}
	EditLineBoxElement *rert=new EditLineBoxElement(30,"FileName");
	rert->setValue(valmueName);
	ll.push_back(rert);
	ll.push_back(new LabelBoxElement("Save"));
	ll.push_back(new LabelBoxElement("Return"));
	myMenu_->setMenuElements(ll);
}

void GameManager::incIndexMenu()
{
	actualIndexMenu_++;
	if (actualIndexMenu_<0)
	{
		actualIndexMenu_=(int)myMenu_->getMenuElements().size()-1;
	}
	if (((unsigned int)actualIndexMenu_)>myMenu_->getMenuElements().size())
	{
		actualIndexMenu_=0;
	}
}

void GameManager::decIndexMenu()
{
	actualIndexMenu_--;
	if (actualIndexMenu_<0)
	{
		actualIndexMenu_=(int)myMenu_->getMenuElements().size()-1;
	}
	if (((unsigned int)actualIndexMenu_)>myMenu_->getMenuElements().size())
	{
		actualIndexMenu_=0;
	}
}
void GameManager::manageStarMenu(CommandManager::ACTIONKEY KEY){
	bool isChanged=false;
	switch (KEY)
	{
	case CommandManager::UP: 
			decIndexMenu();

			isChanged=true;
			break;
	case CommandManager::DOWN:
			incIndexMenu();
			isChanged=true;
			break;
	case CommandManager::ACTION:
	case CommandManager::RETURN:
			transitionStarMenu();
			actualIndexMenu_=-1;
			manageMenu(CommandManager::DOWN);
			isChanged=false;
			break;
		default:
			break;
	
	}
	if (isChanged)
	{
		setStarMenu();
		drawer_->draw();
		myMenu_->setSelected(actualIndexMenu_);
		drawer_->draw(myMenu_);
		
	}
}

void GameManager::manageInGameHelp(CommandManager::ACTIONKEY KEY){
	bool isChanged=false;
	switch (KEY)
	{
	case CommandManager::UP: 
			decIndexMenu();

			isChanged=true;
			break;
	case CommandManager::DOWN:
			incIndexMenu();
			isChanged=true;
			break;
	case CommandManager::ACTION:
	case CommandManager::RETURN:
			transitionInNameHelp();
			actualIndexMenu_=-1;
			manageMenu(CommandManager::DOWN);
			isChanged=false;
			break;
		default:
			break;
	
	}
	if (isChanged)
	{
		setInGameHelp();
		drawer_->draw();
		myMenu_->setSelected(actualIndexMenu_);
		drawer_->draw(myMenu_);
		
	}
}

void GameManager::manageInGameSelectAction(CommandManager::ACTIONKEY KEY){
	bool isChanged=false;
	switch (KEY)
	{
	case CommandManager::UP: 
			decIndexMenu();

			isChanged=true;
			break;
	case CommandManager::DOWN:
			incIndexMenu();
			isChanged=true;
			break;
	case CommandManager::ACTION:
	case CommandManager::RETURN:
			actualState_=INGAME;
			
			transitionInGameSelect();
			isChanged=false;
			actualIndexMenu_=-1;
			firstTime_=true;
			manageMenu(CommandManager::DOWN);
			break;
		default:
			break;
	
	}
	if (isChanged)
	{
		setInGameSelectAction();
		drawer_->draw();
		myMenu_->setSelected(actualIndexMenu_);
		drawer_->draw(myMenu_);
		
	}
}


void GameManager::manageMenu(CommandManager::ACTIONKEY KEY){
	switch (actualState_)
	{
		case DIALOG_BOX: 
			drawer_->draw(meesBox_);
			actualState_=previousState_;
			
			break;
		case START_MENU: 
			manageStarMenu( KEY);
			break;
		case NEW_GAME:
			manageNewMenu(KEY);
			break;
		case NEW_LOCAL_GAME:
			manageNewLocalMenu(KEY);
			break;
		case NEW_LOCAL_GAME_OPEN:
			manageNewLocalOMenu(KEY);
			break;
		case INGAME:
			manageInGame(KEY);
			break;
		case INGAME_HELP:
			manageInGameHelp(KEY);
			break;
		case INGAME_SELECT_ACTION:
			manageInGameSelectAction(KEY);
			break;
		case INGAME_SAVE_GAME:
			manageInGameSave(KEY);
			break;

		case INGAME_SELECT_PLAYERS:
			manageInGameSelectPlayer(KEY);
			break;
		case NEW_GAME_GENERATE_MAP_SIZE:
			manageNewLocalGenerateMapSize(KEY);
			break;
		case NEW_GAME_GENERATE_MAP_PLAYERS:
			manageNewLocalGenerateMapPls(KEY);
			break;
		default:
			break;
	
	}
	
	
}


void GameManager::manageGame(){
	
	drawer_->refreshConfig();
	
	if (actualState_==INGAME&&board_->getWinner()==NULL&&board_->getActualPlayer()!=NULL&&board_->getActualPlayer()->getType()==Player::COMPUTER){
		manageMenu(CommandManager::ACTION);
	}
	else{
		manageMenu(commManager_.readKey());
	}
	
	
}
void GameManager::manageNewLocalGenerateMapSize(CommandManager::ACTIONKEY KEY){
bool isChanged=false;
	switch (KEY)
	{
	case CommandManager::UP: 
			decIndexMenu();

			isChanged=true;
			break;
	case CommandManager::DOWN:
			incIndexMenu();
			isChanged=true;
			break;
	case CommandManager::ACTION:
	case CommandManager::RETURN:
			transitionMapSize();
			actualIndexMenu_=-1;
			manageMenu(CommandManager::DOWN);
			isChanged=false;
			break;
		default:
			break;
	
	}
	if (isChanged)
	{
		setMapSize();
		drawer_->draw();
		myMenu_->setSelected(actualIndexMenu_);
		drawer_->draw(myMenu_);
		
	}
}

void GameManager::manageNewLocalGenerateMapPls(CommandManager::ACTIONKEY KEY){
bool isChanged=false;
	switch (KEY)
	{
	case CommandManager::UP: 
			decIndexMenu();

			isChanged=true;
			break;
	case CommandManager::DOWN:
			incIndexMenu();
			isChanged=true;
			break;
	case CommandManager::ACTION:
	case CommandManager::RETURN:
			transitionMapPlayers();
			actualIndexMenu_=-1;
			manageMenu(CommandManager::DOWN);
			isChanged=false;
			break;
		default:
			break;
	
	}
	if (isChanged)
	{
		setMapPlayer();
		drawer_->draw();
		myMenu_->setSelected(actualIndexMenu_);
		drawer_->draw(myMenu_);
		
	}
}

void GameManager::manageInGameSelectPlayer(CommandManager::ACTIONKEY KEY){
bool isChanged=false;
	switch (KEY)
	{
	case CommandManager::UP: 
			decIndexMenu();

			isChanged=true;
			break;
	case CommandManager::DOWN:
			incIndexMenu();
			isChanged=true;
			break;
	case CommandManager::ACTION:
	case CommandManager::RETURN:
			transitionInGameSelectPlayer();
			actualIndexMenu_=-1;
			manageMenu(CommandManager::DOWN);
			isChanged=false;
			break;
		default:
			break;
	
	}
	if (isChanged)
	{
		setInGameSelectPlayer();
		drawer_->draw();
		myMenu_->setSelected(actualIndexMenu_);
		drawer_->draw(myMenu_);
		
	}
}

void GameManager::manageNewMenu(CommandManager::ACTIONKEY KEY){
bool isChanged=false;
	switch (KEY)
	{
	case CommandManager::UP: 
			decIndexMenu();

			isChanged=true;
			break;
	case CommandManager::DOWN:
			incIndexMenu();
			isChanged=true;
			break;
	case CommandManager::ACTION:
	case CommandManager::RETURN:
			transitionNewMenu();
			actualIndexMenu_=-1;
			manageMenu(CommandManager::DOWN);
			isChanged=false;
			break;
		default:
			break;
	
	}
	if (isChanged)
	{
		setNewMenu();
		drawer_->draw();
		myMenu_->setSelected(actualIndexMenu_);
		drawer_->draw(myMenu_);
		
	}
}



void GameManager::manageNewLocalMenu(CommandManager::ACTIONKEY KEY){
bool isChanged=false;
	switch (KEY)
	{
	case CommandManager::UP: 
			decIndexMenu();

			isChanged=true;
			break;
	case CommandManager::DOWN:
			incIndexMenu();
			isChanged=true;
			break;
	case CommandManager::ACTION:
	case CommandManager::RETURN:
			transitionNewLocalMenu();
			actualIndexMenu_=-1;
			manageMenu(CommandManager::DOWN);
			isChanged=false;
			break;
		default:
			break;
	
	}
	if (isChanged)
	{
		setNewLocalMenu();
		drawer_->draw();
		myMenu_->setSelected(actualIndexMenu_);
		drawer_->draw(myMenu_);
		
	}
}

void  GameManager::manageInGameSave(CommandManager::ACTIONKEY KEY){
	bool isChanged=false;
	switch (KEY)
	{
	case CommandManager::UP: 
			decIndexMenu();

			isChanged=true;
			break;
	case CommandManager::DOWN:
			incIndexMenu();
			isChanged=true;
			break;
	case CommandManager::ACTION:
	case CommandManager::RETURN:
			transitionInGameSave(KEY);
			actualIndexMenu_=-1;
			manageMenu(CommandManager::DOWN);
			isChanged=false;
			break;
	case CommandManager::A:case CommandManager::B:case CommandManager::C:case CommandManager::D:
	case CommandManager::E:case CommandManager::F:case CommandManager::G:case CommandManager::H:
	case CommandManager::I:case CommandManager::J:case CommandManager::K:case CommandManager::L:
	case CommandManager::M:case CommandManager::N:case CommandManager::O:case CommandManager::P:
	case CommandManager::Q:case CommandManager::R:case CommandManager::S:case CommandManager::T:
	case CommandManager::U:case CommandManager::V:case CommandManager::W:case CommandManager::X:
	case CommandManager::Y:case CommandManager::Z:case CommandManager::BACKSPAPE:
		transitionInGameSave(KEY);
		isChanged=true;
		default:
			break;
	
	}
	if (isChanged)
	{
		setInGameSave();
		drawer_->draw();
		myMenu_->setSelected(actualIndexMenu_);
		drawer_->draw(myMenu_);
		
	}
}

void GameManager::manageNewLocalOMenu(CommandManager::ACTIONKEY KEY){
bool isChanged=false;
	switch (KEY)
	{
	case CommandManager::UP: 
			decIndexMenu();

			isChanged=true;
			break;
	case CommandManager::DOWN:
			incIndexMenu();
			isChanged=true;
			break;
	case CommandManager::ACTION:
	case CommandManager::RETURN:
			transitionNewLocalOpenMenu();
			actualIndexMenu_=-1;
			manageMenu(CommandManager::DOWN);
			isChanged=false;
			break;
		default:
			break;
	
	}
	if (isChanged)
	{
		setNewLocalOpenMenu();
		drawer_->draw();
		myMenu_->setSelected(actualIndexMenu_);
		drawer_->draw(myMenu_);
		
	}
}

void GameManager::transitionNewMenu(){
	switch (actualIndexMenu_)
	{
		case 0: 
			actualState_=NEW_LOCAL_GAME;
			actualIndexMenu_=0;
			break;
		case 1:
			actualState_=NEW_GAME;
			break;
		case 2:
			actualState_=START_MENU;
			break;
		default:
			break;
	
	}
}


void GameManager::transitionMapSize(){
	playersGen=0;
	switch (actualIndexMenu_)
	{
		case 0: 
			actualState_=NEW_GAME_GENERATE_MAP_PLAYERS;
			xsizeGen=20;
			ysizeGen=20;
			
			break;
		case 1:
			actualState_=NEW_GAME_GENERATE_MAP_PLAYERS;
			xsizeGen=50;
			ysizeGen=50;
			
			break;
		case 2:
			actualState_=NEW_GAME_GENERATE_MAP_PLAYERS;
			xsizeGen=100;
			ysizeGen=100;
			
			break;
		case 3:
			actualState_=NEW_GAME_GENERATE_MAP_PLAYERS;
			xsizeGen=200;
			ysizeGen=200;
			break;
		case 4:
			actualState_=START_MENU;
			break;
		default:
			break;
	
	}
	
	actualIndexMenu_=0;

}

void GameManager::transitionMapPlayers(){
	switch (actualIndexMenu_)
	{
		case 0: 
			actualState_=INGAME;
			playersGen=2;
			break;
		case 1:
			actualState_=INGAME;
			playersGen=3;
			
			break;
		case 2:
			actualState_=INGAME;
			playersGen=5;
			
			break;
		case 3:
			actualState_=INGAME;
			playersGen=10;
			break;
		case 4:
			actualState_=START_MENU;
			break;
		default:
			break;
	
	}
	if (playersGen!=0)
	{
		MapGenerator mm;
		meesBox_->setTitle("Game Info");
		std::stringstream message;
		message<<"Generate Map for "<<playersGen<<" players .\n";
		meesBox_->setMessage(message.str());
		drawer_->draw(meesBox_);
		//void (*writesmessage)(std::string title,std::string message) ;
		
		
		Case *pp=mm.generateMap(playersGen,xsizeGen,ysizeGen);
		board_->setCases(pp);
		playersGen=0;
		board_->setWidth(xsizeGen);
		board_->setHeight(ysizeGen);
		board_->recalculatePlayer();
		board_->setActualPlayer(board_->getPlayer(0));
		actualState_=INGAME_SELECT_PLAYERS;
		firstTime_=true;
		board_->setWinner(NULL);
		firstTime_=true;
	}
	actualIndexMenu_=0;

}

void GameManager::transitionInGameSelectPlayer(){

	for (int i=0;i<actualIndexMenu_;i++)
	{
		if (board_->getPlayer(i+1)!=NULL)
		board_->getPlayer(i+1)->setType(Player::COMPUTER);
	}
	actualState_=INGAME;
}

void GameManager::transitionInGameSelect(){
	switch (actualIndexMenu_)
	{
		case 0: 
			board_->setActionMode(Board::ATTACK);
			board_->setNbCoutRestant(board_->getNbCoupperTurnAttack());
			
			break;
		case 1:
			board_->setActionMode(Board::DEFEND);
			board_->setNbCoutRestant(board_->getNbCoupperTurnDefend());
			break;
		case 2:
			board_->setActionMode(Board::GUERILLA);
			board_->setNbCoutRestant(board_->getNbCoupperTurnGuerilla());
			break;
		default:
			break;
	
	}
}

void GameManager::transitionInNameHelp(){
	switch (actualIndexMenu_)
	{
		case 0: 
			actualState_=INGAME_SAVE_GAME;
			actualIndexMenu_=0;
			break;
		case 1:
			actualState_=START_MENU;
			break;
		case 2:
			actualState_=INGAME;
			break;
		default:
			break;
	
	}
}
#ifndef DATADIR
#define DATADIR 'data'
#endif
void GameManager::transitionNewLocalMenu(){


	switch (actualIndexMenu_)
	{
		case 0: 
			previousState_=actualState_;
			actualState_=NEW_LOCAL_GAME_OPEN;
			actualDir_=DATADIR;
			actualDir_+="/games/motti/map";
			actualIndexMenu_=0;
			filterMottiSavedGame_=false;
			filterMottiMap_=true;
			break;
		case 1:
			actualState_=NEW_GAME_GENERATE_MAP_SIZE;
			break;
		case 2:
			actualState_=NEW_GAME;
			break;
		default:
			break;
	
	}
}

void GameManager::setStringBoxEle(CommandManager::ACTIONKEY KEY,int index)
{
	if (myMenu_!=NULL)
	{
		BoxElement *el=myMenu_->getMenuElements()[index];
		EditLineBoxElement *elm=dynamic_cast<EditLineBoxElement *>(el);
		if (elm!=NULL)
		{
			std::string str=elm->getValue();
			std::string actTempo;
			int itempo;
			switch (KEY)
			{
				case CommandManager::A:
					str+='a';
					break;
				case CommandManager::B:
					str+='b';
					break;
				case CommandManager::C:	
					str+='c';
					break;
				case CommandManager::D:
					str+='d';
					break;
				case CommandManager::E:
					str+='e';
					break;
				case CommandManager::F:
					str+='f';
					break;
				case CommandManager::G:
					str+='g';
					break;
				case CommandManager::H:
					str+='h';
					break;
				case CommandManager::I:
					str+='i';
					break;
				case CommandManager::J:
					str+='j';
					break;
				case CommandManager::K:
					str+='k';
					break;
				case CommandManager::L:
					str+='l';
					break;
				case CommandManager::M:
					str+='m';
					break;
				case CommandManager::N:
					str+='n';
					break;
				case CommandManager::O:
					str+='o';
					break;
				case CommandManager::P:
					str+='p';
					break;
				case CommandManager::Q:
					str+='q';
					break;
				case CommandManager::R:
					str+='r';
					break;
				case CommandManager::S:
					str+='s';
					break;
				case CommandManager::T:
					str+='t';
					break;
				case CommandManager::U:
					str+='u';
					break;
				case CommandManager::V:
					str+='v';
					break;
				case CommandManager::W:
					str+='w';
					break;
				case CommandManager::X:
					str+='x';
					break;
				case CommandManager::Y:
					str+='y';
					break;
				case CommandManager::Z:
					str+='z';
					break;
				case CommandManager::BACKSPAPE:
					
					for (itempo=0;itempo<(int)str.size()-1;itempo++)
					{
						actTempo+=str.at(itempo);
					}
					str=actTempo;
					break;
				default:
					break;
			}
			elm->setValue(str);
			
		}
	
	}
}

void GameManager::transitionInGameSave(CommandManager::ACTIONKEY KEY){


	switch (actualIndexMenu_)
	{
		case 0: 
			previousState_=actualState_;
			actualState_=NEW_LOCAL_GAME_OPEN;
			actualDir_=".";
			actualIndexMenu_=0;
			filterMottiSavedGame_=false;
			filterMottiMap_=false;
			break;
		case 1:
			setStringBoxEle(KEY,1);
			break;
		case 2:
			if (myMenu_->getMenuElements().size()>1)
			{
				BoxElement *bb=myMenu_->getMenuElements()[1];
				EditLineBoxElement *liE=dynamic_cast<EditLineBoxElement *>(bb);
				if (liE!=NULL)
				{
					std::string filename=liE->getValue();
					meesBox_->setTitle("Game Info");
					std::stringstream message;
					message<<"Saving the saved game :\n"<<actualDir_+"\\"+filename+".mtt"<<"\n";
					meesBox_->setMessage(message.str());
					drawer_->draw(meesBox_);
					
					Serializer sse;
					sse << std::string("GNU_Motti_V1");
					sse << *board_; // this will print all to the first person
#ifdef WIN32 
					sse.saveFile(actualDir_+"\\"+filename+".mtt");
#else
					sse.saveFile(actualDir_+"/"+filename+".mtt");
#endif					
					actualState_=INGAME_HELP;
					actualIndexMenu_=0;
				}
			}
			break;
		case 3:
			actualState_=INGAME_HELP;
			actualIndexMenu_=0;
			break;
		default:
			break;
	
	}
}

bool GameManager::isDir(std::string pp)
{
	
	//pFile = fopen (pp.c_str(),"r");
#if defined __CYGWIN32__ 
	
  DIR *dp;

	 if((dp = opendir(pp.c_str())) == NULL) {
	  
	  return false;
	 }
	 closedir(dp);
	 return true;
#else
#if defined WIN32
	errno_t err;
   // Open for read (will fail if file "crt_fopen_s.c" does not exist)
   if( (err  = fopen_s(&pFile, pp.c_str(), "r" )) !=0 )
      printf( "The file was not opened\n" );
   else
      printf( "The file was opened\n" );
   if (pFile!=NULL)
	{
		return false;
		fclose (pFile);
	}
	return true;
#else
	DIR *dp;

	 if((dp = opendir(pp.c_str())) == NULL) {
	  
	  return false;
	 }
	 closedir(dp);
	 return true;
#endif
#endif
	

	
}

bool GameManager::isGameOldFormat(std::string pp)
{
	FILE * pFile;
//	pFile = fopen (pp.c_str(),"r");
#if defined __CYGWIN32__ 

   // Open for read (will fail if file "crt_fopen_s.c" does not exist)
   if( (pFile  = fopen( pp.c_str(), "r" )) !=0 )
      printf( "The file was not opened\n" );
   else
      printf( "The file was opened\n" );
#else
#if defined WIN32 

	errno_t err;
   // Open for read (will fail if file "crt_fopen_s.c" does not exist)
   if( (err  = fopen_s(&pFile, pp.c_str(), "r" )) !=0 )
      printf( "The file was not opened\n" );
   else
      printf( "The file was opened\n" );
	  
#else
// Open for read (will fail if file "crt_fopen_s.c" does not exist)
   if( (pFile  = fopen( pp.c_str(), "r" )) !=0 )
      printf( "The file was not opened\n" );
   else
      printf( "The file was opened\n" );
#endif
#endif

	bool rettVal=false;
	if (pFile!=NULL)
	{
		
		char MagicWord[6];
		MagicWord[5]=0;
		size_t result = fread (MagicWord,1,5,pFile);
		if (result != 5)
		{
			rettVal=false;
			
		}
		else
		{
			
			std::string word=MagicWord;
			if (word=="width")
			rettVal=true;
		}

		fclose (pFile);
	}
	return rettVal;

	
}

bool GameManager::isGameSavedFormat(std::string pp)
{
	bool retval=false;
	
	Serializer sse;
	sse.readFile(pp);
	std::string mottiWord;
	sse>>mottiWord;		
	if (mottiWord=="GNU_Motti_V1")
	{
		return true;
	}
	return retval;

	
}



void GameManager::transitionNewLocalOpenMenu(){

	if (actualIndexMenu_<0) 
		actualIndexMenu_=0;
	if (actualIndexMenu_>=myMenu_->getMenuElements().size()) 
		actualIndexMenu_=(int)myMenu_->getMenuElements().size();
	
	if (actualIndexMenu_==0) 
	{
		
		actualState_=previousState_;
		return;
	}
	if (((unsigned int )actualIndexMenu_)>myMenu_->getMenuElements().size()) 
		actualIndexMenu_=(int)myMenu_->getMenuElements().size()-1;
	
	 BoxElement *el=myMenu_->getMenuElements().at(actualIndexMenu_);
	 LabelBoxElement *el2=dynamic_cast<LabelBoxElement*>(el);
	 //LabelBoxElement *el2=( LabelBoxElement*)((&el);
	 
	 if (el2!=NULL)
	 {
#ifdef WIN32		
		std::string filename=actualDir_+"\\"+el2->getLabel();
#else
		std::string filename=actualDir_+"/"+el2->getLabel();
#endif
		if (isDir(filename))
		{
			actualState_=NEW_LOCAL_GAME_OPEN;
#ifdef WIN32		
			actualDir_=actualDir_+"\\"+filename;
#else
			actualDir_=actualDir_+"/"+filename;	
#endif			
		}
		else
		{
		
			if (isGameOldFormat(filename))
			{
				previousState_=INGAME;
				actualState_=DIALOG_BOX;
				meesBox_->setTitle("Game Info");
				std::stringstream message;
				message<<"Loading the MAP :\n"<<filename<<"\n";
				meesBox_->setMessage(message.str());
				drawer_->draw(meesBox_);
				*board_=MapManager::loadFileMap(filename);
				meesBox_->setTitle("Opened Map");
				std::stringstream message2;
				message2<<filename<<"\n";
				message2<<"Turn and Turn based\n";
				message2<<"Nb Players:"<<board_->getNbPlayers()<<"\n";
				message2<<"Width:"<<board_->getWidth()<<"\n";
				message2<<"Height:"<<board_->getHeight()<<"\n";
	
				meesBox_->setMessage(message2.str());
				init();
				actualState_=INGAME_SELECT_PLAYERS;
				firstTime_=true;
				board_->setWinner(NULL);
			}
			else if (isGameSavedFormat(filename))
			{
				
				std::string hh;
				Serializer sse;
				
				meesBox_->setTitle("Game Info");
				std::stringstream message;
				message<<"Loading the saved game :\n"<<filename<<"\n";
				meesBox_->setMessage(message.str());
				drawer_->draw(meesBox_);
				sse.readFile(filename);
				
				sse >> hh;
				sse >> *board_;
				
				previousState_=INGAME;
				actualState_=INGAME;
				firstTime_=true;
				board_->setWinner(NULL);
			
				
			}
			else
			{
				
				actualState_=DIALOG_BOX;
				meesBox_->setTitle("File Error");
				meesBox_->setMessage("The file "+filename+" is not a regular map .");
			}
		}
	 }
	actualIndexMenu_=0;

}
#ifndef WIN32
#include <time.h>
#endif

void sleepMill(int milliseconds)
{
#ifndef WIN32
		struct timespec tmReq;
		
		 tmReq.tv_sec = (time_t)(milliseconds / 1000);
		tmReq.tv_nsec = (milliseconds % 1000) * 1000 * 1000;

		nanosleep(&tmReq,(timespec *)NULL);
#endif		

}
void GameManager::manageInGame(CommandManager::ACTIONKEY KEY){

	

	if (firstTime_&&board_->getWinner()==NULL)
	{
		firstTime_=false;
		rulesManager_.cleanSurvyvor();
		previousState_=INGAME;
		actualState_=INGAME;
		meesBox_->setTitle("Game Info");
		std::stringstream message;
		message<<"Player '"<<board_->getActualPlayer()->getName()<<"' is playing .\n";
		meesBox_->setMessage(message.str());
		drawer_->refreshConfig();
		drawer_->setCursorPlacement( drawer_->getWidth()/2, drawer_->getHeight()/2);
		drawer_->draw(meesBox_);
		sleepMill(350);
		if (board_->getActualPlayer()->getType()==Player::COMPUTER)
		{
			AiPlayer pp(board_->getActualPlayer(),&rulesManager_);
			meesBox_->setTitle("Game Info");
			std::stringstream message;
			message<<"Computer Player '"<<board_->getActualPlayer()->getName()<<"' is playing .\n";
			meesBox_->setMessage(message.str());
			drawer_->draw(meesBox_);
			if (!board_->getActualPlayer()->hasLost())
			pp.think(board_);
			std::stringstream message2;
			message2<<"Computer Player '"<<board_->getActualPlayer()->getName()<<"' has played .\n";
			meesBox_->setMessage(message2.str());
			drawer_->draw();
			drawer_->draw(meesBox_);
			KEY=CommandManager::RETURN;
			sleepMill(400);
		}
	}
	if (board_->getWinner()!=NULL)
	{
		previousState_=START_MENU;
		actualState_=DIALOG_BOX;
		meesBox_->setTitle("Game Info");
		std::stringstream message;
		message<<"Player '"<<board_->getWinner()->getName()<<"' is the Winner .\n";
		meesBox_->setMessage(message.str());
		drawer_->draw(meesBox_);
		sleepMill(2000);
	
	}
	bool isChanged=false;
	
	std::stringstream message;
	switch (KEY)
	{
		case CommandManager::RIGHT: 
			drawer_->right();
			isChanged=true;
			break;
		case CommandManager::LEFT: 
			drawer_->left();
			isChanged=true;
			break;
		
		case CommandManager::UP: 
			drawer_->up();
			isChanged=true;
			break;
		case CommandManager::ESCAPE: 
			actualState_=INGAME_HELP;
			actualIndexMenu_=0;
			actualIndexMenu_=-1;
			manageMenu(CommandManager::DOWN);
			isChanged=false;
		
			break;
		case CommandManager::DOWN:
			drawer_->down();
			isChanged=true;
			break;
		case CommandManager::ACTION:
		
			if (board_->getActionMode()==Board::NOTCHOOSE)
			{	
				actualIndexMenu_=-1;
				actualState_=INGAME_SELECT_ACTION;
				manageMenu(CommandManager::DOWN);
				isChanged=false;
				
			}
			else{
				if (board_->getActionMode()==Board::ATTACK)
				{
					if (board_->getCaseNoThrow(drawer_->getXMap(),drawer_->getYMap())!=NULL)
					{
						if (board_->getCaseNoThrow(drawer_->getXMap(),drawer_->getYMap())->getType()==Case::SELECTED)
						{
							unattack(getActualPlayer(),drawer_->getXMap(),drawer_->getYMap());
						}
						else
						{
							attack(getActualPlayer(),drawer_->getXMap(),drawer_->getYMap());
						}
					}
					
				}
				if (board_->getActionMode()==Board::DEFEND)
				{
					if (board_->getCaseNoThrow(drawer_->getXMap(),drawer_->getYMap())!=NULL)
					{
						if (board_->getCaseNoThrow(drawer_->getXMap(),drawer_->getYMap())->getType()==Case::SELECTED)
						{
							undefend(getActualPlayer(),drawer_->getXMap(),drawer_->getYMap());
						}
						else
						{
							defend(getActualPlayer(),drawer_->getXMap(),drawer_->getYMap());
						}
					}
				}
				if (board_->getActionMode()==Board::GUERILLA)
				{
					if (board_->getCaseNoThrow(drawer_->getXMap(),drawer_->getYMap())!=NULL)
					{
						if (board_->getCaseNoThrow(drawer_->getXMap(),drawer_->getYMap())->getType()==Case::SELECTED)
						{
							unguerilla(getActualPlayer(),drawer_->getXMap(),drawer_->getYMap());
						}
						else
						{
							guerilla(getActualPlayer(),drawer_->getXMap(),drawer_->getYMap());
						}
					}
				}
				isChanged=true;
			}
			
			
			break;
		case CommandManager::RETURN:
			previousState_=INGAME;
			actualState_=INGAME;
			meesBox_->setTitle("Game Info");
			
			message<<"Calculating end turn .\n";
			meesBox_->setMessage(message.str());
			drawer_->draw(meesBox_);
			endTurn();
			sleepMill(500);
			firstTime_=true;
			
			
			meesBox_->setTitle("Game Info");
			message.str( "" );
			message<<"Player '"<<board_->getActualPlayer()->getName()<<"' is playing .\n";
			meesBox_->setMessage(message.str());
			drawer_->refreshConfig();
			drawer_->setCursorPlacement( drawer_->getWidth()/2, drawer_->getHeight()/2);
			drawer_->draw(meesBox_);
			sleepMill(500);
			
			//trySave=true;
			
			isChanged=true;
		default:
			break;
	
	}
	if (isChanged)
	{
		drawer_->draw();
		drawer_->redrawCursor();
	}
	
}

std::vector<BoxElement *> GameManager::listLabelDir(std::string direrc){
	std::vector<std::string> rrr=listDir(direrc);
	std::vector<BoxElement *> ret;
	std::vector<std::string>::iterator itt=rrr.begin();
	ret.push_back(new LabelBoxElement("Return"));
	while (itt!=rrr.end())
	{
		if (filterMottiSavedGame_)
		{
			if ((*itt).find(".mtt")!=std::string::npos||(*itt)==".."||(*itt)=="."||isDir(direrc+"/"+(*itt)))
				ret.push_back(new LabelBoxElement(*itt));
		}
		else if (filterMottiMap_)
		{
			if ((*itt).find(".map")!=std::string::npos||(*itt)==".."||(*itt)=="."||isDir(direrc+"/"+(*itt)))
			ret.push_back(new LabelBoxElement(*itt));
		
		}
		else
		{
			ret.push_back(new LabelBoxElement(*itt));
		}
		itt++;
	}
	return ret;
}

//Open directory
#include <stdio.h>
#include <sys/types.h>
#include <errno.h>
#ifdef __CYGWIN32__
#include <dirent.h>
#else
#ifdef WIN32
#include "dirente.h"
#else
#include <dirent.h>
#endif
#endif

std::vector<std::string> GameManager::listDir(std::string direrc){
	std::vector<std::string> list;
	DIR *dir;
	  struct dirent *entry;

	  if ((dir = opendir(direrc.c_str())) == NULL) {
		perror("opendir(3)");
		return list;
	  }

	  entry = readdir(dir);

	  while (entry) {
		  list.push_back(entry->d_name);
		//puts(entry->d_name);
		entry = readdir(dir);
	  }

	  closedir(dir);

	  return list;
}

