/* ex: set ro ft=c: -*- mode: c; buffer-read-only: t -*- */
/*****************************************************************************/
/*  LibreDWG - free implementation of the DWG file format                    */
/*                                                                           */
/*  Copyright (C) 2019-2020 Free Software Foundation, Inc.                   */
/*                                                                           */
/*  This library is free software, licensed under the terms of the GNU       */
/*  General Public License as published by the Free Software Foundation,     */
/*  either version 3 of the License, or (at your option) any later version.  */
/*  You should have received a copy of the GNU General Public License        */
/*  along with this program.  If not, see <http://www.gnu.org/licenses/>.    */
/*****************************************************************************/
/* dynapi coverage tests, generated by gen-dynapi.pl from dynapi_test.c.in
   do not modify */
/* written by: Reini Urban */

#line 16 "dynapi_test.c.in"
#define DYNAPI_TEST_C
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <math.h>
#include <sys/stat.h>

#define DWG_LOGLEVEL DWG_LOGLEVEL_NONE
#include "../../src/config.h"
#include "../../src/common.h"
#include "../../src/classes.h"
#include "dwg.h"
#include "dwg_api.h"
#include "tests_common.h"

/* for all objects/entities/header_vars:
   compare direct api vs dynapi values
*/
static int
test_header (const Dwg_Data *dwg)
{
  int error = 0;
  BITCODE_RL rl;
  BITCODE_RC rc;
  BITCODE_BLL bll;
  BITCODE_BD bd;
  BITCODE_TV tv;

#line 47 "dynapi_test.c"
  /* @@for test_HEADER@@ */
  {
    BITCODE_RL size;
    if (dwg_dynapi_header_value (dwg, "size", &size, NULL)
        && size == dwg->header_vars.size)
      pass ();
    else
      fail ("HEADER.size [RL] %u != %u", dwg->header_vars.size, size);
    size++;
    if (dwg_dynapi_header_set_value (dwg, "size", &size, 0)
        && size == dwg->header_vars.size)
      pass ();
    else
      fail ("HEADER.size [RL] set+1 %u != %u",
            dwg->header_vars.size, size);
    size--;
    dwg_dynapi_header_set_value (dwg, "size", &size, 0);

  }
  {
    BITCODE_RL bitsize_hi;
    if (dwg_dynapi_header_value (dwg, "bitsize_hi", &bitsize_hi, NULL)
        && bitsize_hi == dwg->header_vars.bitsize_hi)
      pass ();
    else
      fail ("HEADER.bitsize_hi [RL] %u != %u", dwg->header_vars.bitsize_hi, bitsize_hi);
    bitsize_hi++;
    if (dwg_dynapi_header_set_value (dwg, "bitsize_hi", &bitsize_hi, 0)
        && bitsize_hi == dwg->header_vars.bitsize_hi)
      pass ();
    else
      fail ("HEADER.bitsize_hi [RL] set+1 %u != %u",
            dwg->header_vars.bitsize_hi, bitsize_hi);
    bitsize_hi--;
    dwg_dynapi_header_set_value (dwg, "bitsize_hi", &bitsize_hi, 0);

  }
  {
    BITCODE_RL bitsize;
    if (dwg_dynapi_header_value (dwg, "bitsize", &bitsize, NULL)
        && bitsize == dwg->header_vars.bitsize)
      pass ();
    else
      fail ("HEADER.bitsize [RL] %u != %u", dwg->header_vars.bitsize, bitsize);
    bitsize++;
    if (dwg_dynapi_header_set_value (dwg, "bitsize", &bitsize, 0)
        && bitsize == dwg->header_vars.bitsize)
      pass ();
    else
      fail ("HEADER.bitsize [RL] set+1 %u != %u",
            dwg->header_vars.bitsize, bitsize);
    bitsize--;
    dwg_dynapi_header_set_value (dwg, "bitsize", &bitsize, 0);

  }
  {
    BITCODE_RC acadmaintver;
    if (dwg_dynapi_header_value (dwg, "ACADMAINTVER", &acadmaintver, NULL)
        && acadmaintver == dwg->header_vars.ACADMAINTVER)
      pass ();
    else
      fail ("HEADER.ACADMAINTVER [RC] %u != %u", dwg->header_vars.ACADMAINTVER, acadmaintver);
    acadmaintver++;
    if (dwg_dynapi_header_set_value (dwg, "ACADMAINTVER", &acadmaintver, 0)
        && acadmaintver == dwg->header_vars.ACADMAINTVER)
      pass ();
    else
      fail ("HEADER.ACADMAINTVER [RC] set+1 %u != %u",
            dwg->header_vars.ACADMAINTVER, acadmaintver);
    acadmaintver--;
    dwg_dynapi_header_set_value (dwg, "ACADMAINTVER", &acadmaintver, 0);

  }
  {
    BITCODE_BLL requiredversions;
    if (dwg_dynapi_header_value (dwg, "REQUIREDVERSIONS", &requiredversions, NULL)
        && requiredversions == dwg->header_vars.REQUIREDVERSIONS)
      pass ();
    else
      fail ("HEADER.REQUIREDVERSIONS [BLL] " FORMAT_BLL " != " FORMAT_BLL "", dwg->header_vars.REQUIREDVERSIONS, requiredversions);
    requiredversions++;
    if (dwg_dynapi_header_set_value (dwg, "REQUIREDVERSIONS", &requiredversions, 0)
        && requiredversions == dwg->header_vars.REQUIREDVERSIONS)
      pass ();
    else
      fail ("HEADER.REQUIREDVERSIONS [BLL] set+1 " FORMAT_BLL " != " FORMAT_BLL "",
            dwg->header_vars.REQUIREDVERSIONS, requiredversions);
    requiredversions--;
    dwg_dynapi_header_set_value (dwg, "REQUIREDVERSIONS", &requiredversions, 0);

  }
  {
    BITCODE_TV dwgcodepage;
    if (dwg_dynapi_header_value (dwg, "DWGCODEPAGE", &dwgcodepage, NULL)
        && !memcmp (&dwgcodepage, &dwg->header_vars.DWGCODEPAGE, sizeof (dwg->header_vars.DWGCODEPAGE))
       )
      pass ();
    else
      fail ("HEADER.DWGCODEPAGE [TV]");
  }
  {
    BITCODE_BD unknown_0;
    if (dwg_dynapi_header_value (dwg, "unknown_0", &unknown_0, NULL)
        && unknown_0 == dwg->header_vars.unknown_0)
      pass ();
    else
      fail ("HEADER.unknown_0 [BD] %g != %g", dwg->header_vars.unknown_0, unknown_0);
    unknown_0++;
    if (dwg_dynapi_header_set_value (dwg, "unknown_0", &unknown_0, 0)
        && unknown_0 == dwg->header_vars.unknown_0)
      pass ();
    else
      fail ("HEADER.unknown_0 [BD] set+1 %g != %g",
            dwg->header_vars.unknown_0, unknown_0);
    unknown_0--;
    dwg_dynapi_header_set_value (dwg, "unknown_0", &unknown_0, 0);

  }
  {
    BITCODE_BD unknown_1;
    if (dwg_dynapi_header_value (dwg, "unknown_1", &unknown_1, NULL)
        && unknown_1 == dwg->header_vars.unknown_1)
      pass ();
    else
      fail ("HEADER.unknown_1 [BD] %g != %g", dwg->header_vars.unknown_1, unknown_1);
    unknown_1++;
    if (dwg_dynapi_header_set_value (dwg, "unknown_1", &unknown_1, 0)
        && unknown_1 == dwg->header_vars.unknown_1)
      pass ();
    else
      fail ("HEADER.unknown_1 [BD] set+1 %g != %g",
            dwg->header_vars.unknown_1, unknown_1);
    unknown_1--;
    dwg_dynapi_header_set_value (dwg, "unknown_1", &unknown_1, 0);

  }
  {
    BITCODE_BD unknown_2;
    if (dwg_dynapi_header_value (dwg, "unknown_2", &unknown_2, NULL)
        && unknown_2 == dwg->header_vars.unknown_2)
      pass ();
    else
      fail ("HEADER.unknown_2 [BD] %g != %g", dwg->header_vars.unknown_2, unknown_2);
    unknown_2++;
    if (dwg_dynapi_header_set_value (dwg, "unknown_2", &unknown_2, 0)
        && unknown_2 == dwg->header_vars.unknown_2)
      pass ();
    else
      fail ("HEADER.unknown_2 [BD] set+1 %g != %g",
            dwg->header_vars.unknown_2, unknown_2);
    unknown_2--;
    dwg_dynapi_header_set_value (dwg, "unknown_2", &unknown_2, 0);

  }
  {
    BITCODE_BD unknown_3;
    if (dwg_dynapi_header_value (dwg, "unknown_3", &unknown_3, NULL)
        && unknown_3 == dwg->header_vars.unknown_3)
      pass ();
    else
      fail ("HEADER.unknown_3 [BD] %g != %g", dwg->header_vars.unknown_3, unknown_3);
    unknown_3++;
    if (dwg_dynapi_header_set_value (dwg, "unknown_3", &unknown_3, 0)
        && unknown_3 == dwg->header_vars.unknown_3)
      pass ();
    else
      fail ("HEADER.unknown_3 [BD] set+1 %g != %g",
            dwg->header_vars.unknown_3, unknown_3);
    unknown_3--;
    dwg_dynapi_header_set_value (dwg, "unknown_3", &unknown_3, 0);

  }
  {
    BITCODE_TV unknown_text1;
    if (dwg_dynapi_header_value (dwg, "unknown_text1", &unknown_text1, NULL)
        && !memcmp (&unknown_text1, &dwg->header_vars.unknown_text1, sizeof (dwg->header_vars.unknown_text1))
       )
      pass ();
    else
      fail ("HEADER.unknown_text1 [TV]");
  }
  {
    BITCODE_TV unknown_text2;
    if (dwg_dynapi_header_value (dwg, "unknown_text2", &unknown_text2, NULL)
        && !memcmp (&unknown_text2, &dwg->header_vars.unknown_text2, sizeof (dwg->header_vars.unknown_text2))
       )
      pass ();
    else
      fail ("HEADER.unknown_text2 [TV]");
  }
  {
    BITCODE_TV unknown_text3;
    if (dwg_dynapi_header_value (dwg, "unknown_text3", &unknown_text3, NULL)
        && !memcmp (&unknown_text3, &dwg->header_vars.unknown_text3, sizeof (dwg->header_vars.unknown_text3))
       )
      pass ();
    else
      fail ("HEADER.unknown_text3 [TV]");
  }
  {
    BITCODE_TV unknown_text4;
    if (dwg_dynapi_header_value (dwg, "unknown_text4", &unknown_text4, NULL)
        && !memcmp (&unknown_text4, &dwg->header_vars.unknown_text4, sizeof (dwg->header_vars.unknown_text4))
       )
      pass ();
    else
      fail ("HEADER.unknown_text4 [TV]");
  }
  {
    BITCODE_BL unknown_8;
    if (dwg_dynapi_header_value (dwg, "unknown_8", &unknown_8, NULL)
        && unknown_8 == dwg->header_vars.unknown_8)
      pass ();
    else
      fail ("HEADER.unknown_8 [BL] %u != %u", dwg->header_vars.unknown_8, unknown_8);
    unknown_8++;
    if (dwg_dynapi_header_set_value (dwg, "unknown_8", &unknown_8, 0)
        && unknown_8 == dwg->header_vars.unknown_8)
      pass ();
    else
      fail ("HEADER.unknown_8 [BL] set+1 %u != %u",
            dwg->header_vars.unknown_8, unknown_8);
    unknown_8--;
    dwg_dynapi_header_set_value (dwg, "unknown_8", &unknown_8, 0);

  }
  {
    BITCODE_BL unknown_9;
    if (dwg_dynapi_header_value (dwg, "unknown_9", &unknown_9, NULL)
        && unknown_9 == dwg->header_vars.unknown_9)
      pass ();
    else
      fail ("HEADER.unknown_9 [BL] %u != %u", dwg->header_vars.unknown_9, unknown_9);
    unknown_9++;
    if (dwg_dynapi_header_set_value (dwg, "unknown_9", &unknown_9, 0)
        && unknown_9 == dwg->header_vars.unknown_9)
      pass ();
    else
      fail ("HEADER.unknown_9 [BL] set+1 %u != %u",
            dwg->header_vars.unknown_9, unknown_9);
    unknown_9--;
    dwg_dynapi_header_set_value (dwg, "unknown_9", &unknown_9, 0);

  }
  {
    BITCODE_BS unknown_10;
    if (dwg_dynapi_header_value (dwg, "unknown_10", &unknown_10, NULL)
        && unknown_10 == dwg->header_vars.unknown_10)
      pass ();
    else
      fail ("HEADER.unknown_10 [BS] %hu != %hu", dwg->header_vars.unknown_10, unknown_10);
    unknown_10++;
    if (dwg_dynapi_header_set_value (dwg, "unknown_10", &unknown_10, 0)
        && unknown_10 == dwg->header_vars.unknown_10)
      pass ();
    else
      fail ("HEADER.unknown_10 [BS] set+1 %hu != %hu",
            dwg->header_vars.unknown_10, unknown_10);
    unknown_10--;
    dwg_dynapi_header_set_value (dwg, "unknown_10", &unknown_10, 0);

  }
  {
    BITCODE_H vx_table_record;
    if (dwg_dynapi_header_value (dwg, "VX_TABLE_RECORD", &vx_table_record, NULL)
        && !memcmp (&vx_table_record, &dwg->header_vars.VX_TABLE_RECORD, sizeof (dwg->header_vars.VX_TABLE_RECORD))
       )
      pass ();
    else
      fail ("HEADER.VX_TABLE_RECORD [H]");
  }
  {
    BITCODE_B dimaso;
    if (dwg_dynapi_header_value (dwg, "DIMASO", &dimaso, NULL)
        && dimaso == dwg->header_vars.DIMASO)
      pass ();
    else
      fail ("HEADER.DIMASO [B] " FORMAT_B " != " FORMAT_B "", dwg->header_vars.DIMASO, dimaso);
    dimaso++;
    if (dwg_dynapi_header_set_value (dwg, "DIMASO", &dimaso, 0)
        && dimaso == dwg->header_vars.DIMASO)
      pass ();
    else
      fail ("HEADER.DIMASO [B] set+1 " FORMAT_B " != " FORMAT_B "",
            dwg->header_vars.DIMASO, dimaso);
    dimaso--;
    dwg_dynapi_header_set_value (dwg, "DIMASO", &dimaso, 0);

  }
  {
    BITCODE_B dimsho;
    if (dwg_dynapi_header_value (dwg, "DIMSHO", &dimsho, NULL)
        && dimsho == dwg->header_vars.DIMSHO)
      pass ();
    else
      fail ("HEADER.DIMSHO [B] " FORMAT_B " != " FORMAT_B "", dwg->header_vars.DIMSHO, dimsho);
    dimsho++;
    if (dwg_dynapi_header_set_value (dwg, "DIMSHO", &dimsho, 0)
        && dimsho == dwg->header_vars.DIMSHO)
      pass ();
    else
      fail ("HEADER.DIMSHO [B] set+1 " FORMAT_B " != " FORMAT_B "",
            dwg->header_vars.DIMSHO, dimsho);
    dimsho--;
    dwg_dynapi_header_set_value (dwg, "DIMSHO", &dimsho, 0);

  }
  {
    BITCODE_B dimsav;
    if (dwg_dynapi_header_value (dwg, "DIMSAV", &dimsav, NULL)
        && dimsav == dwg->header_vars.DIMSAV)
      pass ();
    else
      fail ("HEADER.DIMSAV [B] " FORMAT_B " != " FORMAT_B "", dwg->header_vars.DIMSAV, dimsav);
    dimsav++;
    if (dwg_dynapi_header_set_value (dwg, "DIMSAV", &dimsav, 0)
        && dimsav == dwg->header_vars.DIMSAV)
      pass ();
    else
      fail ("HEADER.DIMSAV [B] set+1 " FORMAT_B " != " FORMAT_B "",
            dwg->header_vars.DIMSAV, dimsav);
    dimsav--;
    dwg_dynapi_header_set_value (dwg, "DIMSAV", &dimsav, 0);

  }
  {
    BITCODE_B plinegen;
    if (dwg_dynapi_header_value (dwg, "PLINEGEN", &plinegen, NULL)
        && plinegen == dwg->header_vars.PLINEGEN)
      pass ();
    else
      fail ("HEADER.PLINEGEN [B] " FORMAT_B " != " FORMAT_B "", dwg->header_vars.PLINEGEN, plinegen);
    plinegen++;
    if (dwg_dynapi_header_set_value (dwg, "PLINEGEN", &plinegen, 0)
        && plinegen == dwg->header_vars.PLINEGEN)
      pass ();
    else
      fail ("HEADER.PLINEGEN [B] set+1 " FORMAT_B " != " FORMAT_B "",
            dwg->header_vars.PLINEGEN, plinegen);
    plinegen--;
    dwg_dynapi_header_set_value (dwg, "PLINEGEN", &plinegen, 0);

  }
  {
    BITCODE_B orthomode;
    if (dwg_dynapi_header_value (dwg, "ORTHOMODE", &orthomode, NULL)
        && orthomode == dwg->header_vars.ORTHOMODE)
      pass ();
    else
      fail ("HEADER.ORTHOMODE [B] " FORMAT_B " != " FORMAT_B "", dwg->header_vars.ORTHOMODE, orthomode);
    orthomode++;
    if (dwg_dynapi_header_set_value (dwg, "ORTHOMODE", &orthomode, 0)
        && orthomode == dwg->header_vars.ORTHOMODE)
      pass ();
    else
      fail ("HEADER.ORTHOMODE [B] set+1 " FORMAT_B " != " FORMAT_B "",
            dwg->header_vars.ORTHOMODE, orthomode);
    orthomode--;
    dwg_dynapi_header_set_value (dwg, "ORTHOMODE", &orthomode, 0);

  }
  {
    BITCODE_B regenmode;
    if (dwg_dynapi_header_value (dwg, "REGENMODE", &regenmode, NULL)
        && regenmode == dwg->header_vars.REGENMODE)
      pass ();
    else
      fail ("HEADER.REGENMODE [B] " FORMAT_B " != " FORMAT_B "", dwg->header_vars.REGENMODE, regenmode);
    regenmode++;
    if (dwg_dynapi_header_set_value (dwg, "REGENMODE", &regenmode, 0)
        && regenmode == dwg->header_vars.REGENMODE)
      pass ();
    else
      fail ("HEADER.REGENMODE [B] set+1 " FORMAT_B " != " FORMAT_B "",
            dwg->header_vars.REGENMODE, regenmode);
    regenmode--;
    dwg_dynapi_header_set_value (dwg, "REGENMODE", &regenmode, 0);

  }
  {
    BITCODE_B fillmode;
    if (dwg_dynapi_header_value (dwg, "FILLMODE", &fillmode, NULL)
        && fillmode == dwg->header_vars.FILLMODE)
      pass ();
    else
      fail ("HEADER.FILLMODE [B] " FORMAT_B " != " FORMAT_B "", dwg->header_vars.FILLMODE, fillmode);
    fillmode++;
    if (dwg_dynapi_header_set_value (dwg, "FILLMODE", &fillmode, 0)
        && fillmode == dwg->header_vars.FILLMODE)
      pass ();
    else
      fail ("HEADER.FILLMODE [B] set+1 " FORMAT_B " != " FORMAT_B "",
            dwg->header_vars.FILLMODE, fillmode);
    fillmode--;
    dwg_dynapi_header_set_value (dwg, "FILLMODE", &fillmode, 0);

  }
  {
    BITCODE_B qtextmode;
    if (dwg_dynapi_header_value (dwg, "QTEXTMODE", &qtextmode, NULL)
        && qtextmode == dwg->header_vars.QTEXTMODE)
      pass ();
    else
      fail ("HEADER.QTEXTMODE [B] " FORMAT_B " != " FORMAT_B "", dwg->header_vars.QTEXTMODE, qtextmode);
    qtextmode++;
    if (dwg_dynapi_header_set_value (dwg, "QTEXTMODE", &qtextmode, 0)
        && qtextmode == dwg->header_vars.QTEXTMODE)
      pass ();
    else
      fail ("HEADER.QTEXTMODE [B] set+1 " FORMAT_B " != " FORMAT_B "",
            dwg->header_vars.QTEXTMODE, qtextmode);
    qtextmode--;
    dwg_dynapi_header_set_value (dwg, "QTEXTMODE", &qtextmode, 0);

  }
  {
    BITCODE_B psltscale;
    if (dwg_dynapi_header_value (dwg, "PSLTSCALE", &psltscale, NULL)
        && psltscale == dwg->header_vars.PSLTSCALE)
      pass ();
    else
      fail ("HEADER.PSLTSCALE [B] " FORMAT_B " != " FORMAT_B "", dwg->header_vars.PSLTSCALE, psltscale);
    psltscale++;
    if (dwg_dynapi_header_set_value (dwg, "PSLTSCALE", &psltscale, 0)
        && psltscale == dwg->header_vars.PSLTSCALE)
      pass ();
    else
      fail ("HEADER.PSLTSCALE [B] set+1 " FORMAT_B " != " FORMAT_B "",
            dwg->header_vars.PSLTSCALE, psltscale);
    psltscale--;
    dwg_dynapi_header_set_value (dwg, "PSLTSCALE", &psltscale, 0);

  }
  {
    BITCODE_B limcheck;
    if (dwg_dynapi_header_value (dwg, "LIMCHECK", &limcheck, NULL)
        && limcheck == dwg->header_vars.LIMCHECK)
      pass ();
    else
      fail ("HEADER.LIMCHECK [B] " FORMAT_B " != " FORMAT_B "", dwg->header_vars.LIMCHECK, limcheck);
    limcheck++;
    if (dwg_dynapi_header_set_value (dwg, "LIMCHECK", &limcheck, 0)
        && limcheck == dwg->header_vars.LIMCHECK)
      pass ();
    else
      fail ("HEADER.LIMCHECK [B] set+1 " FORMAT_B " != " FORMAT_B "",
            dwg->header_vars.LIMCHECK, limcheck);
    limcheck--;
    dwg_dynapi_header_set_value (dwg, "LIMCHECK", &limcheck, 0);

  }
  {
    BITCODE_B blipmode;
    if (dwg_dynapi_header_value (dwg, "BLIPMODE", &blipmode, NULL)
        && blipmode == dwg->header_vars.BLIPMODE)
      pass ();
    else
      fail ("HEADER.BLIPMODE [B] " FORMAT_B " != " FORMAT_B "", dwg->header_vars.BLIPMODE, blipmode);
    blipmode++;
    if (dwg_dynapi_header_set_value (dwg, "BLIPMODE", &blipmode, 0)
        && blipmode == dwg->header_vars.BLIPMODE)
      pass ();
    else
      fail ("HEADER.BLIPMODE [B] set+1 " FORMAT_B " != " FORMAT_B "",
            dwg->header_vars.BLIPMODE, blipmode);
    blipmode--;
    dwg_dynapi_header_set_value (dwg, "BLIPMODE", &blipmode, 0);

  }
  {
    BITCODE_B unknown_11;
    if (dwg_dynapi_header_value (dwg, "unknown_11", &unknown_11, NULL)
        && unknown_11 == dwg->header_vars.unknown_11)
      pass ();
    else
      fail ("HEADER.unknown_11 [B] " FORMAT_B " != " FORMAT_B "", dwg->header_vars.unknown_11, unknown_11);
    unknown_11++;
    if (dwg_dynapi_header_set_value (dwg, "unknown_11", &unknown_11, 0)
        && unknown_11 == dwg->header_vars.unknown_11)
      pass ();
    else
      fail ("HEADER.unknown_11 [B] set+1 " FORMAT_B " != " FORMAT_B "",
            dwg->header_vars.unknown_11, unknown_11);
    unknown_11--;
    dwg_dynapi_header_set_value (dwg, "unknown_11", &unknown_11, 0);

  }
  {
    BITCODE_B usrtimer;
    if (dwg_dynapi_header_value (dwg, "USRTIMER", &usrtimer, NULL)
        && usrtimer == dwg->header_vars.USRTIMER)
      pass ();
    else
      fail ("HEADER.USRTIMER [B] " FORMAT_B " != " FORMAT_B "", dwg->header_vars.USRTIMER, usrtimer);
    usrtimer++;
    if (dwg_dynapi_header_set_value (dwg, "USRTIMER", &usrtimer, 0)
        && usrtimer == dwg->header_vars.USRTIMER)
      pass ();
    else
      fail ("HEADER.USRTIMER [B] set+1 " FORMAT_B " != " FORMAT_B "",
            dwg->header_vars.USRTIMER, usrtimer);
    usrtimer--;
    dwg_dynapi_header_set_value (dwg, "USRTIMER", &usrtimer, 0);

  }
  {
    BITCODE_B skpoly;
    if (dwg_dynapi_header_value (dwg, "SKPOLY", &skpoly, NULL)
        && skpoly == dwg->header_vars.SKPOLY)
      pass ();
    else
      fail ("HEADER.SKPOLY [B] " FORMAT_B " != " FORMAT_B "", dwg->header_vars.SKPOLY, skpoly);
    skpoly++;
    if (dwg_dynapi_header_set_value (dwg, "SKPOLY", &skpoly, 0)
        && skpoly == dwg->header_vars.SKPOLY)
      pass ();
    else
      fail ("HEADER.SKPOLY [B] set+1 " FORMAT_B " != " FORMAT_B "",
            dwg->header_vars.SKPOLY, skpoly);
    skpoly--;
    dwg_dynapi_header_set_value (dwg, "SKPOLY", &skpoly, 0);

  }
  {
    BITCODE_B angdir;
    if (dwg_dynapi_header_value (dwg, "ANGDIR", &angdir, NULL)
        && angdir == dwg->header_vars.ANGDIR)
      pass ();
    else
      fail ("HEADER.ANGDIR [B] " FORMAT_B " != " FORMAT_B "", dwg->header_vars.ANGDIR, angdir);
    angdir++;
    if (dwg_dynapi_header_set_value (dwg, "ANGDIR", &angdir, 0)
        && angdir == dwg->header_vars.ANGDIR)
      pass ();
    else
      fail ("HEADER.ANGDIR [B] set+1 " FORMAT_B " != " FORMAT_B "",
            dwg->header_vars.ANGDIR, angdir);
    angdir--;
    dwg_dynapi_header_set_value (dwg, "ANGDIR", &angdir, 0);

  }
  {
    BITCODE_B splframe;
    if (dwg_dynapi_header_value (dwg, "SPLFRAME", &splframe, NULL)
        && splframe == dwg->header_vars.SPLFRAME)
      pass ();
    else
      fail ("HEADER.SPLFRAME [B] " FORMAT_B " != " FORMAT_B "", dwg->header_vars.SPLFRAME, splframe);
    splframe++;
    if (dwg_dynapi_header_set_value (dwg, "SPLFRAME", &splframe, 0)
        && splframe == dwg->header_vars.SPLFRAME)
      pass ();
    else
      fail ("HEADER.SPLFRAME [B] set+1 " FORMAT_B " != " FORMAT_B "",
            dwg->header_vars.SPLFRAME, splframe);
    splframe--;
    dwg_dynapi_header_set_value (dwg, "SPLFRAME", &splframe, 0);

  }
  {
    BITCODE_B attreq;
    if (dwg_dynapi_header_value (dwg, "ATTREQ", &attreq, NULL)
        && attreq == dwg->header_vars.ATTREQ)
      pass ();
    else
      fail ("HEADER.ATTREQ [B] " FORMAT_B " != " FORMAT_B "", dwg->header_vars.ATTREQ, attreq);
    attreq++;
    if (dwg_dynapi_header_set_value (dwg, "ATTREQ", &attreq, 0)
        && attreq == dwg->header_vars.ATTREQ)
      pass ();
    else
      fail ("HEADER.ATTREQ [B] set+1 " FORMAT_B " != " FORMAT_B "",
            dwg->header_vars.ATTREQ, attreq);
    attreq--;
    dwg_dynapi_header_set_value (dwg, "ATTREQ", &attreq, 0);

  }
  {
    BITCODE_B attdia;
    if (dwg_dynapi_header_value (dwg, "ATTDIA", &attdia, NULL)
        && attdia == dwg->header_vars.ATTDIA)
      pass ();
    else
      fail ("HEADER.ATTDIA [B] " FORMAT_B " != " FORMAT_B "", dwg->header_vars.ATTDIA, attdia);
    attdia++;
    if (dwg_dynapi_header_set_value (dwg, "ATTDIA", &attdia, 0)
        && attdia == dwg->header_vars.ATTDIA)
      pass ();
    else
      fail ("HEADER.ATTDIA [B] set+1 " FORMAT_B " != " FORMAT_B "",
            dwg->header_vars.ATTDIA, attdia);
    attdia--;
    dwg_dynapi_header_set_value (dwg, "ATTDIA", &attdia, 0);

  }
  {
    BITCODE_B mirrtext;
    if (dwg_dynapi_header_value (dwg, "MIRRTEXT", &mirrtext, NULL)
        && mirrtext == dwg->header_vars.MIRRTEXT)
      pass ();
    else
      fail ("HEADER.MIRRTEXT [B] " FORMAT_B " != " FORMAT_B "", dwg->header_vars.MIRRTEXT, mirrtext);
    mirrtext++;
    if (dwg_dynapi_header_set_value (dwg, "MIRRTEXT", &mirrtext, 0)
        && mirrtext == dwg->header_vars.MIRRTEXT)
      pass ();
    else
      fail ("HEADER.MIRRTEXT [B] set+1 " FORMAT_B " != " FORMAT_B "",
            dwg->header_vars.MIRRTEXT, mirrtext);
    mirrtext--;
    dwg_dynapi_header_set_value (dwg, "MIRRTEXT", &mirrtext, 0);

  }
  {
    BITCODE_B worldview;
    if (dwg_dynapi_header_value (dwg, "WORLDVIEW", &worldview, NULL)
        && worldview == dwg->header_vars.WORLDVIEW)
      pass ();
    else
      fail ("HEADER.WORLDVIEW [B] " FORMAT_B " != " FORMAT_B "", dwg->header_vars.WORLDVIEW, worldview);
    worldview++;
    if (dwg_dynapi_header_set_value (dwg, "WORLDVIEW", &worldview, 0)
        && worldview == dwg->header_vars.WORLDVIEW)
      pass ();
    else
      fail ("HEADER.WORLDVIEW [B] set+1 " FORMAT_B " != " FORMAT_B "",
            dwg->header_vars.WORLDVIEW, worldview);
    worldview--;
    dwg_dynapi_header_set_value (dwg, "WORLDVIEW", &worldview, 0);

  }
  {
    BITCODE_B wireframe;
    if (dwg_dynapi_header_value (dwg, "WIREFRAME", &wireframe, NULL)
        && wireframe == dwg->header_vars.WIREFRAME)
      pass ();
    else
      fail ("HEADER.WIREFRAME [B] " FORMAT_B " != " FORMAT_B "", dwg->header_vars.WIREFRAME, wireframe);
    wireframe++;
    if (dwg_dynapi_header_set_value (dwg, "WIREFRAME", &wireframe, 0)
        && wireframe == dwg->header_vars.WIREFRAME)
      pass ();
    else
      fail ("HEADER.WIREFRAME [B] set+1 " FORMAT_B " != " FORMAT_B "",
            dwg->header_vars.WIREFRAME, wireframe);
    wireframe--;
    dwg_dynapi_header_set_value (dwg, "WIREFRAME", &wireframe, 0);

  }
  {
    BITCODE_B tilemode;
    if (dwg_dynapi_header_value (dwg, "TILEMODE", &tilemode, NULL)
        && tilemode == dwg->header_vars.TILEMODE)
      pass ();
    else
      fail ("HEADER.TILEMODE [B] " FORMAT_B " != " FORMAT_B "", dwg->header_vars.TILEMODE, tilemode);
    tilemode++;
    if (dwg_dynapi_header_set_value (dwg, "TILEMODE", &tilemode, 0)
        && tilemode == dwg->header_vars.TILEMODE)
      pass ();
    else
      fail ("HEADER.TILEMODE [B] set+1 " FORMAT_B " != " FORMAT_B "",
            dwg->header_vars.TILEMODE, tilemode);
    tilemode--;
    dwg_dynapi_header_set_value (dwg, "TILEMODE", &tilemode, 0);

  }
  {
    BITCODE_B plimcheck;
    if (dwg_dynapi_header_value (dwg, "PLIMCHECK", &plimcheck, NULL)
        && plimcheck == dwg->header_vars.PLIMCHECK)
      pass ();
    else
      fail ("HEADER.PLIMCHECK [B] " FORMAT_B " != " FORMAT_B "", dwg->header_vars.PLIMCHECK, plimcheck);
    plimcheck++;
    if (dwg_dynapi_header_set_value (dwg, "PLIMCHECK", &plimcheck, 0)
        && plimcheck == dwg->header_vars.PLIMCHECK)
      pass ();
    else
      fail ("HEADER.PLIMCHECK [B] set+1 " FORMAT_B " != " FORMAT_B "",
            dwg->header_vars.PLIMCHECK, plimcheck);
    plimcheck--;
    dwg_dynapi_header_set_value (dwg, "PLIMCHECK", &plimcheck, 0);

  }
  {
    BITCODE_B visretain;
    if (dwg_dynapi_header_value (dwg, "VISRETAIN", &visretain, NULL)
        && visretain == dwg->header_vars.VISRETAIN)
      pass ();
    else
      fail ("HEADER.VISRETAIN [B] " FORMAT_B " != " FORMAT_B "", dwg->header_vars.VISRETAIN, visretain);
    visretain++;
    if (dwg_dynapi_header_set_value (dwg, "VISRETAIN", &visretain, 0)
        && visretain == dwg->header_vars.VISRETAIN)
      pass ();
    else
      fail ("HEADER.VISRETAIN [B] set+1 " FORMAT_B " != " FORMAT_B "",
            dwg->header_vars.VISRETAIN, visretain);
    visretain--;
    dwg_dynapi_header_set_value (dwg, "VISRETAIN", &visretain, 0);

  }
  {
    BITCODE_B delobj;
    if (dwg_dynapi_header_value (dwg, "DELOBJ", &delobj, NULL)
        && delobj == dwg->header_vars.DELOBJ)
      pass ();
    else
      fail ("HEADER.DELOBJ [B] " FORMAT_B " != " FORMAT_B "", dwg->header_vars.DELOBJ, delobj);
    delobj++;
    if (dwg_dynapi_header_set_value (dwg, "DELOBJ", &delobj, 0)
        && delobj == dwg->header_vars.DELOBJ)
      pass ();
    else
      fail ("HEADER.DELOBJ [B] set+1 " FORMAT_B " != " FORMAT_B "",
            dwg->header_vars.DELOBJ, delobj);
    delobj--;
    dwg_dynapi_header_set_value (dwg, "DELOBJ", &delobj, 0);

  }
  {
    BITCODE_B dispsilh;
    if (dwg_dynapi_header_value (dwg, "DISPSILH", &dispsilh, NULL)
        && dispsilh == dwg->header_vars.DISPSILH)
      pass ();
    else
      fail ("HEADER.DISPSILH [B] " FORMAT_B " != " FORMAT_B "", dwg->header_vars.DISPSILH, dispsilh);
    dispsilh++;
    if (dwg_dynapi_header_set_value (dwg, "DISPSILH", &dispsilh, 0)
        && dispsilh == dwg->header_vars.DISPSILH)
      pass ();
    else
      fail ("HEADER.DISPSILH [B] set+1 " FORMAT_B " != " FORMAT_B "",
            dwg->header_vars.DISPSILH, dispsilh);
    dispsilh--;
    dwg_dynapi_header_set_value (dwg, "DISPSILH", &dispsilh, 0);

  }
  {
    BITCODE_B pellipse;
    if (dwg_dynapi_header_value (dwg, "PELLIPSE", &pellipse, NULL)
        && pellipse == dwg->header_vars.PELLIPSE)
      pass ();
    else
      fail ("HEADER.PELLIPSE [B] " FORMAT_B " != " FORMAT_B "", dwg->header_vars.PELLIPSE, pellipse);
    pellipse++;
    if (dwg_dynapi_header_set_value (dwg, "PELLIPSE", &pellipse, 0)
        && pellipse == dwg->header_vars.PELLIPSE)
      pass ();
    else
      fail ("HEADER.PELLIPSE [B] set+1 " FORMAT_B " != " FORMAT_B "",
            dwg->header_vars.PELLIPSE, pellipse);
    pellipse--;
    dwg_dynapi_header_set_value (dwg, "PELLIPSE", &pellipse, 0);

  }
  {
    BITCODE_BS saveimages;
    if (dwg_dynapi_header_value (dwg, "SAVEIMAGES", &saveimages, NULL)
        && saveimages == dwg->header_vars.SAVEIMAGES)
      pass ();
    else
      fail ("HEADER.SAVEIMAGES [BS] %hu != %hu", dwg->header_vars.SAVEIMAGES, saveimages);
    saveimages++;
    if (dwg_dynapi_header_set_value (dwg, "SAVEIMAGES", &saveimages, 0)
        && saveimages == dwg->header_vars.SAVEIMAGES)
      pass ();
    else
      fail ("HEADER.SAVEIMAGES [BS] set+1 %hu != %hu",
            dwg->header_vars.SAVEIMAGES, saveimages);
    saveimages--;
    dwg_dynapi_header_set_value (dwg, "SAVEIMAGES", &saveimages, 0);

  }
  {
    BITCODE_BS proxygraphics;
    if (dwg_dynapi_header_value (dwg, "PROXYGRAPHICS", &proxygraphics, NULL)
        && proxygraphics == dwg->header_vars.PROXYGRAPHICS)
      pass ();
    else
      fail ("HEADER.PROXYGRAPHICS [BS] %hu != %hu", dwg->header_vars.PROXYGRAPHICS, proxygraphics);
    proxygraphics++;
    if (dwg_dynapi_header_set_value (dwg, "PROXYGRAPHICS", &proxygraphics, 0)
        && proxygraphics == dwg->header_vars.PROXYGRAPHICS)
      pass ();
    else
      fail ("HEADER.PROXYGRAPHICS [BS] set+1 %hu != %hu",
            dwg->header_vars.PROXYGRAPHICS, proxygraphics);
    proxygraphics--;
    dwg_dynapi_header_set_value (dwg, "PROXYGRAPHICS", &proxygraphics, 0);

  }
  {
    BITCODE_BS measurement;
    if (dwg_dynapi_header_value (dwg, "MEASUREMENT", &measurement, NULL)
        && measurement == dwg->header_vars.MEASUREMENT)
      pass ();
    else
      fail ("HEADER.MEASUREMENT [BS] %hu != %hu", dwg->header_vars.MEASUREMENT, measurement);
    measurement++;
    if (dwg_dynapi_header_set_value (dwg, "MEASUREMENT", &measurement, 0)
        && measurement == dwg->header_vars.MEASUREMENT)
      pass ();
    else
      fail ("HEADER.MEASUREMENT [BS] set+1 %hu != %hu",
            dwg->header_vars.MEASUREMENT, measurement);
    measurement--;
    dwg_dynapi_header_set_value (dwg, "MEASUREMENT", &measurement, 0);

  }
  {
    BITCODE_BS dragmode;
    if (dwg_dynapi_header_value (dwg, "DRAGMODE", &dragmode, NULL)
        && dragmode == dwg->header_vars.DRAGMODE)
      pass ();
    else
      fail ("HEADER.DRAGMODE [BS] %hu != %hu", dwg->header_vars.DRAGMODE, dragmode);
    dragmode++;
    if (dwg_dynapi_header_set_value (dwg, "DRAGMODE", &dragmode, 0)
        && dragmode == dwg->header_vars.DRAGMODE)
      pass ();
    else
      fail ("HEADER.DRAGMODE [BS] set+1 %hu != %hu",
            dwg->header_vars.DRAGMODE, dragmode);
    dragmode--;
    dwg_dynapi_header_set_value (dwg, "DRAGMODE", &dragmode, 0);

  }
  {
    BITCODE_BS treedepth;
    if (dwg_dynapi_header_value (dwg, "TREEDEPTH", &treedepth, NULL)
        && treedepth == dwg->header_vars.TREEDEPTH)
      pass ();
    else
      fail ("HEADER.TREEDEPTH [BS] %hu != %hu", dwg->header_vars.TREEDEPTH, treedepth);
    treedepth++;
    if (dwg_dynapi_header_set_value (dwg, "TREEDEPTH", &treedepth, 0)
        && treedepth == dwg->header_vars.TREEDEPTH)
      pass ();
    else
      fail ("HEADER.TREEDEPTH [BS] set+1 %hu != %hu",
            dwg->header_vars.TREEDEPTH, treedepth);
    treedepth--;
    dwg_dynapi_header_set_value (dwg, "TREEDEPTH", &treedepth, 0);

  }
  {
    BITCODE_BS lunits;
    if (dwg_dynapi_header_value (dwg, "LUNITS", &lunits, NULL)
        && lunits == dwg->header_vars.LUNITS)
      pass ();
    else
      fail ("HEADER.LUNITS [BS] %hu != %hu", dwg->header_vars.LUNITS, lunits);
    lunits++;
    if (dwg_dynapi_header_set_value (dwg, "LUNITS", &lunits, 0)
        && lunits == dwg->header_vars.LUNITS)
      pass ();
    else
      fail ("HEADER.LUNITS [BS] set+1 %hu != %hu",
            dwg->header_vars.LUNITS, lunits);
    lunits--;
    dwg_dynapi_header_set_value (dwg, "LUNITS", &lunits, 0);

  }
  {
    BITCODE_BS luprec;
    if (dwg_dynapi_header_value (dwg, "LUPREC", &luprec, NULL)
        && luprec == dwg->header_vars.LUPREC)
      pass ();
    else
      fail ("HEADER.LUPREC [BS] %hu != %hu", dwg->header_vars.LUPREC, luprec);
    luprec++;
    if (dwg_dynapi_header_set_value (dwg, "LUPREC", &luprec, 0)
        && luprec == dwg->header_vars.LUPREC)
      pass ();
    else
      fail ("HEADER.LUPREC [BS] set+1 %hu != %hu",
            dwg->header_vars.LUPREC, luprec);
    luprec--;
    dwg_dynapi_header_set_value (dwg, "LUPREC", &luprec, 0);

  }
  {
    BITCODE_BS aunits;
    if (dwg_dynapi_header_value (dwg, "AUNITS", &aunits, NULL)
        && aunits == dwg->header_vars.AUNITS)
      pass ();
    else
      fail ("HEADER.AUNITS [BS] %hu != %hu", dwg->header_vars.AUNITS, aunits);
    aunits++;
    if (dwg_dynapi_header_set_value (dwg, "AUNITS", &aunits, 0)
        && aunits == dwg->header_vars.AUNITS)
      pass ();
    else
      fail ("HEADER.AUNITS [BS] set+1 %hu != %hu",
            dwg->header_vars.AUNITS, aunits);
    aunits--;
    dwg_dynapi_header_set_value (dwg, "AUNITS", &aunits, 0);

  }
  {
    BITCODE_BS auprec;
    if (dwg_dynapi_header_value (dwg, "AUPREC", &auprec, NULL)
        && auprec == dwg->header_vars.AUPREC)
      pass ();
    else
      fail ("HEADER.AUPREC [BS] %hu != %hu", dwg->header_vars.AUPREC, auprec);
    auprec++;
    if (dwg_dynapi_header_set_value (dwg, "AUPREC", &auprec, 0)
        && auprec == dwg->header_vars.AUPREC)
      pass ();
    else
      fail ("HEADER.AUPREC [BS] set+1 %hu != %hu",
            dwg->header_vars.AUPREC, auprec);
    auprec--;
    dwg_dynapi_header_set_value (dwg, "AUPREC", &auprec, 0);

  }
  {
    BITCODE_BS osmode;
    if (dwg_dynapi_header_value (dwg, "OSMODE", &osmode, NULL)
        && osmode == dwg->header_vars.OSMODE)
      pass ();
    else
      fail ("HEADER.OSMODE [BS] %hu != %hu", dwg->header_vars.OSMODE, osmode);
    osmode++;
    if (dwg_dynapi_header_set_value (dwg, "OSMODE", &osmode, 0)
        && osmode == dwg->header_vars.OSMODE)
      pass ();
    else
      fail ("HEADER.OSMODE [BS] set+1 %hu != %hu",
            dwg->header_vars.OSMODE, osmode);
    osmode--;
    dwg_dynapi_header_set_value (dwg, "OSMODE", &osmode, 0);

  }
  {
    BITCODE_BS attmode;
    if (dwg_dynapi_header_value (dwg, "ATTMODE", &attmode, NULL)
        && attmode == dwg->header_vars.ATTMODE)
      pass ();
    else
      fail ("HEADER.ATTMODE [BS] %hu != %hu", dwg->header_vars.ATTMODE, attmode);
    attmode++;
    if (dwg_dynapi_header_set_value (dwg, "ATTMODE", &attmode, 0)
        && attmode == dwg->header_vars.ATTMODE)
      pass ();
    else
      fail ("HEADER.ATTMODE [BS] set+1 %hu != %hu",
            dwg->header_vars.ATTMODE, attmode);
    attmode--;
    dwg_dynapi_header_set_value (dwg, "ATTMODE", &attmode, 0);

  }
  {
    BITCODE_BS coords;
    if (dwg_dynapi_header_value (dwg, "COORDS", &coords, NULL)
        && coords == dwg->header_vars.COORDS)
      pass ();
    else
      fail ("HEADER.COORDS [BS] %hu != %hu", dwg->header_vars.COORDS, coords);
    coords++;
    if (dwg_dynapi_header_set_value (dwg, "COORDS", &coords, 0)
        && coords == dwg->header_vars.COORDS)
      pass ();
    else
      fail ("HEADER.COORDS [BS] set+1 %hu != %hu",
            dwg->header_vars.COORDS, coords);
    coords--;
    dwg_dynapi_header_set_value (dwg, "COORDS", &coords, 0);

  }
  {
    BITCODE_BS pdmode;
    if (dwg_dynapi_header_value (dwg, "PDMODE", &pdmode, NULL)
        && pdmode == dwg->header_vars.PDMODE)
      pass ();
    else
      fail ("HEADER.PDMODE [BS] %hu != %hu", dwg->header_vars.PDMODE, pdmode);
    pdmode++;
    if (dwg_dynapi_header_set_value (dwg, "PDMODE", &pdmode, 0)
        && pdmode == dwg->header_vars.PDMODE)
      pass ();
    else
      fail ("HEADER.PDMODE [BS] set+1 %hu != %hu",
            dwg->header_vars.PDMODE, pdmode);
    pdmode--;
    dwg_dynapi_header_set_value (dwg, "PDMODE", &pdmode, 0);

  }
  {
    BITCODE_BS pickstyle;
    if (dwg_dynapi_header_value (dwg, "PICKSTYLE", &pickstyle, NULL)
        && pickstyle == dwg->header_vars.PICKSTYLE)
      pass ();
    else
      fail ("HEADER.PICKSTYLE [BS] %hu != %hu", dwg->header_vars.PICKSTYLE, pickstyle);
    pickstyle++;
    if (dwg_dynapi_header_set_value (dwg, "PICKSTYLE", &pickstyle, 0)
        && pickstyle == dwg->header_vars.PICKSTYLE)
      pass ();
    else
      fail ("HEADER.PICKSTYLE [BS] set+1 %hu != %hu",
            dwg->header_vars.PICKSTYLE, pickstyle);
    pickstyle--;
    dwg_dynapi_header_set_value (dwg, "PICKSTYLE", &pickstyle, 0);

  }
  {
    BITCODE_BL unknown_12;
    if (dwg_dynapi_header_value (dwg, "unknown_12", &unknown_12, NULL)
        && unknown_12 == dwg->header_vars.unknown_12)
      pass ();
    else
      fail ("HEADER.unknown_12 [BL] %u != %u", dwg->header_vars.unknown_12, unknown_12);
    unknown_12++;
    if (dwg_dynapi_header_set_value (dwg, "unknown_12", &unknown_12, 0)
        && unknown_12 == dwg->header_vars.unknown_12)
      pass ();
    else
      fail ("HEADER.unknown_12 [BL] set+1 %u != %u",
            dwg->header_vars.unknown_12, unknown_12);
    unknown_12--;
    dwg_dynapi_header_set_value (dwg, "unknown_12", &unknown_12, 0);

  }
  {
    BITCODE_BL unknown_13;
    if (dwg_dynapi_header_value (dwg, "unknown_13", &unknown_13, NULL)
        && unknown_13 == dwg->header_vars.unknown_13)
      pass ();
    else
      fail ("HEADER.unknown_13 [BL] %u != %u", dwg->header_vars.unknown_13, unknown_13);
    unknown_13++;
    if (dwg_dynapi_header_set_value (dwg, "unknown_13", &unknown_13, 0)
        && unknown_13 == dwg->header_vars.unknown_13)
      pass ();
    else
      fail ("HEADER.unknown_13 [BL] set+1 %u != %u",
            dwg->header_vars.unknown_13, unknown_13);
    unknown_13--;
    dwg_dynapi_header_set_value (dwg, "unknown_13", &unknown_13, 0);

  }
  {
    BITCODE_BL unknown_14;
    if (dwg_dynapi_header_value (dwg, "unknown_14", &unknown_14, NULL)
        && unknown_14 == dwg->header_vars.unknown_14)
      pass ();
    else
      fail ("HEADER.unknown_14 [BL] %u != %u", dwg->header_vars.unknown_14, unknown_14);
    unknown_14++;
    if (dwg_dynapi_header_set_value (dwg, "unknown_14", &unknown_14, 0)
        && unknown_14 == dwg->header_vars.unknown_14)
      pass ();
    else
      fail ("HEADER.unknown_14 [BL] set+1 %u != %u",
            dwg->header_vars.unknown_14, unknown_14);
    unknown_14--;
    dwg_dynapi_header_set_value (dwg, "unknown_14", &unknown_14, 0);

  }
  {
    BITCODE_BS useri1;
    if (dwg_dynapi_header_value (dwg, "USERI1", &useri1, NULL)
        && useri1 == dwg->header_vars.USERI1)
      pass ();
    else
      fail ("HEADER.USERI1 [BS] %hu != %hu", dwg->header_vars.USERI1, useri1);
    useri1++;
    if (dwg_dynapi_header_set_value (dwg, "USERI1", &useri1, 0)
        && useri1 == dwg->header_vars.USERI1)
      pass ();
    else
      fail ("HEADER.USERI1 [BS] set+1 %hu != %hu",
            dwg->header_vars.USERI1, useri1);
    useri1--;
    dwg_dynapi_header_set_value (dwg, "USERI1", &useri1, 0);

  }
  {
    BITCODE_BS useri2;
    if (dwg_dynapi_header_value (dwg, "USERI2", &useri2, NULL)
        && useri2 == dwg->header_vars.USERI2)
      pass ();
    else
      fail ("HEADER.USERI2 [BS] %hu != %hu", dwg->header_vars.USERI2, useri2);
    useri2++;
    if (dwg_dynapi_header_set_value (dwg, "USERI2", &useri2, 0)
        && useri2 == dwg->header_vars.USERI2)
      pass ();
    else
      fail ("HEADER.USERI2 [BS] set+1 %hu != %hu",
            dwg->header_vars.USERI2, useri2);
    useri2--;
    dwg_dynapi_header_set_value (dwg, "USERI2", &useri2, 0);

  }
  {
    BITCODE_BS useri3;
    if (dwg_dynapi_header_value (dwg, "USERI3", &useri3, NULL)
        && useri3 == dwg->header_vars.USERI3)
      pass ();
    else
      fail ("HEADER.USERI3 [BS] %hu != %hu", dwg->header_vars.USERI3, useri3);
    useri3++;
    if (dwg_dynapi_header_set_value (dwg, "USERI3", &useri3, 0)
        && useri3 == dwg->header_vars.USERI3)
      pass ();
    else
      fail ("HEADER.USERI3 [BS] set+1 %hu != %hu",
            dwg->header_vars.USERI3, useri3);
    useri3--;
    dwg_dynapi_header_set_value (dwg, "USERI3", &useri3, 0);

  }
  {
    BITCODE_BS useri4;
    if (dwg_dynapi_header_value (dwg, "USERI4", &useri4, NULL)
        && useri4 == dwg->header_vars.USERI4)
      pass ();
    else
      fail ("HEADER.USERI4 [BS] %hu != %hu", dwg->header_vars.USERI4, useri4);
    useri4++;
    if (dwg_dynapi_header_set_value (dwg, "USERI4", &useri4, 0)
        && useri4 == dwg->header_vars.USERI4)
      pass ();
    else
      fail ("HEADER.USERI4 [BS] set+1 %hu != %hu",
            dwg->header_vars.USERI4, useri4);
    useri4--;
    dwg_dynapi_header_set_value (dwg, "USERI4", &useri4, 0);

  }
  {
    BITCODE_BS useri5;
    if (dwg_dynapi_header_value (dwg, "USERI5", &useri5, NULL)
        && useri5 == dwg->header_vars.USERI5)
      pass ();
    else
      fail ("HEADER.USERI5 [BS] %hu != %hu", dwg->header_vars.USERI5, useri5);
    useri5++;
    if (dwg_dynapi_header_set_value (dwg, "USERI5", &useri5, 0)
        && useri5 == dwg->header_vars.USERI5)
      pass ();
    else
      fail ("HEADER.USERI5 [BS] set+1 %hu != %hu",
            dwg->header_vars.USERI5, useri5);
    useri5--;
    dwg_dynapi_header_set_value (dwg, "USERI5", &useri5, 0);

  }
  {
    BITCODE_BS splinesegs;
    if (dwg_dynapi_header_value (dwg, "SPLINESEGS", &splinesegs, NULL)
        && splinesegs == dwg->header_vars.SPLINESEGS)
      pass ();
    else
      fail ("HEADER.SPLINESEGS [BS] %hu != %hu", dwg->header_vars.SPLINESEGS, splinesegs);
    splinesegs++;
    if (dwg_dynapi_header_set_value (dwg, "SPLINESEGS", &splinesegs, 0)
        && splinesegs == dwg->header_vars.SPLINESEGS)
      pass ();
    else
      fail ("HEADER.SPLINESEGS [BS] set+1 %hu != %hu",
            dwg->header_vars.SPLINESEGS, splinesegs);
    splinesegs--;
    dwg_dynapi_header_set_value (dwg, "SPLINESEGS", &splinesegs, 0);

  }
  {
    BITCODE_BS surfu;
    if (dwg_dynapi_header_value (dwg, "SURFU", &surfu, NULL)
        && surfu == dwg->header_vars.SURFU)
      pass ();
    else
      fail ("HEADER.SURFU [BS] %hu != %hu", dwg->header_vars.SURFU, surfu);
    surfu++;
    if (dwg_dynapi_header_set_value (dwg, "SURFU", &surfu, 0)
        && surfu == dwg->header_vars.SURFU)
      pass ();
    else
      fail ("HEADER.SURFU [BS] set+1 %hu != %hu",
            dwg->header_vars.SURFU, surfu);
    surfu--;
    dwg_dynapi_header_set_value (dwg, "SURFU", &surfu, 0);

  }
  {
    BITCODE_BS surfv;
    if (dwg_dynapi_header_value (dwg, "SURFV", &surfv, NULL)
        && surfv == dwg->header_vars.SURFV)
      pass ();
    else
      fail ("HEADER.SURFV [BS] %hu != %hu", dwg->header_vars.SURFV, surfv);
    surfv++;
    if (dwg_dynapi_header_set_value (dwg, "SURFV", &surfv, 0)
        && surfv == dwg->header_vars.SURFV)
      pass ();
    else
      fail ("HEADER.SURFV [BS] set+1 %hu != %hu",
            dwg->header_vars.SURFV, surfv);
    surfv--;
    dwg_dynapi_header_set_value (dwg, "SURFV", &surfv, 0);

  }
  {
    BITCODE_BS surftype;
    if (dwg_dynapi_header_value (dwg, "SURFTYPE", &surftype, NULL)
        && surftype == dwg->header_vars.SURFTYPE)
      pass ();
    else
      fail ("HEADER.SURFTYPE [BS] %hu != %hu", dwg->header_vars.SURFTYPE, surftype);
    surftype++;
    if (dwg_dynapi_header_set_value (dwg, "SURFTYPE", &surftype, 0)
        && surftype == dwg->header_vars.SURFTYPE)
      pass ();
    else
      fail ("HEADER.SURFTYPE [BS] set+1 %hu != %hu",
            dwg->header_vars.SURFTYPE, surftype);
    surftype--;
    dwg_dynapi_header_set_value (dwg, "SURFTYPE", &surftype, 0);

  }
  {
    BITCODE_BS surftab1;
    if (dwg_dynapi_header_value (dwg, "SURFTAB1", &surftab1, NULL)
        && surftab1 == dwg->header_vars.SURFTAB1)
      pass ();
    else
      fail ("HEADER.SURFTAB1 [BS] %hu != %hu", dwg->header_vars.SURFTAB1, surftab1);
    surftab1++;
    if (dwg_dynapi_header_set_value (dwg, "SURFTAB1", &surftab1, 0)
        && surftab1 == dwg->header_vars.SURFTAB1)
      pass ();
    else
      fail ("HEADER.SURFTAB1 [BS] set+1 %hu != %hu",
            dwg->header_vars.SURFTAB1, surftab1);
    surftab1--;
    dwg_dynapi_header_set_value (dwg, "SURFTAB1", &surftab1, 0);

  }
  {
    BITCODE_BS surftab2;
    if (dwg_dynapi_header_value (dwg, "SURFTAB2", &surftab2, NULL)
        && surftab2 == dwg->header_vars.SURFTAB2)
      pass ();
    else
      fail ("HEADER.SURFTAB2 [BS] %hu != %hu", dwg->header_vars.SURFTAB2, surftab2);
    surftab2++;
    if (dwg_dynapi_header_set_value (dwg, "SURFTAB2", &surftab2, 0)
        && surftab2 == dwg->header_vars.SURFTAB2)
      pass ();
    else
      fail ("HEADER.SURFTAB2 [BS] set+1 %hu != %hu",
            dwg->header_vars.SURFTAB2, surftab2);
    surftab2--;
    dwg_dynapi_header_set_value (dwg, "SURFTAB2", &surftab2, 0);

  }
  {
    BITCODE_BS splinetype;
    if (dwg_dynapi_header_value (dwg, "SPLINETYPE", &splinetype, NULL)
        && splinetype == dwg->header_vars.SPLINETYPE)
      pass ();
    else
      fail ("HEADER.SPLINETYPE [BS] %hu != %hu", dwg->header_vars.SPLINETYPE, splinetype);
    splinetype++;
    if (dwg_dynapi_header_set_value (dwg, "SPLINETYPE", &splinetype, 0)
        && splinetype == dwg->header_vars.SPLINETYPE)
      pass ();
    else
      fail ("HEADER.SPLINETYPE [BS] set+1 %hu != %hu",
            dwg->header_vars.SPLINETYPE, splinetype);
    splinetype--;
    dwg_dynapi_header_set_value (dwg, "SPLINETYPE", &splinetype, 0);

  }
  {
    BITCODE_BS shadedge;
    if (dwg_dynapi_header_value (dwg, "SHADEDGE", &shadedge, NULL)
        && shadedge == dwg->header_vars.SHADEDGE)
      pass ();
    else
      fail ("HEADER.SHADEDGE [BS] %hu != %hu", dwg->header_vars.SHADEDGE, shadedge);
    shadedge++;
    if (dwg_dynapi_header_set_value (dwg, "SHADEDGE", &shadedge, 0)
        && shadedge == dwg->header_vars.SHADEDGE)
      pass ();
    else
      fail ("HEADER.SHADEDGE [BS] set+1 %hu != %hu",
            dwg->header_vars.SHADEDGE, shadedge);
    shadedge--;
    dwg_dynapi_header_set_value (dwg, "SHADEDGE", &shadedge, 0);

  }
  {
    BITCODE_BS shadedif;
    if (dwg_dynapi_header_value (dwg, "SHADEDIF", &shadedif, NULL)
        && shadedif == dwg->header_vars.SHADEDIF)
      pass ();
    else
      fail ("HEADER.SHADEDIF [BS] %hu != %hu", dwg->header_vars.SHADEDIF, shadedif);
    shadedif++;
    if (dwg_dynapi_header_set_value (dwg, "SHADEDIF", &shadedif, 0)
        && shadedif == dwg->header_vars.SHADEDIF)
      pass ();
    else
      fail ("HEADER.SHADEDIF [BS] set+1 %hu != %hu",
            dwg->header_vars.SHADEDIF, shadedif);
    shadedif--;
    dwg_dynapi_header_set_value (dwg, "SHADEDIF", &shadedif, 0);

  }
  {
    BITCODE_BS unitmode;
    if (dwg_dynapi_header_value (dwg, "UNITMODE", &unitmode, NULL)
        && unitmode == dwg->header_vars.UNITMODE)
      pass ();
    else
      fail ("HEADER.UNITMODE [BS] %hu != %hu", dwg->header_vars.UNITMODE, unitmode);
    unitmode++;
    if (dwg_dynapi_header_set_value (dwg, "UNITMODE", &unitmode, 0)
        && unitmode == dwg->header_vars.UNITMODE)
      pass ();
    else
      fail ("HEADER.UNITMODE [BS] set+1 %hu != %hu",
            dwg->header_vars.UNITMODE, unitmode);
    unitmode--;
    dwg_dynapi_header_set_value (dwg, "UNITMODE", &unitmode, 0);

  }
  {
    BITCODE_BS maxactvp;
    if (dwg_dynapi_header_value (dwg, "MAXACTVP", &maxactvp, NULL)
        && maxactvp == dwg->header_vars.MAXACTVP)
      pass ();
    else
      fail ("HEADER.MAXACTVP [BS] %hu != %hu", dwg->header_vars.MAXACTVP, maxactvp);
    maxactvp++;
    if (dwg_dynapi_header_set_value (dwg, "MAXACTVP", &maxactvp, 0)
        && maxactvp == dwg->header_vars.MAXACTVP)
      pass ();
    else
      fail ("HEADER.MAXACTVP [BS] set+1 %hu != %hu",
            dwg->header_vars.MAXACTVP, maxactvp);
    maxactvp--;
    dwg_dynapi_header_set_value (dwg, "MAXACTVP", &maxactvp, 0);

  }
  {
    BITCODE_BS isolines;
    if (dwg_dynapi_header_value (dwg, "ISOLINES", &isolines, NULL)
        && isolines == dwg->header_vars.ISOLINES)
      pass ();
    else
      fail ("HEADER.ISOLINES [BS] %hu != %hu", dwg->header_vars.ISOLINES, isolines);
    isolines++;
    if (dwg_dynapi_header_set_value (dwg, "ISOLINES", &isolines, 0)
        && isolines == dwg->header_vars.ISOLINES)
      pass ();
    else
      fail ("HEADER.ISOLINES [BS] set+1 %hu != %hu",
            dwg->header_vars.ISOLINES, isolines);
    isolines--;
    dwg_dynapi_header_set_value (dwg, "ISOLINES", &isolines, 0);

  }
  {
    BITCODE_BS cmljust;
    if (dwg_dynapi_header_value (dwg, "CMLJUST", &cmljust, NULL)
        && cmljust == dwg->header_vars.CMLJUST)
      pass ();
    else
      fail ("HEADER.CMLJUST [BS] %hu != %hu", dwg->header_vars.CMLJUST, cmljust);
    cmljust++;
    if (dwg_dynapi_header_set_value (dwg, "CMLJUST", &cmljust, 0)
        && cmljust == dwg->header_vars.CMLJUST)
      pass ();
    else
      fail ("HEADER.CMLJUST [BS] set+1 %hu != %hu",
            dwg->header_vars.CMLJUST, cmljust);
    cmljust--;
    dwg_dynapi_header_set_value (dwg, "CMLJUST", &cmljust, 0);

  }
  {
    BITCODE_BS textqlty;
    if (dwg_dynapi_header_value (dwg, "TEXTQLTY", &textqlty, NULL)
        && textqlty == dwg->header_vars.TEXTQLTY)
      pass ();
    else
      fail ("HEADER.TEXTQLTY [BS] %hu != %hu", dwg->header_vars.TEXTQLTY, textqlty);
    textqlty++;
    if (dwg_dynapi_header_set_value (dwg, "TEXTQLTY", &textqlty, 0)
        && textqlty == dwg->header_vars.TEXTQLTY)
      pass ();
    else
      fail ("HEADER.TEXTQLTY [BS] set+1 %hu != %hu",
            dwg->header_vars.TEXTQLTY, textqlty);
    textqlty--;
    dwg_dynapi_header_set_value (dwg, "TEXTQLTY", &textqlty, 0);

  }
  {
    BITCODE_BL unknown_14b;
    if (dwg_dynapi_header_value (dwg, "unknown_14b", &unknown_14b, NULL)
        && unknown_14b == dwg->header_vars.unknown_14b)
      pass ();
    else
      fail ("HEADER.unknown_14b [BL] %u != %u", dwg->header_vars.unknown_14b, unknown_14b);
    unknown_14b++;
    if (dwg_dynapi_header_set_value (dwg, "unknown_14b", &unknown_14b, 0)
        && unknown_14b == dwg->header_vars.unknown_14b)
      pass ();
    else
      fail ("HEADER.unknown_14b [BL] set+1 %u != %u",
            dwg->header_vars.unknown_14b, unknown_14b);
    unknown_14b--;
    dwg_dynapi_header_set_value (dwg, "unknown_14b", &unknown_14b, 0);

  }
  {
    BITCODE_BD ltscale;
    if (dwg_dynapi_header_value (dwg, "LTSCALE", &ltscale, NULL)
        && ltscale == dwg->header_vars.LTSCALE)
      pass ();
    else
      fail ("HEADER.LTSCALE [BD] %g != %g", dwg->header_vars.LTSCALE, ltscale);
    ltscale++;
    if (dwg_dynapi_header_set_value (dwg, "LTSCALE", &ltscale, 0)
        && ltscale == dwg->header_vars.LTSCALE)
      pass ();
    else
      fail ("HEADER.LTSCALE [BD] set+1 %g != %g",
            dwg->header_vars.LTSCALE, ltscale);
    ltscale--;
    dwg_dynapi_header_set_value (dwg, "LTSCALE", &ltscale, 0);

  }
  {
    BITCODE_BD textsize;
    if (dwg_dynapi_header_value (dwg, "TEXTSIZE", &textsize, NULL)
        && textsize == dwg->header_vars.TEXTSIZE)
      pass ();
    else
      fail ("HEADER.TEXTSIZE [BD] %g != %g", dwg->header_vars.TEXTSIZE, textsize);
    textsize++;
    if (dwg_dynapi_header_set_value (dwg, "TEXTSIZE", &textsize, 0)
        && textsize == dwg->header_vars.TEXTSIZE)
      pass ();
    else
      fail ("HEADER.TEXTSIZE [BD] set+1 %g != %g",
            dwg->header_vars.TEXTSIZE, textsize);
    textsize--;
    dwg_dynapi_header_set_value (dwg, "TEXTSIZE", &textsize, 0);

  }
  {
    BITCODE_BD tracewid;
    if (dwg_dynapi_header_value (dwg, "TRACEWID", &tracewid, NULL)
        && tracewid == dwg->header_vars.TRACEWID)
      pass ();
    else
      fail ("HEADER.TRACEWID [BD] %g != %g", dwg->header_vars.TRACEWID, tracewid);
    tracewid++;
    if (dwg_dynapi_header_set_value (dwg, "TRACEWID", &tracewid, 0)
        && tracewid == dwg->header_vars.TRACEWID)
      pass ();
    else
      fail ("HEADER.TRACEWID [BD] set+1 %g != %g",
            dwg->header_vars.TRACEWID, tracewid);
    tracewid--;
    dwg_dynapi_header_set_value (dwg, "TRACEWID", &tracewid, 0);

  }
  {
    BITCODE_BD sketchinc;
    if (dwg_dynapi_header_value (dwg, "SKETCHINC", &sketchinc, NULL)
        && sketchinc == dwg->header_vars.SKETCHINC)
      pass ();
    else
      fail ("HEADER.SKETCHINC [BD] %g != %g", dwg->header_vars.SKETCHINC, sketchinc);
    sketchinc++;
    if (dwg_dynapi_header_set_value (dwg, "SKETCHINC", &sketchinc, 0)
        && sketchinc == dwg->header_vars.SKETCHINC)
      pass ();
    else
      fail ("HEADER.SKETCHINC [BD] set+1 %g != %g",
            dwg->header_vars.SKETCHINC, sketchinc);
    sketchinc--;
    dwg_dynapi_header_set_value (dwg, "SKETCHINC", &sketchinc, 0);

  }
  {
    BITCODE_BD filletrad;
    if (dwg_dynapi_header_value (dwg, "FILLETRAD", &filletrad, NULL)
        && filletrad == dwg->header_vars.FILLETRAD)
      pass ();
    else
      fail ("HEADER.FILLETRAD [BD] %g != %g", dwg->header_vars.FILLETRAD, filletrad);
    filletrad++;
    if (dwg_dynapi_header_set_value (dwg, "FILLETRAD", &filletrad, 0)
        && filletrad == dwg->header_vars.FILLETRAD)
      pass ();
    else
      fail ("HEADER.FILLETRAD [BD] set+1 %g != %g",
            dwg->header_vars.FILLETRAD, filletrad);
    filletrad--;
    dwg_dynapi_header_set_value (dwg, "FILLETRAD", &filletrad, 0);

  }
  {
    BITCODE_BD thickness;
    if (dwg_dynapi_header_value (dwg, "THICKNESS", &thickness, NULL)
        && thickness == dwg->header_vars.THICKNESS)
      pass ();
    else
      fail ("HEADER.THICKNESS [BD] %g != %g", dwg->header_vars.THICKNESS, thickness);
    thickness++;
    if (dwg_dynapi_header_set_value (dwg, "THICKNESS", &thickness, 0)
        && thickness == dwg->header_vars.THICKNESS)
      pass ();
    else
      fail ("HEADER.THICKNESS [BD] set+1 %g != %g",
            dwg->header_vars.THICKNESS, thickness);
    thickness--;
    dwg_dynapi_header_set_value (dwg, "THICKNESS", &thickness, 0);

  }
  {
    BITCODE_BD angbase;
    if (dwg_dynapi_header_value (dwg, "ANGBASE", &angbase, NULL)
        && angbase == dwg->header_vars.ANGBASE)
      pass ();
    else
      fail ("HEADER.ANGBASE [BD] %g != %g", dwg->header_vars.ANGBASE, angbase);
    angbase++;
    if (dwg_dynapi_header_set_value (dwg, "ANGBASE", &angbase, 0)
        && angbase == dwg->header_vars.ANGBASE)
      pass ();
    else
      fail ("HEADER.ANGBASE [BD] set+1 %g != %g",
            dwg->header_vars.ANGBASE, angbase);
    angbase--;
    dwg_dynapi_header_set_value (dwg, "ANGBASE", &angbase, 0);

  }
  {
    BITCODE_BD pdsize;
    if (dwg_dynapi_header_value (dwg, "PDSIZE", &pdsize, NULL)
        && pdsize == dwg->header_vars.PDSIZE)
      pass ();
    else
      fail ("HEADER.PDSIZE [BD] %g != %g", dwg->header_vars.PDSIZE, pdsize);
    pdsize++;
    if (dwg_dynapi_header_set_value (dwg, "PDSIZE", &pdsize, 0)
        && pdsize == dwg->header_vars.PDSIZE)
      pass ();
    else
      fail ("HEADER.PDSIZE [BD] set+1 %g != %g",
            dwg->header_vars.PDSIZE, pdsize);
    pdsize--;
    dwg_dynapi_header_set_value (dwg, "PDSIZE", &pdsize, 0);

  }
  {
    BITCODE_BD plinewid;
    if (dwg_dynapi_header_value (dwg, "PLINEWID", &plinewid, NULL)
        && plinewid == dwg->header_vars.PLINEWID)
      pass ();
    else
      fail ("HEADER.PLINEWID [BD] %g != %g", dwg->header_vars.PLINEWID, plinewid);
    plinewid++;
    if (dwg_dynapi_header_set_value (dwg, "PLINEWID", &plinewid, 0)
        && plinewid == dwg->header_vars.PLINEWID)
      pass ();
    else
      fail ("HEADER.PLINEWID [BD] set+1 %g != %g",
            dwg->header_vars.PLINEWID, plinewid);
    plinewid--;
    dwg_dynapi_header_set_value (dwg, "PLINEWID", &plinewid, 0);

  }
  {
    BITCODE_BD userr1;
    if (dwg_dynapi_header_value (dwg, "USERR1", &userr1, NULL)
        && userr1 == dwg->header_vars.USERR1)
      pass ();
    else
      fail ("HEADER.USERR1 [BD] %g != %g", dwg->header_vars.USERR1, userr1);
    userr1++;
    if (dwg_dynapi_header_set_value (dwg, "USERR1", &userr1, 0)
        && userr1 == dwg->header_vars.USERR1)
      pass ();
    else
      fail ("HEADER.USERR1 [BD] set+1 %g != %g",
            dwg->header_vars.USERR1, userr1);
    userr1--;
    dwg_dynapi_header_set_value (dwg, "USERR1", &userr1, 0);

  }
  {
    BITCODE_BD userr2;
    if (dwg_dynapi_header_value (dwg, "USERR2", &userr2, NULL)
        && userr2 == dwg->header_vars.USERR2)
      pass ();
    else
      fail ("HEADER.USERR2 [BD] %g != %g", dwg->header_vars.USERR2, userr2);
    userr2++;
    if (dwg_dynapi_header_set_value (dwg, "USERR2", &userr2, 0)
        && userr2 == dwg->header_vars.USERR2)
      pass ();
    else
      fail ("HEADER.USERR2 [BD] set+1 %g != %g",
            dwg->header_vars.USERR2, userr2);
    userr2--;
    dwg_dynapi_header_set_value (dwg, "USERR2", &userr2, 0);

  }
  {
    BITCODE_BD userr3;
    if (dwg_dynapi_header_value (dwg, "USERR3", &userr3, NULL)
        && userr3 == dwg->header_vars.USERR3)
      pass ();
    else
      fail ("HEADER.USERR3 [BD] %g != %g", dwg->header_vars.USERR3, userr3);
    userr3++;
    if (dwg_dynapi_header_set_value (dwg, "USERR3", &userr3, 0)
        && userr3 == dwg->header_vars.USERR3)
      pass ();
    else
      fail ("HEADER.USERR3 [BD] set+1 %g != %g",
            dwg->header_vars.USERR3, userr3);
    userr3--;
    dwg_dynapi_header_set_value (dwg, "USERR3", &userr3, 0);

  }
  {
    BITCODE_BD userr4;
    if (dwg_dynapi_header_value (dwg, "USERR4", &userr4, NULL)
        && userr4 == dwg->header_vars.USERR4)
      pass ();
    else
      fail ("HEADER.USERR4 [BD] %g != %g", dwg->header_vars.USERR4, userr4);
    userr4++;
    if (dwg_dynapi_header_set_value (dwg, "USERR4", &userr4, 0)
        && userr4 == dwg->header_vars.USERR4)
      pass ();
    else
      fail ("HEADER.USERR4 [BD] set+1 %g != %g",
            dwg->header_vars.USERR4, userr4);
    userr4--;
    dwg_dynapi_header_set_value (dwg, "USERR4", &userr4, 0);

  }
  {
    BITCODE_BD userr5;
    if (dwg_dynapi_header_value (dwg, "USERR5", &userr5, NULL)
        && userr5 == dwg->header_vars.USERR5)
      pass ();
    else
      fail ("HEADER.USERR5 [BD] %g != %g", dwg->header_vars.USERR5, userr5);
    userr5++;
    if (dwg_dynapi_header_set_value (dwg, "USERR5", &userr5, 0)
        && userr5 == dwg->header_vars.USERR5)
      pass ();
    else
      fail ("HEADER.USERR5 [BD] set+1 %g != %g",
            dwg->header_vars.USERR5, userr5);
    userr5--;
    dwg_dynapi_header_set_value (dwg, "USERR5", &userr5, 0);

  }
  {
    BITCODE_BD chamfera;
    if (dwg_dynapi_header_value (dwg, "CHAMFERA", &chamfera, NULL)
        && chamfera == dwg->header_vars.CHAMFERA)
      pass ();
    else
      fail ("HEADER.CHAMFERA [BD] %g != %g", dwg->header_vars.CHAMFERA, chamfera);
    chamfera++;
    if (dwg_dynapi_header_set_value (dwg, "CHAMFERA", &chamfera, 0)
        && chamfera == dwg->header_vars.CHAMFERA)
      pass ();
    else
      fail ("HEADER.CHAMFERA [BD] set+1 %g != %g",
            dwg->header_vars.CHAMFERA, chamfera);
    chamfera--;
    dwg_dynapi_header_set_value (dwg, "CHAMFERA", &chamfera, 0);

  }
  {
    BITCODE_BD chamferb;
    if (dwg_dynapi_header_value (dwg, "CHAMFERB", &chamferb, NULL)
        && chamferb == dwg->header_vars.CHAMFERB)
      pass ();
    else
      fail ("HEADER.CHAMFERB [BD] %g != %g", dwg->header_vars.CHAMFERB, chamferb);
    chamferb++;
    if (dwg_dynapi_header_set_value (dwg, "CHAMFERB", &chamferb, 0)
        && chamferb == dwg->header_vars.CHAMFERB)
      pass ();
    else
      fail ("HEADER.CHAMFERB [BD] set+1 %g != %g",
            dwg->header_vars.CHAMFERB, chamferb);
    chamferb--;
    dwg_dynapi_header_set_value (dwg, "CHAMFERB", &chamferb, 0);

  }
  {
    BITCODE_BD chamferc;
    if (dwg_dynapi_header_value (dwg, "CHAMFERC", &chamferc, NULL)
        && chamferc == dwg->header_vars.CHAMFERC)
      pass ();
    else
      fail ("HEADER.CHAMFERC [BD] %g != %g", dwg->header_vars.CHAMFERC, chamferc);
    chamferc++;
    if (dwg_dynapi_header_set_value (dwg, "CHAMFERC", &chamferc, 0)
        && chamferc == dwg->header_vars.CHAMFERC)
      pass ();
    else
      fail ("HEADER.CHAMFERC [BD] set+1 %g != %g",
            dwg->header_vars.CHAMFERC, chamferc);
    chamferc--;
    dwg_dynapi_header_set_value (dwg, "CHAMFERC", &chamferc, 0);

  }
  {
    BITCODE_BD chamferd;
    if (dwg_dynapi_header_value (dwg, "CHAMFERD", &chamferd, NULL)
        && chamferd == dwg->header_vars.CHAMFERD)
      pass ();
    else
      fail ("HEADER.CHAMFERD [BD] %g != %g", dwg->header_vars.CHAMFERD, chamferd);
    chamferd++;
    if (dwg_dynapi_header_set_value (dwg, "CHAMFERD", &chamferd, 0)
        && chamferd == dwg->header_vars.CHAMFERD)
      pass ();
    else
      fail ("HEADER.CHAMFERD [BD] set+1 %g != %g",
            dwg->header_vars.CHAMFERD, chamferd);
    chamferd--;
    dwg_dynapi_header_set_value (dwg, "CHAMFERD", &chamferd, 0);

  }
  {
    BITCODE_BD facetres;
    if (dwg_dynapi_header_value (dwg, "FACETRES", &facetres, NULL)
        && facetres == dwg->header_vars.FACETRES)
      pass ();
    else
      fail ("HEADER.FACETRES [BD] %g != %g", dwg->header_vars.FACETRES, facetres);
    facetres++;
    if (dwg_dynapi_header_set_value (dwg, "FACETRES", &facetres, 0)
        && facetres == dwg->header_vars.FACETRES)
      pass ();
    else
      fail ("HEADER.FACETRES [BD] set+1 %g != %g",
            dwg->header_vars.FACETRES, facetres);
    facetres--;
    dwg_dynapi_header_set_value (dwg, "FACETRES", &facetres, 0);

  }
  {
    BITCODE_BD cmlscale;
    if (dwg_dynapi_header_value (dwg, "CMLSCALE", &cmlscale, NULL)
        && cmlscale == dwg->header_vars.CMLSCALE)
      pass ();
    else
      fail ("HEADER.CMLSCALE [BD] %g != %g", dwg->header_vars.CMLSCALE, cmlscale);
    cmlscale++;
    if (dwg_dynapi_header_set_value (dwg, "CMLSCALE", &cmlscale, 0)
        && cmlscale == dwg->header_vars.CMLSCALE)
      pass ();
    else
      fail ("HEADER.CMLSCALE [BD] set+1 %g != %g",
            dwg->header_vars.CMLSCALE, cmlscale);
    cmlscale--;
    dwg_dynapi_header_set_value (dwg, "CMLSCALE", &cmlscale, 0);

  }
  {
    BITCODE_BD celtscale;
    if (dwg_dynapi_header_value (dwg, "CELTSCALE", &celtscale, NULL)
        && celtscale == dwg->header_vars.CELTSCALE)
      pass ();
    else
      fail ("HEADER.CELTSCALE [BD] %g != %g", dwg->header_vars.CELTSCALE, celtscale);
    celtscale++;
    if (dwg_dynapi_header_set_value (dwg, "CELTSCALE", &celtscale, 0)
        && celtscale == dwg->header_vars.CELTSCALE)
      pass ();
    else
      fail ("HEADER.CELTSCALE [BD] set+1 %g != %g",
            dwg->header_vars.CELTSCALE, celtscale);
    celtscale--;
    dwg_dynapi_header_set_value (dwg, "CELTSCALE", &celtscale, 0);

  }
  {
    BITCODE_TV menu;
    if (dwg_dynapi_header_value (dwg, "MENU", &menu, NULL)
        && !memcmp (&menu, &dwg->header_vars.MENU, sizeof (dwg->header_vars.MENU))
       )
      pass ();
    else
      fail ("HEADER.MENU [TV]");
  }
  {
    BITCODE_TIMEBLL tdcreate;
    if (dwg_dynapi_header_value (dwg, "TDCREATE", &tdcreate, NULL)
        && !memcmp (&tdcreate, &dwg->header_vars.TDCREATE, sizeof (dwg->header_vars.TDCREATE))
       )
      pass ();
    else
      fail ("HEADER.TDCREATE [TIMEBLL]");
  }
  {
    BITCODE_TIMEBLL tdupdate;
    if (dwg_dynapi_header_value (dwg, "TDUPDATE", &tdupdate, NULL)
        && !memcmp (&tdupdate, &dwg->header_vars.TDUPDATE, sizeof (dwg->header_vars.TDUPDATE))
       )
      pass ();
    else
      fail ("HEADER.TDUPDATE [TIMEBLL]");
  }
  {
    BITCODE_TIMEBLL tducreate;
    if (dwg_dynapi_header_value (dwg, "TDUCREATE", &tducreate, NULL)
        && !memcmp (&tducreate, &dwg->header_vars.TDUCREATE, sizeof (dwg->header_vars.TDUCREATE))
       )
      pass ();
    else
      fail ("HEADER.TDUCREATE [TIMEBLL]");
  }
  {
    BITCODE_TIMEBLL tduupdate;
    if (dwg_dynapi_header_value (dwg, "TDUUPDATE", &tduupdate, NULL)
        && !memcmp (&tduupdate, &dwg->header_vars.TDUUPDATE, sizeof (dwg->header_vars.TDUUPDATE))
       )
      pass ();
    else
      fail ("HEADER.TDUUPDATE [TIMEBLL]");
  }
  {
    BITCODE_BL unknown_15;
    if (dwg_dynapi_header_value (dwg, "unknown_15", &unknown_15, NULL)
        && unknown_15 == dwg->header_vars.unknown_15)
      pass ();
    else
      fail ("HEADER.unknown_15 [BL] %u != %u", dwg->header_vars.unknown_15, unknown_15);
    unknown_15++;
    if (dwg_dynapi_header_set_value (dwg, "unknown_15", &unknown_15, 0)
        && unknown_15 == dwg->header_vars.unknown_15)
      pass ();
    else
      fail ("HEADER.unknown_15 [BL] set+1 %u != %u",
            dwg->header_vars.unknown_15, unknown_15);
    unknown_15--;
    dwg_dynapi_header_set_value (dwg, "unknown_15", &unknown_15, 0);

  }
  {
    BITCODE_BL unknown_16;
    if (dwg_dynapi_header_value (dwg, "unknown_16", &unknown_16, NULL)
        && unknown_16 == dwg->header_vars.unknown_16)
      pass ();
    else
      fail ("HEADER.unknown_16 [BL] %u != %u", dwg->header_vars.unknown_16, unknown_16);
    unknown_16++;
    if (dwg_dynapi_header_set_value (dwg, "unknown_16", &unknown_16, 0)
        && unknown_16 == dwg->header_vars.unknown_16)
      pass ();
    else
      fail ("HEADER.unknown_16 [BL] set+1 %u != %u",
            dwg->header_vars.unknown_16, unknown_16);
    unknown_16--;
    dwg_dynapi_header_set_value (dwg, "unknown_16", &unknown_16, 0);

  }
  {
    BITCODE_BL unknown_17;
    if (dwg_dynapi_header_value (dwg, "unknown_17", &unknown_17, NULL)
        && unknown_17 == dwg->header_vars.unknown_17)
      pass ();
    else
      fail ("HEADER.unknown_17 [BL] %u != %u", dwg->header_vars.unknown_17, unknown_17);
    unknown_17++;
    if (dwg_dynapi_header_set_value (dwg, "unknown_17", &unknown_17, 0)
        && unknown_17 == dwg->header_vars.unknown_17)
      pass ();
    else
      fail ("HEADER.unknown_17 [BL] set+1 %u != %u",
            dwg->header_vars.unknown_17, unknown_17);
    unknown_17--;
    dwg_dynapi_header_set_value (dwg, "unknown_17", &unknown_17, 0);

  }
  {
    BITCODE_TIMEBLL tdindwg;
    if (dwg_dynapi_header_value (dwg, "TDINDWG", &tdindwg, NULL)
        && !memcmp (&tdindwg, &dwg->header_vars.TDINDWG, sizeof (dwg->header_vars.TDINDWG))
       )
      pass ();
    else
      fail ("HEADER.TDINDWG [TIMEBLL]");
  }
  {
    BITCODE_TIMEBLL tdusrtimer;
    if (dwg_dynapi_header_value (dwg, "TDUSRTIMER", &tdusrtimer, NULL)
        && !memcmp (&tdusrtimer, &dwg->header_vars.TDUSRTIMER, sizeof (dwg->header_vars.TDUSRTIMER))
       )
      pass ();
    else
      fail ("HEADER.TDUSRTIMER [TIMEBLL]");
  }
  {
    BITCODE_CMC cecolor;
    if (dwg_dynapi_header_value (dwg, "CECOLOR", &cecolor, NULL)
        && !memcmp (&cecolor, &dwg->header_vars.CECOLOR, sizeof (dwg->header_vars.CECOLOR))
       )
      pass ();
    else
      fail ("HEADER.CECOLOR [CMC]");
  }
  {
    BITCODE_BS handling;
    if (dwg_dynapi_header_value (dwg, "HANDLING", &handling, NULL)
        && handling == dwg->header_vars.HANDLING)
      pass ();
    else
      fail ("HEADER.HANDLING [BS] %hu != %hu", dwg->header_vars.HANDLING, handling);
    handling++;
    if (dwg_dynapi_header_set_value (dwg, "HANDLING", &handling, 0)
        && handling == dwg->header_vars.HANDLING)
      pass ();
    else
      fail ("HEADER.HANDLING [BS] set+1 %hu != %hu",
            dwg->header_vars.HANDLING, handling);
    handling--;
    dwg_dynapi_header_set_value (dwg, "HANDLING", &handling, 0);

  }
  {
    BITCODE_H handseed;
    if (dwg_dynapi_header_value (dwg, "HANDSEED", &handseed, NULL)
        && !memcmp (&handseed, &dwg->header_vars.HANDSEED, sizeof (dwg->header_vars.HANDSEED))
       )
      pass ();
    else
      fail ("HEADER.HANDSEED [H]");
  }
  {
    BITCODE_H clayer;
    if (dwg_dynapi_header_value (dwg, "CLAYER", &clayer, NULL)
        && !memcmp (&clayer, &dwg->header_vars.CLAYER, sizeof (dwg->header_vars.CLAYER))
       )
      pass ();
    else
      fail ("HEADER.CLAYER [H]");
  }
  {
    BITCODE_H textstyle;
    if (dwg_dynapi_header_value (dwg, "TEXTSTYLE", &textstyle, NULL)
        && !memcmp (&textstyle, &dwg->header_vars.TEXTSTYLE, sizeof (dwg->header_vars.TEXTSTYLE))
       )
      pass ();
    else
      fail ("HEADER.TEXTSTYLE [H]");
  }
  {
    BITCODE_H celtype;
    if (dwg_dynapi_header_value (dwg, "CELTYPE", &celtype, NULL)
        && !memcmp (&celtype, &dwg->header_vars.CELTYPE, sizeof (dwg->header_vars.CELTYPE))
       )
      pass ();
    else
      fail ("HEADER.CELTYPE [H]");
  }
  {
    BITCODE_H cmaterial;
    if (dwg_dynapi_header_value (dwg, "CMATERIAL", &cmaterial, NULL)
        && !memcmp (&cmaterial, &dwg->header_vars.CMATERIAL, sizeof (dwg->header_vars.CMATERIAL))
       )
      pass ();
    else
      fail ("HEADER.CMATERIAL [H]");
  }
  {
    BITCODE_H dimstyle;
    if (dwg_dynapi_header_value (dwg, "DIMSTYLE", &dimstyle, NULL)
        && !memcmp (&dimstyle, &dwg->header_vars.DIMSTYLE, sizeof (dwg->header_vars.DIMSTYLE))
       )
      pass ();
    else
      fail ("HEADER.DIMSTYLE [H]");
  }
  {
    BITCODE_H cmlstyle;
    if (dwg_dynapi_header_value (dwg, "CMLSTYLE", &cmlstyle, NULL)
        && !memcmp (&cmlstyle, &dwg->header_vars.CMLSTYLE, sizeof (dwg->header_vars.CMLSTYLE))
       )
      pass ();
    else
      fail ("HEADER.CMLSTYLE [H]");
  }
  {
    BITCODE_BD psvpscale;
    if (dwg_dynapi_header_value (dwg, "PSVPSCALE", &psvpscale, NULL)
        && psvpscale == dwg->header_vars.PSVPSCALE)
      pass ();
    else
      fail ("HEADER.PSVPSCALE [BD] %g != %g", dwg->header_vars.PSVPSCALE, psvpscale);
    psvpscale++;
    if (dwg_dynapi_header_set_value (dwg, "PSVPSCALE", &psvpscale, 0)
        && psvpscale == dwg->header_vars.PSVPSCALE)
      pass ();
    else
      fail ("HEADER.PSVPSCALE [BD] set+1 %g != %g",
            dwg->header_vars.PSVPSCALE, psvpscale);
    psvpscale--;
    dwg_dynapi_header_set_value (dwg, "PSVPSCALE", &psvpscale, 0);

  }
  {
    BITCODE_3BD pinsbase;
    if (dwg_dynapi_header_value (dwg, "PINSBASE", &pinsbase, NULL)
        && !memcmp (&pinsbase, &dwg->header_vars.PINSBASE, sizeof (dwg->header_vars.PINSBASE))
       )
      pass ();
    else
      fail ("HEADER.PINSBASE [3BD]");
  }
  {
    BITCODE_3BD pextmin;
    if (dwg_dynapi_header_value (dwg, "PEXTMIN", &pextmin, NULL)
        && !memcmp (&pextmin, &dwg->header_vars.PEXTMIN, sizeof (dwg->header_vars.PEXTMIN))
       )
      pass ();
    else
      fail ("HEADER.PEXTMIN [3BD]");
  }
  {
    BITCODE_3BD pextmax;
    if (dwg_dynapi_header_value (dwg, "PEXTMAX", &pextmax, NULL)
        && !memcmp (&pextmax, &dwg->header_vars.PEXTMAX, sizeof (dwg->header_vars.PEXTMAX))
       )
      pass ();
    else
      fail ("HEADER.PEXTMAX [3BD]");
  }
  {
    BITCODE_2RD plimmin;
    if (dwg_dynapi_header_value (dwg, "PLIMMIN", &plimmin, NULL)
        && !memcmp (&plimmin, &dwg->header_vars.PLIMMIN, sizeof (dwg->header_vars.PLIMMIN))
       )
      pass ();
    else
      fail ("HEADER.PLIMMIN [2RD]");
  }
  {
    BITCODE_2RD plimmax;
    if (dwg_dynapi_header_value (dwg, "PLIMMAX", &plimmax, NULL)
        && !memcmp (&plimmax, &dwg->header_vars.PLIMMAX, sizeof (dwg->header_vars.PLIMMAX))
       )
      pass ();
    else
      fail ("HEADER.PLIMMAX [2RD]");
  }
  {
    BITCODE_BD pelevation;
    if (dwg_dynapi_header_value (dwg, "PELEVATION", &pelevation, NULL)
        && pelevation == dwg->header_vars.PELEVATION)
      pass ();
    else
      fail ("HEADER.PELEVATION [BD] %g != %g", dwg->header_vars.PELEVATION, pelevation);
    pelevation++;
    if (dwg_dynapi_header_set_value (dwg, "PELEVATION", &pelevation, 0)
        && pelevation == dwg->header_vars.PELEVATION)
      pass ();
    else
      fail ("HEADER.PELEVATION [BD] set+1 %g != %g",
            dwg->header_vars.PELEVATION, pelevation);
    pelevation--;
    dwg_dynapi_header_set_value (dwg, "PELEVATION", &pelevation, 0);

  }
  {
    BITCODE_3BD pucsorg;
    if (dwg_dynapi_header_value (dwg, "PUCSORG", &pucsorg, NULL)
        && !memcmp (&pucsorg, &dwg->header_vars.PUCSORG, sizeof (dwg->header_vars.PUCSORG))
       )
      pass ();
    else
      fail ("HEADER.PUCSORG [3BD]");
  }
  {
    BITCODE_3BD pucsxdir;
    if (dwg_dynapi_header_value (dwg, "PUCSXDIR", &pucsxdir, NULL)
        && !memcmp (&pucsxdir, &dwg->header_vars.PUCSXDIR, sizeof (dwg->header_vars.PUCSXDIR))
       )
      pass ();
    else
      fail ("HEADER.PUCSXDIR [3BD]");
  }
  {
    BITCODE_3BD pucsydir;
    if (dwg_dynapi_header_value (dwg, "PUCSYDIR", &pucsydir, NULL)
        && !memcmp (&pucsydir, &dwg->header_vars.PUCSYDIR, sizeof (dwg->header_vars.PUCSYDIR))
       )
      pass ();
    else
      fail ("HEADER.PUCSYDIR [3BD]");
  }
  {
    BITCODE_H pucsname;
    if (dwg_dynapi_header_value (dwg, "PUCSNAME", &pucsname, NULL)
        && !memcmp (&pucsname, &dwg->header_vars.PUCSNAME, sizeof (dwg->header_vars.PUCSNAME))
       )
      pass ();
    else
      fail ("HEADER.PUCSNAME [H]");
  }
  {
    BITCODE_H pucsbase;
    if (dwg_dynapi_header_value (dwg, "PUCSBASE", &pucsbase, NULL)
        && !memcmp (&pucsbase, &dwg->header_vars.PUCSBASE, sizeof (dwg->header_vars.PUCSBASE))
       )
      pass ();
    else
      fail ("HEADER.PUCSBASE [H]");
  }
  {
    BITCODE_H pucsorthoref;
    if (dwg_dynapi_header_value (dwg, "PUCSORTHOREF", &pucsorthoref, NULL)
        && !memcmp (&pucsorthoref, &dwg->header_vars.PUCSORTHOREF, sizeof (dwg->header_vars.PUCSORTHOREF))
       )
      pass ();
    else
      fail ("HEADER.PUCSORTHOREF [H]");
  }
  {
    BITCODE_BS pucsorthoview;
    if (dwg_dynapi_header_value (dwg, "PUCSORTHOVIEW", &pucsorthoview, NULL)
        && pucsorthoview == dwg->header_vars.PUCSORTHOVIEW)
      pass ();
    else
      fail ("HEADER.PUCSORTHOVIEW [BS] %hu != %hu", dwg->header_vars.PUCSORTHOVIEW, pucsorthoview);
    pucsorthoview++;
    if (dwg_dynapi_header_set_value (dwg, "PUCSORTHOVIEW", &pucsorthoview, 0)
        && pucsorthoview == dwg->header_vars.PUCSORTHOVIEW)
      pass ();
    else
      fail ("HEADER.PUCSORTHOVIEW [BS] set+1 %hu != %hu",
            dwg->header_vars.PUCSORTHOVIEW, pucsorthoview);
    pucsorthoview--;
    dwg_dynapi_header_set_value (dwg, "PUCSORTHOVIEW", &pucsorthoview, 0);

  }
  {
    BITCODE_3BD pucsorgtop;
    if (dwg_dynapi_header_value (dwg, "PUCSORGTOP", &pucsorgtop, NULL)
        && !memcmp (&pucsorgtop, &dwg->header_vars.PUCSORGTOP, sizeof (dwg->header_vars.PUCSORGTOP))
       )
      pass ();
    else
      fail ("HEADER.PUCSORGTOP [3BD]");
  }
  {
    BITCODE_3BD pucsorgbottom;
    if (dwg_dynapi_header_value (dwg, "PUCSORGBOTTOM", &pucsorgbottom, NULL)
        && !memcmp (&pucsorgbottom, &dwg->header_vars.PUCSORGBOTTOM, sizeof (dwg->header_vars.PUCSORGBOTTOM))
       )
      pass ();
    else
      fail ("HEADER.PUCSORGBOTTOM [3BD]");
  }
  {
    BITCODE_3BD pucsorgleft;
    if (dwg_dynapi_header_value (dwg, "PUCSORGLEFT", &pucsorgleft, NULL)
        && !memcmp (&pucsorgleft, &dwg->header_vars.PUCSORGLEFT, sizeof (dwg->header_vars.PUCSORGLEFT))
       )
      pass ();
    else
      fail ("HEADER.PUCSORGLEFT [3BD]");
  }
  {
    BITCODE_3BD pucsorgright;
    if (dwg_dynapi_header_value (dwg, "PUCSORGRIGHT", &pucsorgright, NULL)
        && !memcmp (&pucsorgright, &dwg->header_vars.PUCSORGRIGHT, sizeof (dwg->header_vars.PUCSORGRIGHT))
       )
      pass ();
    else
      fail ("HEADER.PUCSORGRIGHT [3BD]");
  }
  {
    BITCODE_3BD pucsorgfront;
    if (dwg_dynapi_header_value (dwg, "PUCSORGFRONT", &pucsorgfront, NULL)
        && !memcmp (&pucsorgfront, &dwg->header_vars.PUCSORGFRONT, sizeof (dwg->header_vars.PUCSORGFRONT))
       )
      pass ();
    else
      fail ("HEADER.PUCSORGFRONT [3BD]");
  }
  {
    BITCODE_3BD pucsorgback;
    if (dwg_dynapi_header_value (dwg, "PUCSORGBACK", &pucsorgback, NULL)
        && !memcmp (&pucsorgback, &dwg->header_vars.PUCSORGBACK, sizeof (dwg->header_vars.PUCSORGBACK))
       )
      pass ();
    else
      fail ("HEADER.PUCSORGBACK [3BD]");
  }
  {
    BITCODE_3BD insbase;
    if (dwg_dynapi_header_value (dwg, "INSBASE", &insbase, NULL)
        && !memcmp (&insbase, &dwg->header_vars.INSBASE, sizeof (dwg->header_vars.INSBASE))
       )
      pass ();
    else
      fail ("HEADER.INSBASE [3BD]");
  }
  {
    BITCODE_3BD extmin;
    if (dwg_dynapi_header_value (dwg, "EXTMIN", &extmin, NULL)
        && !memcmp (&extmin, &dwg->header_vars.EXTMIN, sizeof (dwg->header_vars.EXTMIN))
       )
      pass ();
    else
      fail ("HEADER.EXTMIN [3BD]");
  }
  {
    BITCODE_3BD extmax;
    if (dwg_dynapi_header_value (dwg, "EXTMAX", &extmax, NULL)
        && !memcmp (&extmax, &dwg->header_vars.EXTMAX, sizeof (dwg->header_vars.EXTMAX))
       )
      pass ();
    else
      fail ("HEADER.EXTMAX [3BD]");
  }
  {
    BITCODE_2RD limmin;
    if (dwg_dynapi_header_value (dwg, "LIMMIN", &limmin, NULL)
        && !memcmp (&limmin, &dwg->header_vars.LIMMIN, sizeof (dwg->header_vars.LIMMIN))
       )
      pass ();
    else
      fail ("HEADER.LIMMIN [2RD]");
  }
  {
    BITCODE_2RD limmax;
    if (dwg_dynapi_header_value (dwg, "LIMMAX", &limmax, NULL)
        && !memcmp (&limmax, &dwg->header_vars.LIMMAX, sizeof (dwg->header_vars.LIMMAX))
       )
      pass ();
    else
      fail ("HEADER.LIMMAX [2RD]");
  }
  {
    BITCODE_2RD viewctr;
    if (dwg_dynapi_header_value (dwg, "VIEWCTR", &viewctr, NULL)
        && !memcmp (&viewctr, &dwg->header_vars.VIEWCTR, sizeof (dwg->header_vars.VIEWCTR))
       )
      pass ();
    else
      fail ("HEADER.VIEWCTR [2RD]");
  }
  {
    BITCODE_BD elevation;
    if (dwg_dynapi_header_value (dwg, "ELEVATION", &elevation, NULL)
        && elevation == dwg->header_vars.ELEVATION)
      pass ();
    else
      fail ("HEADER.ELEVATION [BD] %g != %g", dwg->header_vars.ELEVATION, elevation);
    elevation++;
    if (dwg_dynapi_header_set_value (dwg, "ELEVATION", &elevation, 0)
        && elevation == dwg->header_vars.ELEVATION)
      pass ();
    else
      fail ("HEADER.ELEVATION [BD] set+1 %g != %g",
            dwg->header_vars.ELEVATION, elevation);
    elevation--;
    dwg_dynapi_header_set_value (dwg, "ELEVATION", &elevation, 0);

  }
  {
    BITCODE_RD viewsize;
    if (dwg_dynapi_header_value (dwg, "VIEWSIZE", &viewsize, NULL)
        && viewsize == dwg->header_vars.VIEWSIZE)
      pass ();
    else
      fail ("HEADER.VIEWSIZE [RD] %g != %g", dwg->header_vars.VIEWSIZE, viewsize);
    viewsize++;
    if (dwg_dynapi_header_set_value (dwg, "VIEWSIZE", &viewsize, 0)
        && viewsize == dwg->header_vars.VIEWSIZE)
      pass ();
    else
      fail ("HEADER.VIEWSIZE [RD] set+1 %g != %g",
            dwg->header_vars.VIEWSIZE, viewsize);
    viewsize--;
    dwg_dynapi_header_set_value (dwg, "VIEWSIZE", &viewsize, 0);

  }
  {
    BITCODE_RS snapmode;
    if (dwg_dynapi_header_value (dwg, "SNAPMODE", &snapmode, NULL)
        && snapmode == dwg->header_vars.SNAPMODE)
      pass ();
    else
      fail ("HEADER.SNAPMODE [RS] %hu != %hu", dwg->header_vars.SNAPMODE, snapmode);
    snapmode++;
    if (dwg_dynapi_header_set_value (dwg, "SNAPMODE", &snapmode, 0)
        && snapmode == dwg->header_vars.SNAPMODE)
      pass ();
    else
      fail ("HEADER.SNAPMODE [RS] set+1 %hu != %hu",
            dwg->header_vars.SNAPMODE, snapmode);
    snapmode--;
    dwg_dynapi_header_set_value (dwg, "SNAPMODE", &snapmode, 0);

  }
  {
    BITCODE_2RD snapunit;
    if (dwg_dynapi_header_value (dwg, "SNAPUNIT", &snapunit, NULL)
        && !memcmp (&snapunit, &dwg->header_vars.SNAPUNIT, sizeof (dwg->header_vars.SNAPUNIT))
       )
      pass ();
    else
      fail ("HEADER.SNAPUNIT [2RD]");
  }
  {
    BITCODE_2RD snapbase;
    if (dwg_dynapi_header_value (dwg, "SNAPBASE", &snapbase, NULL)
        && !memcmp (&snapbase, &dwg->header_vars.SNAPBASE, sizeof (dwg->header_vars.SNAPBASE))
       )
      pass ();
    else
      fail ("HEADER.SNAPBASE [2RD]");
  }
  {
    BITCODE_RD snapang;
    if (dwg_dynapi_header_value (dwg, "SNAPANG", &snapang, NULL)
        && snapang == dwg->header_vars.SNAPANG)
      pass ();
    else
      fail ("HEADER.SNAPANG [RD] %g != %g", dwg->header_vars.SNAPANG, snapang);
    snapang++;
    if (dwg_dynapi_header_set_value (dwg, "SNAPANG", &snapang, 0)
        && snapang == dwg->header_vars.SNAPANG)
      pass ();
    else
      fail ("HEADER.SNAPANG [RD] set+1 %g != %g",
            dwg->header_vars.SNAPANG, snapang);
    snapang--;
    dwg_dynapi_header_set_value (dwg, "SNAPANG", &snapang, 0);

  }
  {
    BITCODE_RS snapstyl;
    if (dwg_dynapi_header_value (dwg, "SNAPSTYL", &snapstyl, NULL)
        && snapstyl == dwg->header_vars.SNAPSTYL)
      pass ();
    else
      fail ("HEADER.SNAPSTYL [RS] %hu != %hu", dwg->header_vars.SNAPSTYL, snapstyl);
    snapstyl++;
    if (dwg_dynapi_header_set_value (dwg, "SNAPSTYL", &snapstyl, 0)
        && snapstyl == dwg->header_vars.SNAPSTYL)
      pass ();
    else
      fail ("HEADER.SNAPSTYL [RS] set+1 %hu != %hu",
            dwg->header_vars.SNAPSTYL, snapstyl);
    snapstyl--;
    dwg_dynapi_header_set_value (dwg, "SNAPSTYL", &snapstyl, 0);

  }
  {
    BITCODE_RS snapisopair;
    if (dwg_dynapi_header_value (dwg, "SNAPISOPAIR", &snapisopair, NULL)
        && snapisopair == dwg->header_vars.SNAPISOPAIR)
      pass ();
    else
      fail ("HEADER.SNAPISOPAIR [RS] %hu != %hu", dwg->header_vars.SNAPISOPAIR, snapisopair);
    snapisopair++;
    if (dwg_dynapi_header_set_value (dwg, "SNAPISOPAIR", &snapisopair, 0)
        && snapisopair == dwg->header_vars.SNAPISOPAIR)
      pass ();
    else
      fail ("HEADER.SNAPISOPAIR [RS] set+1 %hu != %hu",
            dwg->header_vars.SNAPISOPAIR, snapisopair);
    snapisopair--;
    dwg_dynapi_header_set_value (dwg, "SNAPISOPAIR", &snapisopair, 0);

  }
  {
    BITCODE_RS gridmode;
    if (dwg_dynapi_header_value (dwg, "GRIDMODE", &gridmode, NULL)
        && gridmode == dwg->header_vars.GRIDMODE)
      pass ();
    else
      fail ("HEADER.GRIDMODE [RS] %hu != %hu", dwg->header_vars.GRIDMODE, gridmode);
    gridmode++;
    if (dwg_dynapi_header_set_value (dwg, "GRIDMODE", &gridmode, 0)
        && gridmode == dwg->header_vars.GRIDMODE)
      pass ();
    else
      fail ("HEADER.GRIDMODE [RS] set+1 %hu != %hu",
            dwg->header_vars.GRIDMODE, gridmode);
    gridmode--;
    dwg_dynapi_header_set_value (dwg, "GRIDMODE", &gridmode, 0);

  }
  {
    BITCODE_2RD gridunit;
    if (dwg_dynapi_header_value (dwg, "GRIDUNIT", &gridunit, NULL)
        && !memcmp (&gridunit, &dwg->header_vars.GRIDUNIT, sizeof (dwg->header_vars.GRIDUNIT))
       )
      pass ();
    else
      fail ("HEADER.GRIDUNIT [2RD]");
  }
  {
    BITCODE_3BD ucsorg;
    if (dwg_dynapi_header_value (dwg, "UCSORG", &ucsorg, NULL)
        && !memcmp (&ucsorg, &dwg->header_vars.UCSORG, sizeof (dwg->header_vars.UCSORG))
       )
      pass ();
    else
      fail ("HEADER.UCSORG [3BD]");
  }
  {
    BITCODE_3BD ucsxdir;
    if (dwg_dynapi_header_value (dwg, "UCSXDIR", &ucsxdir, NULL)
        && !memcmp (&ucsxdir, &dwg->header_vars.UCSXDIR, sizeof (dwg->header_vars.UCSXDIR))
       )
      pass ();
    else
      fail ("HEADER.UCSXDIR [3BD]");
  }
  {
    BITCODE_3BD ucsydir;
    if (dwg_dynapi_header_value (dwg, "UCSYDIR", &ucsydir, NULL)
        && !memcmp (&ucsydir, &dwg->header_vars.UCSYDIR, sizeof (dwg->header_vars.UCSYDIR))
       )
      pass ();
    else
      fail ("HEADER.UCSYDIR [3BD]");
  }
  {
    BITCODE_H ucsname;
    if (dwg_dynapi_header_value (dwg, "UCSNAME", &ucsname, NULL)
        && !memcmp (&ucsname, &dwg->header_vars.UCSNAME, sizeof (dwg->header_vars.UCSNAME))
       )
      pass ();
    else
      fail ("HEADER.UCSNAME [H]");
  }
  {
    BITCODE_H ucsbase;
    if (dwg_dynapi_header_value (dwg, "UCSBASE", &ucsbase, NULL)
        && !memcmp (&ucsbase, &dwg->header_vars.UCSBASE, sizeof (dwg->header_vars.UCSBASE))
       )
      pass ();
    else
      fail ("HEADER.UCSBASE [H]");
  }
  {
    BITCODE_BS ucsorthoview;
    if (dwg_dynapi_header_value (dwg, "UCSORTHOVIEW", &ucsorthoview, NULL)
        && ucsorthoview == dwg->header_vars.UCSORTHOVIEW)
      pass ();
    else
      fail ("HEADER.UCSORTHOVIEW [BS] %hu != %hu", dwg->header_vars.UCSORTHOVIEW, ucsorthoview);
    ucsorthoview++;
    if (dwg_dynapi_header_set_value (dwg, "UCSORTHOVIEW", &ucsorthoview, 0)
        && ucsorthoview == dwg->header_vars.UCSORTHOVIEW)
      pass ();
    else
      fail ("HEADER.UCSORTHOVIEW [BS] set+1 %hu != %hu",
            dwg->header_vars.UCSORTHOVIEW, ucsorthoview);
    ucsorthoview--;
    dwg_dynapi_header_set_value (dwg, "UCSORTHOVIEW", &ucsorthoview, 0);

  }
  {
    BITCODE_H ucsorthoref;
    if (dwg_dynapi_header_value (dwg, "UCSORTHOREF", &ucsorthoref, NULL)
        && !memcmp (&ucsorthoref, &dwg->header_vars.UCSORTHOREF, sizeof (dwg->header_vars.UCSORTHOREF))
       )
      pass ();
    else
      fail ("HEADER.UCSORTHOREF [H]");
  }
  {
    BITCODE_3BD ucsorgtop;
    if (dwg_dynapi_header_value (dwg, "UCSORGTOP", &ucsorgtop, NULL)
        && !memcmp (&ucsorgtop, &dwg->header_vars.UCSORGTOP, sizeof (dwg->header_vars.UCSORGTOP))
       )
      pass ();
    else
      fail ("HEADER.UCSORGTOP [3BD]");
  }
  {
    BITCODE_3BD ucsorgbottom;
    if (dwg_dynapi_header_value (dwg, "UCSORGBOTTOM", &ucsorgbottom, NULL)
        && !memcmp (&ucsorgbottom, &dwg->header_vars.UCSORGBOTTOM, sizeof (dwg->header_vars.UCSORGBOTTOM))
       )
      pass ();
    else
      fail ("HEADER.UCSORGBOTTOM [3BD]");
  }
  {
    BITCODE_3BD ucsorgleft;
    if (dwg_dynapi_header_value (dwg, "UCSORGLEFT", &ucsorgleft, NULL)
        && !memcmp (&ucsorgleft, &dwg->header_vars.UCSORGLEFT, sizeof (dwg->header_vars.UCSORGLEFT))
       )
      pass ();
    else
      fail ("HEADER.UCSORGLEFT [3BD]");
  }
  {
    BITCODE_3BD ucsorgright;
    if (dwg_dynapi_header_value (dwg, "UCSORGRIGHT", &ucsorgright, NULL)
        && !memcmp (&ucsorgright, &dwg->header_vars.UCSORGRIGHT, sizeof (dwg->header_vars.UCSORGRIGHT))
       )
      pass ();
    else
      fail ("HEADER.UCSORGRIGHT [3BD]");
  }
  {
    BITCODE_3BD ucsorgfront;
    if (dwg_dynapi_header_value (dwg, "UCSORGFRONT", &ucsorgfront, NULL)
        && !memcmp (&ucsorgfront, &dwg->header_vars.UCSORGFRONT, sizeof (dwg->header_vars.UCSORGFRONT))
       )
      pass ();
    else
      fail ("HEADER.UCSORGFRONT [3BD]");
  }
  {
    BITCODE_3BD ucsorgback;
    if (dwg_dynapi_header_value (dwg, "UCSORGBACK", &ucsorgback, NULL)
        && !memcmp (&ucsorgback, &dwg->header_vars.UCSORGBACK, sizeof (dwg->header_vars.UCSORGBACK))
       )
      pass ();
    else
      fail ("HEADER.UCSORGBACK [3BD]");
  }
  {
    BITCODE_TV dimpost;
    if (dwg_dynapi_header_value (dwg, "DIMPOST", &dimpost, NULL)
        && !memcmp (&dimpost, &dwg->header_vars.DIMPOST, sizeof (dwg->header_vars.DIMPOST))
       )
      pass ();
    else
      fail ("HEADER.DIMPOST [TV]");
  }
  {
    BITCODE_TV dimapost;
    if (dwg_dynapi_header_value (dwg, "DIMAPOST", &dimapost, NULL)
        && !memcmp (&dimapost, &dwg->header_vars.DIMAPOST, sizeof (dwg->header_vars.DIMAPOST))
       )
      pass ();
    else
      fail ("HEADER.DIMAPOST [TV]");
  }
  {
    BITCODE_B dimtol;
    if (dwg_dynapi_header_value (dwg, "DIMTOL", &dimtol, NULL)
        && dimtol == dwg->header_vars.DIMTOL)
      pass ();
    else
      fail ("HEADER.DIMTOL [B] " FORMAT_B " != " FORMAT_B "", dwg->header_vars.DIMTOL, dimtol);
    dimtol++;
    if (dwg_dynapi_header_set_value (dwg, "DIMTOL", &dimtol, 0)
        && dimtol == dwg->header_vars.DIMTOL)
      pass ();
    else
      fail ("HEADER.DIMTOL [B] set+1 " FORMAT_B " != " FORMAT_B "",
            dwg->header_vars.DIMTOL, dimtol);
    dimtol--;
    dwg_dynapi_header_set_value (dwg, "DIMTOL", &dimtol, 0);

  }
  {
    BITCODE_B dimlim;
    if (dwg_dynapi_header_value (dwg, "DIMLIM", &dimlim, NULL)
        && dimlim == dwg->header_vars.DIMLIM)
      pass ();
    else
      fail ("HEADER.DIMLIM [B] " FORMAT_B " != " FORMAT_B "", dwg->header_vars.DIMLIM, dimlim);
    dimlim++;
    if (dwg_dynapi_header_set_value (dwg, "DIMLIM", &dimlim, 0)
        && dimlim == dwg->header_vars.DIMLIM)
      pass ();
    else
      fail ("HEADER.DIMLIM [B] set+1 " FORMAT_B " != " FORMAT_B "",
            dwg->header_vars.DIMLIM, dimlim);
    dimlim--;
    dwg_dynapi_header_set_value (dwg, "DIMLIM", &dimlim, 0);

  }
  {
    BITCODE_B dimtih;
    if (dwg_dynapi_header_value (dwg, "DIMTIH", &dimtih, NULL)
        && dimtih == dwg->header_vars.DIMTIH)
      pass ();
    else
      fail ("HEADER.DIMTIH [B] " FORMAT_B " != " FORMAT_B "", dwg->header_vars.DIMTIH, dimtih);
    dimtih++;
    if (dwg_dynapi_header_set_value (dwg, "DIMTIH", &dimtih, 0)
        && dimtih == dwg->header_vars.DIMTIH)
      pass ();
    else
      fail ("HEADER.DIMTIH [B] set+1 " FORMAT_B " != " FORMAT_B "",
            dwg->header_vars.DIMTIH, dimtih);
    dimtih--;
    dwg_dynapi_header_set_value (dwg, "DIMTIH", &dimtih, 0);

  }
  {
    BITCODE_B dimtoh;
    if (dwg_dynapi_header_value (dwg, "DIMTOH", &dimtoh, NULL)
        && dimtoh == dwg->header_vars.DIMTOH)
      pass ();
    else
      fail ("HEADER.DIMTOH [B] " FORMAT_B " != " FORMAT_B "", dwg->header_vars.DIMTOH, dimtoh);
    dimtoh++;
    if (dwg_dynapi_header_set_value (dwg, "DIMTOH", &dimtoh, 0)
        && dimtoh == dwg->header_vars.DIMTOH)
      pass ();
    else
      fail ("HEADER.DIMTOH [B] set+1 " FORMAT_B " != " FORMAT_B "",
            dwg->header_vars.DIMTOH, dimtoh);
    dimtoh--;
    dwg_dynapi_header_set_value (dwg, "DIMTOH", &dimtoh, 0);

  }
  {
    BITCODE_B dimse1;
    if (dwg_dynapi_header_value (dwg, "DIMSE1", &dimse1, NULL)
        && dimse1 == dwg->header_vars.DIMSE1)
      pass ();
    else
      fail ("HEADER.DIMSE1 [B] " FORMAT_B " != " FORMAT_B "", dwg->header_vars.DIMSE1, dimse1);
    dimse1++;
    if (dwg_dynapi_header_set_value (dwg, "DIMSE1", &dimse1, 0)
        && dimse1 == dwg->header_vars.DIMSE1)
      pass ();
    else
      fail ("HEADER.DIMSE1 [B] set+1 " FORMAT_B " != " FORMAT_B "",
            dwg->header_vars.DIMSE1, dimse1);
    dimse1--;
    dwg_dynapi_header_set_value (dwg, "DIMSE1", &dimse1, 0);

  }
  {
    BITCODE_B dimse2;
    if (dwg_dynapi_header_value (dwg, "DIMSE2", &dimse2, NULL)
        && dimse2 == dwg->header_vars.DIMSE2)
      pass ();
    else
      fail ("HEADER.DIMSE2 [B] " FORMAT_B " != " FORMAT_B "", dwg->header_vars.DIMSE2, dimse2);
    dimse2++;
    if (dwg_dynapi_header_set_value (dwg, "DIMSE2", &dimse2, 0)
        && dimse2 == dwg->header_vars.DIMSE2)
      pass ();
    else
      fail ("HEADER.DIMSE2 [B] set+1 " FORMAT_B " != " FORMAT_B "",
            dwg->header_vars.DIMSE2, dimse2);
    dimse2--;
    dwg_dynapi_header_set_value (dwg, "DIMSE2", &dimse2, 0);

  }
  {
    BITCODE_B dimalt;
    if (dwg_dynapi_header_value (dwg, "DIMALT", &dimalt, NULL)
        && dimalt == dwg->header_vars.DIMALT)
      pass ();
    else
      fail ("HEADER.DIMALT [B] " FORMAT_B " != " FORMAT_B "", dwg->header_vars.DIMALT, dimalt);
    dimalt++;
    if (dwg_dynapi_header_set_value (dwg, "DIMALT", &dimalt, 0)
        && dimalt == dwg->header_vars.DIMALT)
      pass ();
    else
      fail ("HEADER.DIMALT [B] set+1 " FORMAT_B " != " FORMAT_B "",
            dwg->header_vars.DIMALT, dimalt);
    dimalt--;
    dwg_dynapi_header_set_value (dwg, "DIMALT", &dimalt, 0);

  }
  {
    BITCODE_B dimtofl;
    if (dwg_dynapi_header_value (dwg, "DIMTOFL", &dimtofl, NULL)
        && dimtofl == dwg->header_vars.DIMTOFL)
      pass ();
    else
      fail ("HEADER.DIMTOFL [B] " FORMAT_B " != " FORMAT_B "", dwg->header_vars.DIMTOFL, dimtofl);
    dimtofl++;
    if (dwg_dynapi_header_set_value (dwg, "DIMTOFL", &dimtofl, 0)
        && dimtofl == dwg->header_vars.DIMTOFL)
      pass ();
    else
      fail ("HEADER.DIMTOFL [B] set+1 " FORMAT_B " != " FORMAT_B "",
            dwg->header_vars.DIMTOFL, dimtofl);
    dimtofl--;
    dwg_dynapi_header_set_value (dwg, "DIMTOFL", &dimtofl, 0);

  }
  {
    BITCODE_B dimsah;
    if (dwg_dynapi_header_value (dwg, "DIMSAH", &dimsah, NULL)
        && dimsah == dwg->header_vars.DIMSAH)
      pass ();
    else
      fail ("HEADER.DIMSAH [B] " FORMAT_B " != " FORMAT_B "", dwg->header_vars.DIMSAH, dimsah);
    dimsah++;
    if (dwg_dynapi_header_set_value (dwg, "DIMSAH", &dimsah, 0)
        && dimsah == dwg->header_vars.DIMSAH)
      pass ();
    else
      fail ("HEADER.DIMSAH [B] set+1 " FORMAT_B " != " FORMAT_B "",
            dwg->header_vars.DIMSAH, dimsah);
    dimsah--;
    dwg_dynapi_header_set_value (dwg, "DIMSAH", &dimsah, 0);

  }
  {
    BITCODE_B dimtix;
    if (dwg_dynapi_header_value (dwg, "DIMTIX", &dimtix, NULL)
        && dimtix == dwg->header_vars.DIMTIX)
      pass ();
    else
      fail ("HEADER.DIMTIX [B] " FORMAT_B " != " FORMAT_B "", dwg->header_vars.DIMTIX, dimtix);
    dimtix++;
    if (dwg_dynapi_header_set_value (dwg, "DIMTIX", &dimtix, 0)
        && dimtix == dwg->header_vars.DIMTIX)
      pass ();
    else
      fail ("HEADER.DIMTIX [B] set+1 " FORMAT_B " != " FORMAT_B "",
            dwg->header_vars.DIMTIX, dimtix);
    dimtix--;
    dwg_dynapi_header_set_value (dwg, "DIMTIX", &dimtix, 0);

  }
  {
    BITCODE_B dimsoxd;
    if (dwg_dynapi_header_value (dwg, "DIMSOXD", &dimsoxd, NULL)
        && dimsoxd == dwg->header_vars.DIMSOXD)
      pass ();
    else
      fail ("HEADER.DIMSOXD [B] " FORMAT_B " != " FORMAT_B "", dwg->header_vars.DIMSOXD, dimsoxd);
    dimsoxd++;
    if (dwg_dynapi_header_set_value (dwg, "DIMSOXD", &dimsoxd, 0)
        && dimsoxd == dwg->header_vars.DIMSOXD)
      pass ();
    else
      fail ("HEADER.DIMSOXD [B] set+1 " FORMAT_B " != " FORMAT_B "",
            dwg->header_vars.DIMSOXD, dimsoxd);
    dimsoxd--;
    dwg_dynapi_header_set_value (dwg, "DIMSOXD", &dimsoxd, 0);

  }
  {
    BITCODE_BS dimaltd;
    if (dwg_dynapi_header_value (dwg, "DIMALTD", &dimaltd, NULL)
        && dimaltd == dwg->header_vars.DIMALTD)
      pass ();
    else
      fail ("HEADER.DIMALTD [BS] %hu != %hu", dwg->header_vars.DIMALTD, dimaltd);
    dimaltd++;
    if (dwg_dynapi_header_set_value (dwg, "DIMALTD", &dimaltd, 0)
        && dimaltd == dwg->header_vars.DIMALTD)
      pass ();
    else
      fail ("HEADER.DIMALTD [BS] set+1 %hu != %hu",
            dwg->header_vars.DIMALTD, dimaltd);
    dimaltd--;
    dwg_dynapi_header_set_value (dwg, "DIMALTD", &dimaltd, 0);

  }
  {
    BITCODE_BS dimzin;
    if (dwg_dynapi_header_value (dwg, "DIMZIN", &dimzin, NULL)
        && dimzin == dwg->header_vars.DIMZIN)
      pass ();
    else
      fail ("HEADER.DIMZIN [BS] %hu != %hu", dwg->header_vars.DIMZIN, dimzin);
    dimzin++;
    if (dwg_dynapi_header_set_value (dwg, "DIMZIN", &dimzin, 0)
        && dimzin == dwg->header_vars.DIMZIN)
      pass ();
    else
      fail ("HEADER.DIMZIN [BS] set+1 %hu != %hu",
            dwg->header_vars.DIMZIN, dimzin);
    dimzin--;
    dwg_dynapi_header_set_value (dwg, "DIMZIN", &dimzin, 0);

  }
  {
    BITCODE_B dimsd1;
    if (dwg_dynapi_header_value (dwg, "DIMSD1", &dimsd1, NULL)
        && dimsd1 == dwg->header_vars.DIMSD1)
      pass ();
    else
      fail ("HEADER.DIMSD1 [B] " FORMAT_B " != " FORMAT_B "", dwg->header_vars.DIMSD1, dimsd1);
    dimsd1++;
    if (dwg_dynapi_header_set_value (dwg, "DIMSD1", &dimsd1, 0)
        && dimsd1 == dwg->header_vars.DIMSD1)
      pass ();
    else
      fail ("HEADER.DIMSD1 [B] set+1 " FORMAT_B " != " FORMAT_B "",
            dwg->header_vars.DIMSD1, dimsd1);
    dimsd1--;
    dwg_dynapi_header_set_value (dwg, "DIMSD1", &dimsd1, 0);

  }
  {
    BITCODE_B dimsd2;
    if (dwg_dynapi_header_value (dwg, "DIMSD2", &dimsd2, NULL)
        && dimsd2 == dwg->header_vars.DIMSD2)
      pass ();
    else
      fail ("HEADER.DIMSD2 [B] " FORMAT_B " != " FORMAT_B "", dwg->header_vars.DIMSD2, dimsd2);
    dimsd2++;
    if (dwg_dynapi_header_set_value (dwg, "DIMSD2", &dimsd2, 0)
        && dimsd2 == dwg->header_vars.DIMSD2)
      pass ();
    else
      fail ("HEADER.DIMSD2 [B] set+1 " FORMAT_B " != " FORMAT_B "",
            dwg->header_vars.DIMSD2, dimsd2);
    dimsd2--;
    dwg_dynapi_header_set_value (dwg, "DIMSD2", &dimsd2, 0);

  }
  {
    BITCODE_BS dimtolj;
    if (dwg_dynapi_header_value (dwg, "DIMTOLJ", &dimtolj, NULL)
        && dimtolj == dwg->header_vars.DIMTOLJ)
      pass ();
    else
      fail ("HEADER.DIMTOLJ [BS] %hu != %hu", dwg->header_vars.DIMTOLJ, dimtolj);
    dimtolj++;
    if (dwg_dynapi_header_set_value (dwg, "DIMTOLJ", &dimtolj, 0)
        && dimtolj == dwg->header_vars.DIMTOLJ)
      pass ();
    else
      fail ("HEADER.DIMTOLJ [BS] set+1 %hu != %hu",
            dwg->header_vars.DIMTOLJ, dimtolj);
    dimtolj--;
    dwg_dynapi_header_set_value (dwg, "DIMTOLJ", &dimtolj, 0);

  }
  {
    BITCODE_BS dimjust;
    if (dwg_dynapi_header_value (dwg, "DIMJUST", &dimjust, NULL)
        && dimjust == dwg->header_vars.DIMJUST)
      pass ();
    else
      fail ("HEADER.DIMJUST [BS] %hu != %hu", dwg->header_vars.DIMJUST, dimjust);
    dimjust++;
    if (dwg_dynapi_header_set_value (dwg, "DIMJUST", &dimjust, 0)
        && dimjust == dwg->header_vars.DIMJUST)
      pass ();
    else
      fail ("HEADER.DIMJUST [BS] set+1 %hu != %hu",
            dwg->header_vars.DIMJUST, dimjust);
    dimjust--;
    dwg_dynapi_header_set_value (dwg, "DIMJUST", &dimjust, 0);

  }
  {
    BITCODE_BS dimfit;
    if (dwg_dynapi_header_value (dwg, "DIMFIT", &dimfit, NULL)
        && dimfit == dwg->header_vars.DIMFIT)
      pass ();
    else
      fail ("HEADER.DIMFIT [BS] %hu != %hu", dwg->header_vars.DIMFIT, dimfit);
    dimfit++;
    if (dwg_dynapi_header_set_value (dwg, "DIMFIT", &dimfit, 0)
        && dimfit == dwg->header_vars.DIMFIT)
      pass ();
    else
      fail ("HEADER.DIMFIT [BS] set+1 %hu != %hu",
            dwg->header_vars.DIMFIT, dimfit);
    dimfit--;
    dwg_dynapi_header_set_value (dwg, "DIMFIT", &dimfit, 0);

  }
  {
    BITCODE_B dimupt;
    if (dwg_dynapi_header_value (dwg, "DIMUPT", &dimupt, NULL)
        && dimupt == dwg->header_vars.DIMUPT)
      pass ();
    else
      fail ("HEADER.DIMUPT [B] " FORMAT_B " != " FORMAT_B "", dwg->header_vars.DIMUPT, dimupt);
    dimupt++;
    if (dwg_dynapi_header_set_value (dwg, "DIMUPT", &dimupt, 0)
        && dimupt == dwg->header_vars.DIMUPT)
      pass ();
    else
      fail ("HEADER.DIMUPT [B] set+1 " FORMAT_B " != " FORMAT_B "",
            dwg->header_vars.DIMUPT, dimupt);
    dimupt--;
    dwg_dynapi_header_set_value (dwg, "DIMUPT", &dimupt, 0);

  }
  {
    BITCODE_BS dimtzin;
    if (dwg_dynapi_header_value (dwg, "DIMTZIN", &dimtzin, NULL)
        && dimtzin == dwg->header_vars.DIMTZIN)
      pass ();
    else
      fail ("HEADER.DIMTZIN [BS] %hu != %hu", dwg->header_vars.DIMTZIN, dimtzin);
    dimtzin++;
    if (dwg_dynapi_header_set_value (dwg, "DIMTZIN", &dimtzin, 0)
        && dimtzin == dwg->header_vars.DIMTZIN)
      pass ();
    else
      fail ("HEADER.DIMTZIN [BS] set+1 %hu != %hu",
            dwg->header_vars.DIMTZIN, dimtzin);
    dimtzin--;
    dwg_dynapi_header_set_value (dwg, "DIMTZIN", &dimtzin, 0);

  }
  {
    BITCODE_BS dimmaltz;
    if (dwg_dynapi_header_value (dwg, "DIMMALTZ", &dimmaltz, NULL)
        && dimmaltz == dwg->header_vars.DIMMALTZ)
      pass ();
    else
      fail ("HEADER.DIMMALTZ [BS] %hu != %hu", dwg->header_vars.DIMMALTZ, dimmaltz);
    dimmaltz++;
    if (dwg_dynapi_header_set_value (dwg, "DIMMALTZ", &dimmaltz, 0)
        && dimmaltz == dwg->header_vars.DIMMALTZ)
      pass ();
    else
      fail ("HEADER.DIMMALTZ [BS] set+1 %hu != %hu",
            dwg->header_vars.DIMMALTZ, dimmaltz);
    dimmaltz--;
    dwg_dynapi_header_set_value (dwg, "DIMMALTZ", &dimmaltz, 0);

  }
  {
    BITCODE_BS dimmalttz;
    if (dwg_dynapi_header_value (dwg, "DIMMALTTZ", &dimmalttz, NULL)
        && dimmalttz == dwg->header_vars.DIMMALTTZ)
      pass ();
    else
      fail ("HEADER.DIMMALTTZ [BS] %hu != %hu", dwg->header_vars.DIMMALTTZ, dimmalttz);
    dimmalttz++;
    if (dwg_dynapi_header_set_value (dwg, "DIMMALTTZ", &dimmalttz, 0)
        && dimmalttz == dwg->header_vars.DIMMALTTZ)
      pass ();
    else
      fail ("HEADER.DIMMALTTZ [BS] set+1 %hu != %hu",
            dwg->header_vars.DIMMALTTZ, dimmalttz);
    dimmalttz--;
    dwg_dynapi_header_set_value (dwg, "DIMMALTTZ", &dimmalttz, 0);

  }
  {
    BITCODE_BS dimtad;
    if (dwg_dynapi_header_value (dwg, "DIMTAD", &dimtad, NULL)
        && dimtad == dwg->header_vars.DIMTAD)
      pass ();
    else
      fail ("HEADER.DIMTAD [BS] %hu != %hu", dwg->header_vars.DIMTAD, dimtad);
    dimtad++;
    if (dwg_dynapi_header_set_value (dwg, "DIMTAD", &dimtad, 0)
        && dimtad == dwg->header_vars.DIMTAD)
      pass ();
    else
      fail ("HEADER.DIMTAD [BS] set+1 %hu != %hu",
            dwg->header_vars.DIMTAD, dimtad);
    dimtad--;
    dwg_dynapi_header_set_value (dwg, "DIMTAD", &dimtad, 0);

  }
  {
    BITCODE_BS dimunit;
    if (dwg_dynapi_header_value (dwg, "DIMUNIT", &dimunit, NULL)
        && dimunit == dwg->header_vars.DIMUNIT)
      pass ();
    else
      fail ("HEADER.DIMUNIT [BS] %hu != %hu", dwg->header_vars.DIMUNIT, dimunit);
    dimunit++;
    if (dwg_dynapi_header_set_value (dwg, "DIMUNIT", &dimunit, 0)
        && dimunit == dwg->header_vars.DIMUNIT)
      pass ();
    else
      fail ("HEADER.DIMUNIT [BS] set+1 %hu != %hu",
            dwg->header_vars.DIMUNIT, dimunit);
    dimunit--;
    dwg_dynapi_header_set_value (dwg, "DIMUNIT", &dimunit, 0);

  }
  {
    BITCODE_BS dimaunit;
    if (dwg_dynapi_header_value (dwg, "DIMAUNIT", &dimaunit, NULL)
        && dimaunit == dwg->header_vars.DIMAUNIT)
      pass ();
    else
      fail ("HEADER.DIMAUNIT [BS] %hu != %hu", dwg->header_vars.DIMAUNIT, dimaunit);
    dimaunit++;
    if (dwg_dynapi_header_set_value (dwg, "DIMAUNIT", &dimaunit, 0)
        && dimaunit == dwg->header_vars.DIMAUNIT)
      pass ();
    else
      fail ("HEADER.DIMAUNIT [BS] set+1 %hu != %hu",
            dwg->header_vars.DIMAUNIT, dimaunit);
    dimaunit--;
    dwg_dynapi_header_set_value (dwg, "DIMAUNIT", &dimaunit, 0);

  }
  {
    BITCODE_BS dimdec;
    if (dwg_dynapi_header_value (dwg, "DIMDEC", &dimdec, NULL)
        && dimdec == dwg->header_vars.DIMDEC)
      pass ();
    else
      fail ("HEADER.DIMDEC [BS] %hu != %hu", dwg->header_vars.DIMDEC, dimdec);
    dimdec++;
    if (dwg_dynapi_header_set_value (dwg, "DIMDEC", &dimdec, 0)
        && dimdec == dwg->header_vars.DIMDEC)
      pass ();
    else
      fail ("HEADER.DIMDEC [BS] set+1 %hu != %hu",
            dwg->header_vars.DIMDEC, dimdec);
    dimdec--;
    dwg_dynapi_header_set_value (dwg, "DIMDEC", &dimdec, 0);

  }
  {
    BITCODE_BS dimtdec;
    if (dwg_dynapi_header_value (dwg, "DIMTDEC", &dimtdec, NULL)
        && dimtdec == dwg->header_vars.DIMTDEC)
      pass ();
    else
      fail ("HEADER.DIMTDEC [BS] %hu != %hu", dwg->header_vars.DIMTDEC, dimtdec);
    dimtdec++;
    if (dwg_dynapi_header_set_value (dwg, "DIMTDEC", &dimtdec, 0)
        && dimtdec == dwg->header_vars.DIMTDEC)
      pass ();
    else
      fail ("HEADER.DIMTDEC [BS] set+1 %hu != %hu",
            dwg->header_vars.DIMTDEC, dimtdec);
    dimtdec--;
    dwg_dynapi_header_set_value (dwg, "DIMTDEC", &dimtdec, 0);

  }
  {
    BITCODE_BS dimaltu;
    if (dwg_dynapi_header_value (dwg, "DIMALTU", &dimaltu, NULL)
        && dimaltu == dwg->header_vars.DIMALTU)
      pass ();
    else
      fail ("HEADER.DIMALTU [BS] %hu != %hu", dwg->header_vars.DIMALTU, dimaltu);
    dimaltu++;
    if (dwg_dynapi_header_set_value (dwg, "DIMALTU", &dimaltu, 0)
        && dimaltu == dwg->header_vars.DIMALTU)
      pass ();
    else
      fail ("HEADER.DIMALTU [BS] set+1 %hu != %hu",
            dwg->header_vars.DIMALTU, dimaltu);
    dimaltu--;
    dwg_dynapi_header_set_value (dwg, "DIMALTU", &dimaltu, 0);

  }
  {
    BITCODE_BS dimalttd;
    if (dwg_dynapi_header_value (dwg, "DIMALTTD", &dimalttd, NULL)
        && dimalttd == dwg->header_vars.DIMALTTD)
      pass ();
    else
      fail ("HEADER.DIMALTTD [BS] %hu != %hu", dwg->header_vars.DIMALTTD, dimalttd);
    dimalttd++;
    if (dwg_dynapi_header_set_value (dwg, "DIMALTTD", &dimalttd, 0)
        && dimalttd == dwg->header_vars.DIMALTTD)
      pass ();
    else
      fail ("HEADER.DIMALTTD [BS] set+1 %hu != %hu",
            dwg->header_vars.DIMALTTD, dimalttd);
    dimalttd--;
    dwg_dynapi_header_set_value (dwg, "DIMALTTD", &dimalttd, 0);

  }
  {
    BITCODE_H dimtxsty;
    if (dwg_dynapi_header_value (dwg, "DIMTXSTY", &dimtxsty, NULL)
        && !memcmp (&dimtxsty, &dwg->header_vars.DIMTXSTY, sizeof (dwg->header_vars.DIMTXSTY))
       )
      pass ();
    else
      fail ("HEADER.DIMTXSTY [H]");
  }
  {
    BITCODE_BD dimscale;
    if (dwg_dynapi_header_value (dwg, "DIMSCALE", &dimscale, NULL)
        && dimscale == dwg->header_vars.DIMSCALE)
      pass ();
    else
      fail ("HEADER.DIMSCALE [BD] %g != %g", dwg->header_vars.DIMSCALE, dimscale);
    dimscale++;
    if (dwg_dynapi_header_set_value (dwg, "DIMSCALE", &dimscale, 0)
        && dimscale == dwg->header_vars.DIMSCALE)
      pass ();
    else
      fail ("HEADER.DIMSCALE [BD] set+1 %g != %g",
            dwg->header_vars.DIMSCALE, dimscale);
    dimscale--;
    dwg_dynapi_header_set_value (dwg, "DIMSCALE", &dimscale, 0);

  }
  {
    BITCODE_BD dimasz;
    if (dwg_dynapi_header_value (dwg, "DIMASZ", &dimasz, NULL)
        && dimasz == dwg->header_vars.DIMASZ)
      pass ();
    else
      fail ("HEADER.DIMASZ [BD] %g != %g", dwg->header_vars.DIMASZ, dimasz);
    dimasz++;
    if (dwg_dynapi_header_set_value (dwg, "DIMASZ", &dimasz, 0)
        && dimasz == dwg->header_vars.DIMASZ)
      pass ();
    else
      fail ("HEADER.DIMASZ [BD] set+1 %g != %g",
            dwg->header_vars.DIMASZ, dimasz);
    dimasz--;
    dwg_dynapi_header_set_value (dwg, "DIMASZ", &dimasz, 0);

  }
  {
    BITCODE_BD dimexo;
    if (dwg_dynapi_header_value (dwg, "DIMEXO", &dimexo, NULL)
        && dimexo == dwg->header_vars.DIMEXO)
      pass ();
    else
      fail ("HEADER.DIMEXO [BD] %g != %g", dwg->header_vars.DIMEXO, dimexo);
    dimexo++;
    if (dwg_dynapi_header_set_value (dwg, "DIMEXO", &dimexo, 0)
        && dimexo == dwg->header_vars.DIMEXO)
      pass ();
    else
      fail ("HEADER.DIMEXO [BD] set+1 %g != %g",
            dwg->header_vars.DIMEXO, dimexo);
    dimexo--;
    dwg_dynapi_header_set_value (dwg, "DIMEXO", &dimexo, 0);

  }
  {
    BITCODE_BD dimdli;
    if (dwg_dynapi_header_value (dwg, "DIMDLI", &dimdli, NULL)
        && dimdli == dwg->header_vars.DIMDLI)
      pass ();
    else
      fail ("HEADER.DIMDLI [BD] %g != %g", dwg->header_vars.DIMDLI, dimdli);
    dimdli++;
    if (dwg_dynapi_header_set_value (dwg, "DIMDLI", &dimdli, 0)
        && dimdli == dwg->header_vars.DIMDLI)
      pass ();
    else
      fail ("HEADER.DIMDLI [BD] set+1 %g != %g",
            dwg->header_vars.DIMDLI, dimdli);
    dimdli--;
    dwg_dynapi_header_set_value (dwg, "DIMDLI", &dimdli, 0);

  }
  {
    BITCODE_BD dimexe;
    if (dwg_dynapi_header_value (dwg, "DIMEXE", &dimexe, NULL)
        && dimexe == dwg->header_vars.DIMEXE)
      pass ();
    else
      fail ("HEADER.DIMEXE [BD] %g != %g", dwg->header_vars.DIMEXE, dimexe);
    dimexe++;
    if (dwg_dynapi_header_set_value (dwg, "DIMEXE", &dimexe, 0)
        && dimexe == dwg->header_vars.DIMEXE)
      pass ();
    else
      fail ("HEADER.DIMEXE [BD] set+1 %g != %g",
            dwg->header_vars.DIMEXE, dimexe);
    dimexe--;
    dwg_dynapi_header_set_value (dwg, "DIMEXE", &dimexe, 0);

  }
  {
    BITCODE_BD dimrnd;
    if (dwg_dynapi_header_value (dwg, "DIMRND", &dimrnd, NULL)
        && dimrnd == dwg->header_vars.DIMRND)
      pass ();
    else
      fail ("HEADER.DIMRND [BD] %g != %g", dwg->header_vars.DIMRND, dimrnd);
    dimrnd++;
    if (dwg_dynapi_header_set_value (dwg, "DIMRND", &dimrnd, 0)
        && dimrnd == dwg->header_vars.DIMRND)
      pass ();
    else
      fail ("HEADER.DIMRND [BD] set+1 %g != %g",
            dwg->header_vars.DIMRND, dimrnd);
    dimrnd--;
    dwg_dynapi_header_set_value (dwg, "DIMRND", &dimrnd, 0);

  }
  {
    BITCODE_BD dimdle;
    if (dwg_dynapi_header_value (dwg, "DIMDLE", &dimdle, NULL)
        && dimdle == dwg->header_vars.DIMDLE)
      pass ();
    else
      fail ("HEADER.DIMDLE [BD] %g != %g", dwg->header_vars.DIMDLE, dimdle);
    dimdle++;
    if (dwg_dynapi_header_set_value (dwg, "DIMDLE", &dimdle, 0)
        && dimdle == dwg->header_vars.DIMDLE)
      pass ();
    else
      fail ("HEADER.DIMDLE [BD] set+1 %g != %g",
            dwg->header_vars.DIMDLE, dimdle);
    dimdle--;
    dwg_dynapi_header_set_value (dwg, "DIMDLE", &dimdle, 0);

  }
  {
    BITCODE_BD dimtp;
    if (dwg_dynapi_header_value (dwg, "DIMTP", &dimtp, NULL)
        && dimtp == dwg->header_vars.DIMTP)
      pass ();
    else
      fail ("HEADER.DIMTP [BD] %g != %g", dwg->header_vars.DIMTP, dimtp);
    dimtp++;
    if (dwg_dynapi_header_set_value (dwg, "DIMTP", &dimtp, 0)
        && dimtp == dwg->header_vars.DIMTP)
      pass ();
    else
      fail ("HEADER.DIMTP [BD] set+1 %g != %g",
            dwg->header_vars.DIMTP, dimtp);
    dimtp--;
    dwg_dynapi_header_set_value (dwg, "DIMTP", &dimtp, 0);

  }
  {
    BITCODE_BD dimtm;
    if (dwg_dynapi_header_value (dwg, "DIMTM", &dimtm, NULL)
        && dimtm == dwg->header_vars.DIMTM)
      pass ();
    else
      fail ("HEADER.DIMTM [BD] %g != %g", dwg->header_vars.DIMTM, dimtm);
    dimtm++;
    if (dwg_dynapi_header_set_value (dwg, "DIMTM", &dimtm, 0)
        && dimtm == dwg->header_vars.DIMTM)
      pass ();
    else
      fail ("HEADER.DIMTM [BD] set+1 %g != %g",
            dwg->header_vars.DIMTM, dimtm);
    dimtm--;
    dwg_dynapi_header_set_value (dwg, "DIMTM", &dimtm, 0);

  }
  {
    BITCODE_BD dimfxl;
    if (dwg_dynapi_header_value (dwg, "DIMFXL", &dimfxl, NULL)
        && dimfxl == dwg->header_vars.DIMFXL)
      pass ();
    else
      fail ("HEADER.DIMFXL [BD] %g != %g", dwg->header_vars.DIMFXL, dimfxl);
    dimfxl++;
    if (dwg_dynapi_header_set_value (dwg, "DIMFXL", &dimfxl, 0)
        && dimfxl == dwg->header_vars.DIMFXL)
      pass ();
    else
      fail ("HEADER.DIMFXL [BD] set+1 %g != %g",
            dwg->header_vars.DIMFXL, dimfxl);
    dimfxl--;
    dwg_dynapi_header_set_value (dwg, "DIMFXL", &dimfxl, 0);

  }
  {
    BITCODE_BD dimjogang;
    if (dwg_dynapi_header_value (dwg, "DIMJOGANG", &dimjogang, NULL)
        && dimjogang == dwg->header_vars.DIMJOGANG)
      pass ();
    else
      fail ("HEADER.DIMJOGANG [BD] %g != %g", dwg->header_vars.DIMJOGANG, dimjogang);
    dimjogang++;
    if (dwg_dynapi_header_set_value (dwg, "DIMJOGANG", &dimjogang, 0)
        && dimjogang == dwg->header_vars.DIMJOGANG)
      pass ();
    else
      fail ("HEADER.DIMJOGANG [BD] set+1 %g != %g",
            dwg->header_vars.DIMJOGANG, dimjogang);
    dimjogang--;
    dwg_dynapi_header_set_value (dwg, "DIMJOGANG", &dimjogang, 0);

  }
  {
    BITCODE_BS dimtfill;
    if (dwg_dynapi_header_value (dwg, "DIMTFILL", &dimtfill, NULL)
        && dimtfill == dwg->header_vars.DIMTFILL)
      pass ();
    else
      fail ("HEADER.DIMTFILL [BS] %hu != %hu", dwg->header_vars.DIMTFILL, dimtfill);
    dimtfill++;
    if (dwg_dynapi_header_set_value (dwg, "DIMTFILL", &dimtfill, 0)
        && dimtfill == dwg->header_vars.DIMTFILL)
      pass ();
    else
      fail ("HEADER.DIMTFILL [BS] set+1 %hu != %hu",
            dwg->header_vars.DIMTFILL, dimtfill);
    dimtfill--;
    dwg_dynapi_header_set_value (dwg, "DIMTFILL", &dimtfill, 0);

  }
  {
    BITCODE_CMC dimtfillclr;
    if (dwg_dynapi_header_value (dwg, "DIMTFILLCLR", &dimtfillclr, NULL)
        && !memcmp (&dimtfillclr, &dwg->header_vars.DIMTFILLCLR, sizeof (dwg->header_vars.DIMTFILLCLR))
       )
      pass ();
    else
      fail ("HEADER.DIMTFILLCLR [CMC]");
  }
  {
    BITCODE_BS dimazin;
    if (dwg_dynapi_header_value (dwg, "DIMAZIN", &dimazin, NULL)
        && dimazin == dwg->header_vars.DIMAZIN)
      pass ();
    else
      fail ("HEADER.DIMAZIN [BS] %hu != %hu", dwg->header_vars.DIMAZIN, dimazin);
    dimazin++;
    if (dwg_dynapi_header_set_value (dwg, "DIMAZIN", &dimazin, 0)
        && dimazin == dwg->header_vars.DIMAZIN)
      pass ();
    else
      fail ("HEADER.DIMAZIN [BS] set+1 %hu != %hu",
            dwg->header_vars.DIMAZIN, dimazin);
    dimazin--;
    dwg_dynapi_header_set_value (dwg, "DIMAZIN", &dimazin, 0);

  }
  {
    BITCODE_BS dimarcsym;
    if (dwg_dynapi_header_value (dwg, "DIMARCSYM", &dimarcsym, NULL)
        && dimarcsym == dwg->header_vars.DIMARCSYM)
      pass ();
    else
      fail ("HEADER.DIMARCSYM [BS] %hu != %hu", dwg->header_vars.DIMARCSYM, dimarcsym);
    dimarcsym++;
    if (dwg_dynapi_header_set_value (dwg, "DIMARCSYM", &dimarcsym, 0)
        && dimarcsym == dwg->header_vars.DIMARCSYM)
      pass ();
    else
      fail ("HEADER.DIMARCSYM [BS] set+1 %hu != %hu",
            dwg->header_vars.DIMARCSYM, dimarcsym);
    dimarcsym--;
    dwg_dynapi_header_set_value (dwg, "DIMARCSYM", &dimarcsym, 0);

  }
  {
    BITCODE_BD dimtxt;
    if (dwg_dynapi_header_value (dwg, "DIMTXT", &dimtxt, NULL)
        && dimtxt == dwg->header_vars.DIMTXT)
      pass ();
    else
      fail ("HEADER.DIMTXT [BD] %g != %g", dwg->header_vars.DIMTXT, dimtxt);
    dimtxt++;
    if (dwg_dynapi_header_set_value (dwg, "DIMTXT", &dimtxt, 0)
        && dimtxt == dwg->header_vars.DIMTXT)
      pass ();
    else
      fail ("HEADER.DIMTXT [BD] set+1 %g != %g",
            dwg->header_vars.DIMTXT, dimtxt);
    dimtxt--;
    dwg_dynapi_header_set_value (dwg, "DIMTXT", &dimtxt, 0);

  }
  {
    BITCODE_BD dimcen;
    if (dwg_dynapi_header_value (dwg, "DIMCEN", &dimcen, NULL)
        && dimcen == dwg->header_vars.DIMCEN)
      pass ();
    else
      fail ("HEADER.DIMCEN [BD] %g != %g", dwg->header_vars.DIMCEN, dimcen);
    dimcen++;
    if (dwg_dynapi_header_set_value (dwg, "DIMCEN", &dimcen, 0)
        && dimcen == dwg->header_vars.DIMCEN)
      pass ();
    else
      fail ("HEADER.DIMCEN [BD] set+1 %g != %g",
            dwg->header_vars.DIMCEN, dimcen);
    dimcen--;
    dwg_dynapi_header_set_value (dwg, "DIMCEN", &dimcen, 0);

  }
  {
    BITCODE_BD dimtsz;
    if (dwg_dynapi_header_value (dwg, "DIMTSZ", &dimtsz, NULL)
        && dimtsz == dwg->header_vars.DIMTSZ)
      pass ();
    else
      fail ("HEADER.DIMTSZ [BD] %g != %g", dwg->header_vars.DIMTSZ, dimtsz);
    dimtsz++;
    if (dwg_dynapi_header_set_value (dwg, "DIMTSZ", &dimtsz, 0)
        && dimtsz == dwg->header_vars.DIMTSZ)
      pass ();
    else
      fail ("HEADER.DIMTSZ [BD] set+1 %g != %g",
            dwg->header_vars.DIMTSZ, dimtsz);
    dimtsz--;
    dwg_dynapi_header_set_value (dwg, "DIMTSZ", &dimtsz, 0);

  }
  {
    BITCODE_BD dimaltf;
    if (dwg_dynapi_header_value (dwg, "DIMALTF", &dimaltf, NULL)
        && dimaltf == dwg->header_vars.DIMALTF)
      pass ();
    else
      fail ("HEADER.DIMALTF [BD] %g != %g", dwg->header_vars.DIMALTF, dimaltf);
    dimaltf++;
    if (dwg_dynapi_header_set_value (dwg, "DIMALTF", &dimaltf, 0)
        && dimaltf == dwg->header_vars.DIMALTF)
      pass ();
    else
      fail ("HEADER.DIMALTF [BD] set+1 %g != %g",
            dwg->header_vars.DIMALTF, dimaltf);
    dimaltf--;
    dwg_dynapi_header_set_value (dwg, "DIMALTF", &dimaltf, 0);

  }
  {
    BITCODE_BD dimlfac;
    if (dwg_dynapi_header_value (dwg, "DIMLFAC", &dimlfac, NULL)
        && dimlfac == dwg->header_vars.DIMLFAC)
      pass ();
    else
      fail ("HEADER.DIMLFAC [BD] %g != %g", dwg->header_vars.DIMLFAC, dimlfac);
    dimlfac++;
    if (dwg_dynapi_header_set_value (dwg, "DIMLFAC", &dimlfac, 0)
        && dimlfac == dwg->header_vars.DIMLFAC)
      pass ();
    else
      fail ("HEADER.DIMLFAC [BD] set+1 %g != %g",
            dwg->header_vars.DIMLFAC, dimlfac);
    dimlfac--;
    dwg_dynapi_header_set_value (dwg, "DIMLFAC", &dimlfac, 0);

  }
  {
    BITCODE_BD dimtvp;
    if (dwg_dynapi_header_value (dwg, "DIMTVP", &dimtvp, NULL)
        && dimtvp == dwg->header_vars.DIMTVP)
      pass ();
    else
      fail ("HEADER.DIMTVP [BD] %g != %g", dwg->header_vars.DIMTVP, dimtvp);
    dimtvp++;
    if (dwg_dynapi_header_set_value (dwg, "DIMTVP", &dimtvp, 0)
        && dimtvp == dwg->header_vars.DIMTVP)
      pass ();
    else
      fail ("HEADER.DIMTVP [BD] set+1 %g != %g",
            dwg->header_vars.DIMTVP, dimtvp);
    dimtvp--;
    dwg_dynapi_header_set_value (dwg, "DIMTVP", &dimtvp, 0);

  }
  {
    BITCODE_BD dimtfac;
    if (dwg_dynapi_header_value (dwg, "DIMTFAC", &dimtfac, NULL)
        && dimtfac == dwg->header_vars.DIMTFAC)
      pass ();
    else
      fail ("HEADER.DIMTFAC [BD] %g != %g", dwg->header_vars.DIMTFAC, dimtfac);
    dimtfac++;
    if (dwg_dynapi_header_set_value (dwg, "DIMTFAC", &dimtfac, 0)
        && dimtfac == dwg->header_vars.DIMTFAC)
      pass ();
    else
      fail ("HEADER.DIMTFAC [BD] set+1 %g != %g",
            dwg->header_vars.DIMTFAC, dimtfac);
    dimtfac--;
    dwg_dynapi_header_set_value (dwg, "DIMTFAC", &dimtfac, 0);

  }
  {
    BITCODE_BD dimgap;
    if (dwg_dynapi_header_value (dwg, "DIMGAP", &dimgap, NULL)
        && dimgap == dwg->header_vars.DIMGAP)
      pass ();
    else
      fail ("HEADER.DIMGAP [BD] %g != %g", dwg->header_vars.DIMGAP, dimgap);
    dimgap++;
    if (dwg_dynapi_header_set_value (dwg, "DIMGAP", &dimgap, 0)
        && dimgap == dwg->header_vars.DIMGAP)
      pass ();
    else
      fail ("HEADER.DIMGAP [BD] set+1 %g != %g",
            dwg->header_vars.DIMGAP, dimgap);
    dimgap--;
    dwg_dynapi_header_set_value (dwg, "DIMGAP", &dimgap, 0);

  }
  {
    BITCODE_T dimpost_t;
    if (dwg_dynapi_header_value (dwg, "DIMPOST_T", &dimpost_t, NULL)
        && !memcmp (&dimpost_t, &dwg->header_vars.DIMPOST_T, sizeof (dwg->header_vars.DIMPOST_T))
       )
      pass ();
    else
      fail ("HEADER.DIMPOST_T [T]");
  }
  {
    BITCODE_T dimapost_t;
    if (dwg_dynapi_header_value (dwg, "DIMAPOST_T", &dimapost_t, NULL)
        && !memcmp (&dimapost_t, &dwg->header_vars.DIMAPOST_T, sizeof (dwg->header_vars.DIMAPOST_T))
       )
      pass ();
    else
      fail ("HEADER.DIMAPOST_T [T]");
  }
  {
    BITCODE_T dimblk_t;
    if (dwg_dynapi_header_value (dwg, "DIMBLK_T", &dimblk_t, NULL)
        && !memcmp (&dimblk_t, &dwg->header_vars.DIMBLK_T, sizeof (dwg->header_vars.DIMBLK_T))
       )
      pass ();
    else
      fail ("HEADER.DIMBLK_T [T]");
  }
  {
    BITCODE_T dimblk1_t;
    if (dwg_dynapi_header_value (dwg, "DIMBLK1_T", &dimblk1_t, NULL)
        && !memcmp (&dimblk1_t, &dwg->header_vars.DIMBLK1_T, sizeof (dwg->header_vars.DIMBLK1_T))
       )
      pass ();
    else
      fail ("HEADER.DIMBLK1_T [T]");
  }
  {
    BITCODE_T dimblk2_t;
    if (dwg_dynapi_header_value (dwg, "DIMBLK2_T", &dimblk2_t, NULL)
        && !memcmp (&dimblk2_t, &dwg->header_vars.DIMBLK2_T, sizeof (dwg->header_vars.DIMBLK2_T))
       )
      pass ();
    else
      fail ("HEADER.DIMBLK2_T [T]");
  }
  {
    BITCODE_BD dimaltrnd;
    if (dwg_dynapi_header_value (dwg, "DIMALTRND", &dimaltrnd, NULL)
        && dimaltrnd == dwg->header_vars.DIMALTRND)
      pass ();
    else
      fail ("HEADER.DIMALTRND [BD] %g != %g", dwg->header_vars.DIMALTRND, dimaltrnd);
    dimaltrnd++;
    if (dwg_dynapi_header_set_value (dwg, "DIMALTRND", &dimaltrnd, 0)
        && dimaltrnd == dwg->header_vars.DIMALTRND)
      pass ();
    else
      fail ("HEADER.DIMALTRND [BD] set+1 %g != %g",
            dwg->header_vars.DIMALTRND, dimaltrnd);
    dimaltrnd--;
    dwg_dynapi_header_set_value (dwg, "DIMALTRND", &dimaltrnd, 0);

  }
  {
    BITCODE_RS dimclrd_c;
    if (dwg_dynapi_header_value (dwg, "DIMCLRD_C", &dimclrd_c, NULL)
        && dimclrd_c == dwg->header_vars.DIMCLRD_C)
      pass ();
    else
      fail ("HEADER.DIMCLRD_C [RS] %hu != %hu", dwg->header_vars.DIMCLRD_C, dimclrd_c);
    dimclrd_c++;
    if (dwg_dynapi_header_set_value (dwg, "DIMCLRD_C", &dimclrd_c, 0)
        && dimclrd_c == dwg->header_vars.DIMCLRD_C)
      pass ();
    else
      fail ("HEADER.DIMCLRD_C [RS] set+1 %hu != %hu",
            dwg->header_vars.DIMCLRD_C, dimclrd_c);
    dimclrd_c--;
    dwg_dynapi_header_set_value (dwg, "DIMCLRD_C", &dimclrd_c, 0);

  }
  {
    BITCODE_RS dimclre_c;
    if (dwg_dynapi_header_value (dwg, "DIMCLRE_C", &dimclre_c, NULL)
        && dimclre_c == dwg->header_vars.DIMCLRE_C)
      pass ();
    else
      fail ("HEADER.DIMCLRE_C [RS] %hu != %hu", dwg->header_vars.DIMCLRE_C, dimclre_c);
    dimclre_c++;
    if (dwg_dynapi_header_set_value (dwg, "DIMCLRE_C", &dimclre_c, 0)
        && dimclre_c == dwg->header_vars.DIMCLRE_C)
      pass ();
    else
      fail ("HEADER.DIMCLRE_C [RS] set+1 %hu != %hu",
            dwg->header_vars.DIMCLRE_C, dimclre_c);
    dimclre_c--;
    dwg_dynapi_header_set_value (dwg, "DIMCLRE_C", &dimclre_c, 0);

  }
  {
    BITCODE_RS dimclrt_c;
    if (dwg_dynapi_header_value (dwg, "DIMCLRT_C", &dimclrt_c, NULL)
        && dimclrt_c == dwg->header_vars.DIMCLRT_C)
      pass ();
    else
      fail ("HEADER.DIMCLRT_C [RS] %hu != %hu", dwg->header_vars.DIMCLRT_C, dimclrt_c);
    dimclrt_c++;
    if (dwg_dynapi_header_set_value (dwg, "DIMCLRT_C", &dimclrt_c, 0)
        && dimclrt_c == dwg->header_vars.DIMCLRT_C)
      pass ();
    else
      fail ("HEADER.DIMCLRT_C [RS] set+1 %hu != %hu",
            dwg->header_vars.DIMCLRT_C, dimclrt_c);
    dimclrt_c--;
    dwg_dynapi_header_set_value (dwg, "DIMCLRT_C", &dimclrt_c, 0);

  }
  {
    BITCODE_CMC dimclrd;
    if (dwg_dynapi_header_value (dwg, "DIMCLRD", &dimclrd, NULL)
        && !memcmp (&dimclrd, &dwg->header_vars.DIMCLRD, sizeof (dwg->header_vars.DIMCLRD))
       )
      pass ();
    else
      fail ("HEADER.DIMCLRD [CMC]");
  }
  {
    BITCODE_CMC dimclre;
    if (dwg_dynapi_header_value (dwg, "DIMCLRE", &dimclre, NULL)
        && !memcmp (&dimclre, &dwg->header_vars.DIMCLRE, sizeof (dwg->header_vars.DIMCLRE))
       )
      pass ();
    else
      fail ("HEADER.DIMCLRE [CMC]");
  }
  {
    BITCODE_CMC dimclrt;
    if (dwg_dynapi_header_value (dwg, "DIMCLRT", &dimclrt, NULL)
        && !memcmp (&dimclrt, &dwg->header_vars.DIMCLRT, sizeof (dwg->header_vars.DIMCLRT))
       )
      pass ();
    else
      fail ("HEADER.DIMCLRT [CMC]");
  }
  {
    BITCODE_BS dimadec;
    if (dwg_dynapi_header_value (dwg, "DIMADEC", &dimadec, NULL)
        && dimadec == dwg->header_vars.DIMADEC)
      pass ();
    else
      fail ("HEADER.DIMADEC [BS] %hu != %hu", dwg->header_vars.DIMADEC, dimadec);
    dimadec++;
    if (dwg_dynapi_header_set_value (dwg, "DIMADEC", &dimadec, 0)
        && dimadec == dwg->header_vars.DIMADEC)
      pass ();
    else
      fail ("HEADER.DIMADEC [BS] set+1 %hu != %hu",
            dwg->header_vars.DIMADEC, dimadec);
    dimadec--;
    dwg_dynapi_header_set_value (dwg, "DIMADEC", &dimadec, 0);

  }
  {
    BITCODE_BS dimfrac;
    if (dwg_dynapi_header_value (dwg, "DIMFRAC", &dimfrac, NULL)
        && dimfrac == dwg->header_vars.DIMFRAC)
      pass ();
    else
      fail ("HEADER.DIMFRAC [BS] %hu != %hu", dwg->header_vars.DIMFRAC, dimfrac);
    dimfrac++;
    if (dwg_dynapi_header_set_value (dwg, "DIMFRAC", &dimfrac, 0)
        && dimfrac == dwg->header_vars.DIMFRAC)
      pass ();
    else
      fail ("HEADER.DIMFRAC [BS] set+1 %hu != %hu",
            dwg->header_vars.DIMFRAC, dimfrac);
    dimfrac--;
    dwg_dynapi_header_set_value (dwg, "DIMFRAC", &dimfrac, 0);

  }
  {
    BITCODE_BS dimlunit;
    if (dwg_dynapi_header_value (dwg, "DIMLUNIT", &dimlunit, NULL)
        && dimlunit == dwg->header_vars.DIMLUNIT)
      pass ();
    else
      fail ("HEADER.DIMLUNIT [BS] %hu != %hu", dwg->header_vars.DIMLUNIT, dimlunit);
    dimlunit++;
    if (dwg_dynapi_header_set_value (dwg, "DIMLUNIT", &dimlunit, 0)
        && dimlunit == dwg->header_vars.DIMLUNIT)
      pass ();
    else
      fail ("HEADER.DIMLUNIT [BS] set+1 %hu != %hu",
            dwg->header_vars.DIMLUNIT, dimlunit);
    dimlunit--;
    dwg_dynapi_header_set_value (dwg, "DIMLUNIT", &dimlunit, 0);

  }
  {
    BITCODE_BS dimdsep;
    if (dwg_dynapi_header_value (dwg, "DIMDSEP", &dimdsep, NULL)
        && dimdsep == dwg->header_vars.DIMDSEP)
      pass ();
    else
      fail ("HEADER.DIMDSEP [BS] %hu != %hu", dwg->header_vars.DIMDSEP, dimdsep);
    dimdsep++;
    if (dwg_dynapi_header_set_value (dwg, "DIMDSEP", &dimdsep, 0)
        && dimdsep == dwg->header_vars.DIMDSEP)
      pass ();
    else
      fail ("HEADER.DIMDSEP [BS] set+1 %hu != %hu",
            dwg->header_vars.DIMDSEP, dimdsep);
    dimdsep--;
    dwg_dynapi_header_set_value (dwg, "DIMDSEP", &dimdsep, 0);

  }
  {
    BITCODE_BS dimtmove;
    if (dwg_dynapi_header_value (dwg, "DIMTMOVE", &dimtmove, NULL)
        && dimtmove == dwg->header_vars.DIMTMOVE)
      pass ();
    else
      fail ("HEADER.DIMTMOVE [BS] %hu != %hu", dwg->header_vars.DIMTMOVE, dimtmove);
    dimtmove++;
    if (dwg_dynapi_header_set_value (dwg, "DIMTMOVE", &dimtmove, 0)
        && dimtmove == dwg->header_vars.DIMTMOVE)
      pass ();
    else
      fail ("HEADER.DIMTMOVE [BS] set+1 %hu != %hu",
            dwg->header_vars.DIMTMOVE, dimtmove);
    dimtmove--;
    dwg_dynapi_header_set_value (dwg, "DIMTMOVE", &dimtmove, 0);

  }
  {
    BITCODE_BS dimaltz;
    if (dwg_dynapi_header_value (dwg, "DIMALTZ", &dimaltz, NULL)
        && dimaltz == dwg->header_vars.DIMALTZ)
      pass ();
    else
      fail ("HEADER.DIMALTZ [BS] %hu != %hu", dwg->header_vars.DIMALTZ, dimaltz);
    dimaltz++;
    if (dwg_dynapi_header_set_value (dwg, "DIMALTZ", &dimaltz, 0)
        && dimaltz == dwg->header_vars.DIMALTZ)
      pass ();
    else
      fail ("HEADER.DIMALTZ [BS] set+1 %hu != %hu",
            dwg->header_vars.DIMALTZ, dimaltz);
    dimaltz--;
    dwg_dynapi_header_set_value (dwg, "DIMALTZ", &dimaltz, 0);

  }
  {
    BITCODE_BS dimalttz;
    if (dwg_dynapi_header_value (dwg, "DIMALTTZ", &dimalttz, NULL)
        && dimalttz == dwg->header_vars.DIMALTTZ)
      pass ();
    else
      fail ("HEADER.DIMALTTZ [BS] %hu != %hu", dwg->header_vars.DIMALTTZ, dimalttz);
    dimalttz++;
    if (dwg_dynapi_header_set_value (dwg, "DIMALTTZ", &dimalttz, 0)
        && dimalttz == dwg->header_vars.DIMALTTZ)
      pass ();
    else
      fail ("HEADER.DIMALTTZ [BS] set+1 %hu != %hu",
            dwg->header_vars.DIMALTTZ, dimalttz);
    dimalttz--;
    dwg_dynapi_header_set_value (dwg, "DIMALTTZ", &dimalttz, 0);

  }
  {
    BITCODE_BS dimatfit;
    if (dwg_dynapi_header_value (dwg, "DIMATFIT", &dimatfit, NULL)
        && dimatfit == dwg->header_vars.DIMATFIT)
      pass ();
    else
      fail ("HEADER.DIMATFIT [BS] %hu != %hu", dwg->header_vars.DIMATFIT, dimatfit);
    dimatfit++;
    if (dwg_dynapi_header_set_value (dwg, "DIMATFIT", &dimatfit, 0)
        && dimatfit == dwg->header_vars.DIMATFIT)
      pass ();
    else
      fail ("HEADER.DIMATFIT [BS] set+1 %hu != %hu",
            dwg->header_vars.DIMATFIT, dimatfit);
    dimatfit--;
    dwg_dynapi_header_set_value (dwg, "DIMATFIT", &dimatfit, 0);

  }
  {
    BITCODE_B dimfxlon;
    if (dwg_dynapi_header_value (dwg, "DIMFXLON", &dimfxlon, NULL)
        && dimfxlon == dwg->header_vars.DIMFXLON)
      pass ();
    else
      fail ("HEADER.DIMFXLON [B] " FORMAT_B " != " FORMAT_B "", dwg->header_vars.DIMFXLON, dimfxlon);
    dimfxlon++;
    if (dwg_dynapi_header_set_value (dwg, "DIMFXLON", &dimfxlon, 0)
        && dimfxlon == dwg->header_vars.DIMFXLON)
      pass ();
    else
      fail ("HEADER.DIMFXLON [B] set+1 " FORMAT_B " != " FORMAT_B "",
            dwg->header_vars.DIMFXLON, dimfxlon);
    dimfxlon--;
    dwg_dynapi_header_set_value (dwg, "DIMFXLON", &dimfxlon, 0);

  }
  {
    BITCODE_B dimtxtdirection;
    if (dwg_dynapi_header_value (dwg, "DIMTXTDIRECTION", &dimtxtdirection, NULL)
        && dimtxtdirection == dwg->header_vars.DIMTXTDIRECTION)
      pass ();
    else
      fail ("HEADER.DIMTXTDIRECTION [B] " FORMAT_B " != " FORMAT_B "", dwg->header_vars.DIMTXTDIRECTION, dimtxtdirection);
    dimtxtdirection++;
    if (dwg_dynapi_header_set_value (dwg, "DIMTXTDIRECTION", &dimtxtdirection, 0)
        && dimtxtdirection == dwg->header_vars.DIMTXTDIRECTION)
      pass ();
    else
      fail ("HEADER.DIMTXTDIRECTION [B] set+1 " FORMAT_B " != " FORMAT_B "",
            dwg->header_vars.DIMTXTDIRECTION, dimtxtdirection);
    dimtxtdirection--;
    dwg_dynapi_header_set_value (dwg, "DIMTXTDIRECTION", &dimtxtdirection, 0);

  }
  {
    BITCODE_BD dimaltmzf;
    if (dwg_dynapi_header_value (dwg, "DIMALTMZF", &dimaltmzf, NULL)
        && dimaltmzf == dwg->header_vars.DIMALTMZF)
      pass ();
    else
      fail ("HEADER.DIMALTMZF [BD] %g != %g", dwg->header_vars.DIMALTMZF, dimaltmzf);
    dimaltmzf++;
    if (dwg_dynapi_header_set_value (dwg, "DIMALTMZF", &dimaltmzf, 0)
        && dimaltmzf == dwg->header_vars.DIMALTMZF)
      pass ();
    else
      fail ("HEADER.DIMALTMZF [BD] set+1 %g != %g",
            dwg->header_vars.DIMALTMZF, dimaltmzf);
    dimaltmzf--;
    dwg_dynapi_header_set_value (dwg, "DIMALTMZF", &dimaltmzf, 0);

  }
  {
    BITCODE_T dimaltmzs;
    if (dwg_dynapi_header_value (dwg, "DIMALTMZS", &dimaltmzs, NULL)
        && !memcmp (&dimaltmzs, &dwg->header_vars.DIMALTMZS, sizeof (dwg->header_vars.DIMALTMZS))
       )
      pass ();
    else
      fail ("HEADER.DIMALTMZS [T]");
  }
  {
    BITCODE_BD dimmzf;
    if (dwg_dynapi_header_value (dwg, "DIMMZF", &dimmzf, NULL)
        && dimmzf == dwg->header_vars.DIMMZF)
      pass ();
    else
      fail ("HEADER.DIMMZF [BD] %g != %g", dwg->header_vars.DIMMZF, dimmzf);
    dimmzf++;
    if (dwg_dynapi_header_set_value (dwg, "DIMMZF", &dimmzf, 0)
        && dimmzf == dwg->header_vars.DIMMZF)
      pass ();
    else
      fail ("HEADER.DIMMZF [BD] set+1 %g != %g",
            dwg->header_vars.DIMMZF, dimmzf);
    dimmzf--;
    dwg_dynapi_header_set_value (dwg, "DIMMZF", &dimmzf, 0);

  }
  {
    BITCODE_T dimmzs;
    if (dwg_dynapi_header_value (dwg, "DIMMZS", &dimmzs, NULL)
        && !memcmp (&dimmzs, &dwg->header_vars.DIMMZS, sizeof (dwg->header_vars.DIMMZS))
       )
      pass ();
    else
      fail ("HEADER.DIMMZS [T]");
  }
  {
    BITCODE_H dimldrblk;
    if (dwg_dynapi_header_value (dwg, "DIMLDRBLK", &dimldrblk, NULL)
        && !memcmp (&dimldrblk, &dwg->header_vars.DIMLDRBLK, sizeof (dwg->header_vars.DIMLDRBLK))
       )
      pass ();
    else
      fail ("HEADER.DIMLDRBLK [H]");
  }
  {
    BITCODE_H dimblk;
    if (dwg_dynapi_header_value (dwg, "DIMBLK", &dimblk, NULL)
        && !memcmp (&dimblk, &dwg->header_vars.DIMBLK, sizeof (dwg->header_vars.DIMBLK))
       )
      pass ();
    else
      fail ("HEADER.DIMBLK [H]");
  }
  {
    BITCODE_H dimblk1;
    if (dwg_dynapi_header_value (dwg, "DIMBLK1", &dimblk1, NULL)
        && !memcmp (&dimblk1, &dwg->header_vars.DIMBLK1, sizeof (dwg->header_vars.DIMBLK1))
       )
      pass ();
    else
      fail ("HEADER.DIMBLK1 [H]");
  }
  {
    BITCODE_H dimblk2;
    if (dwg_dynapi_header_value (dwg, "DIMBLK2", &dimblk2, NULL)
        && !memcmp (&dimblk2, &dwg->header_vars.DIMBLK2, sizeof (dwg->header_vars.DIMBLK2))
       )
      pass ();
    else
      fail ("HEADER.DIMBLK2 [H]");
  }
  {
    BITCODE_H dimltype;
    if (dwg_dynapi_header_value (dwg, "DIMLTYPE", &dimltype, NULL)
        && !memcmp (&dimltype, &dwg->header_vars.DIMLTYPE, sizeof (dwg->header_vars.DIMLTYPE))
       )
      pass ();
    else
      fail ("HEADER.DIMLTYPE [H]");
  }
  {
    BITCODE_H dimltex1;
    if (dwg_dynapi_header_value (dwg, "DIMLTEX1", &dimltex1, NULL)
        && !memcmp (&dimltex1, &dwg->header_vars.DIMLTEX1, sizeof (dwg->header_vars.DIMLTEX1))
       )
      pass ();
    else
      fail ("HEADER.DIMLTEX1 [H]");
  }
  {
    BITCODE_H dimltex2;
    if (dwg_dynapi_header_value (dwg, "DIMLTEX2", &dimltex2, NULL)
        && !memcmp (&dimltex2, &dwg->header_vars.DIMLTEX2, sizeof (dwg->header_vars.DIMLTEX2))
       )
      pass ();
    else
      fail ("HEADER.DIMLTEX2 [H]");
  }
  {
    BITCODE_BSd dimlwd;
    if (dwg_dynapi_header_value (dwg, "DIMLWD", &dimlwd, NULL)
        && dimlwd == dwg->header_vars.DIMLWD)
      pass ();
    else
      fail ("HEADER.DIMLWD [BSd] " FORMAT_BSd " != " FORMAT_BSd "", dwg->header_vars.DIMLWD, dimlwd);
    dimlwd++;
    if (dwg_dynapi_header_set_value (dwg, "DIMLWD", &dimlwd, 0)
        && dimlwd == dwg->header_vars.DIMLWD)
      pass ();
    else
      fail ("HEADER.DIMLWD [BSd] set+1 " FORMAT_BSd " != " FORMAT_BSd "",
            dwg->header_vars.DIMLWD, dimlwd);
    dimlwd--;
    dwg_dynapi_header_set_value (dwg, "DIMLWD", &dimlwd, 0);

  }
  {
    BITCODE_BSd dimlwe;
    if (dwg_dynapi_header_value (dwg, "DIMLWE", &dimlwe, NULL)
        && dimlwe == dwg->header_vars.DIMLWE)
      pass ();
    else
      fail ("HEADER.DIMLWE [BSd] " FORMAT_BSd " != " FORMAT_BSd "", dwg->header_vars.DIMLWE, dimlwe);
    dimlwe++;
    if (dwg_dynapi_header_set_value (dwg, "DIMLWE", &dimlwe, 0)
        && dimlwe == dwg->header_vars.DIMLWE)
      pass ();
    else
      fail ("HEADER.DIMLWE [BSd] set+1 " FORMAT_BSd " != " FORMAT_BSd "",
            dwg->header_vars.DIMLWE, dimlwe);
    dimlwe--;
    dwg_dynapi_header_set_value (dwg, "DIMLWE", &dimlwe, 0);

  }
  {
    BITCODE_H block_control_object;
    if (dwg_dynapi_header_value (dwg, "BLOCK_CONTROL_OBJECT", &block_control_object, NULL)
        && !memcmp (&block_control_object, &dwg->header_vars.BLOCK_CONTROL_OBJECT, sizeof (dwg->header_vars.BLOCK_CONTROL_OBJECT))
       )
      pass ();
    else
      fail ("HEADER.BLOCK_CONTROL_OBJECT [H]");
  }
  {
    BITCODE_H layer_control_object;
    if (dwg_dynapi_header_value (dwg, "LAYER_CONTROL_OBJECT", &layer_control_object, NULL)
        && !memcmp (&layer_control_object, &dwg->header_vars.LAYER_CONTROL_OBJECT, sizeof (dwg->header_vars.LAYER_CONTROL_OBJECT))
       )
      pass ();
    else
      fail ("HEADER.LAYER_CONTROL_OBJECT [H]");
  }
  {
    BITCODE_H style_control_object;
    if (dwg_dynapi_header_value (dwg, "STYLE_CONTROL_OBJECT", &style_control_object, NULL)
        && !memcmp (&style_control_object, &dwg->header_vars.STYLE_CONTROL_OBJECT, sizeof (dwg->header_vars.STYLE_CONTROL_OBJECT))
       )
      pass ();
    else
      fail ("HEADER.STYLE_CONTROL_OBJECT [H]");
  }
  {
    BITCODE_H ltype_control_object;
    if (dwg_dynapi_header_value (dwg, "LTYPE_CONTROL_OBJECT", &ltype_control_object, NULL)
        && !memcmp (&ltype_control_object, &dwg->header_vars.LTYPE_CONTROL_OBJECT, sizeof (dwg->header_vars.LTYPE_CONTROL_OBJECT))
       )
      pass ();
    else
      fail ("HEADER.LTYPE_CONTROL_OBJECT [H]");
  }
  {
    BITCODE_H view_control_object;
    if (dwg_dynapi_header_value (dwg, "VIEW_CONTROL_OBJECT", &view_control_object, NULL)
        && !memcmp (&view_control_object, &dwg->header_vars.VIEW_CONTROL_OBJECT, sizeof (dwg->header_vars.VIEW_CONTROL_OBJECT))
       )
      pass ();
    else
      fail ("HEADER.VIEW_CONTROL_OBJECT [H]");
  }
  {
    BITCODE_H ucs_control_object;
    if (dwg_dynapi_header_value (dwg, "UCS_CONTROL_OBJECT", &ucs_control_object, NULL)
        && !memcmp (&ucs_control_object, &dwg->header_vars.UCS_CONTROL_OBJECT, sizeof (dwg->header_vars.UCS_CONTROL_OBJECT))
       )
      pass ();
    else
      fail ("HEADER.UCS_CONTROL_OBJECT [H]");
  }
  {
    BITCODE_H vport_control_object;
    if (dwg_dynapi_header_value (dwg, "VPORT_CONTROL_OBJECT", &vport_control_object, NULL)
        && !memcmp (&vport_control_object, &dwg->header_vars.VPORT_CONTROL_OBJECT, sizeof (dwg->header_vars.VPORT_CONTROL_OBJECT))
       )
      pass ();
    else
      fail ("HEADER.VPORT_CONTROL_OBJECT [H]");
  }
  {
    BITCODE_H appid_control_object;
    if (dwg_dynapi_header_value (dwg, "APPID_CONTROL_OBJECT", &appid_control_object, NULL)
        && !memcmp (&appid_control_object, &dwg->header_vars.APPID_CONTROL_OBJECT, sizeof (dwg->header_vars.APPID_CONTROL_OBJECT))
       )
      pass ();
    else
      fail ("HEADER.APPID_CONTROL_OBJECT [H]");
  }
  {
    BITCODE_H dimstyle_control_object;
    if (dwg_dynapi_header_value (dwg, "DIMSTYLE_CONTROL_OBJECT", &dimstyle_control_object, NULL)
        && !memcmp (&dimstyle_control_object, &dwg->header_vars.DIMSTYLE_CONTROL_OBJECT, sizeof (dwg->header_vars.DIMSTYLE_CONTROL_OBJECT))
       )
      pass ();
    else
      fail ("HEADER.DIMSTYLE_CONTROL_OBJECT [H]");
  }
  {
    BITCODE_H vx_control_object;
    if (dwg_dynapi_header_value (dwg, "VX_CONTROL_OBJECT", &vx_control_object, NULL)
        && !memcmp (&vx_control_object, &dwg->header_vars.VX_CONTROL_OBJECT, sizeof (dwg->header_vars.VX_CONTROL_OBJECT))
       )
      pass ();
    else
      fail ("HEADER.VX_CONTROL_OBJECT [H]");
  }
  {
    BITCODE_H dictionary_acad_group;
    if (dwg_dynapi_header_value (dwg, "DICTIONARY_ACAD_GROUP", &dictionary_acad_group, NULL)
        && !memcmp (&dictionary_acad_group, &dwg->header_vars.DICTIONARY_ACAD_GROUP, sizeof (dwg->header_vars.DICTIONARY_ACAD_GROUP))
       )
      pass ();
    else
      fail ("HEADER.DICTIONARY_ACAD_GROUP [H]");
  }
  {
    BITCODE_H dictionary_acad_mlinestyle;
    if (dwg_dynapi_header_value (dwg, "DICTIONARY_ACAD_MLINESTYLE", &dictionary_acad_mlinestyle, NULL)
        && !memcmp (&dictionary_acad_mlinestyle, &dwg->header_vars.DICTIONARY_ACAD_MLINESTYLE, sizeof (dwg->header_vars.DICTIONARY_ACAD_MLINESTYLE))
       )
      pass ();
    else
      fail ("HEADER.DICTIONARY_ACAD_MLINESTYLE [H]");
  }
  {
    BITCODE_H dictionary_named_object;
    if (dwg_dynapi_header_value (dwg, "DICTIONARY_NAMED_OBJECT", &dictionary_named_object, NULL)
        && !memcmp (&dictionary_named_object, &dwg->header_vars.DICTIONARY_NAMED_OBJECT, sizeof (dwg->header_vars.DICTIONARY_NAMED_OBJECT))
       )
      pass ();
    else
      fail ("HEADER.DICTIONARY_NAMED_OBJECT [H]");
  }
  {
    BITCODE_BS tstackalign;
    if (dwg_dynapi_header_value (dwg, "TSTACKALIGN", &tstackalign, NULL)
        && tstackalign == dwg->header_vars.TSTACKALIGN)
      pass ();
    else
      fail ("HEADER.TSTACKALIGN [BS] %hu != %hu", dwg->header_vars.TSTACKALIGN, tstackalign);
    tstackalign++;
    if (dwg_dynapi_header_set_value (dwg, "TSTACKALIGN", &tstackalign, 0)
        && tstackalign == dwg->header_vars.TSTACKALIGN)
      pass ();
    else
      fail ("HEADER.TSTACKALIGN [BS] set+1 %hu != %hu",
            dwg->header_vars.TSTACKALIGN, tstackalign);
    tstackalign--;
    dwg_dynapi_header_set_value (dwg, "TSTACKALIGN", &tstackalign, 0);

  }
  {
    BITCODE_BS tstacksize;
    if (dwg_dynapi_header_value (dwg, "TSTACKSIZE", &tstacksize, NULL)
        && tstacksize == dwg->header_vars.TSTACKSIZE)
      pass ();
    else
      fail ("HEADER.TSTACKSIZE [BS] %hu != %hu", dwg->header_vars.TSTACKSIZE, tstacksize);
    tstacksize++;
    if (dwg_dynapi_header_set_value (dwg, "TSTACKSIZE", &tstacksize, 0)
        && tstacksize == dwg->header_vars.TSTACKSIZE)
      pass ();
    else
      fail ("HEADER.TSTACKSIZE [BS] set+1 %hu != %hu",
            dwg->header_vars.TSTACKSIZE, tstacksize);
    tstacksize--;
    dwg_dynapi_header_set_value (dwg, "TSTACKSIZE", &tstacksize, 0);

  }
  {
    BITCODE_TV hyperlinkbase;
    if (dwg_dynapi_header_value (dwg, "HYPERLINKBASE", &hyperlinkbase, NULL)
        && !memcmp (&hyperlinkbase, &dwg->header_vars.HYPERLINKBASE, sizeof (dwg->header_vars.HYPERLINKBASE))
       )
      pass ();
    else
      fail ("HEADER.HYPERLINKBASE [TV]");
  }
  {
    BITCODE_TV stylesheet;
    if (dwg_dynapi_header_value (dwg, "STYLESHEET", &stylesheet, NULL)
        && !memcmp (&stylesheet, &dwg->header_vars.STYLESHEET, sizeof (dwg->header_vars.STYLESHEET))
       )
      pass ();
    else
      fail ("HEADER.STYLESHEET [TV]");
  }
  {
    BITCODE_H dictionary_layout;
    if (dwg_dynapi_header_value (dwg, "DICTIONARY_LAYOUT", &dictionary_layout, NULL)
        && !memcmp (&dictionary_layout, &dwg->header_vars.DICTIONARY_LAYOUT, sizeof (dwg->header_vars.DICTIONARY_LAYOUT))
       )
      pass ();
    else
      fail ("HEADER.DICTIONARY_LAYOUT [H]");
  }
  {
    BITCODE_H dictionary_plotsettings;
    if (dwg_dynapi_header_value (dwg, "DICTIONARY_PLOTSETTINGS", &dictionary_plotsettings, NULL)
        && !memcmp (&dictionary_plotsettings, &dwg->header_vars.DICTIONARY_PLOTSETTINGS, sizeof (dwg->header_vars.DICTIONARY_PLOTSETTINGS))
       )
      pass ();
    else
      fail ("HEADER.DICTIONARY_PLOTSETTINGS [H]");
  }
  {
    BITCODE_H dictionary_plotstylename;
    if (dwg_dynapi_header_value (dwg, "DICTIONARY_PLOTSTYLENAME", &dictionary_plotstylename, NULL)
        && !memcmp (&dictionary_plotstylename, &dwg->header_vars.DICTIONARY_PLOTSTYLENAME, sizeof (dwg->header_vars.DICTIONARY_PLOTSTYLENAME))
       )
      pass ();
    else
      fail ("HEADER.DICTIONARY_PLOTSTYLENAME [H]");
  }
  {
    BITCODE_H dictionary_material;
    if (dwg_dynapi_header_value (dwg, "DICTIONARY_MATERIAL", &dictionary_material, NULL)
        && !memcmp (&dictionary_material, &dwg->header_vars.DICTIONARY_MATERIAL, sizeof (dwg->header_vars.DICTIONARY_MATERIAL))
       )
      pass ();
    else
      fail ("HEADER.DICTIONARY_MATERIAL [H]");
  }
  {
    BITCODE_H dictionary_color;
    if (dwg_dynapi_header_value (dwg, "DICTIONARY_COLOR", &dictionary_color, NULL)
        && !memcmp (&dictionary_color, &dwg->header_vars.DICTIONARY_COLOR, sizeof (dwg->header_vars.DICTIONARY_COLOR))
       )
      pass ();
    else
      fail ("HEADER.DICTIONARY_COLOR [H]");
  }
  {
    BITCODE_H dictionary_visualstyle;
    if (dwg_dynapi_header_value (dwg, "DICTIONARY_VISUALSTYLE", &dictionary_visualstyle, NULL)
        && !memcmp (&dictionary_visualstyle, &dwg->header_vars.DICTIONARY_VISUALSTYLE, sizeof (dwg->header_vars.DICTIONARY_VISUALSTYLE))
       )
      pass ();
    else
      fail ("HEADER.DICTIONARY_VISUALSTYLE [H]");
  }
  {
    BITCODE_H dictionary_lightlist;
    if (dwg_dynapi_header_value (dwg, "DICTIONARY_LIGHTLIST", &dictionary_lightlist, NULL)
        && !memcmp (&dictionary_lightlist, &dwg->header_vars.DICTIONARY_LIGHTLIST, sizeof (dwg->header_vars.DICTIONARY_LIGHTLIST))
       )
      pass ();
    else
      fail ("HEADER.DICTIONARY_LIGHTLIST [H]");
  }
  {
    BITCODE_H unknown_20;
    if (dwg_dynapi_header_value (dwg, "unknown_20", &unknown_20, NULL)
        && !memcmp (&unknown_20, &dwg->header_vars.unknown_20, sizeof (dwg->header_vars.unknown_20))
       )
      pass ();
    else
      fail ("HEADER.unknown_20 [H]");
  }
  {
    BITCODE_BL flags;
    if (dwg_dynapi_header_value (dwg, "FLAGS", &flags, NULL)
        && flags == dwg->header_vars.FLAGS)
      pass ();
    else
      fail ("HEADER.FLAGS [BL] %u != %u", dwg->header_vars.FLAGS, flags);
    flags++;
    if (dwg_dynapi_header_set_value (dwg, "FLAGS", &flags, 0)
        && flags == dwg->header_vars.FLAGS)
      pass ();
    else
      fail ("HEADER.FLAGS [BL] set+1 %u != %u",
            dwg->header_vars.FLAGS, flags);
    flags--;
    dwg_dynapi_header_set_value (dwg, "FLAGS", &flags, 0);

  }
  {
    BITCODE_BSd celweight;
    if (dwg_dynapi_header_value (dwg, "CELWEIGHT", &celweight, NULL)
        && celweight == dwg->header_vars.CELWEIGHT)
      pass ();
    else
      fail ("HEADER.CELWEIGHT [BSd] " FORMAT_BSd " != " FORMAT_BSd "", dwg->header_vars.CELWEIGHT, celweight);
    celweight++;
    if (dwg_dynapi_header_set_value (dwg, "CELWEIGHT", &celweight, 0)
        && celweight == dwg->header_vars.CELWEIGHT)
      pass ();
    else
      fail ("HEADER.CELWEIGHT [BSd] set+1 " FORMAT_BSd " != " FORMAT_BSd "",
            dwg->header_vars.CELWEIGHT, celweight);
    celweight--;
    dwg_dynapi_header_set_value (dwg, "CELWEIGHT", &celweight, 0);

  }
  {
    BITCODE_B endcaps;
    if (dwg_dynapi_header_value (dwg, "ENDCAPS", &endcaps, NULL)
        && endcaps == dwg->header_vars.ENDCAPS)
      pass ();
    else
      fail ("HEADER.ENDCAPS [B] " FORMAT_B " != " FORMAT_B "", dwg->header_vars.ENDCAPS, endcaps);
    endcaps++;
    if (dwg_dynapi_header_set_value (dwg, "ENDCAPS", &endcaps, 0)
        && endcaps == dwg->header_vars.ENDCAPS)
      pass ();
    else
      fail ("HEADER.ENDCAPS [B] set+1 " FORMAT_B " != " FORMAT_B "",
            dwg->header_vars.ENDCAPS, endcaps);
    endcaps--;
    dwg_dynapi_header_set_value (dwg, "ENDCAPS", &endcaps, 0);

  }
  {
    BITCODE_B joinstyle;
    if (dwg_dynapi_header_value (dwg, "JOINSTYLE", &joinstyle, NULL)
        && joinstyle == dwg->header_vars.JOINSTYLE)
      pass ();
    else
      fail ("HEADER.JOINSTYLE [B] " FORMAT_B " != " FORMAT_B "", dwg->header_vars.JOINSTYLE, joinstyle);
    joinstyle++;
    if (dwg_dynapi_header_set_value (dwg, "JOINSTYLE", &joinstyle, 0)
        && joinstyle == dwg->header_vars.JOINSTYLE)
      pass ();
    else
      fail ("HEADER.JOINSTYLE [B] set+1 " FORMAT_B " != " FORMAT_B "",
            dwg->header_vars.JOINSTYLE, joinstyle);
    joinstyle--;
    dwg_dynapi_header_set_value (dwg, "JOINSTYLE", &joinstyle, 0);

  }
  {
    BITCODE_B lwdisplay;
    if (dwg_dynapi_header_value (dwg, "LWDISPLAY", &lwdisplay, NULL)
        && lwdisplay == dwg->header_vars.LWDISPLAY)
      pass ();
    else
      fail ("HEADER.LWDISPLAY [B] " FORMAT_B " != " FORMAT_B "", dwg->header_vars.LWDISPLAY, lwdisplay);
    lwdisplay++;
    if (dwg_dynapi_header_set_value (dwg, "LWDISPLAY", &lwdisplay, 0)
        && lwdisplay == dwg->header_vars.LWDISPLAY)
      pass ();
    else
      fail ("HEADER.LWDISPLAY [B] set+1 " FORMAT_B " != " FORMAT_B "",
            dwg->header_vars.LWDISPLAY, lwdisplay);
    lwdisplay--;
    dwg_dynapi_header_set_value (dwg, "LWDISPLAY", &lwdisplay, 0);

  }
  {
    BITCODE_B xedit;
    if (dwg_dynapi_header_value (dwg, "XEDIT", &xedit, NULL)
        && xedit == dwg->header_vars.XEDIT)
      pass ();
    else
      fail ("HEADER.XEDIT [B] " FORMAT_B " != " FORMAT_B "", dwg->header_vars.XEDIT, xedit);
    xedit++;
    if (dwg_dynapi_header_set_value (dwg, "XEDIT", &xedit, 0)
        && xedit == dwg->header_vars.XEDIT)
      pass ();
    else
      fail ("HEADER.XEDIT [B] set+1 " FORMAT_B " != " FORMAT_B "",
            dwg->header_vars.XEDIT, xedit);
    xedit--;
    dwg_dynapi_header_set_value (dwg, "XEDIT", &xedit, 0);

  }
  {
    BITCODE_B extnames;
    if (dwg_dynapi_header_value (dwg, "EXTNAMES", &extnames, NULL)
        && extnames == dwg->header_vars.EXTNAMES)
      pass ();
    else
      fail ("HEADER.EXTNAMES [B] " FORMAT_B " != " FORMAT_B "", dwg->header_vars.EXTNAMES, extnames);
    extnames++;
    if (dwg_dynapi_header_set_value (dwg, "EXTNAMES", &extnames, 0)
        && extnames == dwg->header_vars.EXTNAMES)
      pass ();
    else
      fail ("HEADER.EXTNAMES [B] set+1 " FORMAT_B " != " FORMAT_B "",
            dwg->header_vars.EXTNAMES, extnames);
    extnames--;
    dwg_dynapi_header_set_value (dwg, "EXTNAMES", &extnames, 0);

  }
  {
    BITCODE_B pstylemode;
    if (dwg_dynapi_header_value (dwg, "PSTYLEMODE", &pstylemode, NULL)
        && pstylemode == dwg->header_vars.PSTYLEMODE)
      pass ();
    else
      fail ("HEADER.PSTYLEMODE [B] " FORMAT_B " != " FORMAT_B "", dwg->header_vars.PSTYLEMODE, pstylemode);
    pstylemode++;
    if (dwg_dynapi_header_set_value (dwg, "PSTYLEMODE", &pstylemode, 0)
        && pstylemode == dwg->header_vars.PSTYLEMODE)
      pass ();
    else
      fail ("HEADER.PSTYLEMODE [B] set+1 " FORMAT_B " != " FORMAT_B "",
            dwg->header_vars.PSTYLEMODE, pstylemode);
    pstylemode--;
    dwg_dynapi_header_set_value (dwg, "PSTYLEMODE", &pstylemode, 0);

  }
  {
    BITCODE_B olestartup;
    if (dwg_dynapi_header_value (dwg, "OLESTARTUP", &olestartup, NULL)
        && olestartup == dwg->header_vars.OLESTARTUP)
      pass ();
    else
      fail ("HEADER.OLESTARTUP [B] " FORMAT_B " != " FORMAT_B "", dwg->header_vars.OLESTARTUP, olestartup);
    olestartup++;
    if (dwg_dynapi_header_set_value (dwg, "OLESTARTUP", &olestartup, 0)
        && olestartup == dwg->header_vars.OLESTARTUP)
      pass ();
    else
      fail ("HEADER.OLESTARTUP [B] set+1 " FORMAT_B " != " FORMAT_B "",
            dwg->header_vars.OLESTARTUP, olestartup);
    olestartup--;
    dwg_dynapi_header_set_value (dwg, "OLESTARTUP", &olestartup, 0);

  }
  {
    BITCODE_BS insunits;
    if (dwg_dynapi_header_value (dwg, "INSUNITS", &insunits, NULL)
        && insunits == dwg->header_vars.INSUNITS)
      pass ();
    else
      fail ("HEADER.INSUNITS [BS] %hu != %hu", dwg->header_vars.INSUNITS, insunits);
    insunits++;
    if (dwg_dynapi_header_set_value (dwg, "INSUNITS", &insunits, 0)
        && insunits == dwg->header_vars.INSUNITS)
      pass ();
    else
      fail ("HEADER.INSUNITS [BS] set+1 %hu != %hu",
            dwg->header_vars.INSUNITS, insunits);
    insunits--;
    dwg_dynapi_header_set_value (dwg, "INSUNITS", &insunits, 0);

  }
  {
    BITCODE_BS cepsntype;
    if (dwg_dynapi_header_value (dwg, "CEPSNTYPE", &cepsntype, NULL)
        && cepsntype == dwg->header_vars.CEPSNTYPE)
      pass ();
    else
      fail ("HEADER.CEPSNTYPE [BS] %hu != %hu", dwg->header_vars.CEPSNTYPE, cepsntype);
    cepsntype++;
    if (dwg_dynapi_header_set_value (dwg, "CEPSNTYPE", &cepsntype, 0)
        && cepsntype == dwg->header_vars.CEPSNTYPE)
      pass ();
    else
      fail ("HEADER.CEPSNTYPE [BS] set+1 %hu != %hu",
            dwg->header_vars.CEPSNTYPE, cepsntype);
    cepsntype--;
    dwg_dynapi_header_set_value (dwg, "CEPSNTYPE", &cepsntype, 0);

  }
  {
    BITCODE_H cpsnid;
    if (dwg_dynapi_header_value (dwg, "CPSNID", &cpsnid, NULL)
        && !memcmp (&cpsnid, &dwg->header_vars.CPSNID, sizeof (dwg->header_vars.CPSNID))
       )
      pass ();
    else
      fail ("HEADER.CPSNID [H]");
  }
  {
    BITCODE_TV fingerprintguid;
    if (dwg_dynapi_header_value (dwg, "FINGERPRINTGUID", &fingerprintguid, NULL)
        && !memcmp (&fingerprintguid, &dwg->header_vars.FINGERPRINTGUID, sizeof (dwg->header_vars.FINGERPRINTGUID))
       )
      pass ();
    else
      fail ("HEADER.FINGERPRINTGUID [TV]");
  }
  {
    BITCODE_TV versionguid;
    if (dwg_dynapi_header_value (dwg, "VERSIONGUID", &versionguid, NULL)
        && !memcmp (&versionguid, &dwg->header_vars.VERSIONGUID, sizeof (dwg->header_vars.VERSIONGUID))
       )
      pass ();
    else
      fail ("HEADER.VERSIONGUID [TV]");
  }
  {
    BITCODE_RC sortents;
    if (dwg_dynapi_header_value (dwg, "SORTENTS", &sortents, NULL)
        && sortents == dwg->header_vars.SORTENTS)
      pass ();
    else
      fail ("HEADER.SORTENTS [RC] %u != %u", dwg->header_vars.SORTENTS, sortents);
    sortents++;
    if (dwg_dynapi_header_set_value (dwg, "SORTENTS", &sortents, 0)
        && sortents == dwg->header_vars.SORTENTS)
      pass ();
    else
      fail ("HEADER.SORTENTS [RC] set+1 %u != %u",
            dwg->header_vars.SORTENTS, sortents);
    sortents--;
    dwg_dynapi_header_set_value (dwg, "SORTENTS", &sortents, 0);

  }
  {
    BITCODE_RC indexctl;
    if (dwg_dynapi_header_value (dwg, "INDEXCTL", &indexctl, NULL)
        && indexctl == dwg->header_vars.INDEXCTL)
      pass ();
    else
      fail ("HEADER.INDEXCTL [RC] %u != %u", dwg->header_vars.INDEXCTL, indexctl);
    indexctl++;
    if (dwg_dynapi_header_set_value (dwg, "INDEXCTL", &indexctl, 0)
        && indexctl == dwg->header_vars.INDEXCTL)
      pass ();
    else
      fail ("HEADER.INDEXCTL [RC] set+1 %u != %u",
            dwg->header_vars.INDEXCTL, indexctl);
    indexctl--;
    dwg_dynapi_header_set_value (dwg, "INDEXCTL", &indexctl, 0);

  }
  {
    BITCODE_RC hidetext;
    if (dwg_dynapi_header_value (dwg, "HIDETEXT", &hidetext, NULL)
        && hidetext == dwg->header_vars.HIDETEXT)
      pass ();
    else
      fail ("HEADER.HIDETEXT [RC] %u != %u", dwg->header_vars.HIDETEXT, hidetext);
    hidetext++;
    if (dwg_dynapi_header_set_value (dwg, "HIDETEXT", &hidetext, 0)
        && hidetext == dwg->header_vars.HIDETEXT)
      pass ();
    else
      fail ("HEADER.HIDETEXT [RC] set+1 %u != %u",
            dwg->header_vars.HIDETEXT, hidetext);
    hidetext--;
    dwg_dynapi_header_set_value (dwg, "HIDETEXT", &hidetext, 0);

  }
  {
    BITCODE_RC xclipframe;
    if (dwg_dynapi_header_value (dwg, "XCLIPFRAME", &xclipframe, NULL)
        && xclipframe == dwg->header_vars.XCLIPFRAME)
      pass ();
    else
      fail ("HEADER.XCLIPFRAME [RC] %u != %u", dwg->header_vars.XCLIPFRAME, xclipframe);
    xclipframe++;
    if (dwg_dynapi_header_set_value (dwg, "XCLIPFRAME", &xclipframe, 0)
        && xclipframe == dwg->header_vars.XCLIPFRAME)
      pass ();
    else
      fail ("HEADER.XCLIPFRAME [RC] set+1 %u != %u",
            dwg->header_vars.XCLIPFRAME, xclipframe);
    xclipframe--;
    dwg_dynapi_header_set_value (dwg, "XCLIPFRAME", &xclipframe, 0);

  }
  {
    BITCODE_RC dimassoc;
    if (dwg_dynapi_header_value (dwg, "DIMASSOC", &dimassoc, NULL)
        && dimassoc == dwg->header_vars.DIMASSOC)
      pass ();
    else
      fail ("HEADER.DIMASSOC [RC] %u != %u", dwg->header_vars.DIMASSOC, dimassoc);
    dimassoc++;
    if (dwg_dynapi_header_set_value (dwg, "DIMASSOC", &dimassoc, 0)
        && dimassoc == dwg->header_vars.DIMASSOC)
      pass ();
    else
      fail ("HEADER.DIMASSOC [RC] set+1 %u != %u",
            dwg->header_vars.DIMASSOC, dimassoc);
    dimassoc--;
    dwg_dynapi_header_set_value (dwg, "DIMASSOC", &dimassoc, 0);

  }
  {
    BITCODE_RC halogap;
    if (dwg_dynapi_header_value (dwg, "HALOGAP", &halogap, NULL)
        && halogap == dwg->header_vars.HALOGAP)
      pass ();
    else
      fail ("HEADER.HALOGAP [RC] %u != %u", dwg->header_vars.HALOGAP, halogap);
    halogap++;
    if (dwg_dynapi_header_set_value (dwg, "HALOGAP", &halogap, 0)
        && halogap == dwg->header_vars.HALOGAP)
      pass ();
    else
      fail ("HEADER.HALOGAP [RC] set+1 %u != %u",
            dwg->header_vars.HALOGAP, halogap);
    halogap--;
    dwg_dynapi_header_set_value (dwg, "HALOGAP", &halogap, 0);

  }
  {
    BITCODE_BS obscolor;
    if (dwg_dynapi_header_value (dwg, "OBSCOLOR", &obscolor, NULL)
        && obscolor == dwg->header_vars.OBSCOLOR)
      pass ();
    else
      fail ("HEADER.OBSCOLOR [BS] %hu != %hu", dwg->header_vars.OBSCOLOR, obscolor);
    obscolor++;
    if (dwg_dynapi_header_set_value (dwg, "OBSCOLOR", &obscolor, 0)
        && obscolor == dwg->header_vars.OBSCOLOR)
      pass ();
    else
      fail ("HEADER.OBSCOLOR [BS] set+1 %hu != %hu",
            dwg->header_vars.OBSCOLOR, obscolor);
    obscolor--;
    dwg_dynapi_header_set_value (dwg, "OBSCOLOR", &obscolor, 0);

  }
  {
    BITCODE_BS intersectioncolor;
    if (dwg_dynapi_header_value (dwg, "INTERSECTIONCOLOR", &intersectioncolor, NULL)
        && intersectioncolor == dwg->header_vars.INTERSECTIONCOLOR)
      pass ();
    else
      fail ("HEADER.INTERSECTIONCOLOR [BS] %hu != %hu", dwg->header_vars.INTERSECTIONCOLOR, intersectioncolor);
    intersectioncolor++;
    if (dwg_dynapi_header_set_value (dwg, "INTERSECTIONCOLOR", &intersectioncolor, 0)
        && intersectioncolor == dwg->header_vars.INTERSECTIONCOLOR)
      pass ();
    else
      fail ("HEADER.INTERSECTIONCOLOR [BS] set+1 %hu != %hu",
            dwg->header_vars.INTERSECTIONCOLOR, intersectioncolor);
    intersectioncolor--;
    dwg_dynapi_header_set_value (dwg, "INTERSECTIONCOLOR", &intersectioncolor, 0);

  }
  {
    BITCODE_RC obsltype;
    if (dwg_dynapi_header_value (dwg, "OBSLTYPE", &obsltype, NULL)
        && obsltype == dwg->header_vars.OBSLTYPE)
      pass ();
    else
      fail ("HEADER.OBSLTYPE [RC] %u != %u", dwg->header_vars.OBSLTYPE, obsltype);
    obsltype++;
    if (dwg_dynapi_header_set_value (dwg, "OBSLTYPE", &obsltype, 0)
        && obsltype == dwg->header_vars.OBSLTYPE)
      pass ();
    else
      fail ("HEADER.OBSLTYPE [RC] set+1 %u != %u",
            dwg->header_vars.OBSLTYPE, obsltype);
    obsltype--;
    dwg_dynapi_header_set_value (dwg, "OBSLTYPE", &obsltype, 0);

  }
  {
    BITCODE_RC intersectiondisplay;
    if (dwg_dynapi_header_value (dwg, "INTERSECTIONDISPLAY", &intersectiondisplay, NULL)
        && intersectiondisplay == dwg->header_vars.INTERSECTIONDISPLAY)
      pass ();
    else
      fail ("HEADER.INTERSECTIONDISPLAY [RC] %u != %u", dwg->header_vars.INTERSECTIONDISPLAY, intersectiondisplay);
    intersectiondisplay++;
    if (dwg_dynapi_header_set_value (dwg, "INTERSECTIONDISPLAY", &intersectiondisplay, 0)
        && intersectiondisplay == dwg->header_vars.INTERSECTIONDISPLAY)
      pass ();
    else
      fail ("HEADER.INTERSECTIONDISPLAY [RC] set+1 %u != %u",
            dwg->header_vars.INTERSECTIONDISPLAY, intersectiondisplay);
    intersectiondisplay--;
    dwg_dynapi_header_set_value (dwg, "INTERSECTIONDISPLAY", &intersectiondisplay, 0);

  }
  {
    BITCODE_TV projectname;
    if (dwg_dynapi_header_value (dwg, "PROJECTNAME", &projectname, NULL)
        && !memcmp (&projectname, &dwg->header_vars.PROJECTNAME, sizeof (dwg->header_vars.PROJECTNAME))
       )
      pass ();
    else
      fail ("HEADER.PROJECTNAME [TV]");
  }
  {
    BITCODE_H block_record_pspace;
    if (dwg_dynapi_header_value (dwg, "BLOCK_RECORD_PSPACE", &block_record_pspace, NULL)
        && !memcmp (&block_record_pspace, &dwg->header_vars.BLOCK_RECORD_PSPACE, sizeof (dwg->header_vars.BLOCK_RECORD_PSPACE))
       )
      pass ();
    else
      fail ("HEADER.BLOCK_RECORD_PSPACE [H]");
  }
  {
    BITCODE_H block_record_mspace;
    if (dwg_dynapi_header_value (dwg, "BLOCK_RECORD_MSPACE", &block_record_mspace, NULL)
        && !memcmp (&block_record_mspace, &dwg->header_vars.BLOCK_RECORD_MSPACE, sizeof (dwg->header_vars.BLOCK_RECORD_MSPACE))
       )
      pass ();
    else
      fail ("HEADER.BLOCK_RECORD_MSPACE [H]");
  }
  {
    BITCODE_H ltype_bylayer;
    if (dwg_dynapi_header_value (dwg, "LTYPE_BYLAYER", &ltype_bylayer, NULL)
        && !memcmp (&ltype_bylayer, &dwg->header_vars.LTYPE_BYLAYER, sizeof (dwg->header_vars.LTYPE_BYLAYER))
       )
      pass ();
    else
      fail ("HEADER.LTYPE_BYLAYER [H]");
  }
  {
    BITCODE_H ltype_byblock;
    if (dwg_dynapi_header_value (dwg, "LTYPE_BYBLOCK", &ltype_byblock, NULL)
        && !memcmp (&ltype_byblock, &dwg->header_vars.LTYPE_BYBLOCK, sizeof (dwg->header_vars.LTYPE_BYBLOCK))
       )
      pass ();
    else
      fail ("HEADER.LTYPE_BYBLOCK [H]");
  }
  {
    BITCODE_H ltype_continuous;
    if (dwg_dynapi_header_value (dwg, "LTYPE_CONTINUOUS", &ltype_continuous, NULL)
        && !memcmp (&ltype_continuous, &dwg->header_vars.LTYPE_CONTINUOUS, sizeof (dwg->header_vars.LTYPE_CONTINUOUS))
       )
      pass ();
    else
      fail ("HEADER.LTYPE_CONTINUOUS [H]");
  }
  {
    BITCODE_B cameradisplay;
    if (dwg_dynapi_header_value (dwg, "CAMERADISPLAY", &cameradisplay, NULL)
        && cameradisplay == dwg->header_vars.CAMERADISPLAY)
      pass ();
    else
      fail ("HEADER.CAMERADISPLAY [B] " FORMAT_B " != " FORMAT_B "", dwg->header_vars.CAMERADISPLAY, cameradisplay);
    cameradisplay++;
    if (dwg_dynapi_header_set_value (dwg, "CAMERADISPLAY", &cameradisplay, 0)
        && cameradisplay == dwg->header_vars.CAMERADISPLAY)
      pass ();
    else
      fail ("HEADER.CAMERADISPLAY [B] set+1 " FORMAT_B " != " FORMAT_B "",
            dwg->header_vars.CAMERADISPLAY, cameradisplay);
    cameradisplay--;
    dwg_dynapi_header_set_value (dwg, "CAMERADISPLAY", &cameradisplay, 0);

  }
  {
    BITCODE_BL unknown_21;
    if (dwg_dynapi_header_value (dwg, "unknown_21", &unknown_21, NULL)
        && unknown_21 == dwg->header_vars.unknown_21)
      pass ();
    else
      fail ("HEADER.unknown_21 [BL] %u != %u", dwg->header_vars.unknown_21, unknown_21);
    unknown_21++;
    if (dwg_dynapi_header_set_value (dwg, "unknown_21", &unknown_21, 0)
        && unknown_21 == dwg->header_vars.unknown_21)
      pass ();
    else
      fail ("HEADER.unknown_21 [BL] set+1 %u != %u",
            dwg->header_vars.unknown_21, unknown_21);
    unknown_21--;
    dwg_dynapi_header_set_value (dwg, "unknown_21", &unknown_21, 0);

  }
  {
    BITCODE_BL unknown_22;
    if (dwg_dynapi_header_value (dwg, "unknown_22", &unknown_22, NULL)
        && unknown_22 == dwg->header_vars.unknown_22)
      pass ();
    else
      fail ("HEADER.unknown_22 [BL] %u != %u", dwg->header_vars.unknown_22, unknown_22);
    unknown_22++;
    if (dwg_dynapi_header_set_value (dwg, "unknown_22", &unknown_22, 0)
        && unknown_22 == dwg->header_vars.unknown_22)
      pass ();
    else
      fail ("HEADER.unknown_22 [BL] set+1 %u != %u",
            dwg->header_vars.unknown_22, unknown_22);
    unknown_22--;
    dwg_dynapi_header_set_value (dwg, "unknown_22", &unknown_22, 0);

  }
  {
    BITCODE_BD unknown_23;
    if (dwg_dynapi_header_value (dwg, "unknown_23", &unknown_23, NULL)
        && unknown_23 == dwg->header_vars.unknown_23)
      pass ();
    else
      fail ("HEADER.unknown_23 [BD] %g != %g", dwg->header_vars.unknown_23, unknown_23);
    unknown_23++;
    if (dwg_dynapi_header_set_value (dwg, "unknown_23", &unknown_23, 0)
        && unknown_23 == dwg->header_vars.unknown_23)
      pass ();
    else
      fail ("HEADER.unknown_23 [BD] set+1 %g != %g",
            dwg->header_vars.unknown_23, unknown_23);
    unknown_23--;
    dwg_dynapi_header_set_value (dwg, "unknown_23", &unknown_23, 0);

  }
  {
    BITCODE_BD stepspersec;
    if (dwg_dynapi_header_value (dwg, "STEPSPERSEC", &stepspersec, NULL)
        && stepspersec == dwg->header_vars.STEPSPERSEC)
      pass ();
    else
      fail ("HEADER.STEPSPERSEC [BD] %g != %g", dwg->header_vars.STEPSPERSEC, stepspersec);
    stepspersec++;
    if (dwg_dynapi_header_set_value (dwg, "STEPSPERSEC", &stepspersec, 0)
        && stepspersec == dwg->header_vars.STEPSPERSEC)
      pass ();
    else
      fail ("HEADER.STEPSPERSEC [BD] set+1 %g != %g",
            dwg->header_vars.STEPSPERSEC, stepspersec);
    stepspersec--;
    dwg_dynapi_header_set_value (dwg, "STEPSPERSEC", &stepspersec, 0);

  }
  {
    BITCODE_BD stepsize;
    if (dwg_dynapi_header_value (dwg, "STEPSIZE", &stepsize, NULL)
        && stepsize == dwg->header_vars.STEPSIZE)
      pass ();
    else
      fail ("HEADER.STEPSIZE [BD] %g != %g", dwg->header_vars.STEPSIZE, stepsize);
    stepsize++;
    if (dwg_dynapi_header_set_value (dwg, "STEPSIZE", &stepsize, 0)
        && stepsize == dwg->header_vars.STEPSIZE)
      pass ();
    else
      fail ("HEADER.STEPSIZE [BD] set+1 %g != %g",
            dwg->header_vars.STEPSIZE, stepsize);
    stepsize--;
    dwg_dynapi_header_set_value (dwg, "STEPSIZE", &stepsize, 0);

  }
  {
    BITCODE_BD _3ddwfprec;
    if (dwg_dynapi_header_value (dwg, "_3DDWFPREC", &_3ddwfprec, NULL)
        && _3ddwfprec == dwg->header_vars._3DDWFPREC)
      pass ();
    else
      fail ("HEADER._3DDWFPREC [BD] %g != %g", dwg->header_vars._3DDWFPREC, _3ddwfprec);
    _3ddwfprec++;
    if (dwg_dynapi_header_set_value (dwg, "_3DDWFPREC", &_3ddwfprec, 0)
        && _3ddwfprec == dwg->header_vars._3DDWFPREC)
      pass ();
    else
      fail ("HEADER._3DDWFPREC [BD] set+1 %g != %g",
            dwg->header_vars._3DDWFPREC, _3ddwfprec);
    _3ddwfprec--;
    dwg_dynapi_header_set_value (dwg, "_3DDWFPREC", &_3ddwfprec, 0);

  }
  {
    BITCODE_BD lenslength;
    if (dwg_dynapi_header_value (dwg, "LENSLENGTH", &lenslength, NULL)
        && lenslength == dwg->header_vars.LENSLENGTH)
      pass ();
    else
      fail ("HEADER.LENSLENGTH [BD] %g != %g", dwg->header_vars.LENSLENGTH, lenslength);
    lenslength++;
    if (dwg_dynapi_header_set_value (dwg, "LENSLENGTH", &lenslength, 0)
        && lenslength == dwg->header_vars.LENSLENGTH)
      pass ();
    else
      fail ("HEADER.LENSLENGTH [BD] set+1 %g != %g",
            dwg->header_vars.LENSLENGTH, lenslength);
    lenslength--;
    dwg_dynapi_header_set_value (dwg, "LENSLENGTH", &lenslength, 0);

  }
  {
    BITCODE_BD cameraheight;
    if (dwg_dynapi_header_value (dwg, "CAMERAHEIGHT", &cameraheight, NULL)
        && cameraheight == dwg->header_vars.CAMERAHEIGHT)
      pass ();
    else
      fail ("HEADER.CAMERAHEIGHT [BD] %g != %g", dwg->header_vars.CAMERAHEIGHT, cameraheight);
    cameraheight++;
    if (dwg_dynapi_header_set_value (dwg, "CAMERAHEIGHT", &cameraheight, 0)
        && cameraheight == dwg->header_vars.CAMERAHEIGHT)
      pass ();
    else
      fail ("HEADER.CAMERAHEIGHT [BD] set+1 %g != %g",
            dwg->header_vars.CAMERAHEIGHT, cameraheight);
    cameraheight--;
    dwg_dynapi_header_set_value (dwg, "CAMERAHEIGHT", &cameraheight, 0);

  }
  {
    BITCODE_RC solidhist;
    if (dwg_dynapi_header_value (dwg, "SOLIDHIST", &solidhist, NULL)
        && solidhist == dwg->header_vars.SOLIDHIST)
      pass ();
    else
      fail ("HEADER.SOLIDHIST [RC] %u != %u", dwg->header_vars.SOLIDHIST, solidhist);
    solidhist++;
    if (dwg_dynapi_header_set_value (dwg, "SOLIDHIST", &solidhist, 0)
        && solidhist == dwg->header_vars.SOLIDHIST)
      pass ();
    else
      fail ("HEADER.SOLIDHIST [RC] set+1 %u != %u",
            dwg->header_vars.SOLIDHIST, solidhist);
    solidhist--;
    dwg_dynapi_header_set_value (dwg, "SOLIDHIST", &solidhist, 0);

  }
  {
    BITCODE_RC showhist;
    if (dwg_dynapi_header_value (dwg, "SHOWHIST", &showhist, NULL)
        && showhist == dwg->header_vars.SHOWHIST)
      pass ();
    else
      fail ("HEADER.SHOWHIST [RC] %u != %u", dwg->header_vars.SHOWHIST, showhist);
    showhist++;
    if (dwg_dynapi_header_set_value (dwg, "SHOWHIST", &showhist, 0)
        && showhist == dwg->header_vars.SHOWHIST)
      pass ();
    else
      fail ("HEADER.SHOWHIST [RC] set+1 %u != %u",
            dwg->header_vars.SHOWHIST, showhist);
    showhist--;
    dwg_dynapi_header_set_value (dwg, "SHOWHIST", &showhist, 0);

  }
  {
    BITCODE_BD psolwidth;
    if (dwg_dynapi_header_value (dwg, "PSOLWIDTH", &psolwidth, NULL)
        && psolwidth == dwg->header_vars.PSOLWIDTH)
      pass ();
    else
      fail ("HEADER.PSOLWIDTH [BD] %g != %g", dwg->header_vars.PSOLWIDTH, psolwidth);
    psolwidth++;
    if (dwg_dynapi_header_set_value (dwg, "PSOLWIDTH", &psolwidth, 0)
        && psolwidth == dwg->header_vars.PSOLWIDTH)
      pass ();
    else
      fail ("HEADER.PSOLWIDTH [BD] set+1 %g != %g",
            dwg->header_vars.PSOLWIDTH, psolwidth);
    psolwidth--;
    dwg_dynapi_header_set_value (dwg, "PSOLWIDTH", &psolwidth, 0);

  }
  {
    BITCODE_BD psolheight;
    if (dwg_dynapi_header_value (dwg, "PSOLHEIGHT", &psolheight, NULL)
        && psolheight == dwg->header_vars.PSOLHEIGHT)
      pass ();
    else
      fail ("HEADER.PSOLHEIGHT [BD] %g != %g", dwg->header_vars.PSOLHEIGHT, psolheight);
    psolheight++;
    if (dwg_dynapi_header_set_value (dwg, "PSOLHEIGHT", &psolheight, 0)
        && psolheight == dwg->header_vars.PSOLHEIGHT)
      pass ();
    else
      fail ("HEADER.PSOLHEIGHT [BD] set+1 %g != %g",
            dwg->header_vars.PSOLHEIGHT, psolheight);
    psolheight--;
    dwg_dynapi_header_set_value (dwg, "PSOLHEIGHT", &psolheight, 0);

  }
  {
    BITCODE_BD loftang1;
    if (dwg_dynapi_header_value (dwg, "LOFTANG1", &loftang1, NULL)
        && loftang1 == dwg->header_vars.LOFTANG1)
      pass ();
    else
      fail ("HEADER.LOFTANG1 [BD] %g != %g", dwg->header_vars.LOFTANG1, loftang1);
    loftang1++;
    if (dwg_dynapi_header_set_value (dwg, "LOFTANG1", &loftang1, 0)
        && loftang1 == dwg->header_vars.LOFTANG1)
      pass ();
    else
      fail ("HEADER.LOFTANG1 [BD] set+1 %g != %g",
            dwg->header_vars.LOFTANG1, loftang1);
    loftang1--;
    dwg_dynapi_header_set_value (dwg, "LOFTANG1", &loftang1, 0);

  }
  {
    BITCODE_BD loftang2;
    if (dwg_dynapi_header_value (dwg, "LOFTANG2", &loftang2, NULL)
        && loftang2 == dwg->header_vars.LOFTANG2)
      pass ();
    else
      fail ("HEADER.LOFTANG2 [BD] %g != %g", dwg->header_vars.LOFTANG2, loftang2);
    loftang2++;
    if (dwg_dynapi_header_set_value (dwg, "LOFTANG2", &loftang2, 0)
        && loftang2 == dwg->header_vars.LOFTANG2)
      pass ();
    else
      fail ("HEADER.LOFTANG2 [BD] set+1 %g != %g",
            dwg->header_vars.LOFTANG2, loftang2);
    loftang2--;
    dwg_dynapi_header_set_value (dwg, "LOFTANG2", &loftang2, 0);

  }
  {
    BITCODE_BD loftmag1;
    if (dwg_dynapi_header_value (dwg, "LOFTMAG1", &loftmag1, NULL)
        && loftmag1 == dwg->header_vars.LOFTMAG1)
      pass ();
    else
      fail ("HEADER.LOFTMAG1 [BD] %g != %g", dwg->header_vars.LOFTMAG1, loftmag1);
    loftmag1++;
    if (dwg_dynapi_header_set_value (dwg, "LOFTMAG1", &loftmag1, 0)
        && loftmag1 == dwg->header_vars.LOFTMAG1)
      pass ();
    else
      fail ("HEADER.LOFTMAG1 [BD] set+1 %g != %g",
            dwg->header_vars.LOFTMAG1, loftmag1);
    loftmag1--;
    dwg_dynapi_header_set_value (dwg, "LOFTMAG1", &loftmag1, 0);

  }
  {
    BITCODE_BD loftmag2;
    if (dwg_dynapi_header_value (dwg, "LOFTMAG2", &loftmag2, NULL)
        && loftmag2 == dwg->header_vars.LOFTMAG2)
      pass ();
    else
      fail ("HEADER.LOFTMAG2 [BD] %g != %g", dwg->header_vars.LOFTMAG2, loftmag2);
    loftmag2++;
    if (dwg_dynapi_header_set_value (dwg, "LOFTMAG2", &loftmag2, 0)
        && loftmag2 == dwg->header_vars.LOFTMAG2)
      pass ();
    else
      fail ("HEADER.LOFTMAG2 [BD] set+1 %g != %g",
            dwg->header_vars.LOFTMAG2, loftmag2);
    loftmag2--;
    dwg_dynapi_header_set_value (dwg, "LOFTMAG2", &loftmag2, 0);

  }
  {
    BITCODE_BS loftparam;
    if (dwg_dynapi_header_value (dwg, "LOFTPARAM", &loftparam, NULL)
        && loftparam == dwg->header_vars.LOFTPARAM)
      pass ();
    else
      fail ("HEADER.LOFTPARAM [BS] %hu != %hu", dwg->header_vars.LOFTPARAM, loftparam);
    loftparam++;
    if (dwg_dynapi_header_set_value (dwg, "LOFTPARAM", &loftparam, 0)
        && loftparam == dwg->header_vars.LOFTPARAM)
      pass ();
    else
      fail ("HEADER.LOFTPARAM [BS] set+1 %hu != %hu",
            dwg->header_vars.LOFTPARAM, loftparam);
    loftparam--;
    dwg_dynapi_header_set_value (dwg, "LOFTPARAM", &loftparam, 0);

  }
  {
    BITCODE_RC loftnormals;
    if (dwg_dynapi_header_value (dwg, "LOFTNORMALS", &loftnormals, NULL)
        && loftnormals == dwg->header_vars.LOFTNORMALS)
      pass ();
    else
      fail ("HEADER.LOFTNORMALS [RC] %u != %u", dwg->header_vars.LOFTNORMALS, loftnormals);
    loftnormals++;
    if (dwg_dynapi_header_set_value (dwg, "LOFTNORMALS", &loftnormals, 0)
        && loftnormals == dwg->header_vars.LOFTNORMALS)
      pass ();
    else
      fail ("HEADER.LOFTNORMALS [RC] set+1 %u != %u",
            dwg->header_vars.LOFTNORMALS, loftnormals);
    loftnormals--;
    dwg_dynapi_header_set_value (dwg, "LOFTNORMALS", &loftnormals, 0);

  }
  {
    BITCODE_BD latitude;
    if (dwg_dynapi_header_value (dwg, "LATITUDE", &latitude, NULL)
        && latitude == dwg->header_vars.LATITUDE)
      pass ();
    else
      fail ("HEADER.LATITUDE [BD] %g != %g", dwg->header_vars.LATITUDE, latitude);
    latitude++;
    if (dwg_dynapi_header_set_value (dwg, "LATITUDE", &latitude, 0)
        && latitude == dwg->header_vars.LATITUDE)
      pass ();
    else
      fail ("HEADER.LATITUDE [BD] set+1 %g != %g",
            dwg->header_vars.LATITUDE, latitude);
    latitude--;
    dwg_dynapi_header_set_value (dwg, "LATITUDE", &latitude, 0);

  }
  {
    BITCODE_BD longitude;
    if (dwg_dynapi_header_value (dwg, "LONGITUDE", &longitude, NULL)
        && longitude == dwg->header_vars.LONGITUDE)
      pass ();
    else
      fail ("HEADER.LONGITUDE [BD] %g != %g", dwg->header_vars.LONGITUDE, longitude);
    longitude++;
    if (dwg_dynapi_header_set_value (dwg, "LONGITUDE", &longitude, 0)
        && longitude == dwg->header_vars.LONGITUDE)
      pass ();
    else
      fail ("HEADER.LONGITUDE [BD] set+1 %g != %g",
            dwg->header_vars.LONGITUDE, longitude);
    longitude--;
    dwg_dynapi_header_set_value (dwg, "LONGITUDE", &longitude, 0);

  }
  {
    BITCODE_BD northdirection;
    if (dwg_dynapi_header_value (dwg, "NORTHDIRECTION", &northdirection, NULL)
        && northdirection == dwg->header_vars.NORTHDIRECTION)
      pass ();
    else
      fail ("HEADER.NORTHDIRECTION [BD] %g != %g", dwg->header_vars.NORTHDIRECTION, northdirection);
    northdirection++;
    if (dwg_dynapi_header_set_value (dwg, "NORTHDIRECTION", &northdirection, 0)
        && northdirection == dwg->header_vars.NORTHDIRECTION)
      pass ();
    else
      fail ("HEADER.NORTHDIRECTION [BD] set+1 %g != %g",
            dwg->header_vars.NORTHDIRECTION, northdirection);
    northdirection--;
    dwg_dynapi_header_set_value (dwg, "NORTHDIRECTION", &northdirection, 0);

  }
  {
    BITCODE_BL timezone;
    if (dwg_dynapi_header_value (dwg, "TIMEZONE", &timezone, NULL)
        && timezone == dwg->header_vars.TIMEZONE)
      pass ();
    else
      fail ("HEADER.TIMEZONE [BL] %u != %u", dwg->header_vars.TIMEZONE, timezone);
    timezone++;
    if (dwg_dynapi_header_set_value (dwg, "TIMEZONE", &timezone, 0)
        && timezone == dwg->header_vars.TIMEZONE)
      pass ();
    else
      fail ("HEADER.TIMEZONE [BL] set+1 %u != %u",
            dwg->header_vars.TIMEZONE, timezone);
    timezone--;
    dwg_dynapi_header_set_value (dwg, "TIMEZONE", &timezone, 0);

  }
  {
    BITCODE_RC lightglyphdisplay;
    if (dwg_dynapi_header_value (dwg, "LIGHTGLYPHDISPLAY", &lightglyphdisplay, NULL)
        && lightglyphdisplay == dwg->header_vars.LIGHTGLYPHDISPLAY)
      pass ();
    else
      fail ("HEADER.LIGHTGLYPHDISPLAY [RC] %u != %u", dwg->header_vars.LIGHTGLYPHDISPLAY, lightglyphdisplay);
    lightglyphdisplay++;
    if (dwg_dynapi_header_set_value (dwg, "LIGHTGLYPHDISPLAY", &lightglyphdisplay, 0)
        && lightglyphdisplay == dwg->header_vars.LIGHTGLYPHDISPLAY)
      pass ();
    else
      fail ("HEADER.LIGHTGLYPHDISPLAY [RC] set+1 %u != %u",
            dwg->header_vars.LIGHTGLYPHDISPLAY, lightglyphdisplay);
    lightglyphdisplay--;
    dwg_dynapi_header_set_value (dwg, "LIGHTGLYPHDISPLAY", &lightglyphdisplay, 0);

  }
  {
    BITCODE_RC tilemodelightsynch;
    if (dwg_dynapi_header_value (dwg, "TILEMODELIGHTSYNCH", &tilemodelightsynch, NULL)
        && tilemodelightsynch == dwg->header_vars.TILEMODELIGHTSYNCH)
      pass ();
    else
      fail ("HEADER.TILEMODELIGHTSYNCH [RC] %u != %u", dwg->header_vars.TILEMODELIGHTSYNCH, tilemodelightsynch);
    tilemodelightsynch++;
    if (dwg_dynapi_header_set_value (dwg, "TILEMODELIGHTSYNCH", &tilemodelightsynch, 0)
        && tilemodelightsynch == dwg->header_vars.TILEMODELIGHTSYNCH)
      pass ();
    else
      fail ("HEADER.TILEMODELIGHTSYNCH [RC] set+1 %u != %u",
            dwg->header_vars.TILEMODELIGHTSYNCH, tilemodelightsynch);
    tilemodelightsynch--;
    dwg_dynapi_header_set_value (dwg, "TILEMODELIGHTSYNCH", &tilemodelightsynch, 0);

  }
  {
    BITCODE_RC dwfframe;
    if (dwg_dynapi_header_value (dwg, "DWFFRAME", &dwfframe, NULL)
        && dwfframe == dwg->header_vars.DWFFRAME)
      pass ();
    else
      fail ("HEADER.DWFFRAME [RC] %u != %u", dwg->header_vars.DWFFRAME, dwfframe);
    dwfframe++;
    if (dwg_dynapi_header_set_value (dwg, "DWFFRAME", &dwfframe, 0)
        && dwfframe == dwg->header_vars.DWFFRAME)
      pass ();
    else
      fail ("HEADER.DWFFRAME [RC] set+1 %u != %u",
            dwg->header_vars.DWFFRAME, dwfframe);
    dwfframe--;
    dwg_dynapi_header_set_value (dwg, "DWFFRAME", &dwfframe, 0);

  }
  {
    BITCODE_RC dgnframe;
    if (dwg_dynapi_header_value (dwg, "DGNFRAME", &dgnframe, NULL)
        && dgnframe == dwg->header_vars.DGNFRAME)
      pass ();
    else
      fail ("HEADER.DGNFRAME [RC] %u != %u", dwg->header_vars.DGNFRAME, dgnframe);
    dgnframe++;
    if (dwg_dynapi_header_set_value (dwg, "DGNFRAME", &dgnframe, 0)
        && dgnframe == dwg->header_vars.DGNFRAME)
      pass ();
    else
      fail ("HEADER.DGNFRAME [RC] set+1 %u != %u",
            dwg->header_vars.DGNFRAME, dgnframe);
    dgnframe--;
    dwg_dynapi_header_set_value (dwg, "DGNFRAME", &dgnframe, 0);

  }
  {
    BITCODE_B realworldscale;
    if (dwg_dynapi_header_value (dwg, "REALWORLDSCALE", &realworldscale, NULL)
        && realworldscale == dwg->header_vars.REALWORLDSCALE)
      pass ();
    else
      fail ("HEADER.REALWORLDSCALE [B] " FORMAT_B " != " FORMAT_B "", dwg->header_vars.REALWORLDSCALE, realworldscale);
    realworldscale++;
    if (dwg_dynapi_header_set_value (dwg, "REALWORLDSCALE", &realworldscale, 0)
        && realworldscale == dwg->header_vars.REALWORLDSCALE)
      pass ();
    else
      fail ("HEADER.REALWORLDSCALE [B] set+1 " FORMAT_B " != " FORMAT_B "",
            dwg->header_vars.REALWORLDSCALE, realworldscale);
    realworldscale--;
    dwg_dynapi_header_set_value (dwg, "REALWORLDSCALE", &realworldscale, 0);

  }
  {
    BITCODE_CMC interferecolor;
    if (dwg_dynapi_header_value (dwg, "INTERFERECOLOR", &interferecolor, NULL)
        && !memcmp (&interferecolor, &dwg->header_vars.INTERFERECOLOR, sizeof (dwg->header_vars.INTERFERECOLOR))
       )
      pass ();
    else
      fail ("HEADER.INTERFERECOLOR [CMC]");
  }
  {
    BITCODE_H interfereobjvs;
    if (dwg_dynapi_header_value (dwg, "INTERFEREOBJVS", &interfereobjvs, NULL)
        && !memcmp (&interfereobjvs, &dwg->header_vars.INTERFEREOBJVS, sizeof (dwg->header_vars.INTERFEREOBJVS))
       )
      pass ();
    else
      fail ("HEADER.INTERFEREOBJVS [H]");
  }
  {
    BITCODE_H interferevpvs;
    if (dwg_dynapi_header_value (dwg, "INTERFEREVPVS", &interferevpvs, NULL)
        && !memcmp (&interferevpvs, &dwg->header_vars.INTERFEREVPVS, sizeof (dwg->header_vars.INTERFEREVPVS))
       )
      pass ();
    else
      fail ("HEADER.INTERFEREVPVS [H]");
  }
  {
    BITCODE_H dragvs;
    if (dwg_dynapi_header_value (dwg, "DRAGVS", &dragvs, NULL)
        && !memcmp (&dragvs, &dwg->header_vars.DRAGVS, sizeof (dwg->header_vars.DRAGVS))
       )
      pass ();
    else
      fail ("HEADER.DRAGVS [H]");
  }
  {
    BITCODE_RC cshadow;
    if (dwg_dynapi_header_value (dwg, "CSHADOW", &cshadow, NULL)
        && cshadow == dwg->header_vars.CSHADOW)
      pass ();
    else
      fail ("HEADER.CSHADOW [RC] %u != %u", dwg->header_vars.CSHADOW, cshadow);
    cshadow++;
    if (dwg_dynapi_header_set_value (dwg, "CSHADOW", &cshadow, 0)
        && cshadow == dwg->header_vars.CSHADOW)
      pass ();
    else
      fail ("HEADER.CSHADOW [RC] set+1 %u != %u",
            dwg->header_vars.CSHADOW, cshadow);
    cshadow--;
    dwg_dynapi_header_set_value (dwg, "CSHADOW", &cshadow, 0);

  }
  {
    BITCODE_BD shadowplanelocation;
    if (dwg_dynapi_header_value (dwg, "SHADOWPLANELOCATION", &shadowplanelocation, NULL)
        && shadowplanelocation == dwg->header_vars.SHADOWPLANELOCATION)
      pass ();
    else
      fail ("HEADER.SHADOWPLANELOCATION [BD] %g != %g", dwg->header_vars.SHADOWPLANELOCATION, shadowplanelocation);
    shadowplanelocation++;
    if (dwg_dynapi_header_set_value (dwg, "SHADOWPLANELOCATION", &shadowplanelocation, 0)
        && shadowplanelocation == dwg->header_vars.SHADOWPLANELOCATION)
      pass ();
    else
      fail ("HEADER.SHADOWPLANELOCATION [BD] set+1 %g != %g",
            dwg->header_vars.SHADOWPLANELOCATION, shadowplanelocation);
    shadowplanelocation--;
    dwg_dynapi_header_set_value (dwg, "SHADOWPLANELOCATION", &shadowplanelocation, 0);

  }
  {
    BITCODE_BS unknown_54;
    if (dwg_dynapi_header_value (dwg, "unknown_54", &unknown_54, NULL)
        && unknown_54 == dwg->header_vars.unknown_54)
      pass ();
    else
      fail ("HEADER.unknown_54 [BS] %hu != %hu", dwg->header_vars.unknown_54, unknown_54);
    unknown_54++;
    if (dwg_dynapi_header_set_value (dwg, "unknown_54", &unknown_54, 0)
        && unknown_54 == dwg->header_vars.unknown_54)
      pass ();
    else
      fail ("HEADER.unknown_54 [BS] set+1 %hu != %hu",
            dwg->header_vars.unknown_54, unknown_54);
    unknown_54--;
    dwg_dynapi_header_set_value (dwg, "unknown_54", &unknown_54, 0);

  }
  {
    BITCODE_BS unknown_55;
    if (dwg_dynapi_header_value (dwg, "unknown_55", &unknown_55, NULL)
        && unknown_55 == dwg->header_vars.unknown_55)
      pass ();
    else
      fail ("HEADER.unknown_55 [BS] %hu != %hu", dwg->header_vars.unknown_55, unknown_55);
    unknown_55++;
    if (dwg_dynapi_header_set_value (dwg, "unknown_55", &unknown_55, 0)
        && unknown_55 == dwg->header_vars.unknown_55)
      pass ();
    else
      fail ("HEADER.unknown_55 [BS] set+1 %hu != %hu",
            dwg->header_vars.unknown_55, unknown_55);
    unknown_55--;
    dwg_dynapi_header_set_value (dwg, "unknown_55", &unknown_55, 0);

  }
  {
    BITCODE_BS unknown_56;
    if (dwg_dynapi_header_value (dwg, "unknown_56", &unknown_56, NULL)
        && unknown_56 == dwg->header_vars.unknown_56)
      pass ();
    else
      fail ("HEADER.unknown_56 [BS] %hu != %hu", dwg->header_vars.unknown_56, unknown_56);
    unknown_56++;
    if (dwg_dynapi_header_set_value (dwg, "unknown_56", &unknown_56, 0)
        && unknown_56 == dwg->header_vars.unknown_56)
      pass ();
    else
      fail ("HEADER.unknown_56 [BS] set+1 %hu != %hu",
            dwg->header_vars.unknown_56, unknown_56);
    unknown_56--;
    dwg_dynapi_header_set_value (dwg, "unknown_56", &unknown_56, 0);

  }
  {
    BITCODE_BS unknown_57;
    if (dwg_dynapi_header_value (dwg, "unknown_57", &unknown_57, NULL)
        && unknown_57 == dwg->header_vars.unknown_57)
      pass ();
    else
      fail ("HEADER.unknown_57 [BS] %hu != %hu", dwg->header_vars.unknown_57, unknown_57);
    unknown_57++;
    if (dwg_dynapi_header_set_value (dwg, "unknown_57", &unknown_57, 0)
        && unknown_57 == dwg->header_vars.unknown_57)
      pass ();
    else
      fail ("HEADER.unknown_57 [BS] set+1 %hu != %hu",
            dwg->header_vars.unknown_57, unknown_57);
    unknown_57--;
    dwg_dynapi_header_set_value (dwg, "unknown_57", &unknown_57, 0);

  }
#line 48 "dynapi_test.c.in"
  return error;
}
#line 5380 "dynapi_test.c"
/* @@for test_OBJECT@@ */
static int test__3DFACE (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity__3DFACE *restrict _3dface = obj->tio.entity->tio._3DFACE;
  failed = 0;
  {
    BITCODE_3BD corner1;
    if (dwg_dynapi_entity_value (_3dface, "3DFACE", "corner1", &corner1, NULL)
        && !memcmp (&corner1, &_3dface->corner1, sizeof (BITCODE_3BD)))
        pass ();
    else
        fail ("3DFACE.corner1 [3BD]");
  }
  {
    BITCODE_3BD corner2;
    if (dwg_dynapi_entity_value (_3dface, "3DFACE", "corner2", &corner2, NULL)
        && !memcmp (&corner2, &_3dface->corner2, sizeof (BITCODE_3BD)))
        pass ();
    else
        fail ("3DFACE.corner2 [3BD]");
  }
  {
    BITCODE_3BD corner3;
    if (dwg_dynapi_entity_value (_3dface, "3DFACE", "corner3", &corner3, NULL)
        && !memcmp (&corner3, &_3dface->corner3, sizeof (BITCODE_3BD)))
        pass ();
    else
        fail ("3DFACE.corner3 [3BD]");
  }
  {
    BITCODE_3BD corner4;
    if (dwg_dynapi_entity_value (_3dface, "3DFACE", "corner4", &corner4, NULL)
        && !memcmp (&corner4, &_3dface->corner4, sizeof (BITCODE_3BD)))
        pass ();
    else
        fail ("3DFACE.corner4 [3BD]");
  }
  {
    BITCODE_B has_no_flags;
    if (dwg_dynapi_entity_value (_3dface, "3DFACE", "has_no_flags", &has_no_flags, NULL)
        && has_no_flags == _3dface->has_no_flags)
      pass ();
    else
      fail ("3DFACE.has_no_flags [B] " FORMAT_B " != " FORMAT_B "", _3dface->has_no_flags, has_no_flags);
    has_no_flags++;
    if (dwg_dynapi_entity_set_value (_3dface, "3DFACE", "has_no_flags", &has_no_flags, 0)
        && has_no_flags == _3dface->has_no_flags)
      pass ();
    else
      fail ("3DFACE.has_no_flags [B] set+1 " FORMAT_B " != " FORMAT_B "", _3dface->has_no_flags, has_no_flags);
    _3dface->has_no_flags--;
  }
  {
    BITCODE_BS invis_flags;
    if (dwg_dynapi_entity_value (_3dface, "3DFACE", "invis_flags", &invis_flags, NULL)
        && invis_flags == _3dface->invis_flags)
      pass ();
    else
      fail ("3DFACE.invis_flags [BS] %hu != %hu", _3dface->invis_flags, invis_flags);
    invis_flags++;
    if (dwg_dynapi_entity_set_value (_3dface, "3DFACE", "invis_flags", &invis_flags, 0)
        && invis_flags == _3dface->invis_flags)
      pass ();
    else
      fail ("3DFACE.invis_flags [BS] set+1 %hu != %hu", _3dface->invis_flags, invis_flags);
    _3dface->invis_flags--;
  }
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value (_3dface, "3DFACE", "parent", &parent, NULL)
        && !memcmp (&parent, &_3dface->parent, sizeof (struct _dwg_object_entity*)))
        pass ();
    else
        fail ("3DFACE.parent [struct _dwg_object_entity*]");
  }
  {
    BITCODE_B z_is_zero;
    if (dwg_dynapi_entity_value (_3dface, "3DFACE", "z_is_zero", &z_is_zero, NULL)
        && z_is_zero == _3dface->z_is_zero)
      pass ();
    else
      fail ("3DFACE.z_is_zero [B] " FORMAT_B " != " FORMAT_B "", _3dface->z_is_zero, z_is_zero);
    z_is_zero++;
    if (dwg_dynapi_entity_set_value (_3dface, "3DFACE", "z_is_zero", &z_is_zero, 0)
        && z_is_zero == _3dface->z_is_zero)
      pass ();
    else
      fail ("3DFACE.z_is_zero [B] set+1 " FORMAT_B " != " FORMAT_B "", _3dface->z_is_zero, z_is_zero);
    _3dface->z_is_zero--;
  }
  if (failed && (is_class_unstable ("3DFACE") || is_class_debugging ("3DFACE")))
    {
      ok ("%s failed %d tests (TODO unstable)", "3DFACE", failed);
      failed = 0;
    }
  return failed;
}
static int test__3DSOLID (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity__3DSOLID *restrict _3dsolid = obj->tio.entity->tio._3DSOLID;
  failed = 0;
  {
    BITCODE_B _dxf_sab_converted;
    if (dwg_dynapi_entity_value (_3dsolid, "3DSOLID", "_dxf_sab_converted", &_dxf_sab_converted, NULL)
        && _dxf_sab_converted == _3dsolid->_dxf_sab_converted)
      pass ();
    else
      fail ("3DSOLID._dxf_sab_converted [B] " FORMAT_B " != " FORMAT_B "", _3dsolid->_dxf_sab_converted, _dxf_sab_converted);
    _dxf_sab_converted++;
    if (dwg_dynapi_entity_set_value (_3dsolid, "3DSOLID", "_dxf_sab_converted", &_dxf_sab_converted, 0)
        && _dxf_sab_converted == _3dsolid->_dxf_sab_converted)
      pass ();
    else
      fail ("3DSOLID._dxf_sab_converted [B] set+1 " FORMAT_B " != " FORMAT_B "", _3dsolid->_dxf_sab_converted, _dxf_sab_converted);
    _3dsolid->_dxf_sab_converted--;
  }
  {
    BITCODE_RC* acis_data;
    if (dwg_dynapi_entity_value (_3dsolid, "3DSOLID", "acis_data", &acis_data, NULL)
        && acis_data
           ? strEQ ((char *)acis_data, (char *)_3dsolid->acis_data)
           : !_3dsolid->acis_data)
      pass ();
    else
      fail ("3DSOLID.acis_data [RC*] '%s' <> '%s'", acis_data, _3dsolid->acis_data);
  }
  {
    BITCODE_B acis_empty;
    if (dwg_dynapi_entity_value (_3dsolid, "3DSOLID", "acis_empty", &acis_empty, NULL)
        && acis_empty == _3dsolid->acis_empty)
      pass ();
    else
      fail ("3DSOLID.acis_empty [B] " FORMAT_B " != " FORMAT_B "", _3dsolid->acis_empty, acis_empty);
    acis_empty++;
    if (dwg_dynapi_entity_set_value (_3dsolid, "3DSOLID", "acis_empty", &acis_empty, 0)
        && acis_empty == _3dsolid->acis_empty)
      pass ();
    else
      fail ("3DSOLID.acis_empty [B] set+1 " FORMAT_B " != " FORMAT_B "", _3dsolid->acis_empty, acis_empty);
    _3dsolid->acis_empty--;
  }
  {
    BITCODE_B acis_empty2;
    if (dwg_dynapi_entity_value (_3dsolid, "3DSOLID", "acis_empty2", &acis_empty2, NULL)
        && acis_empty2 == _3dsolid->acis_empty2)
      pass ();
    else
      fail ("3DSOLID.acis_empty2 [B] " FORMAT_B " != " FORMAT_B "", _3dsolid->acis_empty2, acis_empty2);
    acis_empty2++;
    if (dwg_dynapi_entity_set_value (_3dsolid, "3DSOLID", "acis_empty2", &acis_empty2, 0)
        && acis_empty2 == _3dsolid->acis_empty2)
      pass ();
    else
      fail ("3DSOLID.acis_empty2 [B] set+1 " FORMAT_B " != " FORMAT_B "", _3dsolid->acis_empty2, acis_empty2);
    _3dsolid->acis_empty2--;
  }
  {
    BITCODE_B acis_empty_bit;
    if (dwg_dynapi_entity_value (_3dsolid, "3DSOLID", "acis_empty_bit", &acis_empty_bit, NULL)
        && acis_empty_bit == _3dsolid->acis_empty_bit)
      pass ();
    else
      fail ("3DSOLID.acis_empty_bit [B] " FORMAT_B " != " FORMAT_B "", _3dsolid->acis_empty_bit, acis_empty_bit);
    acis_empty_bit++;
    if (dwg_dynapi_entity_set_value (_3dsolid, "3DSOLID", "acis_empty_bit", &acis_empty_bit, 0)
        && acis_empty_bit == _3dsolid->acis_empty_bit)
      pass ();
    else
      fail ("3DSOLID.acis_empty_bit [B] set+1 " FORMAT_B " != " FORMAT_B "", _3dsolid->acis_empty_bit, acis_empty_bit);
    _3dsolid->acis_empty_bit--;
  }
  {
    BITCODE_BL* block_size;
    if (dwg_dynapi_entity_value (_3dsolid, "3DSOLID", "block_size", &block_size, NULL)
        && !memcmp (&block_size, &_3dsolid->block_size, sizeof (BITCODE_BL*)))
        pass ();
    else
        fail ("3DSOLID.block_size [BL*]");
  }
  {
    char ** encr_sat_data;
    if (dwg_dynapi_entity_value (_3dsolid, "3DSOLID", "encr_sat_data", &encr_sat_data, NULL)
        && !memcmp (&encr_sat_data, &_3dsolid->encr_sat_data, sizeof (_3dsolid->encr_sat_data)))
      pass ();
    else
      fail ("3DSOLID.encr_sat_data [char **]");
  }
  {
    BITCODE_BL end_marker;
    if (dwg_dynapi_entity_value (_3dsolid, "3DSOLID", "end_marker", &end_marker, NULL)
        && end_marker == _3dsolid->end_marker)
      pass ();
    else
      fail ("3DSOLID.end_marker [BL] %u != %u", _3dsolid->end_marker, end_marker);
    end_marker++;
    if (dwg_dynapi_entity_set_value (_3dsolid, "3DSOLID", "end_marker", &end_marker, 0)
        && end_marker == _3dsolid->end_marker)
      pass ();
    else
      fail ("3DSOLID.end_marker [BL] set+1 %u != %u", _3dsolid->end_marker, end_marker);
    _3dsolid->end_marker--;
  }
  {
    struct _dwg_entity_3DSOLID* extra_acis_data;
    if (dwg_dynapi_entity_value (_3dsolid, "3DSOLID", "extra_acis_data", &extra_acis_data, NULL)
        && !memcmp (&extra_acis_data, &_3dsolid->extra_acis_data, sizeof (struct _dwg_entity_3DSOLID*)))
        pass ();
    else
        fail ("3DSOLID.extra_acis_data [struct _dwg_entity_3DSOLID*]");
  }
  {
    BITCODE_B has_revision_guid;
    if (dwg_dynapi_entity_value (_3dsolid, "3DSOLID", "has_revision_guid", &has_revision_guid, NULL)
        && has_revision_guid == _3dsolid->has_revision_guid)
      pass ();
    else
      fail ("3DSOLID.has_revision_guid [B] " FORMAT_B " != " FORMAT_B "", _3dsolid->has_revision_guid, has_revision_guid);
    has_revision_guid++;
    if (dwg_dynapi_entity_set_value (_3dsolid, "3DSOLID", "has_revision_guid", &has_revision_guid, 0)
        && has_revision_guid == _3dsolid->has_revision_guid)
      pass ();
    else
      fail ("3DSOLID.has_revision_guid [B] set+1 " FORMAT_B " != " FORMAT_B "", _3dsolid->has_revision_guid, has_revision_guid);
    _3dsolid->has_revision_guid--;
  }
  {
    BITCODE_H history_id;
    if (dwg_dynapi_entity_value (_3dsolid, "3DSOLID", "history_id", &history_id, NULL)
        && !memcmp (&history_id, &_3dsolid->history_id, sizeof (BITCODE_H)))
        pass ();
    else
        fail ("3DSOLID.history_id [H]");
  }
  {
    BITCODE_B isoline_present;
    if (dwg_dynapi_entity_value (_3dsolid, "3DSOLID", "isoline_present", &isoline_present, NULL)
        && isoline_present == _3dsolid->isoline_present)
      pass ();
    else
      fail ("3DSOLID.isoline_present [B] " FORMAT_B " != " FORMAT_B "", _3dsolid->isoline_present, isoline_present);
    isoline_present++;
    if (dwg_dynapi_entity_set_value (_3dsolid, "3DSOLID", "isoline_present", &isoline_present, 0)
        && isoline_present == _3dsolid->isoline_present)
      pass ();
    else
      fail ("3DSOLID.isoline_present [B] set+1 " FORMAT_B " != " FORMAT_B "", _3dsolid->isoline_present, isoline_present);
    _3dsolid->isoline_present--;
  }
  {
    BITCODE_BL isolines;
    if (dwg_dynapi_entity_value (_3dsolid, "3DSOLID", "isolines", &isolines, NULL)
        && isolines == _3dsolid->isolines)
      pass ();
    else
      fail ("3DSOLID.isolines [BL] %u != %u", _3dsolid->isolines, isolines);
    isolines++;
    if (dwg_dynapi_entity_set_value (_3dsolid, "3DSOLID", "isolines", &isolines, 0)
        && isolines == _3dsolid->isolines)
      pass ();
    else
      fail ("3DSOLID.isolines [BL] set+1 %u != %u", _3dsolid->isolines, isolines);
    _3dsolid->isolines--;
  }
  {
    Dwg_3DSOLID_material* materials;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (_3dsolid, "3DSOLID", "num_materials", &count, NULL)
        && dwg_dynapi_entity_value (_3dsolid, "3DSOLID", "materials", &materials, NULL)
        && materials == _3dsolid->materials)
      pass ();
    else
      fail ("3DSOLID.materials [Dwg_3DSOLID_material*] * %u num_materials", count);
  }
  {
    BITCODE_BL num_blocks;
    if (dwg_dynapi_entity_value (_3dsolid, "3DSOLID", "num_blocks", &num_blocks, NULL)
        && num_blocks == _3dsolid->num_blocks)
      pass ();
    else
      fail ("3DSOLID.num_blocks [BL] %u != %u", _3dsolid->num_blocks, num_blocks);
    num_blocks++;
    if (dwg_dynapi_entity_set_value (_3dsolid, "3DSOLID", "num_blocks", &num_blocks, 0)
        && num_blocks == _3dsolid->num_blocks)
      pass ();
    else
      fail ("3DSOLID.num_blocks [BL] set+1 %u != %u", _3dsolid->num_blocks, num_blocks);
    _3dsolid->num_blocks--;
  }
  {
    BITCODE_BL num_materials;
    if (dwg_dynapi_entity_value (_3dsolid, "3DSOLID", "num_materials", &num_materials, NULL)
        && num_materials == _3dsolid->num_materials)
      pass ();
    else
      fail ("3DSOLID.num_materials [BL] %u != %u", _3dsolid->num_materials, num_materials);
    num_materials++;
    if (dwg_dynapi_entity_set_value (_3dsolid, "3DSOLID", "num_materials", &num_materials, 0)
        && num_materials == _3dsolid->num_materials)
      pass ();
    else
      fail ("3DSOLID.num_materials [BL] set+1 %u != %u", _3dsolid->num_materials, num_materials);
    _3dsolid->num_materials--;
  }
  {
    BITCODE_BL num_silhouettes;
    if (dwg_dynapi_entity_value (_3dsolid, "3DSOLID", "num_silhouettes", &num_silhouettes, NULL)
        && num_silhouettes == _3dsolid->num_silhouettes)
      pass ();
    else
      fail ("3DSOLID.num_silhouettes [BL] %u != %u", _3dsolid->num_silhouettes, num_silhouettes);
    num_silhouettes++;
    if (dwg_dynapi_entity_set_value (_3dsolid, "3DSOLID", "num_silhouettes", &num_silhouettes, 0)
        && num_silhouettes == _3dsolid->num_silhouettes)
      pass ();
    else
      fail ("3DSOLID.num_silhouettes [BL] set+1 %u != %u", _3dsolid->num_silhouettes, num_silhouettes);
    _3dsolid->num_silhouettes--;
  }
  {
    BITCODE_BL num_wires;
    if (dwg_dynapi_entity_value (_3dsolid, "3DSOLID", "num_wires", &num_wires, NULL)
        && num_wires == _3dsolid->num_wires)
      pass ();
    else
      fail ("3DSOLID.num_wires [BL] %u != %u", _3dsolid->num_wires, num_wires);
    num_wires++;
    if (dwg_dynapi_entity_set_value (_3dsolid, "3DSOLID", "num_wires", &num_wires, 0)
        && num_wires == _3dsolid->num_wires)
      pass ();
    else
      fail ("3DSOLID.num_wires [BL] set+1 %u != %u", _3dsolid->num_wires, num_wires);
    _3dsolid->num_wires--;
  }
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value (_3dsolid, "3DSOLID", "parent", &parent, NULL)
        && !memcmp (&parent, &_3dsolid->parent, sizeof (struct _dwg_object_entity*)))
        pass ();
    else
        fail ("3DSOLID.parent [struct _dwg_object_entity*]");
  }
  {
    BITCODE_3BD point;
    if (dwg_dynapi_entity_value (_3dsolid, "3DSOLID", "point", &point, NULL)
        && !memcmp (&point, &_3dsolid->point, sizeof (BITCODE_3BD)))
        pass ();
    else
        fail ("3DSOLID.point [3BD]");
  }
  {
    BITCODE_B point_present;
    if (dwg_dynapi_entity_value (_3dsolid, "3DSOLID", "point_present", &point_present, NULL)
        && point_present == _3dsolid->point_present)
      pass ();
    else
      fail ("3DSOLID.point_present [B] " FORMAT_B " != " FORMAT_B "", _3dsolid->point_present, point_present);
    point_present++;
    if (dwg_dynapi_entity_set_value (_3dsolid, "3DSOLID", "point_present", &point_present, 0)
        && point_present == _3dsolid->point_present)
      pass ();
    else
      fail ("3DSOLID.point_present [B] set+1 " FORMAT_B " != " FORMAT_B "", _3dsolid->point_present, point_present);
    _3dsolid->point_present--;
  }
  {
    BITCODE_RC revision_bytes[9];
    if (dwg_dynapi_entity_value (_3dsolid, "3DSOLID", "revision_bytes[9]", &revision_bytes, NULL)
        && !memcmp (&revision_bytes, &_3dsolid->revision_bytes, sizeof (BITCODE_RC)))
        pass ();
    else
        fail ("3DSOLID.revision_bytes[9] [RC]");
  }
  {
    BITCODE_RC revision_guid[39];
    if (dwg_dynapi_entity_value (_3dsolid, "3DSOLID", "revision_guid[39]", &revision_guid, NULL)
        && !memcmp (&revision_guid, &_3dsolid->revision_guid, sizeof (BITCODE_RC)))
        pass ();
    else
        fail ("3DSOLID.revision_guid[39] [RC]");
  }
  {
    BITCODE_BL revision_major;
    if (dwg_dynapi_entity_value (_3dsolid, "3DSOLID", "revision_major", &revision_major, NULL)
        && revision_major == _3dsolid->revision_major)
      pass ();
    else
      fail ("3DSOLID.revision_major [BL] %u != %u", _3dsolid->revision_major, revision_major);
    revision_major++;
    if (dwg_dynapi_entity_set_value (_3dsolid, "3DSOLID", "revision_major", &revision_major, 0)
        && revision_major == _3dsolid->revision_major)
      pass ();
    else
      fail ("3DSOLID.revision_major [BL] set+1 %u != %u", _3dsolid->revision_major, revision_major);
    _3dsolid->revision_major--;
  }
  {
    BITCODE_BS revision_minor1;
    if (dwg_dynapi_entity_value (_3dsolid, "3DSOLID", "revision_minor1", &revision_minor1, NULL)
        && revision_minor1 == _3dsolid->revision_minor1)
      pass ();
    else
      fail ("3DSOLID.revision_minor1 [BS] %hu != %hu", _3dsolid->revision_minor1, revision_minor1);
    revision_minor1++;
    if (dwg_dynapi_entity_set_value (_3dsolid, "3DSOLID", "revision_minor1", &revision_minor1, 0)
        && revision_minor1 == _3dsolid->revision_minor1)
      pass ();
    else
      fail ("3DSOLID.revision_minor1 [BS] set+1 %hu != %hu", _3dsolid->revision_minor1, revision_minor1);
    _3dsolid->revision_minor1--;
  }
  {
    BITCODE_BS revision_minor2;
    if (dwg_dynapi_entity_value (_3dsolid, "3DSOLID", "revision_minor2", &revision_minor2, NULL)
        && revision_minor2 == _3dsolid->revision_minor2)
      pass ();
    else
      fail ("3DSOLID.revision_minor2 [BS] %hu != %hu", _3dsolid->revision_minor2, revision_minor2);
    revision_minor2++;
    if (dwg_dynapi_entity_set_value (_3dsolid, "3DSOLID", "revision_minor2", &revision_minor2, 0)
        && revision_minor2 == _3dsolid->revision_minor2)
      pass ();
    else
      fail ("3DSOLID.revision_minor2 [BS] set+1 %hu != %hu", _3dsolid->revision_minor2, revision_minor2);
    _3dsolid->revision_minor2--;
  }
  {
    BITCODE_BL sab_size;
    if (dwg_dynapi_entity_value (_3dsolid, "3DSOLID", "sab_size", &sab_size, NULL)
        && sab_size == _3dsolid->sab_size)
      pass ();
    else
      fail ("3DSOLID.sab_size [BL] %u != %u", _3dsolid->sab_size, sab_size);
    sab_size++;
    if (dwg_dynapi_entity_set_value (_3dsolid, "3DSOLID", "sab_size", &sab_size, 0)
        && sab_size == _3dsolid->sab_size)
      pass ();
    else
      fail ("3DSOLID.sab_size [BL] set+1 %u != %u", _3dsolid->sab_size, sab_size);
    _3dsolid->sab_size--;
  }
  {
    Dwg_3DSOLID_silhouette* silhouettes;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (_3dsolid, "3DSOLID", "num_silhouettes", &count, NULL)
        && dwg_dynapi_entity_value (_3dsolid, "3DSOLID", "silhouettes", &silhouettes, NULL)
        && silhouettes == _3dsolid->silhouettes)
      pass ();
    else
      fail ("3DSOLID.silhouettes [Dwg_3DSOLID_silhouette*] * %u num_silhouettes", count);
  }
  {
    BITCODE_B unknown;
    if (dwg_dynapi_entity_value (_3dsolid, "3DSOLID", "unknown", &unknown, NULL)
        && unknown == _3dsolid->unknown)
      pass ();
    else
      fail ("3DSOLID.unknown [B] " FORMAT_B " != " FORMAT_B "", _3dsolid->unknown, unknown);
    unknown++;
    if (dwg_dynapi_entity_set_value (_3dsolid, "3DSOLID", "unknown", &unknown, 0)
        && unknown == _3dsolid->unknown)
      pass ();
    else
      fail ("3DSOLID.unknown [B] set+1 " FORMAT_B " != " FORMAT_B "", _3dsolid->unknown, unknown);
    _3dsolid->unknown--;
  }
  {
    BITCODE_BS version;
    if (dwg_dynapi_entity_value (_3dsolid, "3DSOLID", "version", &version, NULL)
        && version == _3dsolid->version)
      pass ();
    else
      fail ("3DSOLID.version [BS] %hu != %hu", _3dsolid->version, version);
    version++;
    if (dwg_dynapi_entity_set_value (_3dsolid, "3DSOLID", "version", &version, 0)
        && version == _3dsolid->version)
      pass ();
    else
      fail ("3DSOLID.version [BS] set+1 %hu != %hu", _3dsolid->version, version);
    _3dsolid->version--;
  }
  {
    BITCODE_B wireframe_data_present;
    if (dwg_dynapi_entity_value (_3dsolid, "3DSOLID", "wireframe_data_present", &wireframe_data_present, NULL)
        && wireframe_data_present == _3dsolid->wireframe_data_present)
      pass ();
    else
      fail ("3DSOLID.wireframe_data_present [B] " FORMAT_B " != " FORMAT_B "", _3dsolid->wireframe_data_present, wireframe_data_present);
    wireframe_data_present++;
    if (dwg_dynapi_entity_set_value (_3dsolid, "3DSOLID", "wireframe_data_present", &wireframe_data_present, 0)
        && wireframe_data_present == _3dsolid->wireframe_data_present)
      pass ();
    else
      fail ("3DSOLID.wireframe_data_present [B] set+1 " FORMAT_B " != " FORMAT_B "", _3dsolid->wireframe_data_present, wireframe_data_present);
    _3dsolid->wireframe_data_present--;
  }
  {
    Dwg_3DSOLID_wire* wires;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (_3dsolid, "3DSOLID", "num_wires", &count, NULL)
        && dwg_dynapi_entity_value (_3dsolid, "3DSOLID", "wires", &wires, NULL)
        && wires == _3dsolid->wires)
      pass ();
    else
      fail ("3DSOLID.wires [Dwg_3DSOLID_wire*] * %u num_wires", count);
  }
  if (failed && (is_class_unstable ("3DSOLID") || is_class_debugging ("3DSOLID")))
    {
      ok ("%s failed %d tests (TODO unstable)", "3DSOLID", failed);
      failed = 0;
    }
  return failed;
}
static int test_ALIGNMENTPARAMETERENTITY (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_ALIGNMENTPARAMETERENTITY *restrict alignmentparameterentity = obj->tio.entity->tio.ALIGNMENTPARAMETERENTITY;
  failed = 0;
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value (alignmentparameterentity, "ALIGNMENTPARAMETERENTITY", "parent", &parent, NULL)
        && !memcmp (&parent, &alignmentparameterentity->parent, sizeof (struct _dwg_object_entity*)))
        pass ();
    else
        fail ("ALIGNMENTPARAMETERENTITY.parent [struct _dwg_object_entity*]");
  }
  if (failed && (is_class_unstable ("ALIGNMENTPARAMETERENTITY") || is_class_debugging ("ALIGNMENTPARAMETERENTITY")))
    {
      ok ("%s failed %d tests (TODO unstable)", "ALIGNMENTPARAMETERENTITY", failed);
      failed = 0;
    }
  return failed;
}
static int test_ARC (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_ARC *restrict arc = obj->tio.entity->tio.ARC;
  failed = 0;
  {
    BITCODE_3BD center;
    if (dwg_dynapi_entity_value (arc, "ARC", "center", &center, NULL)
        && !memcmp (&center, &arc->center, sizeof (BITCODE_3BD)))
        pass ();
    else
        fail ("ARC.center [3BD]");
  }
  {
    BITCODE_BD end_angle;
    if (dwg_dynapi_entity_value (arc, "ARC", "end_angle", &end_angle, NULL)
        && end_angle == arc->end_angle)
      pass ();
    else
      fail ("ARC.end_angle [BD] %g != %g", arc->end_angle, end_angle);
    end_angle++;
    if (dwg_dynapi_entity_set_value (arc, "ARC", "end_angle", &end_angle, 0)
        && end_angle == arc->end_angle)
      pass ();
    else
      fail ("ARC.end_angle [BD] set+1 %g != %g", arc->end_angle, end_angle);
    arc->end_angle--;
  }
  {
    BITCODE_BE extrusion;
    if (dwg_dynapi_entity_value (arc, "ARC", "extrusion", &extrusion, NULL)
        && !memcmp (&extrusion, &arc->extrusion, sizeof (BITCODE_BE)))
        pass ();
    else
        fail ("ARC.extrusion [BE]");
  }
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value (arc, "ARC", "parent", &parent, NULL)
        && !memcmp (&parent, &arc->parent, sizeof (struct _dwg_object_entity*)))
        pass ();
    else
        fail ("ARC.parent [struct _dwg_object_entity*]");
  }
  {
    BITCODE_BD radius;
    if (dwg_dynapi_entity_value (arc, "ARC", "radius", &radius, NULL)
        && radius == arc->radius)
      pass ();
    else
      fail ("ARC.radius [BD] %g != %g", arc->radius, radius);
    radius++;
    if (dwg_dynapi_entity_set_value (arc, "ARC", "radius", &radius, 0)
        && radius == arc->radius)
      pass ();
    else
      fail ("ARC.radius [BD] set+1 %g != %g", arc->radius, radius);
    arc->radius--;
  }
  {
    BITCODE_BD start_angle;
    if (dwg_dynapi_entity_value (arc, "ARC", "start_angle", &start_angle, NULL)
        && start_angle == arc->start_angle)
      pass ();
    else
      fail ("ARC.start_angle [BD] %g != %g", arc->start_angle, start_angle);
    start_angle++;
    if (dwg_dynapi_entity_set_value (arc, "ARC", "start_angle", &start_angle, 0)
        && start_angle == arc->start_angle)
      pass ();
    else
      fail ("ARC.start_angle [BD] set+1 %g != %g", arc->start_angle, start_angle);
    arc->start_angle--;
  }
  {
    BITCODE_BT thickness;
    if (dwg_dynapi_entity_value (arc, "ARC", "thickness", &thickness, NULL)
        && thickness == arc->thickness)
      pass ();
    else
      fail ("ARC.thickness [BT] " FORMAT_BT " != " FORMAT_BT "", arc->thickness, thickness);
    if (dwg_dynapi_entity_set_value (arc, "ARC", "thickness", &thickness, 0)
        && thickness == arc->thickness)
      pass ();
    else
      fail ("ARC.thickness [BT] set+1 " FORMAT_BT " != " FORMAT_BT "", arc->thickness, thickness);
    arc->thickness--;
  }
  if (failed && (is_class_unstable ("ARC") || is_class_debugging ("ARC")))
    {
      ok ("%s failed %d tests (TODO unstable)", "ARC", failed);
      failed = 0;
    }
  return failed;
}
static int test_ARC_DIMENSION (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_ARC_DIMENSION *restrict arc_dimension = obj->tio.entity->tio.ARC_DIMENSION;
  failed = 0;
  {
    BITCODE_BD act_measurement;
    if (dwg_dynapi_entity_value (arc_dimension, "ARC_DIMENSION", "act_measurement", &act_measurement, NULL)
        && act_measurement == arc_dimension->act_measurement)
      pass ();
    else
      fail ("ARC_DIMENSION.act_measurement [BD] %g != %g", arc_dimension->act_measurement, act_measurement);
    act_measurement++;
    if (dwg_dynapi_entity_set_value (arc_dimension, "ARC_DIMENSION", "act_measurement", &act_measurement, 0)
        && act_measurement == arc_dimension->act_measurement)
      pass ();
    else
      fail ("ARC_DIMENSION.act_measurement [BD] set+1 %g != %g", arc_dimension->act_measurement, act_measurement);
    arc_dimension->act_measurement--;
  }
  {
    BITCODE_BD arc_end_param;
    if (dwg_dynapi_entity_value (arc_dimension, "ARC_DIMENSION", "arc_end_param", &arc_end_param, NULL)
        && arc_end_param == arc_dimension->arc_end_param)
      pass ();
    else
      fail ("ARC_DIMENSION.arc_end_param [BD] %g != %g", arc_dimension->arc_end_param, arc_end_param);
    arc_end_param++;
    if (dwg_dynapi_entity_set_value (arc_dimension, "ARC_DIMENSION", "arc_end_param", &arc_end_param, 0)
        && arc_end_param == arc_dimension->arc_end_param)
      pass ();
    else
      fail ("ARC_DIMENSION.arc_end_param [BD] set+1 %g != %g", arc_dimension->arc_end_param, arc_end_param);
    arc_dimension->arc_end_param--;
  }
  {
    BITCODE_BD arc_start_param;
    if (dwg_dynapi_entity_value (arc_dimension, "ARC_DIMENSION", "arc_start_param", &arc_start_param, NULL)
        && arc_start_param == arc_dimension->arc_start_param)
      pass ();
    else
      fail ("ARC_DIMENSION.arc_start_param [BD] %g != %g", arc_dimension->arc_start_param, arc_start_param);
    arc_start_param++;
    if (dwg_dynapi_entity_set_value (arc_dimension, "ARC_DIMENSION", "arc_start_param", &arc_start_param, 0)
        && arc_start_param == arc_dimension->arc_start_param)
      pass ();
    else
      fail ("ARC_DIMENSION.arc_start_param [BD] set+1 %g != %g", arc_dimension->arc_start_param, arc_start_param);
    arc_dimension->arc_start_param--;
  }
  {
    BITCODE_BS attachment;
    if (dwg_dynapi_entity_value (arc_dimension, "ARC_DIMENSION", "attachment", &attachment, NULL)
        && attachment == arc_dimension->attachment)
      pass ();
    else
      fail ("ARC_DIMENSION.attachment [BS] %hu != %hu", arc_dimension->attachment, attachment);
    attachment++;
    if (dwg_dynapi_entity_set_value (arc_dimension, "ARC_DIMENSION", "attachment", &attachment, 0)
        && attachment == arc_dimension->attachment)
      pass ();
    else
      fail ("ARC_DIMENSION.attachment [BS] set+1 %hu != %hu", arc_dimension->attachment, attachment);
    arc_dimension->attachment--;
  }
  {
    BITCODE_H block;
    if (dwg_dynapi_entity_value (arc_dimension, "ARC_DIMENSION", "block", &block, NULL)
        && !memcmp (&block, &arc_dimension->block, sizeof (BITCODE_H)))
        pass ();
    else
        fail ("ARC_DIMENSION.block [H]");
  }
  {
    BITCODE_TV blockname;
    if (dwg_dynapi_entity_value (arc_dimension, "ARC_DIMENSION", "blockname", &blockname, NULL)
        && blockname
           ? strEQ ((char *)blockname, (char *)arc_dimension->blockname)
           : !arc_dimension->blockname)
      pass ();
    else
      fail ("ARC_DIMENSION.blockname [TV] '%s' <> '%s'", blockname, arc_dimension->blockname);
  }
  {
    BITCODE_3BD center_pt;
    if (dwg_dynapi_entity_value (arc_dimension, "ARC_DIMENSION", "center_pt", &center_pt, NULL)
        && !memcmp (&center_pt, &arc_dimension->center_pt, sizeof (BITCODE_3BD)))
        pass ();
    else
        fail ("ARC_DIMENSION.center_pt [3BD]");
  }
  {
    BITCODE_RC class_version;
    if (dwg_dynapi_entity_value (arc_dimension, "ARC_DIMENSION", "class_version", &class_version, NULL)
        && class_version == arc_dimension->class_version)
      pass ();
    else
      fail ("ARC_DIMENSION.class_version [RC] %u != %u", arc_dimension->class_version, class_version);
    class_version++;
    if (dwg_dynapi_entity_set_value (arc_dimension, "ARC_DIMENSION", "class_version", &class_version, 0)
        && class_version == arc_dimension->class_version)
      pass ();
    else
      fail ("ARC_DIMENSION.class_version [RC] set+1 %u != %u", arc_dimension->class_version, class_version);
    arc_dimension->class_version--;
  }
  {
    BITCODE_2RD clone_ins_pt;
    if (dwg_dynapi_entity_value (arc_dimension, "ARC_DIMENSION", "clone_ins_pt", &clone_ins_pt, NULL)
        && !memcmp (&clone_ins_pt, &arc_dimension->clone_ins_pt, sizeof (BITCODE_2RD)))
        pass ();
    else
        fail ("ARC_DIMENSION.clone_ins_pt [2RD]");
  }
  {
    BITCODE_3BD def_pt;
    if (dwg_dynapi_entity_value (arc_dimension, "ARC_DIMENSION", "def_pt", &def_pt, NULL)
        && !memcmp (&def_pt, &arc_dimension->def_pt, sizeof (BITCODE_3BD)))
        pass ();
    else
        fail ("ARC_DIMENSION.def_pt [3BD]");
  }
  {
    BITCODE_H dimstyle;
    if (dwg_dynapi_entity_value (arc_dimension, "ARC_DIMENSION", "dimstyle", &dimstyle, NULL)
        && !memcmp (&dimstyle, &arc_dimension->dimstyle, sizeof (BITCODE_H)))
        pass ();
    else
        fail ("ARC_DIMENSION.dimstyle [H]");
  }
  {
    BITCODE_BD elevation;
    if (dwg_dynapi_entity_value (arc_dimension, "ARC_DIMENSION", "elevation", &elevation, NULL)
        && elevation == arc_dimension->elevation)
      pass ();
    else
      fail ("ARC_DIMENSION.elevation [BD] %g != %g", arc_dimension->elevation, elevation);
    elevation++;
    if (dwg_dynapi_entity_set_value (arc_dimension, "ARC_DIMENSION", "elevation", &elevation, 0)
        && elevation == arc_dimension->elevation)
      pass ();
    else
      fail ("ARC_DIMENSION.elevation [BD] set+1 %g != %g", arc_dimension->elevation, elevation);
    arc_dimension->elevation--;
  }
  {
    BITCODE_BE extrusion;
    if (dwg_dynapi_entity_value (arc_dimension, "ARC_DIMENSION", "extrusion", &extrusion, NULL)
        && !memcmp (&extrusion, &arc_dimension->extrusion, sizeof (BITCODE_BE)))
        pass ();
    else
        fail ("ARC_DIMENSION.extrusion [BE]");
  }
  {
    BITCODE_RC flag;
    if (dwg_dynapi_entity_value (arc_dimension, "ARC_DIMENSION", "flag", &flag, NULL)
        && flag == arc_dimension->flag)
      pass ();
    else
      fail ("ARC_DIMENSION.flag [RC] %u != %u", arc_dimension->flag, flag);
    flag++;
    if (dwg_dynapi_entity_set_value (arc_dimension, "ARC_DIMENSION", "flag", &flag, 0)
        && flag == arc_dimension->flag)
      pass ();
    else
      fail ("ARC_DIMENSION.flag [RC] set+1 %u != %u", arc_dimension->flag, flag);
    arc_dimension->flag--;
  }
  {
    BITCODE_RC flag1;
    if (dwg_dynapi_entity_value (arc_dimension, "ARC_DIMENSION", "flag1", &flag1, NULL)
        && flag1 == arc_dimension->flag1)
      pass ();
    else
      fail ("ARC_DIMENSION.flag1 [RC] %u != %u", arc_dimension->flag1, flag1);
    flag1++;
    if (dwg_dynapi_entity_set_value (arc_dimension, "ARC_DIMENSION", "flag1", &flag1, 0)
        && flag1 == arc_dimension->flag1)
      pass ();
    else
      fail ("ARC_DIMENSION.flag1 [RC] set+1 %u != %u", arc_dimension->flag1, flag1);
    arc_dimension->flag1--;
  }
  {
    BITCODE_B flip_arrow1;
    if (dwg_dynapi_entity_value (arc_dimension, "ARC_DIMENSION", "flip_arrow1", &flip_arrow1, NULL)
        && flip_arrow1 == arc_dimension->flip_arrow1)
      pass ();
    else
      fail ("ARC_DIMENSION.flip_arrow1 [B] " FORMAT_B " != " FORMAT_B "", arc_dimension->flip_arrow1, flip_arrow1);
    flip_arrow1++;
    if (dwg_dynapi_entity_set_value (arc_dimension, "ARC_DIMENSION", "flip_arrow1", &flip_arrow1, 0)
        && flip_arrow1 == arc_dimension->flip_arrow1)
      pass ();
    else
      fail ("ARC_DIMENSION.flip_arrow1 [B] set+1 " FORMAT_B " != " FORMAT_B "", arc_dimension->flip_arrow1, flip_arrow1);
    arc_dimension->flip_arrow1--;
  }
  {
    BITCODE_B flip_arrow2;
    if (dwg_dynapi_entity_value (arc_dimension, "ARC_DIMENSION", "flip_arrow2", &flip_arrow2, NULL)
        && flip_arrow2 == arc_dimension->flip_arrow2)
      pass ();
    else
      fail ("ARC_DIMENSION.flip_arrow2 [B] " FORMAT_B " != " FORMAT_B "", arc_dimension->flip_arrow2, flip_arrow2);
    flip_arrow2++;
    if (dwg_dynapi_entity_set_value (arc_dimension, "ARC_DIMENSION", "flip_arrow2", &flip_arrow2, 0)
        && flip_arrow2 == arc_dimension->flip_arrow2)
      pass ();
    else
      fail ("ARC_DIMENSION.flip_arrow2 [B] set+1 " FORMAT_B " != " FORMAT_B "", arc_dimension->flip_arrow2, flip_arrow2);
    arc_dimension->flip_arrow2--;
  }
  {
    BITCODE_B has_leader;
    if (dwg_dynapi_entity_value (arc_dimension, "ARC_DIMENSION", "has_leader", &has_leader, NULL)
        && has_leader == arc_dimension->has_leader)
      pass ();
    else
      fail ("ARC_DIMENSION.has_leader [B] " FORMAT_B " != " FORMAT_B "", arc_dimension->has_leader, has_leader);
    has_leader++;
    if (dwg_dynapi_entity_set_value (arc_dimension, "ARC_DIMENSION", "has_leader", &has_leader, 0)
        && has_leader == arc_dimension->has_leader)
      pass ();
    else
      fail ("ARC_DIMENSION.has_leader [B] set+1 " FORMAT_B " != " FORMAT_B "", arc_dimension->has_leader, has_leader);
    arc_dimension->has_leader--;
  }
  {
    BITCODE_BD horiz_dir;
    if (dwg_dynapi_entity_value (arc_dimension, "ARC_DIMENSION", "horiz_dir", &horiz_dir, NULL)
        && horiz_dir == arc_dimension->horiz_dir)
      pass ();
    else
      fail ("ARC_DIMENSION.horiz_dir [BD] %g != %g", arc_dimension->horiz_dir, horiz_dir);
    horiz_dir++;
    if (dwg_dynapi_entity_set_value (arc_dimension, "ARC_DIMENSION", "horiz_dir", &horiz_dir, 0)
        && horiz_dir == arc_dimension->horiz_dir)
      pass ();
    else
      fail ("ARC_DIMENSION.horiz_dir [BD] set+1 %g != %g", arc_dimension->horiz_dir, horiz_dir);
    arc_dimension->horiz_dir--;
  }
  {
    BITCODE_BD ins_rotation;
    if (dwg_dynapi_entity_value (arc_dimension, "ARC_DIMENSION", "ins_rotation", &ins_rotation, NULL)
        && ins_rotation == arc_dimension->ins_rotation)
      pass ();
    else
      fail ("ARC_DIMENSION.ins_rotation [BD] %g != %g", arc_dimension->ins_rotation, ins_rotation);
    ins_rotation++;
    if (dwg_dynapi_entity_set_value (arc_dimension, "ARC_DIMENSION", "ins_rotation", &ins_rotation, 0)
        && ins_rotation == arc_dimension->ins_rotation)
      pass ();
    else
      fail ("ARC_DIMENSION.ins_rotation [BD] set+1 %g != %g", arc_dimension->ins_rotation, ins_rotation);
    arc_dimension->ins_rotation--;
  }
  {
    BITCODE_3BD ins_scale;
    if (dwg_dynapi_entity_value (arc_dimension, "ARC_DIMENSION", "ins_scale", &ins_scale, NULL)
        && !memcmp (&ins_scale, &arc_dimension->ins_scale, sizeof (BITCODE_3BD)))
        pass ();
    else
        fail ("ARC_DIMENSION.ins_scale [3BD]");
  }
  {
    BITCODE_B is_partial;
    if (dwg_dynapi_entity_value (arc_dimension, "ARC_DIMENSION", "is_partial", &is_partial, NULL)
        && is_partial == arc_dimension->is_partial)
      pass ();
    else
      fail ("ARC_DIMENSION.is_partial [B] " FORMAT_B " != " FORMAT_B "", arc_dimension->is_partial, is_partial);
    is_partial++;
    if (dwg_dynapi_entity_set_value (arc_dimension, "ARC_DIMENSION", "is_partial", &is_partial, 0)
        && is_partial == arc_dimension->is_partial)
      pass ();
    else
      fail ("ARC_DIMENSION.is_partial [B] set+1 " FORMAT_B " != " FORMAT_B "", arc_dimension->is_partial, is_partial);
    arc_dimension->is_partial--;
  }
  {
    BITCODE_3BD leader1_pt;
    if (dwg_dynapi_entity_value (arc_dimension, "ARC_DIMENSION", "leader1_pt", &leader1_pt, NULL)
        && !memcmp (&leader1_pt, &arc_dimension->leader1_pt, sizeof (BITCODE_3BD)))
        pass ();
    else
        fail ("ARC_DIMENSION.leader1_pt [3BD]");
  }
  {
    BITCODE_3BD leader2_pt;
    if (dwg_dynapi_entity_value (arc_dimension, "ARC_DIMENSION", "leader2_pt", &leader2_pt, NULL)
        && !memcmp (&leader2_pt, &arc_dimension->leader2_pt, sizeof (BITCODE_3BD)))
        pass ();
    else
        fail ("ARC_DIMENSION.leader2_pt [3BD]");
  }
  {
    BITCODE_BD lspace_factor;
    if (dwg_dynapi_entity_value (arc_dimension, "ARC_DIMENSION", "lspace_factor", &lspace_factor, NULL)
        && lspace_factor == arc_dimension->lspace_factor)
      pass ();
    else
      fail ("ARC_DIMENSION.lspace_factor [BD] %g != %g", arc_dimension->lspace_factor, lspace_factor);
    lspace_factor++;
    if (dwg_dynapi_entity_set_value (arc_dimension, "ARC_DIMENSION", "lspace_factor", &lspace_factor, 0)
        && lspace_factor == arc_dimension->lspace_factor)
      pass ();
    else
      fail ("ARC_DIMENSION.lspace_factor [BD] set+1 %g != %g", arc_dimension->lspace_factor, lspace_factor);
    arc_dimension->lspace_factor--;
  }
  {
    BITCODE_BS lspace_style;
    if (dwg_dynapi_entity_value (arc_dimension, "ARC_DIMENSION", "lspace_style", &lspace_style, NULL)
        && lspace_style == arc_dimension->lspace_style)
      pass ();
    else
      fail ("ARC_DIMENSION.lspace_style [BS] %hu != %hu", arc_dimension->lspace_style, lspace_style);
    lspace_style++;
    if (dwg_dynapi_entity_set_value (arc_dimension, "ARC_DIMENSION", "lspace_style", &lspace_style, 0)
        && lspace_style == arc_dimension->lspace_style)
      pass ();
    else
      fail ("ARC_DIMENSION.lspace_style [BS] set+1 %hu != %hu", arc_dimension->lspace_style, lspace_style);
    arc_dimension->lspace_style--;
  }
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value (arc_dimension, "ARC_DIMENSION", "parent", &parent, NULL)
        && !memcmp (&parent, &arc_dimension->parent, sizeof (struct _dwg_object_entity*)))
        pass ();
    else
        fail ("ARC_DIMENSION.parent [struct _dwg_object_entity*]");
  }
  {
    BITCODE_2RD text_midpt;
    if (dwg_dynapi_entity_value (arc_dimension, "ARC_DIMENSION", "text_midpt", &text_midpt, NULL)
        && !memcmp (&text_midpt, &arc_dimension->text_midpt, sizeof (BITCODE_2RD)))
        pass ();
    else
        fail ("ARC_DIMENSION.text_midpt [2RD]");
  }
  {
    BITCODE_BD text_rotation;
    if (dwg_dynapi_entity_value (arc_dimension, "ARC_DIMENSION", "text_rotation", &text_rotation, NULL)
        && text_rotation == arc_dimension->text_rotation)
      pass ();
    else
      fail ("ARC_DIMENSION.text_rotation [BD] %g != %g", arc_dimension->text_rotation, text_rotation);
    text_rotation++;
    if (dwg_dynapi_entity_set_value (arc_dimension, "ARC_DIMENSION", "text_rotation", &text_rotation, 0)
        && text_rotation == arc_dimension->text_rotation)
      pass ();
    else
      fail ("ARC_DIMENSION.text_rotation [BD] set+1 %g != %g", arc_dimension->text_rotation, text_rotation);
    arc_dimension->text_rotation--;
  }
  {
    BITCODE_B unknown;
    if (dwg_dynapi_entity_value (arc_dimension, "ARC_DIMENSION", "unknown", &unknown, NULL)
        && unknown == arc_dimension->unknown)
      pass ();
    else
      fail ("ARC_DIMENSION.unknown [B] " FORMAT_B " != " FORMAT_B "", arc_dimension->unknown, unknown);
    unknown++;
    if (dwg_dynapi_entity_set_value (arc_dimension, "ARC_DIMENSION", "unknown", &unknown, 0)
        && unknown == arc_dimension->unknown)
      pass ();
    else
      fail ("ARC_DIMENSION.unknown [B] set+1 " FORMAT_B " != " FORMAT_B "", arc_dimension->unknown, unknown);
    arc_dimension->unknown--;
  }
  {
    BITCODE_TV user_text;
    if (dwg_dynapi_entity_value (arc_dimension, "ARC_DIMENSION", "user_text", &user_text, NULL)
        && user_text
           ? strEQ ((char *)user_text, (char *)arc_dimension->user_text)
           : !arc_dimension->user_text)
      pass ();
    else
      fail ("ARC_DIMENSION.user_text [TV] '%s' <> '%s'", user_text, arc_dimension->user_text);
  }
  {
    BITCODE_3BD xline1_pt;
    if (dwg_dynapi_entity_value (arc_dimension, "ARC_DIMENSION", "xline1_pt", &xline1_pt, NULL)
        && !memcmp (&xline1_pt, &arc_dimension->xline1_pt, sizeof (BITCODE_3BD)))
        pass ();
    else
        fail ("ARC_DIMENSION.xline1_pt [3BD]");
  }
  {
    BITCODE_3BD xline2_pt;
    if (dwg_dynapi_entity_value (arc_dimension, "ARC_DIMENSION", "xline2_pt", &xline2_pt, NULL)
        && !memcmp (&xline2_pt, &arc_dimension->xline2_pt, sizeof (BITCODE_3BD)))
        pass ();
    else
        fail ("ARC_DIMENSION.xline2_pt [3BD]");
  }
  if (failed && (is_class_unstable ("ARC_DIMENSION") || is_class_debugging ("ARC_DIMENSION")))
    {
      ok ("%s failed %d tests (TODO unstable)", "ARC_DIMENSION", failed);
      failed = 0;
    }
  return failed;
}
static int test_ATEXT (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_ATEXT *restrict atext = obj->tio.entity->tio.ATEXT;
  failed = 0;
  {
    BITCODE_BS alignment;
    if (dwg_dynapi_entity_value (atext, "ATEXT", "alignment", &alignment, NULL)
        && alignment == atext->alignment)
      pass ();
    else
      fail ("ATEXT.alignment [BS] %hu != %hu", atext->alignment, alignment);
    alignment++;
    if (dwg_dynapi_entity_set_value (atext, "ATEXT", "alignment", &alignment, 0)
        && alignment == atext->alignment)
      pass ();
    else
      fail ("ATEXT.alignment [BS] set+1 %hu != %hu", atext->alignment, alignment);
    atext->alignment--;
  }
  {
    BITCODE_H arc_handle;
    if (dwg_dynapi_entity_value (atext, "ATEXT", "arc_handle", &arc_handle, NULL)
        && !memcmp (&arc_handle, &atext->arc_handle, sizeof (BITCODE_H)))
        pass ();
    else
        fail ("ATEXT.arc_handle [H]");
  }
  {
    BITCODE_BS bs1;
    if (dwg_dynapi_entity_value (atext, "ATEXT", "bs1", &bs1, NULL)
        && bs1 == atext->bs1)
      pass ();
    else
      fail ("ATEXT.bs1 [BS] %hu != %hu", atext->bs1, bs1);
    bs1++;
    if (dwg_dynapi_entity_set_value (atext, "ATEXT", "bs1", &bs1, 0)
        && bs1 == atext->bs1)
      pass ();
    else
      fail ("ATEXT.bs1 [BS] set+1 %hu != %hu", atext->bs1, bs1);
    atext->bs1--;
  }
  {
    BITCODE_BS bs2;
    if (dwg_dynapi_entity_value (atext, "ATEXT", "bs2", &bs2, NULL)
        && bs2 == atext->bs2)
      pass ();
    else
      fail ("ATEXT.bs2 [BS] %hu != %hu", atext->bs2, bs2);
    bs2++;
    if (dwg_dynapi_entity_set_value (atext, "ATEXT", "bs2", &bs2, 0)
        && bs2 == atext->bs2)
      pass ();
    else
      fail ("ATEXT.bs2 [BS] set+1 %hu != %hu", atext->bs2, bs2);
    atext->bs2--;
  }
  {
    BITCODE_3BD center;
    if (dwg_dynapi_entity_value (atext, "ATEXT", "center", &center, NULL)
        && !memcmp (&center, &atext->center, sizeof (BITCODE_3BD)))
        pass ();
    else
        fail ("ATEXT.center [3BD]");
  }
  {
    BITCODE_D2T char_spacing;
    if (dwg_dynapi_entity_value (atext, "ATEXT", "char_spacing", &char_spacing, NULL)
        && char_spacing == atext->char_spacing)
      pass ();
    else
      fail ("ATEXT.char_spacing [D2T] %s != %s", atext->char_spacing, char_spacing);
    if (dwg_dynapi_entity_set_value (atext, "ATEXT", "char_spacing", &char_spacing, 0)
        && char_spacing == atext->char_spacing)
      pass ();
    else
      fail ("ATEXT.char_spacing [D2T] set+1 %s != %s", atext->char_spacing, char_spacing);
    atext->char_spacing--;
  }
  {
    BITCODE_BL color;
    if (dwg_dynapi_entity_value (atext, "ATEXT", "color", &color, NULL)
        && color == atext->color)
      pass ();
    else
      fail ("ATEXT.color [BL] %u != %u", atext->color, color);
    color++;
    if (dwg_dynapi_entity_set_value (atext, "ATEXT", "color", &color, 0)
        && color == atext->color)
      pass ();
    else
      fail ("ATEXT.color [BL] set+1 %u != %u", atext->color, color);
    atext->color--;
  }
  {
    BITCODE_BD end_angle;
    if (dwg_dynapi_entity_value (atext, "ATEXT", "end_angle", &end_angle, NULL)
        && end_angle == atext->end_angle)
      pass ();
    else
      fail ("ATEXT.end_angle [BD] %g != %g", atext->end_angle, end_angle);
    end_angle++;
    if (dwg_dynapi_entity_set_value (atext, "ATEXT", "end_angle", &end_angle, 0)
        && end_angle == atext->end_angle)
      pass ();
    else
      fail ("ATEXT.end_angle [BD] set+1 %g != %g", atext->end_angle, end_angle);
    atext->end_angle--;
  }
  {
    BITCODE_3BD extrusion;
    if (dwg_dynapi_entity_value (atext, "ATEXT", "extrusion", &extrusion, NULL)
        && !memcmp (&extrusion, &atext->extrusion, sizeof (BITCODE_3BD)))
        pass ();
    else
        fail ("ATEXT.extrusion [3BD]");
  }
  {
    BITCODE_BS font;
    if (dwg_dynapi_entity_value (atext, "ATEXT", "font", &font, NULL)
        && font == atext->font)
      pass ();
    else
      fail ("ATEXT.font [BS] %hu != %hu", atext->font, font);
    font++;
    if (dwg_dynapi_entity_set_value (atext, "ATEXT", "font", &font, 0)
        && font == atext->font)
      pass ();
    else
      fail ("ATEXT.font [BS] set+1 %hu != %hu", atext->font, font);
    atext->font--;
  }
  {
    BITCODE_BS font_19;
    if (dwg_dynapi_entity_value (atext, "ATEXT", "font_19", &font_19, NULL)
        && font_19 == atext->font_19)
      pass ();
    else
      fail ("ATEXT.font_19 [BS] %hu != %hu", atext->font_19, font_19);
    font_19++;
    if (dwg_dynapi_entity_set_value (atext, "ATEXT", "font_19", &font_19, 0)
        && font_19 == atext->font_19)
      pass ();
    else
      fail ("ATEXT.font_19 [BS] set+1 %hu != %hu", atext->font_19, font_19);
    atext->font_19--;
  }
  {
    BITCODE_BS is_reverse;
    if (dwg_dynapi_entity_value (atext, "ATEXT", "is_reverse", &is_reverse, NULL)
        && is_reverse == atext->is_reverse)
      pass ();
    else
      fail ("ATEXT.is_reverse [BS] %hu != %hu", atext->is_reverse, is_reverse);
    is_reverse++;
    if (dwg_dynapi_entity_set_value (atext, "ATEXT", "is_reverse", &is_reverse, 0)
        && is_reverse == atext->is_reverse)
      pass ();
    else
      fail ("ATEXT.is_reverse [BS] set+1 %hu != %hu", atext->is_reverse, is_reverse);
    atext->is_reverse--;
  }
  {
    BITCODE_BS is_shx;
    if (dwg_dynapi_entity_value (atext, "ATEXT", "is_shx", &is_shx, NULL)
        && is_shx == atext->is_shx)
      pass ();
    else
      fail ("ATEXT.is_shx [BS] %hu != %hu", atext->is_shx, is_shx);
    is_shx++;
    if (dwg_dynapi_entity_set_value (atext, "ATEXT", "is_shx", &is_shx, 0)
        && is_shx == atext->is_shx)
      pass ();
    else
      fail ("ATEXT.is_shx [BS] set+1 %hu != %hu", atext->is_shx, is_shx);
    atext->is_shx--;
  }
  {
    BITCODE_BS is_underlined;
    if (dwg_dynapi_entity_value (atext, "ATEXT", "is_underlined", &is_underlined, NULL)
        && is_underlined == atext->is_underlined)
      pass ();
    else
      fail ("ATEXT.is_underlined [BS] %hu != %hu", atext->is_underlined, is_underlined);
    is_underlined++;
    if (dwg_dynapi_entity_set_value (atext, "ATEXT", "is_underlined", &is_underlined, 0)
        && is_underlined == atext->is_underlined)
      pass ();
    else
      fail ("ATEXT.is_underlined [BS] set+1 %hu != %hu", atext->is_underlined, is_underlined);
    atext->is_underlined--;
  }
  {
    BITCODE_D2T left_offset;
    if (dwg_dynapi_entity_value (atext, "ATEXT", "left_offset", &left_offset, NULL)
        && left_offset == atext->left_offset)
      pass ();
    else
      fail ("ATEXT.left_offset [D2T] %s != %s", atext->left_offset, left_offset);
    if (dwg_dynapi_entity_set_value (atext, "ATEXT", "left_offset", &left_offset, 0)
        && left_offset == atext->left_offset)
      pass ();
    else
      fail ("ATEXT.left_offset [D2T] set+1 %s != %s", atext->left_offset, left_offset);
    atext->left_offset--;
  }
  {
    BITCODE_D2T offset_from_arc;
    if (dwg_dynapi_entity_value (atext, "ATEXT", "offset_from_arc", &offset_from_arc, NULL)
        && offset_from_arc == atext->offset_from_arc)
      pass ();
    else
      fail ("ATEXT.offset_from_arc [D2T] %s != %s", atext->offset_from_arc, offset_from_arc);
    if (dwg_dynapi_entity_set_value (atext, "ATEXT", "offset_from_arc", &offset_from_arc, 0)
        && offset_from_arc == atext->offset_from_arc)
      pass ();
    else
      fail ("ATEXT.offset_from_arc [D2T] set+1 %s != %s", atext->offset_from_arc, offset_from_arc);
    atext->offset_from_arc--;
  }
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value (atext, "ATEXT", "parent", &parent, NULL)
        && !memcmp (&parent, &atext->parent, sizeof (struct _dwg_object_entity*)))
        pass ();
    else
        fail ("ATEXT.parent [struct _dwg_object_entity*]");
  }
  {
    BITCODE_BD radius;
    if (dwg_dynapi_entity_value (atext, "ATEXT", "radius", &radius, NULL)
        && radius == atext->radius)
      pass ();
    else
      fail ("ATEXT.radius [BD] %g != %g", atext->radius, radius);
    radius++;
    if (dwg_dynapi_entity_set_value (atext, "ATEXT", "radius", &radius, 0)
        && radius == atext->radius)
      pass ();
    else
      fail ("ATEXT.radius [BD] set+1 %g != %g", atext->radius, radius);
    atext->radius--;
  }
  {
    BITCODE_D2T right_offset;
    if (dwg_dynapi_entity_value (atext, "ATEXT", "right_offset", &right_offset, NULL)
        && right_offset == atext->right_offset)
      pass ();
    else
      fail ("ATEXT.right_offset [D2T] %s != %s", atext->right_offset, right_offset);
    if (dwg_dynapi_entity_set_value (atext, "ATEXT", "right_offset", &right_offset, 0)
        && right_offset == atext->right_offset)
      pass ();
    else
      fail ("ATEXT.right_offset [D2T] set+1 %s != %s", atext->right_offset, right_offset);
    atext->right_offset--;
  }
  {
    BITCODE_BD start_angle;
    if (dwg_dynapi_entity_value (atext, "ATEXT", "start_angle", &start_angle, NULL)
        && start_angle == atext->start_angle)
      pass ();
    else
      fail ("ATEXT.start_angle [BD] %g != %g", atext->start_angle, start_angle);
    start_angle++;
    if (dwg_dynapi_entity_set_value (atext, "ATEXT", "start_angle", &start_angle, 0)
        && start_angle == atext->start_angle)
      pass ();
    else
      fail ("ATEXT.start_angle [BD] set+1 %g != %g", atext->start_angle, start_angle);
    atext->start_angle--;
  }
  {
    BITCODE_T style;
    if (dwg_dynapi_entity_value (atext, "ATEXT", "style", &style, NULL)
        && style
           ? strEQ ((char *)style, (char *)atext->style)
           : !atext->style)
      pass ();
    else
      fail ("ATEXT.style [T] '%s' <> '%s'", style, atext->style);
  }
  {
    BITCODE_T t2;
    if (dwg_dynapi_entity_value (atext, "ATEXT", "t2", &t2, NULL)
        && t2
           ? strEQ ((char *)t2, (char *)atext->t2)
           : !atext->t2)
      pass ();
    else
      fail ("ATEXT.t2 [T] '%s' <> '%s'", t2, atext->t2);
  }
  {
    BITCODE_T t3;
    if (dwg_dynapi_entity_value (atext, "ATEXT", "t3", &t3, NULL)
        && t3
           ? strEQ ((char *)t3, (char *)atext->t3)
           : !atext->t3)
      pass ();
    else
      fail ("ATEXT.t3 [T] '%s' <> '%s'", t3, atext->t3);
  }
  {
    BITCODE_BS text_direction;
    if (dwg_dynapi_entity_value (atext, "ATEXT", "text_direction", &text_direction, NULL)
        && text_direction == atext->text_direction)
      pass ();
    else
      fail ("ATEXT.text_direction [BS] %hu != %hu", atext->text_direction, text_direction);
    text_direction++;
    if (dwg_dynapi_entity_set_value (atext, "ATEXT", "text_direction", &text_direction, 0)
        && text_direction == atext->text_direction)
      pass ();
    else
      fail ("ATEXT.text_direction [BS] set+1 %hu != %hu", atext->text_direction, text_direction);
    atext->text_direction--;
  }
  {
    BITCODE_BS text_position;
    if (dwg_dynapi_entity_value (atext, "ATEXT", "text_position", &text_position, NULL)
        && text_position == atext->text_position)
      pass ();
    else
      fail ("ATEXT.text_position [BS] %hu != %hu", atext->text_position, text_position);
    text_position++;
    if (dwg_dynapi_entity_set_value (atext, "ATEXT", "text_position", &text_position, 0)
        && text_position == atext->text_position)
      pass ();
    else
      fail ("ATEXT.text_position [BS] set+1 %hu != %hu", atext->text_position, text_position);
    atext->text_position--;
  }
  {
    BITCODE_D2T text_size;
    if (dwg_dynapi_entity_value (atext, "ATEXT", "text_size", &text_size, NULL)
        && text_size == atext->text_size)
      pass ();
    else
      fail ("ATEXT.text_size [D2T] %s != %s", atext->text_size, text_size);
    if (dwg_dynapi_entity_set_value (atext, "ATEXT", "text_size", &text_size, 0)
        && text_size == atext->text_size)
      pass ();
    else
      fail ("ATEXT.text_size [D2T] set+1 %s != %s", atext->text_size, text_size);
    atext->text_size--;
  }
  {
    BITCODE_T text_value;
    if (dwg_dynapi_entity_value (atext, "ATEXT", "text_value", &text_value, NULL)
        && text_value
           ? strEQ ((char *)text_value, (char *)atext->text_value)
           : !atext->text_value)
      pass ();
    else
      fail ("ATEXT.text_value [T] '%s' <> '%s'", text_value, atext->text_value);
  }
  {
    BITCODE_BS wizard_flag;
    if (dwg_dynapi_entity_value (atext, "ATEXT", "wizard_flag", &wizard_flag, NULL)
        && wizard_flag == atext->wizard_flag)
      pass ();
    else
      fail ("ATEXT.wizard_flag [BS] %hu != %hu", atext->wizard_flag, wizard_flag);
    wizard_flag++;
    if (dwg_dynapi_entity_set_value (atext, "ATEXT", "wizard_flag", &wizard_flag, 0)
        && wizard_flag == atext->wizard_flag)
      pass ();
    else
      fail ("ATEXT.wizard_flag [BS] set+1 %hu != %hu", atext->wizard_flag, wizard_flag);
    atext->wizard_flag--;
  }
  {
    BITCODE_D2T xscale;
    if (dwg_dynapi_entity_value (atext, "ATEXT", "xscale", &xscale, NULL)
        && xscale == atext->xscale)
      pass ();
    else
      fail ("ATEXT.xscale [D2T] %s != %s", atext->xscale, xscale);
    if (dwg_dynapi_entity_set_value (atext, "ATEXT", "xscale", &xscale, 0)
        && xscale == atext->xscale)
      pass ();
    else
      fail ("ATEXT.xscale [D2T] set+1 %s != %s", atext->xscale, xscale);
    atext->xscale--;
  }
  if (failed && (is_class_unstable ("ATEXT") || is_class_debugging ("ATEXT")))
    {
      ok ("%s failed %d tests (TODO unstable)", "ATEXT", failed);
      failed = 0;
    }
  return failed;
}
static int test_ATTDEF (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_ATTDEF *restrict attdef = obj->tio.entity->tio.ATTDEF;
  failed = 0;
  {
    BITCODE_2DPOINT alignment_pt;
    if (dwg_dynapi_entity_value (attdef, "ATTDEF", "alignment_pt", &alignment_pt, NULL)
        && !memcmp (&alignment_pt, &attdef->alignment_pt, sizeof (BITCODE_2DPOINT)))
        pass ();
    else
        fail ("ATTDEF.alignment_pt [2DPOINT]");
  }
  {
    BITCODE_H annotative_app;
    if (dwg_dynapi_entity_value (attdef, "ATTDEF", "annotative_app", &annotative_app, NULL)
        && !memcmp (&annotative_app, &attdef->annotative_app, sizeof (BITCODE_H)))
        pass ();
    else
        fail ("ATTDEF.annotative_app [H]");
  }
  {
    BITCODE_RC annotative_data_bytes;
    if (dwg_dynapi_entity_value (attdef, "ATTDEF", "annotative_data_bytes", &annotative_data_bytes, NULL)
        && annotative_data_bytes == attdef->annotative_data_bytes)
      pass ();
    else
      fail ("ATTDEF.annotative_data_bytes [RC] %u != %u", attdef->annotative_data_bytes, annotative_data_bytes);
    annotative_data_bytes++;
    if (dwg_dynapi_entity_set_value (attdef, "ATTDEF", "annotative_data_bytes", &annotative_data_bytes, 0)
        && annotative_data_bytes == attdef->annotative_data_bytes)
      pass ();
    else
      fail ("ATTDEF.annotative_data_bytes [RC] set+1 %u != %u", attdef->annotative_data_bytes, annotative_data_bytes);
    attdef->annotative_data_bytes--;
  }
  {
    BITCODE_BS annotative_data_size;
    if (dwg_dynapi_entity_value (attdef, "ATTDEF", "annotative_data_size", &annotative_data_size, NULL)
        && annotative_data_size == attdef->annotative_data_size)
      pass ();
    else
      fail ("ATTDEF.annotative_data_size [BS] %hu != %hu", attdef->annotative_data_size, annotative_data_size);
    annotative_data_size++;
    if (dwg_dynapi_entity_set_value (attdef, "ATTDEF", "annotative_data_size", &annotative_data_size, 0)
        && annotative_data_size == attdef->annotative_data_size)
      pass ();
    else
      fail ("ATTDEF.annotative_data_size [BS] set+1 %hu != %hu", attdef->annotative_data_size, annotative_data_size);
    attdef->annotative_data_size--;
  }
  {
    BITCODE_BS annotative_short;
    if (dwg_dynapi_entity_value (attdef, "ATTDEF", "annotative_short", &annotative_short, NULL)
        && annotative_short == attdef->annotative_short)
      pass ();
    else
      fail ("ATTDEF.annotative_short [BS] %hu != %hu", attdef->annotative_short, annotative_short);
    annotative_short++;
    if (dwg_dynapi_entity_set_value (attdef, "ATTDEF", "annotative_short", &annotative_short, 0)
        && annotative_short == attdef->annotative_short)
      pass ();
    else
      fail ("ATTDEF.annotative_short [BS] set+1 %hu != %hu", attdef->annotative_short, annotative_short);
    attdef->annotative_short--;
  }
  {
    BITCODE_RC attdef_class_version;
    if (dwg_dynapi_entity_value (attdef, "ATTDEF", "attdef_class_version", &attdef_class_version, NULL)
        && attdef_class_version == attdef->attdef_class_version)
      pass ();
    else
      fail ("ATTDEF.attdef_class_version [RC] %u != %u", attdef->attdef_class_version, attdef_class_version);
    attdef_class_version++;
    if (dwg_dynapi_entity_set_value (attdef, "ATTDEF", "attdef_class_version", &attdef_class_version, 0)
        && attdef_class_version == attdef->attdef_class_version)
      pass ();
    else
      fail ("ATTDEF.attdef_class_version [RC] set+1 %u != %u", attdef->attdef_class_version, attdef_class_version);
    attdef->attdef_class_version--;
  }
  {
    BITCODE_RC class_version;
    if (dwg_dynapi_entity_value (attdef, "ATTDEF", "class_version", &class_version, NULL)
        && class_version == attdef->class_version)
      pass ();
    else
      fail ("ATTDEF.class_version [RC] %u != %u", attdef->class_version, class_version);
    class_version++;
    if (dwg_dynapi_entity_set_value (attdef, "ATTDEF", "class_version", &class_version, 0)
        && class_version == attdef->class_version)
      pass ();
    else
      fail ("ATTDEF.class_version [RC] set+1 %u != %u", attdef->class_version, class_version);
    attdef->class_version--;
  }
  {
    BITCODE_RC dataflags;
    if (dwg_dynapi_entity_value (attdef, "ATTDEF", "dataflags", &dataflags, NULL)
        && dataflags == attdef->dataflags)
      pass ();
    else
      fail ("ATTDEF.dataflags [RC] %u != %u", attdef->dataflags, dataflags);
    dataflags++;
    if (dwg_dynapi_entity_set_value (attdef, "ATTDEF", "dataflags", &dataflags, 0)
        && dataflags == attdef->dataflags)
      pass ();
    else
      fail ("ATTDEF.dataflags [RC] set+1 %u != %u", attdef->dataflags, dataflags);
    attdef->dataflags--;
  }
  {
    BITCODE_T default_value;
    if (dwg_dynapi_entity_value (attdef, "ATTDEF", "default_value", &default_value, NULL)
        && default_value
           ? strEQ ((char *)default_value, (char *)attdef->default_value)
           : !attdef->default_value)
      pass ();
    else
      fail ("ATTDEF.default_value [T] '%s' <> '%s'", default_value, attdef->default_value);
  }
  {
    BITCODE_BD elevation;
    if (dwg_dynapi_entity_value (attdef, "ATTDEF", "elevation", &elevation, NULL)
        && elevation == attdef->elevation)
      pass ();
    else
      fail ("ATTDEF.elevation [BD] %g != %g", attdef->elevation, elevation);
    elevation++;
    if (dwg_dynapi_entity_set_value (attdef, "ATTDEF", "elevation", &elevation, 0)
        && elevation == attdef->elevation)
      pass ();
    else
      fail ("ATTDEF.elevation [BD] set+1 %g != %g", attdef->elevation, elevation);
    attdef->elevation--;
  }
  {
    BITCODE_BE extrusion;
    if (dwg_dynapi_entity_value (attdef, "ATTDEF", "extrusion", &extrusion, NULL)
        && !memcmp (&extrusion, &attdef->extrusion, sizeof (BITCODE_BE)))
        pass ();
    else
        fail ("ATTDEF.extrusion [BE]");
  }
  {
    BITCODE_BS field_length;
    if (dwg_dynapi_entity_value (attdef, "ATTDEF", "field_length", &field_length, NULL)
        && field_length == attdef->field_length)
      pass ();
    else
      fail ("ATTDEF.field_length [BS] %hu != %hu", attdef->field_length, field_length);
    field_length++;
    if (dwg_dynapi_entity_set_value (attdef, "ATTDEF", "field_length", &field_length, 0)
        && field_length == attdef->field_length)
      pass ();
    else
      fail ("ATTDEF.field_length [BS] set+1 %hu != %hu", attdef->field_length, field_length);
    attdef->field_length--;
  }
  {
    BITCODE_RC flags;
    if (dwg_dynapi_entity_value (attdef, "ATTDEF", "flags", &flags, NULL)
        && flags == attdef->flags)
      pass ();
    else
      fail ("ATTDEF.flags [RC] %u != %u", attdef->flags, flags);
    flags++;
    if (dwg_dynapi_entity_set_value (attdef, "ATTDEF", "flags", &flags, 0)
        && flags == attdef->flags)
      pass ();
    else
      fail ("ATTDEF.flags [RC] set+1 %u != %u", attdef->flags, flags);
    attdef->flags--;
  }
  {
    BITCODE_BS generation;
    if (dwg_dynapi_entity_value (attdef, "ATTDEF", "generation", &generation, NULL)
        && generation == attdef->generation)
      pass ();
    else
      fail ("ATTDEF.generation [BS] %hu != %hu", attdef->generation, generation);
    generation++;
    if (dwg_dynapi_entity_set_value (attdef, "ATTDEF", "generation", &generation, 0)
        && generation == attdef->generation)
      pass ();
    else
      fail ("ATTDEF.generation [BS] set+1 %hu != %hu", attdef->generation, generation);
    attdef->generation--;
  }
  {
    BITCODE_RD height;
    if (dwg_dynapi_entity_value (attdef, "ATTDEF", "height", &height, NULL)
        && height == attdef->height)
      pass ();
    else
      fail ("ATTDEF.height [RD] %g != %g", attdef->height, height);
    height++;
    if (dwg_dynapi_entity_set_value (attdef, "ATTDEF", "height", &height, 0)
        && height == attdef->height)
      pass ();
    else
      fail ("ATTDEF.height [RD] set+1 %g != %g", attdef->height, height);
    attdef->height--;
  }
  {
    BITCODE_BS horiz_alignment;
    if (dwg_dynapi_entity_value (attdef, "ATTDEF", "horiz_alignment", &horiz_alignment, NULL)
        && horiz_alignment == attdef->horiz_alignment)
      pass ();
    else
      fail ("ATTDEF.horiz_alignment [BS] %hu != %hu", attdef->horiz_alignment, horiz_alignment);
    horiz_alignment++;
    if (dwg_dynapi_entity_set_value (attdef, "ATTDEF", "horiz_alignment", &horiz_alignment, 0)
        && horiz_alignment == attdef->horiz_alignment)
      pass ();
    else
      fail ("ATTDEF.horiz_alignment [BS] set+1 %hu != %hu", attdef->horiz_alignment, horiz_alignment);
    attdef->horiz_alignment--;
  }
  {
    BITCODE_2DPOINT ins_pt;
    if (dwg_dynapi_entity_value (attdef, "ATTDEF", "ins_pt", &ins_pt, NULL)
        && !memcmp (&ins_pt, &attdef->ins_pt, sizeof (BITCODE_2DPOINT)))
        pass ();
    else
        fail ("ATTDEF.ins_pt [2DPOINT]");
  }
  {
    BITCODE_B lock_position_flag;
    if (dwg_dynapi_entity_value (attdef, "ATTDEF", "lock_position_flag", &lock_position_flag, NULL)
        && lock_position_flag == attdef->lock_position_flag)
      pass ();
    else
      fail ("ATTDEF.lock_position_flag [B] " FORMAT_B " != " FORMAT_B "", attdef->lock_position_flag, lock_position_flag);
    lock_position_flag++;
    if (dwg_dynapi_entity_set_value (attdef, "ATTDEF", "lock_position_flag", &lock_position_flag, 0)
        && lock_position_flag == attdef->lock_position_flag)
      pass ();
    else
      fail ("ATTDEF.lock_position_flag [B] set+1 " FORMAT_B " != " FORMAT_B "", attdef->lock_position_flag, lock_position_flag);
    attdef->lock_position_flag--;
  }
  {
    BITCODE_H mtext_handles;
    if (dwg_dynapi_entity_value (attdef, "ATTDEF", "mtext_handles", &mtext_handles, NULL)
        && !memcmp (&mtext_handles, &attdef->mtext_handles, sizeof (BITCODE_H)))
        pass ();
    else
        fail ("ATTDEF.mtext_handles [H]");
  }
  {
    BITCODE_RD oblique_angle;
    if (dwg_dynapi_entity_value (attdef, "ATTDEF", "oblique_angle", &oblique_angle, NULL)
        && oblique_angle == attdef->oblique_angle)
      pass ();
    else
      fail ("ATTDEF.oblique_angle [RD] %g != %g", attdef->oblique_angle, oblique_angle);
    oblique_angle++;
    if (dwg_dynapi_entity_set_value (attdef, "ATTDEF", "oblique_angle", &oblique_angle, 0)
        && oblique_angle == attdef->oblique_angle)
      pass ();
    else
      fail ("ATTDEF.oblique_angle [RD] set+1 %g != %g", attdef->oblique_angle, oblique_angle);
    attdef->oblique_angle--;
  }
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value (attdef, "ATTDEF", "parent", &parent, NULL)
        && !memcmp (&parent, &attdef->parent, sizeof (struct _dwg_object_entity*)))
        pass ();
    else
        fail ("ATTDEF.parent [struct _dwg_object_entity*]");
  }
  {
    BITCODE_T prompt;
    if (dwg_dynapi_entity_value (attdef, "ATTDEF", "prompt", &prompt, NULL)
        && prompt
           ? strEQ ((char *)prompt, (char *)attdef->prompt)
           : !attdef->prompt)
      pass ();
    else
      fail ("ATTDEF.prompt [T] '%s' <> '%s'", prompt, attdef->prompt);
  }
  {
    BITCODE_RD rotation;
    if (dwg_dynapi_entity_value (attdef, "ATTDEF", "rotation", &rotation, NULL)
        && rotation == attdef->rotation)
      pass ();
    else
      fail ("ATTDEF.rotation [RD] %g != %g", attdef->rotation, rotation);
    rotation++;
    if (dwg_dynapi_entity_set_value (attdef, "ATTDEF", "rotation", &rotation, 0)
        && rotation == attdef->rotation)
      pass ();
    else
      fail ("ATTDEF.rotation [RD] set+1 %g != %g", attdef->rotation, rotation);
    attdef->rotation--;
  }
  {
    BITCODE_H style;
    if (dwg_dynapi_entity_value (attdef, "ATTDEF", "style", &style, NULL)
        && !memcmp (&style, &attdef->style, sizeof (BITCODE_H)))
        pass ();
    else
        fail ("ATTDEF.style [H]");
  }
  {
    BITCODE_T tag;
    if (dwg_dynapi_entity_value (attdef, "ATTDEF", "tag", &tag, NULL)
        && tag
           ? strEQ ((char *)tag, (char *)attdef->tag)
           : !attdef->tag)
      pass ();
    else
      fail ("ATTDEF.tag [T] '%s' <> '%s'", tag, attdef->tag);
  }
  {
    BITCODE_RD thickness;
    if (dwg_dynapi_entity_value (attdef, "ATTDEF", "thickness", &thickness, NULL)
        && thickness == attdef->thickness)
      pass ();
    else
      fail ("ATTDEF.thickness [RD] %g != %g", attdef->thickness, thickness);
    thickness++;
    if (dwg_dynapi_entity_set_value (attdef, "ATTDEF", "thickness", &thickness, 0)
        && thickness == attdef->thickness)
      pass ();
    else
      fail ("ATTDEF.thickness [RD] set+1 %g != %g", attdef->thickness, thickness);
    attdef->thickness--;
  }
  {
    BITCODE_RC type;
    if (dwg_dynapi_entity_value (attdef, "ATTDEF", "type", &type, NULL)
        && type == attdef->type)
      pass ();
    else
      fail ("ATTDEF.type [RC] %u != %u", attdef->type, type);
    type++;
    if (dwg_dynapi_entity_set_value (attdef, "ATTDEF", "type", &type, 0)
        && type == attdef->type)
      pass ();
    else
      fail ("ATTDEF.type [RC] set+1 %u != %u", attdef->type, type);
    attdef->type--;
  }
  {
    BITCODE_BS vert_alignment;
    if (dwg_dynapi_entity_value (attdef, "ATTDEF", "vert_alignment", &vert_alignment, NULL)
        && vert_alignment == attdef->vert_alignment)
      pass ();
    else
      fail ("ATTDEF.vert_alignment [BS] %hu != %hu", attdef->vert_alignment, vert_alignment);
    vert_alignment++;
    if (dwg_dynapi_entity_set_value (attdef, "ATTDEF", "vert_alignment", &vert_alignment, 0)
        && vert_alignment == attdef->vert_alignment)
      pass ();
    else
      fail ("ATTDEF.vert_alignment [BS] set+1 %hu != %hu", attdef->vert_alignment, vert_alignment);
    attdef->vert_alignment--;
  }
  {
    BITCODE_RD width_factor;
    if (dwg_dynapi_entity_value (attdef, "ATTDEF", "width_factor", &width_factor, NULL)
        && width_factor == attdef->width_factor)
      pass ();
    else
      fail ("ATTDEF.width_factor [RD] %g != %g", attdef->width_factor, width_factor);
    width_factor++;
    if (dwg_dynapi_entity_set_value (attdef, "ATTDEF", "width_factor", &width_factor, 0)
        && width_factor == attdef->width_factor)
      pass ();
    else
      fail ("ATTDEF.width_factor [RD] set+1 %g != %g", attdef->width_factor, width_factor);
    attdef->width_factor--;
  }
  if (failed && (is_class_unstable ("ATTDEF") || is_class_debugging ("ATTDEF")))
    {
      ok ("%s failed %d tests (TODO unstable)", "ATTDEF", failed);
      failed = 0;
    }
  return failed;
}
static int test_ATTRIB (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_ATTRIB *restrict attrib = obj->tio.entity->tio.ATTRIB;
  failed = 0;
  {
    BITCODE_2DPOINT alignment_pt;
    if (dwg_dynapi_entity_value (attrib, "ATTRIB", "alignment_pt", &alignment_pt, NULL)
        && !memcmp (&alignment_pt, &attrib->alignment_pt, sizeof (BITCODE_2DPOINT)))
        pass ();
    else
        fail ("ATTRIB.alignment_pt [2DPOINT]");
  }
  {
    BITCODE_H annotative_app;
    if (dwg_dynapi_entity_value (attrib, "ATTRIB", "annotative_app", &annotative_app, NULL)
        && !memcmp (&annotative_app, &attrib->annotative_app, sizeof (BITCODE_H)))
        pass ();
    else
        fail ("ATTRIB.annotative_app [H]");
  }
  {
    BITCODE_RC annotative_data_bytes;
    if (dwg_dynapi_entity_value (attrib, "ATTRIB", "annotative_data_bytes", &annotative_data_bytes, NULL)
        && annotative_data_bytes == attrib->annotative_data_bytes)
      pass ();
    else
      fail ("ATTRIB.annotative_data_bytes [RC] %u != %u", attrib->annotative_data_bytes, annotative_data_bytes);
    annotative_data_bytes++;
    if (dwg_dynapi_entity_set_value (attrib, "ATTRIB", "annotative_data_bytes", &annotative_data_bytes, 0)
        && annotative_data_bytes == attrib->annotative_data_bytes)
      pass ();
    else
      fail ("ATTRIB.annotative_data_bytes [RC] set+1 %u != %u", attrib->annotative_data_bytes, annotative_data_bytes);
    attrib->annotative_data_bytes--;
  }
  {
    BITCODE_BS annotative_data_size;
    if (dwg_dynapi_entity_value (attrib, "ATTRIB", "annotative_data_size", &annotative_data_size, NULL)
        && annotative_data_size == attrib->annotative_data_size)
      pass ();
    else
      fail ("ATTRIB.annotative_data_size [BS] %hu != %hu", attrib->annotative_data_size, annotative_data_size);
    annotative_data_size++;
    if (dwg_dynapi_entity_set_value (attrib, "ATTRIB", "annotative_data_size", &annotative_data_size, 0)
        && annotative_data_size == attrib->annotative_data_size)
      pass ();
    else
      fail ("ATTRIB.annotative_data_size [BS] set+1 %hu != %hu", attrib->annotative_data_size, annotative_data_size);
    attrib->annotative_data_size--;
  }
  {
    BITCODE_BS annotative_short;
    if (dwg_dynapi_entity_value (attrib, "ATTRIB", "annotative_short", &annotative_short, NULL)
        && annotative_short == attrib->annotative_short)
      pass ();
    else
      fail ("ATTRIB.annotative_short [BS] %hu != %hu", attrib->annotative_short, annotative_short);
    annotative_short++;
    if (dwg_dynapi_entity_set_value (attrib, "ATTRIB", "annotative_short", &annotative_short, 0)
        && annotative_short == attrib->annotative_short)
      pass ();
    else
      fail ("ATTRIB.annotative_short [BS] set+1 %hu != %hu", attrib->annotative_short, annotative_short);
    attrib->annotative_short--;
  }
  {
    BITCODE_RC class_version;
    if (dwg_dynapi_entity_value (attrib, "ATTRIB", "class_version", &class_version, NULL)
        && class_version == attrib->class_version)
      pass ();
    else
      fail ("ATTRIB.class_version [RC] %u != %u", attrib->class_version, class_version);
    class_version++;
    if (dwg_dynapi_entity_set_value (attrib, "ATTRIB", "class_version", &class_version, 0)
        && class_version == attrib->class_version)
      pass ();
    else
      fail ("ATTRIB.class_version [RC] set+1 %u != %u", attrib->class_version, class_version);
    attrib->class_version--;
  }
  {
    BITCODE_RC dataflags;
    if (dwg_dynapi_entity_value (attrib, "ATTRIB", "dataflags", &dataflags, NULL)
        && dataflags == attrib->dataflags)
      pass ();
    else
      fail ("ATTRIB.dataflags [RC] %u != %u", attrib->dataflags, dataflags);
    dataflags++;
    if (dwg_dynapi_entity_set_value (attrib, "ATTRIB", "dataflags", &dataflags, 0)
        && dataflags == attrib->dataflags)
      pass ();
    else
      fail ("ATTRIB.dataflags [RC] set+1 %u != %u", attrib->dataflags, dataflags);
    attrib->dataflags--;
  }
  {
    BITCODE_BD elevation;
    if (dwg_dynapi_entity_value (attrib, "ATTRIB", "elevation", &elevation, NULL)
        && elevation == attrib->elevation)
      pass ();
    else
      fail ("ATTRIB.elevation [BD] %g != %g", attrib->elevation, elevation);
    elevation++;
    if (dwg_dynapi_entity_set_value (attrib, "ATTRIB", "elevation", &elevation, 0)
        && elevation == attrib->elevation)
      pass ();
    else
      fail ("ATTRIB.elevation [BD] set+1 %g != %g", attrib->elevation, elevation);
    attrib->elevation--;
  }
  {
    BITCODE_BE extrusion;
    if (dwg_dynapi_entity_value (attrib, "ATTRIB", "extrusion", &extrusion, NULL)
        && !memcmp (&extrusion, &attrib->extrusion, sizeof (BITCODE_BE)))
        pass ();
    else
        fail ("ATTRIB.extrusion [BE]");
  }
  {
    BITCODE_BS field_length;
    if (dwg_dynapi_entity_value (attrib, "ATTRIB", "field_length", &field_length, NULL)
        && field_length == attrib->field_length)
      pass ();
    else
      fail ("ATTRIB.field_length [BS] %hu != %hu", attrib->field_length, field_length);
    field_length++;
    if (dwg_dynapi_entity_set_value (attrib, "ATTRIB", "field_length", &field_length, 0)
        && field_length == attrib->field_length)
      pass ();
    else
      fail ("ATTRIB.field_length [BS] set+1 %hu != %hu", attrib->field_length, field_length);
    attrib->field_length--;
  }
  {
    BITCODE_RC flags;
    if (dwg_dynapi_entity_value (attrib, "ATTRIB", "flags", &flags, NULL)
        && flags == attrib->flags)
      pass ();
    else
      fail ("ATTRIB.flags [RC] %u != %u", attrib->flags, flags);
    flags++;
    if (dwg_dynapi_entity_set_value (attrib, "ATTRIB", "flags", &flags, 0)
        && flags == attrib->flags)
      pass ();
    else
      fail ("ATTRIB.flags [RC] set+1 %u != %u", attrib->flags, flags);
    attrib->flags--;
  }
  {
    BITCODE_BS generation;
    if (dwg_dynapi_entity_value (attrib, "ATTRIB", "generation", &generation, NULL)
        && generation == attrib->generation)
      pass ();
    else
      fail ("ATTRIB.generation [BS] %hu != %hu", attrib->generation, generation);
    generation++;
    if (dwg_dynapi_entity_set_value (attrib, "ATTRIB", "generation", &generation, 0)
        && generation == attrib->generation)
      pass ();
    else
      fail ("ATTRIB.generation [BS] set+1 %hu != %hu", attrib->generation, generation);
    attrib->generation--;
  }
  {
    BITCODE_RD height;
    if (dwg_dynapi_entity_value (attrib, "ATTRIB", "height", &height, NULL)
        && height == attrib->height)
      pass ();
    else
      fail ("ATTRIB.height [RD] %g != %g", attrib->height, height);
    height++;
    if (dwg_dynapi_entity_set_value (attrib, "ATTRIB", "height", &height, 0)
        && height == attrib->height)
      pass ();
    else
      fail ("ATTRIB.height [RD] set+1 %g != %g", attrib->height, height);
    attrib->height--;
  }
  {
    BITCODE_BS horiz_alignment;
    if (dwg_dynapi_entity_value (attrib, "ATTRIB", "horiz_alignment", &horiz_alignment, NULL)
        && horiz_alignment == attrib->horiz_alignment)
      pass ();
    else
      fail ("ATTRIB.horiz_alignment [BS] %hu != %hu", attrib->horiz_alignment, horiz_alignment);
    horiz_alignment++;
    if (dwg_dynapi_entity_set_value (attrib, "ATTRIB", "horiz_alignment", &horiz_alignment, 0)
        && horiz_alignment == attrib->horiz_alignment)
      pass ();
    else
      fail ("ATTRIB.horiz_alignment [BS] set+1 %hu != %hu", attrib->horiz_alignment, horiz_alignment);
    attrib->horiz_alignment--;
  }
  {
    BITCODE_2DPOINT ins_pt;
    if (dwg_dynapi_entity_value (attrib, "ATTRIB", "ins_pt", &ins_pt, NULL)
        && !memcmp (&ins_pt, &attrib->ins_pt, sizeof (BITCODE_2DPOINT)))
        pass ();
    else
        fail ("ATTRIB.ins_pt [2DPOINT]");
  }
  {
    BITCODE_B lock_position_flag;
    if (dwg_dynapi_entity_value (attrib, "ATTRIB", "lock_position_flag", &lock_position_flag, NULL)
        && lock_position_flag == attrib->lock_position_flag)
      pass ();
    else
      fail ("ATTRIB.lock_position_flag [B] " FORMAT_B " != " FORMAT_B "", attrib->lock_position_flag, lock_position_flag);
    lock_position_flag++;
    if (dwg_dynapi_entity_set_value (attrib, "ATTRIB", "lock_position_flag", &lock_position_flag, 0)
        && lock_position_flag == attrib->lock_position_flag)
      pass ();
    else
      fail ("ATTRIB.lock_position_flag [B] set+1 " FORMAT_B " != " FORMAT_B "", attrib->lock_position_flag, lock_position_flag);
    attrib->lock_position_flag--;
  }
  {
    BITCODE_H mtext_handles;
    if (dwg_dynapi_entity_value (attrib, "ATTRIB", "mtext_handles", &mtext_handles, NULL)
        && !memcmp (&mtext_handles, &attrib->mtext_handles, sizeof (BITCODE_H)))
        pass ();
    else
        fail ("ATTRIB.mtext_handles [H]");
  }
  {
    BITCODE_RD oblique_angle;
    if (dwg_dynapi_entity_value (attrib, "ATTRIB", "oblique_angle", &oblique_angle, NULL)
        && oblique_angle == attrib->oblique_angle)
      pass ();
    else
      fail ("ATTRIB.oblique_angle [RD] %g != %g", attrib->oblique_angle, oblique_angle);
    oblique_angle++;
    if (dwg_dynapi_entity_set_value (attrib, "ATTRIB", "oblique_angle", &oblique_angle, 0)
        && oblique_angle == attrib->oblique_angle)
      pass ();
    else
      fail ("ATTRIB.oblique_angle [RD] set+1 %g != %g", attrib->oblique_angle, oblique_angle);
    attrib->oblique_angle--;
  }
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value (attrib, "ATTRIB", "parent", &parent, NULL)
        && !memcmp (&parent, &attrib->parent, sizeof (struct _dwg_object_entity*)))
        pass ();
    else
        fail ("ATTRIB.parent [struct _dwg_object_entity*]");
  }
  {
    BITCODE_RD rotation;
    if (dwg_dynapi_entity_value (attrib, "ATTRIB", "rotation", &rotation, NULL)
        && rotation == attrib->rotation)
      pass ();
    else
      fail ("ATTRIB.rotation [RD] %g != %g", attrib->rotation, rotation);
    rotation++;
    if (dwg_dynapi_entity_set_value (attrib, "ATTRIB", "rotation", &rotation, 0)
        && rotation == attrib->rotation)
      pass ();
    else
      fail ("ATTRIB.rotation [RD] set+1 %g != %g", attrib->rotation, rotation);
    attrib->rotation--;
  }
  {
    BITCODE_H style;
    if (dwg_dynapi_entity_value (attrib, "ATTRIB", "style", &style, NULL)
        && !memcmp (&style, &attrib->style, sizeof (BITCODE_H)))
        pass ();
    else
        fail ("ATTRIB.style [H]");
  }
  {
    BITCODE_T tag;
    if (dwg_dynapi_entity_value (attrib, "ATTRIB", "tag", &tag, NULL)
        && tag
           ? strEQ ((char *)tag, (char *)attrib->tag)
           : !attrib->tag)
      pass ();
    else
      fail ("ATTRIB.tag [T] '%s' <> '%s'", tag, attrib->tag);
  }
  {
    BITCODE_T text_value;
    if (dwg_dynapi_entity_value (attrib, "ATTRIB", "text_value", &text_value, NULL)
        && text_value
           ? strEQ ((char *)text_value, (char *)attrib->text_value)
           : !attrib->text_value)
      pass ();
    else
      fail ("ATTRIB.text_value [T] '%s' <> '%s'", text_value, attrib->text_value);
  }
  {
    BITCODE_RD thickness;
    if (dwg_dynapi_entity_value (attrib, "ATTRIB", "thickness", &thickness, NULL)
        && thickness == attrib->thickness)
      pass ();
    else
      fail ("ATTRIB.thickness [RD] %g != %g", attrib->thickness, thickness);
    thickness++;
    if (dwg_dynapi_entity_set_value (attrib, "ATTRIB", "thickness", &thickness, 0)
        && thickness == attrib->thickness)
      pass ();
    else
      fail ("ATTRIB.thickness [RD] set+1 %g != %g", attrib->thickness, thickness);
    attrib->thickness--;
  }
  {
    BITCODE_RC type;
    if (dwg_dynapi_entity_value (attrib, "ATTRIB", "type", &type, NULL)
        && type == attrib->type)
      pass ();
    else
      fail ("ATTRIB.type [RC] %u != %u", attrib->type, type);
    type++;
    if (dwg_dynapi_entity_set_value (attrib, "ATTRIB", "type", &type, 0)
        && type == attrib->type)
      pass ();
    else
      fail ("ATTRIB.type [RC] set+1 %u != %u", attrib->type, type);
    attrib->type--;
  }
  {
    BITCODE_BS vert_alignment;
    if (dwg_dynapi_entity_value (attrib, "ATTRIB", "vert_alignment", &vert_alignment, NULL)
        && vert_alignment == attrib->vert_alignment)
      pass ();
    else
      fail ("ATTRIB.vert_alignment [BS] %hu != %hu", attrib->vert_alignment, vert_alignment);
    vert_alignment++;
    if (dwg_dynapi_entity_set_value (attrib, "ATTRIB", "vert_alignment", &vert_alignment, 0)
        && vert_alignment == attrib->vert_alignment)
      pass ();
    else
      fail ("ATTRIB.vert_alignment [BS] set+1 %hu != %hu", attrib->vert_alignment, vert_alignment);
    attrib->vert_alignment--;
  }
  {
    BITCODE_RD width_factor;
    if (dwg_dynapi_entity_value (attrib, "ATTRIB", "width_factor", &width_factor, NULL)
        && width_factor == attrib->width_factor)
      pass ();
    else
      fail ("ATTRIB.width_factor [RD] %g != %g", attrib->width_factor, width_factor);
    width_factor++;
    if (dwg_dynapi_entity_set_value (attrib, "ATTRIB", "width_factor", &width_factor, 0)
        && width_factor == attrib->width_factor)
      pass ();
    else
      fail ("ATTRIB.width_factor [RD] set+1 %g != %g", attrib->width_factor, width_factor);
    attrib->width_factor--;
  }
  if (failed && (is_class_unstable ("ATTRIB") || is_class_debugging ("ATTRIB")))
    {
      ok ("%s failed %d tests (TODO unstable)", "ATTRIB", failed);
      failed = 0;
    }
  return failed;
}
static int test_BASEPOINTPARAMETERENTITY (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_BASEPOINTPARAMETERENTITY *restrict basepointparameterentity = obj->tio.entity->tio.BASEPOINTPARAMETERENTITY;
  failed = 0;
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value (basepointparameterentity, "BASEPOINTPARAMETERENTITY", "parent", &parent, NULL)
        && !memcmp (&parent, &basepointparameterentity->parent, sizeof (struct _dwg_object_entity*)))
        pass ();
    else
        fail ("BASEPOINTPARAMETERENTITY.parent [struct _dwg_object_entity*]");
  }
  if (failed && (is_class_unstable ("BASEPOINTPARAMETERENTITY") || is_class_debugging ("BASEPOINTPARAMETERENTITY")))
    {
      ok ("%s failed %d tests (TODO unstable)", "BASEPOINTPARAMETERENTITY", failed);
      failed = 0;
    }
  return failed;
}
static int test_BLOCK (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_BLOCK *restrict block = obj->tio.entity->tio.BLOCK;
  failed = 0;
  {
    BITCODE_T filename;
    if (dwg_dynapi_entity_value (block, "BLOCK", "filename", &filename, NULL)
        && filename
           ? strEQ ((char *)filename, (char *)block->filename)
           : !block->filename)
      pass ();
    else
      fail ("BLOCK.filename [T] '%s' <> '%s'", filename, block->filename);
  }
  {
    BITCODE_T name;
    if (dwg_dynapi_entity_value (block, "BLOCK", "name", &name, NULL)
        && name
           ? strEQ ((char *)name, (char *)block->name)
           : !block->name)
      pass ();
    else
      fail ("BLOCK.name [T] '%s' <> '%s'", name, block->name);
  }
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value (block, "BLOCK", "parent", &parent, NULL)
        && !memcmp (&parent, &block->parent, sizeof (struct _dwg_object_entity*)))
        pass ();
    else
        fail ("BLOCK.parent [struct _dwg_object_entity*]");
  }
  if (failed && (is_class_unstable ("BLOCK") || is_class_debugging ("BLOCK")))
    {
      ok ("%s failed %d tests (TODO unstable)", "BLOCK", failed);
      failed = 0;
    }
  return failed;
}
static int test_BODY (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_BODY *restrict body = obj->tio.entity->tio.BODY;
  failed = 0;
  if (failed && (is_class_unstable ("BODY") || is_class_debugging ("BODY")))
    {
      ok ("%s failed %d tests (TODO unstable)", "BODY", failed);
      failed = 0;
    }
  return failed;
}
static int test_CAMERA (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_CAMERA *restrict camera = obj->tio.entity->tio.CAMERA;
  failed = 0;
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value (camera, "CAMERA", "parent", &parent, NULL)
        && !memcmp (&parent, &camera->parent, sizeof (struct _dwg_object_entity*)))
        pass ();
    else
        fail ("CAMERA.parent [struct _dwg_object_entity*]");
  }
  {
    BITCODE_H view;
    if (dwg_dynapi_entity_value (camera, "CAMERA", "view", &view, NULL)
        && !memcmp (&view, &camera->view, sizeof (BITCODE_H)))
        pass ();
    else
        fail ("CAMERA.view [H]");
  }
  if (failed && (is_class_unstable ("CAMERA") || is_class_debugging ("CAMERA")))
    {
      ok ("%s failed %d tests (TODO unstable)", "CAMERA", failed);
      failed = 0;
    }
  return failed;
}
static int test_CIRCLE (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_CIRCLE *restrict circle = obj->tio.entity->tio.CIRCLE;
  failed = 0;
  {
    BITCODE_3BD center;
    if (dwg_dynapi_entity_value (circle, "CIRCLE", "center", &center, NULL)
        && !memcmp (&center, &circle->center, sizeof (BITCODE_3BD)))
        pass ();
    else
        fail ("CIRCLE.center [3BD]");
  }
  {
    BITCODE_BE extrusion;
    if (dwg_dynapi_entity_value (circle, "CIRCLE", "extrusion", &extrusion, NULL)
        && !memcmp (&extrusion, &circle->extrusion, sizeof (BITCODE_BE)))
        pass ();
    else
        fail ("CIRCLE.extrusion [BE]");
  }
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value (circle, "CIRCLE", "parent", &parent, NULL)
        && !memcmp (&parent, &circle->parent, sizeof (struct _dwg_object_entity*)))
        pass ();
    else
        fail ("CIRCLE.parent [struct _dwg_object_entity*]");
  }
  {
    BITCODE_BD radius;
    if (dwg_dynapi_entity_value (circle, "CIRCLE", "radius", &radius, NULL)
        && radius == circle->radius)
      pass ();
    else
      fail ("CIRCLE.radius [BD] %g != %g", circle->radius, radius);
    radius++;
    if (dwg_dynapi_entity_set_value (circle, "CIRCLE", "radius", &radius, 0)
        && radius == circle->radius)
      pass ();
    else
      fail ("CIRCLE.radius [BD] set+1 %g != %g", circle->radius, radius);
    circle->radius--;
  }
  {
    BITCODE_BT thickness;
    if (dwg_dynapi_entity_value (circle, "CIRCLE", "thickness", &thickness, NULL)
        && thickness == circle->thickness)
      pass ();
    else
      fail ("CIRCLE.thickness [BT] " FORMAT_BT " != " FORMAT_BT "", circle->thickness, thickness);
    if (dwg_dynapi_entity_set_value (circle, "CIRCLE", "thickness", &thickness, 0)
        && thickness == circle->thickness)
      pass ();
    else
      fail ("CIRCLE.thickness [BT] set+1 " FORMAT_BT " != " FORMAT_BT "", circle->thickness, thickness);
    circle->thickness--;
  }
  if (failed && (is_class_unstable ("CIRCLE") || is_class_debugging ("CIRCLE")))
    {
      ok ("%s failed %d tests (TODO unstable)", "CIRCLE", failed);
      failed = 0;
    }
  return failed;
}
static int test_DIMENSION_ALIGNED (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_DIMENSION_ALIGNED *restrict dimension_aligned = obj->tio.entity->tio.DIMENSION_ALIGNED;
  failed = 0;
  {
    BITCODE_BD act_measurement;
    if (dwg_dynapi_entity_value (dimension_aligned, "DIMENSION_ALIGNED", "act_measurement", &act_measurement, NULL)
        && act_measurement == dimension_aligned->act_measurement)
      pass ();
    else
      fail ("DIMENSION_ALIGNED.act_measurement [BD] %g != %g", dimension_aligned->act_measurement, act_measurement);
    act_measurement++;
    if (dwg_dynapi_entity_set_value (dimension_aligned, "DIMENSION_ALIGNED", "act_measurement", &act_measurement, 0)
        && act_measurement == dimension_aligned->act_measurement)
      pass ();
    else
      fail ("DIMENSION_ALIGNED.act_measurement [BD] set+1 %g != %g", dimension_aligned->act_measurement, act_measurement);
    dimension_aligned->act_measurement--;
  }
  {
    BITCODE_BS attachment;
    if (dwg_dynapi_entity_value (dimension_aligned, "DIMENSION_ALIGNED", "attachment", &attachment, NULL)
        && attachment == dimension_aligned->attachment)
      pass ();
    else
      fail ("DIMENSION_ALIGNED.attachment [BS] %hu != %hu", dimension_aligned->attachment, attachment);
    attachment++;
    if (dwg_dynapi_entity_set_value (dimension_aligned, "DIMENSION_ALIGNED", "attachment", &attachment, 0)
        && attachment == dimension_aligned->attachment)
      pass ();
    else
      fail ("DIMENSION_ALIGNED.attachment [BS] set+1 %hu != %hu", dimension_aligned->attachment, attachment);
    dimension_aligned->attachment--;
  }
  {
    BITCODE_H block;
    if (dwg_dynapi_entity_value (dimension_aligned, "DIMENSION_ALIGNED", "block", &block, NULL)
        && !memcmp (&block, &dimension_aligned->block, sizeof (BITCODE_H)))
        pass ();
    else
        fail ("DIMENSION_ALIGNED.block [H]");
  }
  {
    BITCODE_TV blockname;
    if (dwg_dynapi_entity_value (dimension_aligned, "DIMENSION_ALIGNED", "blockname", &blockname, NULL)
        && blockname
           ? strEQ ((char *)blockname, (char *)dimension_aligned->blockname)
           : !dimension_aligned->blockname)
      pass ();
    else
      fail ("DIMENSION_ALIGNED.blockname [TV] '%s' <> '%s'", blockname, dimension_aligned->blockname);
  }
  {
    BITCODE_RC class_version;
    if (dwg_dynapi_entity_value (dimension_aligned, "DIMENSION_ALIGNED", "class_version", &class_version, NULL)
        && class_version == dimension_aligned->class_version)
      pass ();
    else
      fail ("DIMENSION_ALIGNED.class_version [RC] %u != %u", dimension_aligned->class_version, class_version);
    class_version++;
    if (dwg_dynapi_entity_set_value (dimension_aligned, "DIMENSION_ALIGNED", "class_version", &class_version, 0)
        && class_version == dimension_aligned->class_version)
      pass ();
    else
      fail ("DIMENSION_ALIGNED.class_version [RC] set+1 %u != %u", dimension_aligned->class_version, class_version);
    dimension_aligned->class_version--;
  }
  {
    BITCODE_2RD clone_ins_pt;
    if (dwg_dynapi_entity_value (dimension_aligned, "DIMENSION_ALIGNED", "clone_ins_pt", &clone_ins_pt, NULL)
        && !memcmp (&clone_ins_pt, &dimension_aligned->clone_ins_pt, sizeof (BITCODE_2RD)))
        pass ();
    else
        fail ("DIMENSION_ALIGNED.clone_ins_pt [2RD]");
  }
  {
    BITCODE_3BD def_pt;
    if (dwg_dynapi_entity_value (dimension_aligned, "DIMENSION_ALIGNED", "def_pt", &def_pt, NULL)
        && !memcmp (&def_pt, &dimension_aligned->def_pt, sizeof (BITCODE_3BD)))
        pass ();
    else
        fail ("DIMENSION_ALIGNED.def_pt [3BD]");
  }
  {
    BITCODE_H dimstyle;
    if (dwg_dynapi_entity_value (dimension_aligned, "DIMENSION_ALIGNED", "dimstyle", &dimstyle, NULL)
        && !memcmp (&dimstyle, &dimension_aligned->dimstyle, sizeof (BITCODE_H)))
        pass ();
    else
        fail ("DIMENSION_ALIGNED.dimstyle [H]");
  }
  {
    BITCODE_BD elevation;
    if (dwg_dynapi_entity_value (dimension_aligned, "DIMENSION_ALIGNED", "elevation", &elevation, NULL)
        && elevation == dimension_aligned->elevation)
      pass ();
    else
      fail ("DIMENSION_ALIGNED.elevation [BD] %g != %g", dimension_aligned->elevation, elevation);
    elevation++;
    if (dwg_dynapi_entity_set_value (dimension_aligned, "DIMENSION_ALIGNED", "elevation", &elevation, 0)
        && elevation == dimension_aligned->elevation)
      pass ();
    else
      fail ("DIMENSION_ALIGNED.elevation [BD] set+1 %g != %g", dimension_aligned->elevation, elevation);
    dimension_aligned->elevation--;
  }
  {
    BITCODE_BE extrusion;
    if (dwg_dynapi_entity_value (dimension_aligned, "DIMENSION_ALIGNED", "extrusion", &extrusion, NULL)
        && !memcmp (&extrusion, &dimension_aligned->extrusion, sizeof (BITCODE_BE)))
        pass ();
    else
        fail ("DIMENSION_ALIGNED.extrusion [BE]");
  }
  {
    BITCODE_RC flag;
    if (dwg_dynapi_entity_value (dimension_aligned, "DIMENSION_ALIGNED", "flag", &flag, NULL)
        && flag == dimension_aligned->flag)
      pass ();
    else
      fail ("DIMENSION_ALIGNED.flag [RC] %u != %u", dimension_aligned->flag, flag);
    flag++;
    if (dwg_dynapi_entity_set_value (dimension_aligned, "DIMENSION_ALIGNED", "flag", &flag, 0)
        && flag == dimension_aligned->flag)
      pass ();
    else
      fail ("DIMENSION_ALIGNED.flag [RC] set+1 %u != %u", dimension_aligned->flag, flag);
    dimension_aligned->flag--;
  }
  {
    BITCODE_RC flag1;
    if (dwg_dynapi_entity_value (dimension_aligned, "DIMENSION_ALIGNED", "flag1", &flag1, NULL)
        && flag1 == dimension_aligned->flag1)
      pass ();
    else
      fail ("DIMENSION_ALIGNED.flag1 [RC] %u != %u", dimension_aligned->flag1, flag1);
    flag1++;
    if (dwg_dynapi_entity_set_value (dimension_aligned, "DIMENSION_ALIGNED", "flag1", &flag1, 0)
        && flag1 == dimension_aligned->flag1)
      pass ();
    else
      fail ("DIMENSION_ALIGNED.flag1 [RC] set+1 %u != %u", dimension_aligned->flag1, flag1);
    dimension_aligned->flag1--;
  }
  {
    BITCODE_B flip_arrow1;
    if (dwg_dynapi_entity_value (dimension_aligned, "DIMENSION_ALIGNED", "flip_arrow1", &flip_arrow1, NULL)
        && flip_arrow1 == dimension_aligned->flip_arrow1)
      pass ();
    else
      fail ("DIMENSION_ALIGNED.flip_arrow1 [B] " FORMAT_B " != " FORMAT_B "", dimension_aligned->flip_arrow1, flip_arrow1);
    flip_arrow1++;
    if (dwg_dynapi_entity_set_value (dimension_aligned, "DIMENSION_ALIGNED", "flip_arrow1", &flip_arrow1, 0)
        && flip_arrow1 == dimension_aligned->flip_arrow1)
      pass ();
    else
      fail ("DIMENSION_ALIGNED.flip_arrow1 [B] set+1 " FORMAT_B " != " FORMAT_B "", dimension_aligned->flip_arrow1, flip_arrow1);
    dimension_aligned->flip_arrow1--;
  }
  {
    BITCODE_B flip_arrow2;
    if (dwg_dynapi_entity_value (dimension_aligned, "DIMENSION_ALIGNED", "flip_arrow2", &flip_arrow2, NULL)
        && flip_arrow2 == dimension_aligned->flip_arrow2)
      pass ();
    else
      fail ("DIMENSION_ALIGNED.flip_arrow2 [B] " FORMAT_B " != " FORMAT_B "", dimension_aligned->flip_arrow2, flip_arrow2);
    flip_arrow2++;
    if (dwg_dynapi_entity_set_value (dimension_aligned, "DIMENSION_ALIGNED", "flip_arrow2", &flip_arrow2, 0)
        && flip_arrow2 == dimension_aligned->flip_arrow2)
      pass ();
    else
      fail ("DIMENSION_ALIGNED.flip_arrow2 [B] set+1 " FORMAT_B " != " FORMAT_B "", dimension_aligned->flip_arrow2, flip_arrow2);
    dimension_aligned->flip_arrow2--;
  }
  {
    BITCODE_BD horiz_dir;
    if (dwg_dynapi_entity_value (dimension_aligned, "DIMENSION_ALIGNED", "horiz_dir", &horiz_dir, NULL)
        && horiz_dir == dimension_aligned->horiz_dir)
      pass ();
    else
      fail ("DIMENSION_ALIGNED.horiz_dir [BD] %g != %g", dimension_aligned->horiz_dir, horiz_dir);
    horiz_dir++;
    if (dwg_dynapi_entity_set_value (dimension_aligned, "DIMENSION_ALIGNED", "horiz_dir", &horiz_dir, 0)
        && horiz_dir == dimension_aligned->horiz_dir)
      pass ();
    else
      fail ("DIMENSION_ALIGNED.horiz_dir [BD] set+1 %g != %g", dimension_aligned->horiz_dir, horiz_dir);
    dimension_aligned->horiz_dir--;
  }
  {
    BITCODE_BD ins_rotation;
    if (dwg_dynapi_entity_value (dimension_aligned, "DIMENSION_ALIGNED", "ins_rotation", &ins_rotation, NULL)
        && ins_rotation == dimension_aligned->ins_rotation)
      pass ();
    else
      fail ("DIMENSION_ALIGNED.ins_rotation [BD] %g != %g", dimension_aligned->ins_rotation, ins_rotation);
    ins_rotation++;
    if (dwg_dynapi_entity_set_value (dimension_aligned, "DIMENSION_ALIGNED", "ins_rotation", &ins_rotation, 0)
        && ins_rotation == dimension_aligned->ins_rotation)
      pass ();
    else
      fail ("DIMENSION_ALIGNED.ins_rotation [BD] set+1 %g != %g", dimension_aligned->ins_rotation, ins_rotation);
    dimension_aligned->ins_rotation--;
  }
  {
    BITCODE_3BD ins_scale;
    if (dwg_dynapi_entity_value (dimension_aligned, "DIMENSION_ALIGNED", "ins_scale", &ins_scale, NULL)
        && !memcmp (&ins_scale, &dimension_aligned->ins_scale, sizeof (BITCODE_3BD)))
        pass ();
    else
        fail ("DIMENSION_ALIGNED.ins_scale [3BD]");
  }
  {
    BITCODE_BD lspace_factor;
    if (dwg_dynapi_entity_value (dimension_aligned, "DIMENSION_ALIGNED", "lspace_factor", &lspace_factor, NULL)
        && lspace_factor == dimension_aligned->lspace_factor)
      pass ();
    else
      fail ("DIMENSION_ALIGNED.lspace_factor [BD] %g != %g", dimension_aligned->lspace_factor, lspace_factor);
    lspace_factor++;
    if (dwg_dynapi_entity_set_value (dimension_aligned, "DIMENSION_ALIGNED", "lspace_factor", &lspace_factor, 0)
        && lspace_factor == dimension_aligned->lspace_factor)
      pass ();
    else
      fail ("DIMENSION_ALIGNED.lspace_factor [BD] set+1 %g != %g", dimension_aligned->lspace_factor, lspace_factor);
    dimension_aligned->lspace_factor--;
  }
  {
    BITCODE_BS lspace_style;
    if (dwg_dynapi_entity_value (dimension_aligned, "DIMENSION_ALIGNED", "lspace_style", &lspace_style, NULL)
        && lspace_style == dimension_aligned->lspace_style)
      pass ();
    else
      fail ("DIMENSION_ALIGNED.lspace_style [BS] %hu != %hu", dimension_aligned->lspace_style, lspace_style);
    lspace_style++;
    if (dwg_dynapi_entity_set_value (dimension_aligned, "DIMENSION_ALIGNED", "lspace_style", &lspace_style, 0)
        && lspace_style == dimension_aligned->lspace_style)
      pass ();
    else
      fail ("DIMENSION_ALIGNED.lspace_style [BS] set+1 %hu != %hu", dimension_aligned->lspace_style, lspace_style);
    dimension_aligned->lspace_style--;
  }
  {
    BITCODE_BD oblique_angle;
    if (dwg_dynapi_entity_value (dimension_aligned, "DIMENSION_ALIGNED", "oblique_angle", &oblique_angle, NULL)
        && oblique_angle == dimension_aligned->oblique_angle)
      pass ();
    else
      fail ("DIMENSION_ALIGNED.oblique_angle [BD] %g != %g", dimension_aligned->oblique_angle, oblique_angle);
    oblique_angle++;
    if (dwg_dynapi_entity_set_value (dimension_aligned, "DIMENSION_ALIGNED", "oblique_angle", &oblique_angle, 0)
        && oblique_angle == dimension_aligned->oblique_angle)
      pass ();
    else
      fail ("DIMENSION_ALIGNED.oblique_angle [BD] set+1 %g != %g", dimension_aligned->oblique_angle, oblique_angle);
    dimension_aligned->oblique_angle--;
  }
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value (dimension_aligned, "DIMENSION_ALIGNED", "parent", &parent, NULL)
        && !memcmp (&parent, &dimension_aligned->parent, sizeof (struct _dwg_object_entity*)))
        pass ();
    else
        fail ("DIMENSION_ALIGNED.parent [struct _dwg_object_entity*]");
  }
  {
    BITCODE_2RD text_midpt;
    if (dwg_dynapi_entity_value (dimension_aligned, "DIMENSION_ALIGNED", "text_midpt", &text_midpt, NULL)
        && !memcmp (&text_midpt, &dimension_aligned->text_midpt, sizeof (BITCODE_2RD)))
        pass ();
    else
        fail ("DIMENSION_ALIGNED.text_midpt [2RD]");
  }
  {
    BITCODE_BD text_rotation;
    if (dwg_dynapi_entity_value (dimension_aligned, "DIMENSION_ALIGNED", "text_rotation", &text_rotation, NULL)
        && text_rotation == dimension_aligned->text_rotation)
      pass ();
    else
      fail ("DIMENSION_ALIGNED.text_rotation [BD] %g != %g", dimension_aligned->text_rotation, text_rotation);
    text_rotation++;
    if (dwg_dynapi_entity_set_value (dimension_aligned, "DIMENSION_ALIGNED", "text_rotation", &text_rotation, 0)
        && text_rotation == dimension_aligned->text_rotation)
      pass ();
    else
      fail ("DIMENSION_ALIGNED.text_rotation [BD] set+1 %g != %g", dimension_aligned->text_rotation, text_rotation);
    dimension_aligned->text_rotation--;
  }
  {
    BITCODE_B unknown;
    if (dwg_dynapi_entity_value (dimension_aligned, "DIMENSION_ALIGNED", "unknown", &unknown, NULL)
        && unknown == dimension_aligned->unknown)
      pass ();
    else
      fail ("DIMENSION_ALIGNED.unknown [B] " FORMAT_B " != " FORMAT_B "", dimension_aligned->unknown, unknown);
    unknown++;
    if (dwg_dynapi_entity_set_value (dimension_aligned, "DIMENSION_ALIGNED", "unknown", &unknown, 0)
        && unknown == dimension_aligned->unknown)
      pass ();
    else
      fail ("DIMENSION_ALIGNED.unknown [B] set+1 " FORMAT_B " != " FORMAT_B "", dimension_aligned->unknown, unknown);
    dimension_aligned->unknown--;
  }
  {
    BITCODE_TV user_text;
    if (dwg_dynapi_entity_value (dimension_aligned, "DIMENSION_ALIGNED", "user_text", &user_text, NULL)
        && user_text
           ? strEQ ((char *)user_text, (char *)dimension_aligned->user_text)
           : !dimension_aligned->user_text)
      pass ();
    else
      fail ("DIMENSION_ALIGNED.user_text [TV] '%s' <> '%s'", user_text, dimension_aligned->user_text);
  }
  {
    BITCODE_3BD xline1_pt;
    if (dwg_dynapi_entity_value (dimension_aligned, "DIMENSION_ALIGNED", "xline1_pt", &xline1_pt, NULL)
        && !memcmp (&xline1_pt, &dimension_aligned->xline1_pt, sizeof (BITCODE_3BD)))
        pass ();
    else
        fail ("DIMENSION_ALIGNED.xline1_pt [3BD]");
  }
  {
    BITCODE_3BD xline2_pt;
    if (dwg_dynapi_entity_value (dimension_aligned, "DIMENSION_ALIGNED", "xline2_pt", &xline2_pt, NULL)
        && !memcmp (&xline2_pt, &dimension_aligned->xline2_pt, sizeof (BITCODE_3BD)))
        pass ();
    else
        fail ("DIMENSION_ALIGNED.xline2_pt [3BD]");
  }
  if (failed && (is_class_unstable ("DIMENSION_ALIGNED") || is_class_debugging ("DIMENSION_ALIGNED")))
    {
      ok ("%s failed %d tests (TODO unstable)", "DIMENSION_ALIGNED", failed);
      failed = 0;
    }
  return failed;
}
static int test_DIMENSION_ANG2LN (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_DIMENSION_ANG2LN *restrict dimension_ang2ln = obj->tio.entity->tio.DIMENSION_ANG2LN;
  failed = 0;
  {
    BITCODE_BD act_measurement;
    if (dwg_dynapi_entity_value (dimension_ang2ln, "DIMENSION_ANG2LN", "act_measurement", &act_measurement, NULL)
        && act_measurement == dimension_ang2ln->act_measurement)
      pass ();
    else
      fail ("DIMENSION_ANG2LN.act_measurement [BD] %g != %g", dimension_ang2ln->act_measurement, act_measurement);
    act_measurement++;
    if (dwg_dynapi_entity_set_value (dimension_ang2ln, "DIMENSION_ANG2LN", "act_measurement", &act_measurement, 0)
        && act_measurement == dimension_ang2ln->act_measurement)
      pass ();
    else
      fail ("DIMENSION_ANG2LN.act_measurement [BD] set+1 %g != %g", dimension_ang2ln->act_measurement, act_measurement);
    dimension_ang2ln->act_measurement--;
  }
  {
    BITCODE_BS attachment;
    if (dwg_dynapi_entity_value (dimension_ang2ln, "DIMENSION_ANG2LN", "attachment", &attachment, NULL)
        && attachment == dimension_ang2ln->attachment)
      pass ();
    else
      fail ("DIMENSION_ANG2LN.attachment [BS] %hu != %hu", dimension_ang2ln->attachment, attachment);
    attachment++;
    if (dwg_dynapi_entity_set_value (dimension_ang2ln, "DIMENSION_ANG2LN", "attachment", &attachment, 0)
        && attachment == dimension_ang2ln->attachment)
      pass ();
    else
      fail ("DIMENSION_ANG2LN.attachment [BS] set+1 %hu != %hu", dimension_ang2ln->attachment, attachment);
    dimension_ang2ln->attachment--;
  }
  {
    BITCODE_H block;
    if (dwg_dynapi_entity_value (dimension_ang2ln, "DIMENSION_ANG2LN", "block", &block, NULL)
        && !memcmp (&block, &dimension_ang2ln->block, sizeof (BITCODE_H)))
        pass ();
    else
        fail ("DIMENSION_ANG2LN.block [H]");
  }
  {
    BITCODE_TV blockname;
    if (dwg_dynapi_entity_value (dimension_ang2ln, "DIMENSION_ANG2LN", "blockname", &blockname, NULL)
        && blockname
           ? strEQ ((char *)blockname, (char *)dimension_ang2ln->blockname)
           : !dimension_ang2ln->blockname)
      pass ();
    else
      fail ("DIMENSION_ANG2LN.blockname [TV] '%s' <> '%s'", blockname, dimension_ang2ln->blockname);
  }
  {
    BITCODE_RC class_version;
    if (dwg_dynapi_entity_value (dimension_ang2ln, "DIMENSION_ANG2LN", "class_version", &class_version, NULL)
        && class_version == dimension_ang2ln->class_version)
      pass ();
    else
      fail ("DIMENSION_ANG2LN.class_version [RC] %u != %u", dimension_ang2ln->class_version, class_version);
    class_version++;
    if (dwg_dynapi_entity_set_value (dimension_ang2ln, "DIMENSION_ANG2LN", "class_version", &class_version, 0)
        && class_version == dimension_ang2ln->class_version)
      pass ();
    else
      fail ("DIMENSION_ANG2LN.class_version [RC] set+1 %u != %u", dimension_ang2ln->class_version, class_version);
    dimension_ang2ln->class_version--;
  }
  {
    BITCODE_2RD clone_ins_pt;
    if (dwg_dynapi_entity_value (dimension_ang2ln, "DIMENSION_ANG2LN", "clone_ins_pt", &clone_ins_pt, NULL)
        && !memcmp (&clone_ins_pt, &dimension_ang2ln->clone_ins_pt, sizeof (BITCODE_2RD)))
        pass ();
    else
        fail ("DIMENSION_ANG2LN.clone_ins_pt [2RD]");
  }
  {
    BITCODE_3BD def_pt;
    if (dwg_dynapi_entity_value (dimension_ang2ln, "DIMENSION_ANG2LN", "def_pt", &def_pt, NULL)
        && !memcmp (&def_pt, &dimension_ang2ln->def_pt, sizeof (BITCODE_3BD)))
        pass ();
    else
        fail ("DIMENSION_ANG2LN.def_pt [3BD]");
  }
  {
    BITCODE_H dimstyle;
    if (dwg_dynapi_entity_value (dimension_ang2ln, "DIMENSION_ANG2LN", "dimstyle", &dimstyle, NULL)
        && !memcmp (&dimstyle, &dimension_ang2ln->dimstyle, sizeof (BITCODE_H)))
        pass ();
    else
        fail ("DIMENSION_ANG2LN.dimstyle [H]");
  }
  {
    BITCODE_BD elevation;
    if (dwg_dynapi_entity_value (dimension_ang2ln, "DIMENSION_ANG2LN", "elevation", &elevation, NULL)
        && elevation == dimension_ang2ln->elevation)
      pass ();
    else
      fail ("DIMENSION_ANG2LN.elevation [BD] %g != %g", dimension_ang2ln->elevation, elevation);
    elevation++;
    if (dwg_dynapi_entity_set_value (dimension_ang2ln, "DIMENSION_ANG2LN", "elevation", &elevation, 0)
        && elevation == dimension_ang2ln->elevation)
      pass ();
    else
      fail ("DIMENSION_ANG2LN.elevation [BD] set+1 %g != %g", dimension_ang2ln->elevation, elevation);
    dimension_ang2ln->elevation--;
  }
  {
    BITCODE_BE extrusion;
    if (dwg_dynapi_entity_value (dimension_ang2ln, "DIMENSION_ANG2LN", "extrusion", &extrusion, NULL)
        && !memcmp (&extrusion, &dimension_ang2ln->extrusion, sizeof (BITCODE_BE)))
        pass ();
    else
        fail ("DIMENSION_ANG2LN.extrusion [BE]");
  }
  {
    BITCODE_RC flag;
    if (dwg_dynapi_entity_value (dimension_ang2ln, "DIMENSION_ANG2LN", "flag", &flag, NULL)
        && flag == dimension_ang2ln->flag)
      pass ();
    else
      fail ("DIMENSION_ANG2LN.flag [RC] %u != %u", dimension_ang2ln->flag, flag);
    flag++;
    if (dwg_dynapi_entity_set_value (dimension_ang2ln, "DIMENSION_ANG2LN", "flag", &flag, 0)
        && flag == dimension_ang2ln->flag)
      pass ();
    else
      fail ("DIMENSION_ANG2LN.flag [RC] set+1 %u != %u", dimension_ang2ln->flag, flag);
    dimension_ang2ln->flag--;
  }
  {
    BITCODE_RC flag1;
    if (dwg_dynapi_entity_value (dimension_ang2ln, "DIMENSION_ANG2LN", "flag1", &flag1, NULL)
        && flag1 == dimension_ang2ln->flag1)
      pass ();
    else
      fail ("DIMENSION_ANG2LN.flag1 [RC] %u != %u", dimension_ang2ln->flag1, flag1);
    flag1++;
    if (dwg_dynapi_entity_set_value (dimension_ang2ln, "DIMENSION_ANG2LN", "flag1", &flag1, 0)
        && flag1 == dimension_ang2ln->flag1)
      pass ();
    else
      fail ("DIMENSION_ANG2LN.flag1 [RC] set+1 %u != %u", dimension_ang2ln->flag1, flag1);
    dimension_ang2ln->flag1--;
  }
  {
    BITCODE_B flip_arrow1;
    if (dwg_dynapi_entity_value (dimension_ang2ln, "DIMENSION_ANG2LN", "flip_arrow1", &flip_arrow1, NULL)
        && flip_arrow1 == dimension_ang2ln->flip_arrow1)
      pass ();
    else
      fail ("DIMENSION_ANG2LN.flip_arrow1 [B] " FORMAT_B " != " FORMAT_B "", dimension_ang2ln->flip_arrow1, flip_arrow1);
    flip_arrow1++;
    if (dwg_dynapi_entity_set_value (dimension_ang2ln, "DIMENSION_ANG2LN", "flip_arrow1", &flip_arrow1, 0)
        && flip_arrow1 == dimension_ang2ln->flip_arrow1)
      pass ();
    else
      fail ("DIMENSION_ANG2LN.flip_arrow1 [B] set+1 " FORMAT_B " != " FORMAT_B "", dimension_ang2ln->flip_arrow1, flip_arrow1);
    dimension_ang2ln->flip_arrow1--;
  }
  {
    BITCODE_B flip_arrow2;
    if (dwg_dynapi_entity_value (dimension_ang2ln, "DIMENSION_ANG2LN", "flip_arrow2", &flip_arrow2, NULL)
        && flip_arrow2 == dimension_ang2ln->flip_arrow2)
      pass ();
    else
      fail ("DIMENSION_ANG2LN.flip_arrow2 [B] " FORMAT_B " != " FORMAT_B "", dimension_ang2ln->flip_arrow2, flip_arrow2);
    flip_arrow2++;
    if (dwg_dynapi_entity_set_value (dimension_ang2ln, "DIMENSION_ANG2LN", "flip_arrow2", &flip_arrow2, 0)
        && flip_arrow2 == dimension_ang2ln->flip_arrow2)
      pass ();
    else
      fail ("DIMENSION_ANG2LN.flip_arrow2 [B] set+1 " FORMAT_B " != " FORMAT_B "", dimension_ang2ln->flip_arrow2, flip_arrow2);
    dimension_ang2ln->flip_arrow2--;
  }
  {
    BITCODE_BD horiz_dir;
    if (dwg_dynapi_entity_value (dimension_ang2ln, "DIMENSION_ANG2LN", "horiz_dir", &horiz_dir, NULL)
        && horiz_dir == dimension_ang2ln->horiz_dir)
      pass ();
    else
      fail ("DIMENSION_ANG2LN.horiz_dir [BD] %g != %g", dimension_ang2ln->horiz_dir, horiz_dir);
    horiz_dir++;
    if (dwg_dynapi_entity_set_value (dimension_ang2ln, "DIMENSION_ANG2LN", "horiz_dir", &horiz_dir, 0)
        && horiz_dir == dimension_ang2ln->horiz_dir)
      pass ();
    else
      fail ("DIMENSION_ANG2LN.horiz_dir [BD] set+1 %g != %g", dimension_ang2ln->horiz_dir, horiz_dir);
    dimension_ang2ln->horiz_dir--;
  }
  {
    BITCODE_BD ins_rotation;
    if (dwg_dynapi_entity_value (dimension_ang2ln, "DIMENSION_ANG2LN", "ins_rotation", &ins_rotation, NULL)
        && ins_rotation == dimension_ang2ln->ins_rotation)
      pass ();
    else
      fail ("DIMENSION_ANG2LN.ins_rotation [BD] %g != %g", dimension_ang2ln->ins_rotation, ins_rotation);
    ins_rotation++;
    if (dwg_dynapi_entity_set_value (dimension_ang2ln, "DIMENSION_ANG2LN", "ins_rotation", &ins_rotation, 0)
        && ins_rotation == dimension_ang2ln->ins_rotation)
      pass ();
    else
      fail ("DIMENSION_ANG2LN.ins_rotation [BD] set+1 %g != %g", dimension_ang2ln->ins_rotation, ins_rotation);
    dimension_ang2ln->ins_rotation--;
  }
  {
    BITCODE_3BD ins_scale;
    if (dwg_dynapi_entity_value (dimension_ang2ln, "DIMENSION_ANG2LN", "ins_scale", &ins_scale, NULL)
        && !memcmp (&ins_scale, &dimension_ang2ln->ins_scale, sizeof (BITCODE_3BD)))
        pass ();
    else
        fail ("DIMENSION_ANG2LN.ins_scale [3BD]");
  }
  {
    BITCODE_BD lspace_factor;
    if (dwg_dynapi_entity_value (dimension_ang2ln, "DIMENSION_ANG2LN", "lspace_factor", &lspace_factor, NULL)
        && lspace_factor == dimension_ang2ln->lspace_factor)
      pass ();
    else
      fail ("DIMENSION_ANG2LN.lspace_factor [BD] %g != %g", dimension_ang2ln->lspace_factor, lspace_factor);
    lspace_factor++;
    if (dwg_dynapi_entity_set_value (dimension_ang2ln, "DIMENSION_ANG2LN", "lspace_factor", &lspace_factor, 0)
        && lspace_factor == dimension_ang2ln->lspace_factor)
      pass ();
    else
      fail ("DIMENSION_ANG2LN.lspace_factor [BD] set+1 %g != %g", dimension_ang2ln->lspace_factor, lspace_factor);
    dimension_ang2ln->lspace_factor--;
  }
  {
    BITCODE_BS lspace_style;
    if (dwg_dynapi_entity_value (dimension_ang2ln, "DIMENSION_ANG2LN", "lspace_style", &lspace_style, NULL)
        && lspace_style == dimension_ang2ln->lspace_style)
      pass ();
    else
      fail ("DIMENSION_ANG2LN.lspace_style [BS] %hu != %hu", dimension_ang2ln->lspace_style, lspace_style);
    lspace_style++;
    if (dwg_dynapi_entity_set_value (dimension_ang2ln, "DIMENSION_ANG2LN", "lspace_style", &lspace_style, 0)
        && lspace_style == dimension_ang2ln->lspace_style)
      pass ();
    else
      fail ("DIMENSION_ANG2LN.lspace_style [BS] set+1 %hu != %hu", dimension_ang2ln->lspace_style, lspace_style);
    dimension_ang2ln->lspace_style--;
  }
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value (dimension_ang2ln, "DIMENSION_ANG2LN", "parent", &parent, NULL)
        && !memcmp (&parent, &dimension_ang2ln->parent, sizeof (struct _dwg_object_entity*)))
        pass ();
    else
        fail ("DIMENSION_ANG2LN.parent [struct _dwg_object_entity*]");
  }
  {
    BITCODE_2RD text_midpt;
    if (dwg_dynapi_entity_value (dimension_ang2ln, "DIMENSION_ANG2LN", "text_midpt", &text_midpt, NULL)
        && !memcmp (&text_midpt, &dimension_ang2ln->text_midpt, sizeof (BITCODE_2RD)))
        pass ();
    else
        fail ("DIMENSION_ANG2LN.text_midpt [2RD]");
  }
  {
    BITCODE_BD text_rotation;
    if (dwg_dynapi_entity_value (dimension_ang2ln, "DIMENSION_ANG2LN", "text_rotation", &text_rotation, NULL)
        && text_rotation == dimension_ang2ln->text_rotation)
      pass ();
    else
      fail ("DIMENSION_ANG2LN.text_rotation [BD] %g != %g", dimension_ang2ln->text_rotation, text_rotation);
    text_rotation++;
    if (dwg_dynapi_entity_set_value (dimension_ang2ln, "DIMENSION_ANG2LN", "text_rotation", &text_rotation, 0)
        && text_rotation == dimension_ang2ln->text_rotation)
      pass ();
    else
      fail ("DIMENSION_ANG2LN.text_rotation [BD] set+1 %g != %g", dimension_ang2ln->text_rotation, text_rotation);
    dimension_ang2ln->text_rotation--;
  }
  {
    BITCODE_B unknown;
    if (dwg_dynapi_entity_value (dimension_ang2ln, "DIMENSION_ANG2LN", "unknown", &unknown, NULL)
        && unknown == dimension_ang2ln->unknown)
      pass ();
    else
      fail ("DIMENSION_ANG2LN.unknown [B] " FORMAT_B " != " FORMAT_B "", dimension_ang2ln->unknown, unknown);
    unknown++;
    if (dwg_dynapi_entity_set_value (dimension_ang2ln, "DIMENSION_ANG2LN", "unknown", &unknown, 0)
        && unknown == dimension_ang2ln->unknown)
      pass ();
    else
      fail ("DIMENSION_ANG2LN.unknown [B] set+1 " FORMAT_B " != " FORMAT_B "", dimension_ang2ln->unknown, unknown);
    dimension_ang2ln->unknown--;
  }
  {
    BITCODE_TV user_text;
    if (dwg_dynapi_entity_value (dimension_ang2ln, "DIMENSION_ANG2LN", "user_text", &user_text, NULL)
        && user_text
           ? strEQ ((char *)user_text, (char *)dimension_ang2ln->user_text)
           : !dimension_ang2ln->user_text)
      pass ();
    else
      fail ("DIMENSION_ANG2LN.user_text [TV] '%s' <> '%s'", user_text, dimension_ang2ln->user_text);
  }
  {
    BITCODE_3BD xline1end_pt;
    if (dwg_dynapi_entity_value (dimension_ang2ln, "DIMENSION_ANG2LN", "xline1end_pt", &xline1end_pt, NULL)
        && !memcmp (&xline1end_pt, &dimension_ang2ln->xline1end_pt, sizeof (BITCODE_3BD)))
        pass ();
    else
        fail ("DIMENSION_ANG2LN.xline1end_pt [3BD]");
  }
  {
    BITCODE_3BD xline1start_pt;
    if (dwg_dynapi_entity_value (dimension_ang2ln, "DIMENSION_ANG2LN", "xline1start_pt", &xline1start_pt, NULL)
        && !memcmp (&xline1start_pt, &dimension_ang2ln->xline1start_pt, sizeof (BITCODE_3BD)))
        pass ();
    else
        fail ("DIMENSION_ANG2LN.xline1start_pt [3BD]");
  }
  {
    BITCODE_3BD xline2end_pt;
    if (dwg_dynapi_entity_value (dimension_ang2ln, "DIMENSION_ANG2LN", "xline2end_pt", &xline2end_pt, NULL)
        && !memcmp (&xline2end_pt, &dimension_ang2ln->xline2end_pt, sizeof (BITCODE_3BD)))
        pass ();
    else
        fail ("DIMENSION_ANG2LN.xline2end_pt [3BD]");
  }
  {
    BITCODE_3BD xline2start_pt;
    if (dwg_dynapi_entity_value (dimension_ang2ln, "DIMENSION_ANG2LN", "xline2start_pt", &xline2start_pt, NULL)
        && !memcmp (&xline2start_pt, &dimension_ang2ln->xline2start_pt, sizeof (BITCODE_3BD)))
        pass ();
    else
        fail ("DIMENSION_ANG2LN.xline2start_pt [3BD]");
  }
  if (failed && (is_class_unstable ("DIMENSION_ANG2LN") || is_class_debugging ("DIMENSION_ANG2LN")))
    {
      ok ("%s failed %d tests (TODO unstable)", "DIMENSION_ANG2LN", failed);
      failed = 0;
    }
  return failed;
}
static int test_DIMENSION_ANG3PT (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_DIMENSION_ANG3PT *restrict dimension_ang3pt = obj->tio.entity->tio.DIMENSION_ANG3PT;
  failed = 0;
  {
    BITCODE_BD act_measurement;
    if (dwg_dynapi_entity_value (dimension_ang3pt, "DIMENSION_ANG3PT", "act_measurement", &act_measurement, NULL)
        && act_measurement == dimension_ang3pt->act_measurement)
      pass ();
    else
      fail ("DIMENSION_ANG3PT.act_measurement [BD] %g != %g", dimension_ang3pt->act_measurement, act_measurement);
    act_measurement++;
    if (dwg_dynapi_entity_set_value (dimension_ang3pt, "DIMENSION_ANG3PT", "act_measurement", &act_measurement, 0)
        && act_measurement == dimension_ang3pt->act_measurement)
      pass ();
    else
      fail ("DIMENSION_ANG3PT.act_measurement [BD] set+1 %g != %g", dimension_ang3pt->act_measurement, act_measurement);
    dimension_ang3pt->act_measurement--;
  }
  {
    BITCODE_BS attachment;
    if (dwg_dynapi_entity_value (dimension_ang3pt, "DIMENSION_ANG3PT", "attachment", &attachment, NULL)
        && attachment == dimension_ang3pt->attachment)
      pass ();
    else
      fail ("DIMENSION_ANG3PT.attachment [BS] %hu != %hu", dimension_ang3pt->attachment, attachment);
    attachment++;
    if (dwg_dynapi_entity_set_value (dimension_ang3pt, "DIMENSION_ANG3PT", "attachment", &attachment, 0)
        && attachment == dimension_ang3pt->attachment)
      pass ();
    else
      fail ("DIMENSION_ANG3PT.attachment [BS] set+1 %hu != %hu", dimension_ang3pt->attachment, attachment);
    dimension_ang3pt->attachment--;
  }
  {
    BITCODE_H block;
    if (dwg_dynapi_entity_value (dimension_ang3pt, "DIMENSION_ANG3PT", "block", &block, NULL)
        && !memcmp (&block, &dimension_ang3pt->block, sizeof (BITCODE_H)))
        pass ();
    else
        fail ("DIMENSION_ANG3PT.block [H]");
  }
  {
    BITCODE_TV blockname;
    if (dwg_dynapi_entity_value (dimension_ang3pt, "DIMENSION_ANG3PT", "blockname", &blockname, NULL)
        && blockname
           ? strEQ ((char *)blockname, (char *)dimension_ang3pt->blockname)
           : !dimension_ang3pt->blockname)
      pass ();
    else
      fail ("DIMENSION_ANG3PT.blockname [TV] '%s' <> '%s'", blockname, dimension_ang3pt->blockname);
  }
  {
    BITCODE_3BD center_pt;
    if (dwg_dynapi_entity_value (dimension_ang3pt, "DIMENSION_ANG3PT", "center_pt", &center_pt, NULL)
        && !memcmp (&center_pt, &dimension_ang3pt->center_pt, sizeof (BITCODE_3BD)))
        pass ();
    else
        fail ("DIMENSION_ANG3PT.center_pt [3BD]");
  }
  {
    BITCODE_RC class_version;
    if (dwg_dynapi_entity_value (dimension_ang3pt, "DIMENSION_ANG3PT", "class_version", &class_version, NULL)
        && class_version == dimension_ang3pt->class_version)
      pass ();
    else
      fail ("DIMENSION_ANG3PT.class_version [RC] %u != %u", dimension_ang3pt->class_version, class_version);
    class_version++;
    if (dwg_dynapi_entity_set_value (dimension_ang3pt, "DIMENSION_ANG3PT", "class_version", &class_version, 0)
        && class_version == dimension_ang3pt->class_version)
      pass ();
    else
      fail ("DIMENSION_ANG3PT.class_version [RC] set+1 %u != %u", dimension_ang3pt->class_version, class_version);
    dimension_ang3pt->class_version--;
  }
  {
    BITCODE_2RD clone_ins_pt;
    if (dwg_dynapi_entity_value (dimension_ang3pt, "DIMENSION_ANG3PT", "clone_ins_pt", &clone_ins_pt, NULL)
        && !memcmp (&clone_ins_pt, &dimension_ang3pt->clone_ins_pt, sizeof (BITCODE_2RD)))
        pass ();
    else
        fail ("DIMENSION_ANG3PT.clone_ins_pt [2RD]");
  }
  {
    BITCODE_3BD def_pt;
    if (dwg_dynapi_entity_value (dimension_ang3pt, "DIMENSION_ANG3PT", "def_pt", &def_pt, NULL)
        && !memcmp (&def_pt, &dimension_ang3pt->def_pt, sizeof (BITCODE_3BD)))
        pass ();
    else
        fail ("DIMENSION_ANG3PT.def_pt [3BD]");
  }
  {
    BITCODE_H dimstyle;
    if (dwg_dynapi_entity_value (dimension_ang3pt, "DIMENSION_ANG3PT", "dimstyle", &dimstyle, NULL)
        && !memcmp (&dimstyle, &dimension_ang3pt->dimstyle, sizeof (BITCODE_H)))
        pass ();
    else
        fail ("DIMENSION_ANG3PT.dimstyle [H]");
  }
  {
    BITCODE_BD elevation;
    if (dwg_dynapi_entity_value (dimension_ang3pt, "DIMENSION_ANG3PT", "elevation", &elevation, NULL)
        && elevation == dimension_ang3pt->elevation)
      pass ();
    else
      fail ("DIMENSION_ANG3PT.elevation [BD] %g != %g", dimension_ang3pt->elevation, elevation);
    elevation++;
    if (dwg_dynapi_entity_set_value (dimension_ang3pt, "DIMENSION_ANG3PT", "elevation", &elevation, 0)
        && elevation == dimension_ang3pt->elevation)
      pass ();
    else
      fail ("DIMENSION_ANG3PT.elevation [BD] set+1 %g != %g", dimension_ang3pt->elevation, elevation);
    dimension_ang3pt->elevation--;
  }
  {
    BITCODE_BE extrusion;
    if (dwg_dynapi_entity_value (dimension_ang3pt, "DIMENSION_ANG3PT", "extrusion", &extrusion, NULL)
        && !memcmp (&extrusion, &dimension_ang3pt->extrusion, sizeof (BITCODE_BE)))
        pass ();
    else
        fail ("DIMENSION_ANG3PT.extrusion [BE]");
  }
  {
    BITCODE_RC flag;
    if (dwg_dynapi_entity_value (dimension_ang3pt, "DIMENSION_ANG3PT", "flag", &flag, NULL)
        && flag == dimension_ang3pt->flag)
      pass ();
    else
      fail ("DIMENSION_ANG3PT.flag [RC] %u != %u", dimension_ang3pt->flag, flag);
    flag++;
    if (dwg_dynapi_entity_set_value (dimension_ang3pt, "DIMENSION_ANG3PT", "flag", &flag, 0)
        && flag == dimension_ang3pt->flag)
      pass ();
    else
      fail ("DIMENSION_ANG3PT.flag [RC] set+1 %u != %u", dimension_ang3pt->flag, flag);
    dimension_ang3pt->flag--;
  }
  {
    BITCODE_RC flag1;
    if (dwg_dynapi_entity_value (dimension_ang3pt, "DIMENSION_ANG3PT", "flag1", &flag1, NULL)
        && flag1 == dimension_ang3pt->flag1)
      pass ();
    else
      fail ("DIMENSION_ANG3PT.flag1 [RC] %u != %u", dimension_ang3pt->flag1, flag1);
    flag1++;
    if (dwg_dynapi_entity_set_value (dimension_ang3pt, "DIMENSION_ANG3PT", "flag1", &flag1, 0)
        && flag1 == dimension_ang3pt->flag1)
      pass ();
    else
      fail ("DIMENSION_ANG3PT.flag1 [RC] set+1 %u != %u", dimension_ang3pt->flag1, flag1);
    dimension_ang3pt->flag1--;
  }
  {
    BITCODE_B flip_arrow1;
    if (dwg_dynapi_entity_value (dimension_ang3pt, "DIMENSION_ANG3PT", "flip_arrow1", &flip_arrow1, NULL)
        && flip_arrow1 == dimension_ang3pt->flip_arrow1)
      pass ();
    else
      fail ("DIMENSION_ANG3PT.flip_arrow1 [B] " FORMAT_B " != " FORMAT_B "", dimension_ang3pt->flip_arrow1, flip_arrow1);
    flip_arrow1++;
    if (dwg_dynapi_entity_set_value (dimension_ang3pt, "DIMENSION_ANG3PT", "flip_arrow1", &flip_arrow1, 0)
        && flip_arrow1 == dimension_ang3pt->flip_arrow1)
      pass ();
    else
      fail ("DIMENSION_ANG3PT.flip_arrow1 [B] set+1 " FORMAT_B " != " FORMAT_B "", dimension_ang3pt->flip_arrow1, flip_arrow1);
    dimension_ang3pt->flip_arrow1--;
  }
  {
    BITCODE_B flip_arrow2;
    if (dwg_dynapi_entity_value (dimension_ang3pt, "DIMENSION_ANG3PT", "flip_arrow2", &flip_arrow2, NULL)
        && flip_arrow2 == dimension_ang3pt->flip_arrow2)
      pass ();
    else
      fail ("DIMENSION_ANG3PT.flip_arrow2 [B] " FORMAT_B " != " FORMAT_B "", dimension_ang3pt->flip_arrow2, flip_arrow2);
    flip_arrow2++;
    if (dwg_dynapi_entity_set_value (dimension_ang3pt, "DIMENSION_ANG3PT", "flip_arrow2", &flip_arrow2, 0)
        && flip_arrow2 == dimension_ang3pt->flip_arrow2)
      pass ();
    else
      fail ("DIMENSION_ANG3PT.flip_arrow2 [B] set+1 " FORMAT_B " != " FORMAT_B "", dimension_ang3pt->flip_arrow2, flip_arrow2);
    dimension_ang3pt->flip_arrow2--;
  }
  {
    BITCODE_BD horiz_dir;
    if (dwg_dynapi_entity_value (dimension_ang3pt, "DIMENSION_ANG3PT", "horiz_dir", &horiz_dir, NULL)
        && horiz_dir == dimension_ang3pt->horiz_dir)
      pass ();
    else
      fail ("DIMENSION_ANG3PT.horiz_dir [BD] %g != %g", dimension_ang3pt->horiz_dir, horiz_dir);
    horiz_dir++;
    if (dwg_dynapi_entity_set_value (dimension_ang3pt, "DIMENSION_ANG3PT", "horiz_dir", &horiz_dir, 0)
        && horiz_dir == dimension_ang3pt->horiz_dir)
      pass ();
    else
      fail ("DIMENSION_ANG3PT.horiz_dir [BD] set+1 %g != %g", dimension_ang3pt->horiz_dir, horiz_dir);
    dimension_ang3pt->horiz_dir--;
  }
  {
    BITCODE_BD ins_rotation;
    if (dwg_dynapi_entity_value (dimension_ang3pt, "DIMENSION_ANG3PT", "ins_rotation", &ins_rotation, NULL)
        && ins_rotation == dimension_ang3pt->ins_rotation)
      pass ();
    else
      fail ("DIMENSION_ANG3PT.ins_rotation [BD] %g != %g", dimension_ang3pt->ins_rotation, ins_rotation);
    ins_rotation++;
    if (dwg_dynapi_entity_set_value (dimension_ang3pt, "DIMENSION_ANG3PT", "ins_rotation", &ins_rotation, 0)
        && ins_rotation == dimension_ang3pt->ins_rotation)
      pass ();
    else
      fail ("DIMENSION_ANG3PT.ins_rotation [BD] set+1 %g != %g", dimension_ang3pt->ins_rotation, ins_rotation);
    dimension_ang3pt->ins_rotation--;
  }
  {
    BITCODE_3BD ins_scale;
    if (dwg_dynapi_entity_value (dimension_ang3pt, "DIMENSION_ANG3PT", "ins_scale", &ins_scale, NULL)
        && !memcmp (&ins_scale, &dimension_ang3pt->ins_scale, sizeof (BITCODE_3BD)))
        pass ();
    else
        fail ("DIMENSION_ANG3PT.ins_scale [3BD]");
  }
  {
    BITCODE_BD lspace_factor;
    if (dwg_dynapi_entity_value (dimension_ang3pt, "DIMENSION_ANG3PT", "lspace_factor", &lspace_factor, NULL)
        && lspace_factor == dimension_ang3pt->lspace_factor)
      pass ();
    else
      fail ("DIMENSION_ANG3PT.lspace_factor [BD] %g != %g", dimension_ang3pt->lspace_factor, lspace_factor);
    lspace_factor++;
    if (dwg_dynapi_entity_set_value (dimension_ang3pt, "DIMENSION_ANG3PT", "lspace_factor", &lspace_factor, 0)
        && lspace_factor == dimension_ang3pt->lspace_factor)
      pass ();
    else
      fail ("DIMENSION_ANG3PT.lspace_factor [BD] set+1 %g != %g", dimension_ang3pt->lspace_factor, lspace_factor);
    dimension_ang3pt->lspace_factor--;
  }
  {
    BITCODE_BS lspace_style;
    if (dwg_dynapi_entity_value (dimension_ang3pt, "DIMENSION_ANG3PT", "lspace_style", &lspace_style, NULL)
        && lspace_style == dimension_ang3pt->lspace_style)
      pass ();
    else
      fail ("DIMENSION_ANG3PT.lspace_style [BS] %hu != %hu", dimension_ang3pt->lspace_style, lspace_style);
    lspace_style++;
    if (dwg_dynapi_entity_set_value (dimension_ang3pt, "DIMENSION_ANG3PT", "lspace_style", &lspace_style, 0)
        && lspace_style == dimension_ang3pt->lspace_style)
      pass ();
    else
      fail ("DIMENSION_ANG3PT.lspace_style [BS] set+1 %hu != %hu", dimension_ang3pt->lspace_style, lspace_style);
    dimension_ang3pt->lspace_style--;
  }
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value (dimension_ang3pt, "DIMENSION_ANG3PT", "parent", &parent, NULL)
        && !memcmp (&parent, &dimension_ang3pt->parent, sizeof (struct _dwg_object_entity*)))
        pass ();
    else
        fail ("DIMENSION_ANG3PT.parent [struct _dwg_object_entity*]");
  }
  {
    BITCODE_2RD text_midpt;
    if (dwg_dynapi_entity_value (dimension_ang3pt, "DIMENSION_ANG3PT", "text_midpt", &text_midpt, NULL)
        && !memcmp (&text_midpt, &dimension_ang3pt->text_midpt, sizeof (BITCODE_2RD)))
        pass ();
    else
        fail ("DIMENSION_ANG3PT.text_midpt [2RD]");
  }
  {
    BITCODE_BD text_rotation;
    if (dwg_dynapi_entity_value (dimension_ang3pt, "DIMENSION_ANG3PT", "text_rotation", &text_rotation, NULL)
        && text_rotation == dimension_ang3pt->text_rotation)
      pass ();
    else
      fail ("DIMENSION_ANG3PT.text_rotation [BD] %g != %g", dimension_ang3pt->text_rotation, text_rotation);
    text_rotation++;
    if (dwg_dynapi_entity_set_value (dimension_ang3pt, "DIMENSION_ANG3PT", "text_rotation", &text_rotation, 0)
        && text_rotation == dimension_ang3pt->text_rotation)
      pass ();
    else
      fail ("DIMENSION_ANG3PT.text_rotation [BD] set+1 %g != %g", dimension_ang3pt->text_rotation, text_rotation);
    dimension_ang3pt->text_rotation--;
  }
  {
    BITCODE_B unknown;
    if (dwg_dynapi_entity_value (dimension_ang3pt, "DIMENSION_ANG3PT", "unknown", &unknown, NULL)
        && unknown == dimension_ang3pt->unknown)
      pass ();
    else
      fail ("DIMENSION_ANG3PT.unknown [B] " FORMAT_B " != " FORMAT_B "", dimension_ang3pt->unknown, unknown);
    unknown++;
    if (dwg_dynapi_entity_set_value (dimension_ang3pt, "DIMENSION_ANG3PT", "unknown", &unknown, 0)
        && unknown == dimension_ang3pt->unknown)
      pass ();
    else
      fail ("DIMENSION_ANG3PT.unknown [B] set+1 " FORMAT_B " != " FORMAT_B "", dimension_ang3pt->unknown, unknown);
    dimension_ang3pt->unknown--;
  }
  {
    BITCODE_TV user_text;
    if (dwg_dynapi_entity_value (dimension_ang3pt, "DIMENSION_ANG3PT", "user_text", &user_text, NULL)
        && user_text
           ? strEQ ((char *)user_text, (char *)dimension_ang3pt->user_text)
           : !dimension_ang3pt->user_text)
      pass ();
    else
      fail ("DIMENSION_ANG3PT.user_text [TV] '%s' <> '%s'", user_text, dimension_ang3pt->user_text);
  }
  {
    BITCODE_3BD xline1_pt;
    if (dwg_dynapi_entity_value (dimension_ang3pt, "DIMENSION_ANG3PT", "xline1_pt", &xline1_pt, NULL)
        && !memcmp (&xline1_pt, &dimension_ang3pt->xline1_pt, sizeof (BITCODE_3BD)))
        pass ();
    else
        fail ("DIMENSION_ANG3PT.xline1_pt [3BD]");
  }
  {
    BITCODE_3BD xline2_pt;
    if (dwg_dynapi_entity_value (dimension_ang3pt, "DIMENSION_ANG3PT", "xline2_pt", &xline2_pt, NULL)
        && !memcmp (&xline2_pt, &dimension_ang3pt->xline2_pt, sizeof (BITCODE_3BD)))
        pass ();
    else
        fail ("DIMENSION_ANG3PT.xline2_pt [3BD]");
  }
  if (failed && (is_class_unstable ("DIMENSION_ANG3PT") || is_class_debugging ("DIMENSION_ANG3PT")))
    {
      ok ("%s failed %d tests (TODO unstable)", "DIMENSION_ANG3PT", failed);
      failed = 0;
    }
  return failed;
}
static int test_DIMENSION_DIAMETER (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_DIMENSION_DIAMETER *restrict dimension_diameter = obj->tio.entity->tio.DIMENSION_DIAMETER;
  failed = 0;
  {
    BITCODE_BD act_measurement;
    if (dwg_dynapi_entity_value (dimension_diameter, "DIMENSION_DIAMETER", "act_measurement", &act_measurement, NULL)
        && act_measurement == dimension_diameter->act_measurement)
      pass ();
    else
      fail ("DIMENSION_DIAMETER.act_measurement [BD] %g != %g", dimension_diameter->act_measurement, act_measurement);
    act_measurement++;
    if (dwg_dynapi_entity_set_value (dimension_diameter, "DIMENSION_DIAMETER", "act_measurement", &act_measurement, 0)
        && act_measurement == dimension_diameter->act_measurement)
      pass ();
    else
      fail ("DIMENSION_DIAMETER.act_measurement [BD] set+1 %g != %g", dimension_diameter->act_measurement, act_measurement);
    dimension_diameter->act_measurement--;
  }
  {
    BITCODE_BS attachment;
    if (dwg_dynapi_entity_value (dimension_diameter, "DIMENSION_DIAMETER", "attachment", &attachment, NULL)
        && attachment == dimension_diameter->attachment)
      pass ();
    else
      fail ("DIMENSION_DIAMETER.attachment [BS] %hu != %hu", dimension_diameter->attachment, attachment);
    attachment++;
    if (dwg_dynapi_entity_set_value (dimension_diameter, "DIMENSION_DIAMETER", "attachment", &attachment, 0)
        && attachment == dimension_diameter->attachment)
      pass ();
    else
      fail ("DIMENSION_DIAMETER.attachment [BS] set+1 %hu != %hu", dimension_diameter->attachment, attachment);
    dimension_diameter->attachment--;
  }
  {
    BITCODE_H block;
    if (dwg_dynapi_entity_value (dimension_diameter, "DIMENSION_DIAMETER", "block", &block, NULL)
        && !memcmp (&block, &dimension_diameter->block, sizeof (BITCODE_H)))
        pass ();
    else
        fail ("DIMENSION_DIAMETER.block [H]");
  }
  {
    BITCODE_TV blockname;
    if (dwg_dynapi_entity_value (dimension_diameter, "DIMENSION_DIAMETER", "blockname", &blockname, NULL)
        && blockname
           ? strEQ ((char *)blockname, (char *)dimension_diameter->blockname)
           : !dimension_diameter->blockname)
      pass ();
    else
      fail ("DIMENSION_DIAMETER.blockname [TV] '%s' <> '%s'", blockname, dimension_diameter->blockname);
  }
  {
    BITCODE_RC class_version;
    if (dwg_dynapi_entity_value (dimension_diameter, "DIMENSION_DIAMETER", "class_version", &class_version, NULL)
        && class_version == dimension_diameter->class_version)
      pass ();
    else
      fail ("DIMENSION_DIAMETER.class_version [RC] %u != %u", dimension_diameter->class_version, class_version);
    class_version++;
    if (dwg_dynapi_entity_set_value (dimension_diameter, "DIMENSION_DIAMETER", "class_version", &class_version, 0)
        && class_version == dimension_diameter->class_version)
      pass ();
    else
      fail ("DIMENSION_DIAMETER.class_version [RC] set+1 %u != %u", dimension_diameter->class_version, class_version);
    dimension_diameter->class_version--;
  }
  {
    BITCODE_2RD clone_ins_pt;
    if (dwg_dynapi_entity_value (dimension_diameter, "DIMENSION_DIAMETER", "clone_ins_pt", &clone_ins_pt, NULL)
        && !memcmp (&clone_ins_pt, &dimension_diameter->clone_ins_pt, sizeof (BITCODE_2RD)))
        pass ();
    else
        fail ("DIMENSION_DIAMETER.clone_ins_pt [2RD]");
  }
  {
    BITCODE_3BD def_pt;
    if (dwg_dynapi_entity_value (dimension_diameter, "DIMENSION_DIAMETER", "def_pt", &def_pt, NULL)
        && !memcmp (&def_pt, &dimension_diameter->def_pt, sizeof (BITCODE_3BD)))
        pass ();
    else
        fail ("DIMENSION_DIAMETER.def_pt [3BD]");
  }
  {
    BITCODE_H dimstyle;
    if (dwg_dynapi_entity_value (dimension_diameter, "DIMENSION_DIAMETER", "dimstyle", &dimstyle, NULL)
        && !memcmp (&dimstyle, &dimension_diameter->dimstyle, sizeof (BITCODE_H)))
        pass ();
    else
        fail ("DIMENSION_DIAMETER.dimstyle [H]");
  }
  {
    BITCODE_BD elevation;
    if (dwg_dynapi_entity_value (dimension_diameter, "DIMENSION_DIAMETER", "elevation", &elevation, NULL)
        && elevation == dimension_diameter->elevation)
      pass ();
    else
      fail ("DIMENSION_DIAMETER.elevation [BD] %g != %g", dimension_diameter->elevation, elevation);
    elevation++;
    if (dwg_dynapi_entity_set_value (dimension_diameter, "DIMENSION_DIAMETER", "elevation", &elevation, 0)
        && elevation == dimension_diameter->elevation)
      pass ();
    else
      fail ("DIMENSION_DIAMETER.elevation [BD] set+1 %g != %g", dimension_diameter->elevation, elevation);
    dimension_diameter->elevation--;
  }
  {
    BITCODE_BE extrusion;
    if (dwg_dynapi_entity_value (dimension_diameter, "DIMENSION_DIAMETER", "extrusion", &extrusion, NULL)
        && !memcmp (&extrusion, &dimension_diameter->extrusion, sizeof (BITCODE_BE)))
        pass ();
    else
        fail ("DIMENSION_DIAMETER.extrusion [BE]");
  }
  {
    BITCODE_3BD first_arc_pt;
    if (dwg_dynapi_entity_value (dimension_diameter, "DIMENSION_DIAMETER", "first_arc_pt", &first_arc_pt, NULL)
        && !memcmp (&first_arc_pt, &dimension_diameter->first_arc_pt, sizeof (BITCODE_3BD)))
        pass ();
    else
        fail ("DIMENSION_DIAMETER.first_arc_pt [3BD]");
  }
  {
    BITCODE_RC flag;
    if (dwg_dynapi_entity_value (dimension_diameter, "DIMENSION_DIAMETER", "flag", &flag, NULL)
        && flag == dimension_diameter->flag)
      pass ();
    else
      fail ("DIMENSION_DIAMETER.flag [RC] %u != %u", dimension_diameter->flag, flag);
    flag++;
    if (dwg_dynapi_entity_set_value (dimension_diameter, "DIMENSION_DIAMETER", "flag", &flag, 0)
        && flag == dimension_diameter->flag)
      pass ();
    else
      fail ("DIMENSION_DIAMETER.flag [RC] set+1 %u != %u", dimension_diameter->flag, flag);
    dimension_diameter->flag--;
  }
  {
    BITCODE_RC flag1;
    if (dwg_dynapi_entity_value (dimension_diameter, "DIMENSION_DIAMETER", "flag1", &flag1, NULL)
        && flag1 == dimension_diameter->flag1)
      pass ();
    else
      fail ("DIMENSION_DIAMETER.flag1 [RC] %u != %u", dimension_diameter->flag1, flag1);
    flag1++;
    if (dwg_dynapi_entity_set_value (dimension_diameter, "DIMENSION_DIAMETER", "flag1", &flag1, 0)
        && flag1 == dimension_diameter->flag1)
      pass ();
    else
      fail ("DIMENSION_DIAMETER.flag1 [RC] set+1 %u != %u", dimension_diameter->flag1, flag1);
    dimension_diameter->flag1--;
  }
  {
    BITCODE_B flip_arrow1;
    if (dwg_dynapi_entity_value (dimension_diameter, "DIMENSION_DIAMETER", "flip_arrow1", &flip_arrow1, NULL)
        && flip_arrow1 == dimension_diameter->flip_arrow1)
      pass ();
    else
      fail ("DIMENSION_DIAMETER.flip_arrow1 [B] " FORMAT_B " != " FORMAT_B "", dimension_diameter->flip_arrow1, flip_arrow1);
    flip_arrow1++;
    if (dwg_dynapi_entity_set_value (dimension_diameter, "DIMENSION_DIAMETER", "flip_arrow1", &flip_arrow1, 0)
        && flip_arrow1 == dimension_diameter->flip_arrow1)
      pass ();
    else
      fail ("DIMENSION_DIAMETER.flip_arrow1 [B] set+1 " FORMAT_B " != " FORMAT_B "", dimension_diameter->flip_arrow1, flip_arrow1);
    dimension_diameter->flip_arrow1--;
  }
  {
    BITCODE_B flip_arrow2;
    if (dwg_dynapi_entity_value (dimension_diameter, "DIMENSION_DIAMETER", "flip_arrow2", &flip_arrow2, NULL)
        && flip_arrow2 == dimension_diameter->flip_arrow2)
      pass ();
    else
      fail ("DIMENSION_DIAMETER.flip_arrow2 [B] " FORMAT_B " != " FORMAT_B "", dimension_diameter->flip_arrow2, flip_arrow2);
    flip_arrow2++;
    if (dwg_dynapi_entity_set_value (dimension_diameter, "DIMENSION_DIAMETER", "flip_arrow2", &flip_arrow2, 0)
        && flip_arrow2 == dimension_diameter->flip_arrow2)
      pass ();
    else
      fail ("DIMENSION_DIAMETER.flip_arrow2 [B] set+1 " FORMAT_B " != " FORMAT_B "", dimension_diameter->flip_arrow2, flip_arrow2);
    dimension_diameter->flip_arrow2--;
  }
  {
    BITCODE_BD horiz_dir;
    if (dwg_dynapi_entity_value (dimension_diameter, "DIMENSION_DIAMETER", "horiz_dir", &horiz_dir, NULL)
        && horiz_dir == dimension_diameter->horiz_dir)
      pass ();
    else
      fail ("DIMENSION_DIAMETER.horiz_dir [BD] %g != %g", dimension_diameter->horiz_dir, horiz_dir);
    horiz_dir++;
    if (dwg_dynapi_entity_set_value (dimension_diameter, "DIMENSION_DIAMETER", "horiz_dir", &horiz_dir, 0)
        && horiz_dir == dimension_diameter->horiz_dir)
      pass ();
    else
      fail ("DIMENSION_DIAMETER.horiz_dir [BD] set+1 %g != %g", dimension_diameter->horiz_dir, horiz_dir);
    dimension_diameter->horiz_dir--;
  }
  {
    BITCODE_BD ins_rotation;
    if (dwg_dynapi_entity_value (dimension_diameter, "DIMENSION_DIAMETER", "ins_rotation", &ins_rotation, NULL)
        && ins_rotation == dimension_diameter->ins_rotation)
      pass ();
    else
      fail ("DIMENSION_DIAMETER.ins_rotation [BD] %g != %g", dimension_diameter->ins_rotation, ins_rotation);
    ins_rotation++;
    if (dwg_dynapi_entity_set_value (dimension_diameter, "DIMENSION_DIAMETER", "ins_rotation", &ins_rotation, 0)
        && ins_rotation == dimension_diameter->ins_rotation)
      pass ();
    else
      fail ("DIMENSION_DIAMETER.ins_rotation [BD] set+1 %g != %g", dimension_diameter->ins_rotation, ins_rotation);
    dimension_diameter->ins_rotation--;
  }
  {
    BITCODE_3BD ins_scale;
    if (dwg_dynapi_entity_value (dimension_diameter, "DIMENSION_DIAMETER", "ins_scale", &ins_scale, NULL)
        && !memcmp (&ins_scale, &dimension_diameter->ins_scale, sizeof (BITCODE_3BD)))
        pass ();
    else
        fail ("DIMENSION_DIAMETER.ins_scale [3BD]");
  }
  {
    BITCODE_BD leader_len;
    if (dwg_dynapi_entity_value (dimension_diameter, "DIMENSION_DIAMETER", "leader_len", &leader_len, NULL)
        && leader_len == dimension_diameter->leader_len)
      pass ();
    else
      fail ("DIMENSION_DIAMETER.leader_len [BD] %g != %g", dimension_diameter->leader_len, leader_len);
    leader_len++;
    if (dwg_dynapi_entity_set_value (dimension_diameter, "DIMENSION_DIAMETER", "leader_len", &leader_len, 0)
        && leader_len == dimension_diameter->leader_len)
      pass ();
    else
      fail ("DIMENSION_DIAMETER.leader_len [BD] set+1 %g != %g", dimension_diameter->leader_len, leader_len);
    dimension_diameter->leader_len--;
  }
  {
    BITCODE_BD lspace_factor;
    if (dwg_dynapi_entity_value (dimension_diameter, "DIMENSION_DIAMETER", "lspace_factor", &lspace_factor, NULL)
        && lspace_factor == dimension_diameter->lspace_factor)
      pass ();
    else
      fail ("DIMENSION_DIAMETER.lspace_factor [BD] %g != %g", dimension_diameter->lspace_factor, lspace_factor);
    lspace_factor++;
    if (dwg_dynapi_entity_set_value (dimension_diameter, "DIMENSION_DIAMETER", "lspace_factor", &lspace_factor, 0)
        && lspace_factor == dimension_diameter->lspace_factor)
      pass ();
    else
      fail ("DIMENSION_DIAMETER.lspace_factor [BD] set+1 %g != %g", dimension_diameter->lspace_factor, lspace_factor);
    dimension_diameter->lspace_factor--;
  }
  {
    BITCODE_BS lspace_style;
    if (dwg_dynapi_entity_value (dimension_diameter, "DIMENSION_DIAMETER", "lspace_style", &lspace_style, NULL)
        && lspace_style == dimension_diameter->lspace_style)
      pass ();
    else
      fail ("DIMENSION_DIAMETER.lspace_style [BS] %hu != %hu", dimension_diameter->lspace_style, lspace_style);
    lspace_style++;
    if (dwg_dynapi_entity_set_value (dimension_diameter, "DIMENSION_DIAMETER", "lspace_style", &lspace_style, 0)
        && lspace_style == dimension_diameter->lspace_style)
      pass ();
    else
      fail ("DIMENSION_DIAMETER.lspace_style [BS] set+1 %hu != %hu", dimension_diameter->lspace_style, lspace_style);
    dimension_diameter->lspace_style--;
  }
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value (dimension_diameter, "DIMENSION_DIAMETER", "parent", &parent, NULL)
        && !memcmp (&parent, &dimension_diameter->parent, sizeof (struct _dwg_object_entity*)))
        pass ();
    else
        fail ("DIMENSION_DIAMETER.parent [struct _dwg_object_entity*]");
  }
  {
    BITCODE_2RD text_midpt;
    if (dwg_dynapi_entity_value (dimension_diameter, "DIMENSION_DIAMETER", "text_midpt", &text_midpt, NULL)
        && !memcmp (&text_midpt, &dimension_diameter->text_midpt, sizeof (BITCODE_2RD)))
        pass ();
    else
        fail ("DIMENSION_DIAMETER.text_midpt [2RD]");
  }
  {
    BITCODE_BD text_rotation;
    if (dwg_dynapi_entity_value (dimension_diameter, "DIMENSION_DIAMETER", "text_rotation", &text_rotation, NULL)
        && text_rotation == dimension_diameter->text_rotation)
      pass ();
    else
      fail ("DIMENSION_DIAMETER.text_rotation [BD] %g != %g", dimension_diameter->text_rotation, text_rotation);
    text_rotation++;
    if (dwg_dynapi_entity_set_value (dimension_diameter, "DIMENSION_DIAMETER", "text_rotation", &text_rotation, 0)
        && text_rotation == dimension_diameter->text_rotation)
      pass ();
    else
      fail ("DIMENSION_DIAMETER.text_rotation [BD] set+1 %g != %g", dimension_diameter->text_rotation, text_rotation);
    dimension_diameter->text_rotation--;
  }
  {
    BITCODE_B unknown;
    if (dwg_dynapi_entity_value (dimension_diameter, "DIMENSION_DIAMETER", "unknown", &unknown, NULL)
        && unknown == dimension_diameter->unknown)
      pass ();
    else
      fail ("DIMENSION_DIAMETER.unknown [B] " FORMAT_B " != " FORMAT_B "", dimension_diameter->unknown, unknown);
    unknown++;
    if (dwg_dynapi_entity_set_value (dimension_diameter, "DIMENSION_DIAMETER", "unknown", &unknown, 0)
        && unknown == dimension_diameter->unknown)
      pass ();
    else
      fail ("DIMENSION_DIAMETER.unknown [B] set+1 " FORMAT_B " != " FORMAT_B "", dimension_diameter->unknown, unknown);
    dimension_diameter->unknown--;
  }
  {
    BITCODE_TV user_text;
    if (dwg_dynapi_entity_value (dimension_diameter, "DIMENSION_DIAMETER", "user_text", &user_text, NULL)
        && user_text
           ? strEQ ((char *)user_text, (char *)dimension_diameter->user_text)
           : !dimension_diameter->user_text)
      pass ();
    else
      fail ("DIMENSION_DIAMETER.user_text [TV] '%s' <> '%s'", user_text, dimension_diameter->user_text);
  }
  if (failed && (is_class_unstable ("DIMENSION_DIAMETER") || is_class_debugging ("DIMENSION_DIAMETER")))
    {
      ok ("%s failed %d tests (TODO unstable)", "DIMENSION_DIAMETER", failed);
      failed = 0;
    }
  return failed;
}
static int test_DIMENSION_LINEAR (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_DIMENSION_LINEAR *restrict dimension_linear = obj->tio.entity->tio.DIMENSION_LINEAR;
  failed = 0;
  {
    BITCODE_BD act_measurement;
    if (dwg_dynapi_entity_value (dimension_linear, "DIMENSION_LINEAR", "act_measurement", &act_measurement, NULL)
        && act_measurement == dimension_linear->act_measurement)
      pass ();
    else
      fail ("DIMENSION_LINEAR.act_measurement [BD] %g != %g", dimension_linear->act_measurement, act_measurement);
    act_measurement++;
    if (dwg_dynapi_entity_set_value (dimension_linear, "DIMENSION_LINEAR", "act_measurement", &act_measurement, 0)
        && act_measurement == dimension_linear->act_measurement)
      pass ();
    else
      fail ("DIMENSION_LINEAR.act_measurement [BD] set+1 %g != %g", dimension_linear->act_measurement, act_measurement);
    dimension_linear->act_measurement--;
  }
  {
    BITCODE_BS attachment;
    if (dwg_dynapi_entity_value (dimension_linear, "DIMENSION_LINEAR", "attachment", &attachment, NULL)
        && attachment == dimension_linear->attachment)
      pass ();
    else
      fail ("DIMENSION_LINEAR.attachment [BS] %hu != %hu", dimension_linear->attachment, attachment);
    attachment++;
    if (dwg_dynapi_entity_set_value (dimension_linear, "DIMENSION_LINEAR", "attachment", &attachment, 0)
        && attachment == dimension_linear->attachment)
      pass ();
    else
      fail ("DIMENSION_LINEAR.attachment [BS] set+1 %hu != %hu", dimension_linear->attachment, attachment);
    dimension_linear->attachment--;
  }
  {
    BITCODE_H block;
    if (dwg_dynapi_entity_value (dimension_linear, "DIMENSION_LINEAR", "block", &block, NULL)
        && !memcmp (&block, &dimension_linear->block, sizeof (BITCODE_H)))
        pass ();
    else
        fail ("DIMENSION_LINEAR.block [H]");
  }
  {
    BITCODE_TV blockname;
    if (dwg_dynapi_entity_value (dimension_linear, "DIMENSION_LINEAR", "blockname", &blockname, NULL)
        && blockname
           ? strEQ ((char *)blockname, (char *)dimension_linear->blockname)
           : !dimension_linear->blockname)
      pass ();
    else
      fail ("DIMENSION_LINEAR.blockname [TV] '%s' <> '%s'", blockname, dimension_linear->blockname);
  }
  {
    BITCODE_RC class_version;
    if (dwg_dynapi_entity_value (dimension_linear, "DIMENSION_LINEAR", "class_version", &class_version, NULL)
        && class_version == dimension_linear->class_version)
      pass ();
    else
      fail ("DIMENSION_LINEAR.class_version [RC] %u != %u", dimension_linear->class_version, class_version);
    class_version++;
    if (dwg_dynapi_entity_set_value (dimension_linear, "DIMENSION_LINEAR", "class_version", &class_version, 0)
        && class_version == dimension_linear->class_version)
      pass ();
    else
      fail ("DIMENSION_LINEAR.class_version [RC] set+1 %u != %u", dimension_linear->class_version, class_version);
    dimension_linear->class_version--;
  }
  {
    BITCODE_2RD clone_ins_pt;
    if (dwg_dynapi_entity_value (dimension_linear, "DIMENSION_LINEAR", "clone_ins_pt", &clone_ins_pt, NULL)
        && !memcmp (&clone_ins_pt, &dimension_linear->clone_ins_pt, sizeof (BITCODE_2RD)))
        pass ();
    else
        fail ("DIMENSION_LINEAR.clone_ins_pt [2RD]");
  }
  {
    BITCODE_3BD def_pt;
    if (dwg_dynapi_entity_value (dimension_linear, "DIMENSION_LINEAR", "def_pt", &def_pt, NULL)
        && !memcmp (&def_pt, &dimension_linear->def_pt, sizeof (BITCODE_3BD)))
        pass ();
    else
        fail ("DIMENSION_LINEAR.def_pt [3BD]");
  }
  {
    BITCODE_BD dim_rotation;
    if (dwg_dynapi_entity_value (dimension_linear, "DIMENSION_LINEAR", "dim_rotation", &dim_rotation, NULL)
        && dim_rotation == dimension_linear->dim_rotation)
      pass ();
    else
      fail ("DIMENSION_LINEAR.dim_rotation [BD] %g != %g", dimension_linear->dim_rotation, dim_rotation);
    dim_rotation++;
    if (dwg_dynapi_entity_set_value (dimension_linear, "DIMENSION_LINEAR", "dim_rotation", &dim_rotation, 0)
        && dim_rotation == dimension_linear->dim_rotation)
      pass ();
    else
      fail ("DIMENSION_LINEAR.dim_rotation [BD] set+1 %g != %g", dimension_linear->dim_rotation, dim_rotation);
    dimension_linear->dim_rotation--;
  }
  {
    BITCODE_H dimstyle;
    if (dwg_dynapi_entity_value (dimension_linear, "DIMENSION_LINEAR", "dimstyle", &dimstyle, NULL)
        && !memcmp (&dimstyle, &dimension_linear->dimstyle, sizeof (BITCODE_H)))
        pass ();
    else
        fail ("DIMENSION_LINEAR.dimstyle [H]");
  }
  {
    BITCODE_BD elevation;
    if (dwg_dynapi_entity_value (dimension_linear, "DIMENSION_LINEAR", "elevation", &elevation, NULL)
        && elevation == dimension_linear->elevation)
      pass ();
    else
      fail ("DIMENSION_LINEAR.elevation [BD] %g != %g", dimension_linear->elevation, elevation);
    elevation++;
    if (dwg_dynapi_entity_set_value (dimension_linear, "DIMENSION_LINEAR", "elevation", &elevation, 0)
        && elevation == dimension_linear->elevation)
      pass ();
    else
      fail ("DIMENSION_LINEAR.elevation [BD] set+1 %g != %g", dimension_linear->elevation, elevation);
    dimension_linear->elevation--;
  }
  {
    BITCODE_BE extrusion;
    if (dwg_dynapi_entity_value (dimension_linear, "DIMENSION_LINEAR", "extrusion", &extrusion, NULL)
        && !memcmp (&extrusion, &dimension_linear->extrusion, sizeof (BITCODE_BE)))
        pass ();
    else
        fail ("DIMENSION_LINEAR.extrusion [BE]");
  }
  {
    BITCODE_RC flag;
    if (dwg_dynapi_entity_value (dimension_linear, "DIMENSION_LINEAR", "flag", &flag, NULL)
        && flag == dimension_linear->flag)
      pass ();
    else
      fail ("DIMENSION_LINEAR.flag [RC] %u != %u", dimension_linear->flag, flag);
    flag++;
    if (dwg_dynapi_entity_set_value (dimension_linear, "DIMENSION_LINEAR", "flag", &flag, 0)
        && flag == dimension_linear->flag)
      pass ();
    else
      fail ("DIMENSION_LINEAR.flag [RC] set+1 %u != %u", dimension_linear->flag, flag);
    dimension_linear->flag--;
  }
  {
    BITCODE_RC flag1;
    if (dwg_dynapi_entity_value (dimension_linear, "DIMENSION_LINEAR", "flag1", &flag1, NULL)
        && flag1 == dimension_linear->flag1)
      pass ();
    else
      fail ("DIMENSION_LINEAR.flag1 [RC] %u != %u", dimension_linear->flag1, flag1);
    flag1++;
    if (dwg_dynapi_entity_set_value (dimension_linear, "DIMENSION_LINEAR", "flag1", &flag1, 0)
        && flag1 == dimension_linear->flag1)
      pass ();
    else
      fail ("DIMENSION_LINEAR.flag1 [RC] set+1 %u != %u", dimension_linear->flag1, flag1);
    dimension_linear->flag1--;
  }
  {
    BITCODE_B flip_arrow1;
    if (dwg_dynapi_entity_value (dimension_linear, "DIMENSION_LINEAR", "flip_arrow1", &flip_arrow1, NULL)
        && flip_arrow1 == dimension_linear->flip_arrow1)
      pass ();
    else
      fail ("DIMENSION_LINEAR.flip_arrow1 [B] " FORMAT_B " != " FORMAT_B "", dimension_linear->flip_arrow1, flip_arrow1);
    flip_arrow1++;
    if (dwg_dynapi_entity_set_value (dimension_linear, "DIMENSION_LINEAR", "flip_arrow1", &flip_arrow1, 0)
        && flip_arrow1 == dimension_linear->flip_arrow1)
      pass ();
    else
      fail ("DIMENSION_LINEAR.flip_arrow1 [B] set+1 " FORMAT_B " != " FORMAT_B "", dimension_linear->flip_arrow1, flip_arrow1);
    dimension_linear->flip_arrow1--;
  }
  {
    BITCODE_B flip_arrow2;
    if (dwg_dynapi_entity_value (dimension_linear, "DIMENSION_LINEAR", "flip_arrow2", &flip_arrow2, NULL)
        && flip_arrow2 == dimension_linear->flip_arrow2)
      pass ();
    else
      fail ("DIMENSION_LINEAR.flip_arrow2 [B] " FORMAT_B " != " FORMAT_B "", dimension_linear->flip_arrow2, flip_arrow2);
    flip_arrow2++;
    if (dwg_dynapi_entity_set_value (dimension_linear, "DIMENSION_LINEAR", "flip_arrow2", &flip_arrow2, 0)
        && flip_arrow2 == dimension_linear->flip_arrow2)
      pass ();
    else
      fail ("DIMENSION_LINEAR.flip_arrow2 [B] set+1 " FORMAT_B " != " FORMAT_B "", dimension_linear->flip_arrow2, flip_arrow2);
    dimension_linear->flip_arrow2--;
  }
  {
    BITCODE_BD horiz_dir;
    if (dwg_dynapi_entity_value (dimension_linear, "DIMENSION_LINEAR", "horiz_dir", &horiz_dir, NULL)
        && horiz_dir == dimension_linear->horiz_dir)
      pass ();
    else
      fail ("DIMENSION_LINEAR.horiz_dir [BD] %g != %g", dimension_linear->horiz_dir, horiz_dir);
    horiz_dir++;
    if (dwg_dynapi_entity_set_value (dimension_linear, "DIMENSION_LINEAR", "horiz_dir", &horiz_dir, 0)
        && horiz_dir == dimension_linear->horiz_dir)
      pass ();
    else
      fail ("DIMENSION_LINEAR.horiz_dir [BD] set+1 %g != %g", dimension_linear->horiz_dir, horiz_dir);
    dimension_linear->horiz_dir--;
  }
  {
    BITCODE_BD ins_rotation;
    if (dwg_dynapi_entity_value (dimension_linear, "DIMENSION_LINEAR", "ins_rotation", &ins_rotation, NULL)
        && ins_rotation == dimension_linear->ins_rotation)
      pass ();
    else
      fail ("DIMENSION_LINEAR.ins_rotation [BD] %g != %g", dimension_linear->ins_rotation, ins_rotation);
    ins_rotation++;
    if (dwg_dynapi_entity_set_value (dimension_linear, "DIMENSION_LINEAR", "ins_rotation", &ins_rotation, 0)
        && ins_rotation == dimension_linear->ins_rotation)
      pass ();
    else
      fail ("DIMENSION_LINEAR.ins_rotation [BD] set+1 %g != %g", dimension_linear->ins_rotation, ins_rotation);
    dimension_linear->ins_rotation--;
  }
  {
    BITCODE_3BD ins_scale;
    if (dwg_dynapi_entity_value (dimension_linear, "DIMENSION_LINEAR", "ins_scale", &ins_scale, NULL)
        && !memcmp (&ins_scale, &dimension_linear->ins_scale, sizeof (BITCODE_3BD)))
        pass ();
    else
        fail ("DIMENSION_LINEAR.ins_scale [3BD]");
  }
  {
    BITCODE_BD lspace_factor;
    if (dwg_dynapi_entity_value (dimension_linear, "DIMENSION_LINEAR", "lspace_factor", &lspace_factor, NULL)
        && lspace_factor == dimension_linear->lspace_factor)
      pass ();
    else
      fail ("DIMENSION_LINEAR.lspace_factor [BD] %g != %g", dimension_linear->lspace_factor, lspace_factor);
    lspace_factor++;
    if (dwg_dynapi_entity_set_value (dimension_linear, "DIMENSION_LINEAR", "lspace_factor", &lspace_factor, 0)
        && lspace_factor == dimension_linear->lspace_factor)
      pass ();
    else
      fail ("DIMENSION_LINEAR.lspace_factor [BD] set+1 %g != %g", dimension_linear->lspace_factor, lspace_factor);
    dimension_linear->lspace_factor--;
  }
  {
    BITCODE_BS lspace_style;
    if (dwg_dynapi_entity_value (dimension_linear, "DIMENSION_LINEAR", "lspace_style", &lspace_style, NULL)
        && lspace_style == dimension_linear->lspace_style)
      pass ();
    else
      fail ("DIMENSION_LINEAR.lspace_style [BS] %hu != %hu", dimension_linear->lspace_style, lspace_style);
    lspace_style++;
    if (dwg_dynapi_entity_set_value (dimension_linear, "DIMENSION_LINEAR", "lspace_style", &lspace_style, 0)
        && lspace_style == dimension_linear->lspace_style)
      pass ();
    else
      fail ("DIMENSION_LINEAR.lspace_style [BS] set+1 %hu != %hu", dimension_linear->lspace_style, lspace_style);
    dimension_linear->lspace_style--;
  }
  {
    BITCODE_BD oblique_angle;
    if (dwg_dynapi_entity_value (dimension_linear, "DIMENSION_LINEAR", "oblique_angle", &oblique_angle, NULL)
        && oblique_angle == dimension_linear->oblique_angle)
      pass ();
    else
      fail ("DIMENSION_LINEAR.oblique_angle [BD] %g != %g", dimension_linear->oblique_angle, oblique_angle);
    oblique_angle++;
    if (dwg_dynapi_entity_set_value (dimension_linear, "DIMENSION_LINEAR", "oblique_angle", &oblique_angle, 0)
        && oblique_angle == dimension_linear->oblique_angle)
      pass ();
    else
      fail ("DIMENSION_LINEAR.oblique_angle [BD] set+1 %g != %g", dimension_linear->oblique_angle, oblique_angle);
    dimension_linear->oblique_angle--;
  }
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value (dimension_linear, "DIMENSION_LINEAR", "parent", &parent, NULL)
        && !memcmp (&parent, &dimension_linear->parent, sizeof (struct _dwg_object_entity*)))
        pass ();
    else
        fail ("DIMENSION_LINEAR.parent [struct _dwg_object_entity*]");
  }
  {
    BITCODE_2RD text_midpt;
    if (dwg_dynapi_entity_value (dimension_linear, "DIMENSION_LINEAR", "text_midpt", &text_midpt, NULL)
        && !memcmp (&text_midpt, &dimension_linear->text_midpt, sizeof (BITCODE_2RD)))
        pass ();
    else
        fail ("DIMENSION_LINEAR.text_midpt [2RD]");
  }
  {
    BITCODE_BD text_rotation;
    if (dwg_dynapi_entity_value (dimension_linear, "DIMENSION_LINEAR", "text_rotation", &text_rotation, NULL)
        && text_rotation == dimension_linear->text_rotation)
      pass ();
    else
      fail ("DIMENSION_LINEAR.text_rotation [BD] %g != %g", dimension_linear->text_rotation, text_rotation);
    text_rotation++;
    if (dwg_dynapi_entity_set_value (dimension_linear, "DIMENSION_LINEAR", "text_rotation", &text_rotation, 0)
        && text_rotation == dimension_linear->text_rotation)
      pass ();
    else
      fail ("DIMENSION_LINEAR.text_rotation [BD] set+1 %g != %g", dimension_linear->text_rotation, text_rotation);
    dimension_linear->text_rotation--;
  }
  {
    BITCODE_B unknown;
    if (dwg_dynapi_entity_value (dimension_linear, "DIMENSION_LINEAR", "unknown", &unknown, NULL)
        && unknown == dimension_linear->unknown)
      pass ();
    else
      fail ("DIMENSION_LINEAR.unknown [B] " FORMAT_B " != " FORMAT_B "", dimension_linear->unknown, unknown);
    unknown++;
    if (dwg_dynapi_entity_set_value (dimension_linear, "DIMENSION_LINEAR", "unknown", &unknown, 0)
        && unknown == dimension_linear->unknown)
      pass ();
    else
      fail ("DIMENSION_LINEAR.unknown [B] set+1 " FORMAT_B " != " FORMAT_B "", dimension_linear->unknown, unknown);
    dimension_linear->unknown--;
  }
  {
    BITCODE_TV user_text;
    if (dwg_dynapi_entity_value (dimension_linear, "DIMENSION_LINEAR", "user_text", &user_text, NULL)
        && user_text
           ? strEQ ((char *)user_text, (char *)dimension_linear->user_text)
           : !dimension_linear->user_text)
      pass ();
    else
      fail ("DIMENSION_LINEAR.user_text [TV] '%s' <> '%s'", user_text, dimension_linear->user_text);
  }
  {
    BITCODE_3BD xline1_pt;
    if (dwg_dynapi_entity_value (dimension_linear, "DIMENSION_LINEAR", "xline1_pt", &xline1_pt, NULL)
        && !memcmp (&xline1_pt, &dimension_linear->xline1_pt, sizeof (BITCODE_3BD)))
        pass ();
    else
        fail ("DIMENSION_LINEAR.xline1_pt [3BD]");
  }
  {
    BITCODE_3BD xline2_pt;
    if (dwg_dynapi_entity_value (dimension_linear, "DIMENSION_LINEAR", "xline2_pt", &xline2_pt, NULL)
        && !memcmp (&xline2_pt, &dimension_linear->xline2_pt, sizeof (BITCODE_3BD)))
        pass ();
    else
        fail ("DIMENSION_LINEAR.xline2_pt [3BD]");
  }
  if (failed && (is_class_unstable ("DIMENSION_LINEAR") || is_class_debugging ("DIMENSION_LINEAR")))
    {
      ok ("%s failed %d tests (TODO unstable)", "DIMENSION_LINEAR", failed);
      failed = 0;
    }
  return failed;
}
static int test_DIMENSION_ORDINATE (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_DIMENSION_ORDINATE *restrict dimension_ordinate = obj->tio.entity->tio.DIMENSION_ORDINATE;
  failed = 0;
  {
    BITCODE_BD act_measurement;
    if (dwg_dynapi_entity_value (dimension_ordinate, "DIMENSION_ORDINATE", "act_measurement", &act_measurement, NULL)
        && act_measurement == dimension_ordinate->act_measurement)
      pass ();
    else
      fail ("DIMENSION_ORDINATE.act_measurement [BD] %g != %g", dimension_ordinate->act_measurement, act_measurement);
    act_measurement++;
    if (dwg_dynapi_entity_set_value (dimension_ordinate, "DIMENSION_ORDINATE", "act_measurement", &act_measurement, 0)
        && act_measurement == dimension_ordinate->act_measurement)
      pass ();
    else
      fail ("DIMENSION_ORDINATE.act_measurement [BD] set+1 %g != %g", dimension_ordinate->act_measurement, act_measurement);
    dimension_ordinate->act_measurement--;
  }
  {
    BITCODE_BS attachment;
    if (dwg_dynapi_entity_value (dimension_ordinate, "DIMENSION_ORDINATE", "attachment", &attachment, NULL)
        && attachment == dimension_ordinate->attachment)
      pass ();
    else
      fail ("DIMENSION_ORDINATE.attachment [BS] %hu != %hu", dimension_ordinate->attachment, attachment);
    attachment++;
    if (dwg_dynapi_entity_set_value (dimension_ordinate, "DIMENSION_ORDINATE", "attachment", &attachment, 0)
        && attachment == dimension_ordinate->attachment)
      pass ();
    else
      fail ("DIMENSION_ORDINATE.attachment [BS] set+1 %hu != %hu", dimension_ordinate->attachment, attachment);
    dimension_ordinate->attachment--;
  }
  {
    BITCODE_H block;
    if (dwg_dynapi_entity_value (dimension_ordinate, "DIMENSION_ORDINATE", "block", &block, NULL)
        && !memcmp (&block, &dimension_ordinate->block, sizeof (BITCODE_H)))
        pass ();
    else
        fail ("DIMENSION_ORDINATE.block [H]");
  }
  {
    BITCODE_TV blockname;
    if (dwg_dynapi_entity_value (dimension_ordinate, "DIMENSION_ORDINATE", "blockname", &blockname, NULL)
        && blockname
           ? strEQ ((char *)blockname, (char *)dimension_ordinate->blockname)
           : !dimension_ordinate->blockname)
      pass ();
    else
      fail ("DIMENSION_ORDINATE.blockname [TV] '%s' <> '%s'", blockname, dimension_ordinate->blockname);
  }
  {
    BITCODE_RC class_version;
    if (dwg_dynapi_entity_value (dimension_ordinate, "DIMENSION_ORDINATE", "class_version", &class_version, NULL)
        && class_version == dimension_ordinate->class_version)
      pass ();
    else
      fail ("DIMENSION_ORDINATE.class_version [RC] %u != %u", dimension_ordinate->class_version, class_version);
    class_version++;
    if (dwg_dynapi_entity_set_value (dimension_ordinate, "DIMENSION_ORDINATE", "class_version", &class_version, 0)
        && class_version == dimension_ordinate->class_version)
      pass ();
    else
      fail ("DIMENSION_ORDINATE.class_version [RC] set+1 %u != %u", dimension_ordinate->class_version, class_version);
    dimension_ordinate->class_version--;
  }
  {
    BITCODE_2RD clone_ins_pt;
    if (dwg_dynapi_entity_value (dimension_ordinate, "DIMENSION_ORDINATE", "clone_ins_pt", &clone_ins_pt, NULL)
        && !memcmp (&clone_ins_pt, &dimension_ordinate->clone_ins_pt, sizeof (BITCODE_2RD)))
        pass ();
    else
        fail ("DIMENSION_ORDINATE.clone_ins_pt [2RD]");
  }
  {
    BITCODE_3BD def_pt;
    if (dwg_dynapi_entity_value (dimension_ordinate, "DIMENSION_ORDINATE", "def_pt", &def_pt, NULL)
        && !memcmp (&def_pt, &dimension_ordinate->def_pt, sizeof (BITCODE_3BD)))
        pass ();
    else
        fail ("DIMENSION_ORDINATE.def_pt [3BD]");
  }
  {
    BITCODE_H dimstyle;
    if (dwg_dynapi_entity_value (dimension_ordinate, "DIMENSION_ORDINATE", "dimstyle", &dimstyle, NULL)
        && !memcmp (&dimstyle, &dimension_ordinate->dimstyle, sizeof (BITCODE_H)))
        pass ();
    else
        fail ("DIMENSION_ORDINATE.dimstyle [H]");
  }
  {
    BITCODE_BD elevation;
    if (dwg_dynapi_entity_value (dimension_ordinate, "DIMENSION_ORDINATE", "elevation", &elevation, NULL)
        && elevation == dimension_ordinate->elevation)
      pass ();
    else
      fail ("DIMENSION_ORDINATE.elevation [BD] %g != %g", dimension_ordinate->elevation, elevation);
    elevation++;
    if (dwg_dynapi_entity_set_value (dimension_ordinate, "DIMENSION_ORDINATE", "elevation", &elevation, 0)
        && elevation == dimension_ordinate->elevation)
      pass ();
    else
      fail ("DIMENSION_ORDINATE.elevation [BD] set+1 %g != %g", dimension_ordinate->elevation, elevation);
    dimension_ordinate->elevation--;
  }
  {
    BITCODE_BE extrusion;
    if (dwg_dynapi_entity_value (dimension_ordinate, "DIMENSION_ORDINATE", "extrusion", &extrusion, NULL)
        && !memcmp (&extrusion, &dimension_ordinate->extrusion, sizeof (BITCODE_BE)))
        pass ();
    else
        fail ("DIMENSION_ORDINATE.extrusion [BE]");
  }
  {
    BITCODE_3BD feature_location_pt;
    if (dwg_dynapi_entity_value (dimension_ordinate, "DIMENSION_ORDINATE", "feature_location_pt", &feature_location_pt, NULL)
        && !memcmp (&feature_location_pt, &dimension_ordinate->feature_location_pt, sizeof (BITCODE_3BD)))
        pass ();
    else
        fail ("DIMENSION_ORDINATE.feature_location_pt [3BD]");
  }
  {
    BITCODE_RC flag;
    if (dwg_dynapi_entity_value (dimension_ordinate, "DIMENSION_ORDINATE", "flag", &flag, NULL)
        && flag == dimension_ordinate->flag)
      pass ();
    else
      fail ("DIMENSION_ORDINATE.flag [RC] %u != %u", dimension_ordinate->flag, flag);
    flag++;
    if (dwg_dynapi_entity_set_value (dimension_ordinate, "DIMENSION_ORDINATE", "flag", &flag, 0)
        && flag == dimension_ordinate->flag)
      pass ();
    else
      fail ("DIMENSION_ORDINATE.flag [RC] set+1 %u != %u", dimension_ordinate->flag, flag);
    dimension_ordinate->flag--;
  }
  {
    BITCODE_RC flag1;
    if (dwg_dynapi_entity_value (dimension_ordinate, "DIMENSION_ORDINATE", "flag1", &flag1, NULL)
        && flag1 == dimension_ordinate->flag1)
      pass ();
    else
      fail ("DIMENSION_ORDINATE.flag1 [RC] %u != %u", dimension_ordinate->flag1, flag1);
    flag1++;
    if (dwg_dynapi_entity_set_value (dimension_ordinate, "DIMENSION_ORDINATE", "flag1", &flag1, 0)
        && flag1 == dimension_ordinate->flag1)
      pass ();
    else
      fail ("DIMENSION_ORDINATE.flag1 [RC] set+1 %u != %u", dimension_ordinate->flag1, flag1);
    dimension_ordinate->flag1--;
  }
  {
    BITCODE_RC flag2;
    if (dwg_dynapi_entity_value (dimension_ordinate, "DIMENSION_ORDINATE", "flag2", &flag2, NULL)
        && flag2 == dimension_ordinate->flag2)
      pass ();
    else
      fail ("DIMENSION_ORDINATE.flag2 [RC] %u != %u", dimension_ordinate->flag2, flag2);
    flag2++;
    if (dwg_dynapi_entity_set_value (dimension_ordinate, "DIMENSION_ORDINATE", "flag2", &flag2, 0)
        && flag2 == dimension_ordinate->flag2)
      pass ();
    else
      fail ("DIMENSION_ORDINATE.flag2 [RC] set+1 %u != %u", dimension_ordinate->flag2, flag2);
    dimension_ordinate->flag2--;
  }
  {
    BITCODE_B flip_arrow1;
    if (dwg_dynapi_entity_value (dimension_ordinate, "DIMENSION_ORDINATE", "flip_arrow1", &flip_arrow1, NULL)
        && flip_arrow1 == dimension_ordinate->flip_arrow1)
      pass ();
    else
      fail ("DIMENSION_ORDINATE.flip_arrow1 [B] " FORMAT_B " != " FORMAT_B "", dimension_ordinate->flip_arrow1, flip_arrow1);
    flip_arrow1++;
    if (dwg_dynapi_entity_set_value (dimension_ordinate, "DIMENSION_ORDINATE", "flip_arrow1", &flip_arrow1, 0)
        && flip_arrow1 == dimension_ordinate->flip_arrow1)
      pass ();
    else
      fail ("DIMENSION_ORDINATE.flip_arrow1 [B] set+1 " FORMAT_B " != " FORMAT_B "", dimension_ordinate->flip_arrow1, flip_arrow1);
    dimension_ordinate->flip_arrow1--;
  }
  {
    BITCODE_B flip_arrow2;
    if (dwg_dynapi_entity_value (dimension_ordinate, "DIMENSION_ORDINATE", "flip_arrow2", &flip_arrow2, NULL)
        && flip_arrow2 == dimension_ordinate->flip_arrow2)
      pass ();
    else
      fail ("DIMENSION_ORDINATE.flip_arrow2 [B] " FORMAT_B " != " FORMAT_B "", dimension_ordinate->flip_arrow2, flip_arrow2);
    flip_arrow2++;
    if (dwg_dynapi_entity_set_value (dimension_ordinate, "DIMENSION_ORDINATE", "flip_arrow2", &flip_arrow2, 0)
        && flip_arrow2 == dimension_ordinate->flip_arrow2)
      pass ();
    else
      fail ("DIMENSION_ORDINATE.flip_arrow2 [B] set+1 " FORMAT_B " != " FORMAT_B "", dimension_ordinate->flip_arrow2, flip_arrow2);
    dimension_ordinate->flip_arrow2--;
  }
  {
    BITCODE_BD horiz_dir;
    if (dwg_dynapi_entity_value (dimension_ordinate, "DIMENSION_ORDINATE", "horiz_dir", &horiz_dir, NULL)
        && horiz_dir == dimension_ordinate->horiz_dir)
      pass ();
    else
      fail ("DIMENSION_ORDINATE.horiz_dir [BD] %g != %g", dimension_ordinate->horiz_dir, horiz_dir);
    horiz_dir++;
    if (dwg_dynapi_entity_set_value (dimension_ordinate, "DIMENSION_ORDINATE", "horiz_dir", &horiz_dir, 0)
        && horiz_dir == dimension_ordinate->horiz_dir)
      pass ();
    else
      fail ("DIMENSION_ORDINATE.horiz_dir [BD] set+1 %g != %g", dimension_ordinate->horiz_dir, horiz_dir);
    dimension_ordinate->horiz_dir--;
  }
  {
    BITCODE_BD ins_rotation;
    if (dwg_dynapi_entity_value (dimension_ordinate, "DIMENSION_ORDINATE", "ins_rotation", &ins_rotation, NULL)
        && ins_rotation == dimension_ordinate->ins_rotation)
      pass ();
    else
      fail ("DIMENSION_ORDINATE.ins_rotation [BD] %g != %g", dimension_ordinate->ins_rotation, ins_rotation);
    ins_rotation++;
    if (dwg_dynapi_entity_set_value (dimension_ordinate, "DIMENSION_ORDINATE", "ins_rotation", &ins_rotation, 0)
        && ins_rotation == dimension_ordinate->ins_rotation)
      pass ();
    else
      fail ("DIMENSION_ORDINATE.ins_rotation [BD] set+1 %g != %g", dimension_ordinate->ins_rotation, ins_rotation);
    dimension_ordinate->ins_rotation--;
  }
  {
    BITCODE_3BD ins_scale;
    if (dwg_dynapi_entity_value (dimension_ordinate, "DIMENSION_ORDINATE", "ins_scale", &ins_scale, NULL)
        && !memcmp (&ins_scale, &dimension_ordinate->ins_scale, sizeof (BITCODE_3BD)))
        pass ();
    else
        fail ("DIMENSION_ORDINATE.ins_scale [3BD]");
  }
  {
    BITCODE_3BD leader_endpt;
    if (dwg_dynapi_entity_value (dimension_ordinate, "DIMENSION_ORDINATE", "leader_endpt", &leader_endpt, NULL)
        && !memcmp (&leader_endpt, &dimension_ordinate->leader_endpt, sizeof (BITCODE_3BD)))
        pass ();
    else
        fail ("DIMENSION_ORDINATE.leader_endpt [3BD]");
  }
  {
    BITCODE_BD lspace_factor;
    if (dwg_dynapi_entity_value (dimension_ordinate, "DIMENSION_ORDINATE", "lspace_factor", &lspace_factor, NULL)
        && lspace_factor == dimension_ordinate->lspace_factor)
      pass ();
    else
      fail ("DIMENSION_ORDINATE.lspace_factor [BD] %g != %g", dimension_ordinate->lspace_factor, lspace_factor);
    lspace_factor++;
    if (dwg_dynapi_entity_set_value (dimension_ordinate, "DIMENSION_ORDINATE", "lspace_factor", &lspace_factor, 0)
        && lspace_factor == dimension_ordinate->lspace_factor)
      pass ();
    else
      fail ("DIMENSION_ORDINATE.lspace_factor [BD] set+1 %g != %g", dimension_ordinate->lspace_factor, lspace_factor);
    dimension_ordinate->lspace_factor--;
  }
  {
    BITCODE_BS lspace_style;
    if (dwg_dynapi_entity_value (dimension_ordinate, "DIMENSION_ORDINATE", "lspace_style", &lspace_style, NULL)
        && lspace_style == dimension_ordinate->lspace_style)
      pass ();
    else
      fail ("DIMENSION_ORDINATE.lspace_style [BS] %hu != %hu", dimension_ordinate->lspace_style, lspace_style);
    lspace_style++;
    if (dwg_dynapi_entity_set_value (dimension_ordinate, "DIMENSION_ORDINATE", "lspace_style", &lspace_style, 0)
        && lspace_style == dimension_ordinate->lspace_style)
      pass ();
    else
      fail ("DIMENSION_ORDINATE.lspace_style [BS] set+1 %hu != %hu", dimension_ordinate->lspace_style, lspace_style);
    dimension_ordinate->lspace_style--;
  }
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value (dimension_ordinate, "DIMENSION_ORDINATE", "parent", &parent, NULL)
        && !memcmp (&parent, &dimension_ordinate->parent, sizeof (struct _dwg_object_entity*)))
        pass ();
    else
        fail ("DIMENSION_ORDINATE.parent [struct _dwg_object_entity*]");
  }
  {
    BITCODE_2RD text_midpt;
    if (dwg_dynapi_entity_value (dimension_ordinate, "DIMENSION_ORDINATE", "text_midpt", &text_midpt, NULL)
        && !memcmp (&text_midpt, &dimension_ordinate->text_midpt, sizeof (BITCODE_2RD)))
        pass ();
    else
        fail ("DIMENSION_ORDINATE.text_midpt [2RD]");
  }
  {
    BITCODE_BD text_rotation;
    if (dwg_dynapi_entity_value (dimension_ordinate, "DIMENSION_ORDINATE", "text_rotation", &text_rotation, NULL)
        && text_rotation == dimension_ordinate->text_rotation)
      pass ();
    else
      fail ("DIMENSION_ORDINATE.text_rotation [BD] %g != %g", dimension_ordinate->text_rotation, text_rotation);
    text_rotation++;
    if (dwg_dynapi_entity_set_value (dimension_ordinate, "DIMENSION_ORDINATE", "text_rotation", &text_rotation, 0)
        && text_rotation == dimension_ordinate->text_rotation)
      pass ();
    else
      fail ("DIMENSION_ORDINATE.text_rotation [BD] set+1 %g != %g", dimension_ordinate->text_rotation, text_rotation);
    dimension_ordinate->text_rotation--;
  }
  {
    BITCODE_B unknown;
    if (dwg_dynapi_entity_value (dimension_ordinate, "DIMENSION_ORDINATE", "unknown", &unknown, NULL)
        && unknown == dimension_ordinate->unknown)
      pass ();
    else
      fail ("DIMENSION_ORDINATE.unknown [B] " FORMAT_B " != " FORMAT_B "", dimension_ordinate->unknown, unknown);
    unknown++;
    if (dwg_dynapi_entity_set_value (dimension_ordinate, "DIMENSION_ORDINATE", "unknown", &unknown, 0)
        && unknown == dimension_ordinate->unknown)
      pass ();
    else
      fail ("DIMENSION_ORDINATE.unknown [B] set+1 " FORMAT_B " != " FORMAT_B "", dimension_ordinate->unknown, unknown);
    dimension_ordinate->unknown--;
  }
  {
    BITCODE_TV user_text;
    if (dwg_dynapi_entity_value (dimension_ordinate, "DIMENSION_ORDINATE", "user_text", &user_text, NULL)
        && user_text
           ? strEQ ((char *)user_text, (char *)dimension_ordinate->user_text)
           : !dimension_ordinate->user_text)
      pass ();
    else
      fail ("DIMENSION_ORDINATE.user_text [TV] '%s' <> '%s'", user_text, dimension_ordinate->user_text);
  }
  if (failed && (is_class_unstable ("DIMENSION_ORDINATE") || is_class_debugging ("DIMENSION_ORDINATE")))
    {
      ok ("%s failed %d tests (TODO unstable)", "DIMENSION_ORDINATE", failed);
      failed = 0;
    }
  return failed;
}
static int test_DIMENSION_RADIUS (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_DIMENSION_RADIUS *restrict dimension_radius = obj->tio.entity->tio.DIMENSION_RADIUS;
  failed = 0;
  {
    BITCODE_BD act_measurement;
    if (dwg_dynapi_entity_value (dimension_radius, "DIMENSION_RADIUS", "act_measurement", &act_measurement, NULL)
        && act_measurement == dimension_radius->act_measurement)
      pass ();
    else
      fail ("DIMENSION_RADIUS.act_measurement [BD] %g != %g", dimension_radius->act_measurement, act_measurement);
    act_measurement++;
    if (dwg_dynapi_entity_set_value (dimension_radius, "DIMENSION_RADIUS", "act_measurement", &act_measurement, 0)
        && act_measurement == dimension_radius->act_measurement)
      pass ();
    else
      fail ("DIMENSION_RADIUS.act_measurement [BD] set+1 %g != %g", dimension_radius->act_measurement, act_measurement);
    dimension_radius->act_measurement--;
  }
  {
    BITCODE_BS attachment;
    if (dwg_dynapi_entity_value (dimension_radius, "DIMENSION_RADIUS", "attachment", &attachment, NULL)
        && attachment == dimension_radius->attachment)
      pass ();
    else
      fail ("DIMENSION_RADIUS.attachment [BS] %hu != %hu", dimension_radius->attachment, attachment);
    attachment++;
    if (dwg_dynapi_entity_set_value (dimension_radius, "DIMENSION_RADIUS", "attachment", &attachment, 0)
        && attachment == dimension_radius->attachment)
      pass ();
    else
      fail ("DIMENSION_RADIUS.attachment [BS] set+1 %hu != %hu", dimension_radius->attachment, attachment);
    dimension_radius->attachment--;
  }
  {
    BITCODE_H block;
    if (dwg_dynapi_entity_value (dimension_radius, "DIMENSION_RADIUS", "block", &block, NULL)
        && !memcmp (&block, &dimension_radius->block, sizeof (BITCODE_H)))
        pass ();
    else
        fail ("DIMENSION_RADIUS.block [H]");
  }
  {
    BITCODE_TV blockname;
    if (dwg_dynapi_entity_value (dimension_radius, "DIMENSION_RADIUS", "blockname", &blockname, NULL)
        && blockname
           ? strEQ ((char *)blockname, (char *)dimension_radius->blockname)
           : !dimension_radius->blockname)
      pass ();
    else
      fail ("DIMENSION_RADIUS.blockname [TV] '%s' <> '%s'", blockname, dimension_radius->blockname);
  }
  {
    BITCODE_RC class_version;
    if (dwg_dynapi_entity_value (dimension_radius, "DIMENSION_RADIUS", "class_version", &class_version, NULL)
        && class_version == dimension_radius->class_version)
      pass ();
    else
      fail ("DIMENSION_RADIUS.class_version [RC] %u != %u", dimension_radius->class_version, class_version);
    class_version++;
    if (dwg_dynapi_entity_set_value (dimension_radius, "DIMENSION_RADIUS", "class_version", &class_version, 0)
        && class_version == dimension_radius->class_version)
      pass ();
    else
      fail ("DIMENSION_RADIUS.class_version [RC] set+1 %u != %u", dimension_radius->class_version, class_version);
    dimension_radius->class_version--;
  }
  {
    BITCODE_2RD clone_ins_pt;
    if (dwg_dynapi_entity_value (dimension_radius, "DIMENSION_RADIUS", "clone_ins_pt", &clone_ins_pt, NULL)
        && !memcmp (&clone_ins_pt, &dimension_radius->clone_ins_pt, sizeof (BITCODE_2RD)))
        pass ();
    else
        fail ("DIMENSION_RADIUS.clone_ins_pt [2RD]");
  }
  {
    BITCODE_3BD def_pt;
    if (dwg_dynapi_entity_value (dimension_radius, "DIMENSION_RADIUS", "def_pt", &def_pt, NULL)
        && !memcmp (&def_pt, &dimension_radius->def_pt, sizeof (BITCODE_3BD)))
        pass ();
    else
        fail ("DIMENSION_RADIUS.def_pt [3BD]");
  }
  {
    BITCODE_H dimstyle;
    if (dwg_dynapi_entity_value (dimension_radius, "DIMENSION_RADIUS", "dimstyle", &dimstyle, NULL)
        && !memcmp (&dimstyle, &dimension_radius->dimstyle, sizeof (BITCODE_H)))
        pass ();
    else
        fail ("DIMENSION_RADIUS.dimstyle [H]");
  }
  {
    BITCODE_BD elevation;
    if (dwg_dynapi_entity_value (dimension_radius, "DIMENSION_RADIUS", "elevation", &elevation, NULL)
        && elevation == dimension_radius->elevation)
      pass ();
    else
      fail ("DIMENSION_RADIUS.elevation [BD] %g != %g", dimension_radius->elevation, elevation);
    elevation++;
    if (dwg_dynapi_entity_set_value (dimension_radius, "DIMENSION_RADIUS", "elevation", &elevation, 0)
        && elevation == dimension_radius->elevation)
      pass ();
    else
      fail ("DIMENSION_RADIUS.elevation [BD] set+1 %g != %g", dimension_radius->elevation, elevation);
    dimension_radius->elevation--;
  }
  {
    BITCODE_BE extrusion;
    if (dwg_dynapi_entity_value (dimension_radius, "DIMENSION_RADIUS", "extrusion", &extrusion, NULL)
        && !memcmp (&extrusion, &dimension_radius->extrusion, sizeof (BITCODE_BE)))
        pass ();
    else
        fail ("DIMENSION_RADIUS.extrusion [BE]");
  }
  {
    BITCODE_3BD first_arc_pt;
    if (dwg_dynapi_entity_value (dimension_radius, "DIMENSION_RADIUS", "first_arc_pt", &first_arc_pt, NULL)
        && !memcmp (&first_arc_pt, &dimension_radius->first_arc_pt, sizeof (BITCODE_3BD)))
        pass ();
    else
        fail ("DIMENSION_RADIUS.first_arc_pt [3BD]");
  }
  {
    BITCODE_RC flag;
    if (dwg_dynapi_entity_value (dimension_radius, "DIMENSION_RADIUS", "flag", &flag, NULL)
        && flag == dimension_radius->flag)
      pass ();
    else
      fail ("DIMENSION_RADIUS.flag [RC] %u != %u", dimension_radius->flag, flag);
    flag++;
    if (dwg_dynapi_entity_set_value (dimension_radius, "DIMENSION_RADIUS", "flag", &flag, 0)
        && flag == dimension_radius->flag)
      pass ();
    else
      fail ("DIMENSION_RADIUS.flag [RC] set+1 %u != %u", dimension_radius->flag, flag);
    dimension_radius->flag--;
  }
  {
    BITCODE_RC flag1;
    if (dwg_dynapi_entity_value (dimension_radius, "DIMENSION_RADIUS", "flag1", &flag1, NULL)
        && flag1 == dimension_radius->flag1)
      pass ();
    else
      fail ("DIMENSION_RADIUS.flag1 [RC] %u != %u", dimension_radius->flag1, flag1);
    flag1++;
    if (dwg_dynapi_entity_set_value (dimension_radius, "DIMENSION_RADIUS", "flag1", &flag1, 0)
        && flag1 == dimension_radius->flag1)
      pass ();
    else
      fail ("DIMENSION_RADIUS.flag1 [RC] set+1 %u != %u", dimension_radius->flag1, flag1);
    dimension_radius->flag1--;
  }
  {
    BITCODE_B flip_arrow1;
    if (dwg_dynapi_entity_value (dimension_radius, "DIMENSION_RADIUS", "flip_arrow1", &flip_arrow1, NULL)
        && flip_arrow1 == dimension_radius->flip_arrow1)
      pass ();
    else
      fail ("DIMENSION_RADIUS.flip_arrow1 [B] " FORMAT_B " != " FORMAT_B "", dimension_radius->flip_arrow1, flip_arrow1);
    flip_arrow1++;
    if (dwg_dynapi_entity_set_value (dimension_radius, "DIMENSION_RADIUS", "flip_arrow1", &flip_arrow1, 0)
        && flip_arrow1 == dimension_radius->flip_arrow1)
      pass ();
    else
      fail ("DIMENSION_RADIUS.flip_arrow1 [B] set+1 " FORMAT_B " != " FORMAT_B "", dimension_radius->flip_arrow1, flip_arrow1);
    dimension_radius->flip_arrow1--;
  }
  {
    BITCODE_B flip_arrow2;
    if (dwg_dynapi_entity_value (dimension_radius, "DIMENSION_RADIUS", "flip_arrow2", &flip_arrow2, NULL)
        && flip_arrow2 == dimension_radius->flip_arrow2)
      pass ();
    else
      fail ("DIMENSION_RADIUS.flip_arrow2 [B] " FORMAT_B " != " FORMAT_B "", dimension_radius->flip_arrow2, flip_arrow2);
    flip_arrow2++;
    if (dwg_dynapi_entity_set_value (dimension_radius, "DIMENSION_RADIUS", "flip_arrow2", &flip_arrow2, 0)
        && flip_arrow2 == dimension_radius->flip_arrow2)
      pass ();
    else
      fail ("DIMENSION_RADIUS.flip_arrow2 [B] set+1 " FORMAT_B " != " FORMAT_B "", dimension_radius->flip_arrow2, flip_arrow2);
    dimension_radius->flip_arrow2--;
  }
  {
    BITCODE_BD horiz_dir;
    if (dwg_dynapi_entity_value (dimension_radius, "DIMENSION_RADIUS", "horiz_dir", &horiz_dir, NULL)
        && horiz_dir == dimension_radius->horiz_dir)
      pass ();
    else
      fail ("DIMENSION_RADIUS.horiz_dir [BD] %g != %g", dimension_radius->horiz_dir, horiz_dir);
    horiz_dir++;
    if (dwg_dynapi_entity_set_value (dimension_radius, "DIMENSION_RADIUS", "horiz_dir", &horiz_dir, 0)
        && horiz_dir == dimension_radius->horiz_dir)
      pass ();
    else
      fail ("DIMENSION_RADIUS.horiz_dir [BD] set+1 %g != %g", dimension_radius->horiz_dir, horiz_dir);
    dimension_radius->horiz_dir--;
  }
  {
    BITCODE_BD ins_rotation;
    if (dwg_dynapi_entity_value (dimension_radius, "DIMENSION_RADIUS", "ins_rotation", &ins_rotation, NULL)
        && ins_rotation == dimension_radius->ins_rotation)
      pass ();
    else
      fail ("DIMENSION_RADIUS.ins_rotation [BD] %g != %g", dimension_radius->ins_rotation, ins_rotation);
    ins_rotation++;
    if (dwg_dynapi_entity_set_value (dimension_radius, "DIMENSION_RADIUS", "ins_rotation", &ins_rotation, 0)
        && ins_rotation == dimension_radius->ins_rotation)
      pass ();
    else
      fail ("DIMENSION_RADIUS.ins_rotation [BD] set+1 %g != %g", dimension_radius->ins_rotation, ins_rotation);
    dimension_radius->ins_rotation--;
  }
  {
    BITCODE_3BD ins_scale;
    if (dwg_dynapi_entity_value (dimension_radius, "DIMENSION_RADIUS", "ins_scale", &ins_scale, NULL)
        && !memcmp (&ins_scale, &dimension_radius->ins_scale, sizeof (BITCODE_3BD)))
        pass ();
    else
        fail ("DIMENSION_RADIUS.ins_scale [3BD]");
  }
  {
    BITCODE_BD leader_len;
    if (dwg_dynapi_entity_value (dimension_radius, "DIMENSION_RADIUS", "leader_len", &leader_len, NULL)
        && leader_len == dimension_radius->leader_len)
      pass ();
    else
      fail ("DIMENSION_RADIUS.leader_len [BD] %g != %g", dimension_radius->leader_len, leader_len);
    leader_len++;
    if (dwg_dynapi_entity_set_value (dimension_radius, "DIMENSION_RADIUS", "leader_len", &leader_len, 0)
        && leader_len == dimension_radius->leader_len)
      pass ();
    else
      fail ("DIMENSION_RADIUS.leader_len [BD] set+1 %g != %g", dimension_radius->leader_len, leader_len);
    dimension_radius->leader_len--;
  }
  {
    BITCODE_BD lspace_factor;
    if (dwg_dynapi_entity_value (dimension_radius, "DIMENSION_RADIUS", "lspace_factor", &lspace_factor, NULL)
        && lspace_factor == dimension_radius->lspace_factor)
      pass ();
    else
      fail ("DIMENSION_RADIUS.lspace_factor [BD] %g != %g", dimension_radius->lspace_factor, lspace_factor);
    lspace_factor++;
    if (dwg_dynapi_entity_set_value (dimension_radius, "DIMENSION_RADIUS", "lspace_factor", &lspace_factor, 0)
        && lspace_factor == dimension_radius->lspace_factor)
      pass ();
    else
      fail ("DIMENSION_RADIUS.lspace_factor [BD] set+1 %g != %g", dimension_radius->lspace_factor, lspace_factor);
    dimension_radius->lspace_factor--;
  }
  {
    BITCODE_BS lspace_style;
    if (dwg_dynapi_entity_value (dimension_radius, "DIMENSION_RADIUS", "lspace_style", &lspace_style, NULL)
        && lspace_style == dimension_radius->lspace_style)
      pass ();
    else
      fail ("DIMENSION_RADIUS.lspace_style [BS] %hu != %hu", dimension_radius->lspace_style, lspace_style);
    lspace_style++;
    if (dwg_dynapi_entity_set_value (dimension_radius, "DIMENSION_RADIUS", "lspace_style", &lspace_style, 0)
        && lspace_style == dimension_radius->lspace_style)
      pass ();
    else
      fail ("DIMENSION_RADIUS.lspace_style [BS] set+1 %hu != %hu", dimension_radius->lspace_style, lspace_style);
    dimension_radius->lspace_style--;
  }
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value (dimension_radius, "DIMENSION_RADIUS", "parent", &parent, NULL)
        && !memcmp (&parent, &dimension_radius->parent, sizeof (struct _dwg_object_entity*)))
        pass ();
    else
        fail ("DIMENSION_RADIUS.parent [struct _dwg_object_entity*]");
  }
  {
    BITCODE_2RD text_midpt;
    if (dwg_dynapi_entity_value (dimension_radius, "DIMENSION_RADIUS", "text_midpt", &text_midpt, NULL)
        && !memcmp (&text_midpt, &dimension_radius->text_midpt, sizeof (BITCODE_2RD)))
        pass ();
    else
        fail ("DIMENSION_RADIUS.text_midpt [2RD]");
  }
  {
    BITCODE_BD text_rotation;
    if (dwg_dynapi_entity_value (dimension_radius, "DIMENSION_RADIUS", "text_rotation", &text_rotation, NULL)
        && text_rotation == dimension_radius->text_rotation)
      pass ();
    else
      fail ("DIMENSION_RADIUS.text_rotation [BD] %g != %g", dimension_radius->text_rotation, text_rotation);
    text_rotation++;
    if (dwg_dynapi_entity_set_value (dimension_radius, "DIMENSION_RADIUS", "text_rotation", &text_rotation, 0)
        && text_rotation == dimension_radius->text_rotation)
      pass ();
    else
      fail ("DIMENSION_RADIUS.text_rotation [BD] set+1 %g != %g", dimension_radius->text_rotation, text_rotation);
    dimension_radius->text_rotation--;
  }
  {
    BITCODE_B unknown;
    if (dwg_dynapi_entity_value (dimension_radius, "DIMENSION_RADIUS", "unknown", &unknown, NULL)
        && unknown == dimension_radius->unknown)
      pass ();
    else
      fail ("DIMENSION_RADIUS.unknown [B] " FORMAT_B " != " FORMAT_B "", dimension_radius->unknown, unknown);
    unknown++;
    if (dwg_dynapi_entity_set_value (dimension_radius, "DIMENSION_RADIUS", "unknown", &unknown, 0)
        && unknown == dimension_radius->unknown)
      pass ();
    else
      fail ("DIMENSION_RADIUS.unknown [B] set+1 " FORMAT_B " != " FORMAT_B "", dimension_radius->unknown, unknown);
    dimension_radius->unknown--;
  }
  {
    BITCODE_TV user_text;
    if (dwg_dynapi_entity_value (dimension_radius, "DIMENSION_RADIUS", "user_text", &user_text, NULL)
        && user_text
           ? strEQ ((char *)user_text, (char *)dimension_radius->user_text)
           : !dimension_radius->user_text)
      pass ();
    else
      fail ("DIMENSION_RADIUS.user_text [TV] '%s' <> '%s'", user_text, dimension_radius->user_text);
  }
  if (failed && (is_class_unstable ("DIMENSION_RADIUS") || is_class_debugging ("DIMENSION_RADIUS")))
    {
      ok ("%s failed %d tests (TODO unstable)", "DIMENSION_RADIUS", failed);
      failed = 0;
    }
  return failed;
}
static int test_ELLIPSE (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_ELLIPSE *restrict ellipse = obj->tio.entity->tio.ELLIPSE;
  failed = 0;
  {
    BITCODE_BD axis_ratio;
    if (dwg_dynapi_entity_value (ellipse, "ELLIPSE", "axis_ratio", &axis_ratio, NULL)
        && axis_ratio == ellipse->axis_ratio)
      pass ();
    else
      fail ("ELLIPSE.axis_ratio [BD] %g != %g", ellipse->axis_ratio, axis_ratio);
    axis_ratio++;
    if (dwg_dynapi_entity_set_value (ellipse, "ELLIPSE", "axis_ratio", &axis_ratio, 0)
        && axis_ratio == ellipse->axis_ratio)
      pass ();
    else
      fail ("ELLIPSE.axis_ratio [BD] set+1 %g != %g", ellipse->axis_ratio, axis_ratio);
    ellipse->axis_ratio--;
  }
  {
    BITCODE_3BD center;
    if (dwg_dynapi_entity_value (ellipse, "ELLIPSE", "center", &center, NULL)
        && !memcmp (&center, &ellipse->center, sizeof (BITCODE_3BD)))
        pass ();
    else
        fail ("ELLIPSE.center [3BD]");
  }
  {
    BITCODE_BD end_angle;
    if (dwg_dynapi_entity_value (ellipse, "ELLIPSE", "end_angle", &end_angle, NULL)
        && end_angle == ellipse->end_angle)
      pass ();
    else
      fail ("ELLIPSE.end_angle [BD] %g != %g", ellipse->end_angle, end_angle);
    end_angle++;
    if (dwg_dynapi_entity_set_value (ellipse, "ELLIPSE", "end_angle", &end_angle, 0)
        && end_angle == ellipse->end_angle)
      pass ();
    else
      fail ("ELLIPSE.end_angle [BD] set+1 %g != %g", ellipse->end_angle, end_angle);
    ellipse->end_angle--;
  }
  {
    BITCODE_BE extrusion;
    if (dwg_dynapi_entity_value (ellipse, "ELLIPSE", "extrusion", &extrusion, NULL)
        && !memcmp (&extrusion, &ellipse->extrusion, sizeof (BITCODE_BE)))
        pass ();
    else
        fail ("ELLIPSE.extrusion [BE]");
  }
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value (ellipse, "ELLIPSE", "parent", &parent, NULL)
        && !memcmp (&parent, &ellipse->parent, sizeof (struct _dwg_object_entity*)))
        pass ();
    else
        fail ("ELLIPSE.parent [struct _dwg_object_entity*]");
  }
  {
    BITCODE_3BD sm_axis;
    if (dwg_dynapi_entity_value (ellipse, "ELLIPSE", "sm_axis", &sm_axis, NULL)
        && !memcmp (&sm_axis, &ellipse->sm_axis, sizeof (BITCODE_3BD)))
        pass ();
    else
        fail ("ELLIPSE.sm_axis [3BD]");
  }
  {
    BITCODE_BD start_angle;
    if (dwg_dynapi_entity_value (ellipse, "ELLIPSE", "start_angle", &start_angle, NULL)
        && start_angle == ellipse->start_angle)
      pass ();
    else
      fail ("ELLIPSE.start_angle [BD] %g != %g", ellipse->start_angle, start_angle);
    start_angle++;
    if (dwg_dynapi_entity_set_value (ellipse, "ELLIPSE", "start_angle", &start_angle, 0)
        && start_angle == ellipse->start_angle)
      pass ();
    else
      fail ("ELLIPSE.start_angle [BD] set+1 %g != %g", ellipse->start_angle, start_angle);
    ellipse->start_angle--;
  }
  if (failed && (is_class_unstable ("ELLIPSE") || is_class_debugging ("ELLIPSE")))
    {
      ok ("%s failed %d tests (TODO unstable)", "ELLIPSE", failed);
      failed = 0;
    }
  return failed;
}
static int test_ENDBLK (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_ENDBLK *restrict endblk = obj->tio.entity->tio.ENDBLK;
  failed = 0;
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value (endblk, "ENDBLK", "parent", &parent, NULL)
        && !memcmp (&parent, &endblk->parent, sizeof (struct _dwg_object_entity*)))
        pass ();
    else
        fail ("ENDBLK.parent [struct _dwg_object_entity*]");
  }
  if (failed && (is_class_unstable ("ENDBLK") || is_class_debugging ("ENDBLK")))
    {
      ok ("%s failed %d tests (TODO unstable)", "ENDBLK", failed);
      failed = 0;
    }
  return failed;
}
static int test_EXTRUDEDSURFACE (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_EXTRUDEDSURFACE *restrict extrudedsurface = obj->tio.entity->tio.EXTRUDEDSURFACE;
  failed = 0;
  {
    BITCODE_B _dxf_sab_converted;
    if (dwg_dynapi_entity_value (extrudedsurface, "EXTRUDEDSURFACE", "_dxf_sab_converted", &_dxf_sab_converted, NULL)
        && _dxf_sab_converted == extrudedsurface->_dxf_sab_converted)
      pass ();
    else
      fail ("EXTRUDEDSURFACE._dxf_sab_converted [B] " FORMAT_B " != " FORMAT_B "", extrudedsurface->_dxf_sab_converted, _dxf_sab_converted);
    _dxf_sab_converted++;
    if (dwg_dynapi_entity_set_value (extrudedsurface, "EXTRUDEDSURFACE", "_dxf_sab_converted", &_dxf_sab_converted, 0)
        && _dxf_sab_converted == extrudedsurface->_dxf_sab_converted)
      pass ();
    else
      fail ("EXTRUDEDSURFACE._dxf_sab_converted [B] set+1 " FORMAT_B " != " FORMAT_B "", extrudedsurface->_dxf_sab_converted, _dxf_sab_converted);
    extrudedsurface->_dxf_sab_converted--;
  }
  {
    BITCODE_RC* acis_data;
    if (dwg_dynapi_entity_value (extrudedsurface, "EXTRUDEDSURFACE", "acis_data", &acis_data, NULL)
        && acis_data
           ? strEQ ((char *)acis_data, (char *)extrudedsurface->acis_data)
           : !extrudedsurface->acis_data)
      pass ();
    else
      fail ("EXTRUDEDSURFACE.acis_data [RC*] '%s' <> '%s'", acis_data, extrudedsurface->acis_data);
  }
  {
    BITCODE_B acis_empty;
    if (dwg_dynapi_entity_value (extrudedsurface, "EXTRUDEDSURFACE", "acis_empty", &acis_empty, NULL)
        && acis_empty == extrudedsurface->acis_empty)
      pass ();
    else
      fail ("EXTRUDEDSURFACE.acis_empty [B] " FORMAT_B " != " FORMAT_B "", extrudedsurface->acis_empty, acis_empty);
    acis_empty++;
    if (dwg_dynapi_entity_set_value (extrudedsurface, "EXTRUDEDSURFACE", "acis_empty", &acis_empty, 0)
        && acis_empty == extrudedsurface->acis_empty)
      pass ();
    else
      fail ("EXTRUDEDSURFACE.acis_empty [B] set+1 " FORMAT_B " != " FORMAT_B "", extrudedsurface->acis_empty, acis_empty);
    extrudedsurface->acis_empty--;
  }
  {
    BITCODE_B acis_empty2;
    if (dwg_dynapi_entity_value (extrudedsurface, "EXTRUDEDSURFACE", "acis_empty2", &acis_empty2, NULL)
        && acis_empty2 == extrudedsurface->acis_empty2)
      pass ();
    else
      fail ("EXTRUDEDSURFACE.acis_empty2 [B] " FORMAT_B " != " FORMAT_B "", extrudedsurface->acis_empty2, acis_empty2);
    acis_empty2++;
    if (dwg_dynapi_entity_set_value (extrudedsurface, "EXTRUDEDSURFACE", "acis_empty2", &acis_empty2, 0)
        && acis_empty2 == extrudedsurface->acis_empty2)
      pass ();
    else
      fail ("EXTRUDEDSURFACE.acis_empty2 [B] set+1 " FORMAT_B " != " FORMAT_B "", extrudedsurface->acis_empty2, acis_empty2);
    extrudedsurface->acis_empty2--;
  }
  {
    BITCODE_B acis_empty_bit;
    if (dwg_dynapi_entity_value (extrudedsurface, "EXTRUDEDSURFACE", "acis_empty_bit", &acis_empty_bit, NULL)
        && acis_empty_bit == extrudedsurface->acis_empty_bit)
      pass ();
    else
      fail ("EXTRUDEDSURFACE.acis_empty_bit [B] " FORMAT_B " != " FORMAT_B "", extrudedsurface->acis_empty_bit, acis_empty_bit);
    acis_empty_bit++;
    if (dwg_dynapi_entity_set_value (extrudedsurface, "EXTRUDEDSURFACE", "acis_empty_bit", &acis_empty_bit, 0)
        && acis_empty_bit == extrudedsurface->acis_empty_bit)
      pass ();
    else
      fail ("EXTRUDEDSURFACE.acis_empty_bit [B] set+1 " FORMAT_B " != " FORMAT_B "", extrudedsurface->acis_empty_bit, acis_empty_bit);
    extrudedsurface->acis_empty_bit--;
  }
  {
    BITCODE_BD align_angle;
    if (dwg_dynapi_entity_value (extrudedsurface, "EXTRUDEDSURFACE", "align_angle", &align_angle, NULL)
        && align_angle == extrudedsurface->align_angle)
      pass ();
    else
      fail ("EXTRUDEDSURFACE.align_angle [BD] %g != %g", extrudedsurface->align_angle, align_angle);
    align_angle++;
    if (dwg_dynapi_entity_set_value (extrudedsurface, "EXTRUDEDSURFACE", "align_angle", &align_angle, 0)
        && align_angle == extrudedsurface->align_angle)
      pass ();
    else
      fail ("EXTRUDEDSURFACE.align_angle [BD] set+1 %g != %g", extrudedsurface->align_angle, align_angle);
    extrudedsurface->align_angle--;
  }
  {
    BITCODE_B align_start;
    if (dwg_dynapi_entity_value (extrudedsurface, "EXTRUDEDSURFACE", "align_start", &align_start, NULL)
        && align_start == extrudedsurface->align_start)
      pass ();
    else
      fail ("EXTRUDEDSURFACE.align_start [B] " FORMAT_B " != " FORMAT_B "", extrudedsurface->align_start, align_start);
    align_start++;
    if (dwg_dynapi_entity_set_value (extrudedsurface, "EXTRUDEDSURFACE", "align_start", &align_start, 0)
        && align_start == extrudedsurface->align_start)
      pass ();
    else
      fail ("EXTRUDEDSURFACE.align_start [B] set+1 " FORMAT_B " != " FORMAT_B "", extrudedsurface->align_start, align_start);
    extrudedsurface->align_start--;
  }
  {
    BITCODE_B bank;
    if (dwg_dynapi_entity_value (extrudedsurface, "EXTRUDEDSURFACE", "bank", &bank, NULL)
        && bank == extrudedsurface->bank)
      pass ();
    else
      fail ("EXTRUDEDSURFACE.bank [B] " FORMAT_B " != " FORMAT_B "", extrudedsurface->bank, bank);
    bank++;
    if (dwg_dynapi_entity_set_value (extrudedsurface, "EXTRUDEDSURFACE", "bank", &bank, 0)
        && bank == extrudedsurface->bank)
      pass ();
    else
      fail ("EXTRUDEDSURFACE.bank [B] set+1 " FORMAT_B " != " FORMAT_B "", extrudedsurface->bank, bank);
    extrudedsurface->bank--;
  }
  {
    BITCODE_B base_point_set;
    if (dwg_dynapi_entity_value (extrudedsurface, "EXTRUDEDSURFACE", "base_point_set", &base_point_set, NULL)
        && base_point_set == extrudedsurface->base_point_set)
      pass ();
    else
      fail ("EXTRUDEDSURFACE.base_point_set [B] " FORMAT_B " != " FORMAT_B "", extrudedsurface->base_point_set, base_point_set);
    base_point_set++;
    if (dwg_dynapi_entity_set_value (extrudedsurface, "EXTRUDEDSURFACE", "base_point_set", &base_point_set, 0)
        && base_point_set == extrudedsurface->base_point_set)
      pass ();
    else
      fail ("EXTRUDEDSURFACE.base_point_set [B] set+1 " FORMAT_B " != " FORMAT_B "", extrudedsurface->base_point_set, base_point_set);
    extrudedsurface->base_point_set--;
  }
  {
    BITCODE_TF bindata;
    if (dwg_dynapi_entity_value (extrudedsurface, "EXTRUDEDSURFACE", "bindata", &bindata, NULL)
        && !memcmp (&bindata, &extrudedsurface->bindata, sizeof (BITCODE_TF)))
        pass ();
    else
        fail ("EXTRUDEDSURFACE.bindata [TF]");
  }
  {
    BITCODE_BL bindata_size;
    if (dwg_dynapi_entity_value (extrudedsurface, "EXTRUDEDSURFACE", "bindata_size", &bindata_size, NULL)
        && bindata_size == extrudedsurface->bindata_size)
      pass ();
    else
      fail ("EXTRUDEDSURFACE.bindata_size [BL] %u != %u", extrudedsurface->bindata_size, bindata_size);
    bindata_size++;
    if (dwg_dynapi_entity_set_value (extrudedsurface, "EXTRUDEDSURFACE", "bindata_size", &bindata_size, 0)
        && bindata_size == extrudedsurface->bindata_size)
      pass ();
    else
      fail ("EXTRUDEDSURFACE.bindata_size [BL] set+1 %u != %u", extrudedsurface->bindata_size, bindata_size);
    extrudedsurface->bindata_size--;
  }
  {
    BITCODE_BL* block_size;
    if (dwg_dynapi_entity_value (extrudedsurface, "EXTRUDEDSURFACE", "block_size", &block_size, NULL)
        && !memcmp (&block_size, &extrudedsurface->block_size, sizeof (BITCODE_BL*)))
        pass ();
    else
        fail ("EXTRUDEDSURFACE.block_size [BL*]");
  }
  {
    BITCODE_BL class_version;
    if (dwg_dynapi_entity_value (extrudedsurface, "EXTRUDEDSURFACE", "class_version", &class_version, NULL)
        && class_version == extrudedsurface->class_version)
      pass ();
    else
      fail ("EXTRUDEDSURFACE.class_version [BL] %u != %u", extrudedsurface->class_version, class_version);
    class_version++;
    if (dwg_dynapi_entity_set_value (extrudedsurface, "EXTRUDEDSURFACE", "class_version", &class_version, 0)
        && class_version == extrudedsurface->class_version)
      pass ();
    else
      fail ("EXTRUDEDSURFACE.class_version [BL] set+1 %u != %u", extrudedsurface->class_version, class_version);
    extrudedsurface->class_version--;
  }
  {
    BITCODE_BD draft_angle;
    if (dwg_dynapi_entity_value (extrudedsurface, "EXTRUDEDSURFACE", "draft_angle", &draft_angle, NULL)
        && draft_angle == extrudedsurface->draft_angle)
      pass ();
    else
      fail ("EXTRUDEDSURFACE.draft_angle [BD] %g != %g", extrudedsurface->draft_angle, draft_angle);
    draft_angle++;
    if (dwg_dynapi_entity_set_value (extrudedsurface, "EXTRUDEDSURFACE", "draft_angle", &draft_angle, 0)
        && draft_angle == extrudedsurface->draft_angle)
      pass ();
    else
      fail ("EXTRUDEDSURFACE.draft_angle [BD] set+1 %g != %g", extrudedsurface->draft_angle, draft_angle);
    extrudedsurface->draft_angle--;
  }
  {
    BITCODE_BD draft_end_distance;
    if (dwg_dynapi_entity_value (extrudedsurface, "EXTRUDEDSURFACE", "draft_end_distance", &draft_end_distance, NULL)
        && draft_end_distance == extrudedsurface->draft_end_distance)
      pass ();
    else
      fail ("EXTRUDEDSURFACE.draft_end_distance [BD] %g != %g", extrudedsurface->draft_end_distance, draft_end_distance);
    draft_end_distance++;
    if (dwg_dynapi_entity_set_value (extrudedsurface, "EXTRUDEDSURFACE", "draft_end_distance", &draft_end_distance, 0)
        && draft_end_distance == extrudedsurface->draft_end_distance)
      pass ();
    else
      fail ("EXTRUDEDSURFACE.draft_end_distance [BD] set+1 %g != %g", extrudedsurface->draft_end_distance, draft_end_distance);
    extrudedsurface->draft_end_distance--;
  }
  {
    BITCODE_BD draft_start_distance;
    if (dwg_dynapi_entity_value (extrudedsurface, "EXTRUDEDSURFACE", "draft_start_distance", &draft_start_distance, NULL)
        && draft_start_distance == extrudedsurface->draft_start_distance)
      pass ();
    else
      fail ("EXTRUDEDSURFACE.draft_start_distance [BD] %g != %g", extrudedsurface->draft_start_distance, draft_start_distance);
    draft_start_distance++;
    if (dwg_dynapi_entity_set_value (extrudedsurface, "EXTRUDEDSURFACE", "draft_start_distance", &draft_start_distance, 0)
        && draft_start_distance == extrudedsurface->draft_start_distance)
      pass ();
    else
      fail ("EXTRUDEDSURFACE.draft_start_distance [BD] set+1 %g != %g", extrudedsurface->draft_start_distance, draft_start_distance);
    extrudedsurface->draft_start_distance--;
  }
  {
    char ** encr_sat_data;
    if (dwg_dynapi_entity_value (extrudedsurface, "EXTRUDEDSURFACE", "encr_sat_data", &encr_sat_data, NULL)
        && !memcmp (&encr_sat_data, &extrudedsurface->encr_sat_data, sizeof (extrudedsurface->encr_sat_data)))
      pass ();
    else
      fail ("EXTRUDEDSURFACE.encr_sat_data [char **]");
  }
  {
    BITCODE_BL end_marker;
    if (dwg_dynapi_entity_value (extrudedsurface, "EXTRUDEDSURFACE", "end_marker", &end_marker, NULL)
        && end_marker == extrudedsurface->end_marker)
      pass ();
    else
      fail ("EXTRUDEDSURFACE.end_marker [BL] %u != %u", extrudedsurface->end_marker, end_marker);
    end_marker++;
    if (dwg_dynapi_entity_set_value (extrudedsurface, "EXTRUDEDSURFACE", "end_marker", &end_marker, 0)
        && end_marker == extrudedsurface->end_marker)
      pass ();
    else
      fail ("EXTRUDEDSURFACE.end_marker [BL] set+1 %u != %u", extrudedsurface->end_marker, end_marker);
    extrudedsurface->end_marker--;
  }
  {
    struct _dwg_entity_3DSOLID* extra_acis_data;
    if (dwg_dynapi_entity_value (extrudedsurface, "EXTRUDEDSURFACE", "extra_acis_data", &extra_acis_data, NULL)
        && !memcmp (&extra_acis_data, &extrudedsurface->extra_acis_data, sizeof (struct _dwg_entity_3DSOLID*)))
        pass ();
    else
        fail ("EXTRUDEDSURFACE.extra_acis_data [struct _dwg_entity_3DSOLID*]");
  }
  {
    BITCODE_B has_revision_guid;
    if (dwg_dynapi_entity_value (extrudedsurface, "EXTRUDEDSURFACE", "has_revision_guid", &has_revision_guid, NULL)
        && has_revision_guid == extrudedsurface->has_revision_guid)
      pass ();
    else
      fail ("EXTRUDEDSURFACE.has_revision_guid [B] " FORMAT_B " != " FORMAT_B "", extrudedsurface->has_revision_guid, has_revision_guid);
    has_revision_guid++;
    if (dwg_dynapi_entity_set_value (extrudedsurface, "EXTRUDEDSURFACE", "has_revision_guid", &has_revision_guid, 0)
        && has_revision_guid == extrudedsurface->has_revision_guid)
      pass ();
    else
      fail ("EXTRUDEDSURFACE.has_revision_guid [B] set+1 " FORMAT_B " != " FORMAT_B "", extrudedsurface->has_revision_guid, has_revision_guid);
    extrudedsurface->has_revision_guid--;
  }
  {
    BITCODE_H history_id;
    if (dwg_dynapi_entity_value (extrudedsurface, "EXTRUDEDSURFACE", "history_id", &history_id, NULL)
        && !memcmp (&history_id, &extrudedsurface->history_id, sizeof (BITCODE_H)))
        pass ();
    else
        fail ("EXTRUDEDSURFACE.history_id [H]");
  }
  {
    BITCODE_B is_solid;
    if (dwg_dynapi_entity_value (extrudedsurface, "EXTRUDEDSURFACE", "is_solid", &is_solid, NULL)
        && is_solid == extrudedsurface->is_solid)
      pass ();
    else
      fail ("EXTRUDEDSURFACE.is_solid [B] " FORMAT_B " != " FORMAT_B "", extrudedsurface->is_solid, is_solid);
    is_solid++;
    if (dwg_dynapi_entity_set_value (extrudedsurface, "EXTRUDEDSURFACE", "is_solid", &is_solid, 0)
        && is_solid == extrudedsurface->is_solid)
      pass ();
    else
      fail ("EXTRUDEDSURFACE.is_solid [B] set+1 " FORMAT_B " != " FORMAT_B "", extrudedsurface->is_solid, is_solid);
    extrudedsurface->is_solid--;
  }
  {
    BITCODE_B isoline_present;
    if (dwg_dynapi_entity_value (extrudedsurface, "EXTRUDEDSURFACE", "isoline_present", &isoline_present, NULL)
        && isoline_present == extrudedsurface->isoline_present)
      pass ();
    else
      fail ("EXTRUDEDSURFACE.isoline_present [B] " FORMAT_B " != " FORMAT_B "", extrudedsurface->isoline_present, isoline_present);
    isoline_present++;
    if (dwg_dynapi_entity_set_value (extrudedsurface, "EXTRUDEDSURFACE", "isoline_present", &isoline_present, 0)
        && isoline_present == extrudedsurface->isoline_present)
      pass ();
    else
      fail ("EXTRUDEDSURFACE.isoline_present [B] set+1 " FORMAT_B " != " FORMAT_B "", extrudedsurface->isoline_present, isoline_present);
    extrudedsurface->isoline_present--;
  }
  {
    BITCODE_BL isolines;
    if (dwg_dynapi_entity_value (extrudedsurface, "EXTRUDEDSURFACE", "isolines", &isolines, NULL)
        && isolines == extrudedsurface->isolines)
      pass ();
    else
      fail ("EXTRUDEDSURFACE.isolines [BL] %u != %u", extrudedsurface->isolines, isolines);
    isolines++;
    if (dwg_dynapi_entity_set_value (extrudedsurface, "EXTRUDEDSURFACE", "isolines", &isolines, 0)
        && isolines == extrudedsurface->isolines)
      pass ();
    else
      fail ("EXTRUDEDSURFACE.isolines [BL] set+1 %u != %u", extrudedsurface->isolines, isolines);
    extrudedsurface->isolines--;
  }
  {
    Dwg_3DSOLID_material* materials;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (extrudedsurface, "EXTRUDEDSURFACE", "num_materials", &count, NULL)
        && dwg_dynapi_entity_value (extrudedsurface, "EXTRUDEDSURFACE", "materials", &materials, NULL)
        && materials == extrudedsurface->materials)
      pass ();
    else
      fail ("EXTRUDEDSURFACE.materials [Dwg_3DSOLID_material*] * %u num_materials", count);
  }
  {
    BITCODE_BS modeler_format_version;
    if (dwg_dynapi_entity_value (extrudedsurface, "EXTRUDEDSURFACE", "modeler_format_version", &modeler_format_version, NULL)
        && modeler_format_version == extrudedsurface->modeler_format_version)
      pass ();
    else
      fail ("EXTRUDEDSURFACE.modeler_format_version [BS] %hu != %hu", extrudedsurface->modeler_format_version, modeler_format_version);
    modeler_format_version++;
    if (dwg_dynapi_entity_set_value (extrudedsurface, "EXTRUDEDSURFACE", "modeler_format_version", &modeler_format_version, 0)
        && modeler_format_version == extrudedsurface->modeler_format_version)
      pass ();
    else
      fail ("EXTRUDEDSURFACE.modeler_format_version [BS] set+1 %hu != %hu", extrudedsurface->modeler_format_version, modeler_format_version);
    extrudedsurface->modeler_format_version--;
  }
  {
    BITCODE_BL num_blocks;
    if (dwg_dynapi_entity_value (extrudedsurface, "EXTRUDEDSURFACE", "num_blocks", &num_blocks, NULL)
        && num_blocks == extrudedsurface->num_blocks)
      pass ();
    else
      fail ("EXTRUDEDSURFACE.num_blocks [BL] %u != %u", extrudedsurface->num_blocks, num_blocks);
    num_blocks++;
    if (dwg_dynapi_entity_set_value (extrudedsurface, "EXTRUDEDSURFACE", "num_blocks", &num_blocks, 0)
        && num_blocks == extrudedsurface->num_blocks)
      pass ();
    else
      fail ("EXTRUDEDSURFACE.num_blocks [BL] set+1 %u != %u", extrudedsurface->num_blocks, num_blocks);
    extrudedsurface->num_blocks--;
  }
  {
    BITCODE_BL num_materials;
    if (dwg_dynapi_entity_value (extrudedsurface, "EXTRUDEDSURFACE", "num_materials", &num_materials, NULL)
        && num_materials == extrudedsurface->num_materials)
      pass ();
    else
      fail ("EXTRUDEDSURFACE.num_materials [BL] %u != %u", extrudedsurface->num_materials, num_materials);
    num_materials++;
    if (dwg_dynapi_entity_set_value (extrudedsurface, "EXTRUDEDSURFACE", "num_materials", &num_materials, 0)
        && num_materials == extrudedsurface->num_materials)
      pass ();
    else
      fail ("EXTRUDEDSURFACE.num_materials [BL] set+1 %u != %u", extrudedsurface->num_materials, num_materials);
    extrudedsurface->num_materials--;
  }
  {
    BITCODE_BL num_silhouettes;
    if (dwg_dynapi_entity_value (extrudedsurface, "EXTRUDEDSURFACE", "num_silhouettes", &num_silhouettes, NULL)
        && num_silhouettes == extrudedsurface->num_silhouettes)
      pass ();
    else
      fail ("EXTRUDEDSURFACE.num_silhouettes [BL] %u != %u", extrudedsurface->num_silhouettes, num_silhouettes);
    num_silhouettes++;
    if (dwg_dynapi_entity_set_value (extrudedsurface, "EXTRUDEDSURFACE", "num_silhouettes", &num_silhouettes, 0)
        && num_silhouettes == extrudedsurface->num_silhouettes)
      pass ();
    else
      fail ("EXTRUDEDSURFACE.num_silhouettes [BL] set+1 %u != %u", extrudedsurface->num_silhouettes, num_silhouettes);
    extrudedsurface->num_silhouettes--;
  }
  {
    BITCODE_BL num_wires;
    if (dwg_dynapi_entity_value (extrudedsurface, "EXTRUDEDSURFACE", "num_wires", &num_wires, NULL)
        && num_wires == extrudedsurface->num_wires)
      pass ();
    else
      fail ("EXTRUDEDSURFACE.num_wires [BL] %u != %u", extrudedsurface->num_wires, num_wires);
    num_wires++;
    if (dwg_dynapi_entity_set_value (extrudedsurface, "EXTRUDEDSURFACE", "num_wires", &num_wires, 0)
        && num_wires == extrudedsurface->num_wires)
      pass ();
    else
      fail ("EXTRUDEDSURFACE.num_wires [BL] set+1 %u != %u", extrudedsurface->num_wires, num_wires);
    extrudedsurface->num_wires--;
  }
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value (extrudedsurface, "EXTRUDEDSURFACE", "parent", &parent, NULL)
        && !memcmp (&parent, &extrudedsurface->parent, sizeof (struct _dwg_object_entity*)))
        pass ();
    else
        fail ("EXTRUDEDSURFACE.parent [struct _dwg_object_entity*]");
  }
  {
    BITCODE_H path_entity;
    if (dwg_dynapi_entity_value (extrudedsurface, "EXTRUDEDSURFACE", "path_entity", &path_entity, NULL)
        && !memcmp (&path_entity, &extrudedsurface->path_entity, sizeof (BITCODE_H)))
        pass ();
    else
        fail ("EXTRUDEDSURFACE.path_entity [H]");
  }
  {
    BITCODE_B path_entity_transform_computed;
    if (dwg_dynapi_entity_value (extrudedsurface, "EXTRUDEDSURFACE", "path_entity_transform_computed", &path_entity_transform_computed, NULL)
        && path_entity_transform_computed == extrudedsurface->path_entity_transform_computed)
      pass ();
    else
      fail ("EXTRUDEDSURFACE.path_entity_transform_computed [B] " FORMAT_B " != " FORMAT_B "", extrudedsurface->path_entity_transform_computed, path_entity_transform_computed);
    path_entity_transform_computed++;
    if (dwg_dynapi_entity_set_value (extrudedsurface, "EXTRUDEDSURFACE", "path_entity_transform_computed", &path_entity_transform_computed, 0)
        && path_entity_transform_computed == extrudedsurface->path_entity_transform_computed)
      pass ();
    else
      fail ("EXTRUDEDSURFACE.path_entity_transform_computed [B] set+1 " FORMAT_B " != " FORMAT_B "", extrudedsurface->path_entity_transform_computed, path_entity_transform_computed);
    extrudedsurface->path_entity_transform_computed--;
  }
  {
    BITCODE_BD* path_entity_transmatrix;
    if (dwg_dynapi_entity_value (extrudedsurface, "EXTRUDEDSURFACE", "path_entity_transmatrix", &path_entity_transmatrix, NULL)
        && !memcmp (&path_entity_transmatrix, &extrudedsurface->path_entity_transmatrix, sizeof (BITCODE_BD*)))
        pass ();
    else
        fail ("EXTRUDEDSURFACE.path_entity_transmatrix [BD*]");
  }
  {
    BITCODE_BS path_flags;
    if (dwg_dynapi_entity_value (extrudedsurface, "EXTRUDEDSURFACE", "path_flags", &path_flags, NULL)
        && path_flags == extrudedsurface->path_flags)
      pass ();
    else
      fail ("EXTRUDEDSURFACE.path_flags [BS] %hu != %hu", extrudedsurface->path_flags, path_flags);
    path_flags++;
    if (dwg_dynapi_entity_set_value (extrudedsurface, "EXTRUDEDSURFACE", "path_flags", &path_flags, 0)
        && path_flags == extrudedsurface->path_flags)
      pass ();
    else
      fail ("EXTRUDEDSURFACE.path_flags [BS] set+1 %hu != %hu", extrudedsurface->path_flags, path_flags);
    extrudedsurface->path_flags--;
  }
  {
    BITCODE_3BD point;
    if (dwg_dynapi_entity_value (extrudedsurface, "EXTRUDEDSURFACE", "point", &point, NULL)
        && !memcmp (&point, &extrudedsurface->point, sizeof (BITCODE_3BD)))
        pass ();
    else
        fail ("EXTRUDEDSURFACE.point [3BD]");
  }
  {
    BITCODE_B point_present;
    if (dwg_dynapi_entity_value (extrudedsurface, "EXTRUDEDSURFACE", "point_present", &point_present, NULL)
        && point_present == extrudedsurface->point_present)
      pass ();
    else
      fail ("EXTRUDEDSURFACE.point_present [B] " FORMAT_B " != " FORMAT_B "", extrudedsurface->point_present, point_present);
    point_present++;
    if (dwg_dynapi_entity_set_value (extrudedsurface, "EXTRUDEDSURFACE", "point_present", &point_present, 0)
        && point_present == extrudedsurface->point_present)
      pass ();
    else
      fail ("EXTRUDEDSURFACE.point_present [B] set+1 " FORMAT_B " != " FORMAT_B "", extrudedsurface->point_present, point_present);
    extrudedsurface->point_present--;
  }
  {
    BITCODE_3BD reference_vector_for_controlling_twist;
    if (dwg_dynapi_entity_value (extrudedsurface, "EXTRUDEDSURFACE", "reference_vector_for_controlling_twist", &reference_vector_for_controlling_twist, NULL)
        && !memcmp (&reference_vector_for_controlling_twist, &extrudedsurface->reference_vector_for_controlling_twist, sizeof (BITCODE_3BD)))
        pass ();
    else
        fail ("EXTRUDEDSURFACE.reference_vector_for_controlling_twist [3BD]");
  }
  {
    BITCODE_RC revision_bytes[9];
    if (dwg_dynapi_entity_value (extrudedsurface, "EXTRUDEDSURFACE", "revision_bytes[9]", &revision_bytes, NULL)
        && !memcmp (&revision_bytes, &extrudedsurface->revision_bytes, sizeof (BITCODE_RC)))
        pass ();
    else
        fail ("EXTRUDEDSURFACE.revision_bytes[9] [RC]");
  }
  {
    BITCODE_RC revision_guid[39];
    if (dwg_dynapi_entity_value (extrudedsurface, "EXTRUDEDSURFACE", "revision_guid[39]", &revision_guid, NULL)
        && !memcmp (&revision_guid, &extrudedsurface->revision_guid, sizeof (BITCODE_RC)))
        pass ();
    else
        fail ("EXTRUDEDSURFACE.revision_guid[39] [RC]");
  }
  {
    BITCODE_BL revision_major;
    if (dwg_dynapi_entity_value (extrudedsurface, "EXTRUDEDSURFACE", "revision_major", &revision_major, NULL)
        && revision_major == extrudedsurface->revision_major)
      pass ();
    else
      fail ("EXTRUDEDSURFACE.revision_major [BL] %u != %u", extrudedsurface->revision_major, revision_major);
    revision_major++;
    if (dwg_dynapi_entity_set_value (extrudedsurface, "EXTRUDEDSURFACE", "revision_major", &revision_major, 0)
        && revision_major == extrudedsurface->revision_major)
      pass ();
    else
      fail ("EXTRUDEDSURFACE.revision_major [BL] set+1 %u != %u", extrudedsurface->revision_major, revision_major);
    extrudedsurface->revision_major--;
  }
  {
    BITCODE_BS revision_minor1;
    if (dwg_dynapi_entity_value (extrudedsurface, "EXTRUDEDSURFACE", "revision_minor1", &revision_minor1, NULL)
        && revision_minor1 == extrudedsurface->revision_minor1)
      pass ();
    else
      fail ("EXTRUDEDSURFACE.revision_minor1 [BS] %hu != %hu", extrudedsurface->revision_minor1, revision_minor1);
    revision_minor1++;
    if (dwg_dynapi_entity_set_value (extrudedsurface, "EXTRUDEDSURFACE", "revision_minor1", &revision_minor1, 0)
        && revision_minor1 == extrudedsurface->revision_minor1)
      pass ();
    else
      fail ("EXTRUDEDSURFACE.revision_minor1 [BS] set+1 %hu != %hu", extrudedsurface->revision_minor1, revision_minor1);
    extrudedsurface->revision_minor1--;
  }
  {
    BITCODE_BS revision_minor2;
    if (dwg_dynapi_entity_value (extrudedsurface, "EXTRUDEDSURFACE", "revision_minor2", &revision_minor2, NULL)
        && revision_minor2 == extrudedsurface->revision_minor2)
      pass ();
    else
      fail ("EXTRUDEDSURFACE.revision_minor2 [BS] %hu != %hu", extrudedsurface->revision_minor2, revision_minor2);
    revision_minor2++;
    if (dwg_dynapi_entity_set_value (extrudedsurface, "EXTRUDEDSURFACE", "revision_minor2", &revision_minor2, 0)
        && revision_minor2 == extrudedsurface->revision_minor2)
      pass ();
    else
      fail ("EXTRUDEDSURFACE.revision_minor2 [BS] set+1 %hu != %hu", extrudedsurface->revision_minor2, revision_minor2);
    extrudedsurface->revision_minor2--;
  }
  {
    BITCODE_BL sab_size;
    if (dwg_dynapi_entity_value (extrudedsurface, "EXTRUDEDSURFACE", "sab_size", &sab_size, NULL)
        && sab_size == extrudedsurface->sab_size)
      pass ();
    else
      fail ("EXTRUDEDSURFACE.sab_size [BL] %u != %u", extrudedsurface->sab_size, sab_size);
    sab_size++;
    if (dwg_dynapi_entity_set_value (extrudedsurface, "EXTRUDEDSURFACE", "sab_size", &sab_size, 0)
        && sab_size == extrudedsurface->sab_size)
      pass ();
    else
      fail ("EXTRUDEDSURFACE.sab_size [BL] set+1 %u != %u", extrudedsurface->sab_size, sab_size);
    extrudedsurface->sab_size--;
  }
  {
    BITCODE_BD scale_factor;
    if (dwg_dynapi_entity_value (extrudedsurface, "EXTRUDEDSURFACE", "scale_factor", &scale_factor, NULL)
        && scale_factor == extrudedsurface->scale_factor)
      pass ();
    else
      fail ("EXTRUDEDSURFACE.scale_factor [BD] %g != %g", extrudedsurface->scale_factor, scale_factor);
    scale_factor++;
    if (dwg_dynapi_entity_set_value (extrudedsurface, "EXTRUDEDSURFACE", "scale_factor", &scale_factor, 0)
        && scale_factor == extrudedsurface->scale_factor)
      pass ();
    else
      fail ("EXTRUDEDSURFACE.scale_factor [BD] set+1 %g != %g", extrudedsurface->scale_factor, scale_factor);
    extrudedsurface->scale_factor--;
  }
  {
    Dwg_3DSOLID_silhouette* silhouettes;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (extrudedsurface, "EXTRUDEDSURFACE", "num_silhouettes", &count, NULL)
        && dwg_dynapi_entity_value (extrudedsurface, "EXTRUDEDSURFACE", "silhouettes", &silhouettes, NULL)
        && silhouettes == extrudedsurface->silhouettes)
      pass ();
    else
      fail ("EXTRUDEDSURFACE.silhouettes [Dwg_3DSOLID_silhouette*] * %u num_silhouettes", count);
  }
  {
    BITCODE_BS sweep_alignment_flags;
    if (dwg_dynapi_entity_value (extrudedsurface, "EXTRUDEDSURFACE", "sweep_alignment_flags", &sweep_alignment_flags, NULL)
        && sweep_alignment_flags == extrudedsurface->sweep_alignment_flags)
      pass ();
    else
      fail ("EXTRUDEDSURFACE.sweep_alignment_flags [BS] %hu != %hu", extrudedsurface->sweep_alignment_flags, sweep_alignment_flags);
    sweep_alignment_flags++;
    if (dwg_dynapi_entity_set_value (extrudedsurface, "EXTRUDEDSURFACE", "sweep_alignment_flags", &sweep_alignment_flags, 0)
        && sweep_alignment_flags == extrudedsurface->sweep_alignment_flags)
      pass ();
    else
      fail ("EXTRUDEDSURFACE.sweep_alignment_flags [BS] set+1 %hu != %hu", extrudedsurface->sweep_alignment_flags, sweep_alignment_flags);
    extrudedsurface->sweep_alignment_flags--;
  }
  {
    BITCODE_H sweep_entity;
    if (dwg_dynapi_entity_value (extrudedsurface, "EXTRUDEDSURFACE", "sweep_entity", &sweep_entity, NULL)
        && !memcmp (&sweep_entity, &extrudedsurface->sweep_entity, sizeof (BITCODE_H)))
        pass ();
    else
        fail ("EXTRUDEDSURFACE.sweep_entity [H]");
  }
  {
    BITCODE_B sweep_entity_transform_computed;
    if (dwg_dynapi_entity_value (extrudedsurface, "EXTRUDEDSURFACE", "sweep_entity_transform_computed", &sweep_entity_transform_computed, NULL)
        && sweep_entity_transform_computed == extrudedsurface->sweep_entity_transform_computed)
      pass ();
    else
      fail ("EXTRUDEDSURFACE.sweep_entity_transform_computed [B] " FORMAT_B " != " FORMAT_B "", extrudedsurface->sweep_entity_transform_computed, sweep_entity_transform_computed);
    sweep_entity_transform_computed++;
    if (dwg_dynapi_entity_set_value (extrudedsurface, "EXTRUDEDSURFACE", "sweep_entity_transform_computed", &sweep_entity_transform_computed, 0)
        && sweep_entity_transform_computed == extrudedsurface->sweep_entity_transform_computed)
      pass ();
    else
      fail ("EXTRUDEDSURFACE.sweep_entity_transform_computed [B] set+1 " FORMAT_B " != " FORMAT_B "", extrudedsurface->sweep_entity_transform_computed, sweep_entity_transform_computed);
    extrudedsurface->sweep_entity_transform_computed--;
  }
  {
    BITCODE_BD* sweep_entity_transmatrix;
    if (dwg_dynapi_entity_value (extrudedsurface, "EXTRUDEDSURFACE", "sweep_entity_transmatrix", &sweep_entity_transmatrix, NULL)
        && !memcmp (&sweep_entity_transmatrix, &extrudedsurface->sweep_entity_transmatrix, sizeof (BITCODE_BD*)))
        pass ();
    else
        fail ("EXTRUDEDSURFACE.sweep_entity_transmatrix [BD*]");
  }
  {
    BITCODE_BD* sweep_transmatrix;
    if (dwg_dynapi_entity_value (extrudedsurface, "EXTRUDEDSURFACE", "sweep_transmatrix", &sweep_transmatrix, NULL)
        && !memcmp (&sweep_transmatrix, &extrudedsurface->sweep_transmatrix, sizeof (BITCODE_BD*)))
        pass ();
    else
        fail ("EXTRUDEDSURFACE.sweep_transmatrix [BD*]");
  }
  {
    BITCODE_3BD sweep_vector;
    if (dwg_dynapi_entity_value (extrudedsurface, "EXTRUDEDSURFACE", "sweep_vector", &sweep_vector, NULL)
        && !memcmp (&sweep_vector, &extrudedsurface->sweep_vector, sizeof (BITCODE_3BD)))
        pass ();
    else
        fail ("EXTRUDEDSURFACE.sweep_vector [3BD]");
  }
  {
    BITCODE_BD twist_angle;
    if (dwg_dynapi_entity_value (extrudedsurface, "EXTRUDEDSURFACE", "twist_angle", &twist_angle, NULL)
        && twist_angle == extrudedsurface->twist_angle)
      pass ();
    else
      fail ("EXTRUDEDSURFACE.twist_angle [BD] %g != %g", extrudedsurface->twist_angle, twist_angle);
    twist_angle++;
    if (dwg_dynapi_entity_set_value (extrudedsurface, "EXTRUDEDSURFACE", "twist_angle", &twist_angle, 0)
        && twist_angle == extrudedsurface->twist_angle)
      pass ();
    else
      fail ("EXTRUDEDSURFACE.twist_angle [BD] set+1 %g != %g", extrudedsurface->twist_angle, twist_angle);
    extrudedsurface->twist_angle--;
  }
  {
    BITCODE_BS u_isolines;
    if (dwg_dynapi_entity_value (extrudedsurface, "EXTRUDEDSURFACE", "u_isolines", &u_isolines, NULL)
        && u_isolines == extrudedsurface->u_isolines)
      pass ();
    else
      fail ("EXTRUDEDSURFACE.u_isolines [BS] %hu != %hu", extrudedsurface->u_isolines, u_isolines);
    u_isolines++;
    if (dwg_dynapi_entity_set_value (extrudedsurface, "EXTRUDEDSURFACE", "u_isolines", &u_isolines, 0)
        && u_isolines == extrudedsurface->u_isolines)
      pass ();
    else
      fail ("EXTRUDEDSURFACE.u_isolines [BS] set+1 %hu != %hu", extrudedsurface->u_isolines, u_isolines);
    extrudedsurface->u_isolines--;
  }
  {
    BITCODE_B unknown;
    if (dwg_dynapi_entity_value (extrudedsurface, "EXTRUDEDSURFACE", "unknown", &unknown, NULL)
        && unknown == extrudedsurface->unknown)
      pass ();
    else
      fail ("EXTRUDEDSURFACE.unknown [B] " FORMAT_B " != " FORMAT_B "", extrudedsurface->unknown, unknown);
    unknown++;
    if (dwg_dynapi_entity_set_value (extrudedsurface, "EXTRUDEDSURFACE", "unknown", &unknown, 0)
        && unknown == extrudedsurface->unknown)
      pass ();
    else
      fail ("EXTRUDEDSURFACE.unknown [B] set+1 " FORMAT_B " != " FORMAT_B "", extrudedsurface->unknown, unknown);
    extrudedsurface->unknown--;
  }
  {
    BITCODE_BS v_isolines;
    if (dwg_dynapi_entity_value (extrudedsurface, "EXTRUDEDSURFACE", "v_isolines", &v_isolines, NULL)
        && v_isolines == extrudedsurface->v_isolines)
      pass ();
    else
      fail ("EXTRUDEDSURFACE.v_isolines [BS] %hu != %hu", extrudedsurface->v_isolines, v_isolines);
    v_isolines++;
    if (dwg_dynapi_entity_set_value (extrudedsurface, "EXTRUDEDSURFACE", "v_isolines", &v_isolines, 0)
        && v_isolines == extrudedsurface->v_isolines)
      pass ();
    else
      fail ("EXTRUDEDSURFACE.v_isolines [BS] set+1 %hu != %hu", extrudedsurface->v_isolines, v_isolines);
    extrudedsurface->v_isolines--;
  }
  {
    BITCODE_BS version;
    if (dwg_dynapi_entity_value (extrudedsurface, "EXTRUDEDSURFACE", "version", &version, NULL)
        && version == extrudedsurface->version)
      pass ();
    else
      fail ("EXTRUDEDSURFACE.version [BS] %hu != %hu", extrudedsurface->version, version);
    version++;
    if (dwg_dynapi_entity_set_value (extrudedsurface, "EXTRUDEDSURFACE", "version", &version, 0)
        && version == extrudedsurface->version)
      pass ();
    else
      fail ("EXTRUDEDSURFACE.version [BS] set+1 %hu != %hu", extrudedsurface->version, version);
    extrudedsurface->version--;
  }
  {
    BITCODE_B wireframe_data_present;
    if (dwg_dynapi_entity_value (extrudedsurface, "EXTRUDEDSURFACE", "wireframe_data_present", &wireframe_data_present, NULL)
        && wireframe_data_present == extrudedsurface->wireframe_data_present)
      pass ();
    else
      fail ("EXTRUDEDSURFACE.wireframe_data_present [B] " FORMAT_B " != " FORMAT_B "", extrudedsurface->wireframe_data_present, wireframe_data_present);
    wireframe_data_present++;
    if (dwg_dynapi_entity_set_value (extrudedsurface, "EXTRUDEDSURFACE", "wireframe_data_present", &wireframe_data_present, 0)
        && wireframe_data_present == extrudedsurface->wireframe_data_present)
      pass ();
    else
      fail ("EXTRUDEDSURFACE.wireframe_data_present [B] set+1 " FORMAT_B " != " FORMAT_B "", extrudedsurface->wireframe_data_present, wireframe_data_present);
    extrudedsurface->wireframe_data_present--;
  }
  {
    Dwg_3DSOLID_wire* wires;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (extrudedsurface, "EXTRUDEDSURFACE", "num_wires", &count, NULL)
        && dwg_dynapi_entity_value (extrudedsurface, "EXTRUDEDSURFACE", "wires", &wires, NULL)
        && wires == extrudedsurface->wires)
      pass ();
    else
      fail ("EXTRUDEDSURFACE.wires [Dwg_3DSOLID_wire*] * %u num_wires", count);
  }
  if (failed && (is_class_unstable ("EXTRUDEDSURFACE") || is_class_debugging ("EXTRUDEDSURFACE")))
    {
      ok ("%s failed %d tests (TODO unstable)", "EXTRUDEDSURFACE", failed);
      failed = 0;
    }
  return failed;
}
static int test_FLIPPARAMETERENTITY (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_FLIPPARAMETERENTITY *restrict flipparameterentity = obj->tio.entity->tio.FLIPPARAMETERENTITY;
  failed = 0;
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value (flipparameterentity, "FLIPPARAMETERENTITY", "parent", &parent, NULL)
        && !memcmp (&parent, &flipparameterentity->parent, sizeof (struct _dwg_object_entity*)))
        pass ();
    else
        fail ("FLIPPARAMETERENTITY.parent [struct _dwg_object_entity*]");
  }
  if (failed && (is_class_unstable ("FLIPPARAMETERENTITY") || is_class_debugging ("FLIPPARAMETERENTITY")))
    {
      ok ("%s failed %d tests (TODO unstable)", "FLIPPARAMETERENTITY", failed);
      failed = 0;
    }
  return failed;
}
static int test_GEOPOSITIONMARKER (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_GEOPOSITIONMARKER *restrict geopositionmarker = obj->tio.entity->tio.GEOPOSITIONMARKER;
  failed = 0;
  {
    BITCODE_BS class_version;
    if (dwg_dynapi_entity_value (geopositionmarker, "GEOPOSITIONMARKER", "class_version", &class_version, NULL)
        && class_version == geopositionmarker->class_version)
      pass ();
    else
      fail ("GEOPOSITIONMARKER.class_version [BS] %hu != %hu", geopositionmarker->class_version, class_version);
    class_version++;
    if (dwg_dynapi_entity_set_value (geopositionmarker, "GEOPOSITIONMARKER", "class_version", &class_version, 0)
        && class_version == geopositionmarker->class_version)
      pass ();
    else
      fail ("GEOPOSITIONMARKER.class_version [BS] set+1 %hu != %hu", geopositionmarker->class_version, class_version);
    geopositionmarker->class_version--;
  }
  {
    BITCODE_B enable_frame_text;
    if (dwg_dynapi_entity_value (geopositionmarker, "GEOPOSITIONMARKER", "enable_frame_text", &enable_frame_text, NULL)
        && enable_frame_text == geopositionmarker->enable_frame_text)
      pass ();
    else
      fail ("GEOPOSITIONMARKER.enable_frame_text [B] " FORMAT_B " != " FORMAT_B "", geopositionmarker->enable_frame_text, enable_frame_text);
    enable_frame_text++;
    if (dwg_dynapi_entity_set_value (geopositionmarker, "GEOPOSITIONMARKER", "enable_frame_text", &enable_frame_text, 0)
        && enable_frame_text == geopositionmarker->enable_frame_text)
      pass ();
    else
      fail ("GEOPOSITIONMARKER.enable_frame_text [B] set+1 " FORMAT_B " != " FORMAT_B "", geopositionmarker->enable_frame_text, enable_frame_text);
    geopositionmarker->enable_frame_text--;
  }
  {
    BITCODE_BD landing_gap;
    if (dwg_dynapi_entity_value (geopositionmarker, "GEOPOSITIONMARKER", "landing_gap", &landing_gap, NULL)
        && landing_gap == geopositionmarker->landing_gap)
      pass ();
    else
      fail ("GEOPOSITIONMARKER.landing_gap [BD] %g != %g", geopositionmarker->landing_gap, landing_gap);
    landing_gap++;
    if (dwg_dynapi_entity_set_value (geopositionmarker, "GEOPOSITIONMARKER", "landing_gap", &landing_gap, 0)
        && landing_gap == geopositionmarker->landing_gap)
      pass ();
    else
      fail ("GEOPOSITIONMARKER.landing_gap [BD] set+1 %g != %g", geopositionmarker->landing_gap, landing_gap);
    geopositionmarker->landing_gap--;
  }
  {
    struct _dwg_object* mtext;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (geopositionmarker, "GEOPOSITIONMARKER", "num_mtext", &count, NULL)
        && dwg_dynapi_entity_value (geopositionmarker, "GEOPOSITIONMARKER", "mtext", &mtext, NULL)
        && mtext == geopositionmarker->mtext)
      pass ();
    else
      fail ("GEOPOSITIONMARKER.mtext [struct _dwg_object*] * %u num_mtext", count);
  }
  {
    BITCODE_B mtext_visible;
    if (dwg_dynapi_entity_value (geopositionmarker, "GEOPOSITIONMARKER", "mtext_visible", &mtext_visible, NULL)
        && mtext_visible == geopositionmarker->mtext_visible)
      pass ();
    else
      fail ("GEOPOSITIONMARKER.mtext_visible [B] " FORMAT_B " != " FORMAT_B "", geopositionmarker->mtext_visible, mtext_visible);
    mtext_visible++;
    if (dwg_dynapi_entity_set_value (geopositionmarker, "GEOPOSITIONMARKER", "mtext_visible", &mtext_visible, 0)
        && mtext_visible == geopositionmarker->mtext_visible)
      pass ();
    else
      fail ("GEOPOSITIONMARKER.mtext_visible [B] set+1 " FORMAT_B " != " FORMAT_B "", geopositionmarker->mtext_visible, mtext_visible);
    geopositionmarker->mtext_visible--;
  }
  {
    BITCODE_T notes;
    if (dwg_dynapi_entity_value (geopositionmarker, "GEOPOSITIONMARKER", "notes", &notes, NULL)
        && notes
           ? strEQ ((char *)notes, (char *)geopositionmarker->notes)
           : !geopositionmarker->notes)
      pass ();
    else
      fail ("GEOPOSITIONMARKER.notes [T] '%s' <> '%s'", notes, geopositionmarker->notes);
  }
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value (geopositionmarker, "GEOPOSITIONMARKER", "parent", &parent, NULL)
        && !memcmp (&parent, &geopositionmarker->parent, sizeof (struct _dwg_object_entity*)))
        pass ();
    else
        fail ("GEOPOSITIONMARKER.parent [struct _dwg_object_entity*]");
  }
  {
    BITCODE_3BD position;
    if (dwg_dynapi_entity_value (geopositionmarker, "GEOPOSITIONMARKER", "position", &position, NULL)
        && !memcmp (&position, &geopositionmarker->position, sizeof (BITCODE_3BD)))
        pass ();
    else
        fail ("GEOPOSITIONMARKER.position [3BD]");
  }
  {
    BITCODE_BD radius;
    if (dwg_dynapi_entity_value (geopositionmarker, "GEOPOSITIONMARKER", "radius", &radius, NULL)
        && radius == geopositionmarker->radius)
      pass ();
    else
      fail ("GEOPOSITIONMARKER.radius [BD] %g != %g", geopositionmarker->radius, radius);
    radius++;
    if (dwg_dynapi_entity_set_value (geopositionmarker, "GEOPOSITIONMARKER", "radius", &radius, 0)
        && radius == geopositionmarker->radius)
      pass ();
    else
      fail ("GEOPOSITIONMARKER.radius [BD] set+1 %g != %g", geopositionmarker->radius, radius);
    geopositionmarker->radius--;
  }
  {
    BITCODE_RC text_alignment;
    if (dwg_dynapi_entity_value (geopositionmarker, "GEOPOSITIONMARKER", "text_alignment", &text_alignment, NULL)
        && text_alignment == geopositionmarker->text_alignment)
      pass ();
    else
      fail ("GEOPOSITIONMARKER.text_alignment [RC] %u != %u", geopositionmarker->text_alignment, text_alignment);
    text_alignment++;
    if (dwg_dynapi_entity_set_value (geopositionmarker, "GEOPOSITIONMARKER", "text_alignment", &text_alignment, 0)
        && text_alignment == geopositionmarker->text_alignment)
      pass ();
    else
      fail ("GEOPOSITIONMARKER.text_alignment [RC] set+1 %u != %u", geopositionmarker->text_alignment, text_alignment);
    geopositionmarker->text_alignment--;
  }
  if (failed && (is_class_unstable ("GEOPOSITIONMARKER") || is_class_debugging ("GEOPOSITIONMARKER")))
    {
      ok ("%s failed %d tests (TODO unstable)", "GEOPOSITIONMARKER", failed);
      failed = 0;
    }
  return failed;
}
static int test_HATCH (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_HATCH *restrict hatch = obj->tio.entity->tio.HATCH;
  failed = 0;
  {
    BITCODE_BD angle;
    if (dwg_dynapi_entity_value (hatch, "HATCH", "angle", &angle, NULL)
        && angle == hatch->angle)
      pass ();
    else
      fail ("HATCH.angle [BD] %g != %g", hatch->angle, angle);
    angle++;
    if (dwg_dynapi_entity_set_value (hatch, "HATCH", "angle", &angle, 0)
        && angle == hatch->angle)
      pass ();
    else
      fail ("HATCH.angle [BD] set+1 %g != %g", hatch->angle, angle);
    hatch->angle--;
  }
  {
    BITCODE_H* boundary_handles;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (hatch, "HATCH", "num_boundary_handles", &count, NULL)
        && dwg_dynapi_entity_value (hatch, "HATCH", "boundary_handles", &boundary_handles, NULL)
        && boundary_handles == hatch->boundary_handles)
      pass ();
    else
      fail ("HATCH.boundary_handles [H*] * %u num_boundary_handles", count);
  }
  {
    Dwg_HATCH_Color* colors;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (hatch, "HATCH", "num_colors", &count, NULL)
        && dwg_dynapi_entity_value (hatch, "HATCH", "colors", &colors, NULL)
        && colors == hatch->colors)
      pass ();
    else
      fail ("HATCH.colors [Dwg_HATCH_Color*] * %u num_colors", count);
  }
  {
    Dwg_HATCH_DefLine* deflines;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (hatch, "HATCH", "num_deflines", &count, NULL)
        && dwg_dynapi_entity_value (hatch, "HATCH", "deflines", &deflines, NULL)
        && deflines == hatch->deflines)
      pass ();
    else
      fail ("HATCH.deflines [Dwg_HATCH_DefLine*] * %u num_deflines", count);
  }
  {
    BITCODE_B double_flag;
    if (dwg_dynapi_entity_value (hatch, "HATCH", "double_flag", &double_flag, NULL)
        && double_flag == hatch->double_flag)
      pass ();
    else
      fail ("HATCH.double_flag [B] " FORMAT_B " != " FORMAT_B "", hatch->double_flag, double_flag);
    double_flag++;
    if (dwg_dynapi_entity_set_value (hatch, "HATCH", "double_flag", &double_flag, 0)
        && double_flag == hatch->double_flag)
      pass ();
    else
      fail ("HATCH.double_flag [B] set+1 " FORMAT_B " != " FORMAT_B "", hatch->double_flag, double_flag);
    hatch->double_flag--;
  }
  {
    BITCODE_BD elevation;
    if (dwg_dynapi_entity_value (hatch, "HATCH", "elevation", &elevation, NULL)
        && elevation == hatch->elevation)
      pass ();
    else
      fail ("HATCH.elevation [BD] %g != %g", hatch->elevation, elevation);
    elevation++;
    if (dwg_dynapi_entity_set_value (hatch, "HATCH", "elevation", &elevation, 0)
        && elevation == hatch->elevation)
      pass ();
    else
      fail ("HATCH.elevation [BD] set+1 %g != %g", hatch->elevation, elevation);
    hatch->elevation--;
  }
  {
    BITCODE_BE extrusion;
    if (dwg_dynapi_entity_value (hatch, "HATCH", "extrusion", &extrusion, NULL)
        && !memcmp (&extrusion, &hatch->extrusion, sizeof (BITCODE_BE)))
        pass ();
    else
        fail ("HATCH.extrusion [BE]");
  }
  {
    BITCODE_BD gradient_angle;
    if (dwg_dynapi_entity_value (hatch, "HATCH", "gradient_angle", &gradient_angle, NULL)
        && gradient_angle == hatch->gradient_angle)
      pass ();
    else
      fail ("HATCH.gradient_angle [BD] %g != %g", hatch->gradient_angle, gradient_angle);
    gradient_angle++;
    if (dwg_dynapi_entity_set_value (hatch, "HATCH", "gradient_angle", &gradient_angle, 0)
        && gradient_angle == hatch->gradient_angle)
      pass ();
    else
      fail ("HATCH.gradient_angle [BD] set+1 %g != %g", hatch->gradient_angle, gradient_angle);
    hatch->gradient_angle--;
  }
  {
    BITCODE_T gradient_name;
    if (dwg_dynapi_entity_value (hatch, "HATCH", "gradient_name", &gradient_name, NULL)
        && gradient_name
           ? strEQ ((char *)gradient_name, (char *)hatch->gradient_name)
           : !hatch->gradient_name)
      pass ();
    else
      fail ("HATCH.gradient_name [T] '%s' <> '%s'", gradient_name, hatch->gradient_name);
  }
  {
    BITCODE_BD gradient_shift;
    if (dwg_dynapi_entity_value (hatch, "HATCH", "gradient_shift", &gradient_shift, NULL)
        && gradient_shift == hatch->gradient_shift)
      pass ();
    else
      fail ("HATCH.gradient_shift [BD] %g != %g", hatch->gradient_shift, gradient_shift);
    gradient_shift++;
    if (dwg_dynapi_entity_set_value (hatch, "HATCH", "gradient_shift", &gradient_shift, 0)
        && gradient_shift == hatch->gradient_shift)
      pass ();
    else
      fail ("HATCH.gradient_shift [BD] set+1 %g != %g", hatch->gradient_shift, gradient_shift);
    hatch->gradient_shift--;
  }
  {
    BITCODE_BD gradient_tint;
    if (dwg_dynapi_entity_value (hatch, "HATCH", "gradient_tint", &gradient_tint, NULL)
        && gradient_tint == hatch->gradient_tint)
      pass ();
    else
      fail ("HATCH.gradient_tint [BD] %g != %g", hatch->gradient_tint, gradient_tint);
    gradient_tint++;
    if (dwg_dynapi_entity_set_value (hatch, "HATCH", "gradient_tint", &gradient_tint, 0)
        && gradient_tint == hatch->gradient_tint)
      pass ();
    else
      fail ("HATCH.gradient_tint [BD] set+1 %g != %g", hatch->gradient_tint, gradient_tint);
    hatch->gradient_tint--;
  }
  {
    BITCODE_B has_derived;
    if (dwg_dynapi_entity_value (hatch, "HATCH", "has_derived", &has_derived, NULL)
        && has_derived == hatch->has_derived)
      pass ();
    else
      fail ("HATCH.has_derived [B] " FORMAT_B " != " FORMAT_B "", hatch->has_derived, has_derived);
    has_derived++;
    if (dwg_dynapi_entity_set_value (hatch, "HATCH", "has_derived", &has_derived, 0)
        && has_derived == hatch->has_derived)
      pass ();
    else
      fail ("HATCH.has_derived [B] set+1 " FORMAT_B " != " FORMAT_B "", hatch->has_derived, has_derived);
    hatch->has_derived--;
  }
  {
    BITCODE_B is_associative;
    if (dwg_dynapi_entity_value (hatch, "HATCH", "is_associative", &is_associative, NULL)
        && is_associative == hatch->is_associative)
      pass ();
    else
      fail ("HATCH.is_associative [B] " FORMAT_B " != " FORMAT_B "", hatch->is_associative, is_associative);
    is_associative++;
    if (dwg_dynapi_entity_set_value (hatch, "HATCH", "is_associative", &is_associative, 0)
        && is_associative == hatch->is_associative)
      pass ();
    else
      fail ("HATCH.is_associative [B] set+1 " FORMAT_B " != " FORMAT_B "", hatch->is_associative, is_associative);
    hatch->is_associative--;
  }
  {
    BITCODE_BL is_gradient_fill;
    if (dwg_dynapi_entity_value (hatch, "HATCH", "is_gradient_fill", &is_gradient_fill, NULL)
        && is_gradient_fill == hatch->is_gradient_fill)
      pass ();
    else
      fail ("HATCH.is_gradient_fill [BL] %u != %u", hatch->is_gradient_fill, is_gradient_fill);
    is_gradient_fill++;
    if (dwg_dynapi_entity_set_value (hatch, "HATCH", "is_gradient_fill", &is_gradient_fill, 0)
        && is_gradient_fill == hatch->is_gradient_fill)
      pass ();
    else
      fail ("HATCH.is_gradient_fill [BL] set+1 %u != %u", hatch->is_gradient_fill, is_gradient_fill);
    hatch->is_gradient_fill--;
  }
  {
    BITCODE_B is_solid_fill;
    if (dwg_dynapi_entity_value (hatch, "HATCH", "is_solid_fill", &is_solid_fill, NULL)
        && is_solid_fill == hatch->is_solid_fill)
      pass ();
    else
      fail ("HATCH.is_solid_fill [B] " FORMAT_B " != " FORMAT_B "", hatch->is_solid_fill, is_solid_fill);
    is_solid_fill++;
    if (dwg_dynapi_entity_set_value (hatch, "HATCH", "is_solid_fill", &is_solid_fill, 0)
        && is_solid_fill == hatch->is_solid_fill)
      pass ();
    else
      fail ("HATCH.is_solid_fill [B] set+1 " FORMAT_B " != " FORMAT_B "", hatch->is_solid_fill, is_solid_fill);
    hatch->is_solid_fill--;
  }
  {
    BITCODE_T name;
    if (dwg_dynapi_entity_value (hatch, "HATCH", "name", &name, NULL)
        && name
           ? strEQ ((char *)name, (char *)hatch->name)
           : !hatch->name)
      pass ();
    else
      fail ("HATCH.name [T] '%s' <> '%s'", name, hatch->name);
  }
  {
    BITCODE_BL num_boundary_handles;
    if (dwg_dynapi_entity_value (hatch, "HATCH", "num_boundary_handles", &num_boundary_handles, NULL)
        && num_boundary_handles == hatch->num_boundary_handles)
      pass ();
    else
      fail ("HATCH.num_boundary_handles [BL] %u != %u", hatch->num_boundary_handles, num_boundary_handles);
    num_boundary_handles++;
    if (dwg_dynapi_entity_set_value (hatch, "HATCH", "num_boundary_handles", &num_boundary_handles, 0)
        && num_boundary_handles == hatch->num_boundary_handles)
      pass ();
    else
      fail ("HATCH.num_boundary_handles [BL] set+1 %u != %u", hatch->num_boundary_handles, num_boundary_handles);
    hatch->num_boundary_handles--;
  }
  {
    BITCODE_BL num_colors;
    if (dwg_dynapi_entity_value (hatch, "HATCH", "num_colors", &num_colors, NULL)
        && num_colors == hatch->num_colors)
      pass ();
    else
      fail ("HATCH.num_colors [BL] %u != %u", hatch->num_colors, num_colors);
    num_colors++;
    if (dwg_dynapi_entity_set_value (hatch, "HATCH", "num_colors", &num_colors, 0)
        && num_colors == hatch->num_colors)
      pass ();
    else
      fail ("HATCH.num_colors [BL] set+1 %u != %u", hatch->num_colors, num_colors);
    hatch->num_colors--;
  }
  {
    BITCODE_BS num_deflines;
    if (dwg_dynapi_entity_value (hatch, "HATCH", "num_deflines", &num_deflines, NULL)
        && num_deflines == hatch->num_deflines)
      pass ();
    else
      fail ("HATCH.num_deflines [BS] %hu != %hu", hatch->num_deflines, num_deflines);
    num_deflines++;
    if (dwg_dynapi_entity_set_value (hatch, "HATCH", "num_deflines", &num_deflines, 0)
        && num_deflines == hatch->num_deflines)
      pass ();
    else
      fail ("HATCH.num_deflines [BS] set+1 %hu != %hu", hatch->num_deflines, num_deflines);
    hatch->num_deflines--;
  }
  {
    BITCODE_BL num_paths;
    if (dwg_dynapi_entity_value (hatch, "HATCH", "num_paths", &num_paths, NULL)
        && num_paths == hatch->num_paths)
      pass ();
    else
      fail ("HATCH.num_paths [BL] %u != %u", hatch->num_paths, num_paths);
    num_paths++;
    if (dwg_dynapi_entity_set_value (hatch, "HATCH", "num_paths", &num_paths, 0)
        && num_paths == hatch->num_paths)
      pass ();
    else
      fail ("HATCH.num_paths [BL] set+1 %u != %u", hatch->num_paths, num_paths);
    hatch->num_paths--;
  }
  {
    BITCODE_BL num_seeds;
    if (dwg_dynapi_entity_value (hatch, "HATCH", "num_seeds", &num_seeds, NULL)
        && num_seeds == hatch->num_seeds)
      pass ();
    else
      fail ("HATCH.num_seeds [BL] %u != %u", hatch->num_seeds, num_seeds);
    num_seeds++;
    if (dwg_dynapi_entity_set_value (hatch, "HATCH", "num_seeds", &num_seeds, 0)
        && num_seeds == hatch->num_seeds)
      pass ();
    else
      fail ("HATCH.num_seeds [BL] set+1 %u != %u", hatch->num_seeds, num_seeds);
    hatch->num_seeds--;
  }
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value (hatch, "HATCH", "parent", &parent, NULL)
        && !memcmp (&parent, &hatch->parent, sizeof (struct _dwg_object_entity*)))
        pass ();
    else
        fail ("HATCH.parent [struct _dwg_object_entity*]");
  }
  {
    Dwg_HATCH_Path* paths;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (hatch, "HATCH", "num_paths", &count, NULL)
        && dwg_dynapi_entity_value (hatch, "HATCH", "paths", &paths, NULL)
        && paths == hatch->paths)
      pass ();
    else
      fail ("HATCH.paths [Dwg_HATCH_Path*] * %u num_paths", count);
  }
  {
    BITCODE_BS pattern_type;
    if (dwg_dynapi_entity_value (hatch, "HATCH", "pattern_type", &pattern_type, NULL)
        && pattern_type == hatch->pattern_type)
      pass ();
    else
      fail ("HATCH.pattern_type [BS] %hu != %hu", hatch->pattern_type, pattern_type);
    pattern_type++;
    if (dwg_dynapi_entity_set_value (hatch, "HATCH", "pattern_type", &pattern_type, 0)
        && pattern_type == hatch->pattern_type)
      pass ();
    else
      fail ("HATCH.pattern_type [BS] set+1 %hu != %hu", hatch->pattern_type, pattern_type);
    hatch->pattern_type--;
  }
  {
    BITCODE_BD pixel_size;
    if (dwg_dynapi_entity_value (hatch, "HATCH", "pixel_size", &pixel_size, NULL)
        && pixel_size == hatch->pixel_size)
      pass ();
    else
      fail ("HATCH.pixel_size [BD] %g != %g", hatch->pixel_size, pixel_size);
    pixel_size++;
    if (dwg_dynapi_entity_set_value (hatch, "HATCH", "pixel_size", &pixel_size, 0)
        && pixel_size == hatch->pixel_size)
      pass ();
    else
      fail ("HATCH.pixel_size [BD] set+1 %g != %g", hatch->pixel_size, pixel_size);
    hatch->pixel_size--;
  }
  {
    BITCODE_BL reserved;
    if (dwg_dynapi_entity_value (hatch, "HATCH", "reserved", &reserved, NULL)
        && reserved == hatch->reserved)
      pass ();
    else
      fail ("HATCH.reserved [BL] %u != %u", hatch->reserved, reserved);
    reserved++;
    if (dwg_dynapi_entity_set_value (hatch, "HATCH", "reserved", &reserved, 0)
        && reserved == hatch->reserved)
      pass ();
    else
      fail ("HATCH.reserved [BL] set+1 %u != %u", hatch->reserved, reserved);
    hatch->reserved--;
  }
  {
    BITCODE_BD scale_spacing;
    if (dwg_dynapi_entity_value (hatch, "HATCH", "scale_spacing", &scale_spacing, NULL)
        && scale_spacing == hatch->scale_spacing)
      pass ();
    else
      fail ("HATCH.scale_spacing [BD] %g != %g", hatch->scale_spacing, scale_spacing);
    scale_spacing++;
    if (dwg_dynapi_entity_set_value (hatch, "HATCH", "scale_spacing", &scale_spacing, 0)
        && scale_spacing == hatch->scale_spacing)
      pass ();
    else
      fail ("HATCH.scale_spacing [BD] set+1 %g != %g", hatch->scale_spacing, scale_spacing);
    hatch->scale_spacing--;
  }
  {
    BITCODE_2RD* seeds;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (hatch, "HATCH", "num_seeds", &count, NULL)
        && dwg_dynapi_entity_value (hatch, "HATCH", "seeds", &seeds, NULL)
        && seeds == hatch->seeds)
      pass ();
    else
      fail ("HATCH.seeds [2RD*] * %u num_seeds", count);
  }
  {
    BITCODE_BL single_color_gradient;
    if (dwg_dynapi_entity_value (hatch, "HATCH", "single_color_gradient", &single_color_gradient, NULL)
        && single_color_gradient == hatch->single_color_gradient)
      pass ();
    else
      fail ("HATCH.single_color_gradient [BL] %u != %u", hatch->single_color_gradient, single_color_gradient);
    single_color_gradient++;
    if (dwg_dynapi_entity_set_value (hatch, "HATCH", "single_color_gradient", &single_color_gradient, 0)
        && single_color_gradient == hatch->single_color_gradient)
      pass ();
    else
      fail ("HATCH.single_color_gradient [BL] set+1 %u != %u", hatch->single_color_gradient, single_color_gradient);
    hatch->single_color_gradient--;
  }
  {
    BITCODE_BS style;
    if (dwg_dynapi_entity_value (hatch, "HATCH", "style", &style, NULL)
        && style == hatch->style)
      pass ();
    else
      fail ("HATCH.style [BS] %hu != %hu", hatch->style, style);
    style++;
    if (dwg_dynapi_entity_set_value (hatch, "HATCH", "style", &style, 0)
        && style == hatch->style)
      pass ();
    else
      fail ("HATCH.style [BS] set+1 %hu != %hu", hatch->style, style);
    hatch->style--;
  }
  if (failed && (is_class_unstable ("HATCH") || is_class_debugging ("HATCH")))
    {
      ok ("%s failed %d tests (TODO unstable)", "HATCH", failed);
      failed = 0;
    }
  return failed;
}
static int test_HELIX (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_HELIX *restrict helix = obj->tio.entity->tio.HELIX;
  failed = 0;
  {
    BITCODE_3BD axis_base_pt;
    if (dwg_dynapi_entity_value (helix, "HELIX", "axis_base_pt", &axis_base_pt, NULL)
        && !memcmp (&axis_base_pt, &helix->axis_base_pt, sizeof (BITCODE_3BD)))
        pass ();
    else
        fail ("HELIX.axis_base_pt [3BD]");
  }
  {
    BITCODE_3BD axis_vector;
    if (dwg_dynapi_entity_value (helix, "HELIX", "axis_vector", &axis_vector, NULL)
        && !memcmp (&axis_vector, &helix->axis_vector, sizeof (BITCODE_3BD)))
        pass ();
    else
        fail ("HELIX.axis_vector [3BD]");
  }
  {
    BITCODE_3BD beg_tan_vec;
    if (dwg_dynapi_entity_value (helix, "HELIX", "beg_tan_vec", &beg_tan_vec, NULL)
        && !memcmp (&beg_tan_vec, &helix->beg_tan_vec, sizeof (BITCODE_3BD)))
        pass ();
    else
        fail ("HELIX.beg_tan_vec [3BD]");
  }
  {
    BITCODE_B closed_b;
    if (dwg_dynapi_entity_value (helix, "HELIX", "closed_b", &closed_b, NULL)
        && closed_b == helix->closed_b)
      pass ();
    else
      fail ("HELIX.closed_b [B] " FORMAT_B " != " FORMAT_B "", helix->closed_b, closed_b);
    closed_b++;
    if (dwg_dynapi_entity_set_value (helix, "HELIX", "closed_b", &closed_b, 0)
        && closed_b == helix->closed_b)
      pass ();
    else
      fail ("HELIX.closed_b [B] set+1 " FORMAT_B " != " FORMAT_B "", helix->closed_b, closed_b);
    helix->closed_b--;
  }
  {
    BITCODE_RC constraint_type;
    if (dwg_dynapi_entity_value (helix, "HELIX", "constraint_type", &constraint_type, NULL)
        && constraint_type == helix->constraint_type)
      pass ();
    else
      fail ("HELIX.constraint_type [RC] %u != %u", helix->constraint_type, constraint_type);
    constraint_type++;
    if (dwg_dynapi_entity_set_value (helix, "HELIX", "constraint_type", &constraint_type, 0)
        && constraint_type == helix->constraint_type)
      pass ();
    else
      fail ("HELIX.constraint_type [RC] set+1 %u != %u", helix->constraint_type, constraint_type);
    helix->constraint_type--;
  }
  {
    Dwg_SPLINE_control_point* ctrl_pts;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (helix, "HELIX", "num_ctrl_pts", &count, NULL)
        && dwg_dynapi_entity_value (helix, "HELIX", "ctrl_pts", &ctrl_pts, NULL)
        && ctrl_pts == helix->ctrl_pts)
      pass ();
    else
      fail ("HELIX.ctrl_pts [Dwg_SPLINE_control_point*] * %u num_ctrl_pts", count);
  }
  {
    BITCODE_BD ctrl_tol;
    if (dwg_dynapi_entity_value (helix, "HELIX", "ctrl_tol", &ctrl_tol, NULL)
        && ctrl_tol == helix->ctrl_tol)
      pass ();
    else
      fail ("HELIX.ctrl_tol [BD] %g != %g", helix->ctrl_tol, ctrl_tol);
    ctrl_tol++;
    if (dwg_dynapi_entity_set_value (helix, "HELIX", "ctrl_tol", &ctrl_tol, 0)
        && ctrl_tol == helix->ctrl_tol)
      pass ();
    else
      fail ("HELIX.ctrl_tol [BD] set+1 %g != %g", helix->ctrl_tol, ctrl_tol);
    helix->ctrl_tol--;
  }
  {
    BITCODE_BS degree;
    if (dwg_dynapi_entity_value (helix, "HELIX", "degree", &degree, NULL)
        && degree == helix->degree)
      pass ();
    else
      fail ("HELIX.degree [BS] %hu != %hu", helix->degree, degree);
    degree++;
    if (dwg_dynapi_entity_set_value (helix, "HELIX", "degree", &degree, 0)
        && degree == helix->degree)
      pass ();
    else
      fail ("HELIX.degree [BS] set+1 %hu != %hu", helix->degree, degree);
    helix->degree--;
  }
  {
    BITCODE_3BD end_tan_vec;
    if (dwg_dynapi_entity_value (helix, "HELIX", "end_tan_vec", &end_tan_vec, NULL)
        && !memcmp (&end_tan_vec, &helix->end_tan_vec, sizeof (BITCODE_3BD)))
        pass ();
    else
        fail ("HELIX.end_tan_vec [3BD]");
  }
  {
    BITCODE_3DPOINT* fit_pts;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (helix, "HELIX", "num_fit_pts", &count, NULL)
        && dwg_dynapi_entity_value (helix, "HELIX", "fit_pts", &fit_pts, NULL)
        && fit_pts == helix->fit_pts)
      pass ();
    else
      fail ("HELIX.fit_pts [3DPOINT*] * %u num_fit_pts", count);
  }
  {
    BITCODE_BD fit_tol;
    if (dwg_dynapi_entity_value (helix, "HELIX", "fit_tol", &fit_tol, NULL)
        && fit_tol == helix->fit_tol)
      pass ();
    else
      fail ("HELIX.fit_tol [BD] %g != %g", helix->fit_tol, fit_tol);
    fit_tol++;
    if (dwg_dynapi_entity_set_value (helix, "HELIX", "fit_tol", &fit_tol, 0)
        && fit_tol == helix->fit_tol)
      pass ();
    else
      fail ("HELIX.fit_tol [BD] set+1 %g != %g", helix->fit_tol, fit_tol);
    helix->fit_tol--;
  }
  {
    BITCODE_BS flag;
    if (dwg_dynapi_entity_value (helix, "HELIX", "flag", &flag, NULL)
        && flag == helix->flag)
      pass ();
    else
      fail ("HELIX.flag [BS] %hu != %hu", helix->flag, flag);
    flag++;
    if (dwg_dynapi_entity_set_value (helix, "HELIX", "flag", &flag, 0)
        && flag == helix->flag)
      pass ();
    else
      fail ("HELIX.flag [BS] set+1 %hu != %hu", helix->flag, flag);
    helix->flag--;
  }
  {
    BITCODE_B handedness;
    if (dwg_dynapi_entity_value (helix, "HELIX", "handedness", &handedness, NULL)
        && handedness == helix->handedness)
      pass ();
    else
      fail ("HELIX.handedness [B] " FORMAT_B " != " FORMAT_B "", helix->handedness, handedness);
    handedness++;
    if (dwg_dynapi_entity_set_value (helix, "HELIX", "handedness", &handedness, 0)
        && handedness == helix->handedness)
      pass ();
    else
      fail ("HELIX.handedness [B] set+1 " FORMAT_B " != " FORMAT_B "", helix->handedness, handedness);
    helix->handedness--;
  }
  {
    BITCODE_BD knot_tol;
    if (dwg_dynapi_entity_value (helix, "HELIX", "knot_tol", &knot_tol, NULL)
        && knot_tol == helix->knot_tol)
      pass ();
    else
      fail ("HELIX.knot_tol [BD] %g != %g", helix->knot_tol, knot_tol);
    knot_tol++;
    if (dwg_dynapi_entity_set_value (helix, "HELIX", "knot_tol", &knot_tol, 0)
        && knot_tol == helix->knot_tol)
      pass ();
    else
      fail ("HELIX.knot_tol [BD] set+1 %g != %g", helix->knot_tol, knot_tol);
    helix->knot_tol--;
  }
  {
    BITCODE_BL knotparam;
    if (dwg_dynapi_entity_value (helix, "HELIX", "knotparam", &knotparam, NULL)
        && knotparam == helix->knotparam)
      pass ();
    else
      fail ("HELIX.knotparam [BL] %u != %u", helix->knotparam, knotparam);
    knotparam++;
    if (dwg_dynapi_entity_set_value (helix, "HELIX", "knotparam", &knotparam, 0)
        && knotparam == helix->knotparam)
      pass ();
    else
      fail ("HELIX.knotparam [BL] set+1 %u != %u", helix->knotparam, knotparam);
    helix->knotparam--;
  }
  {
    BITCODE_BD* knots;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (helix, "HELIX", "num_knots", &count, NULL)
        && dwg_dynapi_entity_value (helix, "HELIX", "knots", &knots, NULL)
        && knots == helix->knots)
      pass ();
    else
      fail ("HELIX.knots [BD*] * %u num_knots", count);
  }
  {
    BITCODE_BL maint_version;
    if (dwg_dynapi_entity_value (helix, "HELIX", "maint_version", &maint_version, NULL)
        && maint_version == helix->maint_version)
      pass ();
    else
      fail ("HELIX.maint_version [BL] %u != %u", helix->maint_version, maint_version);
    maint_version++;
    if (dwg_dynapi_entity_set_value (helix, "HELIX", "maint_version", &maint_version, 0)
        && maint_version == helix->maint_version)
      pass ();
    else
      fail ("HELIX.maint_version [BL] set+1 %u != %u", helix->maint_version, maint_version);
    helix->maint_version--;
  }
  {
    BITCODE_BL major_version;
    if (dwg_dynapi_entity_value (helix, "HELIX", "major_version", &major_version, NULL)
        && major_version == helix->major_version)
      pass ();
    else
      fail ("HELIX.major_version [BL] %u != %u", helix->major_version, major_version);
    major_version++;
    if (dwg_dynapi_entity_set_value (helix, "HELIX", "major_version", &major_version, 0)
        && major_version == helix->major_version)
      pass ();
    else
      fail ("HELIX.major_version [BL] set+1 %u != %u", helix->major_version, major_version);
    helix->major_version--;
  }
  {
    BITCODE_BL num_ctrl_pts;
    if (dwg_dynapi_entity_value (helix, "HELIX", "num_ctrl_pts", &num_ctrl_pts, NULL)
        && num_ctrl_pts == helix->num_ctrl_pts)
      pass ();
    else
      fail ("HELIX.num_ctrl_pts [BL] %u != %u", helix->num_ctrl_pts, num_ctrl_pts);
    num_ctrl_pts++;
    if (dwg_dynapi_entity_set_value (helix, "HELIX", "num_ctrl_pts", &num_ctrl_pts, 0)
        && num_ctrl_pts == helix->num_ctrl_pts)
      pass ();
    else
      fail ("HELIX.num_ctrl_pts [BL] set+1 %u != %u", helix->num_ctrl_pts, num_ctrl_pts);
    helix->num_ctrl_pts--;
  }
  {
    BITCODE_BS num_fit_pts;
    if (dwg_dynapi_entity_value (helix, "HELIX", "num_fit_pts", &num_fit_pts, NULL)
        && num_fit_pts == helix->num_fit_pts)
      pass ();
    else
      fail ("HELIX.num_fit_pts [BS] %hu != %hu", helix->num_fit_pts, num_fit_pts);
    num_fit_pts++;
    if (dwg_dynapi_entity_set_value (helix, "HELIX", "num_fit_pts", &num_fit_pts, 0)
        && num_fit_pts == helix->num_fit_pts)
      pass ();
    else
      fail ("HELIX.num_fit_pts [BS] set+1 %hu != %hu", helix->num_fit_pts, num_fit_pts);
    helix->num_fit_pts--;
  }
  {
    BITCODE_BL num_knots;
    if (dwg_dynapi_entity_value (helix, "HELIX", "num_knots", &num_knots, NULL)
        && num_knots == helix->num_knots)
      pass ();
    else
      fail ("HELIX.num_knots [BL] %u != %u", helix->num_knots, num_knots);
    num_knots++;
    if (dwg_dynapi_entity_set_value (helix, "HELIX", "num_knots", &num_knots, 0)
        && num_knots == helix->num_knots)
      pass ();
    else
      fail ("HELIX.num_knots [BL] set+1 %u != %u", helix->num_knots, num_knots);
    helix->num_knots--;
  }
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value (helix, "HELIX", "parent", &parent, NULL)
        && !memcmp (&parent, &helix->parent, sizeof (struct _dwg_object_entity*)))
        pass ();
    else
        fail ("HELIX.parent [struct _dwg_object_entity*]");
  }
  {
    BITCODE_B periodic;
    if (dwg_dynapi_entity_value (helix, "HELIX", "periodic", &periodic, NULL)
        && periodic == helix->periodic)
      pass ();
    else
      fail ("HELIX.periodic [B] " FORMAT_B " != " FORMAT_B "", helix->periodic, periodic);
    periodic++;
    if (dwg_dynapi_entity_set_value (helix, "HELIX", "periodic", &periodic, 0)
        && periodic == helix->periodic)
      pass ();
    else
      fail ("HELIX.periodic [B] set+1 " FORMAT_B " != " FORMAT_B "", helix->periodic, periodic);
    helix->periodic--;
  }
  {
    BITCODE_BD radius;
    if (dwg_dynapi_entity_value (helix, "HELIX", "radius", &radius, NULL)
        && radius == helix->radius)
      pass ();
    else
      fail ("HELIX.radius [BD] %g != %g", helix->radius, radius);
    radius++;
    if (dwg_dynapi_entity_set_value (helix, "HELIX", "radius", &radius, 0)
        && radius == helix->radius)
      pass ();
    else
      fail ("HELIX.radius [BD] set+1 %g != %g", helix->radius, radius);
    helix->radius--;
  }
  {
    BITCODE_B rational;
    if (dwg_dynapi_entity_value (helix, "HELIX", "rational", &rational, NULL)
        && rational == helix->rational)
      pass ();
    else
      fail ("HELIX.rational [B] " FORMAT_B " != " FORMAT_B "", helix->rational, rational);
    rational++;
    if (dwg_dynapi_entity_set_value (helix, "HELIX", "rational", &rational, 0)
        && rational == helix->rational)
      pass ();
    else
      fail ("HELIX.rational [B] set+1 " FORMAT_B " != " FORMAT_B "", helix->rational, rational);
    helix->rational--;
  }
  {
    BITCODE_BS scenario;
    if (dwg_dynapi_entity_value (helix, "HELIX", "scenario", &scenario, NULL)
        && scenario == helix->scenario)
      pass ();
    else
      fail ("HELIX.scenario [BS] %hu != %hu", helix->scenario, scenario);
    scenario++;
    if (dwg_dynapi_entity_set_value (helix, "HELIX", "scenario", &scenario, 0)
        && scenario == helix->scenario)
      pass ();
    else
      fail ("HELIX.scenario [BS] set+1 %hu != %hu", helix->scenario, scenario);
    helix->scenario--;
  }
  {
    BITCODE_BL splineflags1;
    if (dwg_dynapi_entity_value (helix, "HELIX", "splineflags1", &splineflags1, NULL)
        && splineflags1 == helix->splineflags1)
      pass ();
    else
      fail ("HELIX.splineflags1 [BL] %u != %u", helix->splineflags1, splineflags1);
    splineflags1++;
    if (dwg_dynapi_entity_set_value (helix, "HELIX", "splineflags1", &splineflags1, 0)
        && splineflags1 == helix->splineflags1)
      pass ();
    else
      fail ("HELIX.splineflags1 [BL] set+1 %u != %u", helix->splineflags1, splineflags1);
    helix->splineflags1--;
  }
  {
    BITCODE_3BD start_pt;
    if (dwg_dynapi_entity_value (helix, "HELIX", "start_pt", &start_pt, NULL)
        && !memcmp (&start_pt, &helix->start_pt, sizeof (BITCODE_3BD)))
        pass ();
    else
        fail ("HELIX.start_pt [3BD]");
  }
  {
    BITCODE_BD turn_height;
    if (dwg_dynapi_entity_value (helix, "HELIX", "turn_height", &turn_height, NULL)
        && turn_height == helix->turn_height)
      pass ();
    else
      fail ("HELIX.turn_height [BD] %g != %g", helix->turn_height, turn_height);
    turn_height++;
    if (dwg_dynapi_entity_set_value (helix, "HELIX", "turn_height", &turn_height, 0)
        && turn_height == helix->turn_height)
      pass ();
    else
      fail ("HELIX.turn_height [BD] set+1 %g != %g", helix->turn_height, turn_height);
    helix->turn_height--;
  }
  {
    BITCODE_BD turns;
    if (dwg_dynapi_entity_value (helix, "HELIX", "turns", &turns, NULL)
        && turns == helix->turns)
      pass ();
    else
      fail ("HELIX.turns [BD] %g != %g", helix->turns, turns);
    turns++;
    if (dwg_dynapi_entity_set_value (helix, "HELIX", "turns", &turns, 0)
        && turns == helix->turns)
      pass ();
    else
      fail ("HELIX.turns [BD] set+1 %g != %g", helix->turns, turns);
    helix->turns--;
  }
  {
    BITCODE_B weighted;
    if (dwg_dynapi_entity_value (helix, "HELIX", "weighted", &weighted, NULL)
        && weighted == helix->weighted)
      pass ();
    else
      fail ("HELIX.weighted [B] " FORMAT_B " != " FORMAT_B "", helix->weighted, weighted);
    weighted++;
    if (dwg_dynapi_entity_set_value (helix, "HELIX", "weighted", &weighted, 0)
        && weighted == helix->weighted)
      pass ();
    else
      fail ("HELIX.weighted [B] set+1 " FORMAT_B " != " FORMAT_B "", helix->weighted, weighted);
    helix->weighted--;
  }
  if (failed && (is_class_unstable ("HELIX") || is_class_debugging ("HELIX")))
    {
      ok ("%s failed %d tests (TODO unstable)", "HELIX", failed);
      failed = 0;
    }
  return failed;
}
static int test_IMAGE (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_IMAGE *restrict image = obj->tio.entity->tio.IMAGE;
  failed = 0;
  {
    BITCODE_RC brightness;
    if (dwg_dynapi_entity_value (image, "IMAGE", "brightness", &brightness, NULL)
        && brightness == image->brightness)
      pass ();
    else
      fail ("IMAGE.brightness [RC] %u != %u", image->brightness, brightness);
    brightness++;
    if (dwg_dynapi_entity_set_value (image, "IMAGE", "brightness", &brightness, 0)
        && brightness == image->brightness)
      pass ();
    else
      fail ("IMAGE.brightness [RC] set+1 %u != %u", image->brightness, brightness);
    image->brightness--;
  }
  {
    BITCODE_BL class_version;
    if (dwg_dynapi_entity_value (image, "IMAGE", "class_version", &class_version, NULL)
        && class_version == image->class_version)
      pass ();
    else
      fail ("IMAGE.class_version [BL] %u != %u", image->class_version, class_version);
    class_version++;
    if (dwg_dynapi_entity_set_value (image, "IMAGE", "class_version", &class_version, 0)
        && class_version == image->class_version)
      pass ();
    else
      fail ("IMAGE.class_version [BL] set+1 %u != %u", image->class_version, class_version);
    image->class_version--;
  }
  {
    BITCODE_BS clip_boundary_type;
    if (dwg_dynapi_entity_value (image, "IMAGE", "clip_boundary_type", &clip_boundary_type, NULL)
        && clip_boundary_type == image->clip_boundary_type)
      pass ();
    else
      fail ("IMAGE.clip_boundary_type [BS] %hu != %hu", image->clip_boundary_type, clip_boundary_type);
    clip_boundary_type++;
    if (dwg_dynapi_entity_set_value (image, "IMAGE", "clip_boundary_type", &clip_boundary_type, 0)
        && clip_boundary_type == image->clip_boundary_type)
      pass ();
    else
      fail ("IMAGE.clip_boundary_type [BS] set+1 %hu != %hu", image->clip_boundary_type, clip_boundary_type);
    image->clip_boundary_type--;
  }
  {
    BITCODE_B clip_mode;
    if (dwg_dynapi_entity_value (image, "IMAGE", "clip_mode", &clip_mode, NULL)
        && clip_mode == image->clip_mode)
      pass ();
    else
      fail ("IMAGE.clip_mode [B] " FORMAT_B " != " FORMAT_B "", image->clip_mode, clip_mode);
    clip_mode++;
    if (dwg_dynapi_entity_set_value (image, "IMAGE", "clip_mode", &clip_mode, 0)
        && clip_mode == image->clip_mode)
      pass ();
    else
      fail ("IMAGE.clip_mode [B] set+1 " FORMAT_B " != " FORMAT_B "", image->clip_mode, clip_mode);
    image->clip_mode--;
  }
  {
    BITCODE_2RD* clip_verts;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (image, "IMAGE", "num_clip_verts", &count, NULL)
        && dwg_dynapi_entity_value (image, "IMAGE", "clip_verts", &clip_verts, NULL)
        && clip_verts == image->clip_verts)
      pass ();
    else
      fail ("IMAGE.clip_verts [2RD*] * %u num_clip_verts", count);
  }
  {
    BITCODE_B clipping;
    if (dwg_dynapi_entity_value (image, "IMAGE", "clipping", &clipping, NULL)
        && clipping == image->clipping)
      pass ();
    else
      fail ("IMAGE.clipping [B] " FORMAT_B " != " FORMAT_B "", image->clipping, clipping);
    clipping++;
    if (dwg_dynapi_entity_set_value (image, "IMAGE", "clipping", &clipping, 0)
        && clipping == image->clipping)
      pass ();
    else
      fail ("IMAGE.clipping [B] set+1 " FORMAT_B " != " FORMAT_B "", image->clipping, clipping);
    image->clipping--;
  }
  {
    BITCODE_RC contrast;
    if (dwg_dynapi_entity_value (image, "IMAGE", "contrast", &contrast, NULL)
        && contrast == image->contrast)
      pass ();
    else
      fail ("IMAGE.contrast [RC] %u != %u", image->contrast, contrast);
    contrast++;
    if (dwg_dynapi_entity_set_value (image, "IMAGE", "contrast", &contrast, 0)
        && contrast == image->contrast)
      pass ();
    else
      fail ("IMAGE.contrast [RC] set+1 %u != %u", image->contrast, contrast);
    image->contrast--;
  }
  {
    BITCODE_BS display_props;
    if (dwg_dynapi_entity_value (image, "IMAGE", "display_props", &display_props, NULL)
        && display_props == image->display_props)
      pass ();
    else
      fail ("IMAGE.display_props [BS] %hu != %hu", image->display_props, display_props);
    display_props++;
    if (dwg_dynapi_entity_set_value (image, "IMAGE", "display_props", &display_props, 0)
        && display_props == image->display_props)
      pass ();
    else
      fail ("IMAGE.display_props [BS] set+1 %hu != %hu", image->display_props, display_props);
    image->display_props--;
  }
  {
    BITCODE_RC fade;
    if (dwg_dynapi_entity_value (image, "IMAGE", "fade", &fade, NULL)
        && fade == image->fade)
      pass ();
    else
      fail ("IMAGE.fade [RC] %u != %u", image->fade, fade);
    fade++;
    if (dwg_dynapi_entity_set_value (image, "IMAGE", "fade", &fade, 0)
        && fade == image->fade)
      pass ();
    else
      fail ("IMAGE.fade [RC] set+1 %u != %u", image->fade, fade);
    image->fade--;
  }
  {
    BITCODE_H imagedef;
    if (dwg_dynapi_entity_value (image, "IMAGE", "imagedef", &imagedef, NULL)
        && !memcmp (&imagedef, &image->imagedef, sizeof (BITCODE_H)))
        pass ();
    else
        fail ("IMAGE.imagedef [H]");
  }
  {
    BITCODE_H imagedefreactor;
    if (dwg_dynapi_entity_value (image, "IMAGE", "imagedefreactor", &imagedefreactor, NULL)
        && !memcmp (&imagedefreactor, &image->imagedefreactor, sizeof (BITCODE_H)))
        pass ();
    else
        fail ("IMAGE.imagedefreactor [H]");
  }
  {
    BITCODE_BL num_clip_verts;
    if (dwg_dynapi_entity_value (image, "IMAGE", "num_clip_verts", &num_clip_verts, NULL)
        && num_clip_verts == image->num_clip_verts)
      pass ();
    else
      fail ("IMAGE.num_clip_verts [BL] %u != %u", image->num_clip_verts, num_clip_verts);
    num_clip_verts++;
    if (dwg_dynapi_entity_set_value (image, "IMAGE", "num_clip_verts", &num_clip_verts, 0)
        && num_clip_verts == image->num_clip_verts)
      pass ();
    else
      fail ("IMAGE.num_clip_verts [BL] set+1 %u != %u", image->num_clip_verts, num_clip_verts);
    image->num_clip_verts--;
  }
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value (image, "IMAGE", "parent", &parent, NULL)
        && !memcmp (&parent, &image->parent, sizeof (struct _dwg_object_entity*)))
        pass ();
    else
        fail ("IMAGE.parent [struct _dwg_object_entity*]");
  }
  {
    BITCODE_3BD pt0;
    if (dwg_dynapi_entity_value (image, "IMAGE", "pt0", &pt0, NULL)
        && !memcmp (&pt0, &image->pt0, sizeof (BITCODE_3BD)))
        pass ();
    else
        fail ("IMAGE.pt0 [3BD]");
  }
  {
    BITCODE_2RD size;
    if (dwg_dynapi_entity_value (image, "IMAGE", "size", &size, NULL)
        && !memcmp (&size, &image->size, sizeof (BITCODE_2RD)))
        pass ();
    else
        fail ("IMAGE.size [2RD]");
  }
  {
    BITCODE_3BD uvec;
    if (dwg_dynapi_entity_value (image, "IMAGE", "uvec", &uvec, NULL)
        && !memcmp (&uvec, &image->uvec, sizeof (BITCODE_3BD)))
        pass ();
    else
        fail ("IMAGE.uvec [3BD]");
  }
  {
    BITCODE_3BD vvec;
    if (dwg_dynapi_entity_value (image, "IMAGE", "vvec", &vvec, NULL)
        && !memcmp (&vvec, &image->vvec, sizeof (BITCODE_3BD)))
        pass ();
    else
        fail ("IMAGE.vvec [3BD]");
  }
  if (failed && (is_class_unstable ("IMAGE") || is_class_debugging ("IMAGE")))
    {
      ok ("%s failed %d tests (TODO unstable)", "IMAGE", failed);
      failed = 0;
    }
  return failed;
}
static int test_INSERT (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_INSERT *restrict insert = obj->tio.entity->tio.INSERT;
  failed = 0;
  {
    BITCODE_H* attribs;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (insert, "INSERT", "num_owned", &count, NULL)
        && dwg_dynapi_entity_value (insert, "INSERT", "attribs", &attribs, NULL)
        && attribs == insert->attribs)
      pass ();
    else
      fail ("INSERT.attribs [H*] * %u num_owned", count);
  }
  {
    BITCODE_H block_header;
    if (dwg_dynapi_entity_value (insert, "INSERT", "block_header", &block_header, NULL)
        && !memcmp (&block_header, &insert->block_header, sizeof (BITCODE_H)))
        pass ();
    else
        fail ("INSERT.block_header [H]");
  }
  {
    BITCODE_BE extrusion;
    if (dwg_dynapi_entity_value (insert, "INSERT", "extrusion", &extrusion, NULL)
        && !memcmp (&extrusion, &insert->extrusion, sizeof (BITCODE_BE)))
        pass ();
    else
        fail ("INSERT.extrusion [BE]");
  }
  {
    BITCODE_H first_attrib;
    if (dwg_dynapi_entity_value (insert, "INSERT", "first_attrib", &first_attrib, NULL)
        && !memcmp (&first_attrib, &insert->first_attrib, sizeof (BITCODE_H)))
        pass ();
    else
        fail ("INSERT.first_attrib [H]");
  }
  {
    BITCODE_B has_attribs;
    if (dwg_dynapi_entity_value (insert, "INSERT", "has_attribs", &has_attribs, NULL)
        && has_attribs == insert->has_attribs)
      pass ();
    else
      fail ("INSERT.has_attribs [B] " FORMAT_B " != " FORMAT_B "", insert->has_attribs, has_attribs);
    has_attribs++;
    if (dwg_dynapi_entity_set_value (insert, "INSERT", "has_attribs", &has_attribs, 0)
        && has_attribs == insert->has_attribs)
      pass ();
    else
      fail ("INSERT.has_attribs [B] set+1 " FORMAT_B " != " FORMAT_B "", insert->has_attribs, has_attribs);
    insert->has_attribs--;
  }
  {
    BITCODE_3DPOINT ins_pt;
    if (dwg_dynapi_entity_value (insert, "INSERT", "ins_pt", &ins_pt, NULL)
        && !memcmp (&ins_pt, &insert->ins_pt, sizeof (BITCODE_3DPOINT)))
        pass ();
    else
        fail ("INSERT.ins_pt [3DPOINT]");
  }
  {
    BITCODE_H last_attrib;
    if (dwg_dynapi_entity_value (insert, "INSERT", "last_attrib", &last_attrib, NULL)
        && !memcmp (&last_attrib, &insert->last_attrib, sizeof (BITCODE_H)))
        pass ();
    else
        fail ("INSERT.last_attrib [H]");
  }
  {
    BITCODE_BL num_owned;
    if (dwg_dynapi_entity_value (insert, "INSERT", "num_owned", &num_owned, NULL)
        && num_owned == insert->num_owned)
      pass ();
    else
      fail ("INSERT.num_owned [BL] %u != %u", insert->num_owned, num_owned);
    num_owned++;
    if (dwg_dynapi_entity_set_value (insert, "INSERT", "num_owned", &num_owned, 0)
        && num_owned == insert->num_owned)
      pass ();
    else
      fail ("INSERT.num_owned [BL] set+1 %u != %u", insert->num_owned, num_owned);
    insert->num_owned--;
  }
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value (insert, "INSERT", "parent", &parent, NULL)
        && !memcmp (&parent, &insert->parent, sizeof (struct _dwg_object_entity*)))
        pass ();
    else
        fail ("INSERT.parent [struct _dwg_object_entity*]");
  }
  {
    BITCODE_BD rotation;
    if (dwg_dynapi_entity_value (insert, "INSERT", "rotation", &rotation, NULL)
        && rotation == insert->rotation)
      pass ();
    else
      fail ("INSERT.rotation [BD] %g != %g", insert->rotation, rotation);
    rotation++;
    if (dwg_dynapi_entity_set_value (insert, "INSERT", "rotation", &rotation, 0)
        && rotation == insert->rotation)
      pass ();
    else
      fail ("INSERT.rotation [BD] set+1 %g != %g", insert->rotation, rotation);
    insert->rotation--;
  }
  {
    BITCODE_3BD scale;
    if (dwg_dynapi_entity_value (insert, "INSERT", "scale", &scale, NULL)
        && !memcmp (&scale, &insert->scale, sizeof (BITCODE_3BD)))
        pass ();
    else
        fail ("INSERT.scale [3BD_1]");
  }
  {
    BITCODE_BB scale_flag;
    if (dwg_dynapi_entity_value (insert, "INSERT", "scale_flag", &scale_flag, NULL)
        && scale_flag == insert->scale_flag)
      pass ();
    else
      fail ("INSERT.scale_flag [BB] " FORMAT_BB " != " FORMAT_BB "", insert->scale_flag, scale_flag);
    scale_flag++;
    if (dwg_dynapi_entity_set_value (insert, "INSERT", "scale_flag", &scale_flag, 0)
        && scale_flag == insert->scale_flag)
      pass ();
    else
      fail ("INSERT.scale_flag [BB] set+1 " FORMAT_BB " != " FORMAT_BB "", insert->scale_flag, scale_flag);
    insert->scale_flag--;
  }
  {
    BITCODE_H seqend;
    if (dwg_dynapi_entity_value (insert, "INSERT", "seqend", &seqend, NULL)
        && !memcmp (&seqend, &insert->seqend, sizeof (BITCODE_H)))
        pass ();
    else
        fail ("INSERT.seqend [H]");
  }
  if (failed && (is_class_unstable ("INSERT") || is_class_debugging ("INSERT")))
    {
      ok ("%s failed %d tests (TODO unstable)", "INSERT", failed);
      failed = 0;
    }
  return failed;
}
static int test_LARGE_RADIAL_DIMENSION (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_LARGE_RADIAL_DIMENSION *restrict large_radial_dimension = obj->tio.entity->tio.LARGE_RADIAL_DIMENSION;
  failed = 0;
  {
    BITCODE_BD act_measurement;
    if (dwg_dynapi_entity_value (large_radial_dimension, "LARGE_RADIAL_DIMENSION", "act_measurement", &act_measurement, NULL)
        && act_measurement == large_radial_dimension->act_measurement)
      pass ();
    else
      fail ("LARGE_RADIAL_DIMENSION.act_measurement [BD] %g != %g", large_radial_dimension->act_measurement, act_measurement);
    act_measurement++;
    if (dwg_dynapi_entity_set_value (large_radial_dimension, "LARGE_RADIAL_DIMENSION", "act_measurement", &act_measurement, 0)
        && act_measurement == large_radial_dimension->act_measurement)
      pass ();
    else
      fail ("LARGE_RADIAL_DIMENSION.act_measurement [BD] set+1 %g != %g", large_radial_dimension->act_measurement, act_measurement);
    large_radial_dimension->act_measurement--;
  }
  {
    BITCODE_BS attachment;
    if (dwg_dynapi_entity_value (large_radial_dimension, "LARGE_RADIAL_DIMENSION", "attachment", &attachment, NULL)
        && attachment == large_radial_dimension->attachment)
      pass ();
    else
      fail ("LARGE_RADIAL_DIMENSION.attachment [BS] %hu != %hu", large_radial_dimension->attachment, attachment);
    attachment++;
    if (dwg_dynapi_entity_set_value (large_radial_dimension, "LARGE_RADIAL_DIMENSION", "attachment", &attachment, 0)
        && attachment == large_radial_dimension->attachment)
      pass ();
    else
      fail ("LARGE_RADIAL_DIMENSION.attachment [BS] set+1 %hu != %hu", large_radial_dimension->attachment, attachment);
    large_radial_dimension->attachment--;
  }
  {
    BITCODE_H block;
    if (dwg_dynapi_entity_value (large_radial_dimension, "LARGE_RADIAL_DIMENSION", "block", &block, NULL)
        && !memcmp (&block, &large_radial_dimension->block, sizeof (BITCODE_H)))
        pass ();
    else
        fail ("LARGE_RADIAL_DIMENSION.block [H]");
  }
  {
    BITCODE_TV blockname;
    if (dwg_dynapi_entity_value (large_radial_dimension, "LARGE_RADIAL_DIMENSION", "blockname", &blockname, NULL)
        && blockname
           ? strEQ ((char *)blockname, (char *)large_radial_dimension->blockname)
           : !large_radial_dimension->blockname)
      pass ();
    else
      fail ("LARGE_RADIAL_DIMENSION.blockname [TV] '%s' <> '%s'", blockname, large_radial_dimension->blockname);
  }
  {
    BITCODE_RC class_version;
    if (dwg_dynapi_entity_value (large_radial_dimension, "LARGE_RADIAL_DIMENSION", "class_version", &class_version, NULL)
        && class_version == large_radial_dimension->class_version)
      pass ();
    else
      fail ("LARGE_RADIAL_DIMENSION.class_version [RC] %u != %u", large_radial_dimension->class_version, class_version);
    class_version++;
    if (dwg_dynapi_entity_set_value (large_radial_dimension, "LARGE_RADIAL_DIMENSION", "class_version", &class_version, 0)
        && class_version == large_radial_dimension->class_version)
      pass ();
    else
      fail ("LARGE_RADIAL_DIMENSION.class_version [RC] set+1 %u != %u", large_radial_dimension->class_version, class_version);
    large_radial_dimension->class_version--;
  }
  {
    BITCODE_2RD clone_ins_pt;
    if (dwg_dynapi_entity_value (large_radial_dimension, "LARGE_RADIAL_DIMENSION", "clone_ins_pt", &clone_ins_pt, NULL)
        && !memcmp (&clone_ins_pt, &large_radial_dimension->clone_ins_pt, sizeof (BITCODE_2RD)))
        pass ();
    else
        fail ("LARGE_RADIAL_DIMENSION.clone_ins_pt [2RD]");
  }
  {
    BITCODE_3BD def_pt;
    if (dwg_dynapi_entity_value (large_radial_dimension, "LARGE_RADIAL_DIMENSION", "def_pt", &def_pt, NULL)
        && !memcmp (&def_pt, &large_radial_dimension->def_pt, sizeof (BITCODE_3BD)))
        pass ();
    else
        fail ("LARGE_RADIAL_DIMENSION.def_pt [3BD]");
  }
  {
    BITCODE_H dimstyle;
    if (dwg_dynapi_entity_value (large_radial_dimension, "LARGE_RADIAL_DIMENSION", "dimstyle", &dimstyle, NULL)
        && !memcmp (&dimstyle, &large_radial_dimension->dimstyle, sizeof (BITCODE_H)))
        pass ();
    else
        fail ("LARGE_RADIAL_DIMENSION.dimstyle [H]");
  }
  {
    BITCODE_BD elevation;
    if (dwg_dynapi_entity_value (large_radial_dimension, "LARGE_RADIAL_DIMENSION", "elevation", &elevation, NULL)
        && elevation == large_radial_dimension->elevation)
      pass ();
    else
      fail ("LARGE_RADIAL_DIMENSION.elevation [BD] %g != %g", large_radial_dimension->elevation, elevation);
    elevation++;
    if (dwg_dynapi_entity_set_value (large_radial_dimension, "LARGE_RADIAL_DIMENSION", "elevation", &elevation, 0)
        && elevation == large_radial_dimension->elevation)
      pass ();
    else
      fail ("LARGE_RADIAL_DIMENSION.elevation [BD] set+1 %g != %g", large_radial_dimension->elevation, elevation);
    large_radial_dimension->elevation--;
  }
  {
    BITCODE_BE extrusion;
    if (dwg_dynapi_entity_value (large_radial_dimension, "LARGE_RADIAL_DIMENSION", "extrusion", &extrusion, NULL)
        && !memcmp (&extrusion, &large_radial_dimension->extrusion, sizeof (BITCODE_BE)))
        pass ();
    else
        fail ("LARGE_RADIAL_DIMENSION.extrusion [BE]");
  }
  {
    BITCODE_3BD first_arc_pt;
    if (dwg_dynapi_entity_value (large_radial_dimension, "LARGE_RADIAL_DIMENSION", "first_arc_pt", &first_arc_pt, NULL)
        && !memcmp (&first_arc_pt, &large_radial_dimension->first_arc_pt, sizeof (BITCODE_3BD)))
        pass ();
    else
        fail ("LARGE_RADIAL_DIMENSION.first_arc_pt [3BD]");
  }
  {
    BITCODE_RC flag;
    if (dwg_dynapi_entity_value (large_radial_dimension, "LARGE_RADIAL_DIMENSION", "flag", &flag, NULL)
        && flag == large_radial_dimension->flag)
      pass ();
    else
      fail ("LARGE_RADIAL_DIMENSION.flag [RC] %u != %u", large_radial_dimension->flag, flag);
    flag++;
    if (dwg_dynapi_entity_set_value (large_radial_dimension, "LARGE_RADIAL_DIMENSION", "flag", &flag, 0)
        && flag == large_radial_dimension->flag)
      pass ();
    else
      fail ("LARGE_RADIAL_DIMENSION.flag [RC] set+1 %u != %u", large_radial_dimension->flag, flag);
    large_radial_dimension->flag--;
  }
  {
    BITCODE_RC flag1;
    if (dwg_dynapi_entity_value (large_radial_dimension, "LARGE_RADIAL_DIMENSION", "flag1", &flag1, NULL)
        && flag1 == large_radial_dimension->flag1)
      pass ();
    else
      fail ("LARGE_RADIAL_DIMENSION.flag1 [RC] %u != %u", large_radial_dimension->flag1, flag1);
    flag1++;
    if (dwg_dynapi_entity_set_value (large_radial_dimension, "LARGE_RADIAL_DIMENSION", "flag1", &flag1, 0)
        && flag1 == large_radial_dimension->flag1)
      pass ();
    else
      fail ("LARGE_RADIAL_DIMENSION.flag1 [RC] set+1 %u != %u", large_radial_dimension->flag1, flag1);
    large_radial_dimension->flag1--;
  }
  {
    BITCODE_B flip_arrow1;
    if (dwg_dynapi_entity_value (large_radial_dimension, "LARGE_RADIAL_DIMENSION", "flip_arrow1", &flip_arrow1, NULL)
        && flip_arrow1 == large_radial_dimension->flip_arrow1)
      pass ();
    else
      fail ("LARGE_RADIAL_DIMENSION.flip_arrow1 [B] " FORMAT_B " != " FORMAT_B "", large_radial_dimension->flip_arrow1, flip_arrow1);
    flip_arrow1++;
    if (dwg_dynapi_entity_set_value (large_radial_dimension, "LARGE_RADIAL_DIMENSION", "flip_arrow1", &flip_arrow1, 0)
        && flip_arrow1 == large_radial_dimension->flip_arrow1)
      pass ();
    else
      fail ("LARGE_RADIAL_DIMENSION.flip_arrow1 [B] set+1 " FORMAT_B " != " FORMAT_B "", large_radial_dimension->flip_arrow1, flip_arrow1);
    large_radial_dimension->flip_arrow1--;
  }
  {
    BITCODE_B flip_arrow2;
    if (dwg_dynapi_entity_value (large_radial_dimension, "LARGE_RADIAL_DIMENSION", "flip_arrow2", &flip_arrow2, NULL)
        && flip_arrow2 == large_radial_dimension->flip_arrow2)
      pass ();
    else
      fail ("LARGE_RADIAL_DIMENSION.flip_arrow2 [B] " FORMAT_B " != " FORMAT_B "", large_radial_dimension->flip_arrow2, flip_arrow2);
    flip_arrow2++;
    if (dwg_dynapi_entity_set_value (large_radial_dimension, "LARGE_RADIAL_DIMENSION", "flip_arrow2", &flip_arrow2, 0)
        && flip_arrow2 == large_radial_dimension->flip_arrow2)
      pass ();
    else
      fail ("LARGE_RADIAL_DIMENSION.flip_arrow2 [B] set+1 " FORMAT_B " != " FORMAT_B "", large_radial_dimension->flip_arrow2, flip_arrow2);
    large_radial_dimension->flip_arrow2--;
  }
  {
    BITCODE_BD horiz_dir;
    if (dwg_dynapi_entity_value (large_radial_dimension, "LARGE_RADIAL_DIMENSION", "horiz_dir", &horiz_dir, NULL)
        && horiz_dir == large_radial_dimension->horiz_dir)
      pass ();
    else
      fail ("LARGE_RADIAL_DIMENSION.horiz_dir [BD] %g != %g", large_radial_dimension->horiz_dir, horiz_dir);
    horiz_dir++;
    if (dwg_dynapi_entity_set_value (large_radial_dimension, "LARGE_RADIAL_DIMENSION", "horiz_dir", &horiz_dir, 0)
        && horiz_dir == large_radial_dimension->horiz_dir)
      pass ();
    else
      fail ("LARGE_RADIAL_DIMENSION.horiz_dir [BD] set+1 %g != %g", large_radial_dimension->horiz_dir, horiz_dir);
    large_radial_dimension->horiz_dir--;
  }
  {
    BITCODE_BD ins_rotation;
    if (dwg_dynapi_entity_value (large_radial_dimension, "LARGE_RADIAL_DIMENSION", "ins_rotation", &ins_rotation, NULL)
        && ins_rotation == large_radial_dimension->ins_rotation)
      pass ();
    else
      fail ("LARGE_RADIAL_DIMENSION.ins_rotation [BD] %g != %g", large_radial_dimension->ins_rotation, ins_rotation);
    ins_rotation++;
    if (dwg_dynapi_entity_set_value (large_radial_dimension, "LARGE_RADIAL_DIMENSION", "ins_rotation", &ins_rotation, 0)
        && ins_rotation == large_radial_dimension->ins_rotation)
      pass ();
    else
      fail ("LARGE_RADIAL_DIMENSION.ins_rotation [BD] set+1 %g != %g", large_radial_dimension->ins_rotation, ins_rotation);
    large_radial_dimension->ins_rotation--;
  }
  {
    BITCODE_3BD ins_scale;
    if (dwg_dynapi_entity_value (large_radial_dimension, "LARGE_RADIAL_DIMENSION", "ins_scale", &ins_scale, NULL)
        && !memcmp (&ins_scale, &large_radial_dimension->ins_scale, sizeof (BITCODE_3BD)))
        pass ();
    else
        fail ("LARGE_RADIAL_DIMENSION.ins_scale [3BD]");
  }
  {
    BITCODE_3BD jog_point;
    if (dwg_dynapi_entity_value (large_radial_dimension, "LARGE_RADIAL_DIMENSION", "jog_point", &jog_point, NULL)
        && !memcmp (&jog_point, &large_radial_dimension->jog_point, sizeof (BITCODE_3BD)))
        pass ();
    else
        fail ("LARGE_RADIAL_DIMENSION.jog_point [3BD]");
  }
  {
    BITCODE_BD leader_len;
    if (dwg_dynapi_entity_value (large_radial_dimension, "LARGE_RADIAL_DIMENSION", "leader_len", &leader_len, NULL)
        && leader_len == large_radial_dimension->leader_len)
      pass ();
    else
      fail ("LARGE_RADIAL_DIMENSION.leader_len [BD] %g != %g", large_radial_dimension->leader_len, leader_len);
    leader_len++;
    if (dwg_dynapi_entity_set_value (large_radial_dimension, "LARGE_RADIAL_DIMENSION", "leader_len", &leader_len, 0)
        && leader_len == large_radial_dimension->leader_len)
      pass ();
    else
      fail ("LARGE_RADIAL_DIMENSION.leader_len [BD] set+1 %g != %g", large_radial_dimension->leader_len, leader_len);
    large_radial_dimension->leader_len--;
  }
  {
    BITCODE_BD lspace_factor;
    if (dwg_dynapi_entity_value (large_radial_dimension, "LARGE_RADIAL_DIMENSION", "lspace_factor", &lspace_factor, NULL)
        && lspace_factor == large_radial_dimension->lspace_factor)
      pass ();
    else
      fail ("LARGE_RADIAL_DIMENSION.lspace_factor [BD] %g != %g", large_radial_dimension->lspace_factor, lspace_factor);
    lspace_factor++;
    if (dwg_dynapi_entity_set_value (large_radial_dimension, "LARGE_RADIAL_DIMENSION", "lspace_factor", &lspace_factor, 0)
        && lspace_factor == large_radial_dimension->lspace_factor)
      pass ();
    else
      fail ("LARGE_RADIAL_DIMENSION.lspace_factor [BD] set+1 %g != %g", large_radial_dimension->lspace_factor, lspace_factor);
    large_radial_dimension->lspace_factor--;
  }
  {
    BITCODE_BS lspace_style;
    if (dwg_dynapi_entity_value (large_radial_dimension, "LARGE_RADIAL_DIMENSION", "lspace_style", &lspace_style, NULL)
        && lspace_style == large_radial_dimension->lspace_style)
      pass ();
    else
      fail ("LARGE_RADIAL_DIMENSION.lspace_style [BS] %hu != %hu", large_radial_dimension->lspace_style, lspace_style);
    lspace_style++;
    if (dwg_dynapi_entity_set_value (large_radial_dimension, "LARGE_RADIAL_DIMENSION", "lspace_style", &lspace_style, 0)
        && lspace_style == large_radial_dimension->lspace_style)
      pass ();
    else
      fail ("LARGE_RADIAL_DIMENSION.lspace_style [BS] set+1 %hu != %hu", large_radial_dimension->lspace_style, lspace_style);
    large_radial_dimension->lspace_style--;
  }
  {
    BITCODE_3BD ovr_center;
    if (dwg_dynapi_entity_value (large_radial_dimension, "LARGE_RADIAL_DIMENSION", "ovr_center", &ovr_center, NULL)
        && !memcmp (&ovr_center, &large_radial_dimension->ovr_center, sizeof (BITCODE_3BD)))
        pass ();
    else
        fail ("LARGE_RADIAL_DIMENSION.ovr_center [3BD]");
  }
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value (large_radial_dimension, "LARGE_RADIAL_DIMENSION", "parent", &parent, NULL)
        && !memcmp (&parent, &large_radial_dimension->parent, sizeof (struct _dwg_object_entity*)))
        pass ();
    else
        fail ("LARGE_RADIAL_DIMENSION.parent [struct _dwg_object_entity*]");
  }
  {
    BITCODE_2RD text_midpt;
    if (dwg_dynapi_entity_value (large_radial_dimension, "LARGE_RADIAL_DIMENSION", "text_midpt", &text_midpt, NULL)
        && !memcmp (&text_midpt, &large_radial_dimension->text_midpt, sizeof (BITCODE_2RD)))
        pass ();
    else
        fail ("LARGE_RADIAL_DIMENSION.text_midpt [2RD]");
  }
  {
    BITCODE_BD text_rotation;
    if (dwg_dynapi_entity_value (large_radial_dimension, "LARGE_RADIAL_DIMENSION", "text_rotation", &text_rotation, NULL)
        && text_rotation == large_radial_dimension->text_rotation)
      pass ();
    else
      fail ("LARGE_RADIAL_DIMENSION.text_rotation [BD] %g != %g", large_radial_dimension->text_rotation, text_rotation);
    text_rotation++;
    if (dwg_dynapi_entity_set_value (large_radial_dimension, "LARGE_RADIAL_DIMENSION", "text_rotation", &text_rotation, 0)
        && text_rotation == large_radial_dimension->text_rotation)
      pass ();
    else
      fail ("LARGE_RADIAL_DIMENSION.text_rotation [BD] set+1 %g != %g", large_radial_dimension->text_rotation, text_rotation);
    large_radial_dimension->text_rotation--;
  }
  {
    BITCODE_B unknown;
    if (dwg_dynapi_entity_value (large_radial_dimension, "LARGE_RADIAL_DIMENSION", "unknown", &unknown, NULL)
        && unknown == large_radial_dimension->unknown)
      pass ();
    else
      fail ("LARGE_RADIAL_DIMENSION.unknown [B] " FORMAT_B " != " FORMAT_B "", large_radial_dimension->unknown, unknown);
    unknown++;
    if (dwg_dynapi_entity_set_value (large_radial_dimension, "LARGE_RADIAL_DIMENSION", "unknown", &unknown, 0)
        && unknown == large_radial_dimension->unknown)
      pass ();
    else
      fail ("LARGE_RADIAL_DIMENSION.unknown [B] set+1 " FORMAT_B " != " FORMAT_B "", large_radial_dimension->unknown, unknown);
    large_radial_dimension->unknown--;
  }
  {
    BITCODE_TV user_text;
    if (dwg_dynapi_entity_value (large_radial_dimension, "LARGE_RADIAL_DIMENSION", "user_text", &user_text, NULL)
        && user_text
           ? strEQ ((char *)user_text, (char *)large_radial_dimension->user_text)
           : !large_radial_dimension->user_text)
      pass ();
    else
      fail ("LARGE_RADIAL_DIMENSION.user_text [TV] '%s' <> '%s'", user_text, large_radial_dimension->user_text);
  }
  if (failed && (is_class_unstable ("LARGE_RADIAL_DIMENSION") || is_class_debugging ("LARGE_RADIAL_DIMENSION")))
    {
      ok ("%s failed %d tests (TODO unstable)", "LARGE_RADIAL_DIMENSION", failed);
      failed = 0;
    }
  return failed;
}
static int test_LEADER (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_LEADER *restrict leader = obj->tio.entity->tio.LEADER;
  failed = 0;
  {
    BITCODE_BS annot_type;
    if (dwg_dynapi_entity_value (leader, "LEADER", "annot_type", &annot_type, NULL)
        && annot_type == leader->annot_type)
      pass ();
    else
      fail ("LEADER.annot_type [BS] %hu != %hu", leader->annot_type, annot_type);
    annot_type++;
    if (dwg_dynapi_entity_set_value (leader, "LEADER", "annot_type", &annot_type, 0)
        && annot_type == leader->annot_type)
      pass ();
    else
      fail ("LEADER.annot_type [BS] set+1 %hu != %hu", leader->annot_type, annot_type);
    leader->annot_type--;
  }
  {
    BITCODE_B arrowhead_on;
    if (dwg_dynapi_entity_value (leader, "LEADER", "arrowhead_on", &arrowhead_on, NULL)
        && arrowhead_on == leader->arrowhead_on)
      pass ();
    else
      fail ("LEADER.arrowhead_on [B] " FORMAT_B " != " FORMAT_B "", leader->arrowhead_on, arrowhead_on);
    arrowhead_on++;
    if (dwg_dynapi_entity_set_value (leader, "LEADER", "arrowhead_on", &arrowhead_on, 0)
        && arrowhead_on == leader->arrowhead_on)
      pass ();
    else
      fail ("LEADER.arrowhead_on [B] set+1 " FORMAT_B " != " FORMAT_B "", leader->arrowhead_on, arrowhead_on);
    leader->arrowhead_on--;
  }
  {
    BITCODE_BS arrowhead_type;
    if (dwg_dynapi_entity_value (leader, "LEADER", "arrowhead_type", &arrowhead_type, NULL)
        && arrowhead_type == leader->arrowhead_type)
      pass ();
    else
      fail ("LEADER.arrowhead_type [BS] %hu != %hu", leader->arrowhead_type, arrowhead_type);
    arrowhead_type++;
    if (dwg_dynapi_entity_set_value (leader, "LEADER", "arrowhead_type", &arrowhead_type, 0)
        && arrowhead_type == leader->arrowhead_type)
      pass ();
    else
      fail ("LEADER.arrowhead_type [BS] set+1 %hu != %hu", leader->arrowhead_type, arrowhead_type);
    leader->arrowhead_type--;
  }
  {
    BITCODE_H associated_annotation;
    if (dwg_dynapi_entity_value (leader, "LEADER", "associated_annotation", &associated_annotation, NULL)
        && !memcmp (&associated_annotation, &leader->associated_annotation, sizeof (BITCODE_H)))
        pass ();
    else
        fail ("LEADER.associated_annotation [H]");
  }
  {
    BITCODE_BD box_height;
    if (dwg_dynapi_entity_value (leader, "LEADER", "box_height", &box_height, NULL)
        && box_height == leader->box_height)
      pass ();
    else
      fail ("LEADER.box_height [BD] %g != %g", leader->box_height, box_height);
    box_height++;
    if (dwg_dynapi_entity_set_value (leader, "LEADER", "box_height", &box_height, 0)
        && box_height == leader->box_height)
      pass ();
    else
      fail ("LEADER.box_height [BD] set+1 %g != %g", leader->box_height, box_height);
    leader->box_height--;
  }
  {
    BITCODE_BD box_width;
    if (dwg_dynapi_entity_value (leader, "LEADER", "box_width", &box_width, NULL)
        && box_width == leader->box_width)
      pass ();
    else
      fail ("LEADER.box_width [BD] %g != %g", leader->box_width, box_width);
    box_width++;
    if (dwg_dynapi_entity_set_value (leader, "LEADER", "box_width", &box_width, 0)
        && box_width == leader->box_width)
      pass ();
    else
      fail ("LEADER.box_width [BD] set+1 %g != %g", leader->box_width, box_width);
    leader->box_width--;
  }
  {
    BITCODE_BS byblock_color;
    if (dwg_dynapi_entity_value (leader, "LEADER", "byblock_color", &byblock_color, NULL)
        && byblock_color == leader->byblock_color)
      pass ();
    else
      fail ("LEADER.byblock_color [BS] %hu != %hu", leader->byblock_color, byblock_color);
    byblock_color++;
    if (dwg_dynapi_entity_set_value (leader, "LEADER", "byblock_color", &byblock_color, 0)
        && byblock_color == leader->byblock_color)
      pass ();
    else
      fail ("LEADER.byblock_color [BS] set+1 %hu != %hu", leader->byblock_color, byblock_color);
    leader->byblock_color--;
  }
  {
    BITCODE_BD dimasz;
    if (dwg_dynapi_entity_value (leader, "LEADER", "dimasz", &dimasz, NULL)
        && dimasz == leader->dimasz)
      pass ();
    else
      fail ("LEADER.dimasz [BD] %g != %g", leader->dimasz, dimasz);
    dimasz++;
    if (dwg_dynapi_entity_set_value (leader, "LEADER", "dimasz", &dimasz, 0)
        && dimasz == leader->dimasz)
      pass ();
    else
      fail ("LEADER.dimasz [BD] set+1 %g != %g", leader->dimasz, dimasz);
    leader->dimasz--;
  }
  {
    BITCODE_BD dimgap;
    if (dwg_dynapi_entity_value (leader, "LEADER", "dimgap", &dimgap, NULL)
        && dimgap == leader->dimgap)
      pass ();
    else
      fail ("LEADER.dimgap [BD] %g != %g", leader->dimgap, dimgap);
    dimgap++;
    if (dwg_dynapi_entity_set_value (leader, "LEADER", "dimgap", &dimgap, 0)
        && dimgap == leader->dimgap)
      pass ();
    else
      fail ("LEADER.dimgap [BD] set+1 %g != %g", leader->dimgap, dimgap);
    leader->dimgap--;
  }
  {
    BITCODE_H dimstyle;
    if (dwg_dynapi_entity_value (leader, "LEADER", "dimstyle", &dimstyle, NULL)
        && !memcmp (&dimstyle, &leader->dimstyle, sizeof (BITCODE_H)))
        pass ();
    else
        fail ("LEADER.dimstyle [H]");
  }
  {
    BITCODE_3DPOINT endptproj;
    if (dwg_dynapi_entity_value (leader, "LEADER", "endptproj", &endptproj, NULL)
        && !memcmp (&endptproj, &leader->endptproj, sizeof (BITCODE_3DPOINT)))
        pass ();
    else
        fail ("LEADER.endptproj [3DPOINT]");
  }
  {
    BITCODE_BE extrusion;
    if (dwg_dynapi_entity_value (leader, "LEADER", "extrusion", &extrusion, NULL)
        && !memcmp (&extrusion, &leader->extrusion, sizeof (BITCODE_BE)))
        pass ();
    else
        fail ("LEADER.extrusion [BE]");
  }
  {
    BITCODE_B hookline_dir;
    if (dwg_dynapi_entity_value (leader, "LEADER", "hookline_dir", &hookline_dir, NULL)
        && hookline_dir == leader->hookline_dir)
      pass ();
    else
      fail ("LEADER.hookline_dir [B] " FORMAT_B " != " FORMAT_B "", leader->hookline_dir, hookline_dir);
    hookline_dir++;
    if (dwg_dynapi_entity_set_value (leader, "LEADER", "hookline_dir", &hookline_dir, 0)
        && hookline_dir == leader->hookline_dir)
      pass ();
    else
      fail ("LEADER.hookline_dir [B] set+1 " FORMAT_B " != " FORMAT_B "", leader->hookline_dir, hookline_dir);
    leader->hookline_dir--;
  }
  {
    BITCODE_B hookline_on;
    if (dwg_dynapi_entity_value (leader, "LEADER", "hookline_on", &hookline_on, NULL)
        && hookline_on == leader->hookline_on)
      pass ();
    else
      fail ("LEADER.hookline_on [B] " FORMAT_B " != " FORMAT_B "", leader->hookline_on, hookline_on);
    hookline_on++;
    if (dwg_dynapi_entity_set_value (leader, "LEADER", "hookline_on", &hookline_on, 0)
        && hookline_on == leader->hookline_on)
      pass ();
    else
      fail ("LEADER.hookline_on [B] set+1 " FORMAT_B " != " FORMAT_B "", leader->hookline_on, hookline_on);
    leader->hookline_on--;
  }
  {
    BITCODE_3DPOINT inspt_offset;
    if (dwg_dynapi_entity_value (leader, "LEADER", "inspt_offset", &inspt_offset, NULL)
        && !memcmp (&inspt_offset, &leader->inspt_offset, sizeof (BITCODE_3DPOINT)))
        pass ();
    else
        fail ("LEADER.inspt_offset [3DPOINT]");
  }
  {
    BITCODE_BL num_points;
    if (dwg_dynapi_entity_value (leader, "LEADER", "num_points", &num_points, NULL)
        && num_points == leader->num_points)
      pass ();
    else
      fail ("LEADER.num_points [BL] %u != %u", leader->num_points, num_points);
    num_points++;
    if (dwg_dynapi_entity_set_value (leader, "LEADER", "num_points", &num_points, 0)
        && num_points == leader->num_points)
      pass ();
    else
      fail ("LEADER.num_points [BL] set+1 %u != %u", leader->num_points, num_points);
    leader->num_points--;
  }
  {
    BITCODE_3DPOINT origin;
    if (dwg_dynapi_entity_value (leader, "LEADER", "origin", &origin, NULL)
        && !memcmp (&origin, &leader->origin, sizeof (BITCODE_3DPOINT)))
        pass ();
    else
        fail ("LEADER.origin [3DPOINT]");
  }
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value (leader, "LEADER", "parent", &parent, NULL)
        && !memcmp (&parent, &leader->parent, sizeof (struct _dwg_object_entity*)))
        pass ();
    else
        fail ("LEADER.parent [struct _dwg_object_entity*]");
  }
  {
    BITCODE_BS path_type;
    if (dwg_dynapi_entity_value (leader, "LEADER", "path_type", &path_type, NULL)
        && path_type == leader->path_type)
      pass ();
    else
      fail ("LEADER.path_type [BS] %hu != %hu", leader->path_type, path_type);
    path_type++;
    if (dwg_dynapi_entity_set_value (leader, "LEADER", "path_type", &path_type, 0)
        && path_type == leader->path_type)
      pass ();
    else
      fail ("LEADER.path_type [BS] set+1 %hu != %hu", leader->path_type, path_type);
    leader->path_type--;
  }
  {
    BITCODE_3DPOINT* points;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (leader, "LEADER", "num_points", &count, NULL)
        && dwg_dynapi_entity_value (leader, "LEADER", "points", &points, NULL)
        && points == leader->points)
      pass ();
    else
      fail ("LEADER.points [3DPOINT*] * %u num_points", count);
  }
  {
    BITCODE_B unknown_bit_1;
    if (dwg_dynapi_entity_value (leader, "LEADER", "unknown_bit_1", &unknown_bit_1, NULL)
        && unknown_bit_1 == leader->unknown_bit_1)
      pass ();
    else
      fail ("LEADER.unknown_bit_1 [B] " FORMAT_B " != " FORMAT_B "", leader->unknown_bit_1, unknown_bit_1);
    unknown_bit_1++;
    if (dwg_dynapi_entity_set_value (leader, "LEADER", "unknown_bit_1", &unknown_bit_1, 0)
        && unknown_bit_1 == leader->unknown_bit_1)
      pass ();
    else
      fail ("LEADER.unknown_bit_1 [B] set+1 " FORMAT_B " != " FORMAT_B "", leader->unknown_bit_1, unknown_bit_1);
    leader->unknown_bit_1--;
  }
  {
    BITCODE_B unknown_bit_2;
    if (dwg_dynapi_entity_value (leader, "LEADER", "unknown_bit_2", &unknown_bit_2, NULL)
        && unknown_bit_2 == leader->unknown_bit_2)
      pass ();
    else
      fail ("LEADER.unknown_bit_2 [B] " FORMAT_B " != " FORMAT_B "", leader->unknown_bit_2, unknown_bit_2);
    unknown_bit_2++;
    if (dwg_dynapi_entity_set_value (leader, "LEADER", "unknown_bit_2", &unknown_bit_2, 0)
        && unknown_bit_2 == leader->unknown_bit_2)
      pass ();
    else
      fail ("LEADER.unknown_bit_2 [B] set+1 " FORMAT_B " != " FORMAT_B "", leader->unknown_bit_2, unknown_bit_2);
    leader->unknown_bit_2--;
  }
  {
    BITCODE_B unknown_bit_3;
    if (dwg_dynapi_entity_value (leader, "LEADER", "unknown_bit_3", &unknown_bit_3, NULL)
        && unknown_bit_3 == leader->unknown_bit_3)
      pass ();
    else
      fail ("LEADER.unknown_bit_3 [B] " FORMAT_B " != " FORMAT_B "", leader->unknown_bit_3, unknown_bit_3);
    unknown_bit_3++;
    if (dwg_dynapi_entity_set_value (leader, "LEADER", "unknown_bit_3", &unknown_bit_3, 0)
        && unknown_bit_3 == leader->unknown_bit_3)
      pass ();
    else
      fail ("LEADER.unknown_bit_3 [B] set+1 " FORMAT_B " != " FORMAT_B "", leader->unknown_bit_3, unknown_bit_3);
    leader->unknown_bit_3--;
  }
  {
    BITCODE_B unknown_bit_5;
    if (dwg_dynapi_entity_value (leader, "LEADER", "unknown_bit_5", &unknown_bit_5, NULL)
        && unknown_bit_5 == leader->unknown_bit_5)
      pass ();
    else
      fail ("LEADER.unknown_bit_5 [B] " FORMAT_B " != " FORMAT_B "", leader->unknown_bit_5, unknown_bit_5);
    unknown_bit_5++;
    if (dwg_dynapi_entity_set_value (leader, "LEADER", "unknown_bit_5", &unknown_bit_5, 0)
        && unknown_bit_5 == leader->unknown_bit_5)
      pass ();
    else
      fail ("LEADER.unknown_bit_5 [B] set+1 " FORMAT_B " != " FORMAT_B "", leader->unknown_bit_5, unknown_bit_5);
    leader->unknown_bit_5--;
  }
  {
    BITCODE_BS unknown_short_1;
    if (dwg_dynapi_entity_value (leader, "LEADER", "unknown_short_1", &unknown_short_1, NULL)
        && unknown_short_1 == leader->unknown_short_1)
      pass ();
    else
      fail ("LEADER.unknown_short_1 [BS] %hu != %hu", leader->unknown_short_1, unknown_short_1);
    unknown_short_1++;
    if (dwg_dynapi_entity_set_value (leader, "LEADER", "unknown_short_1", &unknown_short_1, 0)
        && unknown_short_1 == leader->unknown_short_1)
      pass ();
    else
      fail ("LEADER.unknown_short_1 [BS] set+1 %hu != %hu", leader->unknown_short_1, unknown_short_1);
    leader->unknown_short_1--;
  }
  {
    BITCODE_3DPOINT x_direction;
    if (dwg_dynapi_entity_value (leader, "LEADER", "x_direction", &x_direction, NULL)
        && !memcmp (&x_direction, &leader->x_direction, sizeof (BITCODE_3DPOINT)))
        pass ();
    else
        fail ("LEADER.x_direction [3DPOINT]");
  }
  if (failed && (is_class_unstable ("LEADER") || is_class_debugging ("LEADER")))
    {
      ok ("%s failed %d tests (TODO unstable)", "LEADER", failed);
      failed = 0;
    }
  return failed;
}
static int test_LIGHT (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_LIGHT *restrict light = obj->tio.entity->tio.LIGHT;
  failed = 0;
  {
    BITCODE_BD attenuation_end_limit;
    if (dwg_dynapi_entity_value (light, "LIGHT", "attenuation_end_limit", &attenuation_end_limit, NULL)
        && attenuation_end_limit == light->attenuation_end_limit)
      pass ();
    else
      fail ("LIGHT.attenuation_end_limit [BD] %g != %g", light->attenuation_end_limit, attenuation_end_limit);
    attenuation_end_limit++;
    if (dwg_dynapi_entity_set_value (light, "LIGHT", "attenuation_end_limit", &attenuation_end_limit, 0)
        && attenuation_end_limit == light->attenuation_end_limit)
      pass ();
    else
      fail ("LIGHT.attenuation_end_limit [BD] set+1 %g != %g", light->attenuation_end_limit, attenuation_end_limit);
    light->attenuation_end_limit--;
  }
  {
    BITCODE_BD attenuation_start_limit;
    if (dwg_dynapi_entity_value (light, "LIGHT", "attenuation_start_limit", &attenuation_start_limit, NULL)
        && attenuation_start_limit == light->attenuation_start_limit)
      pass ();
    else
      fail ("LIGHT.attenuation_start_limit [BD] %g != %g", light->attenuation_start_limit, attenuation_start_limit);
    attenuation_start_limit++;
    if (dwg_dynapi_entity_set_value (light, "LIGHT", "attenuation_start_limit", &attenuation_start_limit, 0)
        && attenuation_start_limit == light->attenuation_start_limit)
      pass ();
    else
      fail ("LIGHT.attenuation_start_limit [BD] set+1 %g != %g", light->attenuation_start_limit, attenuation_start_limit);
    light->attenuation_start_limit--;
  }
  {
    BITCODE_BL attenuation_type;
    if (dwg_dynapi_entity_value (light, "LIGHT", "attenuation_type", &attenuation_type, NULL)
        && attenuation_type == light->attenuation_type)
      pass ();
    else
      fail ("LIGHT.attenuation_type [BL] %u != %u", light->attenuation_type, attenuation_type);
    attenuation_type++;
    if (dwg_dynapi_entity_set_value (light, "LIGHT", "attenuation_type", &attenuation_type, 0)
        && attenuation_type == light->attenuation_type)
      pass ();
    else
      fail ("LIGHT.attenuation_type [BL] set+1 %u != %u", light->attenuation_type, attenuation_type);
    light->attenuation_type--;
  }
  {
    BITCODE_B cast_shadows;
    if (dwg_dynapi_entity_value (light, "LIGHT", "cast_shadows", &cast_shadows, NULL)
        && cast_shadows == light->cast_shadows)
      pass ();
    else
      fail ("LIGHT.cast_shadows [B] " FORMAT_B " != " FORMAT_B "", light->cast_shadows, cast_shadows);
    cast_shadows++;
    if (dwg_dynapi_entity_set_value (light, "LIGHT", "cast_shadows", &cast_shadows, 0)
        && cast_shadows == light->cast_shadows)
      pass ();
    else
      fail ("LIGHT.cast_shadows [B] set+1 " FORMAT_B " != " FORMAT_B "", light->cast_shadows, cast_shadows);
    light->cast_shadows--;
  }
  {
    BITCODE_BL class_version;
    if (dwg_dynapi_entity_value (light, "LIGHT", "class_version", &class_version, NULL)
        && class_version == light->class_version)
      pass ();
    else
      fail ("LIGHT.class_version [BL] %u != %u", light->class_version, class_version);
    class_version++;
    if (dwg_dynapi_entity_set_value (light, "LIGHT", "class_version", &class_version, 0)
        && class_version == light->class_version)
      pass ();
    else
      fail ("LIGHT.class_version [BL] set+1 %u != %u", light->class_version, class_version);
    light->class_version--;
  }
  {
    BITCODE_CMC color;
    if (dwg_dynapi_entity_value (light, "LIGHT", "color", &color, NULL)
        && !memcmp (&color, &light->color, sizeof (BITCODE_CMC)))
        pass ();
    else
        fail ("LIGHT.color [CMC]");
  }
  {
    BITCODE_BD extlight_length;
    if (dwg_dynapi_entity_value (light, "LIGHT", "extlight_length", &extlight_length, NULL)
        && extlight_length == light->extlight_length)
      pass ();
    else
      fail ("LIGHT.extlight_length [BD] %g != %g", light->extlight_length, extlight_length);
    extlight_length++;
    if (dwg_dynapi_entity_set_value (light, "LIGHT", "extlight_length", &extlight_length, 0)
        && extlight_length == light->extlight_length)
      pass ();
    else
      fail ("LIGHT.extlight_length [BD] set+1 %g != %g", light->extlight_length, extlight_length);
    light->extlight_length--;
  }
  {
    BITCODE_BD extlight_radius;
    if (dwg_dynapi_entity_value (light, "LIGHT", "extlight_radius", &extlight_radius, NULL)
        && extlight_radius == light->extlight_radius)
      pass ();
    else
      fail ("LIGHT.extlight_radius [BD] %g != %g", light->extlight_radius, extlight_radius);
    extlight_radius++;
    if (dwg_dynapi_entity_set_value (light, "LIGHT", "extlight_radius", &extlight_radius, 0)
        && extlight_radius == light->extlight_radius)
      pass ();
    else
      fail ("LIGHT.extlight_radius [BD] set+1 %g != %g", light->extlight_radius, extlight_radius);
    light->extlight_radius--;
  }
  {
    BITCODE_BS extlight_shape;
    if (dwg_dynapi_entity_value (light, "LIGHT", "extlight_shape", &extlight_shape, NULL)
        && extlight_shape == light->extlight_shape)
      pass ();
    else
      fail ("LIGHT.extlight_shape [BS] %hu != %hu", light->extlight_shape, extlight_shape);
    extlight_shape++;
    if (dwg_dynapi_entity_set_value (light, "LIGHT", "extlight_shape", &extlight_shape, 0)
        && extlight_shape == light->extlight_shape)
      pass ();
    else
      fail ("LIGHT.extlight_shape [BS] set+1 %hu != %hu", light->extlight_shape, extlight_shape);
    light->extlight_shape--;
  }
  {
    BITCODE_BD extlight_width;
    if (dwg_dynapi_entity_value (light, "LIGHT", "extlight_width", &extlight_width, NULL)
        && extlight_width == light->extlight_width)
      pass ();
    else
      fail ("LIGHT.extlight_width [BD] %g != %g", light->extlight_width, extlight_width);
    extlight_width++;
    if (dwg_dynapi_entity_set_value (light, "LIGHT", "extlight_width", &extlight_width, 0)
        && extlight_width == light->extlight_width)
      pass ();
    else
      fail ("LIGHT.extlight_width [BD] set+1 %g != %g", light->extlight_width, extlight_width);
    light->extlight_width--;
  }
  {
    BITCODE_BD falloff_angle;
    if (dwg_dynapi_entity_value (light, "LIGHT", "falloff_angle", &falloff_angle, NULL)
        && falloff_angle == light->falloff_angle)
      pass ();
    else
      fail ("LIGHT.falloff_angle [BD] %g != %g", light->falloff_angle, falloff_angle);
    falloff_angle++;
    if (dwg_dynapi_entity_set_value (light, "LIGHT", "falloff_angle", &falloff_angle, 0)
        && falloff_angle == light->falloff_angle)
      pass ();
    else
      fail ("LIGHT.falloff_angle [BD] set+1 %g != %g", light->falloff_angle, falloff_angle);
    light->falloff_angle--;
  }
  {
    BITCODE_BS glyph_display_type;
    if (dwg_dynapi_entity_value (light, "LIGHT", "glyph_display_type", &glyph_display_type, NULL)
        && glyph_display_type == light->glyph_display_type)
      pass ();
    else
      fail ("LIGHT.glyph_display_type [BS] %hu != %hu", light->glyph_display_type, glyph_display_type);
    glyph_display_type++;
    if (dwg_dynapi_entity_set_value (light, "LIGHT", "glyph_display_type", &glyph_display_type, 0)
        && glyph_display_type == light->glyph_display_type)
      pass ();
    else
      fail ("LIGHT.glyph_display_type [BS] set+1 %hu != %hu", light->glyph_display_type, glyph_display_type);
    light->glyph_display_type--;
  }
  {
    BITCODE_B has_photometric_data;
    if (dwg_dynapi_entity_value (light, "LIGHT", "has_photometric_data", &has_photometric_data, NULL)
        && has_photometric_data == light->has_photometric_data)
      pass ();
    else
      fail ("LIGHT.has_photometric_data [B] " FORMAT_B " != " FORMAT_B "", light->has_photometric_data, has_photometric_data);
    has_photometric_data++;
    if (dwg_dynapi_entity_set_value (light, "LIGHT", "has_photometric_data", &has_photometric_data, 0)
        && has_photometric_data == light->has_photometric_data)
      pass ();
    else
      fail ("LIGHT.has_photometric_data [B] set+1 " FORMAT_B " != " FORMAT_B "", light->has_photometric_data, has_photometric_data);
    light->has_photometric_data--;
  }
  {
    BITCODE_BS has_target_grip;
    if (dwg_dynapi_entity_value (light, "LIGHT", "has_target_grip", &has_target_grip, NULL)
        && has_target_grip == light->has_target_grip)
      pass ();
    else
      fail ("LIGHT.has_target_grip [BS] %hu != %hu", light->has_target_grip, has_target_grip);
    has_target_grip++;
    if (dwg_dynapi_entity_set_value (light, "LIGHT", "has_target_grip", &has_target_grip, 0)
        && has_target_grip == light->has_target_grip)
      pass ();
    else
      fail ("LIGHT.has_target_grip [BS] set+1 %hu != %hu", light->has_target_grip, has_target_grip);
    light->has_target_grip--;
  }
  {
    BITCODE_B has_webfile;
    if (dwg_dynapi_entity_value (light, "LIGHT", "has_webfile", &has_webfile, NULL)
        && has_webfile == light->has_webfile)
      pass ();
    else
      fail ("LIGHT.has_webfile [B] " FORMAT_B " != " FORMAT_B "", light->has_webfile, has_webfile);
    has_webfile++;
    if (dwg_dynapi_entity_set_value (light, "LIGHT", "has_webfile", &has_webfile, 0)
        && has_webfile == light->has_webfile)
      pass ();
    else
      fail ("LIGHT.has_webfile [B] set+1 " FORMAT_B " != " FORMAT_B "", light->has_webfile, has_webfile);
    light->has_webfile--;
  }
  {
    BITCODE_BD hotspot_angle;
    if (dwg_dynapi_entity_value (light, "LIGHT", "hotspot_angle", &hotspot_angle, NULL)
        && hotspot_angle == light->hotspot_angle)
      pass ();
    else
      fail ("LIGHT.hotspot_angle [BD] %g != %g", light->hotspot_angle, hotspot_angle);
    hotspot_angle++;
    if (dwg_dynapi_entity_set_value (light, "LIGHT", "hotspot_angle", &hotspot_angle, 0)
        && hotspot_angle == light->hotspot_angle)
      pass ();
    else
      fail ("LIGHT.hotspot_angle [BD] set+1 %g != %g", light->hotspot_angle, hotspot_angle);
    light->hotspot_angle--;
  }
  {
    BITCODE_BD illuminance_dist;
    if (dwg_dynapi_entity_value (light, "LIGHT", "illuminance_dist", &illuminance_dist, NULL)
        && illuminance_dist == light->illuminance_dist)
      pass ();
    else
      fail ("LIGHT.illuminance_dist [BD] %g != %g", light->illuminance_dist, illuminance_dist);
    illuminance_dist++;
    if (dwg_dynapi_entity_set_value (light, "LIGHT", "illuminance_dist", &illuminance_dist, 0)
        && illuminance_dist == light->illuminance_dist)
      pass ();
    else
      fail ("LIGHT.illuminance_dist [BD] set+1 %g != %g", light->illuminance_dist, illuminance_dist);
    light->illuminance_dist--;
  }
  {
    BITCODE_BD intensity;
    if (dwg_dynapi_entity_value (light, "LIGHT", "intensity", &intensity, NULL)
        && intensity == light->intensity)
      pass ();
    else
      fail ("LIGHT.intensity [BD] %g != %g", light->intensity, intensity);
    intensity++;
    if (dwg_dynapi_entity_set_value (light, "LIGHT", "intensity", &intensity, 0)
        && intensity == light->intensity)
      pass ();
    else
      fail ("LIGHT.intensity [BD] set+1 %g != %g", light->intensity, intensity);
    light->intensity--;
  }
  {
    BITCODE_B is_photometric;
    if (dwg_dynapi_entity_value (light, "LIGHT", "is_photometric", &is_photometric, NULL)
        && is_photometric == light->is_photometric)
      pass ();
    else
      fail ("LIGHT.is_photometric [B] " FORMAT_B " != " FORMAT_B "", light->is_photometric, is_photometric);
    is_photometric++;
    if (dwg_dynapi_entity_set_value (light, "LIGHT", "is_photometric", &is_photometric, 0)
        && is_photometric == light->is_photometric)
      pass ();
    else
      fail ("LIGHT.is_photometric [B] set+1 " FORMAT_B " != " FORMAT_B "", light->is_photometric, is_photometric);
    light->is_photometric--;
  }
  {
    BITCODE_BS lamp_color_preset;
    if (dwg_dynapi_entity_value (light, "LIGHT", "lamp_color_preset", &lamp_color_preset, NULL)
        && lamp_color_preset == light->lamp_color_preset)
      pass ();
    else
      fail ("LIGHT.lamp_color_preset [BS] %hu != %hu", light->lamp_color_preset, lamp_color_preset);
    lamp_color_preset++;
    if (dwg_dynapi_entity_set_value (light, "LIGHT", "lamp_color_preset", &lamp_color_preset, 0)
        && lamp_color_preset == light->lamp_color_preset)
      pass ();
    else
      fail ("LIGHT.lamp_color_preset [BS] set+1 %hu != %hu", light->lamp_color_preset, lamp_color_preset);
    light->lamp_color_preset--;
  }
  {
    BITCODE_BL lamp_color_rgb;
    if (dwg_dynapi_entity_value (light, "LIGHT", "lamp_color_rgb", &lamp_color_rgb, NULL)
        && lamp_color_rgb == light->lamp_color_rgb)
      pass ();
    else
      fail ("LIGHT.lamp_color_rgb [BL] %u != %u", light->lamp_color_rgb, lamp_color_rgb);
    lamp_color_rgb++;
    if (dwg_dynapi_entity_set_value (light, "LIGHT", "lamp_color_rgb", &lamp_color_rgb, 0)
        && lamp_color_rgb == light->lamp_color_rgb)
      pass ();
    else
      fail ("LIGHT.lamp_color_rgb [BL] set+1 %u != %u", light->lamp_color_rgb, lamp_color_rgb);
    light->lamp_color_rgb--;
  }
  {
    BITCODE_BD lamp_color_temp;
    if (dwg_dynapi_entity_value (light, "LIGHT", "lamp_color_temp", &lamp_color_temp, NULL)
        && lamp_color_temp == light->lamp_color_temp)
      pass ();
    else
      fail ("LIGHT.lamp_color_temp [BD] %g != %g", light->lamp_color_temp, lamp_color_temp);
    lamp_color_temp++;
    if (dwg_dynapi_entity_set_value (light, "LIGHT", "lamp_color_temp", &lamp_color_temp, 0)
        && lamp_color_temp == light->lamp_color_temp)
      pass ();
    else
      fail ("LIGHT.lamp_color_temp [BD] set+1 %g != %g", light->lamp_color_temp, lamp_color_temp);
    light->lamp_color_temp--;
  }
  {
    BITCODE_BS lamp_color_type;
    if (dwg_dynapi_entity_value (light, "LIGHT", "lamp_color_type", &lamp_color_type, NULL)
        && lamp_color_type == light->lamp_color_type)
      pass ();
    else
      fail ("LIGHT.lamp_color_type [BS] %hu != %hu", light->lamp_color_type, lamp_color_type);
    lamp_color_type++;
    if (dwg_dynapi_entity_set_value (light, "LIGHT", "lamp_color_type", &lamp_color_type, 0)
        && lamp_color_type == light->lamp_color_type)
      pass ();
    else
      fail ("LIGHT.lamp_color_type [BS] set+1 %hu != %hu", light->lamp_color_type, lamp_color_type);
    light->lamp_color_type--;
  }
  {
    BITCODE_T name;
    if (dwg_dynapi_entity_value (light, "LIGHT", "name", &name, NULL)
        && name
           ? strEQ ((char *)name, (char *)light->name)
           : !light->name)
      pass ();
    else
      fail ("LIGHT.name [T] '%s' <> '%s'", name, light->name);
  }
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value (light, "LIGHT", "parent", &parent, NULL)
        && !memcmp (&parent, &light->parent, sizeof (struct _dwg_object_entity*)))
        pass ();
    else
        fail ("LIGHT.parent [struct _dwg_object_entity*]");
  }
  {
    BITCODE_BD physical_intensity;
    if (dwg_dynapi_entity_value (light, "LIGHT", "physical_intensity", &physical_intensity, NULL)
        && physical_intensity == light->physical_intensity)
      pass ();
    else
      fail ("LIGHT.physical_intensity [BD] %g != %g", light->physical_intensity, physical_intensity);
    physical_intensity++;
    if (dwg_dynapi_entity_set_value (light, "LIGHT", "physical_intensity", &physical_intensity, 0)
        && physical_intensity == light->physical_intensity)
      pass ();
    else
      fail ("LIGHT.physical_intensity [BD] set+1 %g != %g", light->physical_intensity, physical_intensity);
    light->physical_intensity--;
  }
  {
    BITCODE_BS physical_intensity_method;
    if (dwg_dynapi_entity_value (light, "LIGHT", "physical_intensity_method", &physical_intensity_method, NULL)
        && physical_intensity_method == light->physical_intensity_method)
      pass ();
    else
      fail ("LIGHT.physical_intensity_method [BS] %hu != %hu", light->physical_intensity_method, physical_intensity_method);
    physical_intensity_method++;
    if (dwg_dynapi_entity_set_value (light, "LIGHT", "physical_intensity_method", &physical_intensity_method, 0)
        && physical_intensity_method == light->physical_intensity_method)
      pass ();
    else
      fail ("LIGHT.physical_intensity_method [BS] set+1 %hu != %hu", light->physical_intensity_method, physical_intensity_method);
    light->physical_intensity_method--;
  }
  {
    BITCODE_B plot_glyph;
    if (dwg_dynapi_entity_value (light, "LIGHT", "plot_glyph", &plot_glyph, NULL)
        && plot_glyph == light->plot_glyph)
      pass ();
    else
      fail ("LIGHT.plot_glyph [B] " FORMAT_B " != " FORMAT_B "", light->plot_glyph, plot_glyph);
    plot_glyph++;
    if (dwg_dynapi_entity_set_value (light, "LIGHT", "plot_glyph", &plot_glyph, 0)
        && plot_glyph == light->plot_glyph)
      pass ();
    else
      fail ("LIGHT.plot_glyph [B] set+1 " FORMAT_B " != " FORMAT_B "", light->plot_glyph, plot_glyph);
    light->plot_glyph--;
  }
  {
    BITCODE_3BD position;
    if (dwg_dynapi_entity_value (light, "LIGHT", "position", &position, NULL)
        && !memcmp (&position, &light->position, sizeof (BITCODE_3BD)))
        pass ();
    else
        fail ("LIGHT.position [3BD]");
  }
  {
    BITCODE_BS shadow_map_size;
    if (dwg_dynapi_entity_value (light, "LIGHT", "shadow_map_size", &shadow_map_size, NULL)
        && shadow_map_size == light->shadow_map_size)
      pass ();
    else
      fail ("LIGHT.shadow_map_size [BS] %hu != %hu", light->shadow_map_size, shadow_map_size);
    shadow_map_size++;
    if (dwg_dynapi_entity_set_value (light, "LIGHT", "shadow_map_size", &shadow_map_size, 0)
        && shadow_map_size == light->shadow_map_size)
      pass ();
    else
      fail ("LIGHT.shadow_map_size [BS] set+1 %hu != %hu", light->shadow_map_size, shadow_map_size);
    light->shadow_map_size--;
  }
  {
    BITCODE_RC shadow_map_softness;
    if (dwg_dynapi_entity_value (light, "LIGHT", "shadow_map_softness", &shadow_map_softness, NULL)
        && shadow_map_softness == light->shadow_map_softness)
      pass ();
    else
      fail ("LIGHT.shadow_map_softness [RC] %u != %u", light->shadow_map_softness, shadow_map_softness);
    shadow_map_softness++;
    if (dwg_dynapi_entity_set_value (light, "LIGHT", "shadow_map_softness", &shadow_map_softness, 0)
        && shadow_map_softness == light->shadow_map_softness)
      pass ();
    else
      fail ("LIGHT.shadow_map_softness [RC] set+1 %u != %u", light->shadow_map_softness, shadow_map_softness);
    light->shadow_map_softness--;
  }
  {
    BITCODE_BL shadow_type;
    if (dwg_dynapi_entity_value (light, "LIGHT", "shadow_type", &shadow_type, NULL)
        && shadow_type == light->shadow_type)
      pass ();
    else
      fail ("LIGHT.shadow_type [BL] %u != %u", light->shadow_type, shadow_type);
    shadow_type++;
    if (dwg_dynapi_entity_set_value (light, "LIGHT", "shadow_type", &shadow_type, 0)
        && shadow_type == light->shadow_type)
      pass ();
    else
      fail ("LIGHT.shadow_type [BL] set+1 %u != %u", light->shadow_type, shadow_type);
    light->shadow_type--;
  }
  {
    BITCODE_B status;
    if (dwg_dynapi_entity_value (light, "LIGHT", "status", &status, NULL)
        && status == light->status)
      pass ();
    else
      fail ("LIGHT.status [B] " FORMAT_B " != " FORMAT_B "", light->status, status);
    status++;
    if (dwg_dynapi_entity_set_value (light, "LIGHT", "status", &status, 0)
        && status == light->status)
      pass ();
    else
      fail ("LIGHT.status [B] set+1 " FORMAT_B " != " FORMAT_B "", light->status, status);
    light->status--;
  }
  {
    BITCODE_3BD target;
    if (dwg_dynapi_entity_value (light, "LIGHT", "target", &target, NULL)
        && !memcmp (&target, &light->target, sizeof (BITCODE_3BD)))
        pass ();
    else
        fail ("LIGHT.target [3BD]");
  }
  {
    BITCODE_BL type;
    if (dwg_dynapi_entity_value (light, "LIGHT", "type", &type, NULL)
        && type == light->type)
      pass ();
    else
      fail ("LIGHT.type [BL] %u != %u", light->type, type);
    type++;
    if (dwg_dynapi_entity_set_value (light, "LIGHT", "type", &type, 0)
        && type == light->type)
      pass ();
    else
      fail ("LIGHT.type [BL] set+1 %u != %u", light->type, type);
    light->type--;
  }
  {
    BITCODE_B use_attenuation_limits;
    if (dwg_dynapi_entity_value (light, "LIGHT", "use_attenuation_limits", &use_attenuation_limits, NULL)
        && use_attenuation_limits == light->use_attenuation_limits)
      pass ();
    else
      fail ("LIGHT.use_attenuation_limits [B] " FORMAT_B " != " FORMAT_B "", light->use_attenuation_limits, use_attenuation_limits);
    use_attenuation_limits++;
    if (dwg_dynapi_entity_set_value (light, "LIGHT", "use_attenuation_limits", &use_attenuation_limits, 0)
        && use_attenuation_limits == light->use_attenuation_limits)
      pass ();
    else
      fail ("LIGHT.use_attenuation_limits [B] set+1 " FORMAT_B " != " FORMAT_B "", light->use_attenuation_limits, use_attenuation_limits);
    light->use_attenuation_limits--;
  }
  {
    BITCODE_BD web_angle1;
    if (dwg_dynapi_entity_value (light, "LIGHT", "web_angle1", &web_angle1, NULL)
        && web_angle1 == light->web_angle1)
      pass ();
    else
      fail ("LIGHT.web_angle1 [BD] %g != %g", light->web_angle1, web_angle1);
    web_angle1++;
    if (dwg_dynapi_entity_set_value (light, "LIGHT", "web_angle1", &web_angle1, 0)
        && web_angle1 == light->web_angle1)
      pass ();
    else
      fail ("LIGHT.web_angle1 [BD] set+1 %g != %g", light->web_angle1, web_angle1);
    light->web_angle1--;
  }
  {
    BITCODE_BD web_angle2;
    if (dwg_dynapi_entity_value (light, "LIGHT", "web_angle2", &web_angle2, NULL)
        && web_angle2 == light->web_angle2)
      pass ();
    else
      fail ("LIGHT.web_angle2 [BD] %g != %g", light->web_angle2, web_angle2);
    web_angle2++;
    if (dwg_dynapi_entity_set_value (light, "LIGHT", "web_angle2", &web_angle2, 0)
        && web_angle2 == light->web_angle2)
      pass ();
    else
      fail ("LIGHT.web_angle2 [BD] set+1 %g != %g", light->web_angle2, web_angle2);
    light->web_angle2--;
  }
  {
    BITCODE_BD web_angle3;
    if (dwg_dynapi_entity_value (light, "LIGHT", "web_angle3", &web_angle3, NULL)
        && web_angle3 == light->web_angle3)
      pass ();
    else
      fail ("LIGHT.web_angle3 [BD] %g != %g", light->web_angle3, web_angle3);
    web_angle3++;
    if (dwg_dynapi_entity_set_value (light, "LIGHT", "web_angle3", &web_angle3, 0)
        && web_angle3 == light->web_angle3)
      pass ();
    else
      fail ("LIGHT.web_angle3 [BD] set+1 %g != %g", light->web_angle3, web_angle3);
    light->web_angle3--;
  }
  {
    BITCODE_BD web_angle4;
    if (dwg_dynapi_entity_value (light, "LIGHT", "web_angle4", &web_angle4, NULL)
        && web_angle4 == light->web_angle4)
      pass ();
    else
      fail ("LIGHT.web_angle4 [BD] %g != %g", light->web_angle4, web_angle4);
    web_angle4++;
    if (dwg_dynapi_entity_set_value (light, "LIGHT", "web_angle4", &web_angle4, 0)
        && web_angle4 == light->web_angle4)
      pass ();
    else
      fail ("LIGHT.web_angle4 [BD] set+1 %g != %g", light->web_angle4, web_angle4);
    light->web_angle4--;
  }
  {
    BITCODE_BD web_angle5;
    if (dwg_dynapi_entity_value (light, "LIGHT", "web_angle5", &web_angle5, NULL)
        && web_angle5 == light->web_angle5)
      pass ();
    else
      fail ("LIGHT.web_angle5 [BD] %g != %g", light->web_angle5, web_angle5);
    web_angle5++;
    if (dwg_dynapi_entity_set_value (light, "LIGHT", "web_angle5", &web_angle5, 0)
        && web_angle5 == light->web_angle5)
      pass ();
    else
      fail ("LIGHT.web_angle5 [BD] set+1 %g != %g", light->web_angle5, web_angle5);
    light->web_angle5--;
  }
  {
    BITCODE_BD web_flux;
    if (dwg_dynapi_entity_value (light, "LIGHT", "web_flux", &web_flux, NULL)
        && web_flux == light->web_flux)
      pass ();
    else
      fail ("LIGHT.web_flux [BD] %g != %g", light->web_flux, web_flux);
    web_flux++;
    if (dwg_dynapi_entity_set_value (light, "LIGHT", "web_flux", &web_flux, 0)
        && web_flux == light->web_flux)
      pass ();
    else
      fail ("LIGHT.web_flux [BD] set+1 %g != %g", light->web_flux, web_flux);
    light->web_flux--;
  }
  {
    BITCODE_3BD web_rotation;
    if (dwg_dynapi_entity_value (light, "LIGHT", "web_rotation", &web_rotation, NULL)
        && !memcmp (&web_rotation, &light->web_rotation, sizeof (BITCODE_3BD)))
        pass ();
    else
        fail ("LIGHT.web_rotation [3BD_1]");
  }
  {
    BITCODE_BS web_symetry;
    if (dwg_dynapi_entity_value (light, "LIGHT", "web_symetry", &web_symetry, NULL)
        && web_symetry == light->web_symetry)
      pass ();
    else
      fail ("LIGHT.web_symetry [BS] %hu != %hu", light->web_symetry, web_symetry);
    web_symetry++;
    if (dwg_dynapi_entity_set_value (light, "LIGHT", "web_symetry", &web_symetry, 0)
        && web_symetry == light->web_symetry)
      pass ();
    else
      fail ("LIGHT.web_symetry [BS] set+1 %hu != %hu", light->web_symetry, web_symetry);
    light->web_symetry--;
  }
  {
    BITCODE_T webfile;
    if (dwg_dynapi_entity_value (light, "LIGHT", "webfile", &webfile, NULL)
        && webfile
           ? strEQ ((char *)webfile, (char *)light->webfile)
           : !light->webfile)
      pass ();
    else
      fail ("LIGHT.webfile [T] '%s' <> '%s'", webfile, light->webfile);
  }
  {
    BITCODE_BS webfile_type;
    if (dwg_dynapi_entity_value (light, "LIGHT", "webfile_type", &webfile_type, NULL)
        && webfile_type == light->webfile_type)
      pass ();
    else
      fail ("LIGHT.webfile_type [BS] %hu != %hu", light->webfile_type, webfile_type);
    webfile_type++;
    if (dwg_dynapi_entity_set_value (light, "LIGHT", "webfile_type", &webfile_type, 0)
        && webfile_type == light->webfile_type)
      pass ();
    else
      fail ("LIGHT.webfile_type [BS] set+1 %hu != %hu", light->webfile_type, webfile_type);
    light->webfile_type--;
  }
  if (failed && (is_class_unstable ("LIGHT") || is_class_debugging ("LIGHT")))
    {
      ok ("%s failed %d tests (TODO unstable)", "LIGHT", failed);
      failed = 0;
    }
  return failed;
}
static int test_LINE (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_LINE *restrict line = obj->tio.entity->tio.LINE;
  failed = 0;
  {
    BITCODE_3BD end;
    if (dwg_dynapi_entity_value (line, "LINE", "end", &end, NULL)
        && !memcmp (&end, &line->end, sizeof (BITCODE_3BD)))
        pass ();
    else
        fail ("LINE.end [3BD]");
  }
  {
    BITCODE_BE extrusion;
    if (dwg_dynapi_entity_value (line, "LINE", "extrusion", &extrusion, NULL)
        && !memcmp (&extrusion, &line->extrusion, sizeof (BITCODE_BE)))
        pass ();
    else
        fail ("LINE.extrusion [BE]");
  }
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value (line, "LINE", "parent", &parent, NULL)
        && !memcmp (&parent, &line->parent, sizeof (struct _dwg_object_entity*)))
        pass ();
    else
        fail ("LINE.parent [struct _dwg_object_entity*]");
  }
  {
    BITCODE_3BD start;
    if (dwg_dynapi_entity_value (line, "LINE", "start", &start, NULL)
        && !memcmp (&start, &line->start, sizeof (BITCODE_3BD)))
        pass ();
    else
        fail ("LINE.start [3BD]");
  }
  {
    BITCODE_BT thickness;
    if (dwg_dynapi_entity_value (line, "LINE", "thickness", &thickness, NULL)
        && thickness == line->thickness)
      pass ();
    else
      fail ("LINE.thickness [BT] " FORMAT_BT " != " FORMAT_BT "", line->thickness, thickness);
    if (dwg_dynapi_entity_set_value (line, "LINE", "thickness", &thickness, 0)
        && thickness == line->thickness)
      pass ();
    else
      fail ("LINE.thickness [BT] set+1 " FORMAT_BT " != " FORMAT_BT "", line->thickness, thickness);
    line->thickness--;
  }
  {
    BITCODE_RC z_is_zero;
    if (dwg_dynapi_entity_value (line, "LINE", "z_is_zero", &z_is_zero, NULL)
        && z_is_zero == line->z_is_zero)
      pass ();
    else
      fail ("LINE.z_is_zero [RC] %u != %u", line->z_is_zero, z_is_zero);
    z_is_zero++;
    if (dwg_dynapi_entity_set_value (line, "LINE", "z_is_zero", &z_is_zero, 0)
        && z_is_zero == line->z_is_zero)
      pass ();
    else
      fail ("LINE.z_is_zero [RC] set+1 %u != %u", line->z_is_zero, z_is_zero);
    line->z_is_zero--;
  }
  if (failed && (is_class_unstable ("LINE") || is_class_debugging ("LINE")))
    {
      ok ("%s failed %d tests (TODO unstable)", "LINE", failed);
      failed = 0;
    }
  return failed;
}
static int test_LINEARPARAMETERENTITY (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_LINEARPARAMETERENTITY *restrict linearparameterentity = obj->tio.entity->tio.LINEARPARAMETERENTITY;
  failed = 0;
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value (linearparameterentity, "LINEARPARAMETERENTITY", "parent", &parent, NULL)
        && !memcmp (&parent, &linearparameterentity->parent, sizeof (struct _dwg_object_entity*)))
        pass ();
    else
        fail ("LINEARPARAMETERENTITY.parent [struct _dwg_object_entity*]");
  }
  if (failed && (is_class_unstable ("LINEARPARAMETERENTITY") || is_class_debugging ("LINEARPARAMETERENTITY")))
    {
      ok ("%s failed %d tests (TODO unstable)", "LINEARPARAMETERENTITY", failed);
      failed = 0;
    }
  return failed;
}
static int test_LOFTEDSURFACE (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_LOFTEDSURFACE *restrict loftedsurface = obj->tio.entity->tio.LOFTEDSURFACE;
  failed = 0;
  {
    BITCODE_B _dxf_sab_converted;
    if (dwg_dynapi_entity_value (loftedsurface, "LOFTEDSURFACE", "_dxf_sab_converted", &_dxf_sab_converted, NULL)
        && _dxf_sab_converted == loftedsurface->_dxf_sab_converted)
      pass ();
    else
      fail ("LOFTEDSURFACE._dxf_sab_converted [B] " FORMAT_B " != " FORMAT_B "", loftedsurface->_dxf_sab_converted, _dxf_sab_converted);
    _dxf_sab_converted++;
    if (dwg_dynapi_entity_set_value (loftedsurface, "LOFTEDSURFACE", "_dxf_sab_converted", &_dxf_sab_converted, 0)
        && _dxf_sab_converted == loftedsurface->_dxf_sab_converted)
      pass ();
    else
      fail ("LOFTEDSURFACE._dxf_sab_converted [B] set+1 " FORMAT_B " != " FORMAT_B "", loftedsurface->_dxf_sab_converted, _dxf_sab_converted);
    loftedsurface->_dxf_sab_converted--;
  }
  {
    BITCODE_RC* acis_data;
    if (dwg_dynapi_entity_value (loftedsurface, "LOFTEDSURFACE", "acis_data", &acis_data, NULL)
        && acis_data
           ? strEQ ((char *)acis_data, (char *)loftedsurface->acis_data)
           : !loftedsurface->acis_data)
      pass ();
    else
      fail ("LOFTEDSURFACE.acis_data [RC*] '%s' <> '%s'", acis_data, loftedsurface->acis_data);
  }
  {
    BITCODE_B acis_empty;
    if (dwg_dynapi_entity_value (loftedsurface, "LOFTEDSURFACE", "acis_empty", &acis_empty, NULL)
        && acis_empty == loftedsurface->acis_empty)
      pass ();
    else
      fail ("LOFTEDSURFACE.acis_empty [B] " FORMAT_B " != " FORMAT_B "", loftedsurface->acis_empty, acis_empty);
    acis_empty++;
    if (dwg_dynapi_entity_set_value (loftedsurface, "LOFTEDSURFACE", "acis_empty", &acis_empty, 0)
        && acis_empty == loftedsurface->acis_empty)
      pass ();
    else
      fail ("LOFTEDSURFACE.acis_empty [B] set+1 " FORMAT_B " != " FORMAT_B "", loftedsurface->acis_empty, acis_empty);
    loftedsurface->acis_empty--;
  }
  {
    BITCODE_B acis_empty2;
    if (dwg_dynapi_entity_value (loftedsurface, "LOFTEDSURFACE", "acis_empty2", &acis_empty2, NULL)
        && acis_empty2 == loftedsurface->acis_empty2)
      pass ();
    else
      fail ("LOFTEDSURFACE.acis_empty2 [B] " FORMAT_B " != " FORMAT_B "", loftedsurface->acis_empty2, acis_empty2);
    acis_empty2++;
    if (dwg_dynapi_entity_set_value (loftedsurface, "LOFTEDSURFACE", "acis_empty2", &acis_empty2, 0)
        && acis_empty2 == loftedsurface->acis_empty2)
      pass ();
    else
      fail ("LOFTEDSURFACE.acis_empty2 [B] set+1 " FORMAT_B " != " FORMAT_B "", loftedsurface->acis_empty2, acis_empty2);
    loftedsurface->acis_empty2--;
  }
  {
    BITCODE_B acis_empty_bit;
    if (dwg_dynapi_entity_value (loftedsurface, "LOFTEDSURFACE", "acis_empty_bit", &acis_empty_bit, NULL)
        && acis_empty_bit == loftedsurface->acis_empty_bit)
      pass ();
    else
      fail ("LOFTEDSURFACE.acis_empty_bit [B] " FORMAT_B " != " FORMAT_B "", loftedsurface->acis_empty_bit, acis_empty_bit);
    acis_empty_bit++;
    if (dwg_dynapi_entity_set_value (loftedsurface, "LOFTEDSURFACE", "acis_empty_bit", &acis_empty_bit, 0)
        && acis_empty_bit == loftedsurface->acis_empty_bit)
      pass ();
    else
      fail ("LOFTEDSURFACE.acis_empty_bit [B] set+1 " FORMAT_B " != " FORMAT_B "", loftedsurface->acis_empty_bit, acis_empty_bit);
    loftedsurface->acis_empty_bit--;
  }
  {
    BITCODE_B align_direction;
    if (dwg_dynapi_entity_value (loftedsurface, "LOFTEDSURFACE", "align_direction", &align_direction, NULL)
        && align_direction == loftedsurface->align_direction)
      pass ();
    else
      fail ("LOFTEDSURFACE.align_direction [B] " FORMAT_B " != " FORMAT_B "", loftedsurface->align_direction, align_direction);
    align_direction++;
    if (dwg_dynapi_entity_set_value (loftedsurface, "LOFTEDSURFACE", "align_direction", &align_direction, 0)
        && align_direction == loftedsurface->align_direction)
      pass ();
    else
      fail ("LOFTEDSURFACE.align_direction [B] set+1 " FORMAT_B " != " FORMAT_B "", loftedsurface->align_direction, align_direction);
    loftedsurface->align_direction--;
  }
  {
    BITCODE_B arc_length_parameterization;
    if (dwg_dynapi_entity_value (loftedsurface, "LOFTEDSURFACE", "arc_length_parameterization", &arc_length_parameterization, NULL)
        && arc_length_parameterization == loftedsurface->arc_length_parameterization)
      pass ();
    else
      fail ("LOFTEDSURFACE.arc_length_parameterization [B] " FORMAT_B " != " FORMAT_B "", loftedsurface->arc_length_parameterization, arc_length_parameterization);
    arc_length_parameterization++;
    if (dwg_dynapi_entity_set_value (loftedsurface, "LOFTEDSURFACE", "arc_length_parameterization", &arc_length_parameterization, 0)
        && arc_length_parameterization == loftedsurface->arc_length_parameterization)
      pass ();
    else
      fail ("LOFTEDSURFACE.arc_length_parameterization [B] set+1 " FORMAT_B " != " FORMAT_B "", loftedsurface->arc_length_parameterization, arc_length_parameterization);
    loftedsurface->arc_length_parameterization--;
  }
  {
    BITCODE_BL* block_size;
    if (dwg_dynapi_entity_value (loftedsurface, "LOFTEDSURFACE", "block_size", &block_size, NULL)
        && !memcmp (&block_size, &loftedsurface->block_size, sizeof (BITCODE_BL*)))
        pass ();
    else
        fail ("LOFTEDSURFACE.block_size [BL*]");
  }
  {
    BITCODE_B closed_surfaces;
    if (dwg_dynapi_entity_value (loftedsurface, "LOFTEDSURFACE", "closed_surfaces", &closed_surfaces, NULL)
        && closed_surfaces == loftedsurface->closed_surfaces)
      pass ();
    else
      fail ("LOFTEDSURFACE.closed_surfaces [B] " FORMAT_B " != " FORMAT_B "", loftedsurface->closed_surfaces, closed_surfaces);
    closed_surfaces++;
    if (dwg_dynapi_entity_set_value (loftedsurface, "LOFTEDSURFACE", "closed_surfaces", &closed_surfaces, 0)
        && closed_surfaces == loftedsurface->closed_surfaces)
      pass ();
    else
      fail ("LOFTEDSURFACE.closed_surfaces [B] set+1 " FORMAT_B " != " FORMAT_B "", loftedsurface->closed_surfaces, closed_surfaces);
    loftedsurface->closed_surfaces--;
  }
  {
    BITCODE_H* cross_sections;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (loftedsurface, "LOFTEDSURFACE", "num_cross_sections", &count, NULL)
        && dwg_dynapi_entity_value (loftedsurface, "LOFTEDSURFACE", "cross_sections", &cross_sections, NULL)
        && cross_sections == loftedsurface->cross_sections)
      pass ();
    else
      fail ("LOFTEDSURFACE.cross_sections [H*] * %u num_cross_sections", count);
  }
  {
    char ** encr_sat_data;
    if (dwg_dynapi_entity_value (loftedsurface, "LOFTEDSURFACE", "encr_sat_data", &encr_sat_data, NULL)
        && !memcmp (&encr_sat_data, &loftedsurface->encr_sat_data, sizeof (loftedsurface->encr_sat_data)))
      pass ();
    else
      fail ("LOFTEDSURFACE.encr_sat_data [char **]");
  }
  {
    BITCODE_BD end_draft_angle;
    if (dwg_dynapi_entity_value (loftedsurface, "LOFTEDSURFACE", "end_draft_angle", &end_draft_angle, NULL)
        && end_draft_angle == loftedsurface->end_draft_angle)
      pass ();
    else
      fail ("LOFTEDSURFACE.end_draft_angle [BD] %g != %g", loftedsurface->end_draft_angle, end_draft_angle);
    end_draft_angle++;
    if (dwg_dynapi_entity_set_value (loftedsurface, "LOFTEDSURFACE", "end_draft_angle", &end_draft_angle, 0)
        && end_draft_angle == loftedsurface->end_draft_angle)
      pass ();
    else
      fail ("LOFTEDSURFACE.end_draft_angle [BD] set+1 %g != %g", loftedsurface->end_draft_angle, end_draft_angle);
    loftedsurface->end_draft_angle--;
  }
  {
    BITCODE_BD end_draft_magnitude;
    if (dwg_dynapi_entity_value (loftedsurface, "LOFTEDSURFACE", "end_draft_magnitude", &end_draft_magnitude, NULL)
        && end_draft_magnitude == loftedsurface->end_draft_magnitude)
      pass ();
    else
      fail ("LOFTEDSURFACE.end_draft_magnitude [BD] %g != %g", loftedsurface->end_draft_magnitude, end_draft_magnitude);
    end_draft_magnitude++;
    if (dwg_dynapi_entity_set_value (loftedsurface, "LOFTEDSURFACE", "end_draft_magnitude", &end_draft_magnitude, 0)
        && end_draft_magnitude == loftedsurface->end_draft_magnitude)
      pass ();
    else
      fail ("LOFTEDSURFACE.end_draft_magnitude [BD] set+1 %g != %g", loftedsurface->end_draft_magnitude, end_draft_magnitude);
    loftedsurface->end_draft_magnitude--;
  }
  {
    BITCODE_BL end_marker;
    if (dwg_dynapi_entity_value (loftedsurface, "LOFTEDSURFACE", "end_marker", &end_marker, NULL)
        && end_marker == loftedsurface->end_marker)
      pass ();
    else
      fail ("LOFTEDSURFACE.end_marker [BL] %u != %u", loftedsurface->end_marker, end_marker);
    end_marker++;
    if (dwg_dynapi_entity_set_value (loftedsurface, "LOFTEDSURFACE", "end_marker", &end_marker, 0)
        && end_marker == loftedsurface->end_marker)
      pass ();
    else
      fail ("LOFTEDSURFACE.end_marker [BL] set+1 %u != %u", loftedsurface->end_marker, end_marker);
    loftedsurface->end_marker--;
  }
  {
    struct _dwg_entity_3DSOLID* extra_acis_data;
    if (dwg_dynapi_entity_value (loftedsurface, "LOFTEDSURFACE", "extra_acis_data", &extra_acis_data, NULL)
        && !memcmp (&extra_acis_data, &loftedsurface->extra_acis_data, sizeof (struct _dwg_entity_3DSOLID*)))
        pass ();
    else
        fail ("LOFTEDSURFACE.extra_acis_data [struct _dwg_entity_3DSOLID*]");
  }
  {
    BITCODE_H* guide_curves;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (loftedsurface, "LOFTEDSURFACE", "num_guide_curves", &count, NULL)
        && dwg_dynapi_entity_value (loftedsurface, "LOFTEDSURFACE", "guide_curves", &guide_curves, NULL)
        && guide_curves == loftedsurface->guide_curves)
      pass ();
    else
      fail ("LOFTEDSURFACE.guide_curves [H*] * %u num_guide_curves", count);
  }
  {
    BITCODE_B has_revision_guid;
    if (dwg_dynapi_entity_value (loftedsurface, "LOFTEDSURFACE", "has_revision_guid", &has_revision_guid, NULL)
        && has_revision_guid == loftedsurface->has_revision_guid)
      pass ();
    else
      fail ("LOFTEDSURFACE.has_revision_guid [B] " FORMAT_B " != " FORMAT_B "", loftedsurface->has_revision_guid, has_revision_guid);
    has_revision_guid++;
    if (dwg_dynapi_entity_set_value (loftedsurface, "LOFTEDSURFACE", "has_revision_guid", &has_revision_guid, 0)
        && has_revision_guid == loftedsurface->has_revision_guid)
      pass ();
    else
      fail ("LOFTEDSURFACE.has_revision_guid [B] set+1 " FORMAT_B " != " FORMAT_B "", loftedsurface->has_revision_guid, has_revision_guid);
    loftedsurface->has_revision_guid--;
  }
  {
    BITCODE_H history_id;
    if (dwg_dynapi_entity_value (loftedsurface, "LOFTEDSURFACE", "history_id", &history_id, NULL)
        && !memcmp (&history_id, &loftedsurface->history_id, sizeof (BITCODE_H)))
        pass ();
    else
        fail ("LOFTEDSURFACE.history_id [H]");
  }
  {
    BITCODE_B isoline_present;
    if (dwg_dynapi_entity_value (loftedsurface, "LOFTEDSURFACE", "isoline_present", &isoline_present, NULL)
        && isoline_present == loftedsurface->isoline_present)
      pass ();
    else
      fail ("LOFTEDSURFACE.isoline_present [B] " FORMAT_B " != " FORMAT_B "", loftedsurface->isoline_present, isoline_present);
    isoline_present++;
    if (dwg_dynapi_entity_set_value (loftedsurface, "LOFTEDSURFACE", "isoline_present", &isoline_present, 0)
        && isoline_present == loftedsurface->isoline_present)
      pass ();
    else
      fail ("LOFTEDSURFACE.isoline_present [B] set+1 " FORMAT_B " != " FORMAT_B "", loftedsurface->isoline_present, isoline_present);
    loftedsurface->isoline_present--;
  }
  {
    BITCODE_BL isolines;
    if (dwg_dynapi_entity_value (loftedsurface, "LOFTEDSURFACE", "isolines", &isolines, NULL)
        && isolines == loftedsurface->isolines)
      pass ();
    else
      fail ("LOFTEDSURFACE.isolines [BL] %u != %u", loftedsurface->isolines, isolines);
    isolines++;
    if (dwg_dynapi_entity_set_value (loftedsurface, "LOFTEDSURFACE", "isolines", &isolines, 0)
        && isolines == loftedsurface->isolines)
      pass ();
    else
      fail ("LOFTEDSURFACE.isolines [BL] set+1 %u != %u", loftedsurface->isolines, isolines);
    loftedsurface->isolines--;
  }
  {
    BITCODE_BD* loft_entity_transmatrix;
    if (dwg_dynapi_entity_value (loftedsurface, "LOFTEDSURFACE", "loft_entity_transmatrix", &loft_entity_transmatrix, NULL)
        && !memcmp (&loft_entity_transmatrix, &loftedsurface->loft_entity_transmatrix, sizeof (BITCODE_BD*)))
        pass ();
    else
        fail ("LOFTEDSURFACE.loft_entity_transmatrix [BD*]");
  }
  {
    Dwg_3DSOLID_material* materials;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (loftedsurface, "LOFTEDSURFACE", "num_materials", &count, NULL)
        && dwg_dynapi_entity_value (loftedsurface, "LOFTEDSURFACE", "materials", &materials, NULL)
        && materials == loftedsurface->materials)
      pass ();
    else
      fail ("LOFTEDSURFACE.materials [Dwg_3DSOLID_material*] * %u num_materials", count);
  }
  {
    BITCODE_BS modeler_format_version;
    if (dwg_dynapi_entity_value (loftedsurface, "LOFTEDSURFACE", "modeler_format_version", &modeler_format_version, NULL)
        && modeler_format_version == loftedsurface->modeler_format_version)
      pass ();
    else
      fail ("LOFTEDSURFACE.modeler_format_version [BS] %hu != %hu", loftedsurface->modeler_format_version, modeler_format_version);
    modeler_format_version++;
    if (dwg_dynapi_entity_set_value (loftedsurface, "LOFTEDSURFACE", "modeler_format_version", &modeler_format_version, 0)
        && modeler_format_version == loftedsurface->modeler_format_version)
      pass ();
    else
      fail ("LOFTEDSURFACE.modeler_format_version [BS] set+1 %hu != %hu", loftedsurface->modeler_format_version, modeler_format_version);
    loftedsurface->modeler_format_version--;
  }
  {
    BITCODE_B no_twist;
    if (dwg_dynapi_entity_value (loftedsurface, "LOFTEDSURFACE", "no_twist", &no_twist, NULL)
        && no_twist == loftedsurface->no_twist)
      pass ();
    else
      fail ("LOFTEDSURFACE.no_twist [B] " FORMAT_B " != " FORMAT_B "", loftedsurface->no_twist, no_twist);
    no_twist++;
    if (dwg_dynapi_entity_set_value (loftedsurface, "LOFTEDSURFACE", "no_twist", &no_twist, 0)
        && no_twist == loftedsurface->no_twist)
      pass ();
    else
      fail ("LOFTEDSURFACE.no_twist [B] set+1 " FORMAT_B " != " FORMAT_B "", loftedsurface->no_twist, no_twist);
    loftedsurface->no_twist--;
  }
  {
    BITCODE_BL num_blocks;
    if (dwg_dynapi_entity_value (loftedsurface, "LOFTEDSURFACE", "num_blocks", &num_blocks, NULL)
        && num_blocks == loftedsurface->num_blocks)
      pass ();
    else
      fail ("LOFTEDSURFACE.num_blocks [BL] %u != %u", loftedsurface->num_blocks, num_blocks);
    num_blocks++;
    if (dwg_dynapi_entity_set_value (loftedsurface, "LOFTEDSURFACE", "num_blocks", &num_blocks, 0)
        && num_blocks == loftedsurface->num_blocks)
      pass ();
    else
      fail ("LOFTEDSURFACE.num_blocks [BL] set+1 %u != %u", loftedsurface->num_blocks, num_blocks);
    loftedsurface->num_blocks--;
  }
  {
    BITCODE_BS num_cross_sections;
    if (dwg_dynapi_entity_value (loftedsurface, "LOFTEDSURFACE", "num_cross_sections", &num_cross_sections, NULL)
        && num_cross_sections == loftedsurface->num_cross_sections)
      pass ();
    else
      fail ("LOFTEDSURFACE.num_cross_sections [BS] %hu != %hu", loftedsurface->num_cross_sections, num_cross_sections);
    num_cross_sections++;
    if (dwg_dynapi_entity_set_value (loftedsurface, "LOFTEDSURFACE", "num_cross_sections", &num_cross_sections, 0)
        && num_cross_sections == loftedsurface->num_cross_sections)
      pass ();
    else
      fail ("LOFTEDSURFACE.num_cross_sections [BS] set+1 %hu != %hu", loftedsurface->num_cross_sections, num_cross_sections);
    loftedsurface->num_cross_sections--;
  }
  {
    BITCODE_BS num_guide_curves;
    if (dwg_dynapi_entity_value (loftedsurface, "LOFTEDSURFACE", "num_guide_curves", &num_guide_curves, NULL)
        && num_guide_curves == loftedsurface->num_guide_curves)
      pass ();
    else
      fail ("LOFTEDSURFACE.num_guide_curves [BS] %hu != %hu", loftedsurface->num_guide_curves, num_guide_curves);
    num_guide_curves++;
    if (dwg_dynapi_entity_set_value (loftedsurface, "LOFTEDSURFACE", "num_guide_curves", &num_guide_curves, 0)
        && num_guide_curves == loftedsurface->num_guide_curves)
      pass ();
    else
      fail ("LOFTEDSURFACE.num_guide_curves [BS] set+1 %hu != %hu", loftedsurface->num_guide_curves, num_guide_curves);
    loftedsurface->num_guide_curves--;
  }
  {
    BITCODE_BL num_materials;
    if (dwg_dynapi_entity_value (loftedsurface, "LOFTEDSURFACE", "num_materials", &num_materials, NULL)
        && num_materials == loftedsurface->num_materials)
      pass ();
    else
      fail ("LOFTEDSURFACE.num_materials [BL] %u != %u", loftedsurface->num_materials, num_materials);
    num_materials++;
    if (dwg_dynapi_entity_set_value (loftedsurface, "LOFTEDSURFACE", "num_materials", &num_materials, 0)
        && num_materials == loftedsurface->num_materials)
      pass ();
    else
      fail ("LOFTEDSURFACE.num_materials [BL] set+1 %u != %u", loftedsurface->num_materials, num_materials);
    loftedsurface->num_materials--;
  }
  {
    BITCODE_BL num_silhouettes;
    if (dwg_dynapi_entity_value (loftedsurface, "LOFTEDSURFACE", "num_silhouettes", &num_silhouettes, NULL)
        && num_silhouettes == loftedsurface->num_silhouettes)
      pass ();
    else
      fail ("LOFTEDSURFACE.num_silhouettes [BL] %u != %u", loftedsurface->num_silhouettes, num_silhouettes);
    num_silhouettes++;
    if (dwg_dynapi_entity_set_value (loftedsurface, "LOFTEDSURFACE", "num_silhouettes", &num_silhouettes, 0)
        && num_silhouettes == loftedsurface->num_silhouettes)
      pass ();
    else
      fail ("LOFTEDSURFACE.num_silhouettes [BL] set+1 %u != %u", loftedsurface->num_silhouettes, num_silhouettes);
    loftedsurface->num_silhouettes--;
  }
  {
    BITCODE_BL num_wires;
    if (dwg_dynapi_entity_value (loftedsurface, "LOFTEDSURFACE", "num_wires", &num_wires, NULL)
        && num_wires == loftedsurface->num_wires)
      pass ();
    else
      fail ("LOFTEDSURFACE.num_wires [BL] %u != %u", loftedsurface->num_wires, num_wires);
    num_wires++;
    if (dwg_dynapi_entity_set_value (loftedsurface, "LOFTEDSURFACE", "num_wires", &num_wires, 0)
        && num_wires == loftedsurface->num_wires)
      pass ();
    else
      fail ("LOFTEDSURFACE.num_wires [BL] set+1 %u != %u", loftedsurface->num_wires, num_wires);
    loftedsurface->num_wires--;
  }
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value (loftedsurface, "LOFTEDSURFACE", "parent", &parent, NULL)
        && !memcmp (&parent, &loftedsurface->parent, sizeof (struct _dwg_object_entity*)))
        pass ();
    else
        fail ("LOFTEDSURFACE.parent [struct _dwg_object_entity*]");
  }
  {
    BITCODE_H path_curve;
    if (dwg_dynapi_entity_value (loftedsurface, "LOFTEDSURFACE", "path_curve", &path_curve, NULL)
        && !memcmp (&path_curve, &loftedsurface->path_curve, sizeof (BITCODE_H)))
        pass ();
    else
        fail ("LOFTEDSURFACE.path_curve [H]");
  }
  {
    BITCODE_BL plane_normal_lofting_type;
    if (dwg_dynapi_entity_value (loftedsurface, "LOFTEDSURFACE", "plane_normal_lofting_type", &plane_normal_lofting_type, NULL)
        && plane_normal_lofting_type == loftedsurface->plane_normal_lofting_type)
      pass ();
    else
      fail ("LOFTEDSURFACE.plane_normal_lofting_type [BL] %u != %u", loftedsurface->plane_normal_lofting_type, plane_normal_lofting_type);
    plane_normal_lofting_type++;
    if (dwg_dynapi_entity_set_value (loftedsurface, "LOFTEDSURFACE", "plane_normal_lofting_type", &plane_normal_lofting_type, 0)
        && plane_normal_lofting_type == loftedsurface->plane_normal_lofting_type)
      pass ();
    else
      fail ("LOFTEDSURFACE.plane_normal_lofting_type [BL] set+1 %u != %u", loftedsurface->plane_normal_lofting_type, plane_normal_lofting_type);
    loftedsurface->plane_normal_lofting_type--;
  }
  {
    BITCODE_3BD point;
    if (dwg_dynapi_entity_value (loftedsurface, "LOFTEDSURFACE", "point", &point, NULL)
        && !memcmp (&point, &loftedsurface->point, sizeof (BITCODE_3BD)))
        pass ();
    else
        fail ("LOFTEDSURFACE.point [3BD]");
  }
  {
    BITCODE_B point_present;
    if (dwg_dynapi_entity_value (loftedsurface, "LOFTEDSURFACE", "point_present", &point_present, NULL)
        && point_present == loftedsurface->point_present)
      pass ();
    else
      fail ("LOFTEDSURFACE.point_present [B] " FORMAT_B " != " FORMAT_B "", loftedsurface->point_present, point_present);
    point_present++;
    if (dwg_dynapi_entity_set_value (loftedsurface, "LOFTEDSURFACE", "point_present", &point_present, 0)
        && point_present == loftedsurface->point_present)
      pass ();
    else
      fail ("LOFTEDSURFACE.point_present [B] set+1 " FORMAT_B " != " FORMAT_B "", loftedsurface->point_present, point_present);
    loftedsurface->point_present--;
  }
  {
    BITCODE_RC revision_bytes[9];
    if (dwg_dynapi_entity_value (loftedsurface, "LOFTEDSURFACE", "revision_bytes[9]", &revision_bytes, NULL)
        && !memcmp (&revision_bytes, &loftedsurface->revision_bytes, sizeof (BITCODE_RC)))
        pass ();
    else
        fail ("LOFTEDSURFACE.revision_bytes[9] [RC]");
  }
  {
    BITCODE_RC revision_guid[39];
    if (dwg_dynapi_entity_value (loftedsurface, "LOFTEDSURFACE", "revision_guid[39]", &revision_guid, NULL)
        && !memcmp (&revision_guid, &loftedsurface->revision_guid, sizeof (BITCODE_RC)))
        pass ();
    else
        fail ("LOFTEDSURFACE.revision_guid[39] [RC]");
  }
  {
    BITCODE_BL revision_major;
    if (dwg_dynapi_entity_value (loftedsurface, "LOFTEDSURFACE", "revision_major", &revision_major, NULL)
        && revision_major == loftedsurface->revision_major)
      pass ();
    else
      fail ("LOFTEDSURFACE.revision_major [BL] %u != %u", loftedsurface->revision_major, revision_major);
    revision_major++;
    if (dwg_dynapi_entity_set_value (loftedsurface, "LOFTEDSURFACE", "revision_major", &revision_major, 0)
        && revision_major == loftedsurface->revision_major)
      pass ();
    else
      fail ("LOFTEDSURFACE.revision_major [BL] set+1 %u != %u", loftedsurface->revision_major, revision_major);
    loftedsurface->revision_major--;
  }
  {
    BITCODE_BS revision_minor1;
    if (dwg_dynapi_entity_value (loftedsurface, "LOFTEDSURFACE", "revision_minor1", &revision_minor1, NULL)
        && revision_minor1 == loftedsurface->revision_minor1)
      pass ();
    else
      fail ("LOFTEDSURFACE.revision_minor1 [BS] %hu != %hu", loftedsurface->revision_minor1, revision_minor1);
    revision_minor1++;
    if (dwg_dynapi_entity_set_value (loftedsurface, "LOFTEDSURFACE", "revision_minor1", &revision_minor1, 0)
        && revision_minor1 == loftedsurface->revision_minor1)
      pass ();
    else
      fail ("LOFTEDSURFACE.revision_minor1 [BS] set+1 %hu != %hu", loftedsurface->revision_minor1, revision_minor1);
    loftedsurface->revision_minor1--;
  }
  {
    BITCODE_BS revision_minor2;
    if (dwg_dynapi_entity_value (loftedsurface, "LOFTEDSURFACE", "revision_minor2", &revision_minor2, NULL)
        && revision_minor2 == loftedsurface->revision_minor2)
      pass ();
    else
      fail ("LOFTEDSURFACE.revision_minor2 [BS] %hu != %hu", loftedsurface->revision_minor2, revision_minor2);
    revision_minor2++;
    if (dwg_dynapi_entity_set_value (loftedsurface, "LOFTEDSURFACE", "revision_minor2", &revision_minor2, 0)
        && revision_minor2 == loftedsurface->revision_minor2)
      pass ();
    else
      fail ("LOFTEDSURFACE.revision_minor2 [BS] set+1 %hu != %hu", loftedsurface->revision_minor2, revision_minor2);
    loftedsurface->revision_minor2--;
  }
  {
    BITCODE_B ruled_surface;
    if (dwg_dynapi_entity_value (loftedsurface, "LOFTEDSURFACE", "ruled_surface", &ruled_surface, NULL)
        && ruled_surface == loftedsurface->ruled_surface)
      pass ();
    else
      fail ("LOFTEDSURFACE.ruled_surface [B] " FORMAT_B " != " FORMAT_B "", loftedsurface->ruled_surface, ruled_surface);
    ruled_surface++;
    if (dwg_dynapi_entity_set_value (loftedsurface, "LOFTEDSURFACE", "ruled_surface", &ruled_surface, 0)
        && ruled_surface == loftedsurface->ruled_surface)
      pass ();
    else
      fail ("LOFTEDSURFACE.ruled_surface [B] set+1 " FORMAT_B " != " FORMAT_B "", loftedsurface->ruled_surface, ruled_surface);
    loftedsurface->ruled_surface--;
  }
  {
    BITCODE_BL sab_size;
    if (dwg_dynapi_entity_value (loftedsurface, "LOFTEDSURFACE", "sab_size", &sab_size, NULL)
        && sab_size == loftedsurface->sab_size)
      pass ();
    else
      fail ("LOFTEDSURFACE.sab_size [BL] %u != %u", loftedsurface->sab_size, sab_size);
    sab_size++;
    if (dwg_dynapi_entity_set_value (loftedsurface, "LOFTEDSURFACE", "sab_size", &sab_size, 0)
        && sab_size == loftedsurface->sab_size)
      pass ();
    else
      fail ("LOFTEDSURFACE.sab_size [BL] set+1 %u != %u", loftedsurface->sab_size, sab_size);
    loftedsurface->sab_size--;
  }
  {
    Dwg_3DSOLID_silhouette* silhouettes;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (loftedsurface, "LOFTEDSURFACE", "num_silhouettes", &count, NULL)
        && dwg_dynapi_entity_value (loftedsurface, "LOFTEDSURFACE", "silhouettes", &silhouettes, NULL)
        && silhouettes == loftedsurface->silhouettes)
      pass ();
    else
      fail ("LOFTEDSURFACE.silhouettes [Dwg_3DSOLID_silhouette*] * %u num_silhouettes", count);
  }
  {
    BITCODE_B simple_surfaces;
    if (dwg_dynapi_entity_value (loftedsurface, "LOFTEDSURFACE", "simple_surfaces", &simple_surfaces, NULL)
        && simple_surfaces == loftedsurface->simple_surfaces)
      pass ();
    else
      fail ("LOFTEDSURFACE.simple_surfaces [B] " FORMAT_B " != " FORMAT_B "", loftedsurface->simple_surfaces, simple_surfaces);
    simple_surfaces++;
    if (dwg_dynapi_entity_set_value (loftedsurface, "LOFTEDSURFACE", "simple_surfaces", &simple_surfaces, 0)
        && simple_surfaces == loftedsurface->simple_surfaces)
      pass ();
    else
      fail ("LOFTEDSURFACE.simple_surfaces [B] set+1 " FORMAT_B " != " FORMAT_B "", loftedsurface->simple_surfaces, simple_surfaces);
    loftedsurface->simple_surfaces--;
  }
  {
    BITCODE_B solid;
    if (dwg_dynapi_entity_value (loftedsurface, "LOFTEDSURFACE", "solid", &solid, NULL)
        && solid == loftedsurface->solid)
      pass ();
    else
      fail ("LOFTEDSURFACE.solid [B] " FORMAT_B " != " FORMAT_B "", loftedsurface->solid, solid);
    solid++;
    if (dwg_dynapi_entity_set_value (loftedsurface, "LOFTEDSURFACE", "solid", &solid, 0)
        && solid == loftedsurface->solid)
      pass ();
    else
      fail ("LOFTEDSURFACE.solid [B] set+1 " FORMAT_B " != " FORMAT_B "", loftedsurface->solid, solid);
    loftedsurface->solid--;
  }
  {
    BITCODE_BD start_draft_angle;
    if (dwg_dynapi_entity_value (loftedsurface, "LOFTEDSURFACE", "start_draft_angle", &start_draft_angle, NULL)
        && start_draft_angle == loftedsurface->start_draft_angle)
      pass ();
    else
      fail ("LOFTEDSURFACE.start_draft_angle [BD] %g != %g", loftedsurface->start_draft_angle, start_draft_angle);
    start_draft_angle++;
    if (dwg_dynapi_entity_set_value (loftedsurface, "LOFTEDSURFACE", "start_draft_angle", &start_draft_angle, 0)
        && start_draft_angle == loftedsurface->start_draft_angle)
      pass ();
    else
      fail ("LOFTEDSURFACE.start_draft_angle [BD] set+1 %g != %g", loftedsurface->start_draft_angle, start_draft_angle);
    loftedsurface->start_draft_angle--;
  }
  {
    BITCODE_BD start_draft_magnitude;
    if (dwg_dynapi_entity_value (loftedsurface, "LOFTEDSURFACE", "start_draft_magnitude", &start_draft_magnitude, NULL)
        && start_draft_magnitude == loftedsurface->start_draft_magnitude)
      pass ();
    else
      fail ("LOFTEDSURFACE.start_draft_magnitude [BD] %g != %g", loftedsurface->start_draft_magnitude, start_draft_magnitude);
    start_draft_magnitude++;
    if (dwg_dynapi_entity_set_value (loftedsurface, "LOFTEDSURFACE", "start_draft_magnitude", &start_draft_magnitude, 0)
        && start_draft_magnitude == loftedsurface->start_draft_magnitude)
      pass ();
    else
      fail ("LOFTEDSURFACE.start_draft_magnitude [BD] set+1 %g != %g", loftedsurface->start_draft_magnitude, start_draft_magnitude);
    loftedsurface->start_draft_magnitude--;
  }
  {
    BITCODE_BS u_isolines;
    if (dwg_dynapi_entity_value (loftedsurface, "LOFTEDSURFACE", "u_isolines", &u_isolines, NULL)
        && u_isolines == loftedsurface->u_isolines)
      pass ();
    else
      fail ("LOFTEDSURFACE.u_isolines [BS] %hu != %hu", loftedsurface->u_isolines, u_isolines);
    u_isolines++;
    if (dwg_dynapi_entity_set_value (loftedsurface, "LOFTEDSURFACE", "u_isolines", &u_isolines, 0)
        && u_isolines == loftedsurface->u_isolines)
      pass ();
    else
      fail ("LOFTEDSURFACE.u_isolines [BS] set+1 %hu != %hu", loftedsurface->u_isolines, u_isolines);
    loftedsurface->u_isolines--;
  }
  {
    BITCODE_B unknown;
    if (dwg_dynapi_entity_value (loftedsurface, "LOFTEDSURFACE", "unknown", &unknown, NULL)
        && unknown == loftedsurface->unknown)
      pass ();
    else
      fail ("LOFTEDSURFACE.unknown [B] " FORMAT_B " != " FORMAT_B "", loftedsurface->unknown, unknown);
    unknown++;
    if (dwg_dynapi_entity_set_value (loftedsurface, "LOFTEDSURFACE", "unknown", &unknown, 0)
        && unknown == loftedsurface->unknown)
      pass ();
    else
      fail ("LOFTEDSURFACE.unknown [B] set+1 " FORMAT_B " != " FORMAT_B "", loftedsurface->unknown, unknown);
    loftedsurface->unknown--;
  }
  {
    BITCODE_BS v_isolines;
    if (dwg_dynapi_entity_value (loftedsurface, "LOFTEDSURFACE", "v_isolines", &v_isolines, NULL)
        && v_isolines == loftedsurface->v_isolines)
      pass ();
    else
      fail ("LOFTEDSURFACE.v_isolines [BS] %hu != %hu", loftedsurface->v_isolines, v_isolines);
    v_isolines++;
    if (dwg_dynapi_entity_set_value (loftedsurface, "LOFTEDSURFACE", "v_isolines", &v_isolines, 0)
        && v_isolines == loftedsurface->v_isolines)
      pass ();
    else
      fail ("LOFTEDSURFACE.v_isolines [BS] set+1 %hu != %hu", loftedsurface->v_isolines, v_isolines);
    loftedsurface->v_isolines--;
  }
  {
    BITCODE_BS version;
    if (dwg_dynapi_entity_value (loftedsurface, "LOFTEDSURFACE", "version", &version, NULL)
        && version == loftedsurface->version)
      pass ();
    else
      fail ("LOFTEDSURFACE.version [BS] %hu != %hu", loftedsurface->version, version);
    version++;
    if (dwg_dynapi_entity_set_value (loftedsurface, "LOFTEDSURFACE", "version", &version, 0)
        && version == loftedsurface->version)
      pass ();
    else
      fail ("LOFTEDSURFACE.version [BS] set+1 %hu != %hu", loftedsurface->version, version);
    loftedsurface->version--;
  }
  {
    BITCODE_B virtual_guide;
    if (dwg_dynapi_entity_value (loftedsurface, "LOFTEDSURFACE", "virtual_guide", &virtual_guide, NULL)
        && virtual_guide == loftedsurface->virtual_guide)
      pass ();
    else
      fail ("LOFTEDSURFACE.virtual_guide [B] " FORMAT_B " != " FORMAT_B "", loftedsurface->virtual_guide, virtual_guide);
    virtual_guide++;
    if (dwg_dynapi_entity_set_value (loftedsurface, "LOFTEDSURFACE", "virtual_guide", &virtual_guide, 0)
        && virtual_guide == loftedsurface->virtual_guide)
      pass ();
    else
      fail ("LOFTEDSURFACE.virtual_guide [B] set+1 " FORMAT_B " != " FORMAT_B "", loftedsurface->virtual_guide, virtual_guide);
    loftedsurface->virtual_guide--;
  }
  {
    BITCODE_B wireframe_data_present;
    if (dwg_dynapi_entity_value (loftedsurface, "LOFTEDSURFACE", "wireframe_data_present", &wireframe_data_present, NULL)
        && wireframe_data_present == loftedsurface->wireframe_data_present)
      pass ();
    else
      fail ("LOFTEDSURFACE.wireframe_data_present [B] " FORMAT_B " != " FORMAT_B "", loftedsurface->wireframe_data_present, wireframe_data_present);
    wireframe_data_present++;
    if (dwg_dynapi_entity_set_value (loftedsurface, "LOFTEDSURFACE", "wireframe_data_present", &wireframe_data_present, 0)
        && wireframe_data_present == loftedsurface->wireframe_data_present)
      pass ();
    else
      fail ("LOFTEDSURFACE.wireframe_data_present [B] set+1 " FORMAT_B " != " FORMAT_B "", loftedsurface->wireframe_data_present, wireframe_data_present);
    loftedsurface->wireframe_data_present--;
  }
  {
    Dwg_3DSOLID_wire* wires;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (loftedsurface, "LOFTEDSURFACE", "num_wires", &count, NULL)
        && dwg_dynapi_entity_value (loftedsurface, "LOFTEDSURFACE", "wires", &wires, NULL)
        && wires == loftedsurface->wires)
      pass ();
    else
      fail ("LOFTEDSURFACE.wires [Dwg_3DSOLID_wire*] * %u num_wires", count);
  }
  if (failed && (is_class_unstable ("LOFTEDSURFACE") || is_class_debugging ("LOFTEDSURFACE")))
    {
      ok ("%s failed %d tests (TODO unstable)", "LOFTEDSURFACE", failed);
      failed = 0;
    }
  return failed;
}
static int test_LWPOLYLINE (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_LWPOLYLINE *restrict lwpolyline = obj->tio.entity->tio.LWPOLYLINE;
  failed = 0;
  {
    BITCODE_BD* bulges;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (lwpolyline, "LWPOLYLINE", "num_bulges", &count, NULL)
        && dwg_dynapi_entity_value (lwpolyline, "LWPOLYLINE", "bulges", &bulges, NULL)
        && bulges == lwpolyline->bulges)
      pass ();
    else
      fail ("LWPOLYLINE.bulges [BD*] * %u num_bulges", count);
  }
  {
    BITCODE_BD const_width;
    if (dwg_dynapi_entity_value (lwpolyline, "LWPOLYLINE", "const_width", &const_width, NULL)
        && const_width == lwpolyline->const_width)
      pass ();
    else
      fail ("LWPOLYLINE.const_width [BD] %g != %g", lwpolyline->const_width, const_width);
    const_width++;
    if (dwg_dynapi_entity_set_value (lwpolyline, "LWPOLYLINE", "const_width", &const_width, 0)
        && const_width == lwpolyline->const_width)
      pass ();
    else
      fail ("LWPOLYLINE.const_width [BD] set+1 %g != %g", lwpolyline->const_width, const_width);
    lwpolyline->const_width--;
  }
  {
    BITCODE_BD elevation;
    if (dwg_dynapi_entity_value (lwpolyline, "LWPOLYLINE", "elevation", &elevation, NULL)
        && elevation == lwpolyline->elevation)
      pass ();
    else
      fail ("LWPOLYLINE.elevation [BD] %g != %g", lwpolyline->elevation, elevation);
    elevation++;
    if (dwg_dynapi_entity_set_value (lwpolyline, "LWPOLYLINE", "elevation", &elevation, 0)
        && elevation == lwpolyline->elevation)
      pass ();
    else
      fail ("LWPOLYLINE.elevation [BD] set+1 %g != %g", lwpolyline->elevation, elevation);
    lwpolyline->elevation--;
  }
  {
    BITCODE_BE extrusion;
    if (dwg_dynapi_entity_value (lwpolyline, "LWPOLYLINE", "extrusion", &extrusion, NULL)
        && !memcmp (&extrusion, &lwpolyline->extrusion, sizeof (BITCODE_BE)))
        pass ();
    else
        fail ("LWPOLYLINE.extrusion [BE]");
  }
  {
    BITCODE_BS flag;
    if (dwg_dynapi_entity_value (lwpolyline, "LWPOLYLINE", "flag", &flag, NULL)
        && flag == lwpolyline->flag)
      pass ();
    else
      fail ("LWPOLYLINE.flag [BS] %hu != %hu", lwpolyline->flag, flag);
    flag++;
    if (dwg_dynapi_entity_set_value (lwpolyline, "LWPOLYLINE", "flag", &flag, 0)
        && flag == lwpolyline->flag)
      pass ();
    else
      fail ("LWPOLYLINE.flag [BS] set+1 %hu != %hu", lwpolyline->flag, flag);
    lwpolyline->flag--;
  }
  {
    BITCODE_BL num_bulges;
    if (dwg_dynapi_entity_value (lwpolyline, "LWPOLYLINE", "num_bulges", &num_bulges, NULL)
        && num_bulges == lwpolyline->num_bulges)
      pass ();
    else
      fail ("LWPOLYLINE.num_bulges [BL] %u != %u", lwpolyline->num_bulges, num_bulges);
    num_bulges++;
    if (dwg_dynapi_entity_set_value (lwpolyline, "LWPOLYLINE", "num_bulges", &num_bulges, 0)
        && num_bulges == lwpolyline->num_bulges)
      pass ();
    else
      fail ("LWPOLYLINE.num_bulges [BL] set+1 %u != %u", lwpolyline->num_bulges, num_bulges);
    lwpolyline->num_bulges--;
  }
  {
    BITCODE_BL num_points;
    if (dwg_dynapi_entity_value (lwpolyline, "LWPOLYLINE", "num_points", &num_points, NULL)
        && num_points == lwpolyline->num_points)
      pass ();
    else
      fail ("LWPOLYLINE.num_points [BL] %u != %u", lwpolyline->num_points, num_points);
    num_points++;
    if (dwg_dynapi_entity_set_value (lwpolyline, "LWPOLYLINE", "num_points", &num_points, 0)
        && num_points == lwpolyline->num_points)
      pass ();
    else
      fail ("LWPOLYLINE.num_points [BL] set+1 %u != %u", lwpolyline->num_points, num_points);
    lwpolyline->num_points--;
  }
  {
    BITCODE_BL num_vertexids;
    if (dwg_dynapi_entity_value (lwpolyline, "LWPOLYLINE", "num_vertexids", &num_vertexids, NULL)
        && num_vertexids == lwpolyline->num_vertexids)
      pass ();
    else
      fail ("LWPOLYLINE.num_vertexids [BL] %u != %u", lwpolyline->num_vertexids, num_vertexids);
    num_vertexids++;
    if (dwg_dynapi_entity_set_value (lwpolyline, "LWPOLYLINE", "num_vertexids", &num_vertexids, 0)
        && num_vertexids == lwpolyline->num_vertexids)
      pass ();
    else
      fail ("LWPOLYLINE.num_vertexids [BL] set+1 %u != %u", lwpolyline->num_vertexids, num_vertexids);
    lwpolyline->num_vertexids--;
  }
  {
    BITCODE_BL num_widths;
    if (dwg_dynapi_entity_value (lwpolyline, "LWPOLYLINE", "num_widths", &num_widths, NULL)
        && num_widths == lwpolyline->num_widths)
      pass ();
    else
      fail ("LWPOLYLINE.num_widths [BL] %u != %u", lwpolyline->num_widths, num_widths);
    num_widths++;
    if (dwg_dynapi_entity_set_value (lwpolyline, "LWPOLYLINE", "num_widths", &num_widths, 0)
        && num_widths == lwpolyline->num_widths)
      pass ();
    else
      fail ("LWPOLYLINE.num_widths [BL] set+1 %u != %u", lwpolyline->num_widths, num_widths);
    lwpolyline->num_widths--;
  }
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value (lwpolyline, "LWPOLYLINE", "parent", &parent, NULL)
        && !memcmp (&parent, &lwpolyline->parent, sizeof (struct _dwg_object_entity*)))
        pass ();
    else
        fail ("LWPOLYLINE.parent [struct _dwg_object_entity*]");
  }
  {
    BITCODE_2RD* points;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (lwpolyline, "LWPOLYLINE", "num_points", &count, NULL)
        && dwg_dynapi_entity_value (lwpolyline, "LWPOLYLINE", "points", &points, NULL)
        && points == lwpolyline->points)
      pass ();
    else
      fail ("LWPOLYLINE.points [2RD*] * %u num_points", count);
  }
  {
    BITCODE_BD thickness;
    if (dwg_dynapi_entity_value (lwpolyline, "LWPOLYLINE", "thickness", &thickness, NULL)
        && thickness == lwpolyline->thickness)
      pass ();
    else
      fail ("LWPOLYLINE.thickness [BD] %g != %g", lwpolyline->thickness, thickness);
    thickness++;
    if (dwg_dynapi_entity_set_value (lwpolyline, "LWPOLYLINE", "thickness", &thickness, 0)
        && thickness == lwpolyline->thickness)
      pass ();
    else
      fail ("LWPOLYLINE.thickness [BD] set+1 %g != %g", lwpolyline->thickness, thickness);
    lwpolyline->thickness--;
  }
  {
    BITCODE_BL* vertexids;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (lwpolyline, "LWPOLYLINE", "num_vertexids", &count, NULL)
        && dwg_dynapi_entity_value (lwpolyline, "LWPOLYLINE", "vertexids", &vertexids, NULL)
        && vertexids == lwpolyline->vertexids)
      pass ();
    else
      fail ("LWPOLYLINE.vertexids [BL*] * %u num_vertexids", count);
  }
  {
    Dwg_LWPOLYLINE_width* widths;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (lwpolyline, "LWPOLYLINE", "num_widths", &count, NULL)
        && dwg_dynapi_entity_value (lwpolyline, "LWPOLYLINE", "widths", &widths, NULL)
        && widths == lwpolyline->widths)
      pass ();
    else
      fail ("LWPOLYLINE.widths [Dwg_LWPOLYLINE_width*] * %u num_widths", count);
  }
  if (failed && (is_class_unstable ("LWPOLYLINE") || is_class_debugging ("LWPOLYLINE")))
    {
      ok ("%s failed %d tests (TODO unstable)", "LWPOLYLINE", failed);
      failed = 0;
    }
  return failed;
}
static int test_MESH (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_MESH *restrict mesh = obj->tio.entity->tio.MESH;
  failed = 0;
  {
    BITCODE_BD* crease;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (mesh, "MESH", "num_crease", &count, NULL)
        && dwg_dynapi_entity_value (mesh, "MESH", "crease", &crease, NULL)
        && crease == mesh->crease)
      pass ();
    else
      fail ("MESH.crease [BD*] * %u num_crease", count);
  }
  {
    BITCODE_BS dlevel;
    if (dwg_dynapi_entity_value (mesh, "MESH", "dlevel", &dlevel, NULL)
        && dlevel == mesh->dlevel)
      pass ();
    else
      fail ("MESH.dlevel [BS] %hu != %hu", mesh->dlevel, dlevel);
    dlevel++;
    if (dwg_dynapi_entity_set_value (mesh, "MESH", "dlevel", &dlevel, 0)
        && dlevel == mesh->dlevel)
      pass ();
    else
      fail ("MESH.dlevel [BS] set+1 %hu != %hu", mesh->dlevel, dlevel);
    mesh->dlevel--;
  }
  {
    Dwg_MESH_edge* edges;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (mesh, "MESH", "num_edges", &count, NULL)
        && dwg_dynapi_entity_value (mesh, "MESH", "edges", &edges, NULL)
        && edges == mesh->edges)
      pass ();
    else
      fail ("MESH.edges [Dwg_MESH_edge*] * %u num_edges", count);
  }
  {
    BITCODE_BL* faces;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (mesh, "MESH", "num_faces", &count, NULL)
        && dwg_dynapi_entity_value (mesh, "MESH", "faces", &faces, NULL)
        && faces == mesh->faces)
      pass ();
    else
      fail ("MESH.faces [BL*] * %u num_faces", count);
  }
  {
    BITCODE_B is_watertight;
    if (dwg_dynapi_entity_value (mesh, "MESH", "is_watertight", &is_watertight, NULL)
        && is_watertight == mesh->is_watertight)
      pass ();
    else
      fail ("MESH.is_watertight [B] " FORMAT_B " != " FORMAT_B "", mesh->is_watertight, is_watertight);
    is_watertight++;
    if (dwg_dynapi_entity_set_value (mesh, "MESH", "is_watertight", &is_watertight, 0)
        && is_watertight == mesh->is_watertight)
      pass ();
    else
      fail ("MESH.is_watertight [B] set+1 " FORMAT_B " != " FORMAT_B "", mesh->is_watertight, is_watertight);
    mesh->is_watertight--;
  }
  {
    BITCODE_BL num_crease;
    if (dwg_dynapi_entity_value (mesh, "MESH", "num_crease", &num_crease, NULL)
        && num_crease == mesh->num_crease)
      pass ();
    else
      fail ("MESH.num_crease [BL] %u != %u", mesh->num_crease, num_crease);
    num_crease++;
    if (dwg_dynapi_entity_set_value (mesh, "MESH", "num_crease", &num_crease, 0)
        && num_crease == mesh->num_crease)
      pass ();
    else
      fail ("MESH.num_crease [BL] set+1 %u != %u", mesh->num_crease, num_crease);
    mesh->num_crease--;
  }
  {
    BITCODE_BL num_edges;
    if (dwg_dynapi_entity_value (mesh, "MESH", "num_edges", &num_edges, NULL)
        && num_edges == mesh->num_edges)
      pass ();
    else
      fail ("MESH.num_edges [BL] %u != %u", mesh->num_edges, num_edges);
    num_edges++;
    if (dwg_dynapi_entity_set_value (mesh, "MESH", "num_edges", &num_edges, 0)
        && num_edges == mesh->num_edges)
      pass ();
    else
      fail ("MESH.num_edges [BL] set+1 %u != %u", mesh->num_edges, num_edges);
    mesh->num_edges--;
  }
  {
    BITCODE_BL num_faces;
    if (dwg_dynapi_entity_value (mesh, "MESH", "num_faces", &num_faces, NULL)
        && num_faces == mesh->num_faces)
      pass ();
    else
      fail ("MESH.num_faces [BL] %u != %u", mesh->num_faces, num_faces);
    num_faces++;
    if (dwg_dynapi_entity_set_value (mesh, "MESH", "num_faces", &num_faces, 0)
        && num_faces == mesh->num_faces)
      pass ();
    else
      fail ("MESH.num_faces [BL] set+1 %u != %u", mesh->num_faces, num_faces);
    mesh->num_faces--;
  }
  {
    BITCODE_BL num_subdiv_vertex;
    if (dwg_dynapi_entity_value (mesh, "MESH", "num_subdiv_vertex", &num_subdiv_vertex, NULL)
        && num_subdiv_vertex == mesh->num_subdiv_vertex)
      pass ();
    else
      fail ("MESH.num_subdiv_vertex [BL] %u != %u", mesh->num_subdiv_vertex, num_subdiv_vertex);
    num_subdiv_vertex++;
    if (dwg_dynapi_entity_set_value (mesh, "MESH", "num_subdiv_vertex", &num_subdiv_vertex, 0)
        && num_subdiv_vertex == mesh->num_subdiv_vertex)
      pass ();
    else
      fail ("MESH.num_subdiv_vertex [BL] set+1 %u != %u", mesh->num_subdiv_vertex, num_subdiv_vertex);
    mesh->num_subdiv_vertex--;
  }
  {
    BITCODE_BL num_vertex;
    if (dwg_dynapi_entity_value (mesh, "MESH", "num_vertex", &num_vertex, NULL)
        && num_vertex == mesh->num_vertex)
      pass ();
    else
      fail ("MESH.num_vertex [BL] %u != %u", mesh->num_vertex, num_vertex);
    num_vertex++;
    if (dwg_dynapi_entity_set_value (mesh, "MESH", "num_vertex", &num_vertex, 0)
        && num_vertex == mesh->num_vertex)
      pass ();
    else
      fail ("MESH.num_vertex [BL] set+1 %u != %u", mesh->num_vertex, num_vertex);
    mesh->num_vertex--;
  }
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value (mesh, "MESH", "parent", &parent, NULL)
        && !memcmp (&parent, &mesh->parent, sizeof (struct _dwg_object_entity*)))
        pass ();
    else
        fail ("MESH.parent [struct _dwg_object_entity*]");
  }
  {
    BITCODE_3DPOINT* subdiv_vertex;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (mesh, "MESH", "num_subdiv_vertex", &count, NULL)
        && dwg_dynapi_entity_value (mesh, "MESH", "subdiv_vertex", &subdiv_vertex, NULL)
        && subdiv_vertex == mesh->subdiv_vertex)
      pass ();
    else
      fail ("MESH.subdiv_vertex [3DPOINT*] * %u num_subdiv_vertex", count);
  }
  {
    BITCODE_3DPOINT* vertex;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (mesh, "MESH", "num_owned", &count, NULL)
        && dwg_dynapi_entity_value (mesh, "MESH", "vertex", &vertex, NULL)
        && vertex == mesh->vertex)
      pass ();
    else
      fail ("MESH.vertex [3DPOINT*] * %u num_owned", count);
  }
  if (failed && (is_class_unstable ("MESH") || is_class_debugging ("MESH")))
    {
      ok ("%s failed %d tests (TODO unstable)", "MESH", failed);
      failed = 0;
    }
  return failed;
}
static int test_MINSERT (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_MINSERT *restrict minsert = obj->tio.entity->tio.MINSERT;
  failed = 0;
  {
    BITCODE_H* attribs;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (minsert, "MINSERT", "num_owned", &count, NULL)
        && dwg_dynapi_entity_value (minsert, "MINSERT", "attribs", &attribs, NULL)
        && attribs == minsert->attribs)
      pass ();
    else
      fail ("MINSERT.attribs [H*] * %u num_owned", count);
  }
  {
    BITCODE_H block_header;
    if (dwg_dynapi_entity_value (minsert, "MINSERT", "block_header", &block_header, NULL)
        && !memcmp (&block_header, &minsert->block_header, sizeof (BITCODE_H)))
        pass ();
    else
        fail ("MINSERT.block_header [H]");
  }
  {
    BITCODE_BD col_spacing;
    if (dwg_dynapi_entity_value (minsert, "MINSERT", "col_spacing", &col_spacing, NULL)
        && col_spacing == minsert->col_spacing)
      pass ();
    else
      fail ("MINSERT.col_spacing [BD] %g != %g", minsert->col_spacing, col_spacing);
    col_spacing++;
    if (dwg_dynapi_entity_set_value (minsert, "MINSERT", "col_spacing", &col_spacing, 0)
        && col_spacing == minsert->col_spacing)
      pass ();
    else
      fail ("MINSERT.col_spacing [BD] set+1 %g != %g", minsert->col_spacing, col_spacing);
    minsert->col_spacing--;
  }
  {
    BITCODE_BE extrusion;
    if (dwg_dynapi_entity_value (minsert, "MINSERT", "extrusion", &extrusion, NULL)
        && !memcmp (&extrusion, &minsert->extrusion, sizeof (BITCODE_BE)))
        pass ();
    else
        fail ("MINSERT.extrusion [BE]");
  }
  {
    BITCODE_H first_attrib;
    if (dwg_dynapi_entity_value (minsert, "MINSERT", "first_attrib", &first_attrib, NULL)
        && !memcmp (&first_attrib, &minsert->first_attrib, sizeof (BITCODE_H)))
        pass ();
    else
        fail ("MINSERT.first_attrib [H]");
  }
  {
    BITCODE_B has_attribs;
    if (dwg_dynapi_entity_value (minsert, "MINSERT", "has_attribs", &has_attribs, NULL)
        && has_attribs == minsert->has_attribs)
      pass ();
    else
      fail ("MINSERT.has_attribs [B] " FORMAT_B " != " FORMAT_B "", minsert->has_attribs, has_attribs);
    has_attribs++;
    if (dwg_dynapi_entity_set_value (minsert, "MINSERT", "has_attribs", &has_attribs, 0)
        && has_attribs == minsert->has_attribs)
      pass ();
    else
      fail ("MINSERT.has_attribs [B] set+1 " FORMAT_B " != " FORMAT_B "", minsert->has_attribs, has_attribs);
    minsert->has_attribs--;
  }
  {
    BITCODE_3DPOINT ins_pt;
    if (dwg_dynapi_entity_value (minsert, "MINSERT", "ins_pt", &ins_pt, NULL)
        && !memcmp (&ins_pt, &minsert->ins_pt, sizeof (BITCODE_3DPOINT)))
        pass ();
    else
        fail ("MINSERT.ins_pt [3DPOINT]");
  }
  {
    BITCODE_H last_attrib;
    if (dwg_dynapi_entity_value (minsert, "MINSERT", "last_attrib", &last_attrib, NULL)
        && !memcmp (&last_attrib, &minsert->last_attrib, sizeof (BITCODE_H)))
        pass ();
    else
        fail ("MINSERT.last_attrib [H]");
  }
  {
    BITCODE_BS num_cols;
    if (dwg_dynapi_entity_value (minsert, "MINSERT", "num_cols", &num_cols, NULL)
        && num_cols == minsert->num_cols)
      pass ();
    else
      fail ("MINSERT.num_cols [BS] %hu != %hu", minsert->num_cols, num_cols);
    num_cols++;
    if (dwg_dynapi_entity_set_value (minsert, "MINSERT", "num_cols", &num_cols, 0)
        && num_cols == minsert->num_cols)
      pass ();
    else
      fail ("MINSERT.num_cols [BS] set+1 %hu != %hu", minsert->num_cols, num_cols);
    minsert->num_cols--;
  }
  {
    BITCODE_BL num_owned;
    if (dwg_dynapi_entity_value (minsert, "MINSERT", "num_owned", &num_owned, NULL)
        && num_owned == minsert->num_owned)
      pass ();
    else
      fail ("MINSERT.num_owned [BL] %u != %u", minsert->num_owned, num_owned);
    num_owned++;
    if (dwg_dynapi_entity_set_value (minsert, "MINSERT", "num_owned", &num_owned, 0)
        && num_owned == minsert->num_owned)
      pass ();
    else
      fail ("MINSERT.num_owned [BL] set+1 %u != %u", minsert->num_owned, num_owned);
    minsert->num_owned--;
  }
  {
    BITCODE_BS num_rows;
    if (dwg_dynapi_entity_value (minsert, "MINSERT", "num_rows", &num_rows, NULL)
        && num_rows == minsert->num_rows)
      pass ();
    else
      fail ("MINSERT.num_rows [BS] %hu != %hu", minsert->num_rows, num_rows);
    num_rows++;
    if (dwg_dynapi_entity_set_value (minsert, "MINSERT", "num_rows", &num_rows, 0)
        && num_rows == minsert->num_rows)
      pass ();
    else
      fail ("MINSERT.num_rows [BS] set+1 %hu != %hu", minsert->num_rows, num_rows);
    minsert->num_rows--;
  }
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value (minsert, "MINSERT", "parent", &parent, NULL)
        && !memcmp (&parent, &minsert->parent, sizeof (struct _dwg_object_entity*)))
        pass ();
    else
        fail ("MINSERT.parent [struct _dwg_object_entity*]");
  }
  {
    BITCODE_BD rotation;
    if (dwg_dynapi_entity_value (minsert, "MINSERT", "rotation", &rotation, NULL)
        && rotation == minsert->rotation)
      pass ();
    else
      fail ("MINSERT.rotation [BD] %g != %g", minsert->rotation, rotation);
    rotation++;
    if (dwg_dynapi_entity_set_value (minsert, "MINSERT", "rotation", &rotation, 0)
        && rotation == minsert->rotation)
      pass ();
    else
      fail ("MINSERT.rotation [BD] set+1 %g != %g", minsert->rotation, rotation);
    minsert->rotation--;
  }
  {
    BITCODE_BD row_spacing;
    if (dwg_dynapi_entity_value (minsert, "MINSERT", "row_spacing", &row_spacing, NULL)
        && row_spacing == minsert->row_spacing)
      pass ();
    else
      fail ("MINSERT.row_spacing [BD] %g != %g", minsert->row_spacing, row_spacing);
    row_spacing++;
    if (dwg_dynapi_entity_set_value (minsert, "MINSERT", "row_spacing", &row_spacing, 0)
        && row_spacing == minsert->row_spacing)
      pass ();
    else
      fail ("MINSERT.row_spacing [BD] set+1 %g != %g", minsert->row_spacing, row_spacing);
    minsert->row_spacing--;
  }
  {
    BITCODE_3BD scale;
    if (dwg_dynapi_entity_value (minsert, "MINSERT", "scale", &scale, NULL)
        && !memcmp (&scale, &minsert->scale, sizeof (BITCODE_3BD)))
        pass ();
    else
        fail ("MINSERT.scale [3BD_1]");
  }
  {
    BITCODE_BB scale_flag;
    if (dwg_dynapi_entity_value (minsert, "MINSERT", "scale_flag", &scale_flag, NULL)
        && scale_flag == minsert->scale_flag)
      pass ();
    else
      fail ("MINSERT.scale_flag [BB] " FORMAT_BB " != " FORMAT_BB "", minsert->scale_flag, scale_flag);
    scale_flag++;
    if (dwg_dynapi_entity_set_value (minsert, "MINSERT", "scale_flag", &scale_flag, 0)
        && scale_flag == minsert->scale_flag)
      pass ();
    else
      fail ("MINSERT.scale_flag [BB] set+1 " FORMAT_BB " != " FORMAT_BB "", minsert->scale_flag, scale_flag);
    minsert->scale_flag--;
  }
  {
    BITCODE_H seqend;
    if (dwg_dynapi_entity_value (minsert, "MINSERT", "seqend", &seqend, NULL)
        && !memcmp (&seqend, &minsert->seqend, sizeof (BITCODE_H)))
        pass ();
    else
        fail ("MINSERT.seqend [H]");
  }
  if (failed && (is_class_unstable ("MINSERT") || is_class_debugging ("MINSERT")))
    {
      ok ("%s failed %d tests (TODO unstable)", "MINSERT", failed);
      failed = 0;
    }
  return failed;
}
static int test_MLINE (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_MLINE *restrict mline = obj->tio.entity->tio.MLINE;
  failed = 0;
  {
    BITCODE_3BD base_point;
    if (dwg_dynapi_entity_value (mline, "MLINE", "base_point", &base_point, NULL)
        && !memcmp (&base_point, &mline->base_point, sizeof (BITCODE_3BD)))
        pass ();
    else
        fail ("MLINE.base_point [3BD]");
  }
  {
    BITCODE_BE extrusion;
    if (dwg_dynapi_entity_value (mline, "MLINE", "extrusion", &extrusion, NULL)
        && !memcmp (&extrusion, &mline->extrusion, sizeof (BITCODE_BE)))
        pass ();
    else
        fail ("MLINE.extrusion [BE]");
  }
  {
    BITCODE_BS flags;
    if (dwg_dynapi_entity_value (mline, "MLINE", "flags", &flags, NULL)
        && flags == mline->flags)
      pass ();
    else
      fail ("MLINE.flags [BS] %hu != %hu", mline->flags, flags);
    flags++;
    if (dwg_dynapi_entity_set_value (mline, "MLINE", "flags", &flags, 0)
        && flags == mline->flags)
      pass ();
    else
      fail ("MLINE.flags [BS] set+1 %hu != %hu", mline->flags, flags);
    mline->flags--;
  }
  {
    BITCODE_RC justification;
    if (dwg_dynapi_entity_value (mline, "MLINE", "justification", &justification, NULL)
        && justification == mline->justification)
      pass ();
    else
      fail ("MLINE.justification [RC] %u != %u", mline->justification, justification);
    justification++;
    if (dwg_dynapi_entity_set_value (mline, "MLINE", "justification", &justification, 0)
        && justification == mline->justification)
      pass ();
    else
      fail ("MLINE.justification [RC] set+1 %u != %u", mline->justification, justification);
    mline->justification--;
  }
  {
    BITCODE_H mlinestyle;
    if (dwg_dynapi_entity_value (mline, "MLINE", "mlinestyle", &mlinestyle, NULL)
        && !memcmp (&mlinestyle, &mline->mlinestyle, sizeof (BITCODE_H)))
        pass ();
    else
        fail ("MLINE.mlinestyle [H]");
  }
  {
    BITCODE_RC num_lines;
    if (dwg_dynapi_entity_value (mline, "MLINE", "num_lines", &num_lines, NULL)
        && num_lines == mline->num_lines)
      pass ();
    else
      fail ("MLINE.num_lines [RC] %u != %u", mline->num_lines, num_lines);
    num_lines++;
    if (dwg_dynapi_entity_set_value (mline, "MLINE", "num_lines", &num_lines, 0)
        && num_lines == mline->num_lines)
      pass ();
    else
      fail ("MLINE.num_lines [RC] set+1 %u != %u", mline->num_lines, num_lines);
    mline->num_lines--;
  }
  {
    BITCODE_BS num_verts;
    if (dwg_dynapi_entity_value (mline, "MLINE", "num_verts", &num_verts, NULL)
        && num_verts == mline->num_verts)
      pass ();
    else
      fail ("MLINE.num_verts [BS] %hu != %hu", mline->num_verts, num_verts);
    num_verts++;
    if (dwg_dynapi_entity_set_value (mline, "MLINE", "num_verts", &num_verts, 0)
        && num_verts == mline->num_verts)
      pass ();
    else
      fail ("MLINE.num_verts [BS] set+1 %hu != %hu", mline->num_verts, num_verts);
    mline->num_verts--;
  }
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value (mline, "MLINE", "parent", &parent, NULL)
        && !memcmp (&parent, &mline->parent, sizeof (struct _dwg_object_entity*)))
        pass ();
    else
        fail ("MLINE.parent [struct _dwg_object_entity*]");
  }
  {
    BITCODE_BD scale;
    if (dwg_dynapi_entity_value (mline, "MLINE", "scale", &scale, NULL)
        && scale == mline->scale)
      pass ();
    else
      fail ("MLINE.scale [BD] %g != %g", mline->scale, scale);
    scale++;
    if (dwg_dynapi_entity_set_value (mline, "MLINE", "scale", &scale, 0)
        && scale == mline->scale)
      pass ();
    else
      fail ("MLINE.scale [BD] set+1 %g != %g", mline->scale, scale);
    mline->scale--;
  }
  {
    Dwg_MLINE_vertex* verts;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (mline, "MLINE", "num_verts", &count, NULL)
        && dwg_dynapi_entity_value (mline, "MLINE", "verts", &verts, NULL)
        && verts == mline->verts)
      pass ();
    else
      fail ("MLINE.verts [Dwg_MLINE_vertex*] * %u num_verts", count);
  }
  if (failed && (is_class_unstable ("MLINE") || is_class_debugging ("MLINE")))
    {
      ok ("%s failed %d tests (TODO unstable)", "MLINE", failed);
      failed = 0;
    }
  return failed;
}
static int test_MPOLYGON (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_MPOLYGON *restrict mpolygon = obj->tio.entity->tio.MPOLYGON;
  failed = 0;
  {
    BITCODE_BD angle;
    if (dwg_dynapi_entity_value (mpolygon, "MPOLYGON", "angle", &angle, NULL)
        && angle == mpolygon->angle)
      pass ();
    else
      fail ("MPOLYGON.angle [BD] %g != %g", mpolygon->angle, angle);
    angle++;
    if (dwg_dynapi_entity_set_value (mpolygon, "MPOLYGON", "angle", &angle, 0)
        && angle == mpolygon->angle)
      pass ();
    else
      fail ("MPOLYGON.angle [BD] set+1 %g != %g", mpolygon->angle, angle);
    mpolygon->angle--;
  }
  {
    BITCODE_H* boundary_handles;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (mpolygon, "MPOLYGON", "num_boundary_handles", &count, NULL)
        && dwg_dynapi_entity_value (mpolygon, "MPOLYGON", "boundary_handles", &boundary_handles, NULL)
        && boundary_handles == mpolygon->boundary_handles)
      pass ();
    else
      fail ("MPOLYGON.boundary_handles [H*] * %u num_boundary_handles", count);
  }
  {
    BITCODE_CMC color;
    if (dwg_dynapi_entity_value (mpolygon, "MPOLYGON", "color", &color, NULL)
        && !memcmp (&color, &mpolygon->color, sizeof (BITCODE_CMC)))
        pass ();
    else
        fail ("MPOLYGON.color [CMC]");
  }
  {
    Dwg_HATCH_Color* colors;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (mpolygon, "MPOLYGON", "num_colors", &count, NULL)
        && dwg_dynapi_entity_value (mpolygon, "MPOLYGON", "colors", &colors, NULL)
        && colors == mpolygon->colors)
      pass ();
    else
      fail ("MPOLYGON.colors [Dwg_HATCH_Color*] * %u num_colors", count);
  }
  {
    Dwg_HATCH_DefLine* deflines;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (mpolygon, "MPOLYGON", "num_deflines", &count, NULL)
        && dwg_dynapi_entity_value (mpolygon, "MPOLYGON", "deflines", &deflines, NULL)
        && deflines == mpolygon->deflines)
      pass ();
    else
      fail ("MPOLYGON.deflines [Dwg_HATCH_DefLine*] * %u num_deflines", count);
  }
  {
    BITCODE_B double_flag;
    if (dwg_dynapi_entity_value (mpolygon, "MPOLYGON", "double_flag", &double_flag, NULL)
        && double_flag == mpolygon->double_flag)
      pass ();
    else
      fail ("MPOLYGON.double_flag [B] " FORMAT_B " != " FORMAT_B "", mpolygon->double_flag, double_flag);
    double_flag++;
    if (dwg_dynapi_entity_set_value (mpolygon, "MPOLYGON", "double_flag", &double_flag, 0)
        && double_flag == mpolygon->double_flag)
      pass ();
    else
      fail ("MPOLYGON.double_flag [B] set+1 " FORMAT_B " != " FORMAT_B "", mpolygon->double_flag, double_flag);
    mpolygon->double_flag--;
  }
  {
    BITCODE_BD elevation;
    if (dwg_dynapi_entity_value (mpolygon, "MPOLYGON", "elevation", &elevation, NULL)
        && elevation == mpolygon->elevation)
      pass ();
    else
      fail ("MPOLYGON.elevation [BD] %g != %g", mpolygon->elevation, elevation);
    elevation++;
    if (dwg_dynapi_entity_set_value (mpolygon, "MPOLYGON", "elevation", &elevation, 0)
        && elevation == mpolygon->elevation)
      pass ();
    else
      fail ("MPOLYGON.elevation [BD] set+1 %g != %g", mpolygon->elevation, elevation);
    mpolygon->elevation--;
  }
  {
    BITCODE_BE extrusion;
    if (dwg_dynapi_entity_value (mpolygon, "MPOLYGON", "extrusion", &extrusion, NULL)
        && !memcmp (&extrusion, &mpolygon->extrusion, sizeof (BITCODE_BE)))
        pass ();
    else
        fail ("MPOLYGON.extrusion [BE]");
  }
  {
    BITCODE_BD gradient_angle;
    if (dwg_dynapi_entity_value (mpolygon, "MPOLYGON", "gradient_angle", &gradient_angle, NULL)
        && gradient_angle == mpolygon->gradient_angle)
      pass ();
    else
      fail ("MPOLYGON.gradient_angle [BD] %g != %g", mpolygon->gradient_angle, gradient_angle);
    gradient_angle++;
    if (dwg_dynapi_entity_set_value (mpolygon, "MPOLYGON", "gradient_angle", &gradient_angle, 0)
        && gradient_angle == mpolygon->gradient_angle)
      pass ();
    else
      fail ("MPOLYGON.gradient_angle [BD] set+1 %g != %g", mpolygon->gradient_angle, gradient_angle);
    mpolygon->gradient_angle--;
  }
  {
    BITCODE_T gradient_name;
    if (dwg_dynapi_entity_value (mpolygon, "MPOLYGON", "gradient_name", &gradient_name, NULL)
        && gradient_name
           ? strEQ ((char *)gradient_name, (char *)mpolygon->gradient_name)
           : !mpolygon->gradient_name)
      pass ();
    else
      fail ("MPOLYGON.gradient_name [T] '%s' <> '%s'", gradient_name, mpolygon->gradient_name);
  }
  {
    BITCODE_BD gradient_shift;
    if (dwg_dynapi_entity_value (mpolygon, "MPOLYGON", "gradient_shift", &gradient_shift, NULL)
        && gradient_shift == mpolygon->gradient_shift)
      pass ();
    else
      fail ("MPOLYGON.gradient_shift [BD] %g != %g", mpolygon->gradient_shift, gradient_shift);
    gradient_shift++;
    if (dwg_dynapi_entity_set_value (mpolygon, "MPOLYGON", "gradient_shift", &gradient_shift, 0)
        && gradient_shift == mpolygon->gradient_shift)
      pass ();
    else
      fail ("MPOLYGON.gradient_shift [BD] set+1 %g != %g", mpolygon->gradient_shift, gradient_shift);
    mpolygon->gradient_shift--;
  }
  {
    BITCODE_BD gradient_tint;
    if (dwg_dynapi_entity_value (mpolygon, "MPOLYGON", "gradient_tint", &gradient_tint, NULL)
        && gradient_tint == mpolygon->gradient_tint)
      pass ();
    else
      fail ("MPOLYGON.gradient_tint [BD] %g != %g", mpolygon->gradient_tint, gradient_tint);
    gradient_tint++;
    if (dwg_dynapi_entity_set_value (mpolygon, "MPOLYGON", "gradient_tint", &gradient_tint, 0)
        && gradient_tint == mpolygon->gradient_tint)
      pass ();
    else
      fail ("MPOLYGON.gradient_tint [BD] set+1 %g != %g", mpolygon->gradient_tint, gradient_tint);
    mpolygon->gradient_tint--;
  }
  {
    BITCODE_B is_associative;
    if (dwg_dynapi_entity_value (mpolygon, "MPOLYGON", "is_associative", &is_associative, NULL)
        && is_associative == mpolygon->is_associative)
      pass ();
    else
      fail ("MPOLYGON.is_associative [B] " FORMAT_B " != " FORMAT_B "", mpolygon->is_associative, is_associative);
    is_associative++;
    if (dwg_dynapi_entity_set_value (mpolygon, "MPOLYGON", "is_associative", &is_associative, 0)
        && is_associative == mpolygon->is_associative)
      pass ();
    else
      fail ("MPOLYGON.is_associative [B] set+1 " FORMAT_B " != " FORMAT_B "", mpolygon->is_associative, is_associative);
    mpolygon->is_associative--;
  }
  {
    BITCODE_BL is_gradient_fill;
    if (dwg_dynapi_entity_value (mpolygon, "MPOLYGON", "is_gradient_fill", &is_gradient_fill, NULL)
        && is_gradient_fill == mpolygon->is_gradient_fill)
      pass ();
    else
      fail ("MPOLYGON.is_gradient_fill [BL] %u != %u", mpolygon->is_gradient_fill, is_gradient_fill);
    is_gradient_fill++;
    if (dwg_dynapi_entity_set_value (mpolygon, "MPOLYGON", "is_gradient_fill", &is_gradient_fill, 0)
        && is_gradient_fill == mpolygon->is_gradient_fill)
      pass ();
    else
      fail ("MPOLYGON.is_gradient_fill [BL] set+1 %u != %u", mpolygon->is_gradient_fill, is_gradient_fill);
    mpolygon->is_gradient_fill--;
  }
  {
    BITCODE_B is_solid_fill;
    if (dwg_dynapi_entity_value (mpolygon, "MPOLYGON", "is_solid_fill", &is_solid_fill, NULL)
        && is_solid_fill == mpolygon->is_solid_fill)
      pass ();
    else
      fail ("MPOLYGON.is_solid_fill [B] " FORMAT_B " != " FORMAT_B "", mpolygon->is_solid_fill, is_solid_fill);
    is_solid_fill++;
    if (dwg_dynapi_entity_set_value (mpolygon, "MPOLYGON", "is_solid_fill", &is_solid_fill, 0)
        && is_solid_fill == mpolygon->is_solid_fill)
      pass ();
    else
      fail ("MPOLYGON.is_solid_fill [B] set+1 " FORMAT_B " != " FORMAT_B "", mpolygon->is_solid_fill, is_solid_fill);
    mpolygon->is_solid_fill--;
  }
  {
    BITCODE_T name;
    if (dwg_dynapi_entity_value (mpolygon, "MPOLYGON", "name", &name, NULL)
        && name
           ? strEQ ((char *)name, (char *)mpolygon->name)
           : !mpolygon->name)
      pass ();
    else
      fail ("MPOLYGON.name [T] '%s' <> '%s'", name, mpolygon->name);
  }
  {
    BITCODE_BL num_boundary_handles;
    if (dwg_dynapi_entity_value (mpolygon, "MPOLYGON", "num_boundary_handles", &num_boundary_handles, NULL)
        && num_boundary_handles == mpolygon->num_boundary_handles)
      pass ();
    else
      fail ("MPOLYGON.num_boundary_handles [BL] %u != %u", mpolygon->num_boundary_handles, num_boundary_handles);
    num_boundary_handles++;
    if (dwg_dynapi_entity_set_value (mpolygon, "MPOLYGON", "num_boundary_handles", &num_boundary_handles, 0)
        && num_boundary_handles == mpolygon->num_boundary_handles)
      pass ();
    else
      fail ("MPOLYGON.num_boundary_handles [BL] set+1 %u != %u", mpolygon->num_boundary_handles, num_boundary_handles);
    mpolygon->num_boundary_handles--;
  }
  {
    BITCODE_BL num_colors;
    if (dwg_dynapi_entity_value (mpolygon, "MPOLYGON", "num_colors", &num_colors, NULL)
        && num_colors == mpolygon->num_colors)
      pass ();
    else
      fail ("MPOLYGON.num_colors [BL] %u != %u", mpolygon->num_colors, num_colors);
    num_colors++;
    if (dwg_dynapi_entity_set_value (mpolygon, "MPOLYGON", "num_colors", &num_colors, 0)
        && num_colors == mpolygon->num_colors)
      pass ();
    else
      fail ("MPOLYGON.num_colors [BL] set+1 %u != %u", mpolygon->num_colors, num_colors);
    mpolygon->num_colors--;
  }
  {
    BITCODE_BS num_deflines;
    if (dwg_dynapi_entity_value (mpolygon, "MPOLYGON", "num_deflines", &num_deflines, NULL)
        && num_deflines == mpolygon->num_deflines)
      pass ();
    else
      fail ("MPOLYGON.num_deflines [BS] %hu != %hu", mpolygon->num_deflines, num_deflines);
    num_deflines++;
    if (dwg_dynapi_entity_set_value (mpolygon, "MPOLYGON", "num_deflines", &num_deflines, 0)
        && num_deflines == mpolygon->num_deflines)
      pass ();
    else
      fail ("MPOLYGON.num_deflines [BS] set+1 %hu != %hu", mpolygon->num_deflines, num_deflines);
    mpolygon->num_deflines--;
  }
  {
    BITCODE_BL num_paths;
    if (dwg_dynapi_entity_value (mpolygon, "MPOLYGON", "num_paths", &num_paths, NULL)
        && num_paths == mpolygon->num_paths)
      pass ();
    else
      fail ("MPOLYGON.num_paths [BL] %u != %u", mpolygon->num_paths, num_paths);
    num_paths++;
    if (dwg_dynapi_entity_set_value (mpolygon, "MPOLYGON", "num_paths", &num_paths, 0)
        && num_paths == mpolygon->num_paths)
      pass ();
    else
      fail ("MPOLYGON.num_paths [BL] set+1 %u != %u", mpolygon->num_paths, num_paths);
    mpolygon->num_paths--;
  }
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value (mpolygon, "MPOLYGON", "parent", &parent, NULL)
        && !memcmp (&parent, &mpolygon->parent, sizeof (struct _dwg_object_entity*)))
        pass ();
    else
        fail ("MPOLYGON.parent [struct _dwg_object_entity*]");
  }
  {
    Dwg_HATCH_Path* paths;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (mpolygon, "MPOLYGON", "num_paths", &count, NULL)
        && dwg_dynapi_entity_value (mpolygon, "MPOLYGON", "paths", &paths, NULL)
        && paths == mpolygon->paths)
      pass ();
    else
      fail ("MPOLYGON.paths [Dwg_HATCH_Path*] * %u num_paths", count);
  }
  {
    BITCODE_BS pattern_type;
    if (dwg_dynapi_entity_value (mpolygon, "MPOLYGON", "pattern_type", &pattern_type, NULL)
        && pattern_type == mpolygon->pattern_type)
      pass ();
    else
      fail ("MPOLYGON.pattern_type [BS] %hu != %hu", mpolygon->pattern_type, pattern_type);
    pattern_type++;
    if (dwg_dynapi_entity_set_value (mpolygon, "MPOLYGON", "pattern_type", &pattern_type, 0)
        && pattern_type == mpolygon->pattern_type)
      pass ();
    else
      fail ("MPOLYGON.pattern_type [BS] set+1 %hu != %hu", mpolygon->pattern_type, pattern_type);
    mpolygon->pattern_type--;
  }
  {
    BITCODE_BL reserved;
    if (dwg_dynapi_entity_value (mpolygon, "MPOLYGON", "reserved", &reserved, NULL)
        && reserved == mpolygon->reserved)
      pass ();
    else
      fail ("MPOLYGON.reserved [BL] %u != %u", mpolygon->reserved, reserved);
    reserved++;
    if (dwg_dynapi_entity_set_value (mpolygon, "MPOLYGON", "reserved", &reserved, 0)
        && reserved == mpolygon->reserved)
      pass ();
    else
      fail ("MPOLYGON.reserved [BL] set+1 %u != %u", mpolygon->reserved, reserved);
    mpolygon->reserved--;
  }
  {
    BITCODE_BD scale_spacing;
    if (dwg_dynapi_entity_value (mpolygon, "MPOLYGON", "scale_spacing", &scale_spacing, NULL)
        && scale_spacing == mpolygon->scale_spacing)
      pass ();
    else
      fail ("MPOLYGON.scale_spacing [BD] %g != %g", mpolygon->scale_spacing, scale_spacing);
    scale_spacing++;
    if (dwg_dynapi_entity_set_value (mpolygon, "MPOLYGON", "scale_spacing", &scale_spacing, 0)
        && scale_spacing == mpolygon->scale_spacing)
      pass ();
    else
      fail ("MPOLYGON.scale_spacing [BD] set+1 %g != %g", mpolygon->scale_spacing, scale_spacing);
    mpolygon->scale_spacing--;
  }
  {
    BITCODE_BL single_color_gradient;
    if (dwg_dynapi_entity_value (mpolygon, "MPOLYGON", "single_color_gradient", &single_color_gradient, NULL)
        && single_color_gradient == mpolygon->single_color_gradient)
      pass ();
    else
      fail ("MPOLYGON.single_color_gradient [BL] %u != %u", mpolygon->single_color_gradient, single_color_gradient);
    single_color_gradient++;
    if (dwg_dynapi_entity_set_value (mpolygon, "MPOLYGON", "single_color_gradient", &single_color_gradient, 0)
        && single_color_gradient == mpolygon->single_color_gradient)
      pass ();
    else
      fail ("MPOLYGON.single_color_gradient [BL] set+1 %u != %u", mpolygon->single_color_gradient, single_color_gradient);
    mpolygon->single_color_gradient--;
  }
  {
    BITCODE_BS style;
    if (dwg_dynapi_entity_value (mpolygon, "MPOLYGON", "style", &style, NULL)
        && style == mpolygon->style)
      pass ();
    else
      fail ("MPOLYGON.style [BS] %hu != %hu", mpolygon->style, style);
    style++;
    if (dwg_dynapi_entity_set_value (mpolygon, "MPOLYGON", "style", &style, 0)
        && style == mpolygon->style)
      pass ();
    else
      fail ("MPOLYGON.style [BS] set+1 %hu != %hu", mpolygon->style, style);
    mpolygon->style--;
  }
  {
    BITCODE_2RD x_dir;
    if (dwg_dynapi_entity_value (mpolygon, "MPOLYGON", "x_dir", &x_dir, NULL)
        && !memcmp (&x_dir, &mpolygon->x_dir, sizeof (BITCODE_2RD)))
        pass ();
    else
        fail ("MPOLYGON.x_dir [2RD]");
  }
  if (failed && (is_class_unstable ("MPOLYGON") || is_class_debugging ("MPOLYGON")))
    {
      ok ("%s failed %d tests (TODO unstable)", "MPOLYGON", failed);
      failed = 0;
    }
  return failed;
}
static int test_MTEXT (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_MTEXT *restrict mtext = obj->tio.entity->tio.MTEXT;
  failed = 0;
  {
    BITCODE_H appid;
    if (dwg_dynapi_entity_value (mtext, "MTEXT", "appid", &appid, NULL)
        && !memcmp (&appid, &mtext->appid, sizeof (BITCODE_H)))
        pass ();
    else
        fail ("MTEXT.appid [H]");
  }
  {
    BITCODE_BS attachment;
    if (dwg_dynapi_entity_value (mtext, "MTEXT", "attachment", &attachment, NULL)
        && attachment == mtext->attachment)
      pass ();
    else
      fail ("MTEXT.attachment [BS] %hu != %hu", mtext->attachment, attachment);
    attachment++;
    if (dwg_dynapi_entity_set_value (mtext, "MTEXT", "attachment", &attachment, 0)
        && attachment == mtext->attachment)
      pass ();
    else
      fail ("MTEXT.attachment [BS] set+1 %hu != %hu", mtext->attachment, attachment);
    mtext->attachment--;
  }
  {
    BITCODE_B auto_height;
    if (dwg_dynapi_entity_value (mtext, "MTEXT", "auto_height", &auto_height, NULL)
        && auto_height == mtext->auto_height)
      pass ();
    else
      fail ("MTEXT.auto_height [B] " FORMAT_B " != " FORMAT_B "", mtext->auto_height, auto_height);
    auto_height++;
    if (dwg_dynapi_entity_set_value (mtext, "MTEXT", "auto_height", &auto_height, 0)
        && auto_height == mtext->auto_height)
      pass ();
    else
      fail ("MTEXT.auto_height [B] set+1 " FORMAT_B " != " FORMAT_B "", mtext->auto_height, auto_height);
    mtext->auto_height--;
  }
  {
    BITCODE_CMC bg_fill_color;
    if (dwg_dynapi_entity_value (mtext, "MTEXT", "bg_fill_color", &bg_fill_color, NULL)
        && !memcmp (&bg_fill_color, &mtext->bg_fill_color, sizeof (BITCODE_CMC)))
        pass ();
    else
        fail ("MTEXT.bg_fill_color [CMC]");
  }
  {
    BITCODE_BL bg_fill_flag;
    if (dwg_dynapi_entity_value (mtext, "MTEXT", "bg_fill_flag", &bg_fill_flag, NULL)
        && bg_fill_flag == mtext->bg_fill_flag)
      pass ();
    else
      fail ("MTEXT.bg_fill_flag [BL] %u != %u", mtext->bg_fill_flag, bg_fill_flag);
    bg_fill_flag++;
    if (dwg_dynapi_entity_set_value (mtext, "MTEXT", "bg_fill_flag", &bg_fill_flag, 0)
        && bg_fill_flag == mtext->bg_fill_flag)
      pass ();
    else
      fail ("MTEXT.bg_fill_flag [BL] set+1 %u != %u", mtext->bg_fill_flag, bg_fill_flag);
    mtext->bg_fill_flag--;
  }
  {
    BITCODE_BL bg_fill_scale;
    if (dwg_dynapi_entity_value (mtext, "MTEXT", "bg_fill_scale", &bg_fill_scale, NULL)
        && bg_fill_scale == mtext->bg_fill_scale)
      pass ();
    else
      fail ("MTEXT.bg_fill_scale [BL] %u != %u", mtext->bg_fill_scale, bg_fill_scale);
    bg_fill_scale++;
    if (dwg_dynapi_entity_set_value (mtext, "MTEXT", "bg_fill_scale", &bg_fill_scale, 0)
        && bg_fill_scale == mtext->bg_fill_scale)
      pass ();
    else
      fail ("MTEXT.bg_fill_scale [BL] set+1 %u != %u", mtext->bg_fill_scale, bg_fill_scale);
    mtext->bg_fill_scale--;
  }
  {
    BITCODE_BL bg_fill_trans;
    if (dwg_dynapi_entity_value (mtext, "MTEXT", "bg_fill_trans", &bg_fill_trans, NULL)
        && bg_fill_trans == mtext->bg_fill_trans)
      pass ();
    else
      fail ("MTEXT.bg_fill_trans [BL] %u != %u", mtext->bg_fill_trans, bg_fill_trans);
    bg_fill_trans++;
    if (dwg_dynapi_entity_set_value (mtext, "MTEXT", "bg_fill_trans", &bg_fill_trans, 0)
        && bg_fill_trans == mtext->bg_fill_trans)
      pass ();
    else
      fail ("MTEXT.bg_fill_trans [BL] set+1 %u != %u", mtext->bg_fill_trans, bg_fill_trans);
    mtext->bg_fill_trans--;
  }
  {
    BITCODE_BS class_version;
    if (dwg_dynapi_entity_value (mtext, "MTEXT", "class_version", &class_version, NULL)
        && class_version == mtext->class_version)
      pass ();
    else
      fail ("MTEXT.class_version [BS] %hu != %hu", mtext->class_version, class_version);
    class_version++;
    if (dwg_dynapi_entity_set_value (mtext, "MTEXT", "class_version", &class_version, 0)
        && class_version == mtext->class_version)
      pass ();
    else
      fail ("MTEXT.class_version [BS] set+1 %hu != %hu", mtext->class_version, class_version);
    mtext->class_version--;
  }
  {
    BITCODE_BD* column_heights;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (mtext, "MTEXT", "num_column_heights", &count, NULL)
        && dwg_dynapi_entity_value (mtext, "MTEXT", "column_heights", &column_heights, NULL)
        && column_heights == mtext->column_heights)
      pass ();
    else
      fail ("MTEXT.column_heights [BD*] * %u num_column_heights", count);
  }
  {
    BITCODE_BS column_type;
    if (dwg_dynapi_entity_value (mtext, "MTEXT", "column_type", &column_type, NULL)
        && column_type == mtext->column_type)
      pass ();
    else
      fail ("MTEXT.column_type [BS] %hu != %hu", mtext->column_type, column_type);
    column_type++;
    if (dwg_dynapi_entity_set_value (mtext, "MTEXT", "column_type", &column_type, 0)
        && column_type == mtext->column_type)
      pass ();
    else
      fail ("MTEXT.column_type [BS] set+1 %hu != %hu", mtext->column_type, column_type);
    mtext->column_type--;
  }
  {
    BITCODE_BD column_width;
    if (dwg_dynapi_entity_value (mtext, "MTEXT", "column_width", &column_width, NULL)
        && column_width == mtext->column_width)
      pass ();
    else
      fail ("MTEXT.column_width [BD] %g != %g", mtext->column_width, column_width);
    column_width++;
    if (dwg_dynapi_entity_set_value (mtext, "MTEXT", "column_width", &column_width, 0)
        && column_width == mtext->column_width)
      pass ();
    else
      fail ("MTEXT.column_width [BD] set+1 %g != %g", mtext->column_width, column_width);
    mtext->column_width--;
  }
  {
    BITCODE_B default_flag;
    if (dwg_dynapi_entity_value (mtext, "MTEXT", "default_flag", &default_flag, NULL)
        && default_flag == mtext->default_flag)
      pass ();
    else
      fail ("MTEXT.default_flag [B] " FORMAT_B " != " FORMAT_B "", mtext->default_flag, default_flag);
    default_flag++;
    if (dwg_dynapi_entity_set_value (mtext, "MTEXT", "default_flag", &default_flag, 0)
        && default_flag == mtext->default_flag)
      pass ();
    else
      fail ("MTEXT.default_flag [B] set+1 " FORMAT_B " != " FORMAT_B "", mtext->default_flag, default_flag);
    mtext->default_flag--;
  }
  {
    BITCODE_BD extents_height;
    if (dwg_dynapi_entity_value (mtext, "MTEXT", "extents_height", &extents_height, NULL)
        && extents_height == mtext->extents_height)
      pass ();
    else
      fail ("MTEXT.extents_height [BD] %g != %g", mtext->extents_height, extents_height);
    extents_height++;
    if (dwg_dynapi_entity_set_value (mtext, "MTEXT", "extents_height", &extents_height, 0)
        && extents_height == mtext->extents_height)
      pass ();
    else
      fail ("MTEXT.extents_height [BD] set+1 %g != %g", mtext->extents_height, extents_height);
    mtext->extents_height--;
  }
  {
    BITCODE_BD extents_width;
    if (dwg_dynapi_entity_value (mtext, "MTEXT", "extents_width", &extents_width, NULL)
        && extents_width == mtext->extents_width)
      pass ();
    else
      fail ("MTEXT.extents_width [BD] %g != %g", mtext->extents_width, extents_width);
    extents_width++;
    if (dwg_dynapi_entity_set_value (mtext, "MTEXT", "extents_width", &extents_width, 0)
        && extents_width == mtext->extents_width)
      pass ();
    else
      fail ("MTEXT.extents_width [BD] set+1 %g != %g", mtext->extents_width, extents_width);
    mtext->extents_width--;
  }
  {
    BITCODE_BE extrusion;
    if (dwg_dynapi_entity_value (mtext, "MTEXT", "extrusion", &extrusion, NULL)
        && !memcmp (&extrusion, &mtext->extrusion, sizeof (BITCODE_BE)))
        pass ();
    else
        fail ("MTEXT.extrusion [BE]");
  }
  {
    BITCODE_BS flow_dir;
    if (dwg_dynapi_entity_value (mtext, "MTEXT", "flow_dir", &flow_dir, NULL)
        && flow_dir == mtext->flow_dir)
      pass ();
    else
      fail ("MTEXT.flow_dir [BS] %hu != %hu", mtext->flow_dir, flow_dir);
    flow_dir++;
    if (dwg_dynapi_entity_set_value (mtext, "MTEXT", "flow_dir", &flow_dir, 0)
        && flow_dir == mtext->flow_dir)
      pass ();
    else
      fail ("MTEXT.flow_dir [BS] set+1 %hu != %hu", mtext->flow_dir, flow_dir);
    mtext->flow_dir--;
  }
  {
    BITCODE_B flow_reversed;
    if (dwg_dynapi_entity_value (mtext, "MTEXT", "flow_reversed", &flow_reversed, NULL)
        && flow_reversed == mtext->flow_reversed)
      pass ();
    else
      fail ("MTEXT.flow_reversed [B] " FORMAT_B " != " FORMAT_B "", mtext->flow_reversed, flow_reversed);
    flow_reversed++;
    if (dwg_dynapi_entity_set_value (mtext, "MTEXT", "flow_reversed", &flow_reversed, 0)
        && flow_reversed == mtext->flow_reversed)
      pass ();
    else
      fail ("MTEXT.flow_reversed [B] set+1 " FORMAT_B " != " FORMAT_B "", mtext->flow_reversed, flow_reversed);
    mtext->flow_reversed--;
  }
  {
    BITCODE_BD gutter;
    if (dwg_dynapi_entity_value (mtext, "MTEXT", "gutter", &gutter, NULL)
        && gutter == mtext->gutter)
      pass ();
    else
      fail ("MTEXT.gutter [BD] %g != %g", mtext->gutter, gutter);
    gutter++;
    if (dwg_dynapi_entity_set_value (mtext, "MTEXT", "gutter", &gutter, 0)
        && gutter == mtext->gutter)
      pass ();
    else
      fail ("MTEXT.gutter [BD] set+1 %g != %g", mtext->gutter, gutter);
    mtext->gutter--;
  }
  {
    BITCODE_BL ignore_attachment;
    if (dwg_dynapi_entity_value (mtext, "MTEXT", "ignore_attachment", &ignore_attachment, NULL)
        && ignore_attachment == mtext->ignore_attachment)
      pass ();
    else
      fail ("MTEXT.ignore_attachment [BL] %u != %u", mtext->ignore_attachment, ignore_attachment);
    ignore_attachment++;
    if (dwg_dynapi_entity_set_value (mtext, "MTEXT", "ignore_attachment", &ignore_attachment, 0)
        && ignore_attachment == mtext->ignore_attachment)
      pass ();
    else
      fail ("MTEXT.ignore_attachment [BL] set+1 %u != %u", mtext->ignore_attachment, ignore_attachment);
    mtext->ignore_attachment--;
  }
  {
    BITCODE_3BD ins_pt;
    if (dwg_dynapi_entity_value (mtext, "MTEXT", "ins_pt", &ins_pt, NULL)
        && !memcmp (&ins_pt, &mtext->ins_pt, sizeof (BITCODE_3BD)))
        pass ();
    else
        fail ("MTEXT.ins_pt [3BD]");
  }
  {
    BITCODE_B is_not_annotative;
    if (dwg_dynapi_entity_value (mtext, "MTEXT", "is_not_annotative", &is_not_annotative, NULL)
        && is_not_annotative == mtext->is_not_annotative)
      pass ();
    else
      fail ("MTEXT.is_not_annotative [B] " FORMAT_B " != " FORMAT_B "", mtext->is_not_annotative, is_not_annotative);
    is_not_annotative++;
    if (dwg_dynapi_entity_set_value (mtext, "MTEXT", "is_not_annotative", &is_not_annotative, 0)
        && is_not_annotative == mtext->is_not_annotative)
      pass ();
    else
      fail ("MTEXT.is_not_annotative [B] set+1 " FORMAT_B " != " FORMAT_B "", mtext->is_not_annotative, is_not_annotative);
    mtext->is_not_annotative--;
  }
  {
    BITCODE_BD linespace_factor;
    if (dwg_dynapi_entity_value (mtext, "MTEXT", "linespace_factor", &linespace_factor, NULL)
        && linespace_factor == mtext->linespace_factor)
      pass ();
    else
      fail ("MTEXT.linespace_factor [BD] %g != %g", mtext->linespace_factor, linespace_factor);
    linespace_factor++;
    if (dwg_dynapi_entity_set_value (mtext, "MTEXT", "linespace_factor", &linespace_factor, 0)
        && linespace_factor == mtext->linespace_factor)
      pass ();
    else
      fail ("MTEXT.linespace_factor [BD] set+1 %g != %g", mtext->linespace_factor, linespace_factor);
    mtext->linespace_factor--;
  }
  {
    BITCODE_BS linespace_style;
    if (dwg_dynapi_entity_value (mtext, "MTEXT", "linespace_style", &linespace_style, NULL)
        && linespace_style == mtext->linespace_style)
      pass ();
    else
      fail ("MTEXT.linespace_style [BS] %hu != %hu", mtext->linespace_style, linespace_style);
    linespace_style++;
    if (dwg_dynapi_entity_set_value (mtext, "MTEXT", "linespace_style", &linespace_style, 0)
        && linespace_style == mtext->linespace_style)
      pass ();
    else
      fail ("MTEXT.linespace_style [BS] set+1 %hu != %hu", mtext->linespace_style, linespace_style);
    mtext->linespace_style--;
  }
  {
    BITCODE_BL num_column_heights;
    if (dwg_dynapi_entity_value (mtext, "MTEXT", "num_column_heights", &num_column_heights, NULL)
        && num_column_heights == mtext->num_column_heights)
      pass ();
    else
      fail ("MTEXT.num_column_heights [BL] %u != %u", mtext->num_column_heights, num_column_heights);
    num_column_heights++;
    if (dwg_dynapi_entity_set_value (mtext, "MTEXT", "num_column_heights", &num_column_heights, 0)
        && num_column_heights == mtext->num_column_heights)
      pass ();
    else
      fail ("MTEXT.num_column_heights [BL] set+1 %u != %u", mtext->num_column_heights, num_column_heights);
    mtext->num_column_heights--;
  }
  {
    BITCODE_BL numfragments;
    if (dwg_dynapi_entity_value (mtext, "MTEXT", "numfragments", &numfragments, NULL)
        && numfragments == mtext->numfragments)
      pass ();
    else
      fail ("MTEXT.numfragments [BL] %u != %u", mtext->numfragments, numfragments);
    numfragments++;
    if (dwg_dynapi_entity_set_value (mtext, "MTEXT", "numfragments", &numfragments, 0)
        && numfragments == mtext->numfragments)
      pass ();
    else
      fail ("MTEXT.numfragments [BL] set+1 %u != %u", mtext->numfragments, numfragments);
    mtext->numfragments--;
  }
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value (mtext, "MTEXT", "parent", &parent, NULL)
        && !memcmp (&parent, &mtext->parent, sizeof (struct _dwg_object_entity*)))
        pass ();
    else
        fail ("MTEXT.parent [struct _dwg_object_entity*]");
  }
  {
    BITCODE_BD rect_height;
    if (dwg_dynapi_entity_value (mtext, "MTEXT", "rect_height", &rect_height, NULL)
        && rect_height == mtext->rect_height)
      pass ();
    else
      fail ("MTEXT.rect_height [BD] %g != %g", mtext->rect_height, rect_height);
    rect_height++;
    if (dwg_dynapi_entity_set_value (mtext, "MTEXT", "rect_height", &rect_height, 0)
        && rect_height == mtext->rect_height)
      pass ();
    else
      fail ("MTEXT.rect_height [BD] set+1 %g != %g", mtext->rect_height, rect_height);
    mtext->rect_height--;
  }
  {
    BITCODE_BD rect_width;
    if (dwg_dynapi_entity_value (mtext, "MTEXT", "rect_width", &rect_width, NULL)
        && rect_width == mtext->rect_width)
      pass ();
    else
      fail ("MTEXT.rect_width [BD] %g != %g", mtext->rect_width, rect_width);
    rect_width++;
    if (dwg_dynapi_entity_set_value (mtext, "MTEXT", "rect_width", &rect_width, 0)
        && rect_width == mtext->rect_width)
      pass ();
    else
      fail ("MTEXT.rect_width [BD] set+1 %g != %g", mtext->rect_width, rect_width);
    mtext->rect_width--;
  }
  {
    BITCODE_H style;
    if (dwg_dynapi_entity_value (mtext, "MTEXT", "style", &style, NULL)
        && !memcmp (&style, &mtext->style, sizeof (BITCODE_H)))
        pass ();
    else
        fail ("MTEXT.style [H]");
  }
  {
    BITCODE_T text;
    if (dwg_dynapi_entity_value (mtext, "MTEXT", "text", &text, NULL)
        && text
           ? strEQ ((char *)text, (char *)mtext->text)
           : !mtext->text)
      pass ();
    else
      fail ("MTEXT.text [T] '%s' <> '%s'", text, mtext->text);
  }
  {
    BITCODE_BD text_height;
    if (dwg_dynapi_entity_value (mtext, "MTEXT", "text_height", &text_height, NULL)
        && text_height == mtext->text_height)
      pass ();
    else
      fail ("MTEXT.text_height [BD] %g != %g", mtext->text_height, text_height);
    text_height++;
    if (dwg_dynapi_entity_set_value (mtext, "MTEXT", "text_height", &text_height, 0)
        && text_height == mtext->text_height)
      pass ();
    else
      fail ("MTEXT.text_height [BD] set+1 %g != %g", mtext->text_height, text_height);
    mtext->text_height--;
  }
  {
    BITCODE_B unknown_b0;
    if (dwg_dynapi_entity_value (mtext, "MTEXT", "unknown_b0", &unknown_b0, NULL)
        && unknown_b0 == mtext->unknown_b0)
      pass ();
    else
      fail ("MTEXT.unknown_b0 [B] " FORMAT_B " != " FORMAT_B "", mtext->unknown_b0, unknown_b0);
    unknown_b0++;
    if (dwg_dynapi_entity_set_value (mtext, "MTEXT", "unknown_b0", &unknown_b0, 0)
        && unknown_b0 == mtext->unknown_b0)
      pass ();
    else
      fail ("MTEXT.unknown_b0 [B] set+1 " FORMAT_B " != " FORMAT_B "", mtext->unknown_b0, unknown_b0);
    mtext->unknown_b0--;
  }
  {
    BITCODE_3BD x_axis_dir;
    if (dwg_dynapi_entity_value (mtext, "MTEXT", "x_axis_dir", &x_axis_dir, NULL)
        && !memcmp (&x_axis_dir, &mtext->x_axis_dir, sizeof (BITCODE_3BD)))
        pass ();
    else
        fail ("MTEXT.x_axis_dir [3BD]");
  }
  if (failed && (is_class_unstable ("MTEXT") || is_class_debugging ("MTEXT")))
    {
      ok ("%s failed %d tests (TODO unstable)", "MTEXT", failed);
      failed = 0;
    }
  return failed;
}
static int test_MULTILEADER (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_MULTILEADER *restrict multileader = obj->tio.entity->tio.MULTILEADER;
  failed = 0;
  {
    BITCODE_H arrow_handle;
    if (dwg_dynapi_entity_value (multileader, "MULTILEADER", "arrow_handle", &arrow_handle, NULL)
        && !memcmp (&arrow_handle, &multileader->arrow_handle, sizeof (BITCODE_H)))
        pass ();
    else
        fail ("MULTILEADER.arrow_handle [H]");
  }
  {
    BITCODE_BD arrow_size;
    if (dwg_dynapi_entity_value (multileader, "MULTILEADER", "arrow_size", &arrow_size, NULL)
        && arrow_size == multileader->arrow_size)
      pass ();
    else
      fail ("MULTILEADER.arrow_size [BD] %g != %g", multileader->arrow_size, arrow_size);
    arrow_size++;
    if (dwg_dynapi_entity_set_value (multileader, "MULTILEADER", "arrow_size", &arrow_size, 0)
        && arrow_size == multileader->arrow_size)
      pass ();
    else
      fail ("MULTILEADER.arrow_size [BD] set+1 %g != %g", multileader->arrow_size, arrow_size);
    multileader->arrow_size--;
  }
  {
    Dwg_LEADER_ArrowHead* arrowheads;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (multileader, "MULTILEADER", "num_arrowheads", &count, NULL)
        && dwg_dynapi_entity_value (multileader, "MULTILEADER", "arrowheads", &arrowheads, NULL)
        && arrowheads == multileader->arrowheads)
      pass ();
    else
      fail ("MULTILEADER.arrowheads [Dwg_LEADER_ArrowHead*] * %u num_arrowheads", count);
  }
  {
    BITCODE_BS attach_bottom;
    if (dwg_dynapi_entity_value (multileader, "MULTILEADER", "attach_bottom", &attach_bottom, NULL)
        && attach_bottom == multileader->attach_bottom)
      pass ();
    else
      fail ("MULTILEADER.attach_bottom [BS] %hu != %hu", multileader->attach_bottom, attach_bottom);
    attach_bottom++;
    if (dwg_dynapi_entity_set_value (multileader, "MULTILEADER", "attach_bottom", &attach_bottom, 0)
        && attach_bottom == multileader->attach_bottom)
      pass ();
    else
      fail ("MULTILEADER.attach_bottom [BS] set+1 %hu != %hu", multileader->attach_bottom, attach_bottom);
    multileader->attach_bottom--;
  }
  {
    BITCODE_BS attach_dir;
    if (dwg_dynapi_entity_value (multileader, "MULTILEADER", "attach_dir", &attach_dir, NULL)
        && attach_dir == multileader->attach_dir)
      pass ();
    else
      fail ("MULTILEADER.attach_dir [BS] %hu != %hu", multileader->attach_dir, attach_dir);
    attach_dir++;
    if (dwg_dynapi_entity_set_value (multileader, "MULTILEADER", "attach_dir", &attach_dir, 0)
        && attach_dir == multileader->attach_dir)
      pass ();
    else
      fail ("MULTILEADER.attach_dir [BS] set+1 %hu != %hu", multileader->attach_dir, attach_dir);
    multileader->attach_dir--;
  }
  {
    BITCODE_BS attach_top;
    if (dwg_dynapi_entity_value (multileader, "MULTILEADER", "attach_top", &attach_top, NULL)
        && attach_top == multileader->attach_top)
      pass ();
    else
      fail ("MULTILEADER.attach_top [BS] %hu != %hu", multileader->attach_top, attach_top);
    attach_top++;
    if (dwg_dynapi_entity_set_value (multileader, "MULTILEADER", "attach_top", &attach_top, 0)
        && attach_top == multileader->attach_top)
      pass ();
    else
      fail ("MULTILEADER.attach_top [BS] set+1 %hu != %hu", multileader->attach_top, attach_top);
    multileader->attach_top--;
  }
  {
    BITCODE_CMC block_color;
    if (dwg_dynapi_entity_value (multileader, "MULTILEADER", "block_color", &block_color, NULL)
        && !memcmp (&block_color, &multileader->block_color, sizeof (BITCODE_CMC)))
        pass ();
    else
        fail ("MULTILEADER.block_color [CMC]");
  }
  {
    BITCODE_BD block_rotation;
    if (dwg_dynapi_entity_value (multileader, "MULTILEADER", "block_rotation", &block_rotation, NULL)
        && block_rotation == multileader->block_rotation)
      pass ();
    else
      fail ("MULTILEADER.block_rotation [BD] %g != %g", multileader->block_rotation, block_rotation);
    block_rotation++;
    if (dwg_dynapi_entity_set_value (multileader, "MULTILEADER", "block_rotation", &block_rotation, 0)
        && block_rotation == multileader->block_rotation)
      pass ();
    else
      fail ("MULTILEADER.block_rotation [BD] set+1 %g != %g", multileader->block_rotation, block_rotation);
    multileader->block_rotation--;
  }
  {
    BITCODE_3BD block_scale;
    if (dwg_dynapi_entity_value (multileader, "MULTILEADER", "block_scale", &block_scale, NULL)
        && !memcmp (&block_scale, &multileader->block_scale, sizeof (BITCODE_3BD)))
        pass ();
    else
        fail ("MULTILEADER.block_scale [3BD]");
  }
  {
    BITCODE_H block_style;
    if (dwg_dynapi_entity_value (multileader, "MULTILEADER", "block_style", &block_style, NULL)
        && !memcmp (&block_style, &multileader->block_style, sizeof (BITCODE_H)))
        pass ();
    else
        fail ("MULTILEADER.block_style [H]");
  }
  {
    Dwg_LEADER_BlockLabel* blocklabels;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (multileader, "MULTILEADER", "num_blocklabels", &count, NULL)
        && dwg_dynapi_entity_value (multileader, "MULTILEADER", "blocklabels", &blocklabels, NULL)
        && blocklabels == multileader->blocklabels)
      pass ();
    else
      fail ("MULTILEADER.blocklabels [Dwg_LEADER_BlockLabel*] * %u num_blocklabels", count);
  }
  {
    BITCODE_BS class_version;
    if (dwg_dynapi_entity_value (multileader, "MULTILEADER", "class_version", &class_version, NULL)
        && class_version == multileader->class_version)
      pass ();
    else
      fail ("MULTILEADER.class_version [BS] %hu != %hu", multileader->class_version, class_version);
    class_version++;
    if (dwg_dynapi_entity_set_value (multileader, "MULTILEADER", "class_version", &class_version, 0)
        && class_version == multileader->class_version)
      pass ();
    else
      fail ("MULTILEADER.class_version [BS] set+1 %hu != %hu", multileader->class_version, class_version);
    multileader->class_version--;
  }
  {
    BITCODE_CMC color;
    if (dwg_dynapi_entity_value (multileader, "MULTILEADER", "color", &color, NULL)
        && !memcmp (&color, &multileader->color, sizeof (BITCODE_CMC)))
        pass ();
    else
        fail ("MULTILEADER.color [CMC]");
  }
  {
    Dwg_MLEADER_AnnotContext ctx;
    if (dwg_dynapi_entity_value (multileader, "MULTILEADER", "ctx", &ctx, NULL)
        && !memcmp (&ctx, &multileader->ctx, sizeof (Dwg_MLEADER_AnnotContext)))
        pass ();
    else
        fail ("MULTILEADER.ctx [Dwg_MLEADER_AnnotContext]");
  }
  {
    BITCODE_BL flags;
    if (dwg_dynapi_entity_value (multileader, "MULTILEADER", "flags", &flags, NULL)
        && flags == multileader->flags)
      pass ();
    else
      fail ("MULTILEADER.flags [BL] %u != %u", multileader->flags, flags);
    flags++;
    if (dwg_dynapi_entity_set_value (multileader, "MULTILEADER", "flags", &flags, 0)
        && flags == multileader->flags)
      pass ();
    else
      fail ("MULTILEADER.flags [BL] set+1 %u != %u", multileader->flags, flags);
    multileader->flags--;
  }
  {
    BITCODE_B has_dogleg;
    if (dwg_dynapi_entity_value (multileader, "MULTILEADER", "has_dogleg", &has_dogleg, NULL)
        && has_dogleg == multileader->has_dogleg)
      pass ();
    else
      fail ("MULTILEADER.has_dogleg [B] " FORMAT_B " != " FORMAT_B "", multileader->has_dogleg, has_dogleg);
    has_dogleg++;
    if (dwg_dynapi_entity_set_value (multileader, "MULTILEADER", "has_dogleg", &has_dogleg, 0)
        && has_dogleg == multileader->has_dogleg)
      pass ();
    else
      fail ("MULTILEADER.has_dogleg [B] set+1 " FORMAT_B " != " FORMAT_B "", multileader->has_dogleg, has_dogleg);
    multileader->has_dogleg--;
  }
  {
    BITCODE_B has_landing;
    if (dwg_dynapi_entity_value (multileader, "MULTILEADER", "has_landing", &has_landing, NULL)
        && has_landing == multileader->has_landing)
      pass ();
    else
      fail ("MULTILEADER.has_landing [B] " FORMAT_B " != " FORMAT_B "", multileader->has_landing, has_landing);
    has_landing++;
    if (dwg_dynapi_entity_set_value (multileader, "MULTILEADER", "has_landing", &has_landing, 0)
        && has_landing == multileader->has_landing)
      pass ();
    else
      fail ("MULTILEADER.has_landing [B] set+1 " FORMAT_B " != " FORMAT_B "", multileader->has_landing, has_landing);
    multileader->has_landing--;
  }
  {
    BITCODE_B has_text_frame;
    if (dwg_dynapi_entity_value (multileader, "MULTILEADER", "has_text_frame", &has_text_frame, NULL)
        && has_text_frame == multileader->has_text_frame)
      pass ();
    else
      fail ("MULTILEADER.has_text_frame [B] " FORMAT_B " != " FORMAT_B "", multileader->has_text_frame, has_text_frame);
    has_text_frame++;
    if (dwg_dynapi_entity_set_value (multileader, "MULTILEADER", "has_text_frame", &has_text_frame, 0)
        && has_text_frame == multileader->has_text_frame)
      pass ();
    else
      fail ("MULTILEADER.has_text_frame [B] set+1 " FORMAT_B " != " FORMAT_B "", multileader->has_text_frame, has_text_frame);
    multileader->has_text_frame--;
  }
  {
    BITCODE_BS ipe_alignment;
    if (dwg_dynapi_entity_value (multileader, "MULTILEADER", "ipe_alignment", &ipe_alignment, NULL)
        && ipe_alignment == multileader->ipe_alignment)
      pass ();
    else
      fail ("MULTILEADER.ipe_alignment [BS] %hu != %hu", multileader->ipe_alignment, ipe_alignment);
    ipe_alignment++;
    if (dwg_dynapi_entity_set_value (multileader, "MULTILEADER", "ipe_alignment", &ipe_alignment, 0)
        && ipe_alignment == multileader->ipe_alignment)
      pass ();
    else
      fail ("MULTILEADER.ipe_alignment [BS] set+1 %hu != %hu", multileader->ipe_alignment, ipe_alignment);
    multileader->ipe_alignment--;
  }
  {
    BITCODE_B is_annotative;
    if (dwg_dynapi_entity_value (multileader, "MULTILEADER", "is_annotative", &is_annotative, NULL)
        && is_annotative == multileader->is_annotative)
      pass ();
    else
      fail ("MULTILEADER.is_annotative [B] " FORMAT_B " != " FORMAT_B "", multileader->is_annotative, is_annotative);
    is_annotative++;
    if (dwg_dynapi_entity_set_value (multileader, "MULTILEADER", "is_annotative", &is_annotative, 0)
        && is_annotative == multileader->is_annotative)
      pass ();
    else
      fail ("MULTILEADER.is_annotative [B] set+1 " FORMAT_B " != " FORMAT_B "", multileader->is_annotative, is_annotative);
    multileader->is_annotative--;
  }
  {
    BITCODE_B is_neg_textdir;
    if (dwg_dynapi_entity_value (multileader, "MULTILEADER", "is_neg_textdir", &is_neg_textdir, NULL)
        && is_neg_textdir == multileader->is_neg_textdir)
      pass ();
    else
      fail ("MULTILEADER.is_neg_textdir [B] " FORMAT_B " != " FORMAT_B "", multileader->is_neg_textdir, is_neg_textdir);
    is_neg_textdir++;
    if (dwg_dynapi_entity_set_value (multileader, "MULTILEADER", "is_neg_textdir", &is_neg_textdir, 0)
        && is_neg_textdir == multileader->is_neg_textdir)
      pass ();
    else
      fail ("MULTILEADER.is_neg_textdir [B] set+1 " FORMAT_B " != " FORMAT_B "", multileader->is_neg_textdir, is_neg_textdir);
    multileader->is_neg_textdir--;
  }
  {
    BITCODE_B is_text_extended;
    if (dwg_dynapi_entity_value (multileader, "MULTILEADER", "is_text_extended", &is_text_extended, NULL)
        && is_text_extended == multileader->is_text_extended)
      pass ();
    else
      fail ("MULTILEADER.is_text_extended [B] " FORMAT_B " != " FORMAT_B "", multileader->is_text_extended, is_text_extended);
    is_text_extended++;
    if (dwg_dynapi_entity_set_value (multileader, "MULTILEADER", "is_text_extended", &is_text_extended, 0)
        && is_text_extended == multileader->is_text_extended)
      pass ();
    else
      fail ("MULTILEADER.is_text_extended [B] set+1 " FORMAT_B " != " FORMAT_B "", multileader->is_text_extended, is_text_extended);
    multileader->is_text_extended--;
  }
  {
    BITCODE_BS justification;
    if (dwg_dynapi_entity_value (multileader, "MULTILEADER", "justification", &justification, NULL)
        && justification == multileader->justification)
      pass ();
    else
      fail ("MULTILEADER.justification [BS] %hu != %hu", multileader->justification, justification);
    justification++;
    if (dwg_dynapi_entity_set_value (multileader, "MULTILEADER", "justification", &justification, 0)
        && justification == multileader->justification)
      pass ();
    else
      fail ("MULTILEADER.justification [BS] set+1 %hu != %hu", multileader->justification, justification);
    multileader->justification--;
  }
  {
    BITCODE_BD landing_dist;
    if (dwg_dynapi_entity_value (multileader, "MULTILEADER", "landing_dist", &landing_dist, NULL)
        && landing_dist == multileader->landing_dist)
      pass ();
    else
      fail ("MULTILEADER.landing_dist [BD] %g != %g", multileader->landing_dist, landing_dist);
    landing_dist++;
    if (dwg_dynapi_entity_set_value (multileader, "MULTILEADER", "landing_dist", &landing_dist, 0)
        && landing_dist == multileader->landing_dist)
      pass ();
    else
      fail ("MULTILEADER.landing_dist [BD] set+1 %g != %g", multileader->landing_dist, landing_dist);
    multileader->landing_dist--;
  }
  {
    BITCODE_BLd linewt;
    if (dwg_dynapi_entity_value (multileader, "MULTILEADER", "linewt", &linewt, NULL)
        && linewt == multileader->linewt)
      pass ();
    else
      fail ("MULTILEADER.linewt [BLd] " FORMAT_BLd " != " FORMAT_BLd "", multileader->linewt, linewt);
    if (dwg_dynapi_entity_set_value (multileader, "MULTILEADER", "linewt", &linewt, 0)
        && linewt == multileader->linewt)
      pass ();
    else
      fail ("MULTILEADER.linewt [BLd] set+1 " FORMAT_BLd " != " FORMAT_BLd "", multileader->linewt, linewt);
    multileader->linewt--;
  }
  {
    BITCODE_H ltype;
    if (dwg_dynapi_entity_value (multileader, "MULTILEADER", "ltype", &ltype, NULL)
        && !memcmp (&ltype, &multileader->ltype, sizeof (BITCODE_H)))
        pass ();
    else
        fail ("MULTILEADER.ltype [H]");
  }
  {
    BITCODE_H mleaderstyle;
    if (dwg_dynapi_entity_value (multileader, "MULTILEADER", "mleaderstyle", &mleaderstyle, NULL)
        && !memcmp (&mleaderstyle, &multileader->mleaderstyle, sizeof (BITCODE_H)))
        pass ();
    else
        fail ("MULTILEADER.mleaderstyle [H]");
  }
  {
    BITCODE_BL num_arrowheads;
    if (dwg_dynapi_entity_value (multileader, "MULTILEADER", "num_arrowheads", &num_arrowheads, NULL)
        && num_arrowheads == multileader->num_arrowheads)
      pass ();
    else
      fail ("MULTILEADER.num_arrowheads [BL] %u != %u", multileader->num_arrowheads, num_arrowheads);
    num_arrowheads++;
    if (dwg_dynapi_entity_set_value (multileader, "MULTILEADER", "num_arrowheads", &num_arrowheads, 0)
        && num_arrowheads == multileader->num_arrowheads)
      pass ();
    else
      fail ("MULTILEADER.num_arrowheads [BL] set+1 %u != %u", multileader->num_arrowheads, num_arrowheads);
    multileader->num_arrowheads--;
  }
  {
    BITCODE_BL num_blocklabels;
    if (dwg_dynapi_entity_value (multileader, "MULTILEADER", "num_blocklabels", &num_blocklabels, NULL)
        && num_blocklabels == multileader->num_blocklabels)
      pass ();
    else
      fail ("MULTILEADER.num_blocklabels [BL] %u != %u", multileader->num_blocklabels, num_blocklabels);
    num_blocklabels++;
    if (dwg_dynapi_entity_set_value (multileader, "MULTILEADER", "num_blocklabels", &num_blocklabels, 0)
        && num_blocklabels == multileader->num_blocklabels)
      pass ();
    else
      fail ("MULTILEADER.num_blocklabels [BL] set+1 %u != %u", multileader->num_blocklabels, num_blocklabels);
    multileader->num_blocklabels--;
  }
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value (multileader, "MULTILEADER", "parent", &parent, NULL)
        && !memcmp (&parent, &multileader->parent, sizeof (struct _dwg_object_entity*)))
        pass ();
    else
        fail ("MULTILEADER.parent [struct _dwg_object_entity*]");
  }
  {
    BITCODE_BD scale_factor;
    if (dwg_dynapi_entity_value (multileader, "MULTILEADER", "scale_factor", &scale_factor, NULL)
        && scale_factor == multileader->scale_factor)
      pass ();
    else
      fail ("MULTILEADER.scale_factor [BD] %g != %g", multileader->scale_factor, scale_factor);
    scale_factor++;
    if (dwg_dynapi_entity_set_value (multileader, "MULTILEADER", "scale_factor", &scale_factor, 0)
        && scale_factor == multileader->scale_factor)
      pass ();
    else
      fail ("MULTILEADER.scale_factor [BD] set+1 %g != %g", multileader->scale_factor, scale_factor);
    multileader->scale_factor--;
  }
  {
    BITCODE_BS style_attachment;
    if (dwg_dynapi_entity_value (multileader, "MULTILEADER", "style_attachment", &style_attachment, NULL)
        && style_attachment == multileader->style_attachment)
      pass ();
    else
      fail ("MULTILEADER.style_attachment [BS] %hu != %hu", multileader->style_attachment, style_attachment);
    style_attachment++;
    if (dwg_dynapi_entity_set_value (multileader, "MULTILEADER", "style_attachment", &style_attachment, 0)
        && style_attachment == multileader->style_attachment)
      pass ();
    else
      fail ("MULTILEADER.style_attachment [BS] set+1 %hu != %hu", multileader->style_attachment, style_attachment);
    multileader->style_attachment--;
  }
  {
    BITCODE_BS style_content;
    if (dwg_dynapi_entity_value (multileader, "MULTILEADER", "style_content", &style_content, NULL)
        && style_content == multileader->style_content)
      pass ();
    else
      fail ("MULTILEADER.style_content [BS] %hu != %hu", multileader->style_content, style_content);
    style_content++;
    if (dwg_dynapi_entity_set_value (multileader, "MULTILEADER", "style_content", &style_content, 0)
        && style_content == multileader->style_content)
      pass ();
    else
      fail ("MULTILEADER.style_content [BS] set+1 %hu != %hu", multileader->style_content, style_content);
    multileader->style_content--;
  }
  {
    BITCODE_BS text_alignment;
    if (dwg_dynapi_entity_value (multileader, "MULTILEADER", "text_alignment", &text_alignment, NULL)
        && text_alignment == multileader->text_alignment)
      pass ();
    else
      fail ("MULTILEADER.text_alignment [BS] %hu != %hu", multileader->text_alignment, text_alignment);
    text_alignment++;
    if (dwg_dynapi_entity_set_value (multileader, "MULTILEADER", "text_alignment", &text_alignment, 0)
        && text_alignment == multileader->text_alignment)
      pass ();
    else
      fail ("MULTILEADER.text_alignment [BS] set+1 %hu != %hu", multileader->text_alignment, text_alignment);
    multileader->text_alignment--;
  }
  {
    BITCODE_BS text_angletype;
    if (dwg_dynapi_entity_value (multileader, "MULTILEADER", "text_angletype", &text_angletype, NULL)
        && text_angletype == multileader->text_angletype)
      pass ();
    else
      fail ("MULTILEADER.text_angletype [BS] %hu != %hu", multileader->text_angletype, text_angletype);
    text_angletype++;
    if (dwg_dynapi_entity_set_value (multileader, "MULTILEADER", "text_angletype", &text_angletype, 0)
        && text_angletype == multileader->text_angletype)
      pass ();
    else
      fail ("MULTILEADER.text_angletype [BS] set+1 %hu != %hu", multileader->text_angletype, text_angletype);
    multileader->text_angletype--;
  }
  {
    BITCODE_CMC text_color;
    if (dwg_dynapi_entity_value (multileader, "MULTILEADER", "text_color", &text_color, NULL)
        && !memcmp (&text_color, &multileader->text_color, sizeof (BITCODE_CMC)))
        pass ();
    else
        fail ("MULTILEADER.text_color [CMC]");
  }
  {
    BITCODE_BS text_left;
    if (dwg_dynapi_entity_value (multileader, "MULTILEADER", "text_left", &text_left, NULL)
        && text_left == multileader->text_left)
      pass ();
    else
      fail ("MULTILEADER.text_left [BS] %hu != %hu", multileader->text_left, text_left);
    text_left++;
    if (dwg_dynapi_entity_set_value (multileader, "MULTILEADER", "text_left", &text_left, 0)
        && text_left == multileader->text_left)
      pass ();
    else
      fail ("MULTILEADER.text_left [BS] set+1 %hu != %hu", multileader->text_left, text_left);
    multileader->text_left--;
  }
  {
    BITCODE_BS text_right;
    if (dwg_dynapi_entity_value (multileader, "MULTILEADER", "text_right", &text_right, NULL)
        && text_right == multileader->text_right)
      pass ();
    else
      fail ("MULTILEADER.text_right [BS] %hu != %hu", multileader->text_right, text_right);
    text_right++;
    if (dwg_dynapi_entity_set_value (multileader, "MULTILEADER", "text_right", &text_right, 0)
        && text_right == multileader->text_right)
      pass ();
    else
      fail ("MULTILEADER.text_right [BS] set+1 %hu != %hu", multileader->text_right, text_right);
    multileader->text_right--;
  }
  {
    BITCODE_H text_style;
    if (dwg_dynapi_entity_value (multileader, "MULTILEADER", "text_style", &text_style, NULL)
        && !memcmp (&text_style, &multileader->text_style, sizeof (BITCODE_H)))
        pass ();
    else
        fail ("MULTILEADER.text_style [H]");
  }
  {
    BITCODE_BS type;
    if (dwg_dynapi_entity_value (multileader, "MULTILEADER", "type", &type, NULL)
        && type == multileader->type)
      pass ();
    else
      fail ("MULTILEADER.type [BS] %hu != %hu", multileader->type, type);
    type++;
    if (dwg_dynapi_entity_set_value (multileader, "MULTILEADER", "type", &type, 0)
        && type == multileader->type)
      pass ();
    else
      fail ("MULTILEADER.type [BS] set+1 %hu != %hu", multileader->type, type);
    multileader->type--;
  }
  if (failed && (is_class_unstable ("MULTILEADER") || is_class_debugging ("MULTILEADER")))
    {
      ok ("%s failed %d tests (TODO unstable)", "MULTILEADER", failed);
      failed = 0;
    }
  return failed;
}
static int test_NAVISWORKSMODEL (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_NAVISWORKSMODEL *restrict navisworksmodel = obj->tio.entity->tio.NAVISWORKSMODEL;
  failed = 0;
  {
    BITCODE_H definition;
    if (dwg_dynapi_entity_value (navisworksmodel, "NAVISWORKSMODEL", "definition", &definition, NULL)
        && !memcmp (&definition, &navisworksmodel->definition, sizeof (BITCODE_H)))
        pass ();
    else
        fail ("NAVISWORKSMODEL.definition [H]");
  }
  {
    BITCODE_BS flags;
    if (dwg_dynapi_entity_value (navisworksmodel, "NAVISWORKSMODEL", "flags", &flags, NULL)
        && flags == navisworksmodel->flags)
      pass ();
    else
      fail ("NAVISWORKSMODEL.flags [BS] %hu != %hu", navisworksmodel->flags, flags);
    flags++;
    if (dwg_dynapi_entity_set_value (navisworksmodel, "NAVISWORKSMODEL", "flags", &flags, 0)
        && flags == navisworksmodel->flags)
      pass ();
    else
      fail ("NAVISWORKSMODEL.flags [BS] set+1 %hu != %hu", navisworksmodel->flags, flags);
    navisworksmodel->flags--;
  }
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value (navisworksmodel, "NAVISWORKSMODEL", "parent", &parent, NULL)
        && !memcmp (&parent, &navisworksmodel->parent, sizeof (struct _dwg_object_entity*)))
        pass ();
    else
        fail ("NAVISWORKSMODEL.parent [struct _dwg_object_entity*]");
  }
  {
    BITCODE_BD* transmatrix;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (navisworksmodel, "NAVISWORKSMODEL", "num_transmatrix", &count, NULL)
        && dwg_dynapi_entity_value (navisworksmodel, "NAVISWORKSMODEL", "transmatrix", &transmatrix, NULL)
        && transmatrix == navisworksmodel->transmatrix)
      pass ();
    else
      fail ("NAVISWORKSMODEL.transmatrix [BD*] * %u num_transmatrix", count);
  }
  {
    BITCODE_BD unitfactor;
    if (dwg_dynapi_entity_value (navisworksmodel, "NAVISWORKSMODEL", "unitfactor", &unitfactor, NULL)
        && unitfactor == navisworksmodel->unitfactor)
      pass ();
    else
      fail ("NAVISWORKSMODEL.unitfactor [BD] %g != %g", navisworksmodel->unitfactor, unitfactor);
    unitfactor++;
    if (dwg_dynapi_entity_set_value (navisworksmodel, "NAVISWORKSMODEL", "unitfactor", &unitfactor, 0)
        && unitfactor == navisworksmodel->unitfactor)
      pass ();
    else
      fail ("NAVISWORKSMODEL.unitfactor [BD] set+1 %g != %g", navisworksmodel->unitfactor, unitfactor);
    navisworksmodel->unitfactor--;
  }
  if (failed && (is_class_unstable ("NAVISWORKSMODEL") || is_class_debugging ("NAVISWORKSMODEL")))
    {
      ok ("%s failed %d tests (TODO unstable)", "NAVISWORKSMODEL", failed);
      failed = 0;
    }
  return failed;
}
static int test_NURBSURFACE (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_NURBSURFACE *restrict nurbsurface = obj->tio.entity->tio.NURBSURFACE;
  failed = 0;
  {
    BITCODE_B _dxf_sab_converted;
    if (dwg_dynapi_entity_value (nurbsurface, "NURBSURFACE", "_dxf_sab_converted", &_dxf_sab_converted, NULL)
        && _dxf_sab_converted == nurbsurface->_dxf_sab_converted)
      pass ();
    else
      fail ("NURBSURFACE._dxf_sab_converted [B] " FORMAT_B " != " FORMAT_B "", nurbsurface->_dxf_sab_converted, _dxf_sab_converted);
    _dxf_sab_converted++;
    if (dwg_dynapi_entity_set_value (nurbsurface, "NURBSURFACE", "_dxf_sab_converted", &_dxf_sab_converted, 0)
        && _dxf_sab_converted == nurbsurface->_dxf_sab_converted)
      pass ();
    else
      fail ("NURBSURFACE._dxf_sab_converted [B] set+1 " FORMAT_B " != " FORMAT_B "", nurbsurface->_dxf_sab_converted, _dxf_sab_converted);
    nurbsurface->_dxf_sab_converted--;
  }
  {
    BITCODE_RC* acis_data;
    if (dwg_dynapi_entity_value (nurbsurface, "NURBSURFACE", "acis_data", &acis_data, NULL)
        && acis_data
           ? strEQ ((char *)acis_data, (char *)nurbsurface->acis_data)
           : !nurbsurface->acis_data)
      pass ();
    else
      fail ("NURBSURFACE.acis_data [RC*] '%s' <> '%s'", acis_data, nurbsurface->acis_data);
  }
  {
    BITCODE_B acis_empty;
    if (dwg_dynapi_entity_value (nurbsurface, "NURBSURFACE", "acis_empty", &acis_empty, NULL)
        && acis_empty == nurbsurface->acis_empty)
      pass ();
    else
      fail ("NURBSURFACE.acis_empty [B] " FORMAT_B " != " FORMAT_B "", nurbsurface->acis_empty, acis_empty);
    acis_empty++;
    if (dwg_dynapi_entity_set_value (nurbsurface, "NURBSURFACE", "acis_empty", &acis_empty, 0)
        && acis_empty == nurbsurface->acis_empty)
      pass ();
    else
      fail ("NURBSURFACE.acis_empty [B] set+1 " FORMAT_B " != " FORMAT_B "", nurbsurface->acis_empty, acis_empty);
    nurbsurface->acis_empty--;
  }
  {
    BITCODE_B acis_empty2;
    if (dwg_dynapi_entity_value (nurbsurface, "NURBSURFACE", "acis_empty2", &acis_empty2, NULL)
        && acis_empty2 == nurbsurface->acis_empty2)
      pass ();
    else
      fail ("NURBSURFACE.acis_empty2 [B] " FORMAT_B " != " FORMAT_B "", nurbsurface->acis_empty2, acis_empty2);
    acis_empty2++;
    if (dwg_dynapi_entity_set_value (nurbsurface, "NURBSURFACE", "acis_empty2", &acis_empty2, 0)
        && acis_empty2 == nurbsurface->acis_empty2)
      pass ();
    else
      fail ("NURBSURFACE.acis_empty2 [B] set+1 " FORMAT_B " != " FORMAT_B "", nurbsurface->acis_empty2, acis_empty2);
    nurbsurface->acis_empty2--;
  }
  {
    BITCODE_B acis_empty_bit;
    if (dwg_dynapi_entity_value (nurbsurface, "NURBSURFACE", "acis_empty_bit", &acis_empty_bit, NULL)
        && acis_empty_bit == nurbsurface->acis_empty_bit)
      pass ();
    else
      fail ("NURBSURFACE.acis_empty_bit [B] " FORMAT_B " != " FORMAT_B "", nurbsurface->acis_empty_bit, acis_empty_bit);
    acis_empty_bit++;
    if (dwg_dynapi_entity_set_value (nurbsurface, "NURBSURFACE", "acis_empty_bit", &acis_empty_bit, 0)
        && acis_empty_bit == nurbsurface->acis_empty_bit)
      pass ();
    else
      fail ("NURBSURFACE.acis_empty_bit [B] set+1 " FORMAT_B " != " FORMAT_B "", nurbsurface->acis_empty_bit, acis_empty_bit);
    nurbsurface->acis_empty_bit--;
  }
  {
    BITCODE_BL* block_size;
    if (dwg_dynapi_entity_value (nurbsurface, "NURBSURFACE", "block_size", &block_size, NULL)
        && !memcmp (&block_size, &nurbsurface->block_size, sizeof (BITCODE_BL*)))
        pass ();
    else
        fail ("NURBSURFACE.block_size [BL*]");
  }
  {
    BITCODE_B cv_hull_display;
    if (dwg_dynapi_entity_value (nurbsurface, "NURBSURFACE", "cv_hull_display", &cv_hull_display, NULL)
        && cv_hull_display == nurbsurface->cv_hull_display)
      pass ();
    else
      fail ("NURBSURFACE.cv_hull_display [B] " FORMAT_B " != " FORMAT_B "", nurbsurface->cv_hull_display, cv_hull_display);
    cv_hull_display++;
    if (dwg_dynapi_entity_set_value (nurbsurface, "NURBSURFACE", "cv_hull_display", &cv_hull_display, 0)
        && cv_hull_display == nurbsurface->cv_hull_display)
      pass ();
    else
      fail ("NURBSURFACE.cv_hull_display [B] set+1 " FORMAT_B " != " FORMAT_B "", nurbsurface->cv_hull_display, cv_hull_display);
    nurbsurface->cv_hull_display--;
  }
  {
    char ** encr_sat_data;
    if (dwg_dynapi_entity_value (nurbsurface, "NURBSURFACE", "encr_sat_data", &encr_sat_data, NULL)
        && !memcmp (&encr_sat_data, &nurbsurface->encr_sat_data, sizeof (nurbsurface->encr_sat_data)))
      pass ();
    else
      fail ("NURBSURFACE.encr_sat_data [char **]");
  }
  {
    BITCODE_BL end_marker;
    if (dwg_dynapi_entity_value (nurbsurface, "NURBSURFACE", "end_marker", &end_marker, NULL)
        && end_marker == nurbsurface->end_marker)
      pass ();
    else
      fail ("NURBSURFACE.end_marker [BL] %u != %u", nurbsurface->end_marker, end_marker);
    end_marker++;
    if (dwg_dynapi_entity_set_value (nurbsurface, "NURBSURFACE", "end_marker", &end_marker, 0)
        && end_marker == nurbsurface->end_marker)
      pass ();
    else
      fail ("NURBSURFACE.end_marker [BL] set+1 %u != %u", nurbsurface->end_marker, end_marker);
    nurbsurface->end_marker--;
  }
  {
    struct _dwg_entity_3DSOLID* extra_acis_data;
    if (dwg_dynapi_entity_value (nurbsurface, "NURBSURFACE", "extra_acis_data", &extra_acis_data, NULL)
        && !memcmp (&extra_acis_data, &nurbsurface->extra_acis_data, sizeof (struct _dwg_entity_3DSOLID*)))
        pass ();
    else
        fail ("NURBSURFACE.extra_acis_data [struct _dwg_entity_3DSOLID*]");
  }
  {
    BITCODE_B has_revision_guid;
    if (dwg_dynapi_entity_value (nurbsurface, "NURBSURFACE", "has_revision_guid", &has_revision_guid, NULL)
        && has_revision_guid == nurbsurface->has_revision_guid)
      pass ();
    else
      fail ("NURBSURFACE.has_revision_guid [B] " FORMAT_B " != " FORMAT_B "", nurbsurface->has_revision_guid, has_revision_guid);
    has_revision_guid++;
    if (dwg_dynapi_entity_set_value (nurbsurface, "NURBSURFACE", "has_revision_guid", &has_revision_guid, 0)
        && has_revision_guid == nurbsurface->has_revision_guid)
      pass ();
    else
      fail ("NURBSURFACE.has_revision_guid [B] set+1 " FORMAT_B " != " FORMAT_B "", nurbsurface->has_revision_guid, has_revision_guid);
    nurbsurface->has_revision_guid--;
  }
  {
    BITCODE_H history_id;
    if (dwg_dynapi_entity_value (nurbsurface, "NURBSURFACE", "history_id", &history_id, NULL)
        && !memcmp (&history_id, &nurbsurface->history_id, sizeof (BITCODE_H)))
        pass ();
    else
        fail ("NURBSURFACE.history_id [H]");
  }
  {
    BITCODE_B isoline_present;
    if (dwg_dynapi_entity_value (nurbsurface, "NURBSURFACE", "isoline_present", &isoline_present, NULL)
        && isoline_present == nurbsurface->isoline_present)
      pass ();
    else
      fail ("NURBSURFACE.isoline_present [B] " FORMAT_B " != " FORMAT_B "", nurbsurface->isoline_present, isoline_present);
    isoline_present++;
    if (dwg_dynapi_entity_set_value (nurbsurface, "NURBSURFACE", "isoline_present", &isoline_present, 0)
        && isoline_present == nurbsurface->isoline_present)
      pass ();
    else
      fail ("NURBSURFACE.isoline_present [B] set+1 " FORMAT_B " != " FORMAT_B "", nurbsurface->isoline_present, isoline_present);
    nurbsurface->isoline_present--;
  }
  {
    BITCODE_BL isolines;
    if (dwg_dynapi_entity_value (nurbsurface, "NURBSURFACE", "isolines", &isolines, NULL)
        && isolines == nurbsurface->isolines)
      pass ();
    else
      fail ("NURBSURFACE.isolines [BL] %u != %u", nurbsurface->isolines, isolines);
    isolines++;
    if (dwg_dynapi_entity_set_value (nurbsurface, "NURBSURFACE", "isolines", &isolines, 0)
        && isolines == nurbsurface->isolines)
      pass ();
    else
      fail ("NURBSURFACE.isolines [BL] set+1 %u != %u", nurbsurface->isolines, isolines);
    nurbsurface->isolines--;
  }
  {
    Dwg_3DSOLID_material* materials;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (nurbsurface, "NURBSURFACE", "num_materials", &count, NULL)
        && dwg_dynapi_entity_value (nurbsurface, "NURBSURFACE", "materials", &materials, NULL)
        && materials == nurbsurface->materials)
      pass ();
    else
      fail ("NURBSURFACE.materials [Dwg_3DSOLID_material*] * %u num_materials", count);
  }
  {
    BITCODE_BL num_blocks;
    if (dwg_dynapi_entity_value (nurbsurface, "NURBSURFACE", "num_blocks", &num_blocks, NULL)
        && num_blocks == nurbsurface->num_blocks)
      pass ();
    else
      fail ("NURBSURFACE.num_blocks [BL] %u != %u", nurbsurface->num_blocks, num_blocks);
    num_blocks++;
    if (dwg_dynapi_entity_set_value (nurbsurface, "NURBSURFACE", "num_blocks", &num_blocks, 0)
        && num_blocks == nurbsurface->num_blocks)
      pass ();
    else
      fail ("NURBSURFACE.num_blocks [BL] set+1 %u != %u", nurbsurface->num_blocks, num_blocks);
    nurbsurface->num_blocks--;
  }
  {
    BITCODE_BL num_materials;
    if (dwg_dynapi_entity_value (nurbsurface, "NURBSURFACE", "num_materials", &num_materials, NULL)
        && num_materials == nurbsurface->num_materials)
      pass ();
    else
      fail ("NURBSURFACE.num_materials [BL] %u != %u", nurbsurface->num_materials, num_materials);
    num_materials++;
    if (dwg_dynapi_entity_set_value (nurbsurface, "NURBSURFACE", "num_materials", &num_materials, 0)
        && num_materials == nurbsurface->num_materials)
      pass ();
    else
      fail ("NURBSURFACE.num_materials [BL] set+1 %u != %u", nurbsurface->num_materials, num_materials);
    nurbsurface->num_materials--;
  }
  {
    BITCODE_BL num_silhouettes;
    if (dwg_dynapi_entity_value (nurbsurface, "NURBSURFACE", "num_silhouettes", &num_silhouettes, NULL)
        && num_silhouettes == nurbsurface->num_silhouettes)
      pass ();
    else
      fail ("NURBSURFACE.num_silhouettes [BL] %u != %u", nurbsurface->num_silhouettes, num_silhouettes);
    num_silhouettes++;
    if (dwg_dynapi_entity_set_value (nurbsurface, "NURBSURFACE", "num_silhouettes", &num_silhouettes, 0)
        && num_silhouettes == nurbsurface->num_silhouettes)
      pass ();
    else
      fail ("NURBSURFACE.num_silhouettes [BL] set+1 %u != %u", nurbsurface->num_silhouettes, num_silhouettes);
    nurbsurface->num_silhouettes--;
  }
  {
    BITCODE_BL num_wires;
    if (dwg_dynapi_entity_value (nurbsurface, "NURBSURFACE", "num_wires", &num_wires, NULL)
        && num_wires == nurbsurface->num_wires)
      pass ();
    else
      fail ("NURBSURFACE.num_wires [BL] %u != %u", nurbsurface->num_wires, num_wires);
    num_wires++;
    if (dwg_dynapi_entity_set_value (nurbsurface, "NURBSURFACE", "num_wires", &num_wires, 0)
        && num_wires == nurbsurface->num_wires)
      pass ();
    else
      fail ("NURBSURFACE.num_wires [BL] set+1 %u != %u", nurbsurface->num_wires, num_wires);
    nurbsurface->num_wires--;
  }
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value (nurbsurface, "NURBSURFACE", "parent", &parent, NULL)
        && !memcmp (&parent, &nurbsurface->parent, sizeof (struct _dwg_object_entity*)))
        pass ();
    else
        fail ("NURBSURFACE.parent [struct _dwg_object_entity*]");
  }
  {
    BITCODE_3BD point;
    if (dwg_dynapi_entity_value (nurbsurface, "NURBSURFACE", "point", &point, NULL)
        && !memcmp (&point, &nurbsurface->point, sizeof (BITCODE_3BD)))
        pass ();
    else
        fail ("NURBSURFACE.point [3BD]");
  }
  {
    BITCODE_B point_present;
    if (dwg_dynapi_entity_value (nurbsurface, "NURBSURFACE", "point_present", &point_present, NULL)
        && point_present == nurbsurface->point_present)
      pass ();
    else
      fail ("NURBSURFACE.point_present [B] " FORMAT_B " != " FORMAT_B "", nurbsurface->point_present, point_present);
    point_present++;
    if (dwg_dynapi_entity_set_value (nurbsurface, "NURBSURFACE", "point_present", &point_present, 0)
        && point_present == nurbsurface->point_present)
      pass ();
    else
      fail ("NURBSURFACE.point_present [B] set+1 " FORMAT_B " != " FORMAT_B "", nurbsurface->point_present, point_present);
    nurbsurface->point_present--;
  }
  {
    BITCODE_RC revision_bytes[9];
    if (dwg_dynapi_entity_value (nurbsurface, "NURBSURFACE", "revision_bytes[9]", &revision_bytes, NULL)
        && !memcmp (&revision_bytes, &nurbsurface->revision_bytes, sizeof (BITCODE_RC)))
        pass ();
    else
        fail ("NURBSURFACE.revision_bytes[9] [RC]");
  }
  {
    BITCODE_RC revision_guid[39];
    if (dwg_dynapi_entity_value (nurbsurface, "NURBSURFACE", "revision_guid[39]", &revision_guid, NULL)
        && !memcmp (&revision_guid, &nurbsurface->revision_guid, sizeof (BITCODE_RC)))
        pass ();
    else
        fail ("NURBSURFACE.revision_guid[39] [RC]");
  }
  {
    BITCODE_BL revision_major;
    if (dwg_dynapi_entity_value (nurbsurface, "NURBSURFACE", "revision_major", &revision_major, NULL)
        && revision_major == nurbsurface->revision_major)
      pass ();
    else
      fail ("NURBSURFACE.revision_major [BL] %u != %u", nurbsurface->revision_major, revision_major);
    revision_major++;
    if (dwg_dynapi_entity_set_value (nurbsurface, "NURBSURFACE", "revision_major", &revision_major, 0)
        && revision_major == nurbsurface->revision_major)
      pass ();
    else
      fail ("NURBSURFACE.revision_major [BL] set+1 %u != %u", nurbsurface->revision_major, revision_major);
    nurbsurface->revision_major--;
  }
  {
    BITCODE_BS revision_minor1;
    if (dwg_dynapi_entity_value (nurbsurface, "NURBSURFACE", "revision_minor1", &revision_minor1, NULL)
        && revision_minor1 == nurbsurface->revision_minor1)
      pass ();
    else
      fail ("NURBSURFACE.revision_minor1 [BS] %hu != %hu", nurbsurface->revision_minor1, revision_minor1);
    revision_minor1++;
    if (dwg_dynapi_entity_set_value (nurbsurface, "NURBSURFACE", "revision_minor1", &revision_minor1, 0)
        && revision_minor1 == nurbsurface->revision_minor1)
      pass ();
    else
      fail ("NURBSURFACE.revision_minor1 [BS] set+1 %hu != %hu", nurbsurface->revision_minor1, revision_minor1);
    nurbsurface->revision_minor1--;
  }
  {
    BITCODE_BS revision_minor2;
    if (dwg_dynapi_entity_value (nurbsurface, "NURBSURFACE", "revision_minor2", &revision_minor2, NULL)
        && revision_minor2 == nurbsurface->revision_minor2)
      pass ();
    else
      fail ("NURBSURFACE.revision_minor2 [BS] %hu != %hu", nurbsurface->revision_minor2, revision_minor2);
    revision_minor2++;
    if (dwg_dynapi_entity_set_value (nurbsurface, "NURBSURFACE", "revision_minor2", &revision_minor2, 0)
        && revision_minor2 == nurbsurface->revision_minor2)
      pass ();
    else
      fail ("NURBSURFACE.revision_minor2 [BS] set+1 %hu != %hu", nurbsurface->revision_minor2, revision_minor2);
    nurbsurface->revision_minor2--;
  }
  {
    BITCODE_BL sab_size;
    if (dwg_dynapi_entity_value (nurbsurface, "NURBSURFACE", "sab_size", &sab_size, NULL)
        && sab_size == nurbsurface->sab_size)
      pass ();
    else
      fail ("NURBSURFACE.sab_size [BL] %u != %u", nurbsurface->sab_size, sab_size);
    sab_size++;
    if (dwg_dynapi_entity_set_value (nurbsurface, "NURBSURFACE", "sab_size", &sab_size, 0)
        && sab_size == nurbsurface->sab_size)
      pass ();
    else
      fail ("NURBSURFACE.sab_size [BL] set+1 %u != %u", nurbsurface->sab_size, sab_size);
    nurbsurface->sab_size--;
  }
  {
    BITCODE_BS short170;
    if (dwg_dynapi_entity_value (nurbsurface, "NURBSURFACE", "short170", &short170, NULL)
        && short170 == nurbsurface->short170)
      pass ();
    else
      fail ("NURBSURFACE.short170 [BS] %hu != %hu", nurbsurface->short170, short170);
    short170++;
    if (dwg_dynapi_entity_set_value (nurbsurface, "NURBSURFACE", "short170", &short170, 0)
        && short170 == nurbsurface->short170)
      pass ();
    else
      fail ("NURBSURFACE.short170 [BS] set+1 %hu != %hu", nurbsurface->short170, short170);
    nurbsurface->short170--;
  }
  {
    Dwg_3DSOLID_silhouette* silhouettes;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (nurbsurface, "NURBSURFACE", "num_silhouettes", &count, NULL)
        && dwg_dynapi_entity_value (nurbsurface, "NURBSURFACE", "silhouettes", &silhouettes, NULL)
        && silhouettes == nurbsurface->silhouettes)
      pass ();
    else
      fail ("NURBSURFACE.silhouettes [Dwg_3DSOLID_silhouette*] * %u num_silhouettes", count);
  }
  {
    BITCODE_BS u_isolines;
    if (dwg_dynapi_entity_value (nurbsurface, "NURBSURFACE", "u_isolines", &u_isolines, NULL)
        && u_isolines == nurbsurface->u_isolines)
      pass ();
    else
      fail ("NURBSURFACE.u_isolines [BS] %hu != %hu", nurbsurface->u_isolines, u_isolines);
    u_isolines++;
    if (dwg_dynapi_entity_set_value (nurbsurface, "NURBSURFACE", "u_isolines", &u_isolines, 0)
        && u_isolines == nurbsurface->u_isolines)
      pass ();
    else
      fail ("NURBSURFACE.u_isolines [BS] set+1 %hu != %hu", nurbsurface->u_isolines, u_isolines);
    nurbsurface->u_isolines--;
  }
  {
    BITCODE_B unknown;
    if (dwg_dynapi_entity_value (nurbsurface, "NURBSURFACE", "unknown", &unknown, NULL)
        && unknown == nurbsurface->unknown)
      pass ();
    else
      fail ("NURBSURFACE.unknown [B] " FORMAT_B " != " FORMAT_B "", nurbsurface->unknown, unknown);
    unknown++;
    if (dwg_dynapi_entity_set_value (nurbsurface, "NURBSURFACE", "unknown", &unknown, 0)
        && unknown == nurbsurface->unknown)
      pass ();
    else
      fail ("NURBSURFACE.unknown [B] set+1 " FORMAT_B " != " FORMAT_B "", nurbsurface->unknown, unknown);
    nurbsurface->unknown--;
  }
  {
    BITCODE_3BD uvec1;
    if (dwg_dynapi_entity_value (nurbsurface, "NURBSURFACE", "uvec1", &uvec1, NULL)
        && !memcmp (&uvec1, &nurbsurface->uvec1, sizeof (BITCODE_3BD)))
        pass ();
    else
        fail ("NURBSURFACE.uvec1 [3BD]");
  }
  {
    BITCODE_3BD uvec2;
    if (dwg_dynapi_entity_value (nurbsurface, "NURBSURFACE", "uvec2", &uvec2, NULL)
        && !memcmp (&uvec2, &nurbsurface->uvec2, sizeof (BITCODE_3BD)))
        pass ();
    else
        fail ("NURBSURFACE.uvec2 [3BD]");
  }
  {
    BITCODE_BS v_isolines;
    if (dwg_dynapi_entity_value (nurbsurface, "NURBSURFACE", "v_isolines", &v_isolines, NULL)
        && v_isolines == nurbsurface->v_isolines)
      pass ();
    else
      fail ("NURBSURFACE.v_isolines [BS] %hu != %hu", nurbsurface->v_isolines, v_isolines);
    v_isolines++;
    if (dwg_dynapi_entity_set_value (nurbsurface, "NURBSURFACE", "v_isolines", &v_isolines, 0)
        && v_isolines == nurbsurface->v_isolines)
      pass ();
    else
      fail ("NURBSURFACE.v_isolines [BS] set+1 %hu != %hu", nurbsurface->v_isolines, v_isolines);
    nurbsurface->v_isolines--;
  }
  {
    BITCODE_BS version;
    if (dwg_dynapi_entity_value (nurbsurface, "NURBSURFACE", "version", &version, NULL)
        && version == nurbsurface->version)
      pass ();
    else
      fail ("NURBSURFACE.version [BS] %hu != %hu", nurbsurface->version, version);
    version++;
    if (dwg_dynapi_entity_set_value (nurbsurface, "NURBSURFACE", "version", &version, 0)
        && version == nurbsurface->version)
      pass ();
    else
      fail ("NURBSURFACE.version [BS] set+1 %hu != %hu", nurbsurface->version, version);
    nurbsurface->version--;
  }
  {
    BITCODE_3BD vvec1;
    if (dwg_dynapi_entity_value (nurbsurface, "NURBSURFACE", "vvec1", &vvec1, NULL)
        && !memcmp (&vvec1, &nurbsurface->vvec1, sizeof (BITCODE_3BD)))
        pass ();
    else
        fail ("NURBSURFACE.vvec1 [3BD]");
  }
  {
    BITCODE_3BD vvec2;
    if (dwg_dynapi_entity_value (nurbsurface, "NURBSURFACE", "vvec2", &vvec2, NULL)
        && !memcmp (&vvec2, &nurbsurface->vvec2, sizeof (BITCODE_3BD)))
        pass ();
    else
        fail ("NURBSURFACE.vvec2 [3BD]");
  }
  {
    BITCODE_B wireframe_data_present;
    if (dwg_dynapi_entity_value (nurbsurface, "NURBSURFACE", "wireframe_data_present", &wireframe_data_present, NULL)
        && wireframe_data_present == nurbsurface->wireframe_data_present)
      pass ();
    else
      fail ("NURBSURFACE.wireframe_data_present [B] " FORMAT_B " != " FORMAT_B "", nurbsurface->wireframe_data_present, wireframe_data_present);
    wireframe_data_present++;
    if (dwg_dynapi_entity_set_value (nurbsurface, "NURBSURFACE", "wireframe_data_present", &wireframe_data_present, 0)
        && wireframe_data_present == nurbsurface->wireframe_data_present)
      pass ();
    else
      fail ("NURBSURFACE.wireframe_data_present [B] set+1 " FORMAT_B " != " FORMAT_B "", nurbsurface->wireframe_data_present, wireframe_data_present);
    nurbsurface->wireframe_data_present--;
  }
  {
    Dwg_3DSOLID_wire* wires;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (nurbsurface, "NURBSURFACE", "num_wires", &count, NULL)
        && dwg_dynapi_entity_value (nurbsurface, "NURBSURFACE", "wires", &wires, NULL)
        && wires == nurbsurface->wires)
      pass ();
    else
      fail ("NURBSURFACE.wires [Dwg_3DSOLID_wire*] * %u num_wires", count);
  }
  if (failed && (is_class_unstable ("NURBSURFACE") || is_class_debugging ("NURBSURFACE")))
    {
      ok ("%s failed %d tests (TODO unstable)", "NURBSURFACE", failed);
      failed = 0;
    }
  return failed;
}
static int test_OLE2FRAME (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_OLE2FRAME *restrict ole2frame = obj->tio.entity->tio.OLE2FRAME;
  failed = 0;
  {
    BITCODE_TF data;
    if (dwg_dynapi_entity_value (ole2frame, "OLE2FRAME", "data", &data, NULL)
        && !memcmp (&data, &ole2frame->data, sizeof (BITCODE_TF)))
        pass ();
    else
        fail ("OLE2FRAME.data [TF]");
  }
  {
    BITCODE_BL data_size;
    if (dwg_dynapi_entity_value (ole2frame, "OLE2FRAME", "data_size", &data_size, NULL)
        && data_size == ole2frame->data_size)
      pass ();
    else
      fail ("OLE2FRAME.data_size [BL] %u != %u", ole2frame->data_size, data_size);
    data_size++;
    if (dwg_dynapi_entity_set_value (ole2frame, "OLE2FRAME", "data_size", &data_size, 0)
        && data_size == ole2frame->data_size)
      pass ();
    else
      fail ("OLE2FRAME.data_size [BL] set+1 %u != %u", ole2frame->data_size, data_size);
    ole2frame->data_size--;
  }
  {
    BITCODE_RC lock_aspect;
    if (dwg_dynapi_entity_value (ole2frame, "OLE2FRAME", "lock_aspect", &lock_aspect, NULL)
        && lock_aspect == ole2frame->lock_aspect)
      pass ();
    else
      fail ("OLE2FRAME.lock_aspect [RC] %u != %u", ole2frame->lock_aspect, lock_aspect);
    lock_aspect++;
    if (dwg_dynapi_entity_set_value (ole2frame, "OLE2FRAME", "lock_aspect", &lock_aspect, 0)
        && lock_aspect == ole2frame->lock_aspect)
      pass ();
    else
      fail ("OLE2FRAME.lock_aspect [RC] set+1 %u != %u", ole2frame->lock_aspect, lock_aspect);
    ole2frame->lock_aspect--;
  }
  {
    BITCODE_BS mode;
    if (dwg_dynapi_entity_value (ole2frame, "OLE2FRAME", "mode", &mode, NULL)
        && mode == ole2frame->mode)
      pass ();
    else
      fail ("OLE2FRAME.mode [BS] %hu != %hu", ole2frame->mode, mode);
    mode++;
    if (dwg_dynapi_entity_set_value (ole2frame, "OLE2FRAME", "mode", &mode, 0)
        && mode == ole2frame->mode)
      pass ();
    else
      fail ("OLE2FRAME.mode [BS] set+1 %hu != %hu", ole2frame->mode, mode);
    ole2frame->mode--;
  }
  {
    BITCODE_TF oleclient;
    if (dwg_dynapi_entity_value (ole2frame, "OLE2FRAME", "oleclient", &oleclient, NULL)
        && !memcmp (&oleclient, &ole2frame->oleclient, sizeof (BITCODE_TF)))
        pass ();
    else
        fail ("OLE2FRAME.oleclient [TF]");
  }
  {
    BITCODE_BS oleversion;
    if (dwg_dynapi_entity_value (ole2frame, "OLE2FRAME", "oleversion", &oleversion, NULL)
        && oleversion == ole2frame->oleversion)
      pass ();
    else
      fail ("OLE2FRAME.oleversion [BS] %hu != %hu", ole2frame->oleversion, oleversion);
    oleversion++;
    if (dwg_dynapi_entity_set_value (ole2frame, "OLE2FRAME", "oleversion", &oleversion, 0)
        && oleversion == ole2frame->oleversion)
      pass ();
    else
      fail ("OLE2FRAME.oleversion [BS] set+1 %hu != %hu", ole2frame->oleversion, oleversion);
    ole2frame->oleversion--;
  }
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value (ole2frame, "OLE2FRAME", "parent", &parent, NULL)
        && !memcmp (&parent, &ole2frame->parent, sizeof (struct _dwg_object_entity*)))
        pass ();
    else
        fail ("OLE2FRAME.parent [struct _dwg_object_entity*]");
  }
  {
    BITCODE_3BD pt1;
    if (dwg_dynapi_entity_value (ole2frame, "OLE2FRAME", "pt1", &pt1, NULL)
        && !memcmp (&pt1, &ole2frame->pt1, sizeof (BITCODE_3BD)))
        pass ();
    else
        fail ("OLE2FRAME.pt1 [3BD]");
  }
  {
    BITCODE_3BD pt2;
    if (dwg_dynapi_entity_value (ole2frame, "OLE2FRAME", "pt2", &pt2, NULL)
        && !memcmp (&pt2, &ole2frame->pt2, sizeof (BITCODE_3BD)))
        pass ();
    else
        fail ("OLE2FRAME.pt2 [3BD]");
  }
  {
    BITCODE_BS type;
    if (dwg_dynapi_entity_value (ole2frame, "OLE2FRAME", "type", &type, NULL)
        && type == ole2frame->type)
      pass ();
    else
      fail ("OLE2FRAME.type [BS] %hu != %hu", ole2frame->type, type);
    type++;
    if (dwg_dynapi_entity_set_value (ole2frame, "OLE2FRAME", "type", &type, 0)
        && type == ole2frame->type)
      pass ();
    else
      fail ("OLE2FRAME.type [BS] set+1 %hu != %hu", ole2frame->type, type);
    ole2frame->type--;
  }
  if (failed && (is_class_unstable ("OLE2FRAME") || is_class_debugging ("OLE2FRAME")))
    {
      ok ("%s failed %d tests (TODO unstable)", "OLE2FRAME", failed);
      failed = 0;
    }
  return failed;
}
static int test_OLEFRAME (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_OLEFRAME *restrict oleframe = obj->tio.entity->tio.OLEFRAME;
  failed = 0;
  {
    BITCODE_TF data;
    if (dwg_dynapi_entity_value (oleframe, "OLEFRAME", "data", &data, NULL)
        && !memcmp (&data, &oleframe->data, sizeof (BITCODE_TF)))
        pass ();
    else
        fail ("OLEFRAME.data [TF]");
  }
  {
    BITCODE_BL data_size;
    if (dwg_dynapi_entity_value (oleframe, "OLEFRAME", "data_size", &data_size, NULL)
        && data_size == oleframe->data_size)
      pass ();
    else
      fail ("OLEFRAME.data_size [BL] %u != %u", oleframe->data_size, data_size);
    data_size++;
    if (dwg_dynapi_entity_set_value (oleframe, "OLEFRAME", "data_size", &data_size, 0)
        && data_size == oleframe->data_size)
      pass ();
    else
      fail ("OLEFRAME.data_size [BL] set+1 %u != %u", oleframe->data_size, data_size);
    oleframe->data_size--;
  }
  {
    BITCODE_BS flag;
    if (dwg_dynapi_entity_value (oleframe, "OLEFRAME", "flag", &flag, NULL)
        && flag == oleframe->flag)
      pass ();
    else
      fail ("OLEFRAME.flag [BS] %hu != %hu", oleframe->flag, flag);
    flag++;
    if (dwg_dynapi_entity_set_value (oleframe, "OLEFRAME", "flag", &flag, 0)
        && flag == oleframe->flag)
      pass ();
    else
      fail ("OLEFRAME.flag [BS] set+1 %hu != %hu", oleframe->flag, flag);
    oleframe->flag--;
  }
  {
    BITCODE_BS mode;
    if (dwg_dynapi_entity_value (oleframe, "OLEFRAME", "mode", &mode, NULL)
        && mode == oleframe->mode)
      pass ();
    else
      fail ("OLEFRAME.mode [BS] %hu != %hu", oleframe->mode, mode);
    mode++;
    if (dwg_dynapi_entity_set_value (oleframe, "OLEFRAME", "mode", &mode, 0)
        && mode == oleframe->mode)
      pass ();
    else
      fail ("OLEFRAME.mode [BS] set+1 %hu != %hu", oleframe->mode, mode);
    oleframe->mode--;
  }
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value (oleframe, "OLEFRAME", "parent", &parent, NULL)
        && !memcmp (&parent, &oleframe->parent, sizeof (struct _dwg_object_entity*)))
        pass ();
    else
        fail ("OLEFRAME.parent [struct _dwg_object_entity*]");
  }
  if (failed && (is_class_unstable ("OLEFRAME") || is_class_debugging ("OLEFRAME")))
    {
      ok ("%s failed %d tests (TODO unstable)", "OLEFRAME", failed);
      failed = 0;
    }
  return failed;
}
static int test_PLANESURFACE (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_PLANESURFACE *restrict planesurface = obj->tio.entity->tio.PLANESURFACE;
  failed = 0;
  {
    BITCODE_B _dxf_sab_converted;
    if (dwg_dynapi_entity_value (planesurface, "PLANESURFACE", "_dxf_sab_converted", &_dxf_sab_converted, NULL)
        && _dxf_sab_converted == planesurface->_dxf_sab_converted)
      pass ();
    else
      fail ("PLANESURFACE._dxf_sab_converted [B] " FORMAT_B " != " FORMAT_B "", planesurface->_dxf_sab_converted, _dxf_sab_converted);
    _dxf_sab_converted++;
    if (dwg_dynapi_entity_set_value (planesurface, "PLANESURFACE", "_dxf_sab_converted", &_dxf_sab_converted, 0)
        && _dxf_sab_converted == planesurface->_dxf_sab_converted)
      pass ();
    else
      fail ("PLANESURFACE._dxf_sab_converted [B] set+1 " FORMAT_B " != " FORMAT_B "", planesurface->_dxf_sab_converted, _dxf_sab_converted);
    planesurface->_dxf_sab_converted--;
  }
  {
    BITCODE_RC* acis_data;
    if (dwg_dynapi_entity_value (planesurface, "PLANESURFACE", "acis_data", &acis_data, NULL)
        && acis_data
           ? strEQ ((char *)acis_data, (char *)planesurface->acis_data)
           : !planesurface->acis_data)
      pass ();
    else
      fail ("PLANESURFACE.acis_data [RC*] '%s' <> '%s'", acis_data, planesurface->acis_data);
  }
  {
    BITCODE_B acis_empty;
    if (dwg_dynapi_entity_value (planesurface, "PLANESURFACE", "acis_empty", &acis_empty, NULL)
        && acis_empty == planesurface->acis_empty)
      pass ();
    else
      fail ("PLANESURFACE.acis_empty [B] " FORMAT_B " != " FORMAT_B "", planesurface->acis_empty, acis_empty);
    acis_empty++;
    if (dwg_dynapi_entity_set_value (planesurface, "PLANESURFACE", "acis_empty", &acis_empty, 0)
        && acis_empty == planesurface->acis_empty)
      pass ();
    else
      fail ("PLANESURFACE.acis_empty [B] set+1 " FORMAT_B " != " FORMAT_B "", planesurface->acis_empty, acis_empty);
    planesurface->acis_empty--;
  }
  {
    BITCODE_B acis_empty2;
    if (dwg_dynapi_entity_value (planesurface, "PLANESURFACE", "acis_empty2", &acis_empty2, NULL)
        && acis_empty2 == planesurface->acis_empty2)
      pass ();
    else
      fail ("PLANESURFACE.acis_empty2 [B] " FORMAT_B " != " FORMAT_B "", planesurface->acis_empty2, acis_empty2);
    acis_empty2++;
    if (dwg_dynapi_entity_set_value (planesurface, "PLANESURFACE", "acis_empty2", &acis_empty2, 0)
        && acis_empty2 == planesurface->acis_empty2)
      pass ();
    else
      fail ("PLANESURFACE.acis_empty2 [B] set+1 " FORMAT_B " != " FORMAT_B "", planesurface->acis_empty2, acis_empty2);
    planesurface->acis_empty2--;
  }
  {
    BITCODE_B acis_empty_bit;
    if (dwg_dynapi_entity_value (planesurface, "PLANESURFACE", "acis_empty_bit", &acis_empty_bit, NULL)
        && acis_empty_bit == planesurface->acis_empty_bit)
      pass ();
    else
      fail ("PLANESURFACE.acis_empty_bit [B] " FORMAT_B " != " FORMAT_B "", planesurface->acis_empty_bit, acis_empty_bit);
    acis_empty_bit++;
    if (dwg_dynapi_entity_set_value (planesurface, "PLANESURFACE", "acis_empty_bit", &acis_empty_bit, 0)
        && acis_empty_bit == planesurface->acis_empty_bit)
      pass ();
    else
      fail ("PLANESURFACE.acis_empty_bit [B] set+1 " FORMAT_B " != " FORMAT_B "", planesurface->acis_empty_bit, acis_empty_bit);
    planesurface->acis_empty_bit--;
  }
  {
    BITCODE_BL* block_size;
    if (dwg_dynapi_entity_value (planesurface, "PLANESURFACE", "block_size", &block_size, NULL)
        && !memcmp (&block_size, &planesurface->block_size, sizeof (BITCODE_BL*)))
        pass ();
    else
        fail ("PLANESURFACE.block_size [BL*]");
  }
  {
    BITCODE_BL class_version;
    if (dwg_dynapi_entity_value (planesurface, "PLANESURFACE", "class_version", &class_version, NULL)
        && class_version == planesurface->class_version)
      pass ();
    else
      fail ("PLANESURFACE.class_version [BL] %u != %u", planesurface->class_version, class_version);
    class_version++;
    if (dwg_dynapi_entity_set_value (planesurface, "PLANESURFACE", "class_version", &class_version, 0)
        && class_version == planesurface->class_version)
      pass ();
    else
      fail ("PLANESURFACE.class_version [BL] set+1 %u != %u", planesurface->class_version, class_version);
    planesurface->class_version--;
  }
  {
    char ** encr_sat_data;
    if (dwg_dynapi_entity_value (planesurface, "PLANESURFACE", "encr_sat_data", &encr_sat_data, NULL)
        && !memcmp (&encr_sat_data, &planesurface->encr_sat_data, sizeof (planesurface->encr_sat_data)))
      pass ();
    else
      fail ("PLANESURFACE.encr_sat_data [char **]");
  }
  {
    BITCODE_BL end_marker;
    if (dwg_dynapi_entity_value (planesurface, "PLANESURFACE", "end_marker", &end_marker, NULL)
        && end_marker == planesurface->end_marker)
      pass ();
    else
      fail ("PLANESURFACE.end_marker [BL] %u != %u", planesurface->end_marker, end_marker);
    end_marker++;
    if (dwg_dynapi_entity_set_value (planesurface, "PLANESURFACE", "end_marker", &end_marker, 0)
        && end_marker == planesurface->end_marker)
      pass ();
    else
      fail ("PLANESURFACE.end_marker [BL] set+1 %u != %u", planesurface->end_marker, end_marker);
    planesurface->end_marker--;
  }
  {
    struct _dwg_entity_3DSOLID* extra_acis_data;
    if (dwg_dynapi_entity_value (planesurface, "PLANESURFACE", "extra_acis_data", &extra_acis_data, NULL)
        && !memcmp (&extra_acis_data, &planesurface->extra_acis_data, sizeof (struct _dwg_entity_3DSOLID*)))
        pass ();
    else
        fail ("PLANESURFACE.extra_acis_data [struct _dwg_entity_3DSOLID*]");
  }
  {
    BITCODE_B has_revision_guid;
    if (dwg_dynapi_entity_value (planesurface, "PLANESURFACE", "has_revision_guid", &has_revision_guid, NULL)
        && has_revision_guid == planesurface->has_revision_guid)
      pass ();
    else
      fail ("PLANESURFACE.has_revision_guid [B] " FORMAT_B " != " FORMAT_B "", planesurface->has_revision_guid, has_revision_guid);
    has_revision_guid++;
    if (dwg_dynapi_entity_set_value (planesurface, "PLANESURFACE", "has_revision_guid", &has_revision_guid, 0)
        && has_revision_guid == planesurface->has_revision_guid)
      pass ();
    else
      fail ("PLANESURFACE.has_revision_guid [B] set+1 " FORMAT_B " != " FORMAT_B "", planesurface->has_revision_guid, has_revision_guid);
    planesurface->has_revision_guid--;
  }
  {
    BITCODE_H history_id;
    if (dwg_dynapi_entity_value (planesurface, "PLANESURFACE", "history_id", &history_id, NULL)
        && !memcmp (&history_id, &planesurface->history_id, sizeof (BITCODE_H)))
        pass ();
    else
        fail ("PLANESURFACE.history_id [H]");
  }
  {
    BITCODE_B isoline_present;
    if (dwg_dynapi_entity_value (planesurface, "PLANESURFACE", "isoline_present", &isoline_present, NULL)
        && isoline_present == planesurface->isoline_present)
      pass ();
    else
      fail ("PLANESURFACE.isoline_present [B] " FORMAT_B " != " FORMAT_B "", planesurface->isoline_present, isoline_present);
    isoline_present++;
    if (dwg_dynapi_entity_set_value (planesurface, "PLANESURFACE", "isoline_present", &isoline_present, 0)
        && isoline_present == planesurface->isoline_present)
      pass ();
    else
      fail ("PLANESURFACE.isoline_present [B] set+1 " FORMAT_B " != " FORMAT_B "", planesurface->isoline_present, isoline_present);
    planesurface->isoline_present--;
  }
  {
    BITCODE_BL isolines;
    if (dwg_dynapi_entity_value (planesurface, "PLANESURFACE", "isolines", &isolines, NULL)
        && isolines == planesurface->isolines)
      pass ();
    else
      fail ("PLANESURFACE.isolines [BL] %u != %u", planesurface->isolines, isolines);
    isolines++;
    if (dwg_dynapi_entity_set_value (planesurface, "PLANESURFACE", "isolines", &isolines, 0)
        && isolines == planesurface->isolines)
      pass ();
    else
      fail ("PLANESURFACE.isolines [BL] set+1 %u != %u", planesurface->isolines, isolines);
    planesurface->isolines--;
  }
  {
    Dwg_3DSOLID_material* materials;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (planesurface, "PLANESURFACE", "num_materials", &count, NULL)
        && dwg_dynapi_entity_value (planesurface, "PLANESURFACE", "materials", &materials, NULL)
        && materials == planesurface->materials)
      pass ();
    else
      fail ("PLANESURFACE.materials [Dwg_3DSOLID_material*] * %u num_materials", count);
  }
  {
    BITCODE_BS modeler_format_version;
    if (dwg_dynapi_entity_value (planesurface, "PLANESURFACE", "modeler_format_version", &modeler_format_version, NULL)
        && modeler_format_version == planesurface->modeler_format_version)
      pass ();
    else
      fail ("PLANESURFACE.modeler_format_version [BS] %hu != %hu", planesurface->modeler_format_version, modeler_format_version);
    modeler_format_version++;
    if (dwg_dynapi_entity_set_value (planesurface, "PLANESURFACE", "modeler_format_version", &modeler_format_version, 0)
        && modeler_format_version == planesurface->modeler_format_version)
      pass ();
    else
      fail ("PLANESURFACE.modeler_format_version [BS] set+1 %hu != %hu", planesurface->modeler_format_version, modeler_format_version);
    planesurface->modeler_format_version--;
  }
  {
    BITCODE_BL num_blocks;
    if (dwg_dynapi_entity_value (planesurface, "PLANESURFACE", "num_blocks", &num_blocks, NULL)
        && num_blocks == planesurface->num_blocks)
      pass ();
    else
      fail ("PLANESURFACE.num_blocks [BL] %u != %u", planesurface->num_blocks, num_blocks);
    num_blocks++;
    if (dwg_dynapi_entity_set_value (planesurface, "PLANESURFACE", "num_blocks", &num_blocks, 0)
        && num_blocks == planesurface->num_blocks)
      pass ();
    else
      fail ("PLANESURFACE.num_blocks [BL] set+1 %u != %u", planesurface->num_blocks, num_blocks);
    planesurface->num_blocks--;
  }
  {
    BITCODE_BL num_materials;
    if (dwg_dynapi_entity_value (planesurface, "PLANESURFACE", "num_materials", &num_materials, NULL)
        && num_materials == planesurface->num_materials)
      pass ();
    else
      fail ("PLANESURFACE.num_materials [BL] %u != %u", planesurface->num_materials, num_materials);
    num_materials++;
    if (dwg_dynapi_entity_set_value (planesurface, "PLANESURFACE", "num_materials", &num_materials, 0)
        && num_materials == planesurface->num_materials)
      pass ();
    else
      fail ("PLANESURFACE.num_materials [BL] set+1 %u != %u", planesurface->num_materials, num_materials);
    planesurface->num_materials--;
  }
  {
    BITCODE_BL num_silhouettes;
    if (dwg_dynapi_entity_value (planesurface, "PLANESURFACE", "num_silhouettes", &num_silhouettes, NULL)
        && num_silhouettes == planesurface->num_silhouettes)
      pass ();
    else
      fail ("PLANESURFACE.num_silhouettes [BL] %u != %u", planesurface->num_silhouettes, num_silhouettes);
    num_silhouettes++;
    if (dwg_dynapi_entity_set_value (planesurface, "PLANESURFACE", "num_silhouettes", &num_silhouettes, 0)
        && num_silhouettes == planesurface->num_silhouettes)
      pass ();
    else
      fail ("PLANESURFACE.num_silhouettes [BL] set+1 %u != %u", planesurface->num_silhouettes, num_silhouettes);
    planesurface->num_silhouettes--;
  }
  {
    BITCODE_BL num_wires;
    if (dwg_dynapi_entity_value (planesurface, "PLANESURFACE", "num_wires", &num_wires, NULL)
        && num_wires == planesurface->num_wires)
      pass ();
    else
      fail ("PLANESURFACE.num_wires [BL] %u != %u", planesurface->num_wires, num_wires);
    num_wires++;
    if (dwg_dynapi_entity_set_value (planesurface, "PLANESURFACE", "num_wires", &num_wires, 0)
        && num_wires == planesurface->num_wires)
      pass ();
    else
      fail ("PLANESURFACE.num_wires [BL] set+1 %u != %u", planesurface->num_wires, num_wires);
    planesurface->num_wires--;
  }
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value (planesurface, "PLANESURFACE", "parent", &parent, NULL)
        && !memcmp (&parent, &planesurface->parent, sizeof (struct _dwg_object_entity*)))
        pass ();
    else
        fail ("PLANESURFACE.parent [struct _dwg_object_entity*]");
  }
  {
    BITCODE_3BD point;
    if (dwg_dynapi_entity_value (planesurface, "PLANESURFACE", "point", &point, NULL)
        && !memcmp (&point, &planesurface->point, sizeof (BITCODE_3BD)))
        pass ();
    else
        fail ("PLANESURFACE.point [3BD]");
  }
  {
    BITCODE_B point_present;
    if (dwg_dynapi_entity_value (planesurface, "PLANESURFACE", "point_present", &point_present, NULL)
        && point_present == planesurface->point_present)
      pass ();
    else
      fail ("PLANESURFACE.point_present [B] " FORMAT_B " != " FORMAT_B "", planesurface->point_present, point_present);
    point_present++;
    if (dwg_dynapi_entity_set_value (planesurface, "PLANESURFACE", "point_present", &point_present, 0)
        && point_present == planesurface->point_present)
      pass ();
    else
      fail ("PLANESURFACE.point_present [B] set+1 " FORMAT_B " != " FORMAT_B "", planesurface->point_present, point_present);
    planesurface->point_present--;
  }
  {
    BITCODE_RC revision_bytes[9];
    if (dwg_dynapi_entity_value (planesurface, "PLANESURFACE", "revision_bytes[9]", &revision_bytes, NULL)
        && !memcmp (&revision_bytes, &planesurface->revision_bytes, sizeof (BITCODE_RC)))
        pass ();
    else
        fail ("PLANESURFACE.revision_bytes[9] [RC]");
  }
  {
    BITCODE_RC revision_guid[39];
    if (dwg_dynapi_entity_value (planesurface, "PLANESURFACE", "revision_guid[39]", &revision_guid, NULL)
        && !memcmp (&revision_guid, &planesurface->revision_guid, sizeof (BITCODE_RC)))
        pass ();
    else
        fail ("PLANESURFACE.revision_guid[39] [RC]");
  }
  {
    BITCODE_BL revision_major;
    if (dwg_dynapi_entity_value (planesurface, "PLANESURFACE", "revision_major", &revision_major, NULL)
        && revision_major == planesurface->revision_major)
      pass ();
    else
      fail ("PLANESURFACE.revision_major [BL] %u != %u", planesurface->revision_major, revision_major);
    revision_major++;
    if (dwg_dynapi_entity_set_value (planesurface, "PLANESURFACE", "revision_major", &revision_major, 0)
        && revision_major == planesurface->revision_major)
      pass ();
    else
      fail ("PLANESURFACE.revision_major [BL] set+1 %u != %u", planesurface->revision_major, revision_major);
    planesurface->revision_major--;
  }
  {
    BITCODE_BS revision_minor1;
    if (dwg_dynapi_entity_value (planesurface, "PLANESURFACE", "revision_minor1", &revision_minor1, NULL)
        && revision_minor1 == planesurface->revision_minor1)
      pass ();
    else
      fail ("PLANESURFACE.revision_minor1 [BS] %hu != %hu", planesurface->revision_minor1, revision_minor1);
    revision_minor1++;
    if (dwg_dynapi_entity_set_value (planesurface, "PLANESURFACE", "revision_minor1", &revision_minor1, 0)
        && revision_minor1 == planesurface->revision_minor1)
      pass ();
    else
      fail ("PLANESURFACE.revision_minor1 [BS] set+1 %hu != %hu", planesurface->revision_minor1, revision_minor1);
    planesurface->revision_minor1--;
  }
  {
    BITCODE_BS revision_minor2;
    if (dwg_dynapi_entity_value (planesurface, "PLANESURFACE", "revision_minor2", &revision_minor2, NULL)
        && revision_minor2 == planesurface->revision_minor2)
      pass ();
    else
      fail ("PLANESURFACE.revision_minor2 [BS] %hu != %hu", planesurface->revision_minor2, revision_minor2);
    revision_minor2++;
    if (dwg_dynapi_entity_set_value (planesurface, "PLANESURFACE", "revision_minor2", &revision_minor2, 0)
        && revision_minor2 == planesurface->revision_minor2)
      pass ();
    else
      fail ("PLANESURFACE.revision_minor2 [BS] set+1 %hu != %hu", planesurface->revision_minor2, revision_minor2);
    planesurface->revision_minor2--;
  }
  {
    BITCODE_BL sab_size;
    if (dwg_dynapi_entity_value (planesurface, "PLANESURFACE", "sab_size", &sab_size, NULL)
        && sab_size == planesurface->sab_size)
      pass ();
    else
      fail ("PLANESURFACE.sab_size [BL] %u != %u", planesurface->sab_size, sab_size);
    sab_size++;
    if (dwg_dynapi_entity_set_value (planesurface, "PLANESURFACE", "sab_size", &sab_size, 0)
        && sab_size == planesurface->sab_size)
      pass ();
    else
      fail ("PLANESURFACE.sab_size [BL] set+1 %u != %u", planesurface->sab_size, sab_size);
    planesurface->sab_size--;
  }
  {
    Dwg_3DSOLID_silhouette* silhouettes;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (planesurface, "PLANESURFACE", "num_silhouettes", &count, NULL)
        && dwg_dynapi_entity_value (planesurface, "PLANESURFACE", "silhouettes", &silhouettes, NULL)
        && silhouettes == planesurface->silhouettes)
      pass ();
    else
      fail ("PLANESURFACE.silhouettes [Dwg_3DSOLID_silhouette*] * %u num_silhouettes", count);
  }
  {
    BITCODE_BS u_isolines;
    if (dwg_dynapi_entity_value (planesurface, "PLANESURFACE", "u_isolines", &u_isolines, NULL)
        && u_isolines == planesurface->u_isolines)
      pass ();
    else
      fail ("PLANESURFACE.u_isolines [BS] %hu != %hu", planesurface->u_isolines, u_isolines);
    u_isolines++;
    if (dwg_dynapi_entity_set_value (planesurface, "PLANESURFACE", "u_isolines", &u_isolines, 0)
        && u_isolines == planesurface->u_isolines)
      pass ();
    else
      fail ("PLANESURFACE.u_isolines [BS] set+1 %hu != %hu", planesurface->u_isolines, u_isolines);
    planesurface->u_isolines--;
  }
  {
    BITCODE_B unknown;
    if (dwg_dynapi_entity_value (planesurface, "PLANESURFACE", "unknown", &unknown, NULL)
        && unknown == planesurface->unknown)
      pass ();
    else
      fail ("PLANESURFACE.unknown [B] " FORMAT_B " != " FORMAT_B "", planesurface->unknown, unknown);
    unknown++;
    if (dwg_dynapi_entity_set_value (planesurface, "PLANESURFACE", "unknown", &unknown, 0)
        && unknown == planesurface->unknown)
      pass ();
    else
      fail ("PLANESURFACE.unknown [B] set+1 " FORMAT_B " != " FORMAT_B "", planesurface->unknown, unknown);
    planesurface->unknown--;
  }
  {
    BITCODE_BS v_isolines;
    if (dwg_dynapi_entity_value (planesurface, "PLANESURFACE", "v_isolines", &v_isolines, NULL)
        && v_isolines == planesurface->v_isolines)
      pass ();
    else
      fail ("PLANESURFACE.v_isolines [BS] %hu != %hu", planesurface->v_isolines, v_isolines);
    v_isolines++;
    if (dwg_dynapi_entity_set_value (planesurface, "PLANESURFACE", "v_isolines", &v_isolines, 0)
        && v_isolines == planesurface->v_isolines)
      pass ();
    else
      fail ("PLANESURFACE.v_isolines [BS] set+1 %hu != %hu", planesurface->v_isolines, v_isolines);
    planesurface->v_isolines--;
  }
  {
    BITCODE_BS version;
    if (dwg_dynapi_entity_value (planesurface, "PLANESURFACE", "version", &version, NULL)
        && version == planesurface->version)
      pass ();
    else
      fail ("PLANESURFACE.version [BS] %hu != %hu", planesurface->version, version);
    version++;
    if (dwg_dynapi_entity_set_value (planesurface, "PLANESURFACE", "version", &version, 0)
        && version == planesurface->version)
      pass ();
    else
      fail ("PLANESURFACE.version [BS] set+1 %hu != %hu", planesurface->version, version);
    planesurface->version--;
  }
  {
    BITCODE_B wireframe_data_present;
    if (dwg_dynapi_entity_value (planesurface, "PLANESURFACE", "wireframe_data_present", &wireframe_data_present, NULL)
        && wireframe_data_present == planesurface->wireframe_data_present)
      pass ();
    else
      fail ("PLANESURFACE.wireframe_data_present [B] " FORMAT_B " != " FORMAT_B "", planesurface->wireframe_data_present, wireframe_data_present);
    wireframe_data_present++;
    if (dwg_dynapi_entity_set_value (planesurface, "PLANESURFACE", "wireframe_data_present", &wireframe_data_present, 0)
        && wireframe_data_present == planesurface->wireframe_data_present)
      pass ();
    else
      fail ("PLANESURFACE.wireframe_data_present [B] set+1 " FORMAT_B " != " FORMAT_B "", planesurface->wireframe_data_present, wireframe_data_present);
    planesurface->wireframe_data_present--;
  }
  {
    Dwg_3DSOLID_wire* wires;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (planesurface, "PLANESURFACE", "num_wires", &count, NULL)
        && dwg_dynapi_entity_value (planesurface, "PLANESURFACE", "wires", &wires, NULL)
        && wires == planesurface->wires)
      pass ();
    else
      fail ("PLANESURFACE.wires [Dwg_3DSOLID_wire*] * %u num_wires", count);
  }
  if (failed && (is_class_unstable ("PLANESURFACE") || is_class_debugging ("PLANESURFACE")))
    {
      ok ("%s failed %d tests (TODO unstable)", "PLANESURFACE", failed);
      failed = 0;
    }
  return failed;
}
static int test_POINT (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_POINT *restrict point = obj->tio.entity->tio.POINT;
  failed = 0;
  {
    BITCODE_BE extrusion;
    if (dwg_dynapi_entity_value (point, "POINT", "extrusion", &extrusion, NULL)
        && !memcmp (&extrusion, &point->extrusion, sizeof (BITCODE_BE)))
        pass ();
    else
        fail ("POINT.extrusion [BE]");
  }
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value (point, "POINT", "parent", &parent, NULL)
        && !memcmp (&parent, &point->parent, sizeof (struct _dwg_object_entity*)))
        pass ();
    else
        fail ("POINT.parent [struct _dwg_object_entity*]");
  }
  {
    BITCODE_BT thickness;
    if (dwg_dynapi_entity_value (point, "POINT", "thickness", &thickness, NULL)
        && thickness == point->thickness)
      pass ();
    else
      fail ("POINT.thickness [BT] " FORMAT_BT " != " FORMAT_BT "", point->thickness, thickness);
    if (dwg_dynapi_entity_set_value (point, "POINT", "thickness", &thickness, 0)
        && thickness == point->thickness)
      pass ();
    else
      fail ("POINT.thickness [BT] set+1 " FORMAT_BT " != " FORMAT_BT "", point->thickness, thickness);
    point->thickness--;
  }
  {
    BITCODE_BD x;
    if (dwg_dynapi_entity_value (point, "POINT", "x", &x, NULL)
        && x == point->x)
      pass ();
    else
      fail ("POINT.x [BD] %g != %g", point->x, x);
    x++;
    if (dwg_dynapi_entity_set_value (point, "POINT", "x", &x, 0)
        && x == point->x)
      pass ();
    else
      fail ("POINT.x [BD] set+1 %g != %g", point->x, x);
    point->x--;
  }
  {
    BITCODE_BD x_ang;
    if (dwg_dynapi_entity_value (point, "POINT", "x_ang", &x_ang, NULL)
        && x_ang == point->x_ang)
      pass ();
    else
      fail ("POINT.x_ang [BD] %g != %g", point->x_ang, x_ang);
    x_ang++;
    if (dwg_dynapi_entity_set_value (point, "POINT", "x_ang", &x_ang, 0)
        && x_ang == point->x_ang)
      pass ();
    else
      fail ("POINT.x_ang [BD] set+1 %g != %g", point->x_ang, x_ang);
    point->x_ang--;
  }
  {
    BITCODE_BD y;
    if (dwg_dynapi_entity_value (point, "POINT", "y", &y, NULL)
        && y == point->y)
      pass ();
    else
      fail ("POINT.y [BD] %g != %g", point->y, y);
    y++;
    if (dwg_dynapi_entity_set_value (point, "POINT", "y", &y, 0)
        && y == point->y)
      pass ();
    else
      fail ("POINT.y [BD] set+1 %g != %g", point->y, y);
    point->y--;
  }
  {
    BITCODE_BD z;
    if (dwg_dynapi_entity_value (point, "POINT", "z", &z, NULL)
        && z == point->z)
      pass ();
    else
      fail ("POINT.z [BD] %g != %g", point->z, z);
    z++;
    if (dwg_dynapi_entity_set_value (point, "POINT", "z", &z, 0)
        && z == point->z)
      pass ();
    else
      fail ("POINT.z [BD] set+1 %g != %g", point->z, z);
    point->z--;
  }
  if (failed && (is_class_unstable ("POINT") || is_class_debugging ("POINT")))
    {
      ok ("%s failed %d tests (TODO unstable)", "POINT", failed);
      failed = 0;
    }
  return failed;
}
static int test_POINTCLOUD (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_POINTCLOUD *restrict pointcloud = obj->tio.entity->tio.POINTCLOUD;
  failed = 0;
  {
    BITCODE_BS class_version;
    if (dwg_dynapi_entity_value (pointcloud, "POINTCLOUD", "class_version", &class_version, NULL)
        && class_version == pointcloud->class_version)
      pass ();
    else
      fail ("POINTCLOUD.class_version [BS] %hu != %hu", pointcloud->class_version, class_version);
    class_version++;
    if (dwg_dynapi_entity_set_value (pointcloud, "POINTCLOUD", "class_version", &class_version, 0)
        && class_version == pointcloud->class_version)
      pass ();
    else
      fail ("POINTCLOUD.class_version [BS] set+1 %hu != %hu", pointcloud->class_version, class_version);
    pointcloud->class_version--;
  }
  {
    Dwg_POINTCLOUD_Clippings* clippings;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (pointcloud, "POINTCLOUD", "num_clippings", &count, NULL)
        && dwg_dynapi_entity_value (pointcloud, "POINTCLOUD", "clippings", &clippings, NULL)
        && clippings == pointcloud->clippings)
      pass ();
    else
      fail ("POINTCLOUD.clippings [Dwg_POINTCLOUD_Clippings*] * %u num_clippings", count);
  }
  {
    BITCODE_3BD extents_max;
    if (dwg_dynapi_entity_value (pointcloud, "POINTCLOUD", "extents_max", &extents_max, NULL)
        && !memcmp (&extents_max, &pointcloud->extents_max, sizeof (BITCODE_3BD)))
        pass ();
    else
        fail ("POINTCLOUD.extents_max [3BD]");
  }
  {
    BITCODE_3BD extents_min;
    if (dwg_dynapi_entity_value (pointcloud, "POINTCLOUD", "extents_min", &extents_min, NULL)
        && !memcmp (&extents_min, &pointcloud->extents_min, sizeof (BITCODE_3BD)))
        pass ();
    else
        fail ("POINTCLOUD.extents_min [3BD]");
  }
  {
    BITCODE_BS intensity_scheme;
    if (dwg_dynapi_entity_value (pointcloud, "POINTCLOUD", "intensity_scheme", &intensity_scheme, NULL)
        && intensity_scheme == pointcloud->intensity_scheme)
      pass ();
    else
      fail ("POINTCLOUD.intensity_scheme [BS] %hu != %hu", pointcloud->intensity_scheme, intensity_scheme);
    intensity_scheme++;
    if (dwg_dynapi_entity_set_value (pointcloud, "POINTCLOUD", "intensity_scheme", &intensity_scheme, 0)
        && intensity_scheme == pointcloud->intensity_scheme)
      pass ();
    else
      fail ("POINTCLOUD.intensity_scheme [BS] set+1 %hu != %hu", pointcloud->intensity_scheme, intensity_scheme);
    pointcloud->intensity_scheme--;
  }
  {
    Dwg_POINTCLOUD_IntensityStyle intensity_style;
    if (dwg_dynapi_entity_value (pointcloud, "POINTCLOUD", "intensity_style", &intensity_style, NULL)
        && !memcmp (&intensity_style, &pointcloud->intensity_style, sizeof (Dwg_POINTCLOUD_IntensityStyle)))
        pass ();
    else
        fail ("POINTCLOUD.intensity_style [Dwg_POINTCLOUD_IntensityStyle]");
  }
  {
    BITCODE_BL num_clippings;
    if (dwg_dynapi_entity_value (pointcloud, "POINTCLOUD", "num_clippings", &num_clippings, NULL)
        && num_clippings == pointcloud->num_clippings)
      pass ();
    else
      fail ("POINTCLOUD.num_clippings [BL] %u != %u", pointcloud->num_clippings, num_clippings);
    num_clippings++;
    if (dwg_dynapi_entity_set_value (pointcloud, "POINTCLOUD", "num_clippings", &num_clippings, 0)
        && num_clippings == pointcloud->num_clippings)
      pass ();
    else
      fail ("POINTCLOUD.num_clippings [BL] set+1 %u != %u", pointcloud->num_clippings, num_clippings);
    pointcloud->num_clippings--;
  }
  {
    BITCODE_BL num_source_files;
    if (dwg_dynapi_entity_value (pointcloud, "POINTCLOUD", "num_source_files", &num_source_files, NULL)
        && num_source_files == pointcloud->num_source_files)
      pass ();
    else
      fail ("POINTCLOUD.num_source_files [BL] %u != %u", pointcloud->num_source_files, num_source_files);
    num_source_files++;
    if (dwg_dynapi_entity_set_value (pointcloud, "POINTCLOUD", "num_source_files", &num_source_files, 0)
        && num_source_files == pointcloud->num_source_files)
      pass ();
    else
      fail ("POINTCLOUD.num_source_files [BL] set+1 %u != %u", pointcloud->num_source_files, num_source_files);
    pointcloud->num_source_files--;
  }
  {
    BITCODE_RLL numpoints;
    if (dwg_dynapi_entity_value (pointcloud, "POINTCLOUD", "numpoints", &numpoints, NULL)
        && numpoints == pointcloud->numpoints)
      pass ();
    else
      fail ("POINTCLOUD.numpoints [RLL] " FORMAT_RLL " != " FORMAT_RLL "", pointcloud->numpoints, numpoints);
    numpoints++;
    if (dwg_dynapi_entity_set_value (pointcloud, "POINTCLOUD", "numpoints", &numpoints, 0)
        && numpoints == pointcloud->numpoints)
      pass ();
    else
      fail ("POINTCLOUD.numpoints [RLL] set+1 " FORMAT_RLL " != " FORMAT_RLL "", pointcloud->numpoints, numpoints);
    pointcloud->numpoints--;
  }
  {
    BITCODE_3BD origin;
    if (dwg_dynapi_entity_value (pointcloud, "POINTCLOUD", "origin", &origin, NULL)
        && !memcmp (&origin, &pointcloud->origin, sizeof (BITCODE_3BD)))
        pass ();
    else
        fail ("POINTCLOUD.origin [3BD]");
  }
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value (pointcloud, "POINTCLOUD", "parent", &parent, NULL)
        && !memcmp (&parent, &pointcloud->parent, sizeof (struct _dwg_object_entity*)))
        pass ();
    else
        fail ("POINTCLOUD.parent [struct _dwg_object_entity*]");
  }
  {
    BITCODE_H pointclouddef;
    if (dwg_dynapi_entity_value (pointcloud, "POINTCLOUD", "pointclouddef", &pointclouddef, NULL)
        && !memcmp (&pointclouddef, &pointcloud->pointclouddef, sizeof (BITCODE_H)))
        pass ();
    else
        fail ("POINTCLOUD.pointclouddef [H]");
  }
  {
    BITCODE_H reactor;
    if (dwg_dynapi_entity_value (pointcloud, "POINTCLOUD", "reactor", &reactor, NULL)
        && !memcmp (&reactor, &pointcloud->reactor, sizeof (BITCODE_H)))
        pass ();
    else
        fail ("POINTCLOUD.reactor [H]");
  }
  {
    BITCODE_T saved_filename;
    if (dwg_dynapi_entity_value (pointcloud, "POINTCLOUD", "saved_filename", &saved_filename, NULL)
        && saved_filename
           ? strEQ ((char *)saved_filename, (char *)pointcloud->saved_filename)
           : !pointcloud->saved_filename)
      pass ();
    else
      fail ("POINTCLOUD.saved_filename [T] '%s' <> '%s'", saved_filename, pointcloud->saved_filename);
  }
  {
    BITCODE_B show_clipping;
    if (dwg_dynapi_entity_value (pointcloud, "POINTCLOUD", "show_clipping", &show_clipping, NULL)
        && show_clipping == pointcloud->show_clipping)
      pass ();
    else
      fail ("POINTCLOUD.show_clipping [B] " FORMAT_B " != " FORMAT_B "", pointcloud->show_clipping, show_clipping);
    show_clipping++;
    if (dwg_dynapi_entity_set_value (pointcloud, "POINTCLOUD", "show_clipping", &show_clipping, 0)
        && show_clipping == pointcloud->show_clipping)
      pass ();
    else
      fail ("POINTCLOUD.show_clipping [B] set+1 " FORMAT_B " != " FORMAT_B "", pointcloud->show_clipping, show_clipping);
    pointcloud->show_clipping--;
  }
  {
    BITCODE_B show_intensity;
    if (dwg_dynapi_entity_value (pointcloud, "POINTCLOUD", "show_intensity", &show_intensity, NULL)
        && show_intensity == pointcloud->show_intensity)
      pass ();
    else
      fail ("POINTCLOUD.show_intensity [B] " FORMAT_B " != " FORMAT_B "", pointcloud->show_intensity, show_intensity);
    show_intensity++;
    if (dwg_dynapi_entity_set_value (pointcloud, "POINTCLOUD", "show_intensity", &show_intensity, 0)
        && show_intensity == pointcloud->show_intensity)
      pass ();
    else
      fail ("POINTCLOUD.show_intensity [B] set+1 " FORMAT_B " != " FORMAT_B "", pointcloud->show_intensity, show_intensity);
    pointcloud->show_intensity--;
  }
  {
    BITCODE_TV* source_files;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (pointcloud, "POINTCLOUD", "num_source_files", &count, NULL)
        && dwg_dynapi_entity_value (pointcloud, "POINTCLOUD", "source_files", &source_files, NULL)
        && source_files == pointcloud->source_files)
      pass ();
    else
      fail ("POINTCLOUD.source_files [TV*] * %u num_source_files", count);
  }
  {
    BITCODE_T ucs_name;
    if (dwg_dynapi_entity_value (pointcloud, "POINTCLOUD", "ucs_name", &ucs_name, NULL)
        && ucs_name
           ? strEQ ((char *)ucs_name, (char *)pointcloud->ucs_name)
           : !pointcloud->ucs_name)
      pass ();
    else
      fail ("POINTCLOUD.ucs_name [T] '%s' <> '%s'", ucs_name, pointcloud->ucs_name);
  }
  {
    BITCODE_3BD ucs_origin;
    if (dwg_dynapi_entity_value (pointcloud, "POINTCLOUD", "ucs_origin", &ucs_origin, NULL)
        && !memcmp (&ucs_origin, &pointcloud->ucs_origin, sizeof (BITCODE_3BD)))
        pass ();
    else
        fail ("POINTCLOUD.ucs_origin [3BD]");
  }
  {
    BITCODE_3BD ucs_x_dir;
    if (dwg_dynapi_entity_value (pointcloud, "POINTCLOUD", "ucs_x_dir", &ucs_x_dir, NULL)
        && !memcmp (&ucs_x_dir, &pointcloud->ucs_x_dir, sizeof (BITCODE_3BD)))
        pass ();
    else
        fail ("POINTCLOUD.ucs_x_dir [3BD]");
  }
  {
    BITCODE_3BD ucs_y_dir;
    if (dwg_dynapi_entity_value (pointcloud, "POINTCLOUD", "ucs_y_dir", &ucs_y_dir, NULL)
        && !memcmp (&ucs_y_dir, &pointcloud->ucs_y_dir, sizeof (BITCODE_3BD)))
        pass ();
    else
        fail ("POINTCLOUD.ucs_y_dir [3BD]");
  }
  {
    BITCODE_3BD ucs_z_dir;
    if (dwg_dynapi_entity_value (pointcloud, "POINTCLOUD", "ucs_z_dir", &ucs_z_dir, NULL)
        && !memcmp (&ucs_z_dir, &pointcloud->ucs_z_dir, sizeof (BITCODE_3BD)))
        pass ();
    else
        fail ("POINTCLOUD.ucs_z_dir [3BD]");
  }
  if (failed && (is_class_unstable ("POINTCLOUD") || is_class_debugging ("POINTCLOUD")))
    {
      ok ("%s failed %d tests (TODO unstable)", "POINTCLOUD", failed);
      failed = 0;
    }
  return failed;
}
static int test_POINTCLOUDEX (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_POINTCLOUDEX *restrict pointcloudex = obj->tio.entity->tio.POINTCLOUDEX;
  failed = 0;
  {
    BITCODE_BS class_version;
    if (dwg_dynapi_entity_value (pointcloudex, "POINTCLOUDEX", "class_version", &class_version, NULL)
        && class_version == pointcloudex->class_version)
      pass ();
    else
      fail ("POINTCLOUDEX.class_version [BS] %hu != %hu", pointcloudex->class_version, class_version);
    class_version++;
    if (dwg_dynapi_entity_set_value (pointcloudex, "POINTCLOUDEX", "class_version", &class_version, 0)
        && class_version == pointcloudex->class_version)
      pass ();
    else
      fail ("POINTCLOUDEX.class_version [BS] set+1 %hu != %hu", pointcloudex->class_version, class_version);
    pointcloudex->class_version--;
  }
  {
    BITCODE_T classification_colorscheme;
    if (dwg_dynapi_entity_value (pointcloudex, "POINTCLOUDEX", "classification_colorscheme", &classification_colorscheme, NULL)
        && classification_colorscheme
           ? strEQ ((char *)classification_colorscheme, (char *)pointcloudex->classification_colorscheme)
           : !pointcloudex->classification_colorscheme)
      pass ();
    else
      fail ("POINTCLOUDEX.classification_colorscheme [T] '%s' <> '%s'", classification_colorscheme, pointcloudex->classification_colorscheme);
  }
  {
    Dwg_POINTCLOUDEX_Croppings* croppings;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (pointcloudex, "POINTCLOUDEX", "num_croppings", &count, NULL)
        && dwg_dynapi_entity_value (pointcloudex, "POINTCLOUDEX", "croppings", &croppings, NULL)
        && croppings == pointcloudex->croppings)
      pass ();
    else
      fail ("POINTCLOUDEX.croppings [Dwg_POINTCLOUDEX_Croppings*] * %u num_croppings", count);
  }
  {
    BITCODE_T cur_colorscheme;
    if (dwg_dynapi_entity_value (pointcloudex, "POINTCLOUDEX", "cur_colorscheme", &cur_colorscheme, NULL)
        && cur_colorscheme
           ? strEQ ((char *)cur_colorscheme, (char *)pointcloudex->cur_colorscheme)
           : !pointcloudex->cur_colorscheme)
      pass ();
    else
      fail ("POINTCLOUDEX.cur_colorscheme [T] '%s' <> '%s'", cur_colorscheme, pointcloudex->cur_colorscheme);
  }
  {
    BITCODE_B elevation_apply_to_fixed_range;
    if (dwg_dynapi_entity_value (pointcloudex, "POINTCLOUDEX", "elevation_apply_to_fixed_range", &elevation_apply_to_fixed_range, NULL)
        && elevation_apply_to_fixed_range == pointcloudex->elevation_apply_to_fixed_range)
      pass ();
    else
      fail ("POINTCLOUDEX.elevation_apply_to_fixed_range [B] " FORMAT_B " != " FORMAT_B "", pointcloudex->elevation_apply_to_fixed_range, elevation_apply_to_fixed_range);
    elevation_apply_to_fixed_range++;
    if (dwg_dynapi_entity_set_value (pointcloudex, "POINTCLOUDEX", "elevation_apply_to_fixed_range", &elevation_apply_to_fixed_range, 0)
        && elevation_apply_to_fixed_range == pointcloudex->elevation_apply_to_fixed_range)
      pass ();
    else
      fail ("POINTCLOUDEX.elevation_apply_to_fixed_range [B] set+1 " FORMAT_B " != " FORMAT_B "", pointcloudex->elevation_apply_to_fixed_range, elevation_apply_to_fixed_range);
    pointcloudex->elevation_apply_to_fixed_range--;
  }
  {
    BITCODE_B elevation_as_gradient;
    if (dwg_dynapi_entity_value (pointcloudex, "POINTCLOUDEX", "elevation_as_gradient", &elevation_as_gradient, NULL)
        && elevation_as_gradient == pointcloudex->elevation_as_gradient)
      pass ();
    else
      fail ("POINTCLOUDEX.elevation_as_gradient [B] " FORMAT_B " != " FORMAT_B "", pointcloudex->elevation_as_gradient, elevation_as_gradient);
    elevation_as_gradient++;
    if (dwg_dynapi_entity_set_value (pointcloudex, "POINTCLOUDEX", "elevation_as_gradient", &elevation_as_gradient, 0)
        && elevation_as_gradient == pointcloudex->elevation_as_gradient)
      pass ();
    else
      fail ("POINTCLOUDEX.elevation_as_gradient [B] set+1 " FORMAT_B " != " FORMAT_B "", pointcloudex->elevation_as_gradient, elevation_as_gradient);
    pointcloudex->elevation_as_gradient--;
  }
  {
    BITCODE_BD elevation_max;
    if (dwg_dynapi_entity_value (pointcloudex, "POINTCLOUDEX", "elevation_max", &elevation_max, NULL)
        && elevation_max == pointcloudex->elevation_max)
      pass ();
    else
      fail ("POINTCLOUDEX.elevation_max [BD] %g != %g", pointcloudex->elevation_max, elevation_max);
    elevation_max++;
    if (dwg_dynapi_entity_set_value (pointcloudex, "POINTCLOUDEX", "elevation_max", &elevation_max, 0)
        && elevation_max == pointcloudex->elevation_max)
      pass ();
    else
      fail ("POINTCLOUDEX.elevation_max [BD] set+1 %g != %g", pointcloudex->elevation_max, elevation_max);
    pointcloudex->elevation_max--;
  }
  {
    BITCODE_BD elevation_min;
    if (dwg_dynapi_entity_value (pointcloudex, "POINTCLOUDEX", "elevation_min", &elevation_min, NULL)
        && elevation_min == pointcloudex->elevation_min)
      pass ();
    else
      fail ("POINTCLOUDEX.elevation_min [BD] %g != %g", pointcloudex->elevation_min, elevation_min);
    elevation_min++;
    if (dwg_dynapi_entity_set_value (pointcloudex, "POINTCLOUDEX", "elevation_min", &elevation_min, 0)
        && elevation_min == pointcloudex->elevation_min)
      pass ();
    else
      fail ("POINTCLOUDEX.elevation_min [BD] set+1 %g != %g", pointcloudex->elevation_min, elevation_min);
    pointcloudex->elevation_min--;
  }
  {
    BITCODE_BS elevation_out_of_range_behavior;
    if (dwg_dynapi_entity_value (pointcloudex, "POINTCLOUDEX", "elevation_out_of_range_behavior", &elevation_out_of_range_behavior, NULL)
        && elevation_out_of_range_behavior == pointcloudex->elevation_out_of_range_behavior)
      pass ();
    else
      fail ("POINTCLOUDEX.elevation_out_of_range_behavior [BS] %hu != %hu", pointcloudex->elevation_out_of_range_behavior, elevation_out_of_range_behavior);
    elevation_out_of_range_behavior++;
    if (dwg_dynapi_entity_set_value (pointcloudex, "POINTCLOUDEX", "elevation_out_of_range_behavior", &elevation_out_of_range_behavior, 0)
        && elevation_out_of_range_behavior == pointcloudex->elevation_out_of_range_behavior)
      pass ();
    else
      fail ("POINTCLOUDEX.elevation_out_of_range_behavior [BS] set+1 %hu != %hu", pointcloudex->elevation_out_of_range_behavior, elevation_out_of_range_behavior);
    pointcloudex->elevation_out_of_range_behavior--;
  }
  {
    BITCODE_3BD extents_max;
    if (dwg_dynapi_entity_value (pointcloudex, "POINTCLOUDEX", "extents_max", &extents_max, NULL)
        && !memcmp (&extents_max, &pointcloudex->extents_max, sizeof (BITCODE_3BD)))
        pass ();
    else
        fail ("POINTCLOUDEX.extents_max [3BD]");
  }
  {
    BITCODE_3BD extents_min;
    if (dwg_dynapi_entity_value (pointcloudex, "POINTCLOUDEX", "extents_min", &extents_min, NULL)
        && !memcmp (&extents_min, &pointcloudex->extents_min, sizeof (BITCODE_3BD)))
        pass ();
    else
        fail ("POINTCLOUDEX.extents_min [3BD]");
  }
  {
    BITCODE_B intensity_as_gradient;
    if (dwg_dynapi_entity_value (pointcloudex, "POINTCLOUDEX", "intensity_as_gradient", &intensity_as_gradient, NULL)
        && intensity_as_gradient == pointcloudex->intensity_as_gradient)
      pass ();
    else
      fail ("POINTCLOUDEX.intensity_as_gradient [B] " FORMAT_B " != " FORMAT_B "", pointcloudex->intensity_as_gradient, intensity_as_gradient);
    intensity_as_gradient++;
    if (dwg_dynapi_entity_set_value (pointcloudex, "POINTCLOUDEX", "intensity_as_gradient", &intensity_as_gradient, 0)
        && intensity_as_gradient == pointcloudex->intensity_as_gradient)
      pass ();
    else
      fail ("POINTCLOUDEX.intensity_as_gradient [B] set+1 " FORMAT_B " != " FORMAT_B "", pointcloudex->intensity_as_gradient, intensity_as_gradient);
    pointcloudex->intensity_as_gradient--;
  }
  {
    BITCODE_T intensity_colorscheme;
    if (dwg_dynapi_entity_value (pointcloudex, "POINTCLOUDEX", "intensity_colorscheme", &intensity_colorscheme, NULL)
        && intensity_colorscheme
           ? strEQ ((char *)intensity_colorscheme, (char *)pointcloudex->intensity_colorscheme)
           : !pointcloudex->intensity_colorscheme)
      pass ();
    else
      fail ("POINTCLOUDEX.intensity_colorscheme [T] '%s' <> '%s'", intensity_colorscheme, pointcloudex->intensity_colorscheme);
  }
  {
    BITCODE_BL intensity_max;
    if (dwg_dynapi_entity_value (pointcloudex, "POINTCLOUDEX", "intensity_max", &intensity_max, NULL)
        && intensity_max == pointcloudex->intensity_max)
      pass ();
    else
      fail ("POINTCLOUDEX.intensity_max [BL] %u != %u", pointcloudex->intensity_max, intensity_max);
    intensity_max++;
    if (dwg_dynapi_entity_set_value (pointcloudex, "POINTCLOUDEX", "intensity_max", &intensity_max, 0)
        && intensity_max == pointcloudex->intensity_max)
      pass ();
    else
      fail ("POINTCLOUDEX.intensity_max [BL] set+1 %u != %u", pointcloudex->intensity_max, intensity_max);
    pointcloudex->intensity_max--;
  }
  {
    BITCODE_BL intensity_min;
    if (dwg_dynapi_entity_value (pointcloudex, "POINTCLOUDEX", "intensity_min", &intensity_min, NULL)
        && intensity_min == pointcloudex->intensity_min)
      pass ();
    else
      fail ("POINTCLOUDEX.intensity_min [BL] %u != %u", pointcloudex->intensity_min, intensity_min);
    intensity_min++;
    if (dwg_dynapi_entity_set_value (pointcloudex, "POINTCLOUDEX", "intensity_min", &intensity_min, 0)
        && intensity_min == pointcloudex->intensity_min)
      pass ();
    else
      fail ("POINTCLOUDEX.intensity_min [BL] set+1 %u != %u", pointcloudex->intensity_min, intensity_min);
    pointcloudex->intensity_min--;
  }
  {
    BITCODE_BS intensity_out_of_range_behavior;
    if (dwg_dynapi_entity_value (pointcloudex, "POINTCLOUDEX", "intensity_out_of_range_behavior", &intensity_out_of_range_behavior, NULL)
        && intensity_out_of_range_behavior == pointcloudex->intensity_out_of_range_behavior)
      pass ();
    else
      fail ("POINTCLOUDEX.intensity_out_of_range_behavior [BS] %hu != %hu", pointcloudex->intensity_out_of_range_behavior, intensity_out_of_range_behavior);
    intensity_out_of_range_behavior++;
    if (dwg_dynapi_entity_set_value (pointcloudex, "POINTCLOUDEX", "intensity_out_of_range_behavior", &intensity_out_of_range_behavior, 0)
        && intensity_out_of_range_behavior == pointcloudex->intensity_out_of_range_behavior)
      pass ();
    else
      fail ("POINTCLOUDEX.intensity_out_of_range_behavior [BS] set+1 %hu != %hu", pointcloudex->intensity_out_of_range_behavior, intensity_out_of_range_behavior);
    pointcloudex->intensity_out_of_range_behavior--;
  }
  {
    BITCODE_B is_locked;
    if (dwg_dynapi_entity_value (pointcloudex, "POINTCLOUDEX", "is_locked", &is_locked, NULL)
        && is_locked == pointcloudex->is_locked)
      pass ();
    else
      fail ("POINTCLOUDEX.is_locked [B] " FORMAT_B " != " FORMAT_B "", pointcloudex->is_locked, is_locked);
    is_locked++;
    if (dwg_dynapi_entity_set_value (pointcloudex, "POINTCLOUDEX", "is_locked", &is_locked, 0)
        && is_locked == pointcloudex->is_locked)
      pass ();
    else
      fail ("POINTCLOUDEX.is_locked [B] set+1 " FORMAT_B " != " FORMAT_B "", pointcloudex->is_locked, is_locked);
    pointcloudex->is_locked--;
  }
  {
    BITCODE_T name;
    if (dwg_dynapi_entity_value (pointcloudex, "POINTCLOUDEX", "name", &name, NULL)
        && name
           ? strEQ ((char *)name, (char *)pointcloudex->name)
           : !pointcloudex->name)
      pass ();
    else
      fail ("POINTCLOUDEX.name [T] '%s' <> '%s'", name, pointcloudex->name);
  }
  {
    BITCODE_BL num_croppings;
    if (dwg_dynapi_entity_value (pointcloudex, "POINTCLOUDEX", "num_croppings", &num_croppings, NULL)
        && num_croppings == pointcloudex->num_croppings)
      pass ();
    else
      fail ("POINTCLOUDEX.num_croppings [BL] %u != %u", pointcloudex->num_croppings, num_croppings);
    num_croppings++;
    if (dwg_dynapi_entity_set_value (pointcloudex, "POINTCLOUDEX", "num_croppings", &num_croppings, 0)
        && num_croppings == pointcloudex->num_croppings)
      pass ();
    else
      fail ("POINTCLOUDEX.num_croppings [BL] set+1 %u != %u", pointcloudex->num_croppings, num_croppings);
    pointcloudex->num_croppings--;
  }
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value (pointcloudex, "POINTCLOUDEX", "parent", &parent, NULL)
        && !memcmp (&parent, &pointcloudex->parent, sizeof (struct _dwg_object_entity*)))
        pass ();
    else
        fail ("POINTCLOUDEX.parent [struct _dwg_object_entity*]");
  }
  {
    BITCODE_H pointclouddefex;
    if (dwg_dynapi_entity_value (pointcloudex, "POINTCLOUDEX", "pointclouddefex", &pointclouddefex, NULL)
        && !memcmp (&pointclouddefex, &pointcloudex->pointclouddefex, sizeof (BITCODE_H)))
        pass ();
    else
        fail ("POINTCLOUDEX.pointclouddefex [H]");
  }
  {
    BITCODE_H reactor;
    if (dwg_dynapi_entity_value (pointcloudex, "POINTCLOUDEX", "reactor", &reactor, NULL)
        && !memcmp (&reactor, &pointcloudex->reactor, sizeof (BITCODE_H)))
        pass ();
    else
        fail ("POINTCLOUDEX.reactor [H]");
  }
  {
    BITCODE_B show_cropping;
    if (dwg_dynapi_entity_value (pointcloudex, "POINTCLOUDEX", "show_cropping", &show_cropping, NULL)
        && show_cropping == pointcloudex->show_cropping)
      pass ();
    else
      fail ("POINTCLOUDEX.show_cropping [B] " FORMAT_B " != " FORMAT_B "", pointcloudex->show_cropping, show_cropping);
    show_cropping++;
    if (dwg_dynapi_entity_set_value (pointcloudex, "POINTCLOUDEX", "show_cropping", &show_cropping, 0)
        && show_cropping == pointcloudex->show_cropping)
      pass ();
    else
      fail ("POINTCLOUDEX.show_cropping [B] set+1 " FORMAT_B " != " FORMAT_B "", pointcloudex->show_cropping, show_cropping);
    pointcloudex->show_cropping--;
  }
  {
    BITCODE_B show_intensity;
    if (dwg_dynapi_entity_value (pointcloudex, "POINTCLOUDEX", "show_intensity", &show_intensity, NULL)
        && show_intensity == pointcloudex->show_intensity)
      pass ();
    else
      fail ("POINTCLOUDEX.show_intensity [B] " FORMAT_B " != " FORMAT_B "", pointcloudex->show_intensity, show_intensity);
    show_intensity++;
    if (dwg_dynapi_entity_set_value (pointcloudex, "POINTCLOUDEX", "show_intensity", &show_intensity, 0)
        && show_intensity == pointcloudex->show_intensity)
      pass ();
    else
      fail ("POINTCLOUDEX.show_intensity [B] set+1 " FORMAT_B " != " FORMAT_B "", pointcloudex->show_intensity, show_intensity);
    pointcloudex->show_intensity--;
  }
  {
    BITCODE_BS stylization_type;
    if (dwg_dynapi_entity_value (pointcloudex, "POINTCLOUDEX", "stylization_type", &stylization_type, NULL)
        && stylization_type == pointcloudex->stylization_type)
      pass ();
    else
      fail ("POINTCLOUDEX.stylization_type [BS] %hu != %hu", pointcloudex->stylization_type, stylization_type);
    stylization_type++;
    if (dwg_dynapi_entity_set_value (pointcloudex, "POINTCLOUDEX", "stylization_type", &stylization_type, 0)
        && stylization_type == pointcloudex->stylization_type)
      pass ();
    else
      fail ("POINTCLOUDEX.stylization_type [BS] set+1 %hu != %hu", pointcloudex->stylization_type, stylization_type);
    pointcloudex->stylization_type--;
  }
  {
    BITCODE_3BD ucs_origin;
    if (dwg_dynapi_entity_value (pointcloudex, "POINTCLOUDEX", "ucs_origin", &ucs_origin, NULL)
        && !memcmp (&ucs_origin, &pointcloudex->ucs_origin, sizeof (BITCODE_3BD)))
        pass ();
    else
        fail ("POINTCLOUDEX.ucs_origin [3BD]");
  }
  {
    BITCODE_3BD ucs_x_dir;
    if (dwg_dynapi_entity_value (pointcloudex, "POINTCLOUDEX", "ucs_x_dir", &ucs_x_dir, NULL)
        && !memcmp (&ucs_x_dir, &pointcloudex->ucs_x_dir, sizeof (BITCODE_3BD)))
        pass ();
    else
        fail ("POINTCLOUDEX.ucs_x_dir [3BD]");
  }
  {
    BITCODE_3BD ucs_y_dir;
    if (dwg_dynapi_entity_value (pointcloudex, "POINTCLOUDEX", "ucs_y_dir", &ucs_y_dir, NULL)
        && !memcmp (&ucs_y_dir, &pointcloudex->ucs_y_dir, sizeof (BITCODE_3BD)))
        pass ();
    else
        fail ("POINTCLOUDEX.ucs_y_dir [3BD]");
  }
  {
    BITCODE_3BD ucs_z_dir;
    if (dwg_dynapi_entity_value (pointcloudex, "POINTCLOUDEX", "ucs_z_dir", &ucs_z_dir, NULL)
        && !memcmp (&ucs_z_dir, &pointcloudex->ucs_z_dir, sizeof (BITCODE_3BD)))
        pass ();
    else
        fail ("POINTCLOUDEX.ucs_z_dir [3BD]");
  }
  {
    BITCODE_BL unknown_bl0;
    if (dwg_dynapi_entity_value (pointcloudex, "POINTCLOUDEX", "unknown_bl0", &unknown_bl0, NULL)
        && unknown_bl0 == pointcloudex->unknown_bl0)
      pass ();
    else
      fail ("POINTCLOUDEX.unknown_bl0 [BL] %u != %u", pointcloudex->unknown_bl0, unknown_bl0);
    unknown_bl0++;
    if (dwg_dynapi_entity_set_value (pointcloudex, "POINTCLOUDEX", "unknown_bl0", &unknown_bl0, 0)
        && unknown_bl0 == pointcloudex->unknown_bl0)
      pass ();
    else
      fail ("POINTCLOUDEX.unknown_bl0 [BL] set+1 %u != %u", pointcloudex->unknown_bl0, unknown_bl0);
    pointcloudex->unknown_bl0--;
  }
  {
    BITCODE_BL unknown_bl1;
    if (dwg_dynapi_entity_value (pointcloudex, "POINTCLOUDEX", "unknown_bl1", &unknown_bl1, NULL)
        && unknown_bl1 == pointcloudex->unknown_bl1)
      pass ();
    else
      fail ("POINTCLOUDEX.unknown_bl1 [BL] %u != %u", pointcloudex->unknown_bl1, unknown_bl1);
    unknown_bl1++;
    if (dwg_dynapi_entity_set_value (pointcloudex, "POINTCLOUDEX", "unknown_bl1", &unknown_bl1, 0)
        && unknown_bl1 == pointcloudex->unknown_bl1)
      pass ();
    else
      fail ("POINTCLOUDEX.unknown_bl1 [BL] set+1 %u != %u", pointcloudex->unknown_bl1, unknown_bl1);
    pointcloudex->unknown_bl1--;
  }
  if (failed && (is_class_unstable ("POINTCLOUDEX") || is_class_debugging ("POINTCLOUDEX")))
    {
      ok ("%s failed %d tests (TODO unstable)", "POINTCLOUDEX", failed);
      failed = 0;
    }
  return failed;
}
static int test_POINTPARAMETERENTITY (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_POINTPARAMETERENTITY *restrict pointparameterentity = obj->tio.entity->tio.POINTPARAMETERENTITY;
  failed = 0;
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value (pointparameterentity, "POINTPARAMETERENTITY", "parent", &parent, NULL)
        && !memcmp (&parent, &pointparameterentity->parent, sizeof (struct _dwg_object_entity*)))
        pass ();
    else
        fail ("POINTPARAMETERENTITY.parent [struct _dwg_object_entity*]");
  }
  if (failed && (is_class_unstable ("POINTPARAMETERENTITY") || is_class_debugging ("POINTPARAMETERENTITY")))
    {
      ok ("%s failed %d tests (TODO unstable)", "POINTPARAMETERENTITY", failed);
      failed = 0;
    }
  return failed;
}
static int test_POLYLINE_2D (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_POLYLINE_2D *restrict polyline_2d = obj->tio.entity->tio.POLYLINE_2D;
  failed = 0;
  {
    BITCODE_BS curve_type;
    if (dwg_dynapi_entity_value (polyline_2d, "POLYLINE_2D", "curve_type", &curve_type, NULL)
        && curve_type == polyline_2d->curve_type)
      pass ();
    else
      fail ("POLYLINE_2D.curve_type [BS] %hu != %hu", polyline_2d->curve_type, curve_type);
    curve_type++;
    if (dwg_dynapi_entity_set_value (polyline_2d, "POLYLINE_2D", "curve_type", &curve_type, 0)
        && curve_type == polyline_2d->curve_type)
      pass ();
    else
      fail ("POLYLINE_2D.curve_type [BS] set+1 %hu != %hu", polyline_2d->curve_type, curve_type);
    polyline_2d->curve_type--;
  }
  {
    BITCODE_BD elevation;
    if (dwg_dynapi_entity_value (polyline_2d, "POLYLINE_2D", "elevation", &elevation, NULL)
        && elevation == polyline_2d->elevation)
      pass ();
    else
      fail ("POLYLINE_2D.elevation [BD] %g != %g", polyline_2d->elevation, elevation);
    elevation++;
    if (dwg_dynapi_entity_set_value (polyline_2d, "POLYLINE_2D", "elevation", &elevation, 0)
        && elevation == polyline_2d->elevation)
      pass ();
    else
      fail ("POLYLINE_2D.elevation [BD] set+1 %g != %g", polyline_2d->elevation, elevation);
    polyline_2d->elevation--;
  }
  {
    BITCODE_BD end_width;
    if (dwg_dynapi_entity_value (polyline_2d, "POLYLINE_2D", "end_width", &end_width, NULL)
        && end_width == polyline_2d->end_width)
      pass ();
    else
      fail ("POLYLINE_2D.end_width [BD] %g != %g", polyline_2d->end_width, end_width);
    end_width++;
    if (dwg_dynapi_entity_set_value (polyline_2d, "POLYLINE_2D", "end_width", &end_width, 0)
        && end_width == polyline_2d->end_width)
      pass ();
    else
      fail ("POLYLINE_2D.end_width [BD] set+1 %g != %g", polyline_2d->end_width, end_width);
    polyline_2d->end_width--;
  }
  {
    BITCODE_BE extrusion;
    if (dwg_dynapi_entity_value (polyline_2d, "POLYLINE_2D", "extrusion", &extrusion, NULL)
        && !memcmp (&extrusion, &polyline_2d->extrusion, sizeof (BITCODE_BE)))
        pass ();
    else
        fail ("POLYLINE_2D.extrusion [BE]");
  }
  {
    BITCODE_H first_vertex;
    if (dwg_dynapi_entity_value (polyline_2d, "POLYLINE_2D", "first_vertex", &first_vertex, NULL)
        && !memcmp (&first_vertex, &polyline_2d->first_vertex, sizeof (BITCODE_H)))
        pass ();
    else
        fail ("POLYLINE_2D.first_vertex [H]");
  }
  {
    BITCODE_BS flag;
    if (dwg_dynapi_entity_value (polyline_2d, "POLYLINE_2D", "flag", &flag, NULL)
        && flag == polyline_2d->flag)
      pass ();
    else
      fail ("POLYLINE_2D.flag [BS] %hu != %hu", polyline_2d->flag, flag);
    flag++;
    if (dwg_dynapi_entity_set_value (polyline_2d, "POLYLINE_2D", "flag", &flag, 0)
        && flag == polyline_2d->flag)
      pass ();
    else
      fail ("POLYLINE_2D.flag [BS] set+1 %hu != %hu", polyline_2d->flag, flag);
    polyline_2d->flag--;
  }
  {
    BITCODE_B has_vertex;
    if (dwg_dynapi_entity_value (polyline_2d, "POLYLINE_2D", "has_vertex", &has_vertex, NULL)
        && has_vertex == polyline_2d->has_vertex)
      pass ();
    else
      fail ("POLYLINE_2D.has_vertex [B] " FORMAT_B " != " FORMAT_B "", polyline_2d->has_vertex, has_vertex);
    has_vertex++;
    if (dwg_dynapi_entity_set_value (polyline_2d, "POLYLINE_2D", "has_vertex", &has_vertex, 0)
        && has_vertex == polyline_2d->has_vertex)
      pass ();
    else
      fail ("POLYLINE_2D.has_vertex [B] set+1 " FORMAT_B " != " FORMAT_B "", polyline_2d->has_vertex, has_vertex);
    polyline_2d->has_vertex--;
  }
  {
    BITCODE_H last_vertex;
    if (dwg_dynapi_entity_value (polyline_2d, "POLYLINE_2D", "last_vertex", &last_vertex, NULL)
        && !memcmp (&last_vertex, &polyline_2d->last_vertex, sizeof (BITCODE_H)))
        pass ();
    else
        fail ("POLYLINE_2D.last_vertex [H]");
  }
  {
    BITCODE_BL num_owned;
    if (dwg_dynapi_entity_value (polyline_2d, "POLYLINE_2D", "num_owned", &num_owned, NULL)
        && num_owned == polyline_2d->num_owned)
      pass ();
    else
      fail ("POLYLINE_2D.num_owned [BL] %u != %u", polyline_2d->num_owned, num_owned);
    num_owned++;
    if (dwg_dynapi_entity_set_value (polyline_2d, "POLYLINE_2D", "num_owned", &num_owned, 0)
        && num_owned == polyline_2d->num_owned)
      pass ();
    else
      fail ("POLYLINE_2D.num_owned [BL] set+1 %u != %u", polyline_2d->num_owned, num_owned);
    polyline_2d->num_owned--;
  }
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value (polyline_2d, "POLYLINE_2D", "parent", &parent, NULL)
        && !memcmp (&parent, &polyline_2d->parent, sizeof (struct _dwg_object_entity*)))
        pass ();
    else
        fail ("POLYLINE_2D.parent [struct _dwg_object_entity*]");
  }
  {
    BITCODE_H seqend;
    if (dwg_dynapi_entity_value (polyline_2d, "POLYLINE_2D", "seqend", &seqend, NULL)
        && !memcmp (&seqend, &polyline_2d->seqend, sizeof (BITCODE_H)))
        pass ();
    else
        fail ("POLYLINE_2D.seqend [H]");
  }
  {
    BITCODE_BD start_width;
    if (dwg_dynapi_entity_value (polyline_2d, "POLYLINE_2D", "start_width", &start_width, NULL)
        && start_width == polyline_2d->start_width)
      pass ();
    else
      fail ("POLYLINE_2D.start_width [BD] %g != %g", polyline_2d->start_width, start_width);
    start_width++;
    if (dwg_dynapi_entity_set_value (polyline_2d, "POLYLINE_2D", "start_width", &start_width, 0)
        && start_width == polyline_2d->start_width)
      pass ();
    else
      fail ("POLYLINE_2D.start_width [BD] set+1 %g != %g", polyline_2d->start_width, start_width);
    polyline_2d->start_width--;
  }
  {
    BITCODE_BT thickness;
    if (dwg_dynapi_entity_value (polyline_2d, "POLYLINE_2D", "thickness", &thickness, NULL)
        && thickness == polyline_2d->thickness)
      pass ();
    else
      fail ("POLYLINE_2D.thickness [BT] " FORMAT_BT " != " FORMAT_BT "", polyline_2d->thickness, thickness);
    if (dwg_dynapi_entity_set_value (polyline_2d, "POLYLINE_2D", "thickness", &thickness, 0)
        && thickness == polyline_2d->thickness)
      pass ();
    else
      fail ("POLYLINE_2D.thickness [BT] set+1 " FORMAT_BT " != " FORMAT_BT "", polyline_2d->thickness, thickness);
    polyline_2d->thickness--;
  }
  {
    BITCODE_H* vertex;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (polyline_2d, "POLYLINE_2D", "num_owned", &count, NULL)
        && dwg_dynapi_entity_value (polyline_2d, "POLYLINE_2D", "vertex", &vertex, NULL)
        && vertex == polyline_2d->vertex)
      pass ();
    else
      fail ("POLYLINE_2D.vertex [H*] * %u num_owned", count);
  }
  if (failed && (is_class_unstable ("POLYLINE_2D") || is_class_debugging ("POLYLINE_2D")))
    {
      ok ("%s failed %d tests (TODO unstable)", "POLYLINE_2D", failed);
      failed = 0;
    }
  return failed;
}
static int test_POLYLINE_3D (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_POLYLINE_3D *restrict polyline_3d = obj->tio.entity->tio.POLYLINE_3D;
  failed = 0;
  {
    BITCODE_RC curve_type;
    if (dwg_dynapi_entity_value (polyline_3d, "POLYLINE_3D", "curve_type", &curve_type, NULL)
        && curve_type == polyline_3d->curve_type)
      pass ();
    else
      fail ("POLYLINE_3D.curve_type [RC] %u != %u", polyline_3d->curve_type, curve_type);
    curve_type++;
    if (dwg_dynapi_entity_set_value (polyline_3d, "POLYLINE_3D", "curve_type", &curve_type, 0)
        && curve_type == polyline_3d->curve_type)
      pass ();
    else
      fail ("POLYLINE_3D.curve_type [RC] set+1 %u != %u", polyline_3d->curve_type, curve_type);
    polyline_3d->curve_type--;
  }
  {
    BITCODE_H first_vertex;
    if (dwg_dynapi_entity_value (polyline_3d, "POLYLINE_3D", "first_vertex", &first_vertex, NULL)
        && !memcmp (&first_vertex, &polyline_3d->first_vertex, sizeof (BITCODE_H)))
        pass ();
    else
        fail ("POLYLINE_3D.first_vertex [H]");
  }
  {
    BITCODE_RC flag;
    if (dwg_dynapi_entity_value (polyline_3d, "POLYLINE_3D", "flag", &flag, NULL)
        && flag == polyline_3d->flag)
      pass ();
    else
      fail ("POLYLINE_3D.flag [RC] %u != %u", polyline_3d->flag, flag);
    flag++;
    if (dwg_dynapi_entity_set_value (polyline_3d, "POLYLINE_3D", "flag", &flag, 0)
        && flag == polyline_3d->flag)
      pass ();
    else
      fail ("POLYLINE_3D.flag [RC] set+1 %u != %u", polyline_3d->flag, flag);
    polyline_3d->flag--;
  }
  {
    BITCODE_B has_vertex;
    if (dwg_dynapi_entity_value (polyline_3d, "POLYLINE_3D", "has_vertex", &has_vertex, NULL)
        && has_vertex == polyline_3d->has_vertex)
      pass ();
    else
      fail ("POLYLINE_3D.has_vertex [B] " FORMAT_B " != " FORMAT_B "", polyline_3d->has_vertex, has_vertex);
    has_vertex++;
    if (dwg_dynapi_entity_set_value (polyline_3d, "POLYLINE_3D", "has_vertex", &has_vertex, 0)
        && has_vertex == polyline_3d->has_vertex)
      pass ();
    else
      fail ("POLYLINE_3D.has_vertex [B] set+1 " FORMAT_B " != " FORMAT_B "", polyline_3d->has_vertex, has_vertex);
    polyline_3d->has_vertex--;
  }
  {
    BITCODE_H last_vertex;
    if (dwg_dynapi_entity_value (polyline_3d, "POLYLINE_3D", "last_vertex", &last_vertex, NULL)
        && !memcmp (&last_vertex, &polyline_3d->last_vertex, sizeof (BITCODE_H)))
        pass ();
    else
        fail ("POLYLINE_3D.last_vertex [H]");
  }
  {
    BITCODE_BL num_owned;
    if (dwg_dynapi_entity_value (polyline_3d, "POLYLINE_3D", "num_owned", &num_owned, NULL)
        && num_owned == polyline_3d->num_owned)
      pass ();
    else
      fail ("POLYLINE_3D.num_owned [BL] %u != %u", polyline_3d->num_owned, num_owned);
    num_owned++;
    if (dwg_dynapi_entity_set_value (polyline_3d, "POLYLINE_3D", "num_owned", &num_owned, 0)
        && num_owned == polyline_3d->num_owned)
      pass ();
    else
      fail ("POLYLINE_3D.num_owned [BL] set+1 %u != %u", polyline_3d->num_owned, num_owned);
    polyline_3d->num_owned--;
  }
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value (polyline_3d, "POLYLINE_3D", "parent", &parent, NULL)
        && !memcmp (&parent, &polyline_3d->parent, sizeof (struct _dwg_object_entity*)))
        pass ();
    else
        fail ("POLYLINE_3D.parent [struct _dwg_object_entity*]");
  }
  {
    BITCODE_H seqend;
    if (dwg_dynapi_entity_value (polyline_3d, "POLYLINE_3D", "seqend", &seqend, NULL)
        && !memcmp (&seqend, &polyline_3d->seqend, sizeof (BITCODE_H)))
        pass ();
    else
        fail ("POLYLINE_3D.seqend [H]");
  }
  {
    BITCODE_H* vertex;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (polyline_3d, "POLYLINE_3D", "num_owned", &count, NULL)
        && dwg_dynapi_entity_value (polyline_3d, "POLYLINE_3D", "vertex", &vertex, NULL)
        && vertex == polyline_3d->vertex)
      pass ();
    else
      fail ("POLYLINE_3D.vertex [H*] * %u num_owned", count);
  }
  if (failed && (is_class_unstable ("POLYLINE_3D") || is_class_debugging ("POLYLINE_3D")))
    {
      ok ("%s failed %d tests (TODO unstable)", "POLYLINE_3D", failed);
      failed = 0;
    }
  return failed;
}
static int test_POLYLINE_MESH (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_POLYLINE_MESH *restrict polyline_mesh = obj->tio.entity->tio.POLYLINE_MESH;
  failed = 0;
  {
    BITCODE_BS curve_type;
    if (dwg_dynapi_entity_value (polyline_mesh, "POLYLINE_MESH", "curve_type", &curve_type, NULL)
        && curve_type == polyline_mesh->curve_type)
      pass ();
    else
      fail ("POLYLINE_MESH.curve_type [BS] %hu != %hu", polyline_mesh->curve_type, curve_type);
    curve_type++;
    if (dwg_dynapi_entity_set_value (polyline_mesh, "POLYLINE_MESH", "curve_type", &curve_type, 0)
        && curve_type == polyline_mesh->curve_type)
      pass ();
    else
      fail ("POLYLINE_MESH.curve_type [BS] set+1 %hu != %hu", polyline_mesh->curve_type, curve_type);
    polyline_mesh->curve_type--;
  }
  {
    BITCODE_H first_vertex;
    if (dwg_dynapi_entity_value (polyline_mesh, "POLYLINE_MESH", "first_vertex", &first_vertex, NULL)
        && !memcmp (&first_vertex, &polyline_mesh->first_vertex, sizeof (BITCODE_H)))
        pass ();
    else
        fail ("POLYLINE_MESH.first_vertex [H]");
  }
  {
    BITCODE_BS flag;
    if (dwg_dynapi_entity_value (polyline_mesh, "POLYLINE_MESH", "flag", &flag, NULL)
        && flag == polyline_mesh->flag)
      pass ();
    else
      fail ("POLYLINE_MESH.flag [BS] %hu != %hu", polyline_mesh->flag, flag);
    flag++;
    if (dwg_dynapi_entity_set_value (polyline_mesh, "POLYLINE_MESH", "flag", &flag, 0)
        && flag == polyline_mesh->flag)
      pass ();
    else
      fail ("POLYLINE_MESH.flag [BS] set+1 %hu != %hu", polyline_mesh->flag, flag);
    polyline_mesh->flag--;
  }
  {
    BITCODE_B has_vertex;
    if (dwg_dynapi_entity_value (polyline_mesh, "POLYLINE_MESH", "has_vertex", &has_vertex, NULL)
        && has_vertex == polyline_mesh->has_vertex)
      pass ();
    else
      fail ("POLYLINE_MESH.has_vertex [B] " FORMAT_B " != " FORMAT_B "", polyline_mesh->has_vertex, has_vertex);
    has_vertex++;
    if (dwg_dynapi_entity_set_value (polyline_mesh, "POLYLINE_MESH", "has_vertex", &has_vertex, 0)
        && has_vertex == polyline_mesh->has_vertex)
      pass ();
    else
      fail ("POLYLINE_MESH.has_vertex [B] set+1 " FORMAT_B " != " FORMAT_B "", polyline_mesh->has_vertex, has_vertex);
    polyline_mesh->has_vertex--;
  }
  {
    BITCODE_H last_vertex;
    if (dwg_dynapi_entity_value (polyline_mesh, "POLYLINE_MESH", "last_vertex", &last_vertex, NULL)
        && !memcmp (&last_vertex, &polyline_mesh->last_vertex, sizeof (BITCODE_H)))
        pass ();
    else
        fail ("POLYLINE_MESH.last_vertex [H]");
  }
  {
    BITCODE_BS m_density;
    if (dwg_dynapi_entity_value (polyline_mesh, "POLYLINE_MESH", "m_density", &m_density, NULL)
        && m_density == polyline_mesh->m_density)
      pass ();
    else
      fail ("POLYLINE_MESH.m_density [BS] %hu != %hu", polyline_mesh->m_density, m_density);
    m_density++;
    if (dwg_dynapi_entity_set_value (polyline_mesh, "POLYLINE_MESH", "m_density", &m_density, 0)
        && m_density == polyline_mesh->m_density)
      pass ();
    else
      fail ("POLYLINE_MESH.m_density [BS] set+1 %hu != %hu", polyline_mesh->m_density, m_density);
    polyline_mesh->m_density--;
  }
  {
    BITCODE_BS n_density;
    if (dwg_dynapi_entity_value (polyline_mesh, "POLYLINE_MESH", "n_density", &n_density, NULL)
        && n_density == polyline_mesh->n_density)
      pass ();
    else
      fail ("POLYLINE_MESH.n_density [BS] %hu != %hu", polyline_mesh->n_density, n_density);
    n_density++;
    if (dwg_dynapi_entity_set_value (polyline_mesh, "POLYLINE_MESH", "n_density", &n_density, 0)
        && n_density == polyline_mesh->n_density)
      pass ();
    else
      fail ("POLYLINE_MESH.n_density [BS] set+1 %hu != %hu", polyline_mesh->n_density, n_density);
    polyline_mesh->n_density--;
  }
  {
    BITCODE_BS num_m_verts;
    if (dwg_dynapi_entity_value (polyline_mesh, "POLYLINE_MESH", "num_m_verts", &num_m_verts, NULL)
        && num_m_verts == polyline_mesh->num_m_verts)
      pass ();
    else
      fail ("POLYLINE_MESH.num_m_verts [BS] %hu != %hu", polyline_mesh->num_m_verts, num_m_verts);
    num_m_verts++;
    if (dwg_dynapi_entity_set_value (polyline_mesh, "POLYLINE_MESH", "num_m_verts", &num_m_verts, 0)
        && num_m_verts == polyline_mesh->num_m_verts)
      pass ();
    else
      fail ("POLYLINE_MESH.num_m_verts [BS] set+1 %hu != %hu", polyline_mesh->num_m_verts, num_m_verts);
    polyline_mesh->num_m_verts--;
  }
  {
    BITCODE_BS num_n_verts;
    if (dwg_dynapi_entity_value (polyline_mesh, "POLYLINE_MESH", "num_n_verts", &num_n_verts, NULL)
        && num_n_verts == polyline_mesh->num_n_verts)
      pass ();
    else
      fail ("POLYLINE_MESH.num_n_verts [BS] %hu != %hu", polyline_mesh->num_n_verts, num_n_verts);
    num_n_verts++;
    if (dwg_dynapi_entity_set_value (polyline_mesh, "POLYLINE_MESH", "num_n_verts", &num_n_verts, 0)
        && num_n_verts == polyline_mesh->num_n_verts)
      pass ();
    else
      fail ("POLYLINE_MESH.num_n_verts [BS] set+1 %hu != %hu", polyline_mesh->num_n_verts, num_n_verts);
    polyline_mesh->num_n_verts--;
  }
  {
    BITCODE_BL num_owned;
    if (dwg_dynapi_entity_value (polyline_mesh, "POLYLINE_MESH", "num_owned", &num_owned, NULL)
        && num_owned == polyline_mesh->num_owned)
      pass ();
    else
      fail ("POLYLINE_MESH.num_owned [BL] %u != %u", polyline_mesh->num_owned, num_owned);
    num_owned++;
    if (dwg_dynapi_entity_set_value (polyline_mesh, "POLYLINE_MESH", "num_owned", &num_owned, 0)
        && num_owned == polyline_mesh->num_owned)
      pass ();
    else
      fail ("POLYLINE_MESH.num_owned [BL] set+1 %u != %u", polyline_mesh->num_owned, num_owned);
    polyline_mesh->num_owned--;
  }
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value (polyline_mesh, "POLYLINE_MESH", "parent", &parent, NULL)
        && !memcmp (&parent, &polyline_mesh->parent, sizeof (struct _dwg_object_entity*)))
        pass ();
    else
        fail ("POLYLINE_MESH.parent [struct _dwg_object_entity*]");
  }
  {
    BITCODE_H seqend;
    if (dwg_dynapi_entity_value (polyline_mesh, "POLYLINE_MESH", "seqend", &seqend, NULL)
        && !memcmp (&seqend, &polyline_mesh->seqend, sizeof (BITCODE_H)))
        pass ();
    else
        fail ("POLYLINE_MESH.seqend [H]");
  }
  {
    BITCODE_H* vertex;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (polyline_mesh, "POLYLINE_MESH", "num_owned", &count, NULL)
        && dwg_dynapi_entity_value (polyline_mesh, "POLYLINE_MESH", "vertex", &vertex, NULL)
        && vertex == polyline_mesh->vertex)
      pass ();
    else
      fail ("POLYLINE_MESH.vertex [H*] * %u num_owned", count);
  }
  if (failed && (is_class_unstable ("POLYLINE_MESH") || is_class_debugging ("POLYLINE_MESH")))
    {
      ok ("%s failed %d tests (TODO unstable)", "POLYLINE_MESH", failed);
      failed = 0;
    }
  return failed;
}
static int test_POLYLINE_PFACE (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_POLYLINE_PFACE *restrict polyline_pface = obj->tio.entity->tio.POLYLINE_PFACE;
  failed = 0;
  {
    BITCODE_H first_vertex;
    if (dwg_dynapi_entity_value (polyline_pface, "POLYLINE_PFACE", "first_vertex", &first_vertex, NULL)
        && !memcmp (&first_vertex, &polyline_pface->first_vertex, sizeof (BITCODE_H)))
        pass ();
    else
        fail ("POLYLINE_PFACE.first_vertex [H]");
  }
  {
    BITCODE_B has_vertex;
    if (dwg_dynapi_entity_value (polyline_pface, "POLYLINE_PFACE", "has_vertex", &has_vertex, NULL)
        && has_vertex == polyline_pface->has_vertex)
      pass ();
    else
      fail ("POLYLINE_PFACE.has_vertex [B] " FORMAT_B " != " FORMAT_B "", polyline_pface->has_vertex, has_vertex);
    has_vertex++;
    if (dwg_dynapi_entity_set_value (polyline_pface, "POLYLINE_PFACE", "has_vertex", &has_vertex, 0)
        && has_vertex == polyline_pface->has_vertex)
      pass ();
    else
      fail ("POLYLINE_PFACE.has_vertex [B] set+1 " FORMAT_B " != " FORMAT_B "", polyline_pface->has_vertex, has_vertex);
    polyline_pface->has_vertex--;
  }
  {
    BITCODE_H last_vertex;
    if (dwg_dynapi_entity_value (polyline_pface, "POLYLINE_PFACE", "last_vertex", &last_vertex, NULL)
        && !memcmp (&last_vertex, &polyline_pface->last_vertex, sizeof (BITCODE_H)))
        pass ();
    else
        fail ("POLYLINE_PFACE.last_vertex [H]");
  }
  {
    BITCODE_BL num_owned;
    if (dwg_dynapi_entity_value (polyline_pface, "POLYLINE_PFACE", "num_owned", &num_owned, NULL)
        && num_owned == polyline_pface->num_owned)
      pass ();
    else
      fail ("POLYLINE_PFACE.num_owned [BL] %u != %u", polyline_pface->num_owned, num_owned);
    num_owned++;
    if (dwg_dynapi_entity_set_value (polyline_pface, "POLYLINE_PFACE", "num_owned", &num_owned, 0)
        && num_owned == polyline_pface->num_owned)
      pass ();
    else
      fail ("POLYLINE_PFACE.num_owned [BL] set+1 %u != %u", polyline_pface->num_owned, num_owned);
    polyline_pface->num_owned--;
  }
  {
    BITCODE_BS numfaces;
    if (dwg_dynapi_entity_value (polyline_pface, "POLYLINE_PFACE", "numfaces", &numfaces, NULL)
        && numfaces == polyline_pface->numfaces)
      pass ();
    else
      fail ("POLYLINE_PFACE.numfaces [BS] %hu != %hu", polyline_pface->numfaces, numfaces);
    numfaces++;
    if (dwg_dynapi_entity_set_value (polyline_pface, "POLYLINE_PFACE", "numfaces", &numfaces, 0)
        && numfaces == polyline_pface->numfaces)
      pass ();
    else
      fail ("POLYLINE_PFACE.numfaces [BS] set+1 %hu != %hu", polyline_pface->numfaces, numfaces);
    polyline_pface->numfaces--;
  }
  {
    BITCODE_BS numverts;
    if (dwg_dynapi_entity_value (polyline_pface, "POLYLINE_PFACE", "numverts", &numverts, NULL)
        && numverts == polyline_pface->numverts)
      pass ();
    else
      fail ("POLYLINE_PFACE.numverts [BS] %hu != %hu", polyline_pface->numverts, numverts);
    numverts++;
    if (dwg_dynapi_entity_set_value (polyline_pface, "POLYLINE_PFACE", "numverts", &numverts, 0)
        && numverts == polyline_pface->numverts)
      pass ();
    else
      fail ("POLYLINE_PFACE.numverts [BS] set+1 %hu != %hu", polyline_pface->numverts, numverts);
    polyline_pface->numverts--;
  }
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value (polyline_pface, "POLYLINE_PFACE", "parent", &parent, NULL)
        && !memcmp (&parent, &polyline_pface->parent, sizeof (struct _dwg_object_entity*)))
        pass ();
    else
        fail ("POLYLINE_PFACE.parent [struct _dwg_object_entity*]");
  }
  {
    BITCODE_H seqend;
    if (dwg_dynapi_entity_value (polyline_pface, "POLYLINE_PFACE", "seqend", &seqend, NULL)
        && !memcmp (&seqend, &polyline_pface->seqend, sizeof (BITCODE_H)))
        pass ();
    else
        fail ("POLYLINE_PFACE.seqend [H]");
  }
  {
    BITCODE_H* vertex;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (polyline_pface, "POLYLINE_PFACE", "num_owned", &count, NULL)
        && dwg_dynapi_entity_value (polyline_pface, "POLYLINE_PFACE", "vertex", &vertex, NULL)
        && vertex == polyline_pface->vertex)
      pass ();
    else
      fail ("POLYLINE_PFACE.vertex [H*] * %u num_owned", count);
  }
  if (failed && (is_class_unstable ("POLYLINE_PFACE") || is_class_debugging ("POLYLINE_PFACE")))
    {
      ok ("%s failed %d tests (TODO unstable)", "POLYLINE_PFACE", failed);
      failed = 0;
    }
  return failed;
}
static int test_PROXY_ENTITY (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_PROXY_ENTITY *restrict proxy_entity = obj->tio.entity->tio.PROXY_ENTITY;
  failed = 0;
  {
    BITCODE_BL class_id;
    if (dwg_dynapi_entity_value (proxy_entity, "PROXY_ENTITY", "class_id", &class_id, NULL)
        && class_id == proxy_entity->class_id)
      pass ();
    else
      fail ("PROXY_ENTITY.class_id [BL] %u != %u", proxy_entity->class_id, class_id);
    class_id++;
    if (dwg_dynapi_entity_set_value (proxy_entity, "PROXY_ENTITY", "class_id", &class_id, 0)
        && class_id == proxy_entity->class_id)
      pass ();
    else
      fail ("PROXY_ENTITY.class_id [BL] set+1 %u != %u", proxy_entity->class_id, class_id);
    proxy_entity->class_id--;
  }
  {
    BITCODE_TF data;
    if (dwg_dynapi_entity_value (proxy_entity, "PROXY_ENTITY", "data", &data, NULL)
        && !memcmp (&data, &proxy_entity->data, sizeof (BITCODE_TF)))
        pass ();
    else
        fail ("PROXY_ENTITY.data [TF]");
  }
  {
    BITCODE_BL data_numbits;
    if (dwg_dynapi_entity_value (proxy_entity, "PROXY_ENTITY", "data_numbits", &data_numbits, NULL)
        && data_numbits == proxy_entity->data_numbits)
      pass ();
    else
      fail ("PROXY_ENTITY.data_numbits [BL] %u != %u", proxy_entity->data_numbits, data_numbits);
    data_numbits++;
    if (dwg_dynapi_entity_set_value (proxy_entity, "PROXY_ENTITY", "data_numbits", &data_numbits, 0)
        && data_numbits == proxy_entity->data_numbits)
      pass ();
    else
      fail ("PROXY_ENTITY.data_numbits [BL] set+1 %u != %u", proxy_entity->data_numbits, data_numbits);
    proxy_entity->data_numbits--;
  }
  {
    BITCODE_BL data_size;
    if (dwg_dynapi_entity_value (proxy_entity, "PROXY_ENTITY", "data_size", &data_size, NULL)
        && data_size == proxy_entity->data_size)
      pass ();
    else
      fail ("PROXY_ENTITY.data_size [BL] %u != %u", proxy_entity->data_size, data_size);
    data_size++;
    if (dwg_dynapi_entity_set_value (proxy_entity, "PROXY_ENTITY", "data_size", &data_size, 0)
        && data_size == proxy_entity->data_size)
      pass ();
    else
      fail ("PROXY_ENTITY.data_size [BL] set+1 %u != %u", proxy_entity->data_size, data_size);
    proxy_entity->data_size--;
  }
  {
    BITCODE_B from_dxf;
    if (dwg_dynapi_entity_value (proxy_entity, "PROXY_ENTITY", "from_dxf", &from_dxf, NULL)
        && from_dxf == proxy_entity->from_dxf)
      pass ();
    else
      fail ("PROXY_ENTITY.from_dxf [B] " FORMAT_B " != " FORMAT_B "", proxy_entity->from_dxf, from_dxf);
    from_dxf++;
    if (dwg_dynapi_entity_set_value (proxy_entity, "PROXY_ENTITY", "from_dxf", &from_dxf, 0)
        && from_dxf == proxy_entity->from_dxf)
      pass ();
    else
      fail ("PROXY_ENTITY.from_dxf [B] set+1 " FORMAT_B " != " FORMAT_B "", proxy_entity->from_dxf, from_dxf);
    proxy_entity->from_dxf--;
  }
  {
    BITCODE_BL maint_version;
    if (dwg_dynapi_entity_value (proxy_entity, "PROXY_ENTITY", "maint_version", &maint_version, NULL)
        && maint_version == proxy_entity->maint_version)
      pass ();
    else
      fail ("PROXY_ENTITY.maint_version [BL] %u != %u", proxy_entity->maint_version, maint_version);
    maint_version++;
    if (dwg_dynapi_entity_set_value (proxy_entity, "PROXY_ENTITY", "maint_version", &maint_version, 0)
        && maint_version == proxy_entity->maint_version)
      pass ();
    else
      fail ("PROXY_ENTITY.maint_version [BL] set+1 %u != %u", proxy_entity->maint_version, maint_version);
    proxy_entity->maint_version--;
  }
  {
    BITCODE_BL num_objids;
    if (dwg_dynapi_entity_value (proxy_entity, "PROXY_ENTITY", "num_objids", &num_objids, NULL)
        && num_objids == proxy_entity->num_objids)
      pass ();
    else
      fail ("PROXY_ENTITY.num_objids [BL] %u != %u", proxy_entity->num_objids, num_objids);
    num_objids++;
    if (dwg_dynapi_entity_set_value (proxy_entity, "PROXY_ENTITY", "num_objids", &num_objids, 0)
        && num_objids == proxy_entity->num_objids)
      pass ();
    else
      fail ("PROXY_ENTITY.num_objids [BL] set+1 %u != %u", proxy_entity->num_objids, num_objids);
    proxy_entity->num_objids--;
  }
  {
    BITCODE_H* objids;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (proxy_entity, "PROXY_ENTITY", "num_objids", &count, NULL)
        && dwg_dynapi_entity_value (proxy_entity, "PROXY_ENTITY", "objids", &objids, NULL)
        && objids == proxy_entity->objids)
      pass ();
    else
      fail ("PROXY_ENTITY.objids [H*] * %u num_objids", count);
  }
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value (proxy_entity, "PROXY_ENTITY", "parent", &parent, NULL)
        && !memcmp (&parent, &proxy_entity->parent, sizeof (struct _dwg_object_entity*)))
        pass ();
    else
        fail ("PROXY_ENTITY.parent [struct _dwg_object_entity*]");
  }
  {
    BITCODE_BL version;
    if (dwg_dynapi_entity_value (proxy_entity, "PROXY_ENTITY", "version", &version, NULL)
        && version == proxy_entity->version)
      pass ();
    else
      fail ("PROXY_ENTITY.version [BL] %u != %u", proxy_entity->version, version);
    version++;
    if (dwg_dynapi_entity_set_value (proxy_entity, "PROXY_ENTITY", "version", &version, 0)
        && version == proxy_entity->version)
      pass ();
    else
      fail ("PROXY_ENTITY.version [BL] set+1 %u != %u", proxy_entity->version, version);
    proxy_entity->version--;
  }
  if (failed && (is_class_unstable ("PROXY_ENTITY") || is_class_debugging ("PROXY_ENTITY")))
    {
      ok ("%s failed %d tests (TODO unstable)", "PROXY_ENTITY", failed);
      failed = 0;
    }
  return failed;
}
static int test_RAY (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_RAY *restrict ray = obj->tio.entity->tio.RAY;
  failed = 0;
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value (ray, "RAY", "parent", &parent, NULL)
        && !memcmp (&parent, &ray->parent, sizeof (struct _dwg_object_entity*)))
        pass ();
    else
        fail ("RAY.parent [struct _dwg_object_entity*]");
  }
  {
    BITCODE_3BD point;
    if (dwg_dynapi_entity_value (ray, "RAY", "point", &point, NULL)
        && !memcmp (&point, &ray->point, sizeof (BITCODE_3BD)))
        pass ();
    else
        fail ("RAY.point [3BD]");
  }
  {
    BITCODE_3BD vector;
    if (dwg_dynapi_entity_value (ray, "RAY", "vector", &vector, NULL)
        && !memcmp (&vector, &ray->vector, sizeof (BITCODE_3BD)))
        pass ();
    else
        fail ("RAY.vector [3BD]");
  }
  if (failed && (is_class_unstable ("RAY") || is_class_debugging ("RAY")))
    {
      ok ("%s failed %d tests (TODO unstable)", "RAY", failed);
      failed = 0;
    }
  return failed;
}
static int test_REGION (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_REGION *restrict region = obj->tio.entity->tio.REGION;
  failed = 0;
  if (failed && (is_class_unstable ("REGION") || is_class_debugging ("REGION")))
    {
      ok ("%s failed %d tests (TODO unstable)", "REGION", failed);
      failed = 0;
    }
  return failed;
}
static int test_REVOLVEDSURFACE (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_REVOLVEDSURFACE *restrict revolvedsurface = obj->tio.entity->tio.REVOLVEDSURFACE;
  failed = 0;
  {
    BITCODE_B _dxf_sab_converted;
    if (dwg_dynapi_entity_value (revolvedsurface, "REVOLVEDSURFACE", "_dxf_sab_converted", &_dxf_sab_converted, NULL)
        && _dxf_sab_converted == revolvedsurface->_dxf_sab_converted)
      pass ();
    else
      fail ("REVOLVEDSURFACE._dxf_sab_converted [B] " FORMAT_B " != " FORMAT_B "", revolvedsurface->_dxf_sab_converted, _dxf_sab_converted);
    _dxf_sab_converted++;
    if (dwg_dynapi_entity_set_value (revolvedsurface, "REVOLVEDSURFACE", "_dxf_sab_converted", &_dxf_sab_converted, 0)
        && _dxf_sab_converted == revolvedsurface->_dxf_sab_converted)
      pass ();
    else
      fail ("REVOLVEDSURFACE._dxf_sab_converted [B] set+1 " FORMAT_B " != " FORMAT_B "", revolvedsurface->_dxf_sab_converted, _dxf_sab_converted);
    revolvedsurface->_dxf_sab_converted--;
  }
  {
    BITCODE_RC* acis_data;
    if (dwg_dynapi_entity_value (revolvedsurface, "REVOLVEDSURFACE", "acis_data", &acis_data, NULL)
        && acis_data
           ? strEQ ((char *)acis_data, (char *)revolvedsurface->acis_data)
           : !revolvedsurface->acis_data)
      pass ();
    else
      fail ("REVOLVEDSURFACE.acis_data [RC*] '%s' <> '%s'", acis_data, revolvedsurface->acis_data);
  }
  {
    BITCODE_B acis_empty;
    if (dwg_dynapi_entity_value (revolvedsurface, "REVOLVEDSURFACE", "acis_empty", &acis_empty, NULL)
        && acis_empty == revolvedsurface->acis_empty)
      pass ();
    else
      fail ("REVOLVEDSURFACE.acis_empty [B] " FORMAT_B " != " FORMAT_B "", revolvedsurface->acis_empty, acis_empty);
    acis_empty++;
    if (dwg_dynapi_entity_set_value (revolvedsurface, "REVOLVEDSURFACE", "acis_empty", &acis_empty, 0)
        && acis_empty == revolvedsurface->acis_empty)
      pass ();
    else
      fail ("REVOLVEDSURFACE.acis_empty [B] set+1 " FORMAT_B " != " FORMAT_B "", revolvedsurface->acis_empty, acis_empty);
    revolvedsurface->acis_empty--;
  }
  {
    BITCODE_B acis_empty2;
    if (dwg_dynapi_entity_value (revolvedsurface, "REVOLVEDSURFACE", "acis_empty2", &acis_empty2, NULL)
        && acis_empty2 == revolvedsurface->acis_empty2)
      pass ();
    else
      fail ("REVOLVEDSURFACE.acis_empty2 [B] " FORMAT_B " != " FORMAT_B "", revolvedsurface->acis_empty2, acis_empty2);
    acis_empty2++;
    if (dwg_dynapi_entity_set_value (revolvedsurface, "REVOLVEDSURFACE", "acis_empty2", &acis_empty2, 0)
        && acis_empty2 == revolvedsurface->acis_empty2)
      pass ();
    else
      fail ("REVOLVEDSURFACE.acis_empty2 [B] set+1 " FORMAT_B " != " FORMAT_B "", revolvedsurface->acis_empty2, acis_empty2);
    revolvedsurface->acis_empty2--;
  }
  {
    BITCODE_B acis_empty_bit;
    if (dwg_dynapi_entity_value (revolvedsurface, "REVOLVEDSURFACE", "acis_empty_bit", &acis_empty_bit, NULL)
        && acis_empty_bit == revolvedsurface->acis_empty_bit)
      pass ();
    else
      fail ("REVOLVEDSURFACE.acis_empty_bit [B] " FORMAT_B " != " FORMAT_B "", revolvedsurface->acis_empty_bit, acis_empty_bit);
    acis_empty_bit++;
    if (dwg_dynapi_entity_set_value (revolvedsurface, "REVOLVEDSURFACE", "acis_empty_bit", &acis_empty_bit, 0)
        && acis_empty_bit == revolvedsurface->acis_empty_bit)
      pass ();
    else
      fail ("REVOLVEDSURFACE.acis_empty_bit [B] set+1 " FORMAT_B " != " FORMAT_B "", revolvedsurface->acis_empty_bit, acis_empty_bit);
    revolvedsurface->acis_empty_bit--;
  }
  {
    BITCODE_3BD axis_point;
    if (dwg_dynapi_entity_value (revolvedsurface, "REVOLVEDSURFACE", "axis_point", &axis_point, NULL)
        && !memcmp (&axis_point, &revolvedsurface->axis_point, sizeof (BITCODE_3BD)))
        pass ();
    else
        fail ("REVOLVEDSURFACE.axis_point [3BD]");
  }
  {
    BITCODE_3BD axis_vector;
    if (dwg_dynapi_entity_value (revolvedsurface, "REVOLVEDSURFACE", "axis_vector", &axis_vector, NULL)
        && !memcmp (&axis_vector, &revolvedsurface->axis_vector, sizeof (BITCODE_3BD)))
        pass ();
    else
        fail ("REVOLVEDSURFACE.axis_vector [3BD]");
  }
  {
    BITCODE_BL* block_size;
    if (dwg_dynapi_entity_value (revolvedsurface, "REVOLVEDSURFACE", "block_size", &block_size, NULL)
        && !memcmp (&block_size, &revolvedsurface->block_size, sizeof (BITCODE_BL*)))
        pass ();
    else
        fail ("REVOLVEDSURFACE.block_size [BL*]");
  }
  {
    BITCODE_BL class_version;
    if (dwg_dynapi_entity_value (revolvedsurface, "REVOLVEDSURFACE", "class_version", &class_version, NULL)
        && class_version == revolvedsurface->class_version)
      pass ();
    else
      fail ("REVOLVEDSURFACE.class_version [BL] %u != %u", revolvedsurface->class_version, class_version);
    class_version++;
    if (dwg_dynapi_entity_set_value (revolvedsurface, "REVOLVEDSURFACE", "class_version", &class_version, 0)
        && class_version == revolvedsurface->class_version)
      pass ();
    else
      fail ("REVOLVEDSURFACE.class_version [BL] set+1 %u != %u", revolvedsurface->class_version, class_version);
    revolvedsurface->class_version--;
  }
  {
    BITCODE_B close_to_axis;
    if (dwg_dynapi_entity_value (revolvedsurface, "REVOLVEDSURFACE", "close_to_axis", &close_to_axis, NULL)
        && close_to_axis == revolvedsurface->close_to_axis)
      pass ();
    else
      fail ("REVOLVEDSURFACE.close_to_axis [B] " FORMAT_B " != " FORMAT_B "", revolvedsurface->close_to_axis, close_to_axis);
    close_to_axis++;
    if (dwg_dynapi_entity_set_value (revolvedsurface, "REVOLVEDSURFACE", "close_to_axis", &close_to_axis, 0)
        && close_to_axis == revolvedsurface->close_to_axis)
      pass ();
    else
      fail ("REVOLVEDSURFACE.close_to_axis [B] set+1 " FORMAT_B " != " FORMAT_B "", revolvedsurface->close_to_axis, close_to_axis);
    revolvedsurface->close_to_axis--;
  }
  {
    BITCODE_BD draft_angle;
    if (dwg_dynapi_entity_value (revolvedsurface, "REVOLVEDSURFACE", "draft_angle", &draft_angle, NULL)
        && draft_angle == revolvedsurface->draft_angle)
      pass ();
    else
      fail ("REVOLVEDSURFACE.draft_angle [BD] %g != %g", revolvedsurface->draft_angle, draft_angle);
    draft_angle++;
    if (dwg_dynapi_entity_set_value (revolvedsurface, "REVOLVEDSURFACE", "draft_angle", &draft_angle, 0)
        && draft_angle == revolvedsurface->draft_angle)
      pass ();
    else
      fail ("REVOLVEDSURFACE.draft_angle [BD] set+1 %g != %g", revolvedsurface->draft_angle, draft_angle);
    revolvedsurface->draft_angle--;
  }
  {
    BITCODE_BD draft_end_distance;
    if (dwg_dynapi_entity_value (revolvedsurface, "REVOLVEDSURFACE", "draft_end_distance", &draft_end_distance, NULL)
        && draft_end_distance == revolvedsurface->draft_end_distance)
      pass ();
    else
      fail ("REVOLVEDSURFACE.draft_end_distance [BD] %g != %g", revolvedsurface->draft_end_distance, draft_end_distance);
    draft_end_distance++;
    if (dwg_dynapi_entity_set_value (revolvedsurface, "REVOLVEDSURFACE", "draft_end_distance", &draft_end_distance, 0)
        && draft_end_distance == revolvedsurface->draft_end_distance)
      pass ();
    else
      fail ("REVOLVEDSURFACE.draft_end_distance [BD] set+1 %g != %g", revolvedsurface->draft_end_distance, draft_end_distance);
    revolvedsurface->draft_end_distance--;
  }
  {
    BITCODE_BD draft_start_distance;
    if (dwg_dynapi_entity_value (revolvedsurface, "REVOLVEDSURFACE", "draft_start_distance", &draft_start_distance, NULL)
        && draft_start_distance == revolvedsurface->draft_start_distance)
      pass ();
    else
      fail ("REVOLVEDSURFACE.draft_start_distance [BD] %g != %g", revolvedsurface->draft_start_distance, draft_start_distance);
    draft_start_distance++;
    if (dwg_dynapi_entity_set_value (revolvedsurface, "REVOLVEDSURFACE", "draft_start_distance", &draft_start_distance, 0)
        && draft_start_distance == revolvedsurface->draft_start_distance)
      pass ();
    else
      fail ("REVOLVEDSURFACE.draft_start_distance [BD] set+1 %g != %g", revolvedsurface->draft_start_distance, draft_start_distance);
    revolvedsurface->draft_start_distance--;
  }
  {
    char ** encr_sat_data;
    if (dwg_dynapi_entity_value (revolvedsurface, "REVOLVEDSURFACE", "encr_sat_data", &encr_sat_data, NULL)
        && !memcmp (&encr_sat_data, &revolvedsurface->encr_sat_data, sizeof (revolvedsurface->encr_sat_data)))
      pass ();
    else
      fail ("REVOLVEDSURFACE.encr_sat_data [char **]");
  }
  {
    BITCODE_BL end_marker;
    if (dwg_dynapi_entity_value (revolvedsurface, "REVOLVEDSURFACE", "end_marker", &end_marker, NULL)
        && end_marker == revolvedsurface->end_marker)
      pass ();
    else
      fail ("REVOLVEDSURFACE.end_marker [BL] %u != %u", revolvedsurface->end_marker, end_marker);
    end_marker++;
    if (dwg_dynapi_entity_set_value (revolvedsurface, "REVOLVEDSURFACE", "end_marker", &end_marker, 0)
        && end_marker == revolvedsurface->end_marker)
      pass ();
    else
      fail ("REVOLVEDSURFACE.end_marker [BL] set+1 %u != %u", revolvedsurface->end_marker, end_marker);
    revolvedsurface->end_marker--;
  }
  {
    struct _dwg_entity_3DSOLID* extra_acis_data;
    if (dwg_dynapi_entity_value (revolvedsurface, "REVOLVEDSURFACE", "extra_acis_data", &extra_acis_data, NULL)
        && !memcmp (&extra_acis_data, &revolvedsurface->extra_acis_data, sizeof (struct _dwg_entity_3DSOLID*)))
        pass ();
    else
        fail ("REVOLVEDSURFACE.extra_acis_data [struct _dwg_entity_3DSOLID*]");
  }
  {
    BITCODE_B has_revision_guid;
    if (dwg_dynapi_entity_value (revolvedsurface, "REVOLVEDSURFACE", "has_revision_guid", &has_revision_guid, NULL)
        && has_revision_guid == revolvedsurface->has_revision_guid)
      pass ();
    else
      fail ("REVOLVEDSURFACE.has_revision_guid [B] " FORMAT_B " != " FORMAT_B "", revolvedsurface->has_revision_guid, has_revision_guid);
    has_revision_guid++;
    if (dwg_dynapi_entity_set_value (revolvedsurface, "REVOLVEDSURFACE", "has_revision_guid", &has_revision_guid, 0)
        && has_revision_guid == revolvedsurface->has_revision_guid)
      pass ();
    else
      fail ("REVOLVEDSURFACE.has_revision_guid [B] set+1 " FORMAT_B " != " FORMAT_B "", revolvedsurface->has_revision_guid, has_revision_guid);
    revolvedsurface->has_revision_guid--;
  }
  {
    BITCODE_H history_id;
    if (dwg_dynapi_entity_value (revolvedsurface, "REVOLVEDSURFACE", "history_id", &history_id, NULL)
        && !memcmp (&history_id, &revolvedsurface->history_id, sizeof (BITCODE_H)))
        pass ();
    else
        fail ("REVOLVEDSURFACE.history_id [H]");
  }
  {
    BITCODE_BL id;
    if (dwg_dynapi_entity_value (revolvedsurface, "REVOLVEDSURFACE", "id", &id, NULL)
        && id == revolvedsurface->id)
      pass ();
    else
      fail ("REVOLVEDSURFACE.id [BL] %u != %u", revolvedsurface->id, id);
    id++;
    if (dwg_dynapi_entity_set_value (revolvedsurface, "REVOLVEDSURFACE", "id", &id, 0)
        && id == revolvedsurface->id)
      pass ();
    else
      fail ("REVOLVEDSURFACE.id [BL] set+1 %u != %u", revolvedsurface->id, id);
    revolvedsurface->id--;
  }
  {
    BITCODE_B isoline_present;
    if (dwg_dynapi_entity_value (revolvedsurface, "REVOLVEDSURFACE", "isoline_present", &isoline_present, NULL)
        && isoline_present == revolvedsurface->isoline_present)
      pass ();
    else
      fail ("REVOLVEDSURFACE.isoline_present [B] " FORMAT_B " != " FORMAT_B "", revolvedsurface->isoline_present, isoline_present);
    isoline_present++;
    if (dwg_dynapi_entity_set_value (revolvedsurface, "REVOLVEDSURFACE", "isoline_present", &isoline_present, 0)
        && isoline_present == revolvedsurface->isoline_present)
      pass ();
    else
      fail ("REVOLVEDSURFACE.isoline_present [B] set+1 " FORMAT_B " != " FORMAT_B "", revolvedsurface->isoline_present, isoline_present);
    revolvedsurface->isoline_present--;
  }
  {
    BITCODE_BL isolines;
    if (dwg_dynapi_entity_value (revolvedsurface, "REVOLVEDSURFACE", "isolines", &isolines, NULL)
        && isolines == revolvedsurface->isolines)
      pass ();
    else
      fail ("REVOLVEDSURFACE.isolines [BL] %u != %u", revolvedsurface->isolines, isolines);
    isolines++;
    if (dwg_dynapi_entity_set_value (revolvedsurface, "REVOLVEDSURFACE", "isolines", &isolines, 0)
        && isolines == revolvedsurface->isolines)
      pass ();
    else
      fail ("REVOLVEDSURFACE.isolines [BL] set+1 %u != %u", revolvedsurface->isolines, isolines);
    revolvedsurface->isolines--;
  }
  {
    Dwg_3DSOLID_material* materials;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (revolvedsurface, "REVOLVEDSURFACE", "num_materials", &count, NULL)
        && dwg_dynapi_entity_value (revolvedsurface, "REVOLVEDSURFACE", "materials", &materials, NULL)
        && materials == revolvedsurface->materials)
      pass ();
    else
      fail ("REVOLVEDSURFACE.materials [Dwg_3DSOLID_material*] * %u num_materials", count);
  }
  {
    BITCODE_BS modeler_format_version;
    if (dwg_dynapi_entity_value (revolvedsurface, "REVOLVEDSURFACE", "modeler_format_version", &modeler_format_version, NULL)
        && modeler_format_version == revolvedsurface->modeler_format_version)
      pass ();
    else
      fail ("REVOLVEDSURFACE.modeler_format_version [BS] %hu != %hu", revolvedsurface->modeler_format_version, modeler_format_version);
    modeler_format_version++;
    if (dwg_dynapi_entity_set_value (revolvedsurface, "REVOLVEDSURFACE", "modeler_format_version", &modeler_format_version, 0)
        && modeler_format_version == revolvedsurface->modeler_format_version)
      pass ();
    else
      fail ("REVOLVEDSURFACE.modeler_format_version [BS] set+1 %hu != %hu", revolvedsurface->modeler_format_version, modeler_format_version);
    revolvedsurface->modeler_format_version--;
  }
  {
    BITCODE_BL num_blocks;
    if (dwg_dynapi_entity_value (revolvedsurface, "REVOLVEDSURFACE", "num_blocks", &num_blocks, NULL)
        && num_blocks == revolvedsurface->num_blocks)
      pass ();
    else
      fail ("REVOLVEDSURFACE.num_blocks [BL] %u != %u", revolvedsurface->num_blocks, num_blocks);
    num_blocks++;
    if (dwg_dynapi_entity_set_value (revolvedsurface, "REVOLVEDSURFACE", "num_blocks", &num_blocks, 0)
        && num_blocks == revolvedsurface->num_blocks)
      pass ();
    else
      fail ("REVOLVEDSURFACE.num_blocks [BL] set+1 %u != %u", revolvedsurface->num_blocks, num_blocks);
    revolvedsurface->num_blocks--;
  }
  {
    BITCODE_BL num_materials;
    if (dwg_dynapi_entity_value (revolvedsurface, "REVOLVEDSURFACE", "num_materials", &num_materials, NULL)
        && num_materials == revolvedsurface->num_materials)
      pass ();
    else
      fail ("REVOLVEDSURFACE.num_materials [BL] %u != %u", revolvedsurface->num_materials, num_materials);
    num_materials++;
    if (dwg_dynapi_entity_set_value (revolvedsurface, "REVOLVEDSURFACE", "num_materials", &num_materials, 0)
        && num_materials == revolvedsurface->num_materials)
      pass ();
    else
      fail ("REVOLVEDSURFACE.num_materials [BL] set+1 %u != %u", revolvedsurface->num_materials, num_materials);
    revolvedsurface->num_materials--;
  }
  {
    BITCODE_BL num_silhouettes;
    if (dwg_dynapi_entity_value (revolvedsurface, "REVOLVEDSURFACE", "num_silhouettes", &num_silhouettes, NULL)
        && num_silhouettes == revolvedsurface->num_silhouettes)
      pass ();
    else
      fail ("REVOLVEDSURFACE.num_silhouettes [BL] %u != %u", revolvedsurface->num_silhouettes, num_silhouettes);
    num_silhouettes++;
    if (dwg_dynapi_entity_set_value (revolvedsurface, "REVOLVEDSURFACE", "num_silhouettes", &num_silhouettes, 0)
        && num_silhouettes == revolvedsurface->num_silhouettes)
      pass ();
    else
      fail ("REVOLVEDSURFACE.num_silhouettes [BL] set+1 %u != %u", revolvedsurface->num_silhouettes, num_silhouettes);
    revolvedsurface->num_silhouettes--;
  }
  {
    BITCODE_BL num_wires;
    if (dwg_dynapi_entity_value (revolvedsurface, "REVOLVEDSURFACE", "num_wires", &num_wires, NULL)
        && num_wires == revolvedsurface->num_wires)
      pass ();
    else
      fail ("REVOLVEDSURFACE.num_wires [BL] %u != %u", revolvedsurface->num_wires, num_wires);
    num_wires++;
    if (dwg_dynapi_entity_set_value (revolvedsurface, "REVOLVEDSURFACE", "num_wires", &num_wires, 0)
        && num_wires == revolvedsurface->num_wires)
      pass ();
    else
      fail ("REVOLVEDSURFACE.num_wires [BL] set+1 %u != %u", revolvedsurface->num_wires, num_wires);
    revolvedsurface->num_wires--;
  }
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value (revolvedsurface, "REVOLVEDSURFACE", "parent", &parent, NULL)
        && !memcmp (&parent, &revolvedsurface->parent, sizeof (struct _dwg_object_entity*)))
        pass ();
    else
        fail ("REVOLVEDSURFACE.parent [struct _dwg_object_entity*]");
  }
  {
    BITCODE_3BD point;
    if (dwg_dynapi_entity_value (revolvedsurface, "REVOLVEDSURFACE", "point", &point, NULL)
        && !memcmp (&point, &revolvedsurface->point, sizeof (BITCODE_3BD)))
        pass ();
    else
        fail ("REVOLVEDSURFACE.point [3BD]");
  }
  {
    BITCODE_B point_present;
    if (dwg_dynapi_entity_value (revolvedsurface, "REVOLVEDSURFACE", "point_present", &point_present, NULL)
        && point_present == revolvedsurface->point_present)
      pass ();
    else
      fail ("REVOLVEDSURFACE.point_present [B] " FORMAT_B " != " FORMAT_B "", revolvedsurface->point_present, point_present);
    point_present++;
    if (dwg_dynapi_entity_set_value (revolvedsurface, "REVOLVEDSURFACE", "point_present", &point_present, 0)
        && point_present == revolvedsurface->point_present)
      pass ();
    else
      fail ("REVOLVEDSURFACE.point_present [B] set+1 " FORMAT_B " != " FORMAT_B "", revolvedsurface->point_present, point_present);
    revolvedsurface->point_present--;
  }
  {
    BITCODE_RC revision_bytes[9];
    if (dwg_dynapi_entity_value (revolvedsurface, "REVOLVEDSURFACE", "revision_bytes[9]", &revision_bytes, NULL)
        && !memcmp (&revision_bytes, &revolvedsurface->revision_bytes, sizeof (BITCODE_RC)))
        pass ();
    else
        fail ("REVOLVEDSURFACE.revision_bytes[9] [RC]");
  }
  {
    BITCODE_RC revision_guid[39];
    if (dwg_dynapi_entity_value (revolvedsurface, "REVOLVEDSURFACE", "revision_guid[39]", &revision_guid, NULL)
        && !memcmp (&revision_guid, &revolvedsurface->revision_guid, sizeof (BITCODE_RC)))
        pass ();
    else
        fail ("REVOLVEDSURFACE.revision_guid[39] [RC]");
  }
  {
    BITCODE_BL revision_major;
    if (dwg_dynapi_entity_value (revolvedsurface, "REVOLVEDSURFACE", "revision_major", &revision_major, NULL)
        && revision_major == revolvedsurface->revision_major)
      pass ();
    else
      fail ("REVOLVEDSURFACE.revision_major [BL] %u != %u", revolvedsurface->revision_major, revision_major);
    revision_major++;
    if (dwg_dynapi_entity_set_value (revolvedsurface, "REVOLVEDSURFACE", "revision_major", &revision_major, 0)
        && revision_major == revolvedsurface->revision_major)
      pass ();
    else
      fail ("REVOLVEDSURFACE.revision_major [BL] set+1 %u != %u", revolvedsurface->revision_major, revision_major);
    revolvedsurface->revision_major--;
  }
  {
    BITCODE_BS revision_minor1;
    if (dwg_dynapi_entity_value (revolvedsurface, "REVOLVEDSURFACE", "revision_minor1", &revision_minor1, NULL)
        && revision_minor1 == revolvedsurface->revision_minor1)
      pass ();
    else
      fail ("REVOLVEDSURFACE.revision_minor1 [BS] %hu != %hu", revolvedsurface->revision_minor1, revision_minor1);
    revision_minor1++;
    if (dwg_dynapi_entity_set_value (revolvedsurface, "REVOLVEDSURFACE", "revision_minor1", &revision_minor1, 0)
        && revision_minor1 == revolvedsurface->revision_minor1)
      pass ();
    else
      fail ("REVOLVEDSURFACE.revision_minor1 [BS] set+1 %hu != %hu", revolvedsurface->revision_minor1, revision_minor1);
    revolvedsurface->revision_minor1--;
  }
  {
    BITCODE_BS revision_minor2;
    if (dwg_dynapi_entity_value (revolvedsurface, "REVOLVEDSURFACE", "revision_minor2", &revision_minor2, NULL)
        && revision_minor2 == revolvedsurface->revision_minor2)
      pass ();
    else
      fail ("REVOLVEDSURFACE.revision_minor2 [BS] %hu != %hu", revolvedsurface->revision_minor2, revision_minor2);
    revision_minor2++;
    if (dwg_dynapi_entity_set_value (revolvedsurface, "REVOLVEDSURFACE", "revision_minor2", &revision_minor2, 0)
        && revision_minor2 == revolvedsurface->revision_minor2)
      pass ();
    else
      fail ("REVOLVEDSURFACE.revision_minor2 [BS] set+1 %hu != %hu", revolvedsurface->revision_minor2, revision_minor2);
    revolvedsurface->revision_minor2--;
  }
  {
    BITCODE_BD revolve_angle;
    if (dwg_dynapi_entity_value (revolvedsurface, "REVOLVEDSURFACE", "revolve_angle", &revolve_angle, NULL)
        && revolve_angle == revolvedsurface->revolve_angle)
      pass ();
    else
      fail ("REVOLVEDSURFACE.revolve_angle [BD] %g != %g", revolvedsurface->revolve_angle, revolve_angle);
    revolve_angle++;
    if (dwg_dynapi_entity_set_value (revolvedsurface, "REVOLVEDSURFACE", "revolve_angle", &revolve_angle, 0)
        && revolve_angle == revolvedsurface->revolve_angle)
      pass ();
    else
      fail ("REVOLVEDSURFACE.revolve_angle [BD] set+1 %g != %g", revolvedsurface->revolve_angle, revolve_angle);
    revolvedsurface->revolve_angle--;
  }
  {
    BITCODE_BD* revolved_entity_transmatrix;
    if (dwg_dynapi_entity_value (revolvedsurface, "REVOLVEDSURFACE", "revolved_entity_transmatrix", &revolved_entity_transmatrix, NULL)
        && !memcmp (&revolved_entity_transmatrix, &revolvedsurface->revolved_entity_transmatrix, sizeof (BITCODE_BD*)))
        pass ();
    else
        fail ("REVOLVEDSURFACE.revolved_entity_transmatrix [BD*]");
  }
  {
    BITCODE_BL sab_size;
    if (dwg_dynapi_entity_value (revolvedsurface, "REVOLVEDSURFACE", "sab_size", &sab_size, NULL)
        && sab_size == revolvedsurface->sab_size)
      pass ();
    else
      fail ("REVOLVEDSURFACE.sab_size [BL] %u != %u", revolvedsurface->sab_size, sab_size);
    sab_size++;
    if (dwg_dynapi_entity_set_value (revolvedsurface, "REVOLVEDSURFACE", "sab_size", &sab_size, 0)
        && sab_size == revolvedsurface->sab_size)
      pass ();
    else
      fail ("REVOLVEDSURFACE.sab_size [BL] set+1 %u != %u", revolvedsurface->sab_size, sab_size);
    revolvedsurface->sab_size--;
  }
  {
    Dwg_3DSOLID_silhouette* silhouettes;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (revolvedsurface, "REVOLVEDSURFACE", "num_silhouettes", &count, NULL)
        && dwg_dynapi_entity_value (revolvedsurface, "REVOLVEDSURFACE", "silhouettes", &silhouettes, NULL)
        && silhouettes == revolvedsurface->silhouettes)
      pass ();
    else
      fail ("REVOLVEDSURFACE.silhouettes [Dwg_3DSOLID_silhouette*] * %u num_silhouettes", count);
  }
  {
    BITCODE_B solid;
    if (dwg_dynapi_entity_value (revolvedsurface, "REVOLVEDSURFACE", "solid", &solid, NULL)
        && solid == revolvedsurface->solid)
      pass ();
    else
      fail ("REVOLVEDSURFACE.solid [B] " FORMAT_B " != " FORMAT_B "", revolvedsurface->solid, solid);
    solid++;
    if (dwg_dynapi_entity_set_value (revolvedsurface, "REVOLVEDSURFACE", "solid", &solid, 0)
        && solid == revolvedsurface->solid)
      pass ();
    else
      fail ("REVOLVEDSURFACE.solid [B] set+1 " FORMAT_B " != " FORMAT_B "", revolvedsurface->solid, solid);
    revolvedsurface->solid--;
  }
  {
    BITCODE_BD start_angle;
    if (dwg_dynapi_entity_value (revolvedsurface, "REVOLVEDSURFACE", "start_angle", &start_angle, NULL)
        && start_angle == revolvedsurface->start_angle)
      pass ();
    else
      fail ("REVOLVEDSURFACE.start_angle [BD] %g != %g", revolvedsurface->start_angle, start_angle);
    start_angle++;
    if (dwg_dynapi_entity_set_value (revolvedsurface, "REVOLVEDSURFACE", "start_angle", &start_angle, 0)
        && start_angle == revolvedsurface->start_angle)
      pass ();
    else
      fail ("REVOLVEDSURFACE.start_angle [BD] set+1 %g != %g", revolvedsurface->start_angle, start_angle);
    revolvedsurface->start_angle--;
  }
  {
    BITCODE_BD twist_angle;
    if (dwg_dynapi_entity_value (revolvedsurface, "REVOLVEDSURFACE", "twist_angle", &twist_angle, NULL)
        && twist_angle == revolvedsurface->twist_angle)
      pass ();
    else
      fail ("REVOLVEDSURFACE.twist_angle [BD] %g != %g", revolvedsurface->twist_angle, twist_angle);
    twist_angle++;
    if (dwg_dynapi_entity_set_value (revolvedsurface, "REVOLVEDSURFACE", "twist_angle", &twist_angle, 0)
        && twist_angle == revolvedsurface->twist_angle)
      pass ();
    else
      fail ("REVOLVEDSURFACE.twist_angle [BD] set+1 %g != %g", revolvedsurface->twist_angle, twist_angle);
    revolvedsurface->twist_angle--;
  }
  {
    BITCODE_BS u_isolines;
    if (dwg_dynapi_entity_value (revolvedsurface, "REVOLVEDSURFACE", "u_isolines", &u_isolines, NULL)
        && u_isolines == revolvedsurface->u_isolines)
      pass ();
    else
      fail ("REVOLVEDSURFACE.u_isolines [BS] %hu != %hu", revolvedsurface->u_isolines, u_isolines);
    u_isolines++;
    if (dwg_dynapi_entity_set_value (revolvedsurface, "REVOLVEDSURFACE", "u_isolines", &u_isolines, 0)
        && u_isolines == revolvedsurface->u_isolines)
      pass ();
    else
      fail ("REVOLVEDSURFACE.u_isolines [BS] set+1 %hu != %hu", revolvedsurface->u_isolines, u_isolines);
    revolvedsurface->u_isolines--;
  }
  {
    BITCODE_B unknown;
    if (dwg_dynapi_entity_value (revolvedsurface, "REVOLVEDSURFACE", "unknown", &unknown, NULL)
        && unknown == revolvedsurface->unknown)
      pass ();
    else
      fail ("REVOLVEDSURFACE.unknown [B] " FORMAT_B " != " FORMAT_B "", revolvedsurface->unknown, unknown);
    unknown++;
    if (dwg_dynapi_entity_set_value (revolvedsurface, "REVOLVEDSURFACE", "unknown", &unknown, 0)
        && unknown == revolvedsurface->unknown)
      pass ();
    else
      fail ("REVOLVEDSURFACE.unknown [B] set+1 " FORMAT_B " != " FORMAT_B "", revolvedsurface->unknown, unknown);
    revolvedsurface->unknown--;
  }
  {
    BITCODE_BS v_isolines;
    if (dwg_dynapi_entity_value (revolvedsurface, "REVOLVEDSURFACE", "v_isolines", &v_isolines, NULL)
        && v_isolines == revolvedsurface->v_isolines)
      pass ();
    else
      fail ("REVOLVEDSURFACE.v_isolines [BS] %hu != %hu", revolvedsurface->v_isolines, v_isolines);
    v_isolines++;
    if (dwg_dynapi_entity_set_value (revolvedsurface, "REVOLVEDSURFACE", "v_isolines", &v_isolines, 0)
        && v_isolines == revolvedsurface->v_isolines)
      pass ();
    else
      fail ("REVOLVEDSURFACE.v_isolines [BS] set+1 %hu != %hu", revolvedsurface->v_isolines, v_isolines);
    revolvedsurface->v_isolines--;
  }
  {
    BITCODE_BS version;
    if (dwg_dynapi_entity_value (revolvedsurface, "REVOLVEDSURFACE", "version", &version, NULL)
        && version == revolvedsurface->version)
      pass ();
    else
      fail ("REVOLVEDSURFACE.version [BS] %hu != %hu", revolvedsurface->version, version);
    version++;
    if (dwg_dynapi_entity_set_value (revolvedsurface, "REVOLVEDSURFACE", "version", &version, 0)
        && version == revolvedsurface->version)
      pass ();
    else
      fail ("REVOLVEDSURFACE.version [BS] set+1 %hu != %hu", revolvedsurface->version, version);
    revolvedsurface->version--;
  }
  {
    BITCODE_B wireframe_data_present;
    if (dwg_dynapi_entity_value (revolvedsurface, "REVOLVEDSURFACE", "wireframe_data_present", &wireframe_data_present, NULL)
        && wireframe_data_present == revolvedsurface->wireframe_data_present)
      pass ();
    else
      fail ("REVOLVEDSURFACE.wireframe_data_present [B] " FORMAT_B " != " FORMAT_B "", revolvedsurface->wireframe_data_present, wireframe_data_present);
    wireframe_data_present++;
    if (dwg_dynapi_entity_set_value (revolvedsurface, "REVOLVEDSURFACE", "wireframe_data_present", &wireframe_data_present, 0)
        && wireframe_data_present == revolvedsurface->wireframe_data_present)
      pass ();
    else
      fail ("REVOLVEDSURFACE.wireframe_data_present [B] set+1 " FORMAT_B " != " FORMAT_B "", revolvedsurface->wireframe_data_present, wireframe_data_present);
    revolvedsurface->wireframe_data_present--;
  }
  {
    Dwg_3DSOLID_wire* wires;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (revolvedsurface, "REVOLVEDSURFACE", "num_wires", &count, NULL)
        && dwg_dynapi_entity_value (revolvedsurface, "REVOLVEDSURFACE", "wires", &wires, NULL)
        && wires == revolvedsurface->wires)
      pass ();
    else
      fail ("REVOLVEDSURFACE.wires [Dwg_3DSOLID_wire*] * %u num_wires", count);
  }
  if (failed && (is_class_unstable ("REVOLVEDSURFACE") || is_class_debugging ("REVOLVEDSURFACE")))
    {
      ok ("%s failed %d tests (TODO unstable)", "REVOLVEDSURFACE", failed);
      failed = 0;
    }
  return failed;
}
static int test_ROTATIONPARAMETERENTITY (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_ROTATIONPARAMETERENTITY *restrict rotationparameterentity = obj->tio.entity->tio.ROTATIONPARAMETERENTITY;
  failed = 0;
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value (rotationparameterentity, "ROTATIONPARAMETERENTITY", "parent", &parent, NULL)
        && !memcmp (&parent, &rotationparameterentity->parent, sizeof (struct _dwg_object_entity*)))
        pass ();
    else
        fail ("ROTATIONPARAMETERENTITY.parent [struct _dwg_object_entity*]");
  }
  if (failed && (is_class_unstable ("ROTATIONPARAMETERENTITY") || is_class_debugging ("ROTATIONPARAMETERENTITY")))
    {
      ok ("%s failed %d tests (TODO unstable)", "ROTATIONPARAMETERENTITY", failed);
      failed = 0;
    }
  return failed;
}
static int test_RTEXT (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_RTEXT *restrict rtext = obj->tio.entity->tio.RTEXT;
  failed = 0;
  {
    BITCODE_BE extrusion;
    if (dwg_dynapi_entity_value (rtext, "RTEXT", "extrusion", &extrusion, NULL)
        && !memcmp (&extrusion, &rtext->extrusion, sizeof (BITCODE_BE)))
        pass ();
    else
        fail ("RTEXT.extrusion [BE]");
  }
  {
    BITCODE_BS flags;
    if (dwg_dynapi_entity_value (rtext, "RTEXT", "flags", &flags, NULL)
        && flags == rtext->flags)
      pass ();
    else
      fail ("RTEXT.flags [BS] %hu != %hu", rtext->flags, flags);
    flags++;
    if (dwg_dynapi_entity_set_value (rtext, "RTEXT", "flags", &flags, 0)
        && flags == rtext->flags)
      pass ();
    else
      fail ("RTEXT.flags [BS] set+1 %hu != %hu", rtext->flags, flags);
    rtext->flags--;
  }
  {
    BITCODE_BD height;
    if (dwg_dynapi_entity_value (rtext, "RTEXT", "height", &height, NULL)
        && height == rtext->height)
      pass ();
    else
      fail ("RTEXT.height [BD] %g != %g", rtext->height, height);
    height++;
    if (dwg_dynapi_entity_set_value (rtext, "RTEXT", "height", &height, 0)
        && height == rtext->height)
      pass ();
    else
      fail ("RTEXT.height [BD] set+1 %g != %g", rtext->height, height);
    rtext->height--;
  }
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value (rtext, "RTEXT", "parent", &parent, NULL)
        && !memcmp (&parent, &rtext->parent, sizeof (struct _dwg_object_entity*)))
        pass ();
    else
        fail ("RTEXT.parent [struct _dwg_object_entity*]");
  }
  {
    BITCODE_3BD pt;
    if (dwg_dynapi_entity_value (rtext, "RTEXT", "pt", &pt, NULL)
        && !memcmp (&pt, &rtext->pt, sizeof (BITCODE_3BD)))
        pass ();
    else
        fail ("RTEXT.pt [3BD]");
  }
  {
    BITCODE_BD rotation;
    if (dwg_dynapi_entity_value (rtext, "RTEXT", "rotation", &rotation, NULL)
        && rotation == rtext->rotation)
      pass ();
    else
      fail ("RTEXT.rotation [BD] %g != %g", rtext->rotation, rotation);
    rotation++;
    if (dwg_dynapi_entity_set_value (rtext, "RTEXT", "rotation", &rotation, 0)
        && rotation == rtext->rotation)
      pass ();
    else
      fail ("RTEXT.rotation [BD] set+1 %g != %g", rtext->rotation, rotation);
    rtext->rotation--;
  }
  {
    BITCODE_H style;
    if (dwg_dynapi_entity_value (rtext, "RTEXT", "style", &style, NULL)
        && !memcmp (&style, &rtext->style, sizeof (BITCODE_H)))
        pass ();
    else
        fail ("RTEXT.style [H]");
  }
  {
    BITCODE_T text_value;
    if (dwg_dynapi_entity_value (rtext, "RTEXT", "text_value", &text_value, NULL)
        && text_value
           ? strEQ ((char *)text_value, (char *)rtext->text_value)
           : !rtext->text_value)
      pass ();
    else
      fail ("RTEXT.text_value [T] '%s' <> '%s'", text_value, rtext->text_value);
  }
  if (failed && (is_class_unstable ("RTEXT") || is_class_debugging ("RTEXT")))
    {
      ok ("%s failed %d tests (TODO unstable)", "RTEXT", failed);
      failed = 0;
    }
  return failed;
}
static int test_SECTIONOBJECT (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_SECTIONOBJECT *restrict sectionobject = obj->tio.entity->tio.SECTIONOBJECT;
  failed = 0;
  {
    BITCODE_3BD* blverts;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (sectionobject, "SECTIONOBJECT", "num_blverts", &count, NULL)
        && dwg_dynapi_entity_value (sectionobject, "SECTIONOBJECT", "blverts", &blverts, NULL)
        && blverts == sectionobject->blverts)
      pass ();
    else
      fail ("SECTIONOBJECT.blverts [3BD*] * %u num_blverts", count);
  }
  {
    BITCODE_BD bottom_height;
    if (dwg_dynapi_entity_value (sectionobject, "SECTIONOBJECT", "bottom_height", &bottom_height, NULL)
        && bottom_height == sectionobject->bottom_height)
      pass ();
    else
      fail ("SECTIONOBJECT.bottom_height [BD] %g != %g", sectionobject->bottom_height, bottom_height);
    bottom_height++;
    if (dwg_dynapi_entity_set_value (sectionobject, "SECTIONOBJECT", "bottom_height", &bottom_height, 0)
        && bottom_height == sectionobject->bottom_height)
      pass ();
    else
      fail ("SECTIONOBJECT.bottom_height [BD] set+1 %g != %g", sectionobject->bottom_height, bottom_height);
    sectionobject->bottom_height--;
  }
  {
    BITCODE_BL flags;
    if (dwg_dynapi_entity_value (sectionobject, "SECTIONOBJECT", "flags", &flags, NULL)
        && flags == sectionobject->flags)
      pass ();
    else
      fail ("SECTIONOBJECT.flags [BL] %u != %u", sectionobject->flags, flags);
    flags++;
    if (dwg_dynapi_entity_set_value (sectionobject, "SECTIONOBJECT", "flags", &flags, 0)
        && flags == sectionobject->flags)
      pass ();
    else
      fail ("SECTIONOBJECT.flags [BL] set+1 %u != %u", sectionobject->flags, flags);
    sectionobject->flags--;
  }
  {
    BITCODE_BS indicator_alpha;
    if (dwg_dynapi_entity_value (sectionobject, "SECTIONOBJECT", "indicator_alpha", &indicator_alpha, NULL)
        && indicator_alpha == sectionobject->indicator_alpha)
      pass ();
    else
      fail ("SECTIONOBJECT.indicator_alpha [BS] %hu != %hu", sectionobject->indicator_alpha, indicator_alpha);
    indicator_alpha++;
    if (dwg_dynapi_entity_set_value (sectionobject, "SECTIONOBJECT", "indicator_alpha", &indicator_alpha, 0)
        && indicator_alpha == sectionobject->indicator_alpha)
      pass ();
    else
      fail ("SECTIONOBJECT.indicator_alpha [BS] set+1 %hu != %hu", sectionobject->indicator_alpha, indicator_alpha);
    sectionobject->indicator_alpha--;
  }
  {
    BITCODE_CMC indicator_color;
    if (dwg_dynapi_entity_value (sectionobject, "SECTIONOBJECT", "indicator_color", &indicator_color, NULL)
        && !memcmp (&indicator_color, &sectionobject->indicator_color, sizeof (BITCODE_CMC)))
        pass ();
    else
        fail ("SECTIONOBJECT.indicator_color [CMC]");
  }
  {
    BITCODE_T name;
    if (dwg_dynapi_entity_value (sectionobject, "SECTIONOBJECT", "name", &name, NULL)
        && name
           ? strEQ ((char *)name, (char *)sectionobject->name)
           : !sectionobject->name)
      pass ();
    else
      fail ("SECTIONOBJECT.name [T] '%s' <> '%s'", name, sectionobject->name);
  }
  {
    BITCODE_BL num_blverts;
    if (dwg_dynapi_entity_value (sectionobject, "SECTIONOBJECT", "num_blverts", &num_blverts, NULL)
        && num_blverts == sectionobject->num_blverts)
      pass ();
    else
      fail ("SECTIONOBJECT.num_blverts [BL] %u != %u", sectionobject->num_blverts, num_blverts);
    num_blverts++;
    if (dwg_dynapi_entity_set_value (sectionobject, "SECTIONOBJECT", "num_blverts", &num_blverts, 0)
        && num_blverts == sectionobject->num_blverts)
      pass ();
    else
      fail ("SECTIONOBJECT.num_blverts [BL] set+1 %u != %u", sectionobject->num_blverts, num_blverts);
    sectionobject->num_blverts--;
  }
  {
    BITCODE_BL num_verts;
    if (dwg_dynapi_entity_value (sectionobject, "SECTIONOBJECT", "num_verts", &num_verts, NULL)
        && num_verts == sectionobject->num_verts)
      pass ();
    else
      fail ("SECTIONOBJECT.num_verts [BL] %u != %u", sectionobject->num_verts, num_verts);
    num_verts++;
    if (dwg_dynapi_entity_set_value (sectionobject, "SECTIONOBJECT", "num_verts", &num_verts, 0)
        && num_verts == sectionobject->num_verts)
      pass ();
    else
      fail ("SECTIONOBJECT.num_verts [BL] set+1 %u != %u", sectionobject->num_verts, num_verts);
    sectionobject->num_verts--;
  }
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value (sectionobject, "SECTIONOBJECT", "parent", &parent, NULL)
        && !memcmp (&parent, &sectionobject->parent, sizeof (struct _dwg_object_entity*)))
        pass ();
    else
        fail ("SECTIONOBJECT.parent [struct _dwg_object_entity*]");
  }
  {
    BITCODE_H section_settings;
    if (dwg_dynapi_entity_value (sectionobject, "SECTIONOBJECT", "section_settings", &section_settings, NULL)
        && !memcmp (&section_settings, &sectionobject->section_settings, sizeof (BITCODE_H)))
        pass ();
    else
        fail ("SECTIONOBJECT.section_settings [H]");
  }
  {
    BITCODE_BL state;
    if (dwg_dynapi_entity_value (sectionobject, "SECTIONOBJECT", "state", &state, NULL)
        && state == sectionobject->state)
      pass ();
    else
      fail ("SECTIONOBJECT.state [BL] %u != %u", sectionobject->state, state);
    state++;
    if (dwg_dynapi_entity_set_value (sectionobject, "SECTIONOBJECT", "state", &state, 0)
        && state == sectionobject->state)
      pass ();
    else
      fail ("SECTIONOBJECT.state [BL] set+1 %u != %u", sectionobject->state, state);
    sectionobject->state--;
  }
  {
    BITCODE_BD top_height;
    if (dwg_dynapi_entity_value (sectionobject, "SECTIONOBJECT", "top_height", &top_height, NULL)
        && top_height == sectionobject->top_height)
      pass ();
    else
      fail ("SECTIONOBJECT.top_height [BD] %g != %g", sectionobject->top_height, top_height);
    top_height++;
    if (dwg_dynapi_entity_set_value (sectionobject, "SECTIONOBJECT", "top_height", &top_height, 0)
        && top_height == sectionobject->top_height)
      pass ();
    else
      fail ("SECTIONOBJECT.top_height [BD] set+1 %g != %g", sectionobject->top_height, top_height);
    sectionobject->top_height--;
  }
  {
    BITCODE_3BD vert_dir;
    if (dwg_dynapi_entity_value (sectionobject, "SECTIONOBJECT", "vert_dir", &vert_dir, NULL)
        && !memcmp (&vert_dir, &sectionobject->vert_dir, sizeof (BITCODE_3BD)))
        pass ();
    else
        fail ("SECTIONOBJECT.vert_dir [3BD]");
  }
  {
    BITCODE_3BD* verts;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (sectionobject, "SECTIONOBJECT", "num_verts", &count, NULL)
        && dwg_dynapi_entity_value (sectionobject, "SECTIONOBJECT", "verts", &verts, NULL)
        && verts == sectionobject->verts)
      pass ();
    else
      fail ("SECTIONOBJECT.verts [3BD*] * %u num_verts", count);
  }
  if (failed && (is_class_unstable ("SECTIONOBJECT") || is_class_debugging ("SECTIONOBJECT")))
    {
      ok ("%s failed %d tests (TODO unstable)", "SECTIONOBJECT", failed);
      failed = 0;
    }
  return failed;
}
static int test_SEQEND (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_SEQEND *restrict seqend = obj->tio.entity->tio.SEQEND;
  failed = 0;
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value (seqend, "SEQEND", "parent", &parent, NULL)
        && !memcmp (&parent, &seqend->parent, sizeof (struct _dwg_object_entity*)))
        pass ();
    else
        fail ("SEQEND.parent [struct _dwg_object_entity*]");
  }
  if (failed && (is_class_unstable ("SEQEND") || is_class_debugging ("SEQEND")))
    {
      ok ("%s failed %d tests (TODO unstable)", "SEQEND", failed);
      failed = 0;
    }
  return failed;
}
static int test_SHAPE (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_SHAPE *restrict shape = obj->tio.entity->tio.SHAPE;
  failed = 0;
  {
    BITCODE_BE extrusion;
    if (dwg_dynapi_entity_value (shape, "SHAPE", "extrusion", &extrusion, NULL)
        && !memcmp (&extrusion, &shape->extrusion, sizeof (BITCODE_BE)))
        pass ();
    else
        fail ("SHAPE.extrusion [BE]");
  }
  {
    BITCODE_3BD ins_pt;
    if (dwg_dynapi_entity_value (shape, "SHAPE", "ins_pt", &ins_pt, NULL)
        && !memcmp (&ins_pt, &shape->ins_pt, sizeof (BITCODE_3BD)))
        pass ();
    else
        fail ("SHAPE.ins_pt [3BD]");
  }
  {
    BITCODE_BD oblique_angle;
    if (dwg_dynapi_entity_value (shape, "SHAPE", "oblique_angle", &oblique_angle, NULL)
        && oblique_angle == shape->oblique_angle)
      pass ();
    else
      fail ("SHAPE.oblique_angle [BD] %g != %g", shape->oblique_angle, oblique_angle);
    oblique_angle++;
    if (dwg_dynapi_entity_set_value (shape, "SHAPE", "oblique_angle", &oblique_angle, 0)
        && oblique_angle == shape->oblique_angle)
      pass ();
    else
      fail ("SHAPE.oblique_angle [BD] set+1 %g != %g", shape->oblique_angle, oblique_angle);
    shape->oblique_angle--;
  }
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value (shape, "SHAPE", "parent", &parent, NULL)
        && !memcmp (&parent, &shape->parent, sizeof (struct _dwg_object_entity*)))
        pass ();
    else
        fail ("SHAPE.parent [struct _dwg_object_entity*]");
  }
  {
    BITCODE_BD rotation;
    if (dwg_dynapi_entity_value (shape, "SHAPE", "rotation", &rotation, NULL)
        && rotation == shape->rotation)
      pass ();
    else
      fail ("SHAPE.rotation [BD] %g != %g", shape->rotation, rotation);
    rotation++;
    if (dwg_dynapi_entity_set_value (shape, "SHAPE", "rotation", &rotation, 0)
        && rotation == shape->rotation)
      pass ();
    else
      fail ("SHAPE.rotation [BD] set+1 %g != %g", shape->rotation, rotation);
    shape->rotation--;
  }
  {
    BITCODE_BD scale;
    if (dwg_dynapi_entity_value (shape, "SHAPE", "scale", &scale, NULL)
        && scale == shape->scale)
      pass ();
    else
      fail ("SHAPE.scale [BD] %g != %g", shape->scale, scale);
    scale++;
    if (dwg_dynapi_entity_set_value (shape, "SHAPE", "scale", &scale, 0)
        && scale == shape->scale)
      pass ();
    else
      fail ("SHAPE.scale [BD] set+1 %g != %g", shape->scale, scale);
    shape->scale--;
  }
  {
    BITCODE_H style;
    if (dwg_dynapi_entity_value (shape, "SHAPE", "style", &style, NULL)
        && !memcmp (&style, &shape->style, sizeof (BITCODE_H)))
        pass ();
    else
        fail ("SHAPE.style [H]");
  }
  {
    BITCODE_BS style_id;
    if (dwg_dynapi_entity_value (shape, "SHAPE", "style_id", &style_id, NULL)
        && style_id == shape->style_id)
      pass ();
    else
      fail ("SHAPE.style_id [BS] %hu != %hu", shape->style_id, style_id);
    style_id++;
    if (dwg_dynapi_entity_set_value (shape, "SHAPE", "style_id", &style_id, 0)
        && style_id == shape->style_id)
      pass ();
    else
      fail ("SHAPE.style_id [BS] set+1 %hu != %hu", shape->style_id, style_id);
    shape->style_id--;
  }
  {
    BITCODE_BD thickness;
    if (dwg_dynapi_entity_value (shape, "SHAPE", "thickness", &thickness, NULL)
        && thickness == shape->thickness)
      pass ();
    else
      fail ("SHAPE.thickness [BD] %g != %g", shape->thickness, thickness);
    thickness++;
    if (dwg_dynapi_entity_set_value (shape, "SHAPE", "thickness", &thickness, 0)
        && thickness == shape->thickness)
      pass ();
    else
      fail ("SHAPE.thickness [BD] set+1 %g != %g", shape->thickness, thickness);
    shape->thickness--;
  }
  {
    BITCODE_BD width_factor;
    if (dwg_dynapi_entity_value (shape, "SHAPE", "width_factor", &width_factor, NULL)
        && width_factor == shape->width_factor)
      pass ();
    else
      fail ("SHAPE.width_factor [BD] %g != %g", shape->width_factor, width_factor);
    width_factor++;
    if (dwg_dynapi_entity_set_value (shape, "SHAPE", "width_factor", &width_factor, 0)
        && width_factor == shape->width_factor)
      pass ();
    else
      fail ("SHAPE.width_factor [BD] set+1 %g != %g", shape->width_factor, width_factor);
    shape->width_factor--;
  }
  if (failed && (is_class_unstable ("SHAPE") || is_class_debugging ("SHAPE")))
    {
      ok ("%s failed %d tests (TODO unstable)", "SHAPE", failed);
      failed = 0;
    }
  return failed;
}
static int test_SOLID (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_SOLID *restrict solid = obj->tio.entity->tio.SOLID;
  failed = 0;
  {
    BITCODE_2RD corner1;
    if (dwg_dynapi_entity_value (solid, "SOLID", "corner1", &corner1, NULL)
        && !memcmp (&corner1, &solid->corner1, sizeof (BITCODE_2RD)))
        pass ();
    else
        fail ("SOLID.corner1 [2RD]");
  }
  {
    BITCODE_2RD corner2;
    if (dwg_dynapi_entity_value (solid, "SOLID", "corner2", &corner2, NULL)
        && !memcmp (&corner2, &solid->corner2, sizeof (BITCODE_2RD)))
        pass ();
    else
        fail ("SOLID.corner2 [2RD]");
  }
  {
    BITCODE_2RD corner3;
    if (dwg_dynapi_entity_value (solid, "SOLID", "corner3", &corner3, NULL)
        && !memcmp (&corner3, &solid->corner3, sizeof (BITCODE_2RD)))
        pass ();
    else
        fail ("SOLID.corner3 [2RD]");
  }
  {
    BITCODE_2RD corner4;
    if (dwg_dynapi_entity_value (solid, "SOLID", "corner4", &corner4, NULL)
        && !memcmp (&corner4, &solid->corner4, sizeof (BITCODE_2RD)))
        pass ();
    else
        fail ("SOLID.corner4 [2RD]");
  }
  {
    BITCODE_BD elevation;
    if (dwg_dynapi_entity_value (solid, "SOLID", "elevation", &elevation, NULL)
        && elevation == solid->elevation)
      pass ();
    else
      fail ("SOLID.elevation [BD] %g != %g", solid->elevation, elevation);
    elevation++;
    if (dwg_dynapi_entity_set_value (solid, "SOLID", "elevation", &elevation, 0)
        && elevation == solid->elevation)
      pass ();
    else
      fail ("SOLID.elevation [BD] set+1 %g != %g", solid->elevation, elevation);
    solid->elevation--;
  }
  {
    BITCODE_BE extrusion;
    if (dwg_dynapi_entity_value (solid, "SOLID", "extrusion", &extrusion, NULL)
        && !memcmp (&extrusion, &solid->extrusion, sizeof (BITCODE_BE)))
        pass ();
    else
        fail ("SOLID.extrusion [BE]");
  }
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value (solid, "SOLID", "parent", &parent, NULL)
        && !memcmp (&parent, &solid->parent, sizeof (struct _dwg_object_entity*)))
        pass ();
    else
        fail ("SOLID.parent [struct _dwg_object_entity*]");
  }
  {
    BITCODE_BT thickness;
    if (dwg_dynapi_entity_value (solid, "SOLID", "thickness", &thickness, NULL)
        && thickness == solid->thickness)
      pass ();
    else
      fail ("SOLID.thickness [BT] " FORMAT_BT " != " FORMAT_BT "", solid->thickness, thickness);
    if (dwg_dynapi_entity_set_value (solid, "SOLID", "thickness", &thickness, 0)
        && thickness == solid->thickness)
      pass ();
    else
      fail ("SOLID.thickness [BT] set+1 " FORMAT_BT " != " FORMAT_BT "", solid->thickness, thickness);
    solid->thickness--;
  }
  if (failed && (is_class_unstable ("SOLID") || is_class_debugging ("SOLID")))
    {
      ok ("%s failed %d tests (TODO unstable)", "SOLID", failed);
      failed = 0;
    }
  return failed;
}
static int test_SPLINE (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_SPLINE *restrict spline = obj->tio.entity->tio.SPLINE;
  failed = 0;
  {
    BITCODE_3BD beg_tan_vec;
    if (dwg_dynapi_entity_value (spline, "SPLINE", "beg_tan_vec", &beg_tan_vec, NULL)
        && !memcmp (&beg_tan_vec, &spline->beg_tan_vec, sizeof (BITCODE_3BD)))
        pass ();
    else
        fail ("SPLINE.beg_tan_vec [3BD]");
  }
  {
    BITCODE_B closed_b;
    if (dwg_dynapi_entity_value (spline, "SPLINE", "closed_b", &closed_b, NULL)
        && closed_b == spline->closed_b)
      pass ();
    else
      fail ("SPLINE.closed_b [B] " FORMAT_B " != " FORMAT_B "", spline->closed_b, closed_b);
    closed_b++;
    if (dwg_dynapi_entity_set_value (spline, "SPLINE", "closed_b", &closed_b, 0)
        && closed_b == spline->closed_b)
      pass ();
    else
      fail ("SPLINE.closed_b [B] set+1 " FORMAT_B " != " FORMAT_B "", spline->closed_b, closed_b);
    spline->closed_b--;
  }
  {
    Dwg_SPLINE_control_point* ctrl_pts;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (spline, "SPLINE", "num_ctrl_pts", &count, NULL)
        && dwg_dynapi_entity_value (spline, "SPLINE", "ctrl_pts", &ctrl_pts, NULL)
        && ctrl_pts == spline->ctrl_pts)
      pass ();
    else
      fail ("SPLINE.ctrl_pts [Dwg_SPLINE_control_point*] * %u num_ctrl_pts", count);
  }
  {
    BITCODE_BD ctrl_tol;
    if (dwg_dynapi_entity_value (spline, "SPLINE", "ctrl_tol", &ctrl_tol, NULL)
        && ctrl_tol == spline->ctrl_tol)
      pass ();
    else
      fail ("SPLINE.ctrl_tol [BD] %g != %g", spline->ctrl_tol, ctrl_tol);
    ctrl_tol++;
    if (dwg_dynapi_entity_set_value (spline, "SPLINE", "ctrl_tol", &ctrl_tol, 0)
        && ctrl_tol == spline->ctrl_tol)
      pass ();
    else
      fail ("SPLINE.ctrl_tol [BD] set+1 %g != %g", spline->ctrl_tol, ctrl_tol);
    spline->ctrl_tol--;
  }
  {
    BITCODE_BS degree;
    if (dwg_dynapi_entity_value (spline, "SPLINE", "degree", &degree, NULL)
        && degree == spline->degree)
      pass ();
    else
      fail ("SPLINE.degree [BS] %hu != %hu", spline->degree, degree);
    degree++;
    if (dwg_dynapi_entity_set_value (spline, "SPLINE", "degree", &degree, 0)
        && degree == spline->degree)
      pass ();
    else
      fail ("SPLINE.degree [BS] set+1 %hu != %hu", spline->degree, degree);
    spline->degree--;
  }
  {
    BITCODE_3BD end_tan_vec;
    if (dwg_dynapi_entity_value (spline, "SPLINE", "end_tan_vec", &end_tan_vec, NULL)
        && !memcmp (&end_tan_vec, &spline->end_tan_vec, sizeof (BITCODE_3BD)))
        pass ();
    else
        fail ("SPLINE.end_tan_vec [3BD]");
  }
  {
    BITCODE_3DPOINT* fit_pts;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (spline, "SPLINE", "num_fit_pts", &count, NULL)
        && dwg_dynapi_entity_value (spline, "SPLINE", "fit_pts", &fit_pts, NULL)
        && fit_pts == spline->fit_pts)
      pass ();
    else
      fail ("SPLINE.fit_pts [3DPOINT*] * %u num_fit_pts", count);
  }
  {
    BITCODE_BD fit_tol;
    if (dwg_dynapi_entity_value (spline, "SPLINE", "fit_tol", &fit_tol, NULL)
        && fit_tol == spline->fit_tol)
      pass ();
    else
      fail ("SPLINE.fit_tol [BD] %g != %g", spline->fit_tol, fit_tol);
    fit_tol++;
    if (dwg_dynapi_entity_set_value (spline, "SPLINE", "fit_tol", &fit_tol, 0)
        && fit_tol == spline->fit_tol)
      pass ();
    else
      fail ("SPLINE.fit_tol [BD] set+1 %g != %g", spline->fit_tol, fit_tol);
    spline->fit_tol--;
  }
  {
    BITCODE_RS flag;
    if (dwg_dynapi_entity_value (spline, "SPLINE", "flag", &flag, NULL)
        && flag == spline->flag)
      pass ();
    else
      fail ("SPLINE.flag [RS] %hu != %hu", spline->flag, flag);
    flag++;
    if (dwg_dynapi_entity_set_value (spline, "SPLINE", "flag", &flag, 0)
        && flag == spline->flag)
      pass ();
    else
      fail ("SPLINE.flag [RS] set+1 %hu != %hu", spline->flag, flag);
    spline->flag--;
  }
  {
    BITCODE_BD knot_tol;
    if (dwg_dynapi_entity_value (spline, "SPLINE", "knot_tol", &knot_tol, NULL)
        && knot_tol == spline->knot_tol)
      pass ();
    else
      fail ("SPLINE.knot_tol [BD] %g != %g", spline->knot_tol, knot_tol);
    knot_tol++;
    if (dwg_dynapi_entity_set_value (spline, "SPLINE", "knot_tol", &knot_tol, 0)
        && knot_tol == spline->knot_tol)
      pass ();
    else
      fail ("SPLINE.knot_tol [BD] set+1 %g != %g", spline->knot_tol, knot_tol);
    spline->knot_tol--;
  }
  {
    BITCODE_BL knotparam;
    if (dwg_dynapi_entity_value (spline, "SPLINE", "knotparam", &knotparam, NULL)
        && knotparam == spline->knotparam)
      pass ();
    else
      fail ("SPLINE.knotparam [BL] %u != %u", spline->knotparam, knotparam);
    knotparam++;
    if (dwg_dynapi_entity_set_value (spline, "SPLINE", "knotparam", &knotparam, 0)
        && knotparam == spline->knotparam)
      pass ();
    else
      fail ("SPLINE.knotparam [BL] set+1 %u != %u", spline->knotparam, knotparam);
    spline->knotparam--;
  }
  {
    BITCODE_BD* knots;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (spline, "SPLINE", "num_knots", &count, NULL)
        && dwg_dynapi_entity_value (spline, "SPLINE", "knots", &knots, NULL)
        && knots == spline->knots)
      pass ();
    else
      fail ("SPLINE.knots [BD*] * %u num_knots", count);
  }
  {
    BITCODE_BL num_ctrl_pts;
    if (dwg_dynapi_entity_value (spline, "SPLINE", "num_ctrl_pts", &num_ctrl_pts, NULL)
        && num_ctrl_pts == spline->num_ctrl_pts)
      pass ();
    else
      fail ("SPLINE.num_ctrl_pts [BL] %u != %u", spline->num_ctrl_pts, num_ctrl_pts);
    num_ctrl_pts++;
    if (dwg_dynapi_entity_set_value (spline, "SPLINE", "num_ctrl_pts", &num_ctrl_pts, 0)
        && num_ctrl_pts == spline->num_ctrl_pts)
      pass ();
    else
      fail ("SPLINE.num_ctrl_pts [BL] set+1 %u != %u", spline->num_ctrl_pts, num_ctrl_pts);
    spline->num_ctrl_pts--;
  }
  {
    BITCODE_BS num_fit_pts;
    if (dwg_dynapi_entity_value (spline, "SPLINE", "num_fit_pts", &num_fit_pts, NULL)
        && num_fit_pts == spline->num_fit_pts)
      pass ();
    else
      fail ("SPLINE.num_fit_pts [BS] %hu != %hu", spline->num_fit_pts, num_fit_pts);
    num_fit_pts++;
    if (dwg_dynapi_entity_set_value (spline, "SPLINE", "num_fit_pts", &num_fit_pts, 0)
        && num_fit_pts == spline->num_fit_pts)
      pass ();
    else
      fail ("SPLINE.num_fit_pts [BS] set+1 %hu != %hu", spline->num_fit_pts, num_fit_pts);
    spline->num_fit_pts--;
  }
  {
    BITCODE_BL num_knots;
    if (dwg_dynapi_entity_value (spline, "SPLINE", "num_knots", &num_knots, NULL)
        && num_knots == spline->num_knots)
      pass ();
    else
      fail ("SPLINE.num_knots [BL] %u != %u", spline->num_knots, num_knots);
    num_knots++;
    if (dwg_dynapi_entity_set_value (spline, "SPLINE", "num_knots", &num_knots, 0)
        && num_knots == spline->num_knots)
      pass ();
    else
      fail ("SPLINE.num_knots [BL] set+1 %u != %u", spline->num_knots, num_knots);
    spline->num_knots--;
  }
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value (spline, "SPLINE", "parent", &parent, NULL)
        && !memcmp (&parent, &spline->parent, sizeof (struct _dwg_object_entity*)))
        pass ();
    else
        fail ("SPLINE.parent [struct _dwg_object_entity*]");
  }
  {
    BITCODE_B periodic;
    if (dwg_dynapi_entity_value (spline, "SPLINE", "periodic", &periodic, NULL)
        && periodic == spline->periodic)
      pass ();
    else
      fail ("SPLINE.periodic [B] " FORMAT_B " != " FORMAT_B "", spline->periodic, periodic);
    periodic++;
    if (dwg_dynapi_entity_set_value (spline, "SPLINE", "periodic", &periodic, 0)
        && periodic == spline->periodic)
      pass ();
    else
      fail ("SPLINE.periodic [B] set+1 " FORMAT_B " != " FORMAT_B "", spline->periodic, periodic);
    spline->periodic--;
  }
  {
    BITCODE_B rational;
    if (dwg_dynapi_entity_value (spline, "SPLINE", "rational", &rational, NULL)
        && rational == spline->rational)
      pass ();
    else
      fail ("SPLINE.rational [B] " FORMAT_B " != " FORMAT_B "", spline->rational, rational);
    rational++;
    if (dwg_dynapi_entity_set_value (spline, "SPLINE", "rational", &rational, 0)
        && rational == spline->rational)
      pass ();
    else
      fail ("SPLINE.rational [B] set+1 " FORMAT_B " != " FORMAT_B "", spline->rational, rational);
    spline->rational--;
  }
  {
    BITCODE_BS scenario;
    if (dwg_dynapi_entity_value (spline, "SPLINE", "scenario", &scenario, NULL)
        && scenario == spline->scenario)
      pass ();
    else
      fail ("SPLINE.scenario [BS] %hu != %hu", spline->scenario, scenario);
    scenario++;
    if (dwg_dynapi_entity_set_value (spline, "SPLINE", "scenario", &scenario, 0)
        && scenario == spline->scenario)
      pass ();
    else
      fail ("SPLINE.scenario [BS] set+1 %hu != %hu", spline->scenario, scenario);
    spline->scenario--;
  }
  {
    BITCODE_BL splineflags1;
    if (dwg_dynapi_entity_value (spline, "SPLINE", "splineflags1", &splineflags1, NULL)
        && splineflags1 == spline->splineflags1)
      pass ();
    else
      fail ("SPLINE.splineflags1 [BL] %u != %u", spline->splineflags1, splineflags1);
    splineflags1++;
    if (dwg_dynapi_entity_set_value (spline, "SPLINE", "splineflags1", &splineflags1, 0)
        && splineflags1 == spline->splineflags1)
      pass ();
    else
      fail ("SPLINE.splineflags1 [BL] set+1 %u != %u", spline->splineflags1, splineflags1);
    spline->splineflags1--;
  }
  {
    BITCODE_B weighted;
    if (dwg_dynapi_entity_value (spline, "SPLINE", "weighted", &weighted, NULL)
        && weighted == spline->weighted)
      pass ();
    else
      fail ("SPLINE.weighted [B] " FORMAT_B " != " FORMAT_B "", spline->weighted, weighted);
    weighted++;
    if (dwg_dynapi_entity_set_value (spline, "SPLINE", "weighted", &weighted, 0)
        && weighted == spline->weighted)
      pass ();
    else
      fail ("SPLINE.weighted [B] set+1 " FORMAT_B " != " FORMAT_B "", spline->weighted, weighted);
    spline->weighted--;
  }
  if (failed && (is_class_unstable ("SPLINE") || is_class_debugging ("SPLINE")))
    {
      ok ("%s failed %d tests (TODO unstable)", "SPLINE", failed);
      failed = 0;
    }
  return failed;
}
static int test_SWEPTSURFACE (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_SWEPTSURFACE *restrict sweptsurface = obj->tio.entity->tio.SWEPTSURFACE;
  failed = 0;
  {
    BITCODE_B _dxf_sab_converted;
    if (dwg_dynapi_entity_value (sweptsurface, "SWEPTSURFACE", "_dxf_sab_converted", &_dxf_sab_converted, NULL)
        && _dxf_sab_converted == sweptsurface->_dxf_sab_converted)
      pass ();
    else
      fail ("SWEPTSURFACE._dxf_sab_converted [B] " FORMAT_B " != " FORMAT_B "", sweptsurface->_dxf_sab_converted, _dxf_sab_converted);
    _dxf_sab_converted++;
    if (dwg_dynapi_entity_set_value (sweptsurface, "SWEPTSURFACE", "_dxf_sab_converted", &_dxf_sab_converted, 0)
        && _dxf_sab_converted == sweptsurface->_dxf_sab_converted)
      pass ();
    else
      fail ("SWEPTSURFACE._dxf_sab_converted [B] set+1 " FORMAT_B " != " FORMAT_B "", sweptsurface->_dxf_sab_converted, _dxf_sab_converted);
    sweptsurface->_dxf_sab_converted--;
  }
  {
    BITCODE_RC* acis_data;
    if (dwg_dynapi_entity_value (sweptsurface, "SWEPTSURFACE", "acis_data", &acis_data, NULL)
        && acis_data
           ? strEQ ((char *)acis_data, (char *)sweptsurface->acis_data)
           : !sweptsurface->acis_data)
      pass ();
    else
      fail ("SWEPTSURFACE.acis_data [RC*] '%s' <> '%s'", acis_data, sweptsurface->acis_data);
  }
  {
    BITCODE_B acis_empty;
    if (dwg_dynapi_entity_value (sweptsurface, "SWEPTSURFACE", "acis_empty", &acis_empty, NULL)
        && acis_empty == sweptsurface->acis_empty)
      pass ();
    else
      fail ("SWEPTSURFACE.acis_empty [B] " FORMAT_B " != " FORMAT_B "", sweptsurface->acis_empty, acis_empty);
    acis_empty++;
    if (dwg_dynapi_entity_set_value (sweptsurface, "SWEPTSURFACE", "acis_empty", &acis_empty, 0)
        && acis_empty == sweptsurface->acis_empty)
      pass ();
    else
      fail ("SWEPTSURFACE.acis_empty [B] set+1 " FORMAT_B " != " FORMAT_B "", sweptsurface->acis_empty, acis_empty);
    sweptsurface->acis_empty--;
  }
  {
    BITCODE_B acis_empty2;
    if (dwg_dynapi_entity_value (sweptsurface, "SWEPTSURFACE", "acis_empty2", &acis_empty2, NULL)
        && acis_empty2 == sweptsurface->acis_empty2)
      pass ();
    else
      fail ("SWEPTSURFACE.acis_empty2 [B] " FORMAT_B " != " FORMAT_B "", sweptsurface->acis_empty2, acis_empty2);
    acis_empty2++;
    if (dwg_dynapi_entity_set_value (sweptsurface, "SWEPTSURFACE", "acis_empty2", &acis_empty2, 0)
        && acis_empty2 == sweptsurface->acis_empty2)
      pass ();
    else
      fail ("SWEPTSURFACE.acis_empty2 [B] set+1 " FORMAT_B " != " FORMAT_B "", sweptsurface->acis_empty2, acis_empty2);
    sweptsurface->acis_empty2--;
  }
  {
    BITCODE_B acis_empty_bit;
    if (dwg_dynapi_entity_value (sweptsurface, "SWEPTSURFACE", "acis_empty_bit", &acis_empty_bit, NULL)
        && acis_empty_bit == sweptsurface->acis_empty_bit)
      pass ();
    else
      fail ("SWEPTSURFACE.acis_empty_bit [B] " FORMAT_B " != " FORMAT_B "", sweptsurface->acis_empty_bit, acis_empty_bit);
    acis_empty_bit++;
    if (dwg_dynapi_entity_set_value (sweptsurface, "SWEPTSURFACE", "acis_empty_bit", &acis_empty_bit, 0)
        && acis_empty_bit == sweptsurface->acis_empty_bit)
      pass ();
    else
      fail ("SWEPTSURFACE.acis_empty_bit [B] set+1 " FORMAT_B " != " FORMAT_B "", sweptsurface->acis_empty_bit, acis_empty_bit);
    sweptsurface->acis_empty_bit--;
  }
  {
    BITCODE_BD align_angle;
    if (dwg_dynapi_entity_value (sweptsurface, "SWEPTSURFACE", "align_angle", &align_angle, NULL)
        && align_angle == sweptsurface->align_angle)
      pass ();
    else
      fail ("SWEPTSURFACE.align_angle [BD] %g != %g", sweptsurface->align_angle, align_angle);
    align_angle++;
    if (dwg_dynapi_entity_set_value (sweptsurface, "SWEPTSURFACE", "align_angle", &align_angle, 0)
        && align_angle == sweptsurface->align_angle)
      pass ();
    else
      fail ("SWEPTSURFACE.align_angle [BD] set+1 %g != %g", sweptsurface->align_angle, align_angle);
    sweptsurface->align_angle--;
  }
  {
    BITCODE_B align_start;
    if (dwg_dynapi_entity_value (sweptsurface, "SWEPTSURFACE", "align_start", &align_start, NULL)
        && align_start == sweptsurface->align_start)
      pass ();
    else
      fail ("SWEPTSURFACE.align_start [B] " FORMAT_B " != " FORMAT_B "", sweptsurface->align_start, align_start);
    align_start++;
    if (dwg_dynapi_entity_set_value (sweptsurface, "SWEPTSURFACE", "align_start", &align_start, 0)
        && align_start == sweptsurface->align_start)
      pass ();
    else
      fail ("SWEPTSURFACE.align_start [B] set+1 " FORMAT_B " != " FORMAT_B "", sweptsurface->align_start, align_start);
    sweptsurface->align_start--;
  }
  {
    BITCODE_B bank;
    if (dwg_dynapi_entity_value (sweptsurface, "SWEPTSURFACE", "bank", &bank, NULL)
        && bank == sweptsurface->bank)
      pass ();
    else
      fail ("SWEPTSURFACE.bank [B] " FORMAT_B " != " FORMAT_B "", sweptsurface->bank, bank);
    bank++;
    if (dwg_dynapi_entity_set_value (sweptsurface, "SWEPTSURFACE", "bank", &bank, 0)
        && bank == sweptsurface->bank)
      pass ();
    else
      fail ("SWEPTSURFACE.bank [B] set+1 " FORMAT_B " != " FORMAT_B "", sweptsurface->bank, bank);
    sweptsurface->bank--;
  }
  {
    BITCODE_B base_point_set;
    if (dwg_dynapi_entity_value (sweptsurface, "SWEPTSURFACE", "base_point_set", &base_point_set, NULL)
        && base_point_set == sweptsurface->base_point_set)
      pass ();
    else
      fail ("SWEPTSURFACE.base_point_set [B] " FORMAT_B " != " FORMAT_B "", sweptsurface->base_point_set, base_point_set);
    base_point_set++;
    if (dwg_dynapi_entity_set_value (sweptsurface, "SWEPTSURFACE", "base_point_set", &base_point_set, 0)
        && base_point_set == sweptsurface->base_point_set)
      pass ();
    else
      fail ("SWEPTSURFACE.base_point_set [B] set+1 " FORMAT_B " != " FORMAT_B "", sweptsurface->base_point_set, base_point_set);
    sweptsurface->base_point_set--;
  }
  {
    BITCODE_BL* block_size;
    if (dwg_dynapi_entity_value (sweptsurface, "SWEPTSURFACE", "block_size", &block_size, NULL)
        && !memcmp (&block_size, &sweptsurface->block_size, sizeof (BITCODE_BL*)))
        pass ();
    else
        fail ("SWEPTSURFACE.block_size [BL*]");
  }
  {
    BITCODE_BL class_version;
    if (dwg_dynapi_entity_value (sweptsurface, "SWEPTSURFACE", "class_version", &class_version, NULL)
        && class_version == sweptsurface->class_version)
      pass ();
    else
      fail ("SWEPTSURFACE.class_version [BL] %u != %u", sweptsurface->class_version, class_version);
    class_version++;
    if (dwg_dynapi_entity_set_value (sweptsurface, "SWEPTSURFACE", "class_version", &class_version, 0)
        && class_version == sweptsurface->class_version)
      pass ();
    else
      fail ("SWEPTSURFACE.class_version [BL] set+1 %u != %u", sweptsurface->class_version, class_version);
    sweptsurface->class_version--;
  }
  {
    BITCODE_BD draft_angle;
    if (dwg_dynapi_entity_value (sweptsurface, "SWEPTSURFACE", "draft_angle", &draft_angle, NULL)
        && draft_angle == sweptsurface->draft_angle)
      pass ();
    else
      fail ("SWEPTSURFACE.draft_angle [BD] %g != %g", sweptsurface->draft_angle, draft_angle);
    draft_angle++;
    if (dwg_dynapi_entity_set_value (sweptsurface, "SWEPTSURFACE", "draft_angle", &draft_angle, 0)
        && draft_angle == sweptsurface->draft_angle)
      pass ();
    else
      fail ("SWEPTSURFACE.draft_angle [BD] set+1 %g != %g", sweptsurface->draft_angle, draft_angle);
    sweptsurface->draft_angle--;
  }
  {
    BITCODE_BD draft_end_distance;
    if (dwg_dynapi_entity_value (sweptsurface, "SWEPTSURFACE", "draft_end_distance", &draft_end_distance, NULL)
        && draft_end_distance == sweptsurface->draft_end_distance)
      pass ();
    else
      fail ("SWEPTSURFACE.draft_end_distance [BD] %g != %g", sweptsurface->draft_end_distance, draft_end_distance);
    draft_end_distance++;
    if (dwg_dynapi_entity_set_value (sweptsurface, "SWEPTSURFACE", "draft_end_distance", &draft_end_distance, 0)
        && draft_end_distance == sweptsurface->draft_end_distance)
      pass ();
    else
      fail ("SWEPTSURFACE.draft_end_distance [BD] set+1 %g != %g", sweptsurface->draft_end_distance, draft_end_distance);
    sweptsurface->draft_end_distance--;
  }
  {
    BITCODE_BD draft_start_distance;
    if (dwg_dynapi_entity_value (sweptsurface, "SWEPTSURFACE", "draft_start_distance", &draft_start_distance, NULL)
        && draft_start_distance == sweptsurface->draft_start_distance)
      pass ();
    else
      fail ("SWEPTSURFACE.draft_start_distance [BD] %g != %g", sweptsurface->draft_start_distance, draft_start_distance);
    draft_start_distance++;
    if (dwg_dynapi_entity_set_value (sweptsurface, "SWEPTSURFACE", "draft_start_distance", &draft_start_distance, 0)
        && draft_start_distance == sweptsurface->draft_start_distance)
      pass ();
    else
      fail ("SWEPTSURFACE.draft_start_distance [BD] set+1 %g != %g", sweptsurface->draft_start_distance, draft_start_distance);
    sweptsurface->draft_start_distance--;
  }
  {
    char ** encr_sat_data;
    if (dwg_dynapi_entity_value (sweptsurface, "SWEPTSURFACE", "encr_sat_data", &encr_sat_data, NULL)
        && !memcmp (&encr_sat_data, &sweptsurface->encr_sat_data, sizeof (sweptsurface->encr_sat_data)))
      pass ();
    else
      fail ("SWEPTSURFACE.encr_sat_data [char **]");
  }
  {
    BITCODE_BL end_marker;
    if (dwg_dynapi_entity_value (sweptsurface, "SWEPTSURFACE", "end_marker", &end_marker, NULL)
        && end_marker == sweptsurface->end_marker)
      pass ();
    else
      fail ("SWEPTSURFACE.end_marker [BL] %u != %u", sweptsurface->end_marker, end_marker);
    end_marker++;
    if (dwg_dynapi_entity_set_value (sweptsurface, "SWEPTSURFACE", "end_marker", &end_marker, 0)
        && end_marker == sweptsurface->end_marker)
      pass ();
    else
      fail ("SWEPTSURFACE.end_marker [BL] set+1 %u != %u", sweptsurface->end_marker, end_marker);
    sweptsurface->end_marker--;
  }
  {
    struct _dwg_entity_3DSOLID* extra_acis_data;
    if (dwg_dynapi_entity_value (sweptsurface, "SWEPTSURFACE", "extra_acis_data", &extra_acis_data, NULL)
        && !memcmp (&extra_acis_data, &sweptsurface->extra_acis_data, sizeof (struct _dwg_entity_3DSOLID*)))
        pass ();
    else
        fail ("SWEPTSURFACE.extra_acis_data [struct _dwg_entity_3DSOLID*]");
  }
  {
    BITCODE_B has_revision_guid;
    if (dwg_dynapi_entity_value (sweptsurface, "SWEPTSURFACE", "has_revision_guid", &has_revision_guid, NULL)
        && has_revision_guid == sweptsurface->has_revision_guid)
      pass ();
    else
      fail ("SWEPTSURFACE.has_revision_guid [B] " FORMAT_B " != " FORMAT_B "", sweptsurface->has_revision_guid, has_revision_guid);
    has_revision_guid++;
    if (dwg_dynapi_entity_set_value (sweptsurface, "SWEPTSURFACE", "has_revision_guid", &has_revision_guid, 0)
        && has_revision_guid == sweptsurface->has_revision_guid)
      pass ();
    else
      fail ("SWEPTSURFACE.has_revision_guid [B] set+1 " FORMAT_B " != " FORMAT_B "", sweptsurface->has_revision_guid, has_revision_guid);
    sweptsurface->has_revision_guid--;
  }
  {
    BITCODE_H history_id;
    if (dwg_dynapi_entity_value (sweptsurface, "SWEPTSURFACE", "history_id", &history_id, NULL)
        && !memcmp (&history_id, &sweptsurface->history_id, sizeof (BITCODE_H)))
        pass ();
    else
        fail ("SWEPTSURFACE.history_id [H]");
  }
  {
    BITCODE_B is_solid;
    if (dwg_dynapi_entity_value (sweptsurface, "SWEPTSURFACE", "is_solid", &is_solid, NULL)
        && is_solid == sweptsurface->is_solid)
      pass ();
    else
      fail ("SWEPTSURFACE.is_solid [B] " FORMAT_B " != " FORMAT_B "", sweptsurface->is_solid, is_solid);
    is_solid++;
    if (dwg_dynapi_entity_set_value (sweptsurface, "SWEPTSURFACE", "is_solid", &is_solid, 0)
        && is_solid == sweptsurface->is_solid)
      pass ();
    else
      fail ("SWEPTSURFACE.is_solid [B] set+1 " FORMAT_B " != " FORMAT_B "", sweptsurface->is_solid, is_solid);
    sweptsurface->is_solid--;
  }
  {
    BITCODE_B isoline_present;
    if (dwg_dynapi_entity_value (sweptsurface, "SWEPTSURFACE", "isoline_present", &isoline_present, NULL)
        && isoline_present == sweptsurface->isoline_present)
      pass ();
    else
      fail ("SWEPTSURFACE.isoline_present [B] " FORMAT_B " != " FORMAT_B "", sweptsurface->isoline_present, isoline_present);
    isoline_present++;
    if (dwg_dynapi_entity_set_value (sweptsurface, "SWEPTSURFACE", "isoline_present", &isoline_present, 0)
        && isoline_present == sweptsurface->isoline_present)
      pass ();
    else
      fail ("SWEPTSURFACE.isoline_present [B] set+1 " FORMAT_B " != " FORMAT_B "", sweptsurface->isoline_present, isoline_present);
    sweptsurface->isoline_present--;
  }
  {
    BITCODE_BL isolines;
    if (dwg_dynapi_entity_value (sweptsurface, "SWEPTSURFACE", "isolines", &isolines, NULL)
        && isolines == sweptsurface->isolines)
      pass ();
    else
      fail ("SWEPTSURFACE.isolines [BL] %u != %u", sweptsurface->isolines, isolines);
    isolines++;
    if (dwg_dynapi_entity_set_value (sweptsurface, "SWEPTSURFACE", "isolines", &isolines, 0)
        && isolines == sweptsurface->isolines)
      pass ();
    else
      fail ("SWEPTSURFACE.isolines [BL] set+1 %u != %u", sweptsurface->isolines, isolines);
    sweptsurface->isolines--;
  }
  {
    Dwg_3DSOLID_material* materials;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (sweptsurface, "SWEPTSURFACE", "num_materials", &count, NULL)
        && dwg_dynapi_entity_value (sweptsurface, "SWEPTSURFACE", "materials", &materials, NULL)
        && materials == sweptsurface->materials)
      pass ();
    else
      fail ("SWEPTSURFACE.materials [Dwg_3DSOLID_material*] * %u num_materials", count);
  }
  {
    BITCODE_BS modeler_format_version;
    if (dwg_dynapi_entity_value (sweptsurface, "SWEPTSURFACE", "modeler_format_version", &modeler_format_version, NULL)
        && modeler_format_version == sweptsurface->modeler_format_version)
      pass ();
    else
      fail ("SWEPTSURFACE.modeler_format_version [BS] %hu != %hu", sweptsurface->modeler_format_version, modeler_format_version);
    modeler_format_version++;
    if (dwg_dynapi_entity_set_value (sweptsurface, "SWEPTSURFACE", "modeler_format_version", &modeler_format_version, 0)
        && modeler_format_version == sweptsurface->modeler_format_version)
      pass ();
    else
      fail ("SWEPTSURFACE.modeler_format_version [BS] set+1 %hu != %hu", sweptsurface->modeler_format_version, modeler_format_version);
    sweptsurface->modeler_format_version--;
  }
  {
    BITCODE_BL num_blocks;
    if (dwg_dynapi_entity_value (sweptsurface, "SWEPTSURFACE", "num_blocks", &num_blocks, NULL)
        && num_blocks == sweptsurface->num_blocks)
      pass ();
    else
      fail ("SWEPTSURFACE.num_blocks [BL] %u != %u", sweptsurface->num_blocks, num_blocks);
    num_blocks++;
    if (dwg_dynapi_entity_set_value (sweptsurface, "SWEPTSURFACE", "num_blocks", &num_blocks, 0)
        && num_blocks == sweptsurface->num_blocks)
      pass ();
    else
      fail ("SWEPTSURFACE.num_blocks [BL] set+1 %u != %u", sweptsurface->num_blocks, num_blocks);
    sweptsurface->num_blocks--;
  }
  {
    BITCODE_BL num_materials;
    if (dwg_dynapi_entity_value (sweptsurface, "SWEPTSURFACE", "num_materials", &num_materials, NULL)
        && num_materials == sweptsurface->num_materials)
      pass ();
    else
      fail ("SWEPTSURFACE.num_materials [BL] %u != %u", sweptsurface->num_materials, num_materials);
    num_materials++;
    if (dwg_dynapi_entity_set_value (sweptsurface, "SWEPTSURFACE", "num_materials", &num_materials, 0)
        && num_materials == sweptsurface->num_materials)
      pass ();
    else
      fail ("SWEPTSURFACE.num_materials [BL] set+1 %u != %u", sweptsurface->num_materials, num_materials);
    sweptsurface->num_materials--;
  }
  {
    BITCODE_BL num_silhouettes;
    if (dwg_dynapi_entity_value (sweptsurface, "SWEPTSURFACE", "num_silhouettes", &num_silhouettes, NULL)
        && num_silhouettes == sweptsurface->num_silhouettes)
      pass ();
    else
      fail ("SWEPTSURFACE.num_silhouettes [BL] %u != %u", sweptsurface->num_silhouettes, num_silhouettes);
    num_silhouettes++;
    if (dwg_dynapi_entity_set_value (sweptsurface, "SWEPTSURFACE", "num_silhouettes", &num_silhouettes, 0)
        && num_silhouettes == sweptsurface->num_silhouettes)
      pass ();
    else
      fail ("SWEPTSURFACE.num_silhouettes [BL] set+1 %u != %u", sweptsurface->num_silhouettes, num_silhouettes);
    sweptsurface->num_silhouettes--;
  }
  {
    BITCODE_BL num_wires;
    if (dwg_dynapi_entity_value (sweptsurface, "SWEPTSURFACE", "num_wires", &num_wires, NULL)
        && num_wires == sweptsurface->num_wires)
      pass ();
    else
      fail ("SWEPTSURFACE.num_wires [BL] %u != %u", sweptsurface->num_wires, num_wires);
    num_wires++;
    if (dwg_dynapi_entity_set_value (sweptsurface, "SWEPTSURFACE", "num_wires", &num_wires, 0)
        && num_wires == sweptsurface->num_wires)
      pass ();
    else
      fail ("SWEPTSURFACE.num_wires [BL] set+1 %u != %u", sweptsurface->num_wires, num_wires);
    sweptsurface->num_wires--;
  }
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value (sweptsurface, "SWEPTSURFACE", "parent", &parent, NULL)
        && !memcmp (&parent, &sweptsurface->parent, sizeof (struct _dwg_object_entity*)))
        pass ();
    else
        fail ("SWEPTSURFACE.parent [struct _dwg_object_entity*]");
  }
  {
    BITCODE_H path_entity;
    if (dwg_dynapi_entity_value (sweptsurface, "SWEPTSURFACE", "path_entity", &path_entity, NULL)
        && !memcmp (&path_entity, &sweptsurface->path_entity, sizeof (BITCODE_H)))
        pass ();
    else
        fail ("SWEPTSURFACE.path_entity [H]");
  }
  {
    BITCODE_BL path_entity_id;
    if (dwg_dynapi_entity_value (sweptsurface, "SWEPTSURFACE", "path_entity_id", &path_entity_id, NULL)
        && path_entity_id == sweptsurface->path_entity_id)
      pass ();
    else
      fail ("SWEPTSURFACE.path_entity_id [BL] %u != %u", sweptsurface->path_entity_id, path_entity_id);
    path_entity_id++;
    if (dwg_dynapi_entity_set_value (sweptsurface, "SWEPTSURFACE", "path_entity_id", &path_entity_id, 0)
        && path_entity_id == sweptsurface->path_entity_id)
      pass ();
    else
      fail ("SWEPTSURFACE.path_entity_id [BL] set+1 %u != %u", sweptsurface->path_entity_id, path_entity_id);
    sweptsurface->path_entity_id--;
  }
  {
    BITCODE_B path_entity_transform_computed;
    if (dwg_dynapi_entity_value (sweptsurface, "SWEPTSURFACE", "path_entity_transform_computed", &path_entity_transform_computed, NULL)
        && path_entity_transform_computed == sweptsurface->path_entity_transform_computed)
      pass ();
    else
      fail ("SWEPTSURFACE.path_entity_transform_computed [B] " FORMAT_B " != " FORMAT_B "", sweptsurface->path_entity_transform_computed, path_entity_transform_computed);
    path_entity_transform_computed++;
    if (dwg_dynapi_entity_set_value (sweptsurface, "SWEPTSURFACE", "path_entity_transform_computed", &path_entity_transform_computed, 0)
        && path_entity_transform_computed == sweptsurface->path_entity_transform_computed)
      pass ();
    else
      fail ("SWEPTSURFACE.path_entity_transform_computed [B] set+1 " FORMAT_B " != " FORMAT_B "", sweptsurface->path_entity_transform_computed, path_entity_transform_computed);
    sweptsurface->path_entity_transform_computed--;
  }
  {
    BITCODE_BD* path_entity_transmatrix;
    if (dwg_dynapi_entity_value (sweptsurface, "SWEPTSURFACE", "path_entity_transmatrix", &path_entity_transmatrix, NULL)
        && !memcmp (&path_entity_transmatrix, &sweptsurface->path_entity_transmatrix, sizeof (BITCODE_BD*)))
        pass ();
    else
        fail ("SWEPTSURFACE.path_entity_transmatrix [BD*]");
  }
  {
    BITCODE_BS path_flags;
    if (dwg_dynapi_entity_value (sweptsurface, "SWEPTSURFACE", "path_flags", &path_flags, NULL)
        && path_flags == sweptsurface->path_flags)
      pass ();
    else
      fail ("SWEPTSURFACE.path_flags [BS] %hu != %hu", sweptsurface->path_flags, path_flags);
    path_flags++;
    if (dwg_dynapi_entity_set_value (sweptsurface, "SWEPTSURFACE", "path_flags", &path_flags, 0)
        && path_flags == sweptsurface->path_flags)
      pass ();
    else
      fail ("SWEPTSURFACE.path_flags [BS] set+1 %hu != %hu", sweptsurface->path_flags, path_flags);
    sweptsurface->path_flags--;
  }
  {
    BITCODE_TF pathdata;
    if (dwg_dynapi_entity_value (sweptsurface, "SWEPTSURFACE", "pathdata", &pathdata, NULL)
        && !memcmp (&pathdata, &sweptsurface->pathdata, sizeof (BITCODE_TF)))
        pass ();
    else
        fail ("SWEPTSURFACE.pathdata [TF]");
  }
  {
    BITCODE_BL pathdata_size;
    if (dwg_dynapi_entity_value (sweptsurface, "SWEPTSURFACE", "pathdata_size", &pathdata_size, NULL)
        && pathdata_size == sweptsurface->pathdata_size)
      pass ();
    else
      fail ("SWEPTSURFACE.pathdata_size [BL] %u != %u", sweptsurface->pathdata_size, pathdata_size);
    pathdata_size++;
    if (dwg_dynapi_entity_set_value (sweptsurface, "SWEPTSURFACE", "pathdata_size", &pathdata_size, 0)
        && pathdata_size == sweptsurface->pathdata_size)
      pass ();
    else
      fail ("SWEPTSURFACE.pathdata_size [BL] set+1 %u != %u", sweptsurface->pathdata_size, pathdata_size);
    sweptsurface->pathdata_size--;
  }
  {
    BITCODE_3BD point;
    if (dwg_dynapi_entity_value (sweptsurface, "SWEPTSURFACE", "point", &point, NULL)
        && !memcmp (&point, &sweptsurface->point, sizeof (BITCODE_3BD)))
        pass ();
    else
        fail ("SWEPTSURFACE.point [3BD]");
  }
  {
    BITCODE_B point_present;
    if (dwg_dynapi_entity_value (sweptsurface, "SWEPTSURFACE", "point_present", &point_present, NULL)
        && point_present == sweptsurface->point_present)
      pass ();
    else
      fail ("SWEPTSURFACE.point_present [B] " FORMAT_B " != " FORMAT_B "", sweptsurface->point_present, point_present);
    point_present++;
    if (dwg_dynapi_entity_set_value (sweptsurface, "SWEPTSURFACE", "point_present", &point_present, 0)
        && point_present == sweptsurface->point_present)
      pass ();
    else
      fail ("SWEPTSURFACE.point_present [B] set+1 " FORMAT_B " != " FORMAT_B "", sweptsurface->point_present, point_present);
    sweptsurface->point_present--;
  }
  {
    BITCODE_3BD reference_vector_for_controlling_twist;
    if (dwg_dynapi_entity_value (sweptsurface, "SWEPTSURFACE", "reference_vector_for_controlling_twist", &reference_vector_for_controlling_twist, NULL)
        && !memcmp (&reference_vector_for_controlling_twist, &sweptsurface->reference_vector_for_controlling_twist, sizeof (BITCODE_3BD)))
        pass ();
    else
        fail ("SWEPTSURFACE.reference_vector_for_controlling_twist [3BD]");
  }
  {
    BITCODE_RC revision_bytes[9];
    if (dwg_dynapi_entity_value (sweptsurface, "SWEPTSURFACE", "revision_bytes[9]", &revision_bytes, NULL)
        && !memcmp (&revision_bytes, &sweptsurface->revision_bytes, sizeof (BITCODE_RC)))
        pass ();
    else
        fail ("SWEPTSURFACE.revision_bytes[9] [RC]");
  }
  {
    BITCODE_RC revision_guid[39];
    if (dwg_dynapi_entity_value (sweptsurface, "SWEPTSURFACE", "revision_guid[39]", &revision_guid, NULL)
        && !memcmp (&revision_guid, &sweptsurface->revision_guid, sizeof (BITCODE_RC)))
        pass ();
    else
        fail ("SWEPTSURFACE.revision_guid[39] [RC]");
  }
  {
    BITCODE_BL revision_major;
    if (dwg_dynapi_entity_value (sweptsurface, "SWEPTSURFACE", "revision_major", &revision_major, NULL)
        && revision_major == sweptsurface->revision_major)
      pass ();
    else
      fail ("SWEPTSURFACE.revision_major [BL] %u != %u", sweptsurface->revision_major, revision_major);
    revision_major++;
    if (dwg_dynapi_entity_set_value (sweptsurface, "SWEPTSURFACE", "revision_major", &revision_major, 0)
        && revision_major == sweptsurface->revision_major)
      pass ();
    else
      fail ("SWEPTSURFACE.revision_major [BL] set+1 %u != %u", sweptsurface->revision_major, revision_major);
    sweptsurface->revision_major--;
  }
  {
    BITCODE_BS revision_minor1;
    if (dwg_dynapi_entity_value (sweptsurface, "SWEPTSURFACE", "revision_minor1", &revision_minor1, NULL)
        && revision_minor1 == sweptsurface->revision_minor1)
      pass ();
    else
      fail ("SWEPTSURFACE.revision_minor1 [BS] %hu != %hu", sweptsurface->revision_minor1, revision_minor1);
    revision_minor1++;
    if (dwg_dynapi_entity_set_value (sweptsurface, "SWEPTSURFACE", "revision_minor1", &revision_minor1, 0)
        && revision_minor1 == sweptsurface->revision_minor1)
      pass ();
    else
      fail ("SWEPTSURFACE.revision_minor1 [BS] set+1 %hu != %hu", sweptsurface->revision_minor1, revision_minor1);
    sweptsurface->revision_minor1--;
  }
  {
    BITCODE_BS revision_minor2;
    if (dwg_dynapi_entity_value (sweptsurface, "SWEPTSURFACE", "revision_minor2", &revision_minor2, NULL)
        && revision_minor2 == sweptsurface->revision_minor2)
      pass ();
    else
      fail ("SWEPTSURFACE.revision_minor2 [BS] %hu != %hu", sweptsurface->revision_minor2, revision_minor2);
    revision_minor2++;
    if (dwg_dynapi_entity_set_value (sweptsurface, "SWEPTSURFACE", "revision_minor2", &revision_minor2, 0)
        && revision_minor2 == sweptsurface->revision_minor2)
      pass ();
    else
      fail ("SWEPTSURFACE.revision_minor2 [BS] set+1 %hu != %hu", sweptsurface->revision_minor2, revision_minor2);
    sweptsurface->revision_minor2--;
  }
  {
    BITCODE_BL sab_size;
    if (dwg_dynapi_entity_value (sweptsurface, "SWEPTSURFACE", "sab_size", &sab_size, NULL)
        && sab_size == sweptsurface->sab_size)
      pass ();
    else
      fail ("SWEPTSURFACE.sab_size [BL] %u != %u", sweptsurface->sab_size, sab_size);
    sab_size++;
    if (dwg_dynapi_entity_set_value (sweptsurface, "SWEPTSURFACE", "sab_size", &sab_size, 0)
        && sab_size == sweptsurface->sab_size)
      pass ();
    else
      fail ("SWEPTSURFACE.sab_size [BL] set+1 %u != %u", sweptsurface->sab_size, sab_size);
    sweptsurface->sab_size--;
  }
  {
    BITCODE_BD scale_factor;
    if (dwg_dynapi_entity_value (sweptsurface, "SWEPTSURFACE", "scale_factor", &scale_factor, NULL)
        && scale_factor == sweptsurface->scale_factor)
      pass ();
    else
      fail ("SWEPTSURFACE.scale_factor [BD] %g != %g", sweptsurface->scale_factor, scale_factor);
    scale_factor++;
    if (dwg_dynapi_entity_set_value (sweptsurface, "SWEPTSURFACE", "scale_factor", &scale_factor, 0)
        && scale_factor == sweptsurface->scale_factor)
      pass ();
    else
      fail ("SWEPTSURFACE.scale_factor [BD] set+1 %g != %g", sweptsurface->scale_factor, scale_factor);
    sweptsurface->scale_factor--;
  }
  {
    Dwg_3DSOLID_silhouette* silhouettes;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (sweptsurface, "SWEPTSURFACE", "num_silhouettes", &count, NULL)
        && dwg_dynapi_entity_value (sweptsurface, "SWEPTSURFACE", "silhouettes", &silhouettes, NULL)
        && silhouettes == sweptsurface->silhouettes)
      pass ();
    else
      fail ("SWEPTSURFACE.silhouettes [Dwg_3DSOLID_silhouette*] * %u num_silhouettes", count);
  }
  {
    BITCODE_BS sweep_alignment_flags;
    if (dwg_dynapi_entity_value (sweptsurface, "SWEPTSURFACE", "sweep_alignment_flags", &sweep_alignment_flags, NULL)
        && sweep_alignment_flags == sweptsurface->sweep_alignment_flags)
      pass ();
    else
      fail ("SWEPTSURFACE.sweep_alignment_flags [BS] %hu != %hu", sweptsurface->sweep_alignment_flags, sweep_alignment_flags);
    sweep_alignment_flags++;
    if (dwg_dynapi_entity_set_value (sweptsurface, "SWEPTSURFACE", "sweep_alignment_flags", &sweep_alignment_flags, 0)
        && sweep_alignment_flags == sweptsurface->sweep_alignment_flags)
      pass ();
    else
      fail ("SWEPTSURFACE.sweep_alignment_flags [BS] set+1 %hu != %hu", sweptsurface->sweep_alignment_flags, sweep_alignment_flags);
    sweptsurface->sweep_alignment_flags--;
  }
  {
    BITCODE_H sweep_entity;
    if (dwg_dynapi_entity_value (sweptsurface, "SWEPTSURFACE", "sweep_entity", &sweep_entity, NULL)
        && !memcmp (&sweep_entity, &sweptsurface->sweep_entity, sizeof (BITCODE_H)))
        pass ();
    else
        fail ("SWEPTSURFACE.sweep_entity [H]");
  }
  {
    BITCODE_BL sweep_entity_id;
    if (dwg_dynapi_entity_value (sweptsurface, "SWEPTSURFACE", "sweep_entity_id", &sweep_entity_id, NULL)
        && sweep_entity_id == sweptsurface->sweep_entity_id)
      pass ();
    else
      fail ("SWEPTSURFACE.sweep_entity_id [BL] %u != %u", sweptsurface->sweep_entity_id, sweep_entity_id);
    sweep_entity_id++;
    if (dwg_dynapi_entity_set_value (sweptsurface, "SWEPTSURFACE", "sweep_entity_id", &sweep_entity_id, 0)
        && sweep_entity_id == sweptsurface->sweep_entity_id)
      pass ();
    else
      fail ("SWEPTSURFACE.sweep_entity_id [BL] set+1 %u != %u", sweptsurface->sweep_entity_id, sweep_entity_id);
    sweptsurface->sweep_entity_id--;
  }
  {
    BITCODE_B sweep_entity_transform_computed;
    if (dwg_dynapi_entity_value (sweptsurface, "SWEPTSURFACE", "sweep_entity_transform_computed", &sweep_entity_transform_computed, NULL)
        && sweep_entity_transform_computed == sweptsurface->sweep_entity_transform_computed)
      pass ();
    else
      fail ("SWEPTSURFACE.sweep_entity_transform_computed [B] " FORMAT_B " != " FORMAT_B "", sweptsurface->sweep_entity_transform_computed, sweep_entity_transform_computed);
    sweep_entity_transform_computed++;
    if (dwg_dynapi_entity_set_value (sweptsurface, "SWEPTSURFACE", "sweep_entity_transform_computed", &sweep_entity_transform_computed, 0)
        && sweep_entity_transform_computed == sweptsurface->sweep_entity_transform_computed)
      pass ();
    else
      fail ("SWEPTSURFACE.sweep_entity_transform_computed [B] set+1 " FORMAT_B " != " FORMAT_B "", sweptsurface->sweep_entity_transform_computed, sweep_entity_transform_computed);
    sweptsurface->sweep_entity_transform_computed--;
  }
  {
    BITCODE_BD* sweep_entity_transmatrix;
    if (dwg_dynapi_entity_value (sweptsurface, "SWEPTSURFACE", "sweep_entity_transmatrix", &sweep_entity_transmatrix, NULL)
        && !memcmp (&sweep_entity_transmatrix, &sweptsurface->sweep_entity_transmatrix, sizeof (BITCODE_BD*)))
        pass ();
    else
        fail ("SWEPTSURFACE.sweep_entity_transmatrix [BD*]");
  }
  {
    BITCODE_TF sweepdata;
    if (dwg_dynapi_entity_value (sweptsurface, "SWEPTSURFACE", "sweepdata", &sweepdata, NULL)
        && !memcmp (&sweepdata, &sweptsurface->sweepdata, sizeof (BITCODE_TF)))
        pass ();
    else
        fail ("SWEPTSURFACE.sweepdata [TF]");
  }
  {
    BITCODE_BL sweepdata_size;
    if (dwg_dynapi_entity_value (sweptsurface, "SWEPTSURFACE", "sweepdata_size", &sweepdata_size, NULL)
        && sweepdata_size == sweptsurface->sweepdata_size)
      pass ();
    else
      fail ("SWEPTSURFACE.sweepdata_size [BL] %u != %u", sweptsurface->sweepdata_size, sweepdata_size);
    sweepdata_size++;
    if (dwg_dynapi_entity_set_value (sweptsurface, "SWEPTSURFACE", "sweepdata_size", &sweepdata_size, 0)
        && sweepdata_size == sweptsurface->sweepdata_size)
      pass ();
    else
      fail ("SWEPTSURFACE.sweepdata_size [BL] set+1 %u != %u", sweptsurface->sweepdata_size, sweepdata_size);
    sweptsurface->sweepdata_size--;
  }
  {
    BITCODE_BD twist_angle;
    if (dwg_dynapi_entity_value (sweptsurface, "SWEPTSURFACE", "twist_angle", &twist_angle, NULL)
        && twist_angle == sweptsurface->twist_angle)
      pass ();
    else
      fail ("SWEPTSURFACE.twist_angle [BD] %g != %g", sweptsurface->twist_angle, twist_angle);
    twist_angle++;
    if (dwg_dynapi_entity_set_value (sweptsurface, "SWEPTSURFACE", "twist_angle", &twist_angle, 0)
        && twist_angle == sweptsurface->twist_angle)
      pass ();
    else
      fail ("SWEPTSURFACE.twist_angle [BD] set+1 %g != %g", sweptsurface->twist_angle, twist_angle);
    sweptsurface->twist_angle--;
  }
  {
    BITCODE_BS u_isolines;
    if (dwg_dynapi_entity_value (sweptsurface, "SWEPTSURFACE", "u_isolines", &u_isolines, NULL)
        && u_isolines == sweptsurface->u_isolines)
      pass ();
    else
      fail ("SWEPTSURFACE.u_isolines [BS] %hu != %hu", sweptsurface->u_isolines, u_isolines);
    u_isolines++;
    if (dwg_dynapi_entity_set_value (sweptsurface, "SWEPTSURFACE", "u_isolines", &u_isolines, 0)
        && u_isolines == sweptsurface->u_isolines)
      pass ();
    else
      fail ("SWEPTSURFACE.u_isolines [BS] set+1 %hu != %hu", sweptsurface->u_isolines, u_isolines);
    sweptsurface->u_isolines--;
  }
  {
    BITCODE_B unknown;
    if (dwg_dynapi_entity_value (sweptsurface, "SWEPTSURFACE", "unknown", &unknown, NULL)
        && unknown == sweptsurface->unknown)
      pass ();
    else
      fail ("SWEPTSURFACE.unknown [B] " FORMAT_B " != " FORMAT_B "", sweptsurface->unknown, unknown);
    unknown++;
    if (dwg_dynapi_entity_set_value (sweptsurface, "SWEPTSURFACE", "unknown", &unknown, 0)
        && unknown == sweptsurface->unknown)
      pass ();
    else
      fail ("SWEPTSURFACE.unknown [B] set+1 " FORMAT_B " != " FORMAT_B "", sweptsurface->unknown, unknown);
    sweptsurface->unknown--;
  }
  {
    BITCODE_BS v_isolines;
    if (dwg_dynapi_entity_value (sweptsurface, "SWEPTSURFACE", "v_isolines", &v_isolines, NULL)
        && v_isolines == sweptsurface->v_isolines)
      pass ();
    else
      fail ("SWEPTSURFACE.v_isolines [BS] %hu != %hu", sweptsurface->v_isolines, v_isolines);
    v_isolines++;
    if (dwg_dynapi_entity_set_value (sweptsurface, "SWEPTSURFACE", "v_isolines", &v_isolines, 0)
        && v_isolines == sweptsurface->v_isolines)
      pass ();
    else
      fail ("SWEPTSURFACE.v_isolines [BS] set+1 %hu != %hu", sweptsurface->v_isolines, v_isolines);
    sweptsurface->v_isolines--;
  }
  {
    BITCODE_BS version;
    if (dwg_dynapi_entity_value (sweptsurface, "SWEPTSURFACE", "version", &version, NULL)
        && version == sweptsurface->version)
      pass ();
    else
      fail ("SWEPTSURFACE.version [BS] %hu != %hu", sweptsurface->version, version);
    version++;
    if (dwg_dynapi_entity_set_value (sweptsurface, "SWEPTSURFACE", "version", &version, 0)
        && version == sweptsurface->version)
      pass ();
    else
      fail ("SWEPTSURFACE.version [BS] set+1 %hu != %hu", sweptsurface->version, version);
    sweptsurface->version--;
  }
  {
    BITCODE_B wireframe_data_present;
    if (dwg_dynapi_entity_value (sweptsurface, "SWEPTSURFACE", "wireframe_data_present", &wireframe_data_present, NULL)
        && wireframe_data_present == sweptsurface->wireframe_data_present)
      pass ();
    else
      fail ("SWEPTSURFACE.wireframe_data_present [B] " FORMAT_B " != " FORMAT_B "", sweptsurface->wireframe_data_present, wireframe_data_present);
    wireframe_data_present++;
    if (dwg_dynapi_entity_set_value (sweptsurface, "SWEPTSURFACE", "wireframe_data_present", &wireframe_data_present, 0)
        && wireframe_data_present == sweptsurface->wireframe_data_present)
      pass ();
    else
      fail ("SWEPTSURFACE.wireframe_data_present [B] set+1 " FORMAT_B " != " FORMAT_B "", sweptsurface->wireframe_data_present, wireframe_data_present);
    sweptsurface->wireframe_data_present--;
  }
  {
    Dwg_3DSOLID_wire* wires;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (sweptsurface, "SWEPTSURFACE", "num_wires", &count, NULL)
        && dwg_dynapi_entity_value (sweptsurface, "SWEPTSURFACE", "wires", &wires, NULL)
        && wires == sweptsurface->wires)
      pass ();
    else
      fail ("SWEPTSURFACE.wires [Dwg_3DSOLID_wire*] * %u num_wires", count);
  }
  if (failed && (is_class_unstable ("SWEPTSURFACE") || is_class_debugging ("SWEPTSURFACE")))
    {
      ok ("%s failed %d tests (TODO unstable)", "SWEPTSURFACE", failed);
      failed = 0;
    }
  return failed;
}
static int test_TABLE (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_TABLE *restrict table = obj->tio.entity->tio.TABLE;
  failed = 0;
  {
    BITCODE_H* attribs;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (table, "TABLE", "num_owned", &count, NULL)
        && dwg_dynapi_entity_value (table, "TABLE", "attribs", &attribs, NULL)
        && attribs == table->attribs)
      pass ();
    else
      fail ("TABLE.attribs [H*] * %u num_owned", count);
  }
  {
    BITCODE_H block_header;
    if (dwg_dynapi_entity_value (table, "TABLE", "block_header", &block_header, NULL)
        && !memcmp (&block_header, &table->block_header, sizeof (BITCODE_H)))
        pass ();
    else
        fail ("TABLE.block_header [H]");
  }
  {
    BITCODE_BL border_color_overrides_flag;
    if (dwg_dynapi_entity_value (table, "TABLE", "border_color_overrides_flag", &border_color_overrides_flag, NULL)
        && border_color_overrides_flag == table->border_color_overrides_flag)
      pass ();
    else
      fail ("TABLE.border_color_overrides_flag [BL] %u != %u", table->border_color_overrides_flag, border_color_overrides_flag);
    border_color_overrides_flag++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "border_color_overrides_flag", &border_color_overrides_flag, 0)
        && border_color_overrides_flag == table->border_color_overrides_flag)
      pass ();
    else
      fail ("TABLE.border_color_overrides_flag [BL] set+1 %u != %u", table->border_color_overrides_flag, border_color_overrides_flag);
    table->border_color_overrides_flag--;
  }
  {
    BITCODE_BL border_lineweight_overrides_flag;
    if (dwg_dynapi_entity_value (table, "TABLE", "border_lineweight_overrides_flag", &border_lineweight_overrides_flag, NULL)
        && border_lineweight_overrides_flag == table->border_lineweight_overrides_flag)
      pass ();
    else
      fail ("TABLE.border_lineweight_overrides_flag [BL] %u != %u", table->border_lineweight_overrides_flag, border_lineweight_overrides_flag);
    border_lineweight_overrides_flag++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "border_lineweight_overrides_flag", &border_lineweight_overrides_flag, 0)
        && border_lineweight_overrides_flag == table->border_lineweight_overrides_flag)
      pass ();
    else
      fail ("TABLE.border_lineweight_overrides_flag [BL] set+1 %u != %u", table->border_lineweight_overrides_flag, border_lineweight_overrides_flag);
    table->border_lineweight_overrides_flag--;
  }
  {
    BITCODE_BL border_visibility_overrides_flag;
    if (dwg_dynapi_entity_value (table, "TABLE", "border_visibility_overrides_flag", &border_visibility_overrides_flag, NULL)
        && border_visibility_overrides_flag == table->border_visibility_overrides_flag)
      pass ();
    else
      fail ("TABLE.border_visibility_overrides_flag [BL] %u != %u", table->border_visibility_overrides_flag, border_visibility_overrides_flag);
    border_visibility_overrides_flag++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "border_visibility_overrides_flag", &border_visibility_overrides_flag, 0)
        && border_visibility_overrides_flag == table->border_visibility_overrides_flag)
      pass ();
    else
      fail ("TABLE.border_visibility_overrides_flag [BL] set+1 %u != %u", table->border_visibility_overrides_flag, border_visibility_overrides_flag);
    table->border_visibility_overrides_flag--;
  }
  {
    BITCODE_BL break_flag;
    if (dwg_dynapi_entity_value (table, "TABLE", "break_flag", &break_flag, NULL)
        && break_flag == table->break_flag)
      pass ();
    else
      fail ("TABLE.break_flag [BL] %u != %u", table->break_flag, break_flag);
    break_flag++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "break_flag", &break_flag, 0)
        && break_flag == table->break_flag)
      pass ();
    else
      fail ("TABLE.break_flag [BL] set+1 %u != %u", table->break_flag, break_flag);
    table->break_flag--;
  }
  {
    BITCODE_BL break_flow_direction;
    if (dwg_dynapi_entity_value (table, "TABLE", "break_flow_direction", &break_flow_direction, NULL)
        && break_flow_direction == table->break_flow_direction)
      pass ();
    else
      fail ("TABLE.break_flow_direction [BL] %u != %u", table->break_flow_direction, break_flow_direction);
    break_flow_direction++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "break_flow_direction", &break_flow_direction, 0)
        && break_flow_direction == table->break_flow_direction)
      pass ();
    else
      fail ("TABLE.break_flow_direction [BL] set+1 %u != %u", table->break_flow_direction, break_flow_direction);
    table->break_flow_direction--;
  }
  {
    Dwg_TABLE_BreakHeight* break_heights;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (table, "TABLE", "num_break_heights", &count, NULL)
        && dwg_dynapi_entity_value (table, "TABLE", "break_heights", &break_heights, NULL)
        && break_heights == table->break_heights)
      pass ();
    else
      fail ("TABLE.break_heights [Dwg_TABLE_BreakHeight*] * %u num_break_heights", count);
  }
  {
    Dwg_TABLE_BreakRow* break_rows;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (table, "TABLE", "num_break_rows", &count, NULL)
        && dwg_dynapi_entity_value (table, "TABLE", "break_rows", &break_rows, NULL)
        && break_rows == table->break_rows)
      pass ();
    else
      fail ("TABLE.break_rows [Dwg_TABLE_BreakRow*] * %u num_break_rows", count);
  }
  {
    BITCODE_BD break_spacing;
    if (dwg_dynapi_entity_value (table, "TABLE", "break_spacing", &break_spacing, NULL)
        && break_spacing == table->break_spacing)
      pass ();
    else
      fail ("TABLE.break_spacing [BD] %g != %g", table->break_spacing, break_spacing);
    break_spacing++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "break_spacing", &break_spacing, 0)
        && break_spacing == table->break_spacing)
      pass ();
    else
      fail ("TABLE.break_spacing [BD] set+1 %g != %g", table->break_spacing, break_spacing);
    table->break_spacing--;
  }
  {
    BITCODE_BL break_unknown1;
    if (dwg_dynapi_entity_value (table, "TABLE", "break_unknown1", &break_unknown1, NULL)
        && break_unknown1 == table->break_unknown1)
      pass ();
    else
      fail ("TABLE.break_unknown1 [BL] %u != %u", table->break_unknown1, break_unknown1);
    break_unknown1++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "break_unknown1", &break_unknown1, 0)
        && break_unknown1 == table->break_unknown1)
      pass ();
    else
      fail ("TABLE.break_unknown1 [BL] set+1 %u != %u", table->break_unknown1, break_unknown1);
    table->break_unknown1--;
  }
  {
    BITCODE_BL break_unknown2;
    if (dwg_dynapi_entity_value (table, "TABLE", "break_unknown2", &break_unknown2, NULL)
        && break_unknown2 == table->break_unknown2)
      pass ();
    else
      fail ("TABLE.break_unknown2 [BL] %u != %u", table->break_unknown2, break_unknown2);
    break_unknown2++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "break_unknown2", &break_unknown2, 0)
        && break_unknown2 == table->break_unknown2)
      pass ();
    else
      fail ("TABLE.break_unknown2 [BL] set+1 %u != %u", table->break_unknown2, break_unknown2);
    table->break_unknown2--;
  }
  {
    Dwg_TABLE_Cell* cells;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (table, "TABLE", "num_cells", &count, NULL)
        && dwg_dynapi_entity_value (table, "TABLE", "cells", &cells, NULL)
        && cells == table->cells)
      pass ();
    else
      fail ("TABLE.cells [Dwg_TABLE_Cell*] * %u num_cells", count);
  }
  {
    BITCODE_BD* col_widths;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (table, "TABLE", "num_col_widths", &count, NULL)
        && dwg_dynapi_entity_value (table, "TABLE", "col_widths", &col_widths, NULL)
        && col_widths == table->col_widths)
      pass ();
    else
      fail ("TABLE.col_widths [BD*] * %u num_col_widths", count);
  }
  {
    BITCODE_CMC data_horiz_bottom_color;
    if (dwg_dynapi_entity_value (table, "TABLE", "data_horiz_bottom_color", &data_horiz_bottom_color, NULL)
        && !memcmp (&data_horiz_bottom_color, &table->data_horiz_bottom_color, sizeof (BITCODE_CMC)))
        pass ();
    else
        fail ("TABLE.data_horiz_bottom_color [CMC]");
  }
  {
    BITCODE_BS data_horiz_bottom_linewt;
    if (dwg_dynapi_entity_value (table, "TABLE", "data_horiz_bottom_linewt", &data_horiz_bottom_linewt, NULL)
        && data_horiz_bottom_linewt == table->data_horiz_bottom_linewt)
      pass ();
    else
      fail ("TABLE.data_horiz_bottom_linewt [BS] %hu != %hu", table->data_horiz_bottom_linewt, data_horiz_bottom_linewt);
    data_horiz_bottom_linewt++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "data_horiz_bottom_linewt", &data_horiz_bottom_linewt, 0)
        && data_horiz_bottom_linewt == table->data_horiz_bottom_linewt)
      pass ();
    else
      fail ("TABLE.data_horiz_bottom_linewt [BS] set+1 %hu != %hu", table->data_horiz_bottom_linewt, data_horiz_bottom_linewt);
    table->data_horiz_bottom_linewt--;
  }
  {
    BITCODE_BS data_horiz_bottom_visibility;
    if (dwg_dynapi_entity_value (table, "TABLE", "data_horiz_bottom_visibility", &data_horiz_bottom_visibility, NULL)
        && data_horiz_bottom_visibility == table->data_horiz_bottom_visibility)
      pass ();
    else
      fail ("TABLE.data_horiz_bottom_visibility [BS] %hu != %hu", table->data_horiz_bottom_visibility, data_horiz_bottom_visibility);
    data_horiz_bottom_visibility++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "data_horiz_bottom_visibility", &data_horiz_bottom_visibility, 0)
        && data_horiz_bottom_visibility == table->data_horiz_bottom_visibility)
      pass ();
    else
      fail ("TABLE.data_horiz_bottom_visibility [BS] set+1 %hu != %hu", table->data_horiz_bottom_visibility, data_horiz_bottom_visibility);
    table->data_horiz_bottom_visibility--;
  }
  {
    BITCODE_CMC data_horiz_ins_color;
    if (dwg_dynapi_entity_value (table, "TABLE", "data_horiz_ins_color", &data_horiz_ins_color, NULL)
        && !memcmp (&data_horiz_ins_color, &table->data_horiz_ins_color, sizeof (BITCODE_CMC)))
        pass ();
    else
        fail ("TABLE.data_horiz_ins_color [CMC]");
  }
  {
    BITCODE_BS data_horiz_ins_linewt;
    if (dwg_dynapi_entity_value (table, "TABLE", "data_horiz_ins_linewt", &data_horiz_ins_linewt, NULL)
        && data_horiz_ins_linewt == table->data_horiz_ins_linewt)
      pass ();
    else
      fail ("TABLE.data_horiz_ins_linewt [BS] %hu != %hu", table->data_horiz_ins_linewt, data_horiz_ins_linewt);
    data_horiz_ins_linewt++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "data_horiz_ins_linewt", &data_horiz_ins_linewt, 0)
        && data_horiz_ins_linewt == table->data_horiz_ins_linewt)
      pass ();
    else
      fail ("TABLE.data_horiz_ins_linewt [BS] set+1 %hu != %hu", table->data_horiz_ins_linewt, data_horiz_ins_linewt);
    table->data_horiz_ins_linewt--;
  }
  {
    BITCODE_BS data_horiz_ins_visibility;
    if (dwg_dynapi_entity_value (table, "TABLE", "data_horiz_ins_visibility", &data_horiz_ins_visibility, NULL)
        && data_horiz_ins_visibility == table->data_horiz_ins_visibility)
      pass ();
    else
      fail ("TABLE.data_horiz_ins_visibility [BS] %hu != %hu", table->data_horiz_ins_visibility, data_horiz_ins_visibility);
    data_horiz_ins_visibility++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "data_horiz_ins_visibility", &data_horiz_ins_visibility, 0)
        && data_horiz_ins_visibility == table->data_horiz_ins_visibility)
      pass ();
    else
      fail ("TABLE.data_horiz_ins_visibility [BS] set+1 %hu != %hu", table->data_horiz_ins_visibility, data_horiz_ins_visibility);
    table->data_horiz_ins_visibility--;
  }
  {
    BITCODE_CMC data_horiz_top_color;
    if (dwg_dynapi_entity_value (table, "TABLE", "data_horiz_top_color", &data_horiz_top_color, NULL)
        && !memcmp (&data_horiz_top_color, &table->data_horiz_top_color, sizeof (BITCODE_CMC)))
        pass ();
    else
        fail ("TABLE.data_horiz_top_color [CMC]");
  }
  {
    BITCODE_BS data_horiz_top_linewt;
    if (dwg_dynapi_entity_value (table, "TABLE", "data_horiz_top_linewt", &data_horiz_top_linewt, NULL)
        && data_horiz_top_linewt == table->data_horiz_top_linewt)
      pass ();
    else
      fail ("TABLE.data_horiz_top_linewt [BS] %hu != %hu", table->data_horiz_top_linewt, data_horiz_top_linewt);
    data_horiz_top_linewt++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "data_horiz_top_linewt", &data_horiz_top_linewt, 0)
        && data_horiz_top_linewt == table->data_horiz_top_linewt)
      pass ();
    else
      fail ("TABLE.data_horiz_top_linewt [BS] set+1 %hu != %hu", table->data_horiz_top_linewt, data_horiz_top_linewt);
    table->data_horiz_top_linewt--;
  }
  {
    BITCODE_BS data_horiz_top_visibility;
    if (dwg_dynapi_entity_value (table, "TABLE", "data_horiz_top_visibility", &data_horiz_top_visibility, NULL)
        && data_horiz_top_visibility == table->data_horiz_top_visibility)
      pass ();
    else
      fail ("TABLE.data_horiz_top_visibility [BS] %hu != %hu", table->data_horiz_top_visibility, data_horiz_top_visibility);
    data_horiz_top_visibility++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "data_horiz_top_visibility", &data_horiz_top_visibility, 0)
        && data_horiz_top_visibility == table->data_horiz_top_visibility)
      pass ();
    else
      fail ("TABLE.data_horiz_top_visibility [BS] set+1 %hu != %hu", table->data_horiz_top_visibility, data_horiz_top_visibility);
    table->data_horiz_top_visibility--;
  }
  {
    BITCODE_BS data_row_alignment;
    if (dwg_dynapi_entity_value (table, "TABLE", "data_row_alignment", &data_row_alignment, NULL)
        && data_row_alignment == table->data_row_alignment)
      pass ();
    else
      fail ("TABLE.data_row_alignment [BS] %hu != %hu", table->data_row_alignment, data_row_alignment);
    data_row_alignment++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "data_row_alignment", &data_row_alignment, 0)
        && data_row_alignment == table->data_row_alignment)
      pass ();
    else
      fail ("TABLE.data_row_alignment [BS] set+1 %hu != %hu", table->data_row_alignment, data_row_alignment);
    table->data_row_alignment--;
  }
  {
    BITCODE_CMC data_row_color;
    if (dwg_dynapi_entity_value (table, "TABLE", "data_row_color", &data_row_color, NULL)
        && !memcmp (&data_row_color, &table->data_row_color, sizeof (BITCODE_CMC)))
        pass ();
    else
        fail ("TABLE.data_row_color [CMC]");
  }
  {
    BITCODE_CMC data_row_fill_color;
    if (dwg_dynapi_entity_value (table, "TABLE", "data_row_fill_color", &data_row_fill_color, NULL)
        && !memcmp (&data_row_fill_color, &table->data_row_fill_color, sizeof (BITCODE_CMC)))
        pass ();
    else
        fail ("TABLE.data_row_fill_color [CMC]");
  }
  {
    BITCODE_B data_row_fill_none;
    if (dwg_dynapi_entity_value (table, "TABLE", "data_row_fill_none", &data_row_fill_none, NULL)
        && data_row_fill_none == table->data_row_fill_none)
      pass ();
    else
      fail ("TABLE.data_row_fill_none [B] " FORMAT_B " != " FORMAT_B "", table->data_row_fill_none, data_row_fill_none);
    data_row_fill_none++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "data_row_fill_none", &data_row_fill_none, 0)
        && data_row_fill_none == table->data_row_fill_none)
      pass ();
    else
      fail ("TABLE.data_row_fill_none [B] set+1 " FORMAT_B " != " FORMAT_B "", table->data_row_fill_none, data_row_fill_none);
    table->data_row_fill_none--;
  }
  {
    BITCODE_BD data_row_height;
    if (dwg_dynapi_entity_value (table, "TABLE", "data_row_height", &data_row_height, NULL)
        && data_row_height == table->data_row_height)
      pass ();
    else
      fail ("TABLE.data_row_height [BD] %g != %g", table->data_row_height, data_row_height);
    data_row_height++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "data_row_height", &data_row_height, 0)
        && data_row_height == table->data_row_height)
      pass ();
    else
      fail ("TABLE.data_row_height [BD] set+1 %g != %g", table->data_row_height, data_row_height);
    table->data_row_height--;
  }
  {
    BITCODE_H data_row_style_override;
    if (dwg_dynapi_entity_value (table, "TABLE", "data_row_style_override", &data_row_style_override, NULL)
        && !memcmp (&data_row_style_override, &table->data_row_style_override, sizeof (BITCODE_H)))
        pass ();
    else
        fail ("TABLE.data_row_style_override [H]");
  }
  {
    BITCODE_H data_text_style;
    if (dwg_dynapi_entity_value (table, "TABLE", "data_text_style", &data_text_style, NULL)
        && !memcmp (&data_text_style, &table->data_text_style, sizeof (BITCODE_H)))
        pass ();
    else
        fail ("TABLE.data_text_style [H]");
  }
  {
    BITCODE_CMC data_vert_ins_color;
    if (dwg_dynapi_entity_value (table, "TABLE", "data_vert_ins_color", &data_vert_ins_color, NULL)
        && !memcmp (&data_vert_ins_color, &table->data_vert_ins_color, sizeof (BITCODE_CMC)))
        pass ();
    else
        fail ("TABLE.data_vert_ins_color [CMC]");
  }
  {
    BITCODE_BS data_vert_ins_linewt;
    if (dwg_dynapi_entity_value (table, "TABLE", "data_vert_ins_linewt", &data_vert_ins_linewt, NULL)
        && data_vert_ins_linewt == table->data_vert_ins_linewt)
      pass ();
    else
      fail ("TABLE.data_vert_ins_linewt [BS] %hu != %hu", table->data_vert_ins_linewt, data_vert_ins_linewt);
    data_vert_ins_linewt++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "data_vert_ins_linewt", &data_vert_ins_linewt, 0)
        && data_vert_ins_linewt == table->data_vert_ins_linewt)
      pass ();
    else
      fail ("TABLE.data_vert_ins_linewt [BS] set+1 %hu != %hu", table->data_vert_ins_linewt, data_vert_ins_linewt);
    table->data_vert_ins_linewt--;
  }
  {
    BITCODE_BS data_vert_ins_visibility;
    if (dwg_dynapi_entity_value (table, "TABLE", "data_vert_ins_visibility", &data_vert_ins_visibility, NULL)
        && data_vert_ins_visibility == table->data_vert_ins_visibility)
      pass ();
    else
      fail ("TABLE.data_vert_ins_visibility [BS] %hu != %hu", table->data_vert_ins_visibility, data_vert_ins_visibility);
    data_vert_ins_visibility++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "data_vert_ins_visibility", &data_vert_ins_visibility, 0)
        && data_vert_ins_visibility == table->data_vert_ins_visibility)
      pass ();
    else
      fail ("TABLE.data_vert_ins_visibility [BS] set+1 %hu != %hu", table->data_vert_ins_visibility, data_vert_ins_visibility);
    table->data_vert_ins_visibility--;
  }
  {
    BITCODE_CMC data_vert_left_color;
    if (dwg_dynapi_entity_value (table, "TABLE", "data_vert_left_color", &data_vert_left_color, NULL)
        && !memcmp (&data_vert_left_color, &table->data_vert_left_color, sizeof (BITCODE_CMC)))
        pass ();
    else
        fail ("TABLE.data_vert_left_color [CMC]");
  }
  {
    BITCODE_BS data_vert_left_linewt;
    if (dwg_dynapi_entity_value (table, "TABLE", "data_vert_left_linewt", &data_vert_left_linewt, NULL)
        && data_vert_left_linewt == table->data_vert_left_linewt)
      pass ();
    else
      fail ("TABLE.data_vert_left_linewt [BS] %hu != %hu", table->data_vert_left_linewt, data_vert_left_linewt);
    data_vert_left_linewt++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "data_vert_left_linewt", &data_vert_left_linewt, 0)
        && data_vert_left_linewt == table->data_vert_left_linewt)
      pass ();
    else
      fail ("TABLE.data_vert_left_linewt [BS] set+1 %hu != %hu", table->data_vert_left_linewt, data_vert_left_linewt);
    table->data_vert_left_linewt--;
  }
  {
    BITCODE_BS data_vert_left_visibility;
    if (dwg_dynapi_entity_value (table, "TABLE", "data_vert_left_visibility", &data_vert_left_visibility, NULL)
        && data_vert_left_visibility == table->data_vert_left_visibility)
      pass ();
    else
      fail ("TABLE.data_vert_left_visibility [BS] %hu != %hu", table->data_vert_left_visibility, data_vert_left_visibility);
    data_vert_left_visibility++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "data_vert_left_visibility", &data_vert_left_visibility, 0)
        && data_vert_left_visibility == table->data_vert_left_visibility)
      pass ();
    else
      fail ("TABLE.data_vert_left_visibility [BS] set+1 %hu != %hu", table->data_vert_left_visibility, data_vert_left_visibility);
    table->data_vert_left_visibility--;
  }
  {
    BITCODE_CMC data_vert_right_color;
    if (dwg_dynapi_entity_value (table, "TABLE", "data_vert_right_color", &data_vert_right_color, NULL)
        && !memcmp (&data_vert_right_color, &table->data_vert_right_color, sizeof (BITCODE_CMC)))
        pass ();
    else
        fail ("TABLE.data_vert_right_color [CMC]");
  }
  {
    BITCODE_BS data_vert_right_linewt;
    if (dwg_dynapi_entity_value (table, "TABLE", "data_vert_right_linewt", &data_vert_right_linewt, NULL)
        && data_vert_right_linewt == table->data_vert_right_linewt)
      pass ();
    else
      fail ("TABLE.data_vert_right_linewt [BS] %hu != %hu", table->data_vert_right_linewt, data_vert_right_linewt);
    data_vert_right_linewt++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "data_vert_right_linewt", &data_vert_right_linewt, 0)
        && data_vert_right_linewt == table->data_vert_right_linewt)
      pass ();
    else
      fail ("TABLE.data_vert_right_linewt [BS] set+1 %hu != %hu", table->data_vert_right_linewt, data_vert_right_linewt);
    table->data_vert_right_linewt--;
  }
  {
    BITCODE_BS data_vert_right_visibility;
    if (dwg_dynapi_entity_value (table, "TABLE", "data_vert_right_visibility", &data_vert_right_visibility, NULL)
        && data_vert_right_visibility == table->data_vert_right_visibility)
      pass ();
    else
      fail ("TABLE.data_vert_right_visibility [BS] %hu != %hu", table->data_vert_right_visibility, data_vert_right_visibility);
    data_vert_right_visibility++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "data_vert_right_visibility", &data_vert_right_visibility, 0)
        && data_vert_right_visibility == table->data_vert_right_visibility)
      pass ();
    else
      fail ("TABLE.data_vert_right_visibility [BS] set+1 %hu != %hu", table->data_vert_right_visibility, data_vert_right_visibility);
    table->data_vert_right_visibility--;
  }
  {
    BITCODE_BE extrusion;
    if (dwg_dynapi_entity_value (table, "TABLE", "extrusion", &extrusion, NULL)
        && !memcmp (&extrusion, &table->extrusion, sizeof (BITCODE_BE)))
        pass ();
    else
        fail ("TABLE.extrusion [BE]");
  }
  {
    Dwg_FormattedTableData fdata;
    if (dwg_dynapi_entity_value (table, "TABLE", "fdata", &fdata, NULL)
        && !memcmp (&fdata, &table->fdata, sizeof (Dwg_FormattedTableData)))
        pass ();
    else
        fail ("TABLE.fdata [Dwg_FormattedTableData]");
  }
  {
    BITCODE_H first_attrib;
    if (dwg_dynapi_entity_value (table, "TABLE", "first_attrib", &first_attrib, NULL)
        && !memcmp (&first_attrib, &table->first_attrib, sizeof (BITCODE_H)))
        pass ();
    else
        fail ("TABLE.first_attrib [H]");
  }
  {
    BITCODE_BS flag_for_table_value;
    if (dwg_dynapi_entity_value (table, "TABLE", "flag_for_table_value", &flag_for_table_value, NULL)
        && flag_for_table_value == table->flag_for_table_value)
      pass ();
    else
      fail ("TABLE.flag_for_table_value [BS] %hu != %hu", table->flag_for_table_value, flag_for_table_value);
    flag_for_table_value++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "flag_for_table_value", &flag_for_table_value, 0)
        && flag_for_table_value == table->flag_for_table_value)
      pass ();
    else
      fail ("TABLE.flag_for_table_value [BS] set+1 %hu != %hu", table->flag_for_table_value, flag_for_table_value);
    table->flag_for_table_value--;
  }
  {
    BITCODE_BS flow_direction;
    if (dwg_dynapi_entity_value (table, "TABLE", "flow_direction", &flow_direction, NULL)
        && flow_direction == table->flow_direction)
      pass ();
    else
      fail ("TABLE.flow_direction [BS] %hu != %hu", table->flow_direction, flow_direction);
    flow_direction++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "flow_direction", &flow_direction, 0)
        && flow_direction == table->flow_direction)
      pass ();
    else
      fail ("TABLE.flow_direction [BS] set+1 %hu != %hu", table->flow_direction, flow_direction);
    table->flow_direction--;
  }
  {
    BITCODE_B has_attribs;
    if (dwg_dynapi_entity_value (table, "TABLE", "has_attribs", &has_attribs, NULL)
        && has_attribs == table->has_attribs)
      pass ();
    else
      fail ("TABLE.has_attribs [B] " FORMAT_B " != " FORMAT_B "", table->has_attribs, has_attribs);
    has_attribs++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "has_attribs", &has_attribs, 0)
        && has_attribs == table->has_attribs)
      pass ();
    else
      fail ("TABLE.has_attribs [B] set+1 " FORMAT_B " != " FORMAT_B "", table->has_attribs, has_attribs);
    table->has_attribs--;
  }
  {
    BITCODE_B has_border_color_overrides;
    if (dwg_dynapi_entity_value (table, "TABLE", "has_border_color_overrides", &has_border_color_overrides, NULL)
        && has_border_color_overrides == table->has_border_color_overrides)
      pass ();
    else
      fail ("TABLE.has_border_color_overrides [B] " FORMAT_B " != " FORMAT_B "", table->has_border_color_overrides, has_border_color_overrides);
    has_border_color_overrides++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "has_border_color_overrides", &has_border_color_overrides, 0)
        && has_border_color_overrides == table->has_border_color_overrides)
      pass ();
    else
      fail ("TABLE.has_border_color_overrides [B] set+1 " FORMAT_B " != " FORMAT_B "", table->has_border_color_overrides, has_border_color_overrides);
    table->has_border_color_overrides--;
  }
  {
    BITCODE_B has_border_lineweight_overrides;
    if (dwg_dynapi_entity_value (table, "TABLE", "has_border_lineweight_overrides", &has_border_lineweight_overrides, NULL)
        && has_border_lineweight_overrides == table->has_border_lineweight_overrides)
      pass ();
    else
      fail ("TABLE.has_border_lineweight_overrides [B] " FORMAT_B " != " FORMAT_B "", table->has_border_lineweight_overrides, has_border_lineweight_overrides);
    has_border_lineweight_overrides++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "has_border_lineweight_overrides", &has_border_lineweight_overrides, 0)
        && has_border_lineweight_overrides == table->has_border_lineweight_overrides)
      pass ();
    else
      fail ("TABLE.has_border_lineweight_overrides [B] set+1 " FORMAT_B " != " FORMAT_B "", table->has_border_lineweight_overrides, has_border_lineweight_overrides);
    table->has_border_lineweight_overrides--;
  }
  {
    BITCODE_B has_border_visibility_overrides;
    if (dwg_dynapi_entity_value (table, "TABLE", "has_border_visibility_overrides", &has_border_visibility_overrides, NULL)
        && has_border_visibility_overrides == table->has_border_visibility_overrides)
      pass ();
    else
      fail ("TABLE.has_border_visibility_overrides [B] " FORMAT_B " != " FORMAT_B "", table->has_border_visibility_overrides, has_border_visibility_overrides);
    has_border_visibility_overrides++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "has_border_visibility_overrides", &has_border_visibility_overrides, 0)
        && has_border_visibility_overrides == table->has_border_visibility_overrides)
      pass ();
    else
      fail ("TABLE.has_border_visibility_overrides [B] set+1 " FORMAT_B " != " FORMAT_B "", table->has_border_visibility_overrides, has_border_visibility_overrides);
    table->has_border_visibility_overrides--;
  }
  {
    BITCODE_BL has_break_data;
    if (dwg_dynapi_entity_value (table, "TABLE", "has_break_data", &has_break_data, NULL)
        && has_break_data == table->has_break_data)
      pass ();
    else
      fail ("TABLE.has_break_data [BL] %u != %u", table->has_break_data, has_break_data);
    has_break_data++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "has_break_data", &has_break_data, 0)
        && has_break_data == table->has_break_data)
      pass ();
    else
      fail ("TABLE.has_break_data [BL] set+1 %u != %u", table->has_break_data, has_break_data);
    table->has_break_data--;
  }
  {
    BITCODE_B has_table_overrides;
    if (dwg_dynapi_entity_value (table, "TABLE", "has_table_overrides", &has_table_overrides, NULL)
        && has_table_overrides == table->has_table_overrides)
      pass ();
    else
      fail ("TABLE.has_table_overrides [B] " FORMAT_B " != " FORMAT_B "", table->has_table_overrides, has_table_overrides);
    has_table_overrides++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "has_table_overrides", &has_table_overrides, 0)
        && has_table_overrides == table->has_table_overrides)
      pass ();
    else
      fail ("TABLE.has_table_overrides [B] set+1 " FORMAT_B " != " FORMAT_B "", table->has_table_overrides, has_table_overrides);
    table->has_table_overrides--;
  }
  {
    BITCODE_CMC header_horiz_bottom_color;
    if (dwg_dynapi_entity_value (table, "TABLE", "header_horiz_bottom_color", &header_horiz_bottom_color, NULL)
        && !memcmp (&header_horiz_bottom_color, &table->header_horiz_bottom_color, sizeof (BITCODE_CMC)))
        pass ();
    else
        fail ("TABLE.header_horiz_bottom_color [CMC]");
  }
  {
    BITCODE_BS header_horiz_bottom_linewt;
    if (dwg_dynapi_entity_value (table, "TABLE", "header_horiz_bottom_linewt", &header_horiz_bottom_linewt, NULL)
        && header_horiz_bottom_linewt == table->header_horiz_bottom_linewt)
      pass ();
    else
      fail ("TABLE.header_horiz_bottom_linewt [BS] %hu != %hu", table->header_horiz_bottom_linewt, header_horiz_bottom_linewt);
    header_horiz_bottom_linewt++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "header_horiz_bottom_linewt", &header_horiz_bottom_linewt, 0)
        && header_horiz_bottom_linewt == table->header_horiz_bottom_linewt)
      pass ();
    else
      fail ("TABLE.header_horiz_bottom_linewt [BS] set+1 %hu != %hu", table->header_horiz_bottom_linewt, header_horiz_bottom_linewt);
    table->header_horiz_bottom_linewt--;
  }
  {
    BITCODE_BS header_horiz_bottom_visibility;
    if (dwg_dynapi_entity_value (table, "TABLE", "header_horiz_bottom_visibility", &header_horiz_bottom_visibility, NULL)
        && header_horiz_bottom_visibility == table->header_horiz_bottom_visibility)
      pass ();
    else
      fail ("TABLE.header_horiz_bottom_visibility [BS] %hu != %hu", table->header_horiz_bottom_visibility, header_horiz_bottom_visibility);
    header_horiz_bottom_visibility++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "header_horiz_bottom_visibility", &header_horiz_bottom_visibility, 0)
        && header_horiz_bottom_visibility == table->header_horiz_bottom_visibility)
      pass ();
    else
      fail ("TABLE.header_horiz_bottom_visibility [BS] set+1 %hu != %hu", table->header_horiz_bottom_visibility, header_horiz_bottom_visibility);
    table->header_horiz_bottom_visibility--;
  }
  {
    BITCODE_CMC header_horiz_ins_color;
    if (dwg_dynapi_entity_value (table, "TABLE", "header_horiz_ins_color", &header_horiz_ins_color, NULL)
        && !memcmp (&header_horiz_ins_color, &table->header_horiz_ins_color, sizeof (BITCODE_CMC)))
        pass ();
    else
        fail ("TABLE.header_horiz_ins_color [CMC]");
  }
  {
    BITCODE_BS header_horiz_ins_linewt;
    if (dwg_dynapi_entity_value (table, "TABLE", "header_horiz_ins_linewt", &header_horiz_ins_linewt, NULL)
        && header_horiz_ins_linewt == table->header_horiz_ins_linewt)
      pass ();
    else
      fail ("TABLE.header_horiz_ins_linewt [BS] %hu != %hu", table->header_horiz_ins_linewt, header_horiz_ins_linewt);
    header_horiz_ins_linewt++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "header_horiz_ins_linewt", &header_horiz_ins_linewt, 0)
        && header_horiz_ins_linewt == table->header_horiz_ins_linewt)
      pass ();
    else
      fail ("TABLE.header_horiz_ins_linewt [BS] set+1 %hu != %hu", table->header_horiz_ins_linewt, header_horiz_ins_linewt);
    table->header_horiz_ins_linewt--;
  }
  {
    BITCODE_BS header_horiz_ins_visibility;
    if (dwg_dynapi_entity_value (table, "TABLE", "header_horiz_ins_visibility", &header_horiz_ins_visibility, NULL)
        && header_horiz_ins_visibility == table->header_horiz_ins_visibility)
      pass ();
    else
      fail ("TABLE.header_horiz_ins_visibility [BS] %hu != %hu", table->header_horiz_ins_visibility, header_horiz_ins_visibility);
    header_horiz_ins_visibility++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "header_horiz_ins_visibility", &header_horiz_ins_visibility, 0)
        && header_horiz_ins_visibility == table->header_horiz_ins_visibility)
      pass ();
    else
      fail ("TABLE.header_horiz_ins_visibility [BS] set+1 %hu != %hu", table->header_horiz_ins_visibility, header_horiz_ins_visibility);
    table->header_horiz_ins_visibility--;
  }
  {
    BITCODE_CMC header_horiz_top_color;
    if (dwg_dynapi_entity_value (table, "TABLE", "header_horiz_top_color", &header_horiz_top_color, NULL)
        && !memcmp (&header_horiz_top_color, &table->header_horiz_top_color, sizeof (BITCODE_CMC)))
        pass ();
    else
        fail ("TABLE.header_horiz_top_color [CMC]");
  }
  {
    BITCODE_BS header_horiz_top_linewt;
    if (dwg_dynapi_entity_value (table, "TABLE", "header_horiz_top_linewt", &header_horiz_top_linewt, NULL)
        && header_horiz_top_linewt == table->header_horiz_top_linewt)
      pass ();
    else
      fail ("TABLE.header_horiz_top_linewt [BS] %hu != %hu", table->header_horiz_top_linewt, header_horiz_top_linewt);
    header_horiz_top_linewt++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "header_horiz_top_linewt", &header_horiz_top_linewt, 0)
        && header_horiz_top_linewt == table->header_horiz_top_linewt)
      pass ();
    else
      fail ("TABLE.header_horiz_top_linewt [BS] set+1 %hu != %hu", table->header_horiz_top_linewt, header_horiz_top_linewt);
    table->header_horiz_top_linewt--;
  }
  {
    BITCODE_BS header_horiz_top_visibility;
    if (dwg_dynapi_entity_value (table, "TABLE", "header_horiz_top_visibility", &header_horiz_top_visibility, NULL)
        && header_horiz_top_visibility == table->header_horiz_top_visibility)
      pass ();
    else
      fail ("TABLE.header_horiz_top_visibility [BS] %hu != %hu", table->header_horiz_top_visibility, header_horiz_top_visibility);
    header_horiz_top_visibility++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "header_horiz_top_visibility", &header_horiz_top_visibility, 0)
        && header_horiz_top_visibility == table->header_horiz_top_visibility)
      pass ();
    else
      fail ("TABLE.header_horiz_top_visibility [BS] set+1 %hu != %hu", table->header_horiz_top_visibility, header_horiz_top_visibility);
    table->header_horiz_top_visibility--;
  }
  {
    BITCODE_BS header_row_alignment;
    if (dwg_dynapi_entity_value (table, "TABLE", "header_row_alignment", &header_row_alignment, NULL)
        && header_row_alignment == table->header_row_alignment)
      pass ();
    else
      fail ("TABLE.header_row_alignment [BS] %hu != %hu", table->header_row_alignment, header_row_alignment);
    header_row_alignment++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "header_row_alignment", &header_row_alignment, 0)
        && header_row_alignment == table->header_row_alignment)
      pass ();
    else
      fail ("TABLE.header_row_alignment [BS] set+1 %hu != %hu", table->header_row_alignment, header_row_alignment);
    table->header_row_alignment--;
  }
  {
    BITCODE_CMC header_row_color;
    if (dwg_dynapi_entity_value (table, "TABLE", "header_row_color", &header_row_color, NULL)
        && !memcmp (&header_row_color, &table->header_row_color, sizeof (BITCODE_CMC)))
        pass ();
    else
        fail ("TABLE.header_row_color [CMC]");
  }
  {
    BITCODE_CMC header_row_fill_color;
    if (dwg_dynapi_entity_value (table, "TABLE", "header_row_fill_color", &header_row_fill_color, NULL)
        && !memcmp (&header_row_fill_color, &table->header_row_fill_color, sizeof (BITCODE_CMC)))
        pass ();
    else
        fail ("TABLE.header_row_fill_color [CMC]");
  }
  {
    BITCODE_B header_row_fill_none;
    if (dwg_dynapi_entity_value (table, "TABLE", "header_row_fill_none", &header_row_fill_none, NULL)
        && header_row_fill_none == table->header_row_fill_none)
      pass ();
    else
      fail ("TABLE.header_row_fill_none [B] " FORMAT_B " != " FORMAT_B "", table->header_row_fill_none, header_row_fill_none);
    header_row_fill_none++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "header_row_fill_none", &header_row_fill_none, 0)
        && header_row_fill_none == table->header_row_fill_none)
      pass ();
    else
      fail ("TABLE.header_row_fill_none [B] set+1 " FORMAT_B " != " FORMAT_B "", table->header_row_fill_none, header_row_fill_none);
    table->header_row_fill_none--;
  }
  {
    BITCODE_BD header_row_height;
    if (dwg_dynapi_entity_value (table, "TABLE", "header_row_height", &header_row_height, NULL)
        && header_row_height == table->header_row_height)
      pass ();
    else
      fail ("TABLE.header_row_height [BD] %g != %g", table->header_row_height, header_row_height);
    header_row_height++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "header_row_height", &header_row_height, 0)
        && header_row_height == table->header_row_height)
      pass ();
    else
      fail ("TABLE.header_row_height [BD] set+1 %g != %g", table->header_row_height, header_row_height);
    table->header_row_height--;
  }
  {
    BITCODE_H header_row_style_override;
    if (dwg_dynapi_entity_value (table, "TABLE", "header_row_style_override", &header_row_style_override, NULL)
        && !memcmp (&header_row_style_override, &table->header_row_style_override, sizeof (BITCODE_H)))
        pass ();
    else
        fail ("TABLE.header_row_style_override [H]");
  }
  {
    BITCODE_B header_suppressed;
    if (dwg_dynapi_entity_value (table, "TABLE", "header_suppressed", &header_suppressed, NULL)
        && header_suppressed == table->header_suppressed)
      pass ();
    else
      fail ("TABLE.header_suppressed [B] " FORMAT_B " != " FORMAT_B "", table->header_suppressed, header_suppressed);
    header_suppressed++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "header_suppressed", &header_suppressed, 0)
        && header_suppressed == table->header_suppressed)
      pass ();
    else
      fail ("TABLE.header_suppressed [B] set+1 " FORMAT_B " != " FORMAT_B "", table->header_suppressed, header_suppressed);
    table->header_suppressed--;
  }
  {
    BITCODE_H header_text_style;
    if (dwg_dynapi_entity_value (table, "TABLE", "header_text_style", &header_text_style, NULL)
        && !memcmp (&header_text_style, &table->header_text_style, sizeof (BITCODE_H)))
        pass ();
    else
        fail ("TABLE.header_text_style [H]");
  }
  {
    BITCODE_CMC header_vert_ins_color;
    if (dwg_dynapi_entity_value (table, "TABLE", "header_vert_ins_color", &header_vert_ins_color, NULL)
        && !memcmp (&header_vert_ins_color, &table->header_vert_ins_color, sizeof (BITCODE_CMC)))
        pass ();
    else
        fail ("TABLE.header_vert_ins_color [CMC]");
  }
  {
    BITCODE_BS header_vert_ins_linewt;
    if (dwg_dynapi_entity_value (table, "TABLE", "header_vert_ins_linewt", &header_vert_ins_linewt, NULL)
        && header_vert_ins_linewt == table->header_vert_ins_linewt)
      pass ();
    else
      fail ("TABLE.header_vert_ins_linewt [BS] %hu != %hu", table->header_vert_ins_linewt, header_vert_ins_linewt);
    header_vert_ins_linewt++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "header_vert_ins_linewt", &header_vert_ins_linewt, 0)
        && header_vert_ins_linewt == table->header_vert_ins_linewt)
      pass ();
    else
      fail ("TABLE.header_vert_ins_linewt [BS] set+1 %hu != %hu", table->header_vert_ins_linewt, header_vert_ins_linewt);
    table->header_vert_ins_linewt--;
  }
  {
    BITCODE_BS header_vert_ins_visibility;
    if (dwg_dynapi_entity_value (table, "TABLE", "header_vert_ins_visibility", &header_vert_ins_visibility, NULL)
        && header_vert_ins_visibility == table->header_vert_ins_visibility)
      pass ();
    else
      fail ("TABLE.header_vert_ins_visibility [BS] %hu != %hu", table->header_vert_ins_visibility, header_vert_ins_visibility);
    header_vert_ins_visibility++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "header_vert_ins_visibility", &header_vert_ins_visibility, 0)
        && header_vert_ins_visibility == table->header_vert_ins_visibility)
      pass ();
    else
      fail ("TABLE.header_vert_ins_visibility [BS] set+1 %hu != %hu", table->header_vert_ins_visibility, header_vert_ins_visibility);
    table->header_vert_ins_visibility--;
  }
  {
    BITCODE_CMC header_vert_left_color;
    if (dwg_dynapi_entity_value (table, "TABLE", "header_vert_left_color", &header_vert_left_color, NULL)
        && !memcmp (&header_vert_left_color, &table->header_vert_left_color, sizeof (BITCODE_CMC)))
        pass ();
    else
        fail ("TABLE.header_vert_left_color [CMC]");
  }
  {
    BITCODE_BS header_vert_left_linewt;
    if (dwg_dynapi_entity_value (table, "TABLE", "header_vert_left_linewt", &header_vert_left_linewt, NULL)
        && header_vert_left_linewt == table->header_vert_left_linewt)
      pass ();
    else
      fail ("TABLE.header_vert_left_linewt [BS] %hu != %hu", table->header_vert_left_linewt, header_vert_left_linewt);
    header_vert_left_linewt++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "header_vert_left_linewt", &header_vert_left_linewt, 0)
        && header_vert_left_linewt == table->header_vert_left_linewt)
      pass ();
    else
      fail ("TABLE.header_vert_left_linewt [BS] set+1 %hu != %hu", table->header_vert_left_linewt, header_vert_left_linewt);
    table->header_vert_left_linewt--;
  }
  {
    BITCODE_BS header_vert_left_visibility;
    if (dwg_dynapi_entity_value (table, "TABLE", "header_vert_left_visibility", &header_vert_left_visibility, NULL)
        && header_vert_left_visibility == table->header_vert_left_visibility)
      pass ();
    else
      fail ("TABLE.header_vert_left_visibility [BS] %hu != %hu", table->header_vert_left_visibility, header_vert_left_visibility);
    header_vert_left_visibility++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "header_vert_left_visibility", &header_vert_left_visibility, 0)
        && header_vert_left_visibility == table->header_vert_left_visibility)
      pass ();
    else
      fail ("TABLE.header_vert_left_visibility [BS] set+1 %hu != %hu", table->header_vert_left_visibility, header_vert_left_visibility);
    table->header_vert_left_visibility--;
  }
  {
    BITCODE_CMC header_vert_right_color;
    if (dwg_dynapi_entity_value (table, "TABLE", "header_vert_right_color", &header_vert_right_color, NULL)
        && !memcmp (&header_vert_right_color, &table->header_vert_right_color, sizeof (BITCODE_CMC)))
        pass ();
    else
        fail ("TABLE.header_vert_right_color [CMC]");
  }
  {
    BITCODE_BS header_vert_right_linewt;
    if (dwg_dynapi_entity_value (table, "TABLE", "header_vert_right_linewt", &header_vert_right_linewt, NULL)
        && header_vert_right_linewt == table->header_vert_right_linewt)
      pass ();
    else
      fail ("TABLE.header_vert_right_linewt [BS] %hu != %hu", table->header_vert_right_linewt, header_vert_right_linewt);
    header_vert_right_linewt++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "header_vert_right_linewt", &header_vert_right_linewt, 0)
        && header_vert_right_linewt == table->header_vert_right_linewt)
      pass ();
    else
      fail ("TABLE.header_vert_right_linewt [BS] set+1 %hu != %hu", table->header_vert_right_linewt, header_vert_right_linewt);
    table->header_vert_right_linewt--;
  }
  {
    BITCODE_BS header_vert_right_visibility;
    if (dwg_dynapi_entity_value (table, "TABLE", "header_vert_right_visibility", &header_vert_right_visibility, NULL)
        && header_vert_right_visibility == table->header_vert_right_visibility)
      pass ();
    else
      fail ("TABLE.header_vert_right_visibility [BS] %hu != %hu", table->header_vert_right_visibility, header_vert_right_visibility);
    header_vert_right_visibility++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "header_vert_right_visibility", &header_vert_right_visibility, 0)
        && header_vert_right_visibility == table->header_vert_right_visibility)
      pass ();
    else
      fail ("TABLE.header_vert_right_visibility [BS] set+1 %hu != %hu", table->header_vert_right_visibility, header_vert_right_visibility);
    table->header_vert_right_visibility--;
  }
  {
    BITCODE_3BD hor_dir;
    if (dwg_dynapi_entity_value (table, "TABLE", "hor_dir", &hor_dir, NULL)
        && !memcmp (&hor_dir, &table->hor_dir, sizeof (BITCODE_3BD)))
        pass ();
    else
        fail ("TABLE.hor_dir [3BD]");
  }
  {
    BITCODE_BD horiz_cell_margin;
    if (dwg_dynapi_entity_value (table, "TABLE", "horiz_cell_margin", &horiz_cell_margin, NULL)
        && horiz_cell_margin == table->horiz_cell_margin)
      pass ();
    else
      fail ("TABLE.horiz_cell_margin [BD] %g != %g", table->horiz_cell_margin, horiz_cell_margin);
    horiz_cell_margin++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "horiz_cell_margin", &horiz_cell_margin, 0)
        && horiz_cell_margin == table->horiz_cell_margin)
      pass ();
    else
      fail ("TABLE.horiz_cell_margin [BD] set+1 %g != %g", table->horiz_cell_margin, horiz_cell_margin);
    table->horiz_cell_margin--;
  }
  {
    BITCODE_3BD horiz_direction;
    if (dwg_dynapi_entity_value (table, "TABLE", "horiz_direction", &horiz_direction, NULL)
        && !memcmp (&horiz_direction, &table->horiz_direction, sizeof (BITCODE_3BD)))
        pass ();
    else
        fail ("TABLE.horiz_direction [3BD]");
  }
  {
    BITCODE_3BD ins_pt;
    if (dwg_dynapi_entity_value (table, "TABLE", "ins_pt", &ins_pt, NULL)
        && !memcmp (&ins_pt, &table->ins_pt, sizeof (BITCODE_3BD)))
        pass ();
    else
        fail ("TABLE.ins_pt [3BD]");
  }
  {
    BITCODE_H last_attrib;
    if (dwg_dynapi_entity_value (table, "TABLE", "last_attrib", &last_attrib, NULL)
        && !memcmp (&last_attrib, &table->last_attrib, sizeof (BITCODE_H)))
        pass ();
    else
        fail ("TABLE.last_attrib [H]");
  }
  {
    Dwg_LinkedData ldata;
    if (dwg_dynapi_entity_value (table, "TABLE", "ldata", &ldata, NULL)
        && !memcmp (&ldata, &table->ldata, sizeof (Dwg_LinkedData)))
        pass ();
    else
        fail ("TABLE.ldata [Dwg_LinkedData]");
  }
  {
    BITCODE_BL num_break_heights;
    if (dwg_dynapi_entity_value (table, "TABLE", "num_break_heights", &num_break_heights, NULL)
        && num_break_heights == table->num_break_heights)
      pass ();
    else
      fail ("TABLE.num_break_heights [BL] %u != %u", table->num_break_heights, num_break_heights);
    num_break_heights++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "num_break_heights", &num_break_heights, 0)
        && num_break_heights == table->num_break_heights)
      pass ();
    else
      fail ("TABLE.num_break_heights [BL] set+1 %u != %u", table->num_break_heights, num_break_heights);
    table->num_break_heights--;
  }
  {
    BITCODE_BL num_break_rows;
    if (dwg_dynapi_entity_value (table, "TABLE", "num_break_rows", &num_break_rows, NULL)
        && num_break_rows == table->num_break_rows)
      pass ();
    else
      fail ("TABLE.num_break_rows [BL] %u != %u", table->num_break_rows, num_break_rows);
    num_break_rows++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "num_break_rows", &num_break_rows, 0)
        && num_break_rows == table->num_break_rows)
      pass ();
    else
      fail ("TABLE.num_break_rows [BL] set+1 %u != %u", table->num_break_rows, num_break_rows);
    table->num_break_rows--;
  }
  {
    unsigned long num_cells;
    if (dwg_dynapi_entity_value (table, "TABLE", "num_cells", &num_cells, NULL)
        && num_cells == table->num_cells)
      pass ();
    else
      fail ("TABLE.num_cells [unsigned long] %lu != %lu", table->num_cells, num_cells);
    num_cells++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "num_cells", &num_cells, 0)
        && num_cells == table->num_cells)
      pass ();
    else
      fail ("TABLE.num_cells [unsigned long] set+1 %lu != %lu", table->num_cells, num_cells);
    table->num_cells--;
  }
  {
    BITCODE_BL num_cols;
    if (dwg_dynapi_entity_value (table, "TABLE", "num_cols", &num_cols, NULL)
        && num_cols == table->num_cols)
      pass ();
    else
      fail ("TABLE.num_cols [BL] %u != %u", table->num_cols, num_cols);
    num_cols++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "num_cols", &num_cols, 0)
        && num_cols == table->num_cols)
      pass ();
    else
      fail ("TABLE.num_cols [BL] set+1 %u != %u", table->num_cols, num_cols);
    table->num_cols--;
  }
  {
    BITCODE_BL num_owned;
    if (dwg_dynapi_entity_value (table, "TABLE", "num_owned", &num_owned, NULL)
        && num_owned == table->num_owned)
      pass ();
    else
      fail ("TABLE.num_owned [BL] %u != %u", table->num_owned, num_owned);
    num_owned++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "num_owned", &num_owned, 0)
        && num_owned == table->num_owned)
      pass ();
    else
      fail ("TABLE.num_owned [BL] set+1 %u != %u", table->num_owned, num_owned);
    table->num_owned--;
  }
  {
    BITCODE_BL num_rows;
    if (dwg_dynapi_entity_value (table, "TABLE", "num_rows", &num_rows, NULL)
        && num_rows == table->num_rows)
      pass ();
    else
      fail ("TABLE.num_rows [BL] %u != %u", table->num_rows, num_rows);
    num_rows++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "num_rows", &num_rows, 0)
        && num_rows == table->num_rows)
      pass ();
    else
      fail ("TABLE.num_rows [BL] set+1 %u != %u", table->num_rows, num_rows);
    table->num_rows--;
  }
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value (table, "TABLE", "parent", &parent, NULL)
        && !memcmp (&parent, &table->parent, sizeof (struct _dwg_object_entity*)))
        pass ();
    else
        fail ("TABLE.parent [struct _dwg_object_entity*]");
  }
  {
    BITCODE_BD rotation;
    if (dwg_dynapi_entity_value (table, "TABLE", "rotation", &rotation, NULL)
        && rotation == table->rotation)
      pass ();
    else
      fail ("TABLE.rotation [BD] %g != %g", table->rotation, rotation);
    rotation++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "rotation", &rotation, 0)
        && rotation == table->rotation)
      pass ();
    else
      fail ("TABLE.rotation [BD] set+1 %g != %g", table->rotation, rotation);
    table->rotation--;
  }
  {
    BITCODE_BD* row_heights;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (table, "TABLE", "num_row_heights", &count, NULL)
        && dwg_dynapi_entity_value (table, "TABLE", "row_heights", &row_heights, NULL)
        && row_heights == table->row_heights)
      pass ();
    else
      fail ("TABLE.row_heights [BD*] * %u num_row_heights", count);
  }
  {
    BITCODE_3BD scale;
    if (dwg_dynapi_entity_value (table, "TABLE", "scale", &scale, NULL)
        && !memcmp (&scale, &table->scale, sizeof (BITCODE_3BD)))
        pass ();
    else
        fail ("TABLE.scale [3BD_1]");
  }
  {
    BITCODE_BB scale_flag;
    if (dwg_dynapi_entity_value (table, "TABLE", "scale_flag", &scale_flag, NULL)
        && scale_flag == table->scale_flag)
      pass ();
    else
      fail ("TABLE.scale_flag [BB] " FORMAT_BB " != " FORMAT_BB "", table->scale_flag, scale_flag);
    scale_flag++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "scale_flag", &scale_flag, 0)
        && scale_flag == table->scale_flag)
      pass ();
    else
      fail ("TABLE.scale_flag [BB] set+1 " FORMAT_BB " != " FORMAT_BB "", table->scale_flag, scale_flag);
    table->scale_flag--;
  }
  {
    BITCODE_H seqend;
    if (dwg_dynapi_entity_value (table, "TABLE", "seqend", &seqend, NULL)
        && !memcmp (&seqend, &table->seqend, sizeof (BITCODE_H)))
        pass ();
    else
        fail ("TABLE.seqend [H]");
  }
  {
    BITCODE_BL table_flag_override;
    if (dwg_dynapi_entity_value (table, "TABLE", "table_flag_override", &table_flag_override, NULL)
        && table_flag_override == table->table_flag_override)
      pass ();
    else
      fail ("TABLE.table_flag_override [BL] %u != %u", table->table_flag_override, table_flag_override);
    table_flag_override++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "table_flag_override", &table_flag_override, 0)
        && table_flag_override == table->table_flag_override)
      pass ();
    else
      fail ("TABLE.table_flag_override [BL] set+1 %u != %u", table->table_flag_override, table_flag_override);
    table->table_flag_override--;
  }
  {
    BITCODE_H tablestyle;
    if (dwg_dynapi_entity_value (table, "TABLE", "tablestyle", &tablestyle, NULL)
        && !memcmp (&tablestyle, &table->tablestyle, sizeof (BITCODE_H)))
        pass ();
    else
        fail ("TABLE.tablestyle [H]");
  }
  {
    Dwg_LinkedTableData tdata;
    if (dwg_dynapi_entity_value (table, "TABLE", "tdata", &tdata, NULL)
        && !memcmp (&tdata, &table->tdata, sizeof (Dwg_LinkedTableData)))
        pass ();
    else
        fail ("TABLE.tdata [Dwg_LinkedTableData]");
  }
  {
    BITCODE_CMC title_horiz_bottom_color;
    if (dwg_dynapi_entity_value (table, "TABLE", "title_horiz_bottom_color", &title_horiz_bottom_color, NULL)
        && !memcmp (&title_horiz_bottom_color, &table->title_horiz_bottom_color, sizeof (BITCODE_CMC)))
        pass ();
    else
        fail ("TABLE.title_horiz_bottom_color [CMC]");
  }
  {
    BITCODE_BS title_horiz_bottom_linewt;
    if (dwg_dynapi_entity_value (table, "TABLE", "title_horiz_bottom_linewt", &title_horiz_bottom_linewt, NULL)
        && title_horiz_bottom_linewt == table->title_horiz_bottom_linewt)
      pass ();
    else
      fail ("TABLE.title_horiz_bottom_linewt [BS] %hu != %hu", table->title_horiz_bottom_linewt, title_horiz_bottom_linewt);
    title_horiz_bottom_linewt++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "title_horiz_bottom_linewt", &title_horiz_bottom_linewt, 0)
        && title_horiz_bottom_linewt == table->title_horiz_bottom_linewt)
      pass ();
    else
      fail ("TABLE.title_horiz_bottom_linewt [BS] set+1 %hu != %hu", table->title_horiz_bottom_linewt, title_horiz_bottom_linewt);
    table->title_horiz_bottom_linewt--;
  }
  {
    BITCODE_BS title_horiz_bottom_visibility;
    if (dwg_dynapi_entity_value (table, "TABLE", "title_horiz_bottom_visibility", &title_horiz_bottom_visibility, NULL)
        && title_horiz_bottom_visibility == table->title_horiz_bottom_visibility)
      pass ();
    else
      fail ("TABLE.title_horiz_bottom_visibility [BS] %hu != %hu", table->title_horiz_bottom_visibility, title_horiz_bottom_visibility);
    title_horiz_bottom_visibility++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "title_horiz_bottom_visibility", &title_horiz_bottom_visibility, 0)
        && title_horiz_bottom_visibility == table->title_horiz_bottom_visibility)
      pass ();
    else
      fail ("TABLE.title_horiz_bottom_visibility [BS] set+1 %hu != %hu", table->title_horiz_bottom_visibility, title_horiz_bottom_visibility);
    table->title_horiz_bottom_visibility--;
  }
  {
    BITCODE_CMC title_horiz_ins_color;
    if (dwg_dynapi_entity_value (table, "TABLE", "title_horiz_ins_color", &title_horiz_ins_color, NULL)
        && !memcmp (&title_horiz_ins_color, &table->title_horiz_ins_color, sizeof (BITCODE_CMC)))
        pass ();
    else
        fail ("TABLE.title_horiz_ins_color [CMC]");
  }
  {
    BITCODE_BS title_horiz_ins_linewt;
    if (dwg_dynapi_entity_value (table, "TABLE", "title_horiz_ins_linewt", &title_horiz_ins_linewt, NULL)
        && title_horiz_ins_linewt == table->title_horiz_ins_linewt)
      pass ();
    else
      fail ("TABLE.title_horiz_ins_linewt [BS] %hu != %hu", table->title_horiz_ins_linewt, title_horiz_ins_linewt);
    title_horiz_ins_linewt++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "title_horiz_ins_linewt", &title_horiz_ins_linewt, 0)
        && title_horiz_ins_linewt == table->title_horiz_ins_linewt)
      pass ();
    else
      fail ("TABLE.title_horiz_ins_linewt [BS] set+1 %hu != %hu", table->title_horiz_ins_linewt, title_horiz_ins_linewt);
    table->title_horiz_ins_linewt--;
  }
  {
    BITCODE_BS title_horiz_ins_visibility;
    if (dwg_dynapi_entity_value (table, "TABLE", "title_horiz_ins_visibility", &title_horiz_ins_visibility, NULL)
        && title_horiz_ins_visibility == table->title_horiz_ins_visibility)
      pass ();
    else
      fail ("TABLE.title_horiz_ins_visibility [BS] %hu != %hu", table->title_horiz_ins_visibility, title_horiz_ins_visibility);
    title_horiz_ins_visibility++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "title_horiz_ins_visibility", &title_horiz_ins_visibility, 0)
        && title_horiz_ins_visibility == table->title_horiz_ins_visibility)
      pass ();
    else
      fail ("TABLE.title_horiz_ins_visibility [BS] set+1 %hu != %hu", table->title_horiz_ins_visibility, title_horiz_ins_visibility);
    table->title_horiz_ins_visibility--;
  }
  {
    BITCODE_CMC title_horiz_top_color;
    if (dwg_dynapi_entity_value (table, "TABLE", "title_horiz_top_color", &title_horiz_top_color, NULL)
        && !memcmp (&title_horiz_top_color, &table->title_horiz_top_color, sizeof (BITCODE_CMC)))
        pass ();
    else
        fail ("TABLE.title_horiz_top_color [CMC]");
  }
  {
    BITCODE_BS title_horiz_top_linewt;
    if (dwg_dynapi_entity_value (table, "TABLE", "title_horiz_top_linewt", &title_horiz_top_linewt, NULL)
        && title_horiz_top_linewt == table->title_horiz_top_linewt)
      pass ();
    else
      fail ("TABLE.title_horiz_top_linewt [BS] %hu != %hu", table->title_horiz_top_linewt, title_horiz_top_linewt);
    title_horiz_top_linewt++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "title_horiz_top_linewt", &title_horiz_top_linewt, 0)
        && title_horiz_top_linewt == table->title_horiz_top_linewt)
      pass ();
    else
      fail ("TABLE.title_horiz_top_linewt [BS] set+1 %hu != %hu", table->title_horiz_top_linewt, title_horiz_top_linewt);
    table->title_horiz_top_linewt--;
  }
  {
    BITCODE_BS title_horiz_top_visibility;
    if (dwg_dynapi_entity_value (table, "TABLE", "title_horiz_top_visibility", &title_horiz_top_visibility, NULL)
        && title_horiz_top_visibility == table->title_horiz_top_visibility)
      pass ();
    else
      fail ("TABLE.title_horiz_top_visibility [BS] %hu != %hu", table->title_horiz_top_visibility, title_horiz_top_visibility);
    title_horiz_top_visibility++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "title_horiz_top_visibility", &title_horiz_top_visibility, 0)
        && title_horiz_top_visibility == table->title_horiz_top_visibility)
      pass ();
    else
      fail ("TABLE.title_horiz_top_visibility [BS] set+1 %hu != %hu", table->title_horiz_top_visibility, title_horiz_top_visibility);
    table->title_horiz_top_visibility--;
  }
  {
    BITCODE_BS title_row_alignment;
    if (dwg_dynapi_entity_value (table, "TABLE", "title_row_alignment", &title_row_alignment, NULL)
        && title_row_alignment == table->title_row_alignment)
      pass ();
    else
      fail ("TABLE.title_row_alignment [BS] %hu != %hu", table->title_row_alignment, title_row_alignment);
    title_row_alignment++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "title_row_alignment", &title_row_alignment, 0)
        && title_row_alignment == table->title_row_alignment)
      pass ();
    else
      fail ("TABLE.title_row_alignment [BS] set+1 %hu != %hu", table->title_row_alignment, title_row_alignment);
    table->title_row_alignment--;
  }
  {
    BITCODE_CMC title_row_color;
    if (dwg_dynapi_entity_value (table, "TABLE", "title_row_color", &title_row_color, NULL)
        && !memcmp (&title_row_color, &table->title_row_color, sizeof (BITCODE_CMC)))
        pass ();
    else
        fail ("TABLE.title_row_color [CMC]");
  }
  {
    BITCODE_CMC title_row_fill_color;
    if (dwg_dynapi_entity_value (table, "TABLE", "title_row_fill_color", &title_row_fill_color, NULL)
        && !memcmp (&title_row_fill_color, &table->title_row_fill_color, sizeof (BITCODE_CMC)))
        pass ();
    else
        fail ("TABLE.title_row_fill_color [CMC]");
  }
  {
    BITCODE_B title_row_fill_none;
    if (dwg_dynapi_entity_value (table, "TABLE", "title_row_fill_none", &title_row_fill_none, NULL)
        && title_row_fill_none == table->title_row_fill_none)
      pass ();
    else
      fail ("TABLE.title_row_fill_none [B] " FORMAT_B " != " FORMAT_B "", table->title_row_fill_none, title_row_fill_none);
    title_row_fill_none++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "title_row_fill_none", &title_row_fill_none, 0)
        && title_row_fill_none == table->title_row_fill_none)
      pass ();
    else
      fail ("TABLE.title_row_fill_none [B] set+1 " FORMAT_B " != " FORMAT_B "", table->title_row_fill_none, title_row_fill_none);
    table->title_row_fill_none--;
  }
  {
    BITCODE_BD title_row_height;
    if (dwg_dynapi_entity_value (table, "TABLE", "title_row_height", &title_row_height, NULL)
        && title_row_height == table->title_row_height)
      pass ();
    else
      fail ("TABLE.title_row_height [BD] %g != %g", table->title_row_height, title_row_height);
    title_row_height++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "title_row_height", &title_row_height, 0)
        && title_row_height == table->title_row_height)
      pass ();
    else
      fail ("TABLE.title_row_height [BD] set+1 %g != %g", table->title_row_height, title_row_height);
    table->title_row_height--;
  }
  {
    BITCODE_H title_row_style_override;
    if (dwg_dynapi_entity_value (table, "TABLE", "title_row_style_override", &title_row_style_override, NULL)
        && !memcmp (&title_row_style_override, &table->title_row_style_override, sizeof (BITCODE_H)))
        pass ();
    else
        fail ("TABLE.title_row_style_override [H]");
  }
  {
    BITCODE_B title_suppressed;
    if (dwg_dynapi_entity_value (table, "TABLE", "title_suppressed", &title_suppressed, NULL)
        && title_suppressed == table->title_suppressed)
      pass ();
    else
      fail ("TABLE.title_suppressed [B] " FORMAT_B " != " FORMAT_B "", table->title_suppressed, title_suppressed);
    title_suppressed++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "title_suppressed", &title_suppressed, 0)
        && title_suppressed == table->title_suppressed)
      pass ();
    else
      fail ("TABLE.title_suppressed [B] set+1 " FORMAT_B " != " FORMAT_B "", table->title_suppressed, title_suppressed);
    table->title_suppressed--;
  }
  {
    BITCODE_H title_text_style;
    if (dwg_dynapi_entity_value (table, "TABLE", "title_text_style", &title_text_style, NULL)
        && !memcmp (&title_text_style, &table->title_text_style, sizeof (BITCODE_H)))
        pass ();
    else
        fail ("TABLE.title_text_style [H]");
  }
  {
    BITCODE_CMC title_vert_ins_color;
    if (dwg_dynapi_entity_value (table, "TABLE", "title_vert_ins_color", &title_vert_ins_color, NULL)
        && !memcmp (&title_vert_ins_color, &table->title_vert_ins_color, sizeof (BITCODE_CMC)))
        pass ();
    else
        fail ("TABLE.title_vert_ins_color [CMC]");
  }
  {
    BITCODE_BS title_vert_ins_linewt;
    if (dwg_dynapi_entity_value (table, "TABLE", "title_vert_ins_linewt", &title_vert_ins_linewt, NULL)
        && title_vert_ins_linewt == table->title_vert_ins_linewt)
      pass ();
    else
      fail ("TABLE.title_vert_ins_linewt [BS] %hu != %hu", table->title_vert_ins_linewt, title_vert_ins_linewt);
    title_vert_ins_linewt++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "title_vert_ins_linewt", &title_vert_ins_linewt, 0)
        && title_vert_ins_linewt == table->title_vert_ins_linewt)
      pass ();
    else
      fail ("TABLE.title_vert_ins_linewt [BS] set+1 %hu != %hu", table->title_vert_ins_linewt, title_vert_ins_linewt);
    table->title_vert_ins_linewt--;
  }
  {
    BITCODE_BS title_vert_ins_visibility;
    if (dwg_dynapi_entity_value (table, "TABLE", "title_vert_ins_visibility", &title_vert_ins_visibility, NULL)
        && title_vert_ins_visibility == table->title_vert_ins_visibility)
      pass ();
    else
      fail ("TABLE.title_vert_ins_visibility [BS] %hu != %hu", table->title_vert_ins_visibility, title_vert_ins_visibility);
    title_vert_ins_visibility++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "title_vert_ins_visibility", &title_vert_ins_visibility, 0)
        && title_vert_ins_visibility == table->title_vert_ins_visibility)
      pass ();
    else
      fail ("TABLE.title_vert_ins_visibility [BS] set+1 %hu != %hu", table->title_vert_ins_visibility, title_vert_ins_visibility);
    table->title_vert_ins_visibility--;
  }
  {
    BITCODE_CMC title_vert_left_color;
    if (dwg_dynapi_entity_value (table, "TABLE", "title_vert_left_color", &title_vert_left_color, NULL)
        && !memcmp (&title_vert_left_color, &table->title_vert_left_color, sizeof (BITCODE_CMC)))
        pass ();
    else
        fail ("TABLE.title_vert_left_color [CMC]");
  }
  {
    BITCODE_BS title_vert_left_linewt;
    if (dwg_dynapi_entity_value (table, "TABLE", "title_vert_left_linewt", &title_vert_left_linewt, NULL)
        && title_vert_left_linewt == table->title_vert_left_linewt)
      pass ();
    else
      fail ("TABLE.title_vert_left_linewt [BS] %hu != %hu", table->title_vert_left_linewt, title_vert_left_linewt);
    title_vert_left_linewt++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "title_vert_left_linewt", &title_vert_left_linewt, 0)
        && title_vert_left_linewt == table->title_vert_left_linewt)
      pass ();
    else
      fail ("TABLE.title_vert_left_linewt [BS] set+1 %hu != %hu", table->title_vert_left_linewt, title_vert_left_linewt);
    table->title_vert_left_linewt--;
  }
  {
    BITCODE_BS title_vert_left_visibility;
    if (dwg_dynapi_entity_value (table, "TABLE", "title_vert_left_visibility", &title_vert_left_visibility, NULL)
        && title_vert_left_visibility == table->title_vert_left_visibility)
      pass ();
    else
      fail ("TABLE.title_vert_left_visibility [BS] %hu != %hu", table->title_vert_left_visibility, title_vert_left_visibility);
    title_vert_left_visibility++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "title_vert_left_visibility", &title_vert_left_visibility, 0)
        && title_vert_left_visibility == table->title_vert_left_visibility)
      pass ();
    else
      fail ("TABLE.title_vert_left_visibility [BS] set+1 %hu != %hu", table->title_vert_left_visibility, title_vert_left_visibility);
    table->title_vert_left_visibility--;
  }
  {
    BITCODE_CMC title_vert_right_color;
    if (dwg_dynapi_entity_value (table, "TABLE", "title_vert_right_color", &title_vert_right_color, NULL)
        && !memcmp (&title_vert_right_color, &table->title_vert_right_color, sizeof (BITCODE_CMC)))
        pass ();
    else
        fail ("TABLE.title_vert_right_color [CMC]");
  }
  {
    BITCODE_BS title_vert_right_linewt;
    if (dwg_dynapi_entity_value (table, "TABLE", "title_vert_right_linewt", &title_vert_right_linewt, NULL)
        && title_vert_right_linewt == table->title_vert_right_linewt)
      pass ();
    else
      fail ("TABLE.title_vert_right_linewt [BS] %hu != %hu", table->title_vert_right_linewt, title_vert_right_linewt);
    title_vert_right_linewt++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "title_vert_right_linewt", &title_vert_right_linewt, 0)
        && title_vert_right_linewt == table->title_vert_right_linewt)
      pass ();
    else
      fail ("TABLE.title_vert_right_linewt [BS] set+1 %hu != %hu", table->title_vert_right_linewt, title_vert_right_linewt);
    table->title_vert_right_linewt--;
  }
  {
    BITCODE_BS title_vert_right_visibility;
    if (dwg_dynapi_entity_value (table, "TABLE", "title_vert_right_visibility", &title_vert_right_visibility, NULL)
        && title_vert_right_visibility == table->title_vert_right_visibility)
      pass ();
    else
      fail ("TABLE.title_vert_right_visibility [BS] %hu != %hu", table->title_vert_right_visibility, title_vert_right_visibility);
    title_vert_right_visibility++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "title_vert_right_visibility", &title_vert_right_visibility, 0)
        && title_vert_right_visibility == table->title_vert_right_visibility)
      pass ();
    else
      fail ("TABLE.title_vert_right_visibility [BS] set+1 %hu != %hu", table->title_vert_right_visibility, title_vert_right_visibility);
    table->title_vert_right_visibility--;
  }
  {
    BITCODE_B unknown_b;
    if (dwg_dynapi_entity_value (table, "TABLE", "unknown_b", &unknown_b, NULL)
        && unknown_b == table->unknown_b)
      pass ();
    else
      fail ("TABLE.unknown_b [B] " FORMAT_B " != " FORMAT_B "", table->unknown_b, unknown_b);
    unknown_b++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "unknown_b", &unknown_b, 0)
        && unknown_b == table->unknown_b)
      pass ();
    else
      fail ("TABLE.unknown_b [B] set+1 " FORMAT_B " != " FORMAT_B "", table->unknown_b, unknown_b);
    table->unknown_b--;
  }
  {
    BITCODE_BL unknown_bl;
    if (dwg_dynapi_entity_value (table, "TABLE", "unknown_bl", &unknown_bl, NULL)
        && unknown_bl == table->unknown_bl)
      pass ();
    else
      fail ("TABLE.unknown_bl [BL] %u != %u", table->unknown_bl, unknown_bl);
    unknown_bl++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "unknown_bl", &unknown_bl, 0)
        && unknown_bl == table->unknown_bl)
      pass ();
    else
      fail ("TABLE.unknown_bl [BL] set+1 %u != %u", table->unknown_bl, unknown_bl);
    table->unknown_bl--;
  }
  {
    BITCODE_BL unknown_bl1;
    if (dwg_dynapi_entity_value (table, "TABLE", "unknown_bl1", &unknown_bl1, NULL)
        && unknown_bl1 == table->unknown_bl1)
      pass ();
    else
      fail ("TABLE.unknown_bl1 [BL] %u != %u", table->unknown_bl1, unknown_bl1);
    unknown_bl1++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "unknown_bl1", &unknown_bl1, 0)
        && unknown_bl1 == table->unknown_bl1)
      pass ();
    else
      fail ("TABLE.unknown_bl1 [BL] set+1 %u != %u", table->unknown_bl1, unknown_bl1);
    table->unknown_bl1--;
  }
  {
    BITCODE_BS unknown_bs;
    if (dwg_dynapi_entity_value (table, "TABLE", "unknown_bs", &unknown_bs, NULL)
        && unknown_bs == table->unknown_bs)
      pass ();
    else
      fail ("TABLE.unknown_bs [BS] %hu != %hu", table->unknown_bs, unknown_bs);
    unknown_bs++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "unknown_bs", &unknown_bs, 0)
        && unknown_bs == table->unknown_bs)
      pass ();
    else
      fail ("TABLE.unknown_bs [BS] set+1 %hu != %hu", table->unknown_bs, unknown_bs);
    table->unknown_bs--;
  }
  {
    BITCODE_H unknown_h;
    if (dwg_dynapi_entity_value (table, "TABLE", "unknown_h", &unknown_h, NULL)
        && !memcmp (&unknown_h, &table->unknown_h, sizeof (BITCODE_H)))
        pass ();
    else
        fail ("TABLE.unknown_h [H]");
  }
  {
    BITCODE_RC unknown_rc;
    if (dwg_dynapi_entity_value (table, "TABLE", "unknown_rc", &unknown_rc, NULL)
        && unknown_rc == table->unknown_rc)
      pass ();
    else
      fail ("TABLE.unknown_rc [RC] %u != %u", table->unknown_rc, unknown_rc);
    unknown_rc++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "unknown_rc", &unknown_rc, 0)
        && unknown_rc == table->unknown_rc)
      pass ();
    else
      fail ("TABLE.unknown_rc [RC] set+1 %u != %u", table->unknown_rc, unknown_rc);
    table->unknown_rc--;
  }
  {
    BITCODE_BD vert_cell_margin;
    if (dwg_dynapi_entity_value (table, "TABLE", "vert_cell_margin", &vert_cell_margin, NULL)
        && vert_cell_margin == table->vert_cell_margin)
      pass ();
    else
      fail ("TABLE.vert_cell_margin [BD] %g != %g", table->vert_cell_margin, vert_cell_margin);
    vert_cell_margin++;
    if (dwg_dynapi_entity_set_value (table, "TABLE", "vert_cell_margin", &vert_cell_margin, 0)
        && vert_cell_margin == table->vert_cell_margin)
      pass ();
    else
      fail ("TABLE.vert_cell_margin [BD] set+1 %g != %g", table->vert_cell_margin, vert_cell_margin);
    table->vert_cell_margin--;
  }
  if (failed && (is_class_unstable ("TABLE") || is_class_debugging ("TABLE")))
    {
      ok ("%s failed %d tests (TODO unstable)", "TABLE", failed);
      failed = 0;
    }
  return failed;
}
static int test_TEXT (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_TEXT *restrict text = obj->tio.entity->tio.TEXT;
  failed = 0;
  {
    BITCODE_2DPOINT alignment_pt;
    if (dwg_dynapi_entity_value (text, "TEXT", "alignment_pt", &alignment_pt, NULL)
        && !memcmp (&alignment_pt, &text->alignment_pt, sizeof (BITCODE_2DPOINT)))
        pass ();
    else
        fail ("TEXT.alignment_pt [2DPOINT]");
  }
  {
    BITCODE_RC dataflags;
    if (dwg_dynapi_entity_value (text, "TEXT", "dataflags", &dataflags, NULL)
        && dataflags == text->dataflags)
      pass ();
    else
      fail ("TEXT.dataflags [RC] %u != %u", text->dataflags, dataflags);
    dataflags++;
    if (dwg_dynapi_entity_set_value (text, "TEXT", "dataflags", &dataflags, 0)
        && dataflags == text->dataflags)
      pass ();
    else
      fail ("TEXT.dataflags [RC] set+1 %u != %u", text->dataflags, dataflags);
    text->dataflags--;
  }
  {
    BITCODE_RD elevation;
    if (dwg_dynapi_entity_value (text, "TEXT", "elevation", &elevation, NULL)
        && elevation == text->elevation)
      pass ();
    else
      fail ("TEXT.elevation [RD] %g != %g", text->elevation, elevation);
    elevation++;
    if (dwg_dynapi_entity_set_value (text, "TEXT", "elevation", &elevation, 0)
        && elevation == text->elevation)
      pass ();
    else
      fail ("TEXT.elevation [RD] set+1 %g != %g", text->elevation, elevation);
    text->elevation--;
  }
  {
    BITCODE_BE extrusion;
    if (dwg_dynapi_entity_value (text, "TEXT", "extrusion", &extrusion, NULL)
        && !memcmp (&extrusion, &text->extrusion, sizeof (BITCODE_BE)))
        pass ();
    else
        fail ("TEXT.extrusion [BE]");
  }
  {
    BITCODE_BS generation;
    if (dwg_dynapi_entity_value (text, "TEXT", "generation", &generation, NULL)
        && generation == text->generation)
      pass ();
    else
      fail ("TEXT.generation [BS] %hu != %hu", text->generation, generation);
    generation++;
    if (dwg_dynapi_entity_set_value (text, "TEXT", "generation", &generation, 0)
        && generation == text->generation)
      pass ();
    else
      fail ("TEXT.generation [BS] set+1 %hu != %hu", text->generation, generation);
    text->generation--;
  }
  {
    BITCODE_RD height;
    if (dwg_dynapi_entity_value (text, "TEXT", "height", &height, NULL)
        && height == text->height)
      pass ();
    else
      fail ("TEXT.height [RD] %g != %g", text->height, height);
    height++;
    if (dwg_dynapi_entity_set_value (text, "TEXT", "height", &height, 0)
        && height == text->height)
      pass ();
    else
      fail ("TEXT.height [RD] set+1 %g != %g", text->height, height);
    text->height--;
  }
  {
    BITCODE_BS horiz_alignment;
    if (dwg_dynapi_entity_value (text, "TEXT", "horiz_alignment", &horiz_alignment, NULL)
        && horiz_alignment == text->horiz_alignment)
      pass ();
    else
      fail ("TEXT.horiz_alignment [BS] %hu != %hu", text->horiz_alignment, horiz_alignment);
    horiz_alignment++;
    if (dwg_dynapi_entity_set_value (text, "TEXT", "horiz_alignment", &horiz_alignment, 0)
        && horiz_alignment == text->horiz_alignment)
      pass ();
    else
      fail ("TEXT.horiz_alignment [BS] set+1 %hu != %hu", text->horiz_alignment, horiz_alignment);
    text->horiz_alignment--;
  }
  {
    BITCODE_2DPOINT ins_pt;
    if (dwg_dynapi_entity_value (text, "TEXT", "ins_pt", &ins_pt, NULL)
        && !memcmp (&ins_pt, &text->ins_pt, sizeof (BITCODE_2DPOINT)))
        pass ();
    else
        fail ("TEXT.ins_pt [2DPOINT]");
  }
  {
    BITCODE_RD oblique_angle;
    if (dwg_dynapi_entity_value (text, "TEXT", "oblique_angle", &oblique_angle, NULL)
        && oblique_angle == text->oblique_angle)
      pass ();
    else
      fail ("TEXT.oblique_angle [RD] %g != %g", text->oblique_angle, oblique_angle);
    oblique_angle++;
    if (dwg_dynapi_entity_set_value (text, "TEXT", "oblique_angle", &oblique_angle, 0)
        && oblique_angle == text->oblique_angle)
      pass ();
    else
      fail ("TEXT.oblique_angle [RD] set+1 %g != %g", text->oblique_angle, oblique_angle);
    text->oblique_angle--;
  }
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value (text, "TEXT", "parent", &parent, NULL)
        && !memcmp (&parent, &text->parent, sizeof (struct _dwg_object_entity*)))
        pass ();
    else
        fail ("TEXT.parent [struct _dwg_object_entity*]");
  }
  {
    BITCODE_RD rotation;
    if (dwg_dynapi_entity_value (text, "TEXT", "rotation", &rotation, NULL)
        && rotation == text->rotation)
      pass ();
    else
      fail ("TEXT.rotation [RD] %g != %g", text->rotation, rotation);
    rotation++;
    if (dwg_dynapi_entity_set_value (text, "TEXT", "rotation", &rotation, 0)
        && rotation == text->rotation)
      pass ();
    else
      fail ("TEXT.rotation [RD] set+1 %g != %g", text->rotation, rotation);
    text->rotation--;
  }
  {
    BITCODE_H style;
    if (dwg_dynapi_entity_value (text, "TEXT", "style", &style, NULL)
        && !memcmp (&style, &text->style, sizeof (BITCODE_H)))
        pass ();
    else
        fail ("TEXT.style [H]");
  }
  {
    BITCODE_T text_value;
    if (dwg_dynapi_entity_value (text, "TEXT", "text_value", &text_value, NULL)
        && text_value
           ? strEQ ((char *)text_value, (char *)text->text_value)
           : !text->text_value)
      pass ();
    else
      fail ("TEXT.text_value [T] '%s' <> '%s'", text_value, text->text_value);
  }
  {
    BITCODE_RD thickness;
    if (dwg_dynapi_entity_value (text, "TEXT", "thickness", &thickness, NULL)
        && thickness == text->thickness)
      pass ();
    else
      fail ("TEXT.thickness [RD] %g != %g", text->thickness, thickness);
    thickness++;
    if (dwg_dynapi_entity_set_value (text, "TEXT", "thickness", &thickness, 0)
        && thickness == text->thickness)
      pass ();
    else
      fail ("TEXT.thickness [RD] set+1 %g != %g", text->thickness, thickness);
    text->thickness--;
  }
  {
    BITCODE_BS vert_alignment;
    if (dwg_dynapi_entity_value (text, "TEXT", "vert_alignment", &vert_alignment, NULL)
        && vert_alignment == text->vert_alignment)
      pass ();
    else
      fail ("TEXT.vert_alignment [BS] %hu != %hu", text->vert_alignment, vert_alignment);
    vert_alignment++;
    if (dwg_dynapi_entity_set_value (text, "TEXT", "vert_alignment", &vert_alignment, 0)
        && vert_alignment == text->vert_alignment)
      pass ();
    else
      fail ("TEXT.vert_alignment [BS] set+1 %hu != %hu", text->vert_alignment, vert_alignment);
    text->vert_alignment--;
  }
  {
    BITCODE_RD width_factor;
    if (dwg_dynapi_entity_value (text, "TEXT", "width_factor", &width_factor, NULL)
        && width_factor == text->width_factor)
      pass ();
    else
      fail ("TEXT.width_factor [RD] %g != %g", text->width_factor, width_factor);
    width_factor++;
    if (dwg_dynapi_entity_set_value (text, "TEXT", "width_factor", &width_factor, 0)
        && width_factor == text->width_factor)
      pass ();
    else
      fail ("TEXT.width_factor [RD] set+1 %g != %g", text->width_factor, width_factor);
    text->width_factor--;
  }
  if (failed && (is_class_unstable ("TEXT") || is_class_debugging ("TEXT")))
    {
      ok ("%s failed %d tests (TODO unstable)", "TEXT", failed);
      failed = 0;
    }
  return failed;
}
static int test_TOLERANCE (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_TOLERANCE *restrict tolerance = obj->tio.entity->tio.TOLERANCE;
  failed = 0;
  {
    BITCODE_BD dimgap;
    if (dwg_dynapi_entity_value (tolerance, "TOLERANCE", "dimgap", &dimgap, NULL)
        && dimgap == tolerance->dimgap)
      pass ();
    else
      fail ("TOLERANCE.dimgap [BD] %g != %g", tolerance->dimgap, dimgap);
    dimgap++;
    if (dwg_dynapi_entity_set_value (tolerance, "TOLERANCE", "dimgap", &dimgap, 0)
        && dimgap == tolerance->dimgap)
      pass ();
    else
      fail ("TOLERANCE.dimgap [BD] set+1 %g != %g", tolerance->dimgap, dimgap);
    tolerance->dimgap--;
  }
  {
    BITCODE_H dimstyle;
    if (dwg_dynapi_entity_value (tolerance, "TOLERANCE", "dimstyle", &dimstyle, NULL)
        && !memcmp (&dimstyle, &tolerance->dimstyle, sizeof (BITCODE_H)))
        pass ();
    else
        fail ("TOLERANCE.dimstyle [H]");
  }
  {
    BITCODE_BE extrusion;
    if (dwg_dynapi_entity_value (tolerance, "TOLERANCE", "extrusion", &extrusion, NULL)
        && !memcmp (&extrusion, &tolerance->extrusion, sizeof (BITCODE_BE)))
        pass ();
    else
        fail ("TOLERANCE.extrusion [BE]");
  }
  {
    BITCODE_BD height;
    if (dwg_dynapi_entity_value (tolerance, "TOLERANCE", "height", &height, NULL)
        && height == tolerance->height)
      pass ();
    else
      fail ("TOLERANCE.height [BD] %g != %g", tolerance->height, height);
    height++;
    if (dwg_dynapi_entity_set_value (tolerance, "TOLERANCE", "height", &height, 0)
        && height == tolerance->height)
      pass ();
    else
      fail ("TOLERANCE.height [BD] set+1 %g != %g", tolerance->height, height);
    tolerance->height--;
  }
  {
    BITCODE_3BD ins_pt;
    if (dwg_dynapi_entity_value (tolerance, "TOLERANCE", "ins_pt", &ins_pt, NULL)
        && !memcmp (&ins_pt, &tolerance->ins_pt, sizeof (BITCODE_3BD)))
        pass ();
    else
        fail ("TOLERANCE.ins_pt [3BD]");
  }
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value (tolerance, "TOLERANCE", "parent", &parent, NULL)
        && !memcmp (&parent, &tolerance->parent, sizeof (struct _dwg_object_entity*)))
        pass ();
    else
        fail ("TOLERANCE.parent [struct _dwg_object_entity*]");
  }
  {
    BITCODE_T text_value;
    if (dwg_dynapi_entity_value (tolerance, "TOLERANCE", "text_value", &text_value, NULL)
        && text_value
           ? strEQ ((char *)text_value, (char *)tolerance->text_value)
           : !tolerance->text_value)
      pass ();
    else
      fail ("TOLERANCE.text_value [T] '%s' <> '%s'", text_value, tolerance->text_value);
  }
  {
    BITCODE_BS unknown_short;
    if (dwg_dynapi_entity_value (tolerance, "TOLERANCE", "unknown_short", &unknown_short, NULL)
        && unknown_short == tolerance->unknown_short)
      pass ();
    else
      fail ("TOLERANCE.unknown_short [BS] %hu != %hu", tolerance->unknown_short, unknown_short);
    unknown_short++;
    if (dwg_dynapi_entity_set_value (tolerance, "TOLERANCE", "unknown_short", &unknown_short, 0)
        && unknown_short == tolerance->unknown_short)
      pass ();
    else
      fail ("TOLERANCE.unknown_short [BS] set+1 %hu != %hu", tolerance->unknown_short, unknown_short);
    tolerance->unknown_short--;
  }
  {
    BITCODE_3BD x_direction;
    if (dwg_dynapi_entity_value (tolerance, "TOLERANCE", "x_direction", &x_direction, NULL)
        && !memcmp (&x_direction, &tolerance->x_direction, sizeof (BITCODE_3BD)))
        pass ();
    else
        fail ("TOLERANCE.x_direction [3BD]");
  }
  if (failed && (is_class_unstable ("TOLERANCE") || is_class_debugging ("TOLERANCE")))
    {
      ok ("%s failed %d tests (TODO unstable)", "TOLERANCE", failed);
      failed = 0;
    }
  return failed;
}
static int test_TRACE (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_TRACE *restrict trace = obj->tio.entity->tio.TRACE;
  failed = 0;
  {
    BITCODE_2RD corner1;
    if (dwg_dynapi_entity_value (trace, "TRACE", "corner1", &corner1, NULL)
        && !memcmp (&corner1, &trace->corner1, sizeof (BITCODE_2RD)))
        pass ();
    else
        fail ("TRACE.corner1 [2RD]");
  }
  {
    BITCODE_2RD corner2;
    if (dwg_dynapi_entity_value (trace, "TRACE", "corner2", &corner2, NULL)
        && !memcmp (&corner2, &trace->corner2, sizeof (BITCODE_2RD)))
        pass ();
    else
        fail ("TRACE.corner2 [2RD]");
  }
  {
    BITCODE_2RD corner3;
    if (dwg_dynapi_entity_value (trace, "TRACE", "corner3", &corner3, NULL)
        && !memcmp (&corner3, &trace->corner3, sizeof (BITCODE_2RD)))
        pass ();
    else
        fail ("TRACE.corner3 [2RD]");
  }
  {
    BITCODE_2RD corner4;
    if (dwg_dynapi_entity_value (trace, "TRACE", "corner4", &corner4, NULL)
        && !memcmp (&corner4, &trace->corner4, sizeof (BITCODE_2RD)))
        pass ();
    else
        fail ("TRACE.corner4 [2RD]");
  }
  {
    BITCODE_BD elevation;
    if (dwg_dynapi_entity_value (trace, "TRACE", "elevation", &elevation, NULL)
        && elevation == trace->elevation)
      pass ();
    else
      fail ("TRACE.elevation [BD] %g != %g", trace->elevation, elevation);
    elevation++;
    if (dwg_dynapi_entity_set_value (trace, "TRACE", "elevation", &elevation, 0)
        && elevation == trace->elevation)
      pass ();
    else
      fail ("TRACE.elevation [BD] set+1 %g != %g", trace->elevation, elevation);
    trace->elevation--;
  }
  {
    BITCODE_BE extrusion;
    if (dwg_dynapi_entity_value (trace, "TRACE", "extrusion", &extrusion, NULL)
        && !memcmp (&extrusion, &trace->extrusion, sizeof (BITCODE_BE)))
        pass ();
    else
        fail ("TRACE.extrusion [BE]");
  }
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value (trace, "TRACE", "parent", &parent, NULL)
        && !memcmp (&parent, &trace->parent, sizeof (struct _dwg_object_entity*)))
        pass ();
    else
        fail ("TRACE.parent [struct _dwg_object_entity*]");
  }
  {
    BITCODE_BT thickness;
    if (dwg_dynapi_entity_value (trace, "TRACE", "thickness", &thickness, NULL)
        && thickness == trace->thickness)
      pass ();
    else
      fail ("TRACE.thickness [BT] " FORMAT_BT " != " FORMAT_BT "", trace->thickness, thickness);
    if (dwg_dynapi_entity_set_value (trace, "TRACE", "thickness", &thickness, 0)
        && thickness == trace->thickness)
      pass ();
    else
      fail ("TRACE.thickness [BT] set+1 " FORMAT_BT " != " FORMAT_BT "", trace->thickness, thickness);
    trace->thickness--;
  }
  if (failed && (is_class_unstable ("TRACE") || is_class_debugging ("TRACE")))
    {
      ok ("%s failed %d tests (TODO unstable)", "TRACE", failed);
      failed = 0;
    }
  return failed;
}
static int test_UNDERLAY (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_UNDERLAY *restrict underlay = obj->tio.entity->tio.UNDERLAY;
  failed = 0;
  {
    BITCODE_BD angle;
    if (dwg_dynapi_entity_value (underlay, "UNDERLAY", "angle", &angle, NULL)
        && angle == underlay->angle)
      pass ();
    else
      fail ("UNDERLAY.angle [BD] %g != %g", underlay->angle, angle);
    angle++;
    if (dwg_dynapi_entity_set_value (underlay, "UNDERLAY", "angle", &angle, 0)
        && angle == underlay->angle)
      pass ();
    else
      fail ("UNDERLAY.angle [BD] set+1 %g != %g", underlay->angle, angle);
    underlay->angle--;
  }
  {
    BITCODE_2RD* clip_inverts;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (underlay, "UNDERLAY", "num_clip_inverts", &count, NULL)
        && dwg_dynapi_entity_value (underlay, "UNDERLAY", "clip_inverts", &clip_inverts, NULL)
        && clip_inverts == underlay->clip_inverts)
      pass ();
    else
      fail ("UNDERLAY.clip_inverts [2RD*] * %u num_clip_inverts", count);
  }
  {
    BITCODE_2RD* clip_verts;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (underlay, "UNDERLAY", "num_clip_verts", &count, NULL)
        && dwg_dynapi_entity_value (underlay, "UNDERLAY", "clip_verts", &clip_verts, NULL)
        && clip_verts == underlay->clip_verts)
      pass ();
    else
      fail ("UNDERLAY.clip_verts [2RD*] * %u num_clip_verts", count);
  }
  {
    BITCODE_RC contrast;
    if (dwg_dynapi_entity_value (underlay, "UNDERLAY", "contrast", &contrast, NULL)
        && contrast == underlay->contrast)
      pass ();
    else
      fail ("UNDERLAY.contrast [RC] %u != %u", underlay->contrast, contrast);
    contrast++;
    if (dwg_dynapi_entity_set_value (underlay, "UNDERLAY", "contrast", &contrast, 0)
        && contrast == underlay->contrast)
      pass ();
    else
      fail ("UNDERLAY.contrast [RC] set+1 %u != %u", underlay->contrast, contrast);
    underlay->contrast--;
  }
  {
    BITCODE_H definition_id;
    if (dwg_dynapi_entity_value (underlay, "UNDERLAY", "definition_id", &definition_id, NULL)
        && !memcmp (&definition_id, &underlay->definition_id, sizeof (BITCODE_H)))
        pass ();
    else
        fail ("UNDERLAY.definition_id [H]");
  }
  {
    BITCODE_BE extrusion;
    if (dwg_dynapi_entity_value (underlay, "UNDERLAY", "extrusion", &extrusion, NULL)
        && !memcmp (&extrusion, &underlay->extrusion, sizeof (BITCODE_BE)))
        pass ();
    else
        fail ("UNDERLAY.extrusion [BE]");
  }
  {
    BITCODE_RC fade;
    if (dwg_dynapi_entity_value (underlay, "UNDERLAY", "fade", &fade, NULL)
        && fade == underlay->fade)
      pass ();
    else
      fail ("UNDERLAY.fade [RC] %u != %u", underlay->fade, fade);
    fade++;
    if (dwg_dynapi_entity_set_value (underlay, "UNDERLAY", "fade", &fade, 0)
        && fade == underlay->fade)
      pass ();
    else
      fail ("UNDERLAY.fade [RC] set+1 %u != %u", underlay->fade, fade);
    underlay->fade--;
  }
  {
    BITCODE_RC flag;
    if (dwg_dynapi_entity_value (underlay, "UNDERLAY", "flag", &flag, NULL)
        && flag == underlay->flag)
      pass ();
    else
      fail ("UNDERLAY.flag [RC] %u != %u", underlay->flag, flag);
    flag++;
    if (dwg_dynapi_entity_set_value (underlay, "UNDERLAY", "flag", &flag, 0)
        && flag == underlay->flag)
      pass ();
    else
      fail ("UNDERLAY.flag [RC] set+1 %u != %u", underlay->flag, flag);
    underlay->flag--;
  }
  {
    BITCODE_3BD ins_pt;
    if (dwg_dynapi_entity_value (underlay, "UNDERLAY", "ins_pt", &ins_pt, NULL)
        && !memcmp (&ins_pt, &underlay->ins_pt, sizeof (BITCODE_3BD)))
        pass ();
    else
        fail ("UNDERLAY.ins_pt [3BD]");
  }
  {
    BITCODE_BL num_clip_inverts;
    if (dwg_dynapi_entity_value (underlay, "UNDERLAY", "num_clip_inverts", &num_clip_inverts, NULL)
        && num_clip_inverts == underlay->num_clip_inverts)
      pass ();
    else
      fail ("UNDERLAY.num_clip_inverts [BL] %u != %u", underlay->num_clip_inverts, num_clip_inverts);
    num_clip_inverts++;
    if (dwg_dynapi_entity_set_value (underlay, "UNDERLAY", "num_clip_inverts", &num_clip_inverts, 0)
        && num_clip_inverts == underlay->num_clip_inverts)
      pass ();
    else
      fail ("UNDERLAY.num_clip_inverts [BL] set+1 %u != %u", underlay->num_clip_inverts, num_clip_inverts);
    underlay->num_clip_inverts--;
  }
  {
    BITCODE_BL num_clip_verts;
    if (dwg_dynapi_entity_value (underlay, "UNDERLAY", "num_clip_verts", &num_clip_verts, NULL)
        && num_clip_verts == underlay->num_clip_verts)
      pass ();
    else
      fail ("UNDERLAY.num_clip_verts [BL] %u != %u", underlay->num_clip_verts, num_clip_verts);
    num_clip_verts++;
    if (dwg_dynapi_entity_set_value (underlay, "UNDERLAY", "num_clip_verts", &num_clip_verts, 0)
        && num_clip_verts == underlay->num_clip_verts)
      pass ();
    else
      fail ("UNDERLAY.num_clip_verts [BL] set+1 %u != %u", underlay->num_clip_verts, num_clip_verts);
    underlay->num_clip_verts--;
  }
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value (underlay, "UNDERLAY", "parent", &parent, NULL)
        && !memcmp (&parent, &underlay->parent, sizeof (struct _dwg_object_entity*)))
        pass ();
    else
        fail ("UNDERLAY.parent [struct _dwg_object_entity*]");
  }
  {
    BITCODE_3BD scale;
    if (dwg_dynapi_entity_value (underlay, "UNDERLAY", "scale", &scale, NULL)
        && !memcmp (&scale, &underlay->scale, sizeof (BITCODE_3BD)))
        pass ();
    else
        fail ("UNDERLAY.scale [3BD_1]");
  }
  if (failed && (is_class_unstable ("UNDERLAY") || is_class_debugging ("UNDERLAY")))
    {
      ok ("%s failed %d tests (TODO unstable)", "UNDERLAY", failed);
      failed = 0;
    }
  return failed;
}
static int test_VERTEX_2D (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_VERTEX_2D *restrict vertex_2d = obj->tio.entity->tio.VERTEX_2D;
  failed = 0;
  {
    BITCODE_BD bulge;
    if (dwg_dynapi_entity_value (vertex_2d, "VERTEX_2D", "bulge", &bulge, NULL)
        && bulge == vertex_2d->bulge)
      pass ();
    else
      fail ("VERTEX_2D.bulge [BD] %g != %g", vertex_2d->bulge, bulge);
    bulge++;
    if (dwg_dynapi_entity_set_value (vertex_2d, "VERTEX_2D", "bulge", &bulge, 0)
        && bulge == vertex_2d->bulge)
      pass ();
    else
      fail ("VERTEX_2D.bulge [BD] set+1 %g != %g", vertex_2d->bulge, bulge);
    vertex_2d->bulge--;
  }
  {
    BITCODE_BD end_width;
    if (dwg_dynapi_entity_value (vertex_2d, "VERTEX_2D", "end_width", &end_width, NULL)
        && end_width == vertex_2d->end_width)
      pass ();
    else
      fail ("VERTEX_2D.end_width [BD] %g != %g", vertex_2d->end_width, end_width);
    end_width++;
    if (dwg_dynapi_entity_set_value (vertex_2d, "VERTEX_2D", "end_width", &end_width, 0)
        && end_width == vertex_2d->end_width)
      pass ();
    else
      fail ("VERTEX_2D.end_width [BD] set+1 %g != %g", vertex_2d->end_width, end_width);
    vertex_2d->end_width--;
  }
  {
    BITCODE_RC flag;
    if (dwg_dynapi_entity_value (vertex_2d, "VERTEX_2D", "flag", &flag, NULL)
        && flag == vertex_2d->flag)
      pass ();
    else
      fail ("VERTEX_2D.flag [RC] %u != %u", vertex_2d->flag, flag);
    flag++;
    if (dwg_dynapi_entity_set_value (vertex_2d, "VERTEX_2D", "flag", &flag, 0)
        && flag == vertex_2d->flag)
      pass ();
    else
      fail ("VERTEX_2D.flag [RC] set+1 %u != %u", vertex_2d->flag, flag);
    vertex_2d->flag--;
  }
  {
    BITCODE_BL id;
    if (dwg_dynapi_entity_value (vertex_2d, "VERTEX_2D", "id", &id, NULL)
        && id == vertex_2d->id)
      pass ();
    else
      fail ("VERTEX_2D.id [BL] %u != %u", vertex_2d->id, id);
    id++;
    if (dwg_dynapi_entity_set_value (vertex_2d, "VERTEX_2D", "id", &id, 0)
        && id == vertex_2d->id)
      pass ();
    else
      fail ("VERTEX_2D.id [BL] set+1 %u != %u", vertex_2d->id, id);
    vertex_2d->id--;
  }
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value (vertex_2d, "VERTEX_2D", "parent", &parent, NULL)
        && !memcmp (&parent, &vertex_2d->parent, sizeof (struct _dwg_object_entity*)))
        pass ();
    else
        fail ("VERTEX_2D.parent [struct _dwg_object_entity*]");
  }
  {
    BITCODE_3BD point;
    if (dwg_dynapi_entity_value (vertex_2d, "VERTEX_2D", "point", &point, NULL)
        && !memcmp (&point, &vertex_2d->point, sizeof (BITCODE_3BD)))
        pass ();
    else
        fail ("VERTEX_2D.point [3BD]");
  }
  {
    BITCODE_BD start_width;
    if (dwg_dynapi_entity_value (vertex_2d, "VERTEX_2D", "start_width", &start_width, NULL)
        && start_width == vertex_2d->start_width)
      pass ();
    else
      fail ("VERTEX_2D.start_width [BD] %g != %g", vertex_2d->start_width, start_width);
    start_width++;
    if (dwg_dynapi_entity_set_value (vertex_2d, "VERTEX_2D", "start_width", &start_width, 0)
        && start_width == vertex_2d->start_width)
      pass ();
    else
      fail ("VERTEX_2D.start_width [BD] set+1 %g != %g", vertex_2d->start_width, start_width);
    vertex_2d->start_width--;
  }
  {
    BITCODE_BD tangent_dir;
    if (dwg_dynapi_entity_value (vertex_2d, "VERTEX_2D", "tangent_dir", &tangent_dir, NULL)
        && tangent_dir == vertex_2d->tangent_dir)
      pass ();
    else
      fail ("VERTEX_2D.tangent_dir [BD] %g != %g", vertex_2d->tangent_dir, tangent_dir);
    tangent_dir++;
    if (dwg_dynapi_entity_set_value (vertex_2d, "VERTEX_2D", "tangent_dir", &tangent_dir, 0)
        && tangent_dir == vertex_2d->tangent_dir)
      pass ();
    else
      fail ("VERTEX_2D.tangent_dir [BD] set+1 %g != %g", vertex_2d->tangent_dir, tangent_dir);
    vertex_2d->tangent_dir--;
  }
  if (failed && (is_class_unstable ("VERTEX_2D") || is_class_debugging ("VERTEX_2D")))
    {
      ok ("%s failed %d tests (TODO unstable)", "VERTEX_2D", failed);
      failed = 0;
    }
  return failed;
}
static int test_VERTEX_3D (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_VERTEX_3D *restrict vertex_3d = obj->tio.entity->tio.VERTEX_3D;
  failed = 0;
  {
    BITCODE_RC flag;
    if (dwg_dynapi_entity_value (vertex_3d, "VERTEX_3D", "flag", &flag, NULL)
        && flag == vertex_3d->flag)
      pass ();
    else
      fail ("VERTEX_3D.flag [RC] %u != %u", vertex_3d->flag, flag);
    flag++;
    if (dwg_dynapi_entity_set_value (vertex_3d, "VERTEX_3D", "flag", &flag, 0)
        && flag == vertex_3d->flag)
      pass ();
    else
      fail ("VERTEX_3D.flag [RC] set+1 %u != %u", vertex_3d->flag, flag);
    vertex_3d->flag--;
  }
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value (vertex_3d, "VERTEX_3D", "parent", &parent, NULL)
        && !memcmp (&parent, &vertex_3d->parent, sizeof (struct _dwg_object_entity*)))
        pass ();
    else
        fail ("VERTEX_3D.parent [struct _dwg_object_entity*]");
  }
  {
    BITCODE_3BD point;
    if (dwg_dynapi_entity_value (vertex_3d, "VERTEX_3D", "point", &point, NULL)
        && !memcmp (&point, &vertex_3d->point, sizeof (BITCODE_3BD)))
        pass ();
    else
        fail ("VERTEX_3D.point [3BD]");
  }
  if (failed && (is_class_unstable ("VERTEX_3D") || is_class_debugging ("VERTEX_3D")))
    {
      ok ("%s failed %d tests (TODO unstable)", "VERTEX_3D", failed);
      failed = 0;
    }
  return failed;
}
static int test_VERTEX_MESH (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_VERTEX_MESH *restrict vertex_mesh = obj->tio.entity->tio.VERTEX_MESH;
  failed = 0;
  if (failed && (is_class_unstable ("VERTEX_MESH") || is_class_debugging ("VERTEX_MESH")))
    {
      ok ("%s failed %d tests (TODO unstable)", "VERTEX_MESH", failed);
      failed = 0;
    }
  return failed;
}
static int test_VERTEX_PFACE (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_VERTEX_PFACE *restrict vertex_pface = obj->tio.entity->tio.VERTEX_PFACE;
  failed = 0;
  if (failed && (is_class_unstable ("VERTEX_PFACE") || is_class_debugging ("VERTEX_PFACE")))
    {
      ok ("%s failed %d tests (TODO unstable)", "VERTEX_PFACE", failed);
      failed = 0;
    }
  return failed;
}
static int test_VERTEX_PFACE_FACE (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_VERTEX_PFACE_FACE *restrict vertex_pface_face = obj->tio.entity->tio.VERTEX_PFACE_FACE;
  failed = 0;
  {
    BITCODE_RC flag;
    if (dwg_dynapi_entity_value (vertex_pface_face, "VERTEX_PFACE_FACE", "flag", &flag, NULL)
        && flag == vertex_pface_face->flag)
      pass ();
    else
      fail ("VERTEX_PFACE_FACE.flag [RC] %u != %u", vertex_pface_face->flag, flag);
    flag++;
    if (dwg_dynapi_entity_set_value (vertex_pface_face, "VERTEX_PFACE_FACE", "flag", &flag, 0)
        && flag == vertex_pface_face->flag)
      pass ();
    else
      fail ("VERTEX_PFACE_FACE.flag [RC] set+1 %u != %u", vertex_pface_face->flag, flag);
    vertex_pface_face->flag--;
  }
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value (vertex_pface_face, "VERTEX_PFACE_FACE", "parent", &parent, NULL)
        && !memcmp (&parent, &vertex_pface_face->parent, sizeof (struct _dwg_object_entity*)))
        pass ();
    else
        fail ("VERTEX_PFACE_FACE.parent [struct _dwg_object_entity*]");
  }
  {
    BITCODE_BS vertind[4];
    if (dwg_dynapi_entity_value (vertex_pface_face, "VERTEX_PFACE_FACE", "vertind[4]", &vertind, NULL)
        && !memcmp (&vertind, &vertex_pface_face->vertind, sizeof (BITCODE_BS)))
        pass ();
    else
        fail ("VERTEX_PFACE_FACE.vertind[4] [BS]");
  }
  if (failed && (is_class_unstable ("VERTEX_PFACE_FACE") || is_class_debugging ("VERTEX_PFACE_FACE")))
    {
      ok ("%s failed %d tests (TODO unstable)", "VERTEX_PFACE_FACE", failed);
      failed = 0;
    }
  return failed;
}
static int test_VIEWPORT (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_VIEWPORT *restrict viewport = obj->tio.entity->tio.VIEWPORT;
  failed = 0;
  {
    BITCODE_2RD GRIDUNIT;
    if (dwg_dynapi_entity_value (viewport, "VIEWPORT", "GRIDUNIT", &GRIDUNIT, NULL)
        && !memcmp (&GRIDUNIT, &viewport->GRIDUNIT, sizeof (BITCODE_2RD)))
        pass ();
    else
        fail ("VIEWPORT.GRIDUNIT [2RD]");
  }
  {
    BITCODE_BD SNAPANG;
    if (dwg_dynapi_entity_value (viewport, "VIEWPORT", "SNAPANG", &SNAPANG, NULL)
        && SNAPANG == viewport->SNAPANG)
      pass ();
    else
      fail ("VIEWPORT.SNAPANG [BD] %g != %g", viewport->SNAPANG, SNAPANG);
    SNAPANG++;
    if (dwg_dynapi_entity_set_value (viewport, "VIEWPORT", "SNAPANG", &SNAPANG, 0)
        && SNAPANG == viewport->SNAPANG)
      pass ();
    else
      fail ("VIEWPORT.SNAPANG [BD] set+1 %g != %g", viewport->SNAPANG, SNAPANG);
    viewport->SNAPANG--;
  }
  {
    BITCODE_2RD SNAPBASE;
    if (dwg_dynapi_entity_value (viewport, "VIEWPORT", "SNAPBASE", &SNAPBASE, NULL)
        && !memcmp (&SNAPBASE, &viewport->SNAPBASE, sizeof (BITCODE_2RD)))
        pass ();
    else
        fail ("VIEWPORT.SNAPBASE [2RD]");
  }
  {
    BITCODE_2RD SNAPUNIT;
    if (dwg_dynapi_entity_value (viewport, "VIEWPORT", "SNAPUNIT", &SNAPUNIT, NULL)
        && !memcmp (&SNAPUNIT, &viewport->SNAPUNIT, sizeof (BITCODE_2RD)))
        pass ();
    else
        fail ("VIEWPORT.SNAPUNIT [2RD]");
  }
  {
    BITCODE_BS UCSORTHOVIEW;
    if (dwg_dynapi_entity_value (viewport, "VIEWPORT", "UCSORTHOVIEW", &UCSORTHOVIEW, NULL)
        && UCSORTHOVIEW == viewport->UCSORTHOVIEW)
      pass ();
    else
      fail ("VIEWPORT.UCSORTHOVIEW [BS] %hu != %hu", viewport->UCSORTHOVIEW, UCSORTHOVIEW);
    UCSORTHOVIEW++;
    if (dwg_dynapi_entity_set_value (viewport, "VIEWPORT", "UCSORTHOVIEW", &UCSORTHOVIEW, 0)
        && UCSORTHOVIEW == viewport->UCSORTHOVIEW)
      pass ();
    else
      fail ("VIEWPORT.UCSORTHOVIEW [BS] set+1 %hu != %hu", viewport->UCSORTHOVIEW, UCSORTHOVIEW);
    viewport->UCSORTHOVIEW--;
  }
  {
    BITCODE_B UCSVP;
    if (dwg_dynapi_entity_value (viewport, "VIEWPORT", "UCSVP", &UCSVP, NULL)
        && UCSVP == viewport->UCSVP)
      pass ();
    else
      fail ("VIEWPORT.UCSVP [B] " FORMAT_B " != " FORMAT_B "", viewport->UCSVP, UCSVP);
    UCSVP++;
    if (dwg_dynapi_entity_set_value (viewport, "VIEWPORT", "UCSVP", &UCSVP, 0)
        && UCSVP == viewport->UCSVP)
      pass ();
    else
      fail ("VIEWPORT.UCSVP [B] set+1 " FORMAT_B " != " FORMAT_B "", viewport->UCSVP, UCSVP);
    viewport->UCSVP--;
  }
  {
    BITCODE_2RD VIEWCTR;
    if (dwg_dynapi_entity_value (viewport, "VIEWPORT", "VIEWCTR", &VIEWCTR, NULL)
        && !memcmp (&VIEWCTR, &viewport->VIEWCTR, sizeof (BITCODE_2RD)))
        pass ();
    else
        fail ("VIEWPORT.VIEWCTR [2RD]");
  }
  {
    BITCODE_3BD VIEWDIR;
    if (dwg_dynapi_entity_value (viewport, "VIEWPORT", "VIEWDIR", &VIEWDIR, NULL)
        && !memcmp (&VIEWDIR, &viewport->VIEWDIR, sizeof (BITCODE_3BD)))
        pass ();
    else
        fail ("VIEWPORT.VIEWDIR [3BD]");
  }
  {
    BITCODE_BD VIEWSIZE;
    if (dwg_dynapi_entity_value (viewport, "VIEWPORT", "VIEWSIZE", &VIEWSIZE, NULL)
        && VIEWSIZE == viewport->VIEWSIZE)
      pass ();
    else
      fail ("VIEWPORT.VIEWSIZE [BD] %g != %g", viewport->VIEWSIZE, VIEWSIZE);
    VIEWSIZE++;
    if (dwg_dynapi_entity_set_value (viewport, "VIEWPORT", "VIEWSIZE", &VIEWSIZE, 0)
        && VIEWSIZE == viewport->VIEWSIZE)
      pass ();
    else
      fail ("VIEWPORT.VIEWSIZE [BD] set+1 %g != %g", viewport->VIEWSIZE, VIEWSIZE);
    viewport->VIEWSIZE--;
  }
  {
    BITCODE_CMC ambient_color;
    if (dwg_dynapi_entity_value (viewport, "VIEWPORT", "ambient_color", &ambient_color, NULL)
        && !memcmp (&ambient_color, &viewport->ambient_color, sizeof (BITCODE_CMC)))
        pass ();
    else
        fail ("VIEWPORT.ambient_color [CMC]");
  }
  {
    BITCODE_BD back_clip_z;
    if (dwg_dynapi_entity_value (viewport, "VIEWPORT", "back_clip_z", &back_clip_z, NULL)
        && back_clip_z == viewport->back_clip_z)
      pass ();
    else
      fail ("VIEWPORT.back_clip_z [BD] %g != %g", viewport->back_clip_z, back_clip_z);
    back_clip_z++;
    if (dwg_dynapi_entity_set_value (viewport, "VIEWPORT", "back_clip_z", &back_clip_z, 0)
        && back_clip_z == viewport->back_clip_z)
      pass ();
    else
      fail ("VIEWPORT.back_clip_z [BD] set+1 %g != %g", viewport->back_clip_z, back_clip_z);
    viewport->back_clip_z--;
  }
  {
    BITCODE_H background;
    if (dwg_dynapi_entity_value (viewport, "VIEWPORT", "background", &background, NULL)
        && !memcmp (&background, &viewport->background, sizeof (BITCODE_H)))
        pass ();
    else
        fail ("VIEWPORT.background [H]");
  }
  {
    BITCODE_H base_ucs;
    if (dwg_dynapi_entity_value (viewport, "VIEWPORT", "base_ucs", &base_ucs, NULL)
        && !memcmp (&base_ucs, &viewport->base_ucs, sizeof (BITCODE_H)))
        pass ();
    else
        fail ("VIEWPORT.base_ucs [H]");
  }
  {
    BITCODE_BD brightness;
    if (dwg_dynapi_entity_value (viewport, "VIEWPORT", "brightness", &brightness, NULL)
        && brightness == viewport->brightness)
      pass ();
    else
      fail ("VIEWPORT.brightness [BD] %g != %g", viewport->brightness, brightness);
    brightness++;
    if (dwg_dynapi_entity_set_value (viewport, "VIEWPORT", "brightness", &brightness, 0)
        && brightness == viewport->brightness)
      pass ();
    else
      fail ("VIEWPORT.brightness [BD] set+1 %g != %g", viewport->brightness, brightness);
    viewport->brightness--;
  }
  {
    BITCODE_3BD center;
    if (dwg_dynapi_entity_value (viewport, "VIEWPORT", "center", &center, NULL)
        && !memcmp (&center, &viewport->center, sizeof (BITCODE_3BD)))
        pass ();
    else
        fail ("VIEWPORT.center [3BD]");
  }
  {
    BITCODE_BS circle_zoom;
    if (dwg_dynapi_entity_value (viewport, "VIEWPORT", "circle_zoom", &circle_zoom, NULL)
        && circle_zoom == viewport->circle_zoom)
      pass ();
    else
      fail ("VIEWPORT.circle_zoom [BS] %hu != %hu", viewport->circle_zoom, circle_zoom);
    circle_zoom++;
    if (dwg_dynapi_entity_set_value (viewport, "VIEWPORT", "circle_zoom", &circle_zoom, 0)
        && circle_zoom == viewport->circle_zoom)
      pass ();
    else
      fail ("VIEWPORT.circle_zoom [BS] set+1 %hu != %hu", viewport->circle_zoom, circle_zoom);
    viewport->circle_zoom--;
  }
  {
    BITCODE_H clip_boundary;
    if (dwg_dynapi_entity_value (viewport, "VIEWPORT", "clip_boundary", &clip_boundary, NULL)
        && !memcmp (&clip_boundary, &viewport->clip_boundary, sizeof (BITCODE_H)))
        pass ();
    else
        fail ("VIEWPORT.clip_boundary [H]");
  }
  {
    BITCODE_BD contrast;
    if (dwg_dynapi_entity_value (viewport, "VIEWPORT", "contrast", &contrast, NULL)
        && contrast == viewport->contrast)
      pass ();
    else
      fail ("VIEWPORT.contrast [BD] %g != %g", viewport->contrast, contrast);
    contrast++;
    if (dwg_dynapi_entity_set_value (viewport, "VIEWPORT", "contrast", &contrast, 0)
        && contrast == viewport->contrast)
      pass ();
    else
      fail ("VIEWPORT.contrast [BD] set+1 %g != %g", viewport->contrast, contrast);
    viewport->contrast--;
  }
  {
    BITCODE_RC default_lighting_type;
    if (dwg_dynapi_entity_value (viewport, "VIEWPORT", "default_lighting_type", &default_lighting_type, NULL)
        && default_lighting_type == viewport->default_lighting_type)
      pass ();
    else
      fail ("VIEWPORT.default_lighting_type [RC] %u != %u", viewport->default_lighting_type, default_lighting_type);
    default_lighting_type++;
    if (dwg_dynapi_entity_set_value (viewport, "VIEWPORT", "default_lighting_type", &default_lighting_type, 0)
        && default_lighting_type == viewport->default_lighting_type)
      pass ();
    else
      fail ("VIEWPORT.default_lighting_type [RC] set+1 %u != %u", viewport->default_lighting_type, default_lighting_type);
    viewport->default_lighting_type--;
  }
  {
    BITCODE_BD front_clip_z;
    if (dwg_dynapi_entity_value (viewport, "VIEWPORT", "front_clip_z", &front_clip_z, NULL)
        && front_clip_z == viewport->front_clip_z)
      pass ();
    else
      fail ("VIEWPORT.front_clip_z [BD] %g != %g", viewport->front_clip_z, front_clip_z);
    front_clip_z++;
    if (dwg_dynapi_entity_set_value (viewport, "VIEWPORT", "front_clip_z", &front_clip_z, 0)
        && front_clip_z == viewport->front_clip_z)
      pass ();
    else
      fail ("VIEWPORT.front_clip_z [BD] set+1 %g != %g", viewport->front_clip_z, front_clip_z);
    viewport->front_clip_z--;
  }
  {
    BITCODE_H* frozen_layers;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (viewport, "VIEWPORT", "num_frozen_layers", &count, NULL)
        && dwg_dynapi_entity_value (viewport, "VIEWPORT", "frozen_layers", &frozen_layers, NULL)
        && frozen_layers == viewport->frozen_layers)
      pass ();
    else
      fail ("VIEWPORT.frozen_layers [H*] * %u num_frozen_layers", count);
  }
  {
    BITCODE_BS grid_major;
    if (dwg_dynapi_entity_value (viewport, "VIEWPORT", "grid_major", &grid_major, NULL)
        && grid_major == viewport->grid_major)
      pass ();
    else
      fail ("VIEWPORT.grid_major [BS] %hu != %hu", viewport->grid_major, grid_major);
    grid_major++;
    if (dwg_dynapi_entity_set_value (viewport, "VIEWPORT", "grid_major", &grid_major, 0)
        && grid_major == viewport->grid_major)
      pass ();
    else
      fail ("VIEWPORT.grid_major [BS] set+1 %hu != %hu", viewport->grid_major, grid_major);
    viewport->grid_major--;
  }
  {
    BITCODE_BD height;
    if (dwg_dynapi_entity_value (viewport, "VIEWPORT", "height", &height, NULL)
        && height == viewport->height)
      pass ();
    else
      fail ("VIEWPORT.height [BD] %g != %g", viewport->height, height);
    height++;
    if (dwg_dynapi_entity_set_value (viewport, "VIEWPORT", "height", &height, 0)
        && height == viewport->height)
      pass ();
    else
      fail ("VIEWPORT.height [BD] set+1 %g != %g", viewport->height, height);
    viewport->height--;
  }
  {
    BITCODE_RS id;
    if (dwg_dynapi_entity_value (viewport, "VIEWPORT", "id", &id, NULL)
        && id == viewport->id)
      pass ();
    else
      fail ("VIEWPORT.id [RS] %hu != %hu", viewport->id, id);
    id++;
    if (dwg_dynapi_entity_set_value (viewport, "VIEWPORT", "id", &id, 0)
        && id == viewport->id)
      pass ();
    else
      fail ("VIEWPORT.id [RS] set+1 %hu != %hu", viewport->id, id);
    viewport->id--;
  }
  {
    BITCODE_BD lens_length;
    if (dwg_dynapi_entity_value (viewport, "VIEWPORT", "lens_length", &lens_length, NULL)
        && lens_length == viewport->lens_length)
      pass ();
    else
      fail ("VIEWPORT.lens_length [BD] %g != %g", viewport->lens_length, lens_length);
    lens_length++;
    if (dwg_dynapi_entity_set_value (viewport, "VIEWPORT", "lens_length", &lens_length, 0)
        && lens_length == viewport->lens_length)
      pass ();
    else
      fail ("VIEWPORT.lens_length [BD] set+1 %g != %g", viewport->lens_length, lens_length);
    viewport->lens_length--;
  }
  {
    BITCODE_H named_ucs;
    if (dwg_dynapi_entity_value (viewport, "VIEWPORT", "named_ucs", &named_ucs, NULL)
        && !memcmp (&named_ucs, &viewport->named_ucs, sizeof (BITCODE_H)))
        pass ();
    else
        fail ("VIEWPORT.named_ucs [H]");
  }
  {
    BITCODE_BL num_frozen_layers;
    if (dwg_dynapi_entity_value (viewport, "VIEWPORT", "num_frozen_layers", &num_frozen_layers, NULL)
        && num_frozen_layers == viewport->num_frozen_layers)
      pass ();
    else
      fail ("VIEWPORT.num_frozen_layers [BL] %u != %u", viewport->num_frozen_layers, num_frozen_layers);
    num_frozen_layers++;
    if (dwg_dynapi_entity_set_value (viewport, "VIEWPORT", "num_frozen_layers", &num_frozen_layers, 0)
        && num_frozen_layers == viewport->num_frozen_layers)
      pass ();
    else
      fail ("VIEWPORT.num_frozen_layers [BL] set+1 %u != %u", viewport->num_frozen_layers, num_frozen_layers);
    viewport->num_frozen_layers--;
  }
  {
    BITCODE_RS on_off;
    if (dwg_dynapi_entity_value (viewport, "VIEWPORT", "on_off", &on_off, NULL)
        && on_off == viewport->on_off)
      pass ();
    else
      fail ("VIEWPORT.on_off [RS] %hu != %hu", viewport->on_off, on_off);
    on_off++;
    if (dwg_dynapi_entity_set_value (viewport, "VIEWPORT", "on_off", &on_off, 0)
        && on_off == viewport->on_off)
      pass ();
    else
      fail ("VIEWPORT.on_off [RS] set+1 %hu != %hu", viewport->on_off, on_off);
    viewport->on_off--;
  }
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value (viewport, "VIEWPORT", "parent", &parent, NULL)
        && !memcmp (&parent, &viewport->parent, sizeof (struct _dwg_object_entity*)))
        pass ();
    else
        fail ("VIEWPORT.parent [struct _dwg_object_entity*]");
  }
  {
    BITCODE_RC render_mode;
    if (dwg_dynapi_entity_value (viewport, "VIEWPORT", "render_mode", &render_mode, NULL)
        && render_mode == viewport->render_mode)
      pass ();
    else
      fail ("VIEWPORT.render_mode [RC] %u != %u", viewport->render_mode, render_mode);
    render_mode++;
    if (dwg_dynapi_entity_set_value (viewport, "VIEWPORT", "render_mode", &render_mode, 0)
        && render_mode == viewport->render_mode)
      pass ();
    else
      fail ("VIEWPORT.render_mode [RC] set+1 %u != %u", viewport->render_mode, render_mode);
    viewport->render_mode--;
  }
  {
    BITCODE_H shadeplot;
    if (dwg_dynapi_entity_value (viewport, "VIEWPORT", "shadeplot", &shadeplot, NULL)
        && !memcmp (&shadeplot, &viewport->shadeplot, sizeof (BITCODE_H)))
        pass ();
    else
        fail ("VIEWPORT.shadeplot [H]");
  }
  {
    BITCODE_BS shadeplot_mode;
    if (dwg_dynapi_entity_value (viewport, "VIEWPORT", "shadeplot_mode", &shadeplot_mode, NULL)
        && shadeplot_mode == viewport->shadeplot_mode)
      pass ();
    else
      fail ("VIEWPORT.shadeplot_mode [BS] %hu != %hu", viewport->shadeplot_mode, shadeplot_mode);
    shadeplot_mode++;
    if (dwg_dynapi_entity_set_value (viewport, "VIEWPORT", "shadeplot_mode", &shadeplot_mode, 0)
        && shadeplot_mode == viewport->shadeplot_mode)
      pass ();
    else
      fail ("VIEWPORT.shadeplot_mode [BS] set+1 %hu != %hu", viewport->shadeplot_mode, shadeplot_mode);
    viewport->shadeplot_mode--;
  }
  {
    BITCODE_BL status_flag;
    if (dwg_dynapi_entity_value (viewport, "VIEWPORT", "status_flag", &status_flag, NULL)
        && status_flag == viewport->status_flag)
      pass ();
    else
      fail ("VIEWPORT.status_flag [BL] %u != %u", viewport->status_flag, status_flag);
    status_flag++;
    if (dwg_dynapi_entity_set_value (viewport, "VIEWPORT", "status_flag", &status_flag, 0)
        && status_flag == viewport->status_flag)
      pass ();
    else
      fail ("VIEWPORT.status_flag [BL] set+1 %u != %u", viewport->status_flag, status_flag);
    viewport->status_flag--;
  }
  {
    BITCODE_T style_sheet;
    if (dwg_dynapi_entity_value (viewport, "VIEWPORT", "style_sheet", &style_sheet, NULL)
        && style_sheet
           ? strEQ ((char *)style_sheet, (char *)viewport->style_sheet)
           : !viewport->style_sheet)
      pass ();
    else
      fail ("VIEWPORT.style_sheet [T] '%s' <> '%s'", style_sheet, viewport->style_sheet);
  }
  {
    BITCODE_H sun;
    if (dwg_dynapi_entity_value (viewport, "VIEWPORT", "sun", &sun, NULL)
        && !memcmp (&sun, &viewport->sun, sizeof (BITCODE_H)))
        pass ();
    else
        fail ("VIEWPORT.sun [H]");
  }
  {
    BITCODE_BD twist_angle;
    if (dwg_dynapi_entity_value (viewport, "VIEWPORT", "twist_angle", &twist_angle, NULL)
        && twist_angle == viewport->twist_angle)
      pass ();
    else
      fail ("VIEWPORT.twist_angle [BD] %g != %g", viewport->twist_angle, twist_angle);
    twist_angle++;
    if (dwg_dynapi_entity_set_value (viewport, "VIEWPORT", "twist_angle", &twist_angle, 0)
        && twist_angle == viewport->twist_angle)
      pass ();
    else
      fail ("VIEWPORT.twist_angle [BD] set+1 %g != %g", viewport->twist_angle, twist_angle);
    viewport->twist_angle--;
  }
  {
    BITCODE_B ucs_at_origin;
    if (dwg_dynapi_entity_value (viewport, "VIEWPORT", "ucs_at_origin", &ucs_at_origin, NULL)
        && ucs_at_origin == viewport->ucs_at_origin)
      pass ();
    else
      fail ("VIEWPORT.ucs_at_origin [B] " FORMAT_B " != " FORMAT_B "", viewport->ucs_at_origin, ucs_at_origin);
    ucs_at_origin++;
    if (dwg_dynapi_entity_set_value (viewport, "VIEWPORT", "ucs_at_origin", &ucs_at_origin, 0)
        && ucs_at_origin == viewport->ucs_at_origin)
      pass ();
    else
      fail ("VIEWPORT.ucs_at_origin [B] set+1 " FORMAT_B " != " FORMAT_B "", viewport->ucs_at_origin, ucs_at_origin);
    viewport->ucs_at_origin--;
  }
  {
    BITCODE_BD ucs_elevation;
    if (dwg_dynapi_entity_value (viewport, "VIEWPORT", "ucs_elevation", &ucs_elevation, NULL)
        && ucs_elevation == viewport->ucs_elevation)
      pass ();
    else
      fail ("VIEWPORT.ucs_elevation [BD] %g != %g", viewport->ucs_elevation, ucs_elevation);
    ucs_elevation++;
    if (dwg_dynapi_entity_set_value (viewport, "VIEWPORT", "ucs_elevation", &ucs_elevation, 0)
        && ucs_elevation == viewport->ucs_elevation)
      pass ();
    else
      fail ("VIEWPORT.ucs_elevation [BD] set+1 %g != %g", viewport->ucs_elevation, ucs_elevation);
    viewport->ucs_elevation--;
  }
  {
    BITCODE_3BD ucsorg;
    if (dwg_dynapi_entity_value (viewport, "VIEWPORT", "ucsorg", &ucsorg, NULL)
        && !memcmp (&ucsorg, &viewport->ucsorg, sizeof (BITCODE_3BD)))
        pass ();
    else
        fail ("VIEWPORT.ucsorg [3BD]");
  }
  {
    BITCODE_3BD ucsxdir;
    if (dwg_dynapi_entity_value (viewport, "VIEWPORT", "ucsxdir", &ucsxdir, NULL)
        && !memcmp (&ucsxdir, &viewport->ucsxdir, sizeof (BITCODE_3BD)))
        pass ();
    else
        fail ("VIEWPORT.ucsxdir [3BD]");
  }
  {
    BITCODE_3BD ucsydir;
    if (dwg_dynapi_entity_value (viewport, "VIEWPORT", "ucsydir", &ucsydir, NULL)
        && !memcmp (&ucsydir, &viewport->ucsydir, sizeof (BITCODE_3BD)))
        pass ();
    else
        fail ("VIEWPORT.ucsydir [3BD]");
  }
  {
    BITCODE_B use_default_lights;
    if (dwg_dynapi_entity_value (viewport, "VIEWPORT", "use_default_lights", &use_default_lights, NULL)
        && use_default_lights == viewport->use_default_lights)
      pass ();
    else
      fail ("VIEWPORT.use_default_lights [B] " FORMAT_B " != " FORMAT_B "", viewport->use_default_lights, use_default_lights);
    use_default_lights++;
    if (dwg_dynapi_entity_set_value (viewport, "VIEWPORT", "use_default_lights", &use_default_lights, 0)
        && use_default_lights == viewport->use_default_lights)
      pass ();
    else
      fail ("VIEWPORT.use_default_lights [B] set+1 " FORMAT_B " != " FORMAT_B "", viewport->use_default_lights, use_default_lights);
    viewport->use_default_lights--;
  }
  {
    BITCODE_3BD view_target;
    if (dwg_dynapi_entity_value (viewport, "VIEWPORT", "view_target", &view_target, NULL)
        && !memcmp (&view_target, &viewport->view_target, sizeof (BITCODE_3BD)))
        pass ();
    else
        fail ("VIEWPORT.view_target [3BD]");
  }
  {
    BITCODE_H visualstyle;
    if (dwg_dynapi_entity_value (viewport, "VIEWPORT", "visualstyle", &visualstyle, NULL)
        && !memcmp (&visualstyle, &viewport->visualstyle, sizeof (BITCODE_H)))
        pass ();
    else
        fail ("VIEWPORT.visualstyle [H]");
  }
  {
    BITCODE_H vport_entity_header;
    if (dwg_dynapi_entity_value (viewport, "VIEWPORT", "vport_entity_header", &vport_entity_header, NULL)
        && !memcmp (&vport_entity_header, &viewport->vport_entity_header, sizeof (BITCODE_H)))
        pass ();
    else
        fail ("VIEWPORT.vport_entity_header [H]");
  }
  {
    BITCODE_BD width;
    if (dwg_dynapi_entity_value (viewport, "VIEWPORT", "width", &width, NULL)
        && width == viewport->width)
      pass ();
    else
      fail ("VIEWPORT.width [BD] %g != %g", viewport->width, width);
    width++;
    if (dwg_dynapi_entity_set_value (viewport, "VIEWPORT", "width", &width, 0)
        && width == viewport->width)
      pass ();
    else
      fail ("VIEWPORT.width [BD] set+1 %g != %g", viewport->width, width);
    viewport->width--;
  }
  if (failed && (is_class_unstable ("VIEWPORT") || is_class_debugging ("VIEWPORT")))
    {
      ok ("%s failed %d tests (TODO unstable)", "VIEWPORT", failed);
      failed = 0;
    }
  return failed;
}
static int test_VISIBILITYGRIPENTITY (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_VISIBILITYGRIPENTITY *restrict visibilitygripentity = obj->tio.entity->tio.VISIBILITYGRIPENTITY;
  failed = 0;
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value (visibilitygripentity, "VISIBILITYGRIPENTITY", "parent", &parent, NULL)
        && !memcmp (&parent, &visibilitygripentity->parent, sizeof (struct _dwg_object_entity*)))
        pass ();
    else
        fail ("VISIBILITYGRIPENTITY.parent [struct _dwg_object_entity*]");
  }
  if (failed && (is_class_unstable ("VISIBILITYGRIPENTITY") || is_class_debugging ("VISIBILITYGRIPENTITY")))
    {
      ok ("%s failed %d tests (TODO unstable)", "VISIBILITYGRIPENTITY", failed);
      failed = 0;
    }
  return failed;
}
static int test_VISIBILITYPARAMETERENTITY (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_VISIBILITYPARAMETERENTITY *restrict visibilityparameterentity = obj->tio.entity->tio.VISIBILITYPARAMETERENTITY;
  failed = 0;
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value (visibilityparameterentity, "VISIBILITYPARAMETERENTITY", "parent", &parent, NULL)
        && !memcmp (&parent, &visibilityparameterentity->parent, sizeof (struct _dwg_object_entity*)))
        pass ();
    else
        fail ("VISIBILITYPARAMETERENTITY.parent [struct _dwg_object_entity*]");
  }
  if (failed && (is_class_unstable ("VISIBILITYPARAMETERENTITY") || is_class_debugging ("VISIBILITYPARAMETERENTITY")))
    {
      ok ("%s failed %d tests (TODO unstable)", "VISIBILITYPARAMETERENTITY", failed);
      failed = 0;
    }
  return failed;
}
static int test_WIPEOUT (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_WIPEOUT *restrict wipeout = obj->tio.entity->tio.WIPEOUT;
  failed = 0;
  {
    BITCODE_RC brightness;
    if (dwg_dynapi_entity_value (wipeout, "WIPEOUT", "brightness", &brightness, NULL)
        && brightness == wipeout->brightness)
      pass ();
    else
      fail ("WIPEOUT.brightness [RC] %u != %u", wipeout->brightness, brightness);
    brightness++;
    if (dwg_dynapi_entity_set_value (wipeout, "WIPEOUT", "brightness", &brightness, 0)
        && brightness == wipeout->brightness)
      pass ();
    else
      fail ("WIPEOUT.brightness [RC] set+1 %u != %u", wipeout->brightness, brightness);
    wipeout->brightness--;
  }
  {
    BITCODE_BL class_version;
    if (dwg_dynapi_entity_value (wipeout, "WIPEOUT", "class_version", &class_version, NULL)
        && class_version == wipeout->class_version)
      pass ();
    else
      fail ("WIPEOUT.class_version [BL] %u != %u", wipeout->class_version, class_version);
    class_version++;
    if (dwg_dynapi_entity_set_value (wipeout, "WIPEOUT", "class_version", &class_version, 0)
        && class_version == wipeout->class_version)
      pass ();
    else
      fail ("WIPEOUT.class_version [BL] set+1 %u != %u", wipeout->class_version, class_version);
    wipeout->class_version--;
  }
  {
    BITCODE_BS clip_boundary_type;
    if (dwg_dynapi_entity_value (wipeout, "WIPEOUT", "clip_boundary_type", &clip_boundary_type, NULL)
        && clip_boundary_type == wipeout->clip_boundary_type)
      pass ();
    else
      fail ("WIPEOUT.clip_boundary_type [BS] %hu != %hu", wipeout->clip_boundary_type, clip_boundary_type);
    clip_boundary_type++;
    if (dwg_dynapi_entity_set_value (wipeout, "WIPEOUT", "clip_boundary_type", &clip_boundary_type, 0)
        && clip_boundary_type == wipeout->clip_boundary_type)
      pass ();
    else
      fail ("WIPEOUT.clip_boundary_type [BS] set+1 %hu != %hu", wipeout->clip_boundary_type, clip_boundary_type);
    wipeout->clip_boundary_type--;
  }
  {
    BITCODE_B clip_mode;
    if (dwg_dynapi_entity_value (wipeout, "WIPEOUT", "clip_mode", &clip_mode, NULL)
        && clip_mode == wipeout->clip_mode)
      pass ();
    else
      fail ("WIPEOUT.clip_mode [B] " FORMAT_B " != " FORMAT_B "", wipeout->clip_mode, clip_mode);
    clip_mode++;
    if (dwg_dynapi_entity_set_value (wipeout, "WIPEOUT", "clip_mode", &clip_mode, 0)
        && clip_mode == wipeout->clip_mode)
      pass ();
    else
      fail ("WIPEOUT.clip_mode [B] set+1 " FORMAT_B " != " FORMAT_B "", wipeout->clip_mode, clip_mode);
    wipeout->clip_mode--;
  }
  {
    BITCODE_2RD* clip_verts;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (wipeout, "WIPEOUT", "num_clip_verts", &count, NULL)
        && dwg_dynapi_entity_value (wipeout, "WIPEOUT", "clip_verts", &clip_verts, NULL)
        && clip_verts == wipeout->clip_verts)
      pass ();
    else
      fail ("WIPEOUT.clip_verts [2RD*] * %u num_clip_verts", count);
  }
  {
    BITCODE_B clipping;
    if (dwg_dynapi_entity_value (wipeout, "WIPEOUT", "clipping", &clipping, NULL)
        && clipping == wipeout->clipping)
      pass ();
    else
      fail ("WIPEOUT.clipping [B] " FORMAT_B " != " FORMAT_B "", wipeout->clipping, clipping);
    clipping++;
    if (dwg_dynapi_entity_set_value (wipeout, "WIPEOUT", "clipping", &clipping, 0)
        && clipping == wipeout->clipping)
      pass ();
    else
      fail ("WIPEOUT.clipping [B] set+1 " FORMAT_B " != " FORMAT_B "", wipeout->clipping, clipping);
    wipeout->clipping--;
  }
  {
    BITCODE_RC contrast;
    if (dwg_dynapi_entity_value (wipeout, "WIPEOUT", "contrast", &contrast, NULL)
        && contrast == wipeout->contrast)
      pass ();
    else
      fail ("WIPEOUT.contrast [RC] %u != %u", wipeout->contrast, contrast);
    contrast++;
    if (dwg_dynapi_entity_set_value (wipeout, "WIPEOUT", "contrast", &contrast, 0)
        && contrast == wipeout->contrast)
      pass ();
    else
      fail ("WIPEOUT.contrast [RC] set+1 %u != %u", wipeout->contrast, contrast);
    wipeout->contrast--;
  }
  {
    BITCODE_BS display_props;
    if (dwg_dynapi_entity_value (wipeout, "WIPEOUT", "display_props", &display_props, NULL)
        && display_props == wipeout->display_props)
      pass ();
    else
      fail ("WIPEOUT.display_props [BS] %hu != %hu", wipeout->display_props, display_props);
    display_props++;
    if (dwg_dynapi_entity_set_value (wipeout, "WIPEOUT", "display_props", &display_props, 0)
        && display_props == wipeout->display_props)
      pass ();
    else
      fail ("WIPEOUT.display_props [BS] set+1 %hu != %hu", wipeout->display_props, display_props);
    wipeout->display_props--;
  }
  {
    BITCODE_RC fade;
    if (dwg_dynapi_entity_value (wipeout, "WIPEOUT", "fade", &fade, NULL)
        && fade == wipeout->fade)
      pass ();
    else
      fail ("WIPEOUT.fade [RC] %u != %u", wipeout->fade, fade);
    fade++;
    if (dwg_dynapi_entity_set_value (wipeout, "WIPEOUT", "fade", &fade, 0)
        && fade == wipeout->fade)
      pass ();
    else
      fail ("WIPEOUT.fade [RC] set+1 %u != %u", wipeout->fade, fade);
    wipeout->fade--;
  }
  {
    BITCODE_H imagedef;
    if (dwg_dynapi_entity_value (wipeout, "WIPEOUT", "imagedef", &imagedef, NULL)
        && !memcmp (&imagedef, &wipeout->imagedef, sizeof (BITCODE_H)))
        pass ();
    else
        fail ("WIPEOUT.imagedef [H]");
  }
  {
    BITCODE_H imagedefreactor;
    if (dwg_dynapi_entity_value (wipeout, "WIPEOUT", "imagedefreactor", &imagedefreactor, NULL)
        && !memcmp (&imagedefreactor, &wipeout->imagedefreactor, sizeof (BITCODE_H)))
        pass ();
    else
        fail ("WIPEOUT.imagedefreactor [H]");
  }
  {
    BITCODE_BL num_clip_verts;
    if (dwg_dynapi_entity_value (wipeout, "WIPEOUT", "num_clip_verts", &num_clip_verts, NULL)
        && num_clip_verts == wipeout->num_clip_verts)
      pass ();
    else
      fail ("WIPEOUT.num_clip_verts [BL] %u != %u", wipeout->num_clip_verts, num_clip_verts);
    num_clip_verts++;
    if (dwg_dynapi_entity_set_value (wipeout, "WIPEOUT", "num_clip_verts", &num_clip_verts, 0)
        && num_clip_verts == wipeout->num_clip_verts)
      pass ();
    else
      fail ("WIPEOUT.num_clip_verts [BL] set+1 %u != %u", wipeout->num_clip_verts, num_clip_verts);
    wipeout->num_clip_verts--;
  }
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value (wipeout, "WIPEOUT", "parent", &parent, NULL)
        && !memcmp (&parent, &wipeout->parent, sizeof (struct _dwg_object_entity*)))
        pass ();
    else
        fail ("WIPEOUT.parent [struct _dwg_object_entity*]");
  }
  {
    BITCODE_3BD pt0;
    if (dwg_dynapi_entity_value (wipeout, "WIPEOUT", "pt0", &pt0, NULL)
        && !memcmp (&pt0, &wipeout->pt0, sizeof (BITCODE_3BD)))
        pass ();
    else
        fail ("WIPEOUT.pt0 [3BD]");
  }
  {
    BITCODE_2RD size;
    if (dwg_dynapi_entity_value (wipeout, "WIPEOUT", "size", &size, NULL)
        && !memcmp (&size, &wipeout->size, sizeof (BITCODE_2RD)))
        pass ();
    else
        fail ("WIPEOUT.size [2RD]");
  }
  {
    BITCODE_3BD uvec;
    if (dwg_dynapi_entity_value (wipeout, "WIPEOUT", "uvec", &uvec, NULL)
        && !memcmp (&uvec, &wipeout->uvec, sizeof (BITCODE_3BD)))
        pass ();
    else
        fail ("WIPEOUT.uvec [3BD]");
  }
  {
    BITCODE_3BD vvec;
    if (dwg_dynapi_entity_value (wipeout, "WIPEOUT", "vvec", &vvec, NULL)
        && !memcmp (&vvec, &wipeout->vvec, sizeof (BITCODE_3BD)))
        pass ();
    else
        fail ("WIPEOUT.vvec [3BD]");
  }
  if (failed && (is_class_unstable ("WIPEOUT") || is_class_debugging ("WIPEOUT")))
    {
      ok ("%s failed %d tests (TODO unstable)", "WIPEOUT", failed);
      failed = 0;
    }
  return failed;
}
static int test_XLINE (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_XLINE *restrict xline = obj->tio.entity->tio.XLINE;
  failed = 0;
  if (failed && (is_class_unstable ("XLINE") || is_class_debugging ("XLINE")))
    {
      ok ("%s failed %d tests (TODO unstable)", "XLINE", failed);
      failed = 0;
    }
  return failed;
}
static int test_XYPARAMETERENTITY (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Entity *restrict obj_obj = obj->tio.entity;
  Dwg_Entity_XYPARAMETERENTITY *restrict xyparameterentity = obj->tio.entity->tio.XYPARAMETERENTITY;
  failed = 0;
  {
    struct _dwg_object_entity* parent;
    if (dwg_dynapi_entity_value (xyparameterentity, "XYPARAMETERENTITY", "parent", &parent, NULL)
        && !memcmp (&parent, &xyparameterentity->parent, sizeof (struct _dwg_object_entity*)))
        pass ();
    else
        fail ("XYPARAMETERENTITY.parent [struct _dwg_object_entity*]");
  }
  if (failed && (is_class_unstable ("XYPARAMETERENTITY") || is_class_debugging ("XYPARAMETERENTITY")))
    {
      ok ("%s failed %d tests (TODO unstable)", "XYPARAMETERENTITY", failed);
      failed = 0;
    }
  return failed;
}
static int test_ACMECOMMANDHISTORY (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Object *restrict obj_obj = obj->tio.object;
  Dwg_Object_ACMECOMMANDHISTORY *restrict acmecommandhistory = obj->tio.object->tio.ACMECOMMANDHISTORY;
  failed = 0;
  {
    BITCODE_BS class_version;
    if (dwg_dynapi_entity_value (acmecommandhistory, "ACMECOMMANDHISTORY", "class_version", &class_version, NULL)
        && class_version == acmecommandhistory->class_version)
      pass ();
    else
      fail ("ACMECOMMANDHISTORY.class_version [BS] %hu != %hu", acmecommandhistory->class_version, class_version);
    class_version++;
    if (dwg_dynapi_entity_set_value (acmecommandhistory, "ACMECOMMANDHISTORY", "class_version", &class_version, 0)
        && class_version == acmecommandhistory->class_version)
      pass ();
    else
      fail ("ACMECOMMANDHISTORY.class_version [BS] set+1 %hu != %hu", acmecommandhistory->class_version, class_version);
    acmecommandhistory->class_version--;
  }
  {
    struct _dwg_object_object* parent;
    if (dwg_dynapi_entity_value (acmecommandhistory, "ACMECOMMANDHISTORY", "parent", &parent, NULL)
        && !memcmp (&parent, &acmecommandhistory->parent, sizeof (struct _dwg_object_object*)))
        pass ();
    else
        fail ("ACMECOMMANDHISTORY.parent [struct _dwg_object_object*]");
  }
  if (failed && (is_class_unstable ("ACMECOMMANDHISTORY") || is_class_debugging ("ACMECOMMANDHISTORY")))
    {
      ok ("%s failed %d tests (TODO unstable)", "ACMECOMMANDHISTORY", failed);
      failed = 0;
    }
  return failed;
}
static int test_ACMESCOPE (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Object *restrict obj_obj = obj->tio.object;
  Dwg_Object_ACMESCOPE *restrict acmescope = obj->tio.object->tio.ACMESCOPE;
  failed = 0;
  {
    BITCODE_BS class_version;
    if (dwg_dynapi_entity_value (acmescope, "ACMESCOPE", "class_version", &class_version, NULL)
        && class_version == acmescope->class_version)
      pass ();
    else
      fail ("ACMESCOPE.class_version [BS] %hu != %hu", acmescope->class_version, class_version);
    class_version++;
    if (dwg_dynapi_entity_set_value (acmescope, "ACMESCOPE", "class_version", &class_version, 0)
        && class_version == acmescope->class_version)
      pass ();
    else
      fail ("ACMESCOPE.class_version [BS] set+1 %hu != %hu", acmescope->class_version, class_version);
    acmescope->class_version--;
  }
  {
    struct _dwg_object_object* parent;
    if (dwg_dynapi_entity_value (acmescope, "ACMESCOPE", "parent", &parent, NULL)
        && !memcmp (&parent, &acmescope->parent, sizeof (struct _dwg_object_object*)))
        pass ();
    else
        fail ("ACMESCOPE.parent [struct _dwg_object_object*]");
  }
  if (failed && (is_class_unstable ("ACMESCOPE") || is_class_debugging ("ACMESCOPE")))
    {
      ok ("%s failed %d tests (TODO unstable)", "ACMESCOPE", failed);
      failed = 0;
    }
  return failed;
}
static int test_ACMESTATEMGR (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Object *restrict obj_obj = obj->tio.object;
  Dwg_Object_ACMESTATEMGR *restrict acmestatemgr = obj->tio.object->tio.ACMESTATEMGR;
  failed = 0;
  {
    BITCODE_BS class_version;
    if (dwg_dynapi_entity_value (acmestatemgr, "ACMESTATEMGR", "class_version", &class_version, NULL)
        && class_version == acmestatemgr->class_version)
      pass ();
    else
      fail ("ACMESTATEMGR.class_version [BS] %hu != %hu", acmestatemgr->class_version, class_version);
    class_version++;
    if (dwg_dynapi_entity_set_value (acmestatemgr, "ACMESTATEMGR", "class_version", &class_version, 0)
        && class_version == acmestatemgr->class_version)
      pass ();
    else
      fail ("ACMESTATEMGR.class_version [BS] set+1 %hu != %hu", acmestatemgr->class_version, class_version);
    acmestatemgr->class_version--;
  }
  {
    struct _dwg_object_object* parent;
    if (dwg_dynapi_entity_value (acmestatemgr, "ACMESTATEMGR", "parent", &parent, NULL)
        && !memcmp (&parent, &acmestatemgr->parent, sizeof (struct _dwg_object_object*)))
        pass ();
    else
        fail ("ACMESTATEMGR.parent [struct _dwg_object_object*]");
  }
  if (failed && (is_class_unstable ("ACMESTATEMGR") || is_class_debugging ("ACMESTATEMGR")))
    {
      ok ("%s failed %d tests (TODO unstable)", "ACMESTATEMGR", failed);
      failed = 0;
    }
  return failed;
}
static int test_ACSH_BOOLEAN_CLASS (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Object *restrict obj_obj = obj->tio.object;
  Dwg_Object_ACSH_BOOLEAN_CLASS *restrict acsh_boolean_class = obj->tio.object->tio.ACSH_BOOLEAN_CLASS;
  failed = 0;
  {
    Dwg_EvalExpr evalexpr;
    if (dwg_dynapi_entity_value (acsh_boolean_class, "ACSH_BOOLEAN_CLASS", "evalexpr", &evalexpr, NULL)
        && !memcmp (&evalexpr, &acsh_boolean_class->evalexpr, sizeof (Dwg_EvalExpr)))
        pass ();
    else
        fail ("ACSH_BOOLEAN_CLASS.evalexpr [Dwg_EvalExpr]");
  }
  {
    Dwg_ACSH_HistoryNode history_node;
    if (dwg_dynapi_entity_value (acsh_boolean_class, "ACSH_BOOLEAN_CLASS", "history_node", &history_node, NULL)
        && !memcmp (&history_node, &acsh_boolean_class->history_node, sizeof (Dwg_ACSH_HistoryNode)))
        pass ();
    else
        fail ("ACSH_BOOLEAN_CLASS.history_node [Dwg_ACSH_HistoryNode]");
  }
  {
    BITCODE_BL major;
    if (dwg_dynapi_entity_value (acsh_boolean_class, "ACSH_BOOLEAN_CLASS", "major", &major, NULL)
        && major == acsh_boolean_class->major)
      pass ();
    else
      fail ("ACSH_BOOLEAN_CLASS.major [BL] %u != %u", acsh_boolean_class->major, major);
    major++;
    if (dwg_dynapi_entity_set_value (acsh_boolean_class, "ACSH_BOOLEAN_CLASS", "major", &major, 0)
        && major == acsh_boolean_class->major)
      pass ();
    else
      fail ("ACSH_BOOLEAN_CLASS.major [BL] set+1 %u != %u", acsh_boolean_class->major, major);
    acsh_boolean_class->major--;
  }
  {
    BITCODE_BL minor;
    if (dwg_dynapi_entity_value (acsh_boolean_class, "ACSH_BOOLEAN_CLASS", "minor", &minor, NULL)
        && minor == acsh_boolean_class->minor)
      pass ();
    else
      fail ("ACSH_BOOLEAN_CLASS.minor [BL] %u != %u", acsh_boolean_class->minor, minor);
    minor++;
    if (dwg_dynapi_entity_set_value (acsh_boolean_class, "ACSH_BOOLEAN_CLASS", "minor", &minor, 0)
        && minor == acsh_boolean_class->minor)
      pass ();
    else
      fail ("ACSH_BOOLEAN_CLASS.minor [BL] set+1 %u != %u", acsh_boolean_class->minor, minor);
    acsh_boolean_class->minor--;
  }
  {
    BITCODE_BL operand1;
    if (dwg_dynapi_entity_value (acsh_boolean_class, "ACSH_BOOLEAN_CLASS", "operand1", &operand1, NULL)
        && operand1 == acsh_boolean_class->operand1)
      pass ();
    else
      fail ("ACSH_BOOLEAN_CLASS.operand1 [BL] %u != %u", acsh_boolean_class->operand1, operand1);
    operand1++;
    if (dwg_dynapi_entity_set_value (acsh_boolean_class, "ACSH_BOOLEAN_CLASS", "operand1", &operand1, 0)
        && operand1 == acsh_boolean_class->operand1)
      pass ();
    else
      fail ("ACSH_BOOLEAN_CLASS.operand1 [BL] set+1 %u != %u", acsh_boolean_class->operand1, operand1);
    acsh_boolean_class->operand1--;
  }
  {
    BITCODE_BL operand2;
    if (dwg_dynapi_entity_value (acsh_boolean_class, "ACSH_BOOLEAN_CLASS", "operand2", &operand2, NULL)
        && operand2 == acsh_boolean_class->operand2)
      pass ();
    else
      fail ("ACSH_BOOLEAN_CLASS.operand2 [BL] %u != %u", acsh_boolean_class->operand2, operand2);
    operand2++;
    if (dwg_dynapi_entity_set_value (acsh_boolean_class, "ACSH_BOOLEAN_CLASS", "operand2", &operand2, 0)
        && operand2 == acsh_boolean_class->operand2)
      pass ();
    else
      fail ("ACSH_BOOLEAN_CLASS.operand2 [BL] set+1 %u != %u", acsh_boolean_class->operand2, operand2);
    acsh_boolean_class->operand2--;
  }
  {
    BITCODE_RCd operation;
    if (dwg_dynapi_entity_value (acsh_boolean_class, "ACSH_BOOLEAN_CLASS", "operation", &operation, NULL)
        && operation == acsh_boolean_class->operation)
      pass ();
    else
      fail ("ACSH_BOOLEAN_CLASS.operation [RCd] " FORMAT_RCd " != " FORMAT_RCd "", acsh_boolean_class->operation, operation);
    operation++;
    if (dwg_dynapi_entity_set_value (acsh_boolean_class, "ACSH_BOOLEAN_CLASS", "operation", &operation, 0)
        && operation == acsh_boolean_class->operation)
      pass ();
    else
      fail ("ACSH_BOOLEAN_CLASS.operation [RCd] set+1 " FORMAT_RCd " != " FORMAT_RCd "", acsh_boolean_class->operation, operation);
    acsh_boolean_class->operation--;
  }
  {
    struct _dwg_object_object* parent;
    if (dwg_dynapi_entity_value (acsh_boolean_class, "ACSH_BOOLEAN_CLASS", "parent", &parent, NULL)
        && !memcmp (&parent, &acsh_boolean_class->parent, sizeof (struct _dwg_object_object*)))
        pass ();
    else
        fail ("ACSH_BOOLEAN_CLASS.parent [struct _dwg_object_object*]");
  }
  if (failed && (is_class_unstable ("ACSH_BOOLEAN_CLASS") || is_class_debugging ("ACSH_BOOLEAN_CLASS")))
    {
      ok ("%s failed %d tests (TODO unstable)", "ACSH_BOOLEAN_CLASS", failed);
      failed = 0;
    }
  return failed;
}
static int test_ACSH_BOX_CLASS (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Object *restrict obj_obj = obj->tio.object;
  Dwg_Object_ACSH_BOX_CLASS *restrict acsh_box_class = obj->tio.object->tio.ACSH_BOX_CLASS;
  failed = 0;
  {
    Dwg_EvalExpr evalexpr;
    if (dwg_dynapi_entity_value (acsh_box_class, "ACSH_BOX_CLASS", "evalexpr", &evalexpr, NULL)
        && !memcmp (&evalexpr, &acsh_box_class->evalexpr, sizeof (Dwg_EvalExpr)))
        pass ();
    else
        fail ("ACSH_BOX_CLASS.evalexpr [Dwg_EvalExpr]");
  }
  {
    BITCODE_BD height;
    if (dwg_dynapi_entity_value (acsh_box_class, "ACSH_BOX_CLASS", "height", &height, NULL)
        && height == acsh_box_class->height)
      pass ();
    else
      fail ("ACSH_BOX_CLASS.height [BD] %g != %g", acsh_box_class->height, height);
    height++;
    if (dwg_dynapi_entity_set_value (acsh_box_class, "ACSH_BOX_CLASS", "height", &height, 0)
        && height == acsh_box_class->height)
      pass ();
    else
      fail ("ACSH_BOX_CLASS.height [BD] set+1 %g != %g", acsh_box_class->height, height);
    acsh_box_class->height--;
  }
  {
    Dwg_ACSH_HistoryNode history_node;
    if (dwg_dynapi_entity_value (acsh_box_class, "ACSH_BOX_CLASS", "history_node", &history_node, NULL)
        && !memcmp (&history_node, &acsh_box_class->history_node, sizeof (Dwg_ACSH_HistoryNode)))
        pass ();
    else
        fail ("ACSH_BOX_CLASS.history_node [Dwg_ACSH_HistoryNode]");
  }
  {
    BITCODE_BD length;
    if (dwg_dynapi_entity_value (acsh_box_class, "ACSH_BOX_CLASS", "length", &length, NULL)
        && length == acsh_box_class->length)
      pass ();
    else
      fail ("ACSH_BOX_CLASS.length [BD] %g != %g", acsh_box_class->length, length);
    length++;
    if (dwg_dynapi_entity_set_value (acsh_box_class, "ACSH_BOX_CLASS", "length", &length, 0)
        && length == acsh_box_class->length)
      pass ();
    else
      fail ("ACSH_BOX_CLASS.length [BD] set+1 %g != %g", acsh_box_class->length, length);
    acsh_box_class->length--;
  }
  {
    BITCODE_BL major;
    if (dwg_dynapi_entity_value (acsh_box_class, "ACSH_BOX_CLASS", "major", &major, NULL)
        && major == acsh_box_class->major)
      pass ();
    else
      fail ("ACSH_BOX_CLASS.major [BL] %u != %u", acsh_box_class->major, major);
    major++;
    if (dwg_dynapi_entity_set_value (acsh_box_class, "ACSH_BOX_CLASS", "major", &major, 0)
        && major == acsh_box_class->major)
      pass ();
    else
      fail ("ACSH_BOX_CLASS.major [BL] set+1 %u != %u", acsh_box_class->major, major);
    acsh_box_class->major--;
  }
  {
    BITCODE_BL minor;
    if (dwg_dynapi_entity_value (acsh_box_class, "ACSH_BOX_CLASS", "minor", &minor, NULL)
        && minor == acsh_box_class->minor)
      pass ();
    else
      fail ("ACSH_BOX_CLASS.minor [BL] %u != %u", acsh_box_class->minor, minor);
    minor++;
    if (dwg_dynapi_entity_set_value (acsh_box_class, "ACSH_BOX_CLASS", "minor", &minor, 0)
        && minor == acsh_box_class->minor)
      pass ();
    else
      fail ("ACSH_BOX_CLASS.minor [BL] set+1 %u != %u", acsh_box_class->minor, minor);
    acsh_box_class->minor--;
  }
  {
    struct _dwg_object_object* parent;
    if (dwg_dynapi_entity_value (acsh_box_class, "ACSH_BOX_CLASS", "parent", &parent, NULL)
        && !memcmp (&parent, &acsh_box_class->parent, sizeof (struct _dwg_object_object*)))
        pass ();
    else
        fail ("ACSH_BOX_CLASS.parent [struct _dwg_object_object*]");
  }
  {
    BITCODE_BD width;
    if (dwg_dynapi_entity_value (acsh_box_class, "ACSH_BOX_CLASS", "width", &width, NULL)
        && width == acsh_box_class->width)
      pass ();
    else
      fail ("ACSH_BOX_CLASS.width [BD] %g != %g", acsh_box_class->width, width);
    width++;
    if (dwg_dynapi_entity_set_value (acsh_box_class, "ACSH_BOX_CLASS", "width", &width, 0)
        && width == acsh_box_class->width)
      pass ();
    else
      fail ("ACSH_BOX_CLASS.width [BD] set+1 %g != %g", acsh_box_class->width, width);
    acsh_box_class->width--;
  }
  if (failed && (is_class_unstable ("ACSH_BOX_CLASS") || is_class_debugging ("ACSH_BOX_CLASS")))
    {
      ok ("%s failed %d tests (TODO unstable)", "ACSH_BOX_CLASS", failed);
      failed = 0;
    }
  return failed;
}
static int test_ACSH_BREP_CLASS (const Dwg_Object *obj)
{
  int error = 0;
  const Dwg_Object_Object *restrict obj_obj = obj->tio.object;
  Dwg_Object_ACSH_BREP_CLASS *restrict acsh_brep_class = obj->tio.object->tio.ACSH_BREP_CLASS;
  failed = 0;
  {
    BITCODE_B _dxf_sab_converted;
    if (dwg_dynapi_entity_value (acsh_brep_class, "ACSH_BREP_CLASS", "_dxf_sab_converted", &_dxf_sab_converted, NULL)
        && _dxf_sab_converted == acsh_brep_class->_dxf_sab_converted)
      pass ();
    else
      fail ("ACSH_BREP_CLASS._dxf_sab_converted [B] " FORMAT_B " != " FORMAT_B "", acsh_brep_class->_dxf_sab_converted, _dxf_sab_converted);
    _dxf_sab_converted++;
    if (dwg_dynapi_entity_set_value (acsh_brep_class, "ACSH_BREP_CLASS", "_dxf_sab_converted", &_dxf_sab_converted, 0)
        && _dxf_sab_converted == acsh_brep_class->_dxf_sab_converted)
      pass ();
    else
      fail ("ACSH_BREP_CLASS._dxf_sab_converted [B] set+1 " FORMAT_B " != " FORMAT_B "", acsh_brep_class->_dxf_sab_converted, _dxf_sab_converted);
    acsh_brep_class->_dxf_sab_converted--;
  }
  {
    BITCODE_RC* acis_data;
    if (dwg_dynapi_entity_value (acsh_brep_class, "ACSH_BREP_CLASS", "acis_data", &acis_data, NULL)
        && acis_data
           ? strEQ ((char *)acis_data, (char *)acsh_brep_class->acis_data)
           : !acsh_brep_class->acis_data)
      pass ();
    else
      fail ("ACSH_BREP_CLASS.acis_data [RC*] '%s' <> '%s'", acis_data, acsh_brep_class->acis_data);
  }
  {
    BITCODE_B acis_empty;
    if (dwg_dynapi_entity_value (acsh_brep_class, "ACSH_BREP_CLASS", "acis_empty", &acis_empty, NULL)
        && acis_empty == acsh_brep_class->acis_empty)
      pass ();
    else
      fail ("ACSH_BREP_CLASS.acis_empty [B] " FORMAT_B " != " FORMAT_B "", acsh_brep_class->acis_empty, acis_empty);
    acis_empty++;
    if (dwg_dynapi_entity_set_value (acsh_brep_class, "ACSH_BREP_CLASS", "acis_empty", &acis_empty, 0)
        && acis_empty == acsh_brep_class->acis_empty)
      pass ();
    else
      fail ("ACSH_BREP_CLASS.acis_empty [B] set+1 " FORMAT_B " != " FORMAT_B "", acsh_brep_class->acis_empty, acis_empty);
    acsh_brep_class->acis_empty--;
  }
  {
    BITCODE_B acis_empty2;
    if (dwg_dynapi_entity_value (acsh_brep_class, "ACSH_BREP_CLASS", "acis_empty2", &acis_empty2, NULL)
        && acis_empty2 == acsh_brep_class->acis_empty2)
      pass ();
    else
      fail ("ACSH_BREP_CLASS.acis_empty2 [B] " FORMAT_B " != " FORMAT_B "", acsh_brep_class->acis_empty2, acis_empty2);
    acis_empty2++;
    if (dwg_dynapi_entity_set_value (acsh_brep_class, "ACSH_BREP_CLASS", "acis_empty2", &acis_empty2, 0)
        && acis_empty2 == acsh_brep_class->acis_empty2)
      pass ();
    else
      fail ("ACSH_BREP_CLASS.acis_empty2 [B] set+1 " FORMAT_B " != " FORMAT_B "", acsh_brep_class->acis_empty2, acis_empty2);
    acsh_brep_class->acis_empty2--;
  }
  {
    BITCODE_B acis_empty_bit;
    if (dwg_dynapi_entity_value (acsh_brep_class, "ACSH_BREP_CLASS", "acis_empty_bit", &acis_empty_bit, NULL)
        && acis_empty_bit == acsh_brep_class->acis_empty_bit)
      pass ();
    else
      fail ("ACSH_BREP_CLASS.acis_empty_bit [B] " FORMAT_B " != " FORMAT_B "", acsh_brep_class->acis_empty_bit, acis_empty_bit);
    acis_empty_bit++;
    if (dwg_dynapi_entity_set_value (acsh_brep_class, "ACSH_BREP_CLASS", "acis_empty_bit", &acis_empty_bit, 0)
        && acis_empty_bit == acsh_brep_class->acis_empty_bit)
      pass ();
    else
      fail ("ACSH_BREP_CLASS.acis_empty_bit [B] set+1 " FORMAT_B " != " FORMAT_B "", acsh_brep_class->acis_empty_bit, acis_empty_bit);
    acsh_brep_class->acis_empty_bit--;
  }
  {
    BITCODE_BL* block_size;
    if (dwg_dynapi_entity_value (acsh_brep_class, "ACSH_BREP_CLASS", "block_size", &block_size, NULL)
        && !memcmp (&block_size, &acsh_brep_class->block_size, sizeof (BITCODE_BL*)))
        pass ();
    else
        fail ("ACSH_BREP_CLASS.block_size [BL*]");
  }
  {
    char ** encr_sat_data;
    if (dwg_dynapi_entity_value (acsh_brep_class, "ACSH_BREP_CLASS", "encr_sat_data", &encr_sat_data, NULL)
        && !memcmp (&encr_sat_data, &acsh_brep_class->encr_sat_data, sizeof (acsh_brep_class->encr_sat_data)))
      pass ();
    else
      fail ("ACSH_BREP_CLASS.encr_sat_data [char **]");
  }
  {
    BITCODE_BL end_marker;
    if (dwg_dynapi_entity_value (acsh_brep_class, "ACSH_BREP_CLASS", "end_marker", &end_marker, NULL)
        && end_marker == acsh_brep_class->end_marker)
      pass ();
    else
      fail ("ACSH_BREP_CLASS.end_marker [BL] %u != %u", acsh_brep_class->end_marker, end_marker);
    end_marker++;
    if (dwg_dynapi_entity_set_value (acsh_brep_class, "ACSH_BREP_CLASS", "end_marker", &end_marker, 0)
        && end_marker == acsh_brep_class->end_marker)
      pass ();
    else
      fail ("ACSH_BREP_CLASS.end_marker [BL] set+1 %u != %u", acsh_brep_class->end_marker, end_marker);
    acsh_brep_class->end_marker--;
  }
  {
    Dwg_EvalExpr evalexpr;
    if (dwg_dynapi_entity_value (acsh_brep_class, "ACSH_BREP_CLASS", "evalexpr", &evalexpr, NULL)
        && !memcmp (&evalexpr, &acsh_brep_class->evalexpr, sizeof (Dwg_EvalExpr)))
        pass ();
    else
        fail ("ACSH_BREP_CLASS.evalexpr [Dwg_EvalExpr]");
  }
  {
    struct _dwg_entity_3DSOLID* extra_acis_data;
    if (dwg_dynapi_entity_value (acsh_brep_class, "ACSH_BREP_CLASS", "extra_acis_data", &extra_acis_data, NULL)
        && !memcmp (&extra_acis_data, &acsh_brep_class->extra_acis_data, sizeof (struct _dwg_entity_3DSOLID*)))
        pass ();
    else
        fail ("ACSH_BREP_CLASS.extra_acis_data [struct _dwg_entity_3DSOLID*]");
  }
  {
    BITCODE_B has_revision_guid;
    if (dwg_dynapi_entity_value (acsh_brep_class, "ACSH_BREP_CLASS", "has_revision_guid", &has_revision_guid, NULL)
        && has_revision_guid == acsh_brep_class->has_revision_guid)
      pass ();
    else
      fail ("ACSH_BREP_CLASS.has_revision_guid [B] " FORMAT_B " != " FORMAT_B "", acsh_brep_class->has_revision_guid, has_revision_guid);
    has_revision_guid++;
    if (dwg_dynapi_entity_set_value (acsh_brep_class, "ACSH_BREP_CLASS", "has_revision_guid", &has_revision_guid, 0)
        && has_revision_guid == acsh_brep_class->has_revision_guid)
      pass ();
    else
      fail ("ACSH_BREP_CLASS.has_revision_guid [B] set+1 " FORMAT_B " != " FORMAT_B "", acsh_brep_class->has_revision_guid, has_revision_guid);
    acsh_brep_class->has_revision_guid--;
  }
  {
    BITCODE_H history_id;
    if (dwg_dynapi_entity_value (acsh_brep_class, "ACSH_BREP_CLASS", "history_id", &history_id, NULL)
        && !memcmp (&history_id, &acsh_brep_class->history_id, sizeof (BITCODE_H)))
        pass ();
    else
        fail ("ACSH_BREP_CLASS.history_id [H]");
  }
  {
    Dwg_ACSH_HistoryNode history_node;
    if (dwg_dynapi_entity_value (acsh_brep_class, "ACSH_BREP_CLASS", "history_node", &history_node, NULL)
        && !memcmp (&history_node, &acsh_brep_class->history_node, sizeof (Dwg_ACSH_HistoryNode)))
        pass ();
    else
        fail ("ACSH_BREP_CLASS.history_node [Dwg_ACSH_HistoryNode]");
  }
  {
    BITCODE_B isoline_present;
    if (dwg_dynapi_entity_value (acsh_brep_class, "ACSH_BREP_CLASS", "isoline_present", &isoline_present, NULL)
        && isoline_present == acsh_brep_class->isoline_present)
      pass ();
    else
      fail ("ACSH_BREP_CLASS.isoline_present [B] " FORMAT_B " != " FORMAT_B "", acsh_brep_class->isoline_present, isoline_present);
    isoline_present++;
    if (dwg_dynapi_entity_set_value (acsh_brep_class, "ACSH_BREP_CLASS", "isoline_present", &isoline_present, 0)
        && isoline_present == acsh_brep_class->isoline_present)
      pass ();
    else
      fail ("ACSH_BREP_CLASS.isoline_present [B] set+1 " FORMAT_B " != " FORMAT_B "", acsh_brep_class->isoline_present, isoline_present);
    acsh_brep_class->isoline_present--;
  }
  {
    BITCODE_BL isolines;
    if (dwg_dynapi_entity_value (acsh_brep_class, "ACSH_BREP_CLASS", "isolines", &isolines, NULL)
        && isolines == acsh_brep_class->isolines)
      pass ();
    else
      fail ("ACSH_BREP_CLASS.isolines [BL] %u != %u", acsh_brep_class->isolines, isolines);
    isolines++;
    if (dwg_dynapi_entity_set_value (acsh_brep_class, "ACSH_BREP_CLASS", "isolines", &isolines, 0)
        && isolines == acsh_brep_class->isolines)
      pass ();
    else
      fail ("ACSH_BREP_CLASS.isolines [BL] set+1 %u != %u", acsh_brep_class->isolines, isolines);
    acsh_brep_class->isolines--;
  }
  {
    BITCODE_BL major;
    if (dwg_dynapi_entity_value (acsh_brep_class, "ACSH_BREP_CLASS", "major", &major, NULL)
        && major == acsh_brep_class->major)
      pass ();
    else
      fail ("ACSH_BREP_CLASS.major [BL] %u != %u", acsh_brep_class->major, major);
    major++;
    if (dwg_dynapi_entity_set_value (acsh_brep_class, "ACSH_BREP_CLASS", "major", &major, 0)
        && major == acsh_brep_class->major)
      pass ();
    else
      fail ("ACSH_BREP_CLASS.major [BL] set+1 %u != %u", acsh_brep_class->major, major);
    acsh_brep_class->major--;
  }
  {
    Dwg_3DSOLID_material* materials;
    BITCODE_BL count = 0;
    if (dwg_dynapi_entity_value (acsh_brep_class, "ACSH_BREP_CLASS", "num_materials", &count, NULL)
        && dwg_dynapi_entity_value (acsh_brep_class, "ACSH_BREP_CLASS", "materials", &materials, NULL)
        && materials == acsh_brep_class->materials)
      pass ();
    else
      fail ("ACSH_BREP_CLASS.materials [Dwg_3DSOLID_material*] * %u num_materials", count);
  }
  {
    BITCODE_BL minor;
    if (dwg_dynapi_entity_value (acsh_brep_class, "ACSH_BREP_CLASS", "minor", &minor, NULL)
        && minor == acsh_brep_class->minor)
      pass ();
    else
      fail ("ACSH_BREP_CLASS.minor [BL] %u != %u", acsh_brep_class->minor, minor);
    minor++;
    if (dwg_dynapi_entity_set_value (acsh_brep_class, "ACSH_BREP_CLASS", "minor", &minor, 0)
        && minor == acsh_brep_class->minor)
      pass ();
    else
      fail ("ACSH_BREP_CLASS.minor [BL] set+1 %u != %u", acsh_brep_class->minor, minor);
    acsh_brep_class->minor--;
  }
  {
    BITCODE_BL num_blocks;
    if (dwg_dynapi_entity_value (acsh_brep_class, "ACSH_BREP_CLASS", "num_blocks", &num_blocks, NULL)
        && num_blocks == acsh_brep_class->num_blocks)
      pass ();
    else
      fail ("ACSH_BREP_CLASS.num_blocks [BL] %u != %u", acsh_brep_class->num_blocks, num_blocks);
    num_blocks++;
    if (dwg_dynapi_entity_set_value (acsh_brep_class, "ACSH_BREP_CLASS", "num_blocks", &num_blocks, 0)
        && num_blocks == acsh_brep_class->num_blocks)
      pass ();
    else
      fail ("ACSH_BREP_CLASS.num_blocks [BL] set+1 %u != %u", acsh_brep_class->num_blocks, num_blocks);
    acsh_brep_class->num_blocks--;
  }
  {
    BITCODE_BL num_materials;
    if (dwg_dynapi_entity_value (acsh_brep_class, "ACSH_BREP_CLASS", "num_materials", &num_materials, NULL)
        && num_materials == acsh_brep_class->num_materials)
      pass ();
    else
      fail ("ACSH_BREP_CLASS.num_materials [BL] %u != %u", acsh_brep_class->num_materials, num_materials);
    num_materials++;
    if (dwg_dynapi_entity_set_value (acsh_brep_class, "ACSH_BREP_CLASS", "num_materials", &num_materials, 0)
        && num_materials == acsh_brep_class->num_materials)
      pass ();
    else
      fail ("ACSH_BREP_CLASS.num_materials [BL] set+1 %u != %u", acsh_brep_class->num_materials, num_materials);
    acsh_brep_class->num_materials--;
  }
  {
    BITCODE_BL num_silhouettes;
    if (dwg_dynapi_entity_value (acsh_brep_class, "ACSH_BREP_CLASS", "num_silhouettes", &num_silhouettes, NULL)
        && num_silhouettes == acsh_brep_class->num_silhouettes)
      pass ();
    else
      fail ("ACSH_BREP_CLASS.num_silhouettes [BL] %u != %u", acsh_brep_class->num_silhouettes, num_silhouettes);
    num_silhouettes++;
    if (dwg_dynapi_entity_set_value (acsh_brep_class, "ACSH_BREP_CLASS", "num_silhouettes", &num_silhouettes, 0)
        && num_silhouettes == acsh_brep_class->num_silhouettes)
      pass ();
    else
      fail ("ACSH_BREP_CLASS.num_silhouettes [BL] set+1 %u != %u", acsh_brep_class->num_silhouettes, num_silhouettes);
    acsh_brep_class->num_silhouettes--;
  }
  {
    BITCODE_BL num_wires;
    if (dwg_dynapi_entity_value (acsh_brep_class, "ACSH_BREP_CLASS", "num_wires", &num_wires, NULL)
        && num_wires == acsh_brep_class->num_wires)
      pass ();
    else
      fail ("ACSH_BREP_CLASS.num_wires [BL] %u != %u", acsh_brep_class->num_wires, num_wires);
    num_wires++;
    if (dwg_dynapi_entity_set_value (acsh_brep_class, "ACSH_BREP_CLASS", "num_wires", &num_wires, 0)
        && num_wires == acsh_brep_class->num_wires)
      pass ();
    else
      fail ("ACSH_BREP_CLASS.num_wires [BL] set+1 %u != %u", acsh_brep_class->num_wires, num_wires);
    acsh_brep_class->num_wires--;
  }
  {
    struct _dwg_object_object* parent;
    if (dwg_dynapi_entity_value (acsh_brep_class, "ACSH_BREP_CLASS", "parent", &parent, NULL)
        && !memcmp (&parent, &acsh_brep_class->parent, sizeof (struct _dwg_object_object*)))
        pass ();
    else
        fail ("ACSH_BREP_CLASS.parent [struct _dwg_object_object*]");
  }
  