/* AArch64 tests for GCS.
   Copyright (C) 2025 Free Software Foundation, Inc.
   This file is part of the GNU C Library.

   The GNU C Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   The GNU C Library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with the GNU C Library; if not, see
   <https://www.gnu.org/licenses/>.  */

#include "tst-gcs-helper.h"

int fun1 (void); // tst-gcs-mod1.c
int fun3 (void); // tst-gcs-mod3.c

static int
do_test (void)
{
  /* Check if GCS could possible by enabled.  */
  if (!(getauxval (AT_HWCAP) & HWCAP_GCS))
    {
      puts ("kernel or CPU does not support GCS");
      return EXIT_UNSUPPORTED;
    }
#if TEST_GCS_EXPECT_ENABLED
  TEST_VERIFY (__check_gcs_status ());
#else
  TEST_VERIFY (!__check_gcs_status ());
#endif
  return fun1 () + fun3 ();
}

#include <support/test-driver.c>
