/* Test llround.
   Copyright (C) 1997-2024 Free Software Foundation, Inc.
   This file is part of the GNU C Library.

   The GNU C Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   The GNU C Library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with the GNU C Library; if not, see
   <https://www.gnu.org/licenses/>.  */

#include "libm-test-driver.c"

static const struct test_f_L_data llround_test_data[] =
  {
    /* Bug 6797: errno setting may be missing.  */
    TEST_f_L (llround, plus_infty, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION),
    TEST_f_L (llround, minus_infty, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION),
    TEST_f_L (llround, qnan_value, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION),
    TEST_f_L (llround, -qnan_value, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION),
    TEST_f_L (llround, snan_value, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION),
    TEST_f_L (llround, -snan_value, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION),
    TEST_f_L (llround, max_value, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION),
    TEST_f_L (llround, -max_value, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION),
    TEST_f_L (llround, 0x1p31, 0x80000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_L (llround, 0x1p32, 0x100000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_L (llround, 0x1p33, 0x200000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_L (llround, 0x1p63, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION),
    TEST_f_L (llround, 0x1p64, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION),
    TEST_f_L (llround, 0x1p65, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION),
    TEST_f_L (llround, -0x1p31, -0x80000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_L (llround, -0x1p32, -0x100000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_L (llround, -0x1p33, -0x200000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_L (llround, -0x1p63, LLONG_MIN, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_L (llround, -0x1p64, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION),
    TEST_f_L (llround, -0x1p65, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION),
    TEST_f_L (llround, 0x7fffff80p0, 0x7fffff80LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
#if !TEST_COND_binary32
    TEST_f_L (llround, 0x7fffffffp0, 0x7fffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_L (llround, 0x7fffffff.4p0, 0x7fffffffLL, ERRNO_UNCHANGED),
    TEST_f_L (llround, 0x7fffffff.7ffffcp0, 0x7fffffffLL, ERRNO_UNCHANGED),
    TEST_f_L (llround, 0x7fffffff.8p0, 0x80000000LL, ERRNO_UNCHANGED),
    TEST_f_L (llround, 0x7fffffff.cp0, 0x80000000LL, ERRNO_UNCHANGED),
#endif
#if MANT_DIG >= 64
    TEST_f_L (llround, 0x7fffffff.7fffffff8p0L, 0x7fffffffLL, ERRNO_UNCHANGED),
#endif
#if MANT_DIG >= 106
    TEST_f_L (llround, 0x7fffffff.7fffffffffffffffffep0L, 0x7fffffffLL, ERRNO_UNCHANGED),
#endif
#if MANT_DIG >= 113
    TEST_f_L (llround, 0x7fffffff.7fffffffffffffffffffcp0L, 0x7fffffffLL, ERRNO_UNCHANGED),
#endif
#if !TEST_COND_binary32
    TEST_f_L (llround, -0x80000000.4p0, -0x80000000LL, ERRNO_UNCHANGED),
    TEST_f_L (llround, -0x80000000.7ffff8p0, -0x80000000LL, ERRNO_UNCHANGED),
    TEST_f_L (llround, -0x80000000.8p0, -0x80000001LL, ERRNO_UNCHANGED),
    TEST_f_L (llround, -0x80000000.cp0, -0x80000001LL, ERRNO_UNCHANGED),
    TEST_f_L (llround, -0x80000001p0, -0x80000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
#endif
    TEST_f_L (llround, -0x80000100p0, -0x80000100LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
#if MANT_DIG >= 64
    TEST_f_L (llround, -0x80000000.7fffffffp0L, -0x80000000LL, ERRNO_UNCHANGED),
#endif
#if MANT_DIG >= 106
    TEST_f_L (llround, -0x80000000.7fffffffffffffffffcp0L, -0x80000000LL, ERRNO_UNCHANGED),
#endif
#if MANT_DIG >= 113
    TEST_f_L (llround, -0x80000000.7fffffffffffffffffff8p0L, -0x80000000LL, ERRNO_UNCHANGED),
#endif
    TEST_f_L (llround, 0x7fffff8000000000p0, 0x7fffff8000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
#if !TEST_COND_binary32
    TEST_f_L (llround, 0x7ffffffffffffc00p0, 0x7ffffffffffffc00LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
#endif
#if MANT_DIG >= 64
    TEST_f_L (llround, 0x7fffffffffffffffp0L, 0x7fffffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_L (llround, 0x7fffffffffffffff.8p0L, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION),
# if MANT_DIG > 64
    TEST_f_L (llround, 0x7fffffffffffffff.4p0L, 0x7fffffffffffffffLL, ERRNO_UNCHANGED),
    TEST_f_L (llround, 0x7fffffffffffffff.cp0L, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION),
# endif
# if MANT_DIG >= 106
    TEST_f_L (llround, 0x7fffffffffffffff.7fffffffffep0L, 0x7fffffffffffffffLL, ERRNO_UNCHANGED),
# endif
# if MANT_DIG >= 113
    TEST_f_L (llround, 0x7fffffffffffffff.7fffffffffffcp0L, 0x7fffffffffffffffLL, ERRNO_UNCHANGED),
# endif
#endif
#if MANT_DIG >= 64
    TEST_f_L (llround, -0x8000000000000001p0L, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION),
#endif
#if MANT_DIG >= 106
    TEST_f_L (llround, -0x8000000000000000.4p0L, LLONG_MIN, ERRNO_UNCHANGED),
    TEST_f_L (llround, -0x8000000000000000.7fffffffffcp0L, LLONG_MIN, ERRNO_UNCHANGED),
    TEST_f_L (llround, -0x8000000000000000.8p0L, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION),
    TEST_f_L (llround, -0x8000000000000000.cp0L, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION),
#endif
    TEST_f_L (llround, -0x8000010000000000p0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION),
#if !TEST_COND_binary32
    TEST_f_L (llround, -0x8000000000000800p0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION),
#endif
#if MANT_DIG >= 113
    TEST_f_L (llround, -0x8000000000000000.7fffffffffff8p0L, LLONG_MIN, ERRNO_UNCHANGED),
#endif
    TEST_f_L (llround, 0, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_L (llround, minus_zero, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_L (llround, min_value, 0.0, ERRNO_UNCHANGED),
    TEST_f_L (llround, -min_value, 0, ERRNO_UNCHANGED),
    TEST_f_L (llround, min_subnorm_value, 0.0, ERRNO_UNCHANGED),
    TEST_f_L (llround, -min_subnorm_value, 0, ERRNO_UNCHANGED),
    TEST_f_L (llround, 0.2L, 0.0, ERRNO_UNCHANGED),
    TEST_f_L (llround, -0.2L, 0, ERRNO_UNCHANGED),
    TEST_f_L (llround, 0.5, 1, ERRNO_UNCHANGED),
    TEST_f_L (llround, -0.5, -1, ERRNO_UNCHANGED),
    TEST_f_L (llround, 0.8L, 1, ERRNO_UNCHANGED),
    TEST_f_L (llround, -0.8L, -1, ERRNO_UNCHANGED),
    TEST_f_L (llround, 1.5, 2, ERRNO_UNCHANGED),
    TEST_f_L (llround, -1.5, -2, ERRNO_UNCHANGED),
    TEST_f_L (llround, 22514.5, 22515, ERRNO_UNCHANGED),
    TEST_f_L (llround, -22514.5, -22515, ERRNO_UNCHANGED),
    TEST_f_L (llround, 1071930.0008, 1071930, ERRNO_UNCHANGED),
    TEST_f_L (llround, 2097152.5, 2097153, ERRNO_UNCHANGED),
    TEST_f_L (llround, -2097152.5, -2097153, ERRNO_UNCHANGED),
#if !TEST_COND_binary32
    TEST_f_L (llround, 1073741824.01, 1073741824, ERRNO_UNCHANGED),
    TEST_f_L (llround, 34359738368.5, 34359738369ll, ERRNO_UNCHANGED),
    TEST_f_L (llround, -34359738368.5, -34359738369ll, ERRNO_UNCHANGED),
    TEST_f_L (llround, -3.65309740835E17, -365309740835000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_L (llround, 281474976710656.025, 281474976710656, ERRNO_UNCHANGED),
    TEST_f_L (llround, 18014398509481974, 18014398509481974, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
#endif

    /* Test boundary conditions.  */
    /* 0x1FFFFF */
    TEST_f_L (llround, 2097151.0, 2097151LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    /* 0x800000 */
    TEST_f_L (llround, 8388608.0, 8388608LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    /* 0x1000000 */
    TEST_f_L (llround, 16777216.0, 16777216LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    /* 0x20000000000 */
    TEST_f_L (llround, 2199023255552.0, 2199023255552LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    /* 0x40000000000 */
    TEST_f_L (llround, 4398046511104.0, 4398046511104LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    /* 0x1000000000000 */
    TEST_f_L (llround, 281474976710656.0, 281474976710656LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    /* 0x10000000000000 */
    TEST_f_L (llround, 4503599627370496.0, 4503599627370496LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    /* 0x10000080000000 */
    TEST_f_L (llround, 4503601774854144.0, 4503601774854144LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    /* 0x20000000000000 */
    TEST_f_L (llround, 9007199254740992.0, 9007199254740992LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    /* 0x80000000000000 */
    TEST_f_L (llround, 36028797018963968.0, 36028797018963968LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    /* 0x100000000000000 */
    TEST_f_L (llround, 72057594037927936.0, 72057594037927936LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),

#if !TEST_COND_binary32
    /* 0x100000000 */
    TEST_f_L (llround, 4294967295.5, 4294967296LL, ERRNO_UNCHANGED),
    /* 0x200000000 */
    TEST_f_L (llround, 8589934591.5, 8589934592LL, ERRNO_UNCHANGED),

    /* nextafter(0.5,-1)  */
    TEST_f_L (llround, 0x1.fffffffffffffp-2, 0, ERRNO_UNCHANGED),
    /* nextafter(-0.5,1)  */
    TEST_f_L (llround, -0x1.fffffffffffffp-2, 0, ERRNO_UNCHANGED),
    /* On PowerPC an exponent of '52' is the largest incrementally
     * representable sequence of whole-numbers in the 'double' range.  We test
     * lround to make sure that a guard bit set during the lround operation
     * hasn't forced an erroneous shift giving us an incorrect result.  The odd
     * numbers between +-(2^52+1 and 2^53-1) are affected since they have the
     * rightmost bit set.  */
    /* +-(2^52+1)  */
    TEST_f_L (llround, 0x1.0000000000001p+52, 4503599627370497LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_L (llround, -0x1.0000000000001p+52, -4503599627370497LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    /* +-(2^53-1): Input is the last (positive and negative) incrementally
     * representable whole-number in the 'double' range that might round
     * erroneously.  */
    TEST_f_L (llround, 0x1.fffffffffffffp+52, 9007199254740991LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_L (llround, -0x1.fffffffffffffp+52, -9007199254740991LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
#endif
    TEST_f_L (llround, 0x1.fffffp-2, 0, ERRNO_UNCHANGED),
    /* nextafter(0.5,-1)  */
    TEST_f_L (llround, 0x1.fffffep-2, 0, ERRNO_UNCHANGED),
    TEST_f_L (llround, -0x1.fffffp-2, 0, ERRNO_UNCHANGED),
    /* nextafter(-0.5,1)  */
    TEST_f_L (llround, -0x1.fffffep-2, 0, ERRNO_UNCHANGED),
    TEST_f_L (llround, 0x1.fffffep+23, 16777215, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_L (llround, -0x1.fffffep+23, -16777215, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    /* As above, on PowerPC an exponent of '23' is the largest incrementally
     * representable sequence of whole-numbers in the 'float' range.
     * Likewise, numbers between +-(2^23+1 and 2^24-1) are affected.  */
    TEST_f_L (llround, 0x1.000002p+23, 8388609, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_L (llround, -0x1.000002p+23, -8388609, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_L (llround, 0x1.fffffep+23, 16777215, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_L (llround, -0x1.fffffep+23, -16777215, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),

#if MANT_DIG >= 64
    /* The input can only be represented in long double.  */
    TEST_f_L (llround, 4503599627370495.5L, 4503599627370496LL, ERRNO_UNCHANGED),
    TEST_f_L (llround, 4503599627370496.25L, 4503599627370496LL, ERRNO_UNCHANGED),
    TEST_f_L (llround, 4503599627370496.5L, 4503599627370497LL, ERRNO_UNCHANGED),
    TEST_f_L (llround, 4503599627370496.75L, 4503599627370497LL, ERRNO_UNCHANGED),
    TEST_f_L (llround, 4503599627370497.5L, 4503599627370498LL, ERRNO_UNCHANGED),

# if MANT_DIG > 100
    TEST_f_L (llround, 4503599627370495.4999999999999L, 4503599627370495LL, ERRNO_UNCHANGED),
    TEST_f_L (llround, 4503599627370496.4999999999999L, 4503599627370496LL, ERRNO_UNCHANGED),
    TEST_f_L (llround, 4503599627370497.4999999999999L, 4503599627370497LL, ERRNO_UNCHANGED),
    TEST_f_L (llround, 4503599627370494.5000000000001L, 4503599627370495LL, ERRNO_UNCHANGED),
    TEST_f_L (llround, 4503599627370495.5000000000001L, 4503599627370496LL, ERRNO_UNCHANGED),
    TEST_f_L (llround, 4503599627370496.5000000000001L, 4503599627370497LL, ERRNO_UNCHANGED),

    TEST_f_L (llround, -4503599627370495.4999999999999L, -4503599627370495LL, ERRNO_UNCHANGED),
    TEST_f_L (llround, -4503599627370496.4999999999999L, -4503599627370496LL, ERRNO_UNCHANGED),
    TEST_f_L (llround, -4503599627370497.4999999999999L, -4503599627370497LL, ERRNO_UNCHANGED),
    TEST_f_L (llround, -4503599627370494.5000000000001L, -4503599627370495LL, ERRNO_UNCHANGED),
    TEST_f_L (llround, -4503599627370495.5000000000001L, -4503599627370496LL, ERRNO_UNCHANGED),
    TEST_f_L (llround, -4503599627370496.5000000000001L, -4503599627370497LL, ERRNO_UNCHANGED),
# endif

    TEST_f_L (llround, -4503599627370495.5L, -4503599627370496LL, ERRNO_UNCHANGED),
    TEST_f_L (llround, -4503599627370496.25L, -4503599627370496LL, ERRNO_UNCHANGED),
    TEST_f_L (llround, -4503599627370496.5L, -4503599627370497LL, ERRNO_UNCHANGED),
    TEST_f_L (llround, -4503599627370496.75L, -4503599627370497LL, ERRNO_UNCHANGED),
    TEST_f_L (llround, -4503599627370497.5L, -4503599627370498LL, ERRNO_UNCHANGED),

    TEST_f_L (llround, 9007199254740991.5L, 9007199254740992LL, ERRNO_UNCHANGED),
    TEST_f_L (llround, 9007199254740992.25L, 9007199254740992LL, ERRNO_UNCHANGED),
    TEST_f_L (llround, 9007199254740992.5L, 9007199254740993LL, ERRNO_UNCHANGED),
    TEST_f_L (llround, 9007199254740992.75L, 9007199254740993LL, ERRNO_UNCHANGED),
    TEST_f_L (llround, 9007199254740993.5L, 9007199254740994LL, ERRNO_UNCHANGED),

# if MANT_DIG > 100
    TEST_f_L (llround, 9007199254740991.4999999999999L, 9007199254740991LL, ERRNO_UNCHANGED),
    TEST_f_L (llround, 9007199254740992.4999999999999L, 9007199254740992LL, ERRNO_UNCHANGED),
    TEST_f_L (llround, 9007199254740993.4999999999999L, 9007199254740993LL, ERRNO_UNCHANGED),
    TEST_f_L (llround, 9007199254740991.5000000000001L, 9007199254740992LL, ERRNO_UNCHANGED),
    TEST_f_L (llround, 9007199254740992.5000000000001L, 9007199254740993LL, ERRNO_UNCHANGED),
    TEST_f_L (llround, 9007199254740993.5000000000001L, 9007199254740994LL, ERRNO_UNCHANGED),

    TEST_f_L (llround, -9007199254740991.4999999999999L, -9007199254740991LL, ERRNO_UNCHANGED),
    TEST_f_L (llround, -9007199254740992.4999999999999L, -9007199254740992LL, ERRNO_UNCHANGED),
    TEST_f_L (llround, -9007199254740993.4999999999999L, -9007199254740993LL, ERRNO_UNCHANGED),
    TEST_f_L (llround, -9007199254740991.5000000000001L, -9007199254740992LL, ERRNO_UNCHANGED),
    TEST_f_L (llround, -9007199254740992.5000000000001L, -9007199254740993LL, ERRNO_UNCHANGED),
    TEST_f_L (llround, -9007199254740993.5000000000001L, -9007199254740994LL, ERRNO_UNCHANGED),
# endif

    TEST_f_L (llround, -9007199254740991.5L, -9007199254740992LL, ERRNO_UNCHANGED),
    TEST_f_L (llround, -9007199254740992.25L, -9007199254740992LL, ERRNO_UNCHANGED),
    TEST_f_L (llround, -9007199254740992.5L, -9007199254740993LL, ERRNO_UNCHANGED),
    TEST_f_L (llround, -9007199254740992.75L, -9007199254740993LL, ERRNO_UNCHANGED),
    TEST_f_L (llround, -9007199254740993.5L, -9007199254740994LL, ERRNO_UNCHANGED),

    TEST_f_L (llround, 72057594037927935.5L, 72057594037927936LL, ERRNO_UNCHANGED),
    TEST_f_L (llround, 72057594037927936.25L, 72057594037927936LL, ERRNO_UNCHANGED),
    TEST_f_L (llround, 72057594037927936.5L, 72057594037927937LL, ERRNO_UNCHANGED),
    TEST_f_L (llround, 72057594037927936.75L, 72057594037927937LL, ERRNO_UNCHANGED),
    TEST_f_L (llround, 72057594037927937.5L, 72057594037927938LL, ERRNO_UNCHANGED),

    TEST_f_L (llround, -72057594037927935.5L, -72057594037927936LL, ERRNO_UNCHANGED),
    TEST_f_L (llround, -72057594037927936.25L, -72057594037927936LL, ERRNO_UNCHANGED),
    TEST_f_L (llround, -72057594037927936.5L, -72057594037927937LL, ERRNO_UNCHANGED),
    TEST_f_L (llround, -72057594037927936.75L, -72057594037927937LL, ERRNO_UNCHANGED),
    TEST_f_L (llround, -72057594037927937.5L, -72057594037927938LL, ERRNO_UNCHANGED),

    TEST_f_L (llround, 9223372036854775806.25L, 9223372036854775806LL, ERRNO_UNCHANGED),
    TEST_f_L (llround, -9223372036854775806.25L, -9223372036854775806LL, ERRNO_UNCHANGED),
    TEST_f_L (llround, 9223372036854775806.5L, 9223372036854775807LL, ERRNO_UNCHANGED),
    TEST_f_L (llround, -9223372036854775806.5L, -9223372036854775807LL, ERRNO_UNCHANGED),
    TEST_f_L (llround, 9223372036854775807.0L, 9223372036854775807LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_f_L (llround, -9223372036854775807.0L, -9223372036854775807LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
#endif
  };

static void
llround_test (void)
{
  ALL_RM_TEST (llround, 1, llround_test_data, RUN_TEST_LOOP_f_L, END);
}

static void
do_test (void)
{
  llround_test ();
}

/*
 * Local Variables:
 * mode:c
 * End:
 */
